/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.workflow.statemachine;

import lombok.Generated;
import org.apache.dolphinscheduler.common.enums.WorkflowExecutionStatus;
import org.apache.dolphinscheduler.server.master.engine.WorkflowEventBus;
import org.apache.dolphinscheduler.server.master.engine.graph.IWorkflowExecutionGraph;
import org.apache.dolphinscheduler.server.master.engine.workflow.lifecycle.event.WorkflowFailedLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.workflow.lifecycle.event.WorkflowFinalizeLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.workflow.lifecycle.event.WorkflowPauseLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.workflow.lifecycle.event.WorkflowPausedLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.workflow.lifecycle.event.WorkflowStartLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.workflow.lifecycle.event.WorkflowStopLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.workflow.lifecycle.event.WorkflowStoppedLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.workflow.lifecycle.event.WorkflowSucceedLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.workflow.lifecycle.event.WorkflowTopologyLogicalTransitionWithTaskFinishLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.workflow.runnable.IWorkflowExecutionRunnable;
import org.apache.dolphinscheduler.server.master.engine.workflow.statemachine.AbstractWorkflowStateAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WorkflowReadyStopStateAction
extends AbstractWorkflowStateAction {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkflowReadyStopStateAction.class);

    @Override
    public void onStartEvent(IWorkflowExecutionRunnable workflowExecutionRunnable, WorkflowStartLifecycleEvent workflowStartEvent) {
        this.throwExceptionIfStateIsNotMatch(workflowExecutionRunnable);
        IWorkflowExecutionGraph workflowExecutionGraph = workflowExecutionRunnable.getWorkflowExecuteContext().getWorkflowExecutionGraph();
        this.triggerTasks(workflowExecutionRunnable, workflowExecutionGraph.getStartNodes());
    }

    @Override
    public void onTopologyLogicalTransitionEvent(IWorkflowExecutionRunnable workflowExecutionRunnable, WorkflowTopologyLogicalTransitionWithTaskFinishLifecycleEvent workflowTopologyLogicalTransitionWithTaskFinishEvent) {
        this.throwExceptionIfStateIsNotMatch(workflowExecutionRunnable);
        super.tryToTriggerSuccessorsAfterTaskFinish(workflowExecutionRunnable, workflowTopologyLogicalTransitionWithTaskFinishEvent.getTaskExecutionRunnable());
    }

    @Override
    public void onPauseEvent(IWorkflowExecutionRunnable workflowExecutionRunnable, WorkflowPauseLifecycleEvent workflowPauseEvent) {
        this.throwExceptionIfStateIsNotMatch(workflowExecutionRunnable);
        this.logWarningIfCannotDoAction(workflowExecutionRunnable, workflowPauseEvent);
    }

    @Override
    public void onPausedEvent(IWorkflowExecutionRunnable workflowExecutionRunnable, WorkflowPausedLifecycleEvent workflowPausedEvent) {
        this.throwExceptionIfStateIsNotMatch(workflowExecutionRunnable);
        this.logWarningIfCannotDoAction(workflowExecutionRunnable, workflowPausedEvent);
    }

    @Override
    public void onStopEvent(IWorkflowExecutionRunnable workflowExecutionRunnable, WorkflowStopLifecycleEvent workflowStopEvent) {
        this.throwExceptionIfStateIsNotMatch(workflowExecutionRunnable);
        super.killActiveTask(workflowExecutionRunnable);
    }

    @Override
    public void onStoppedEvent(IWorkflowExecutionRunnable workflowExecutionRunnable, WorkflowStoppedLifecycleEvent workflowStoppedEvent) {
        this.throwExceptionIfStateIsNotMatch(workflowExecutionRunnable);
        super.workflowFinish(workflowExecutionRunnable, WorkflowExecutionStatus.STOP);
    }

    @Override
    public void onSucceedEvent(IWorkflowExecutionRunnable workflowExecutionRunnable, WorkflowSucceedLifecycleEvent workflowSucceedEvent) {
        this.throwExceptionIfStateIsNotMatch(workflowExecutionRunnable);
        super.workflowFinish(workflowExecutionRunnable, WorkflowExecutionStatus.SUCCESS);
    }

    @Override
    public void onFailedEvent(IWorkflowExecutionRunnable workflowExecutionRunnable, WorkflowFailedLifecycleEvent workflowFailedEvent) {
        this.throwExceptionIfStateIsNotMatch(workflowExecutionRunnable);
        super.workflowFinish(workflowExecutionRunnable, WorkflowExecutionStatus.FAILURE);
    }

    @Override
    public void onFinalizeEvent(IWorkflowExecutionRunnable workflowExecutionRunnable, WorkflowFinalizeLifecycleEvent workflowFinalizeEvent) {
        this.throwExceptionIfStateIsNotMatch(workflowExecutionRunnable);
        this.logWarningIfCannotDoAction(workflowExecutionRunnable, workflowFinalizeEvent);
    }

    @Override
    public WorkflowExecutionStatus matchState() {
        return WorkflowExecutionStatus.READY_STOP;
    }

    @Override
    protected void emitWorkflowFinishedEventIfApplicable(IWorkflowExecutionRunnable workflowExecutionRunnable) {
        IWorkflowExecutionGraph workflowExecutionGraph = workflowExecutionRunnable.getWorkflowExecuteContext().getWorkflowExecutionGraph();
        if (!workflowExecutionGraph.isAllTaskExecutionRunnableChainFinish()) {
            log.debug("There exist task which is not finish, don't need to emit workflow finished event");
            return;
        }
        WorkflowEventBus workflowEventBus = workflowExecutionRunnable.getWorkflowEventBus();
        if (workflowExecutionGraph.isExistKilledTaskExecutionRunnableChain()) {
            workflowEventBus.publish(WorkflowStoppedLifecycleEvent.of(workflowExecutionRunnable));
            return;
        }
        if (workflowExecutionGraph.isExistFailureTaskExecutionRunnableChain()) {
            workflowEventBus.publish(WorkflowFailedLifecycleEvent.of(workflowExecutionRunnable));
            return;
        }
        if (workflowExecutionGraph.isAllTaskExecutionRunnableChainSuccess()) {
            workflowEventBus.publish(WorkflowSucceedLifecycleEvent.of(workflowExecutionRunnable));
            return;
        }
        throw new IllegalStateException("The workflow: " + workflowExecutionRunnable.getName() + " state is " + workflowExecutionRunnable.getState() + " can only finish with success/failed/stop but exist task chain which state is not success/failure/kill");
    }
}

