/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.resourcemanager.network.NetworkManager;
import com.azure.resourcemanager.network.fluent.ExpressRouteCircuitPeeringsClient;
import com.azure.resourcemanager.network.fluent.models.ExpressRouteCircuitPeeringInner;
import com.azure.resourcemanager.network.implementation.ExpressRouteCircuitStatsImpl;
import com.azure.resourcemanager.network.models.ExpressRouteCircuitPeering;
import com.azure.resourcemanager.network.models.ExpressRouteCircuitPeeringConfig;
import com.azure.resourcemanager.network.models.ExpressRoutePeeringState;
import com.azure.resourcemanager.network.models.ExpressRoutePeeringType;
import com.azure.resourcemanager.network.models.Ipv6ExpressRouteCircuitPeeringConfig;
import com.azure.resourcemanager.resources.fluentcore.arm.models.GroupableResource;
import com.azure.resourcemanager.resources.fluentcore.model.Refreshable;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.CreatableUpdatableImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import java.util.Arrays;
import reactor.core.publisher.Mono;

class ExpressRouteCircuitPeeringImpl<ParentModelT, ParentInnerT, ParentT extends GroupableResource<NetworkManager, ParentInnerT> & Refreshable<ParentModelT>>
extends CreatableUpdatableImpl<ExpressRouteCircuitPeering, ExpressRouteCircuitPeeringInner, ExpressRouteCircuitPeeringImpl<ParentModelT, ParentInnerT, ParentT>>
implements ExpressRouteCircuitPeering,
ExpressRouteCircuitPeering.Definition,
ExpressRouteCircuitPeering.Update {
    private final ExpressRouteCircuitPeeringsClient client;
    private final ParentT parent;
    private ExpressRouteCircuitStatsImpl stats;

    ExpressRouteCircuitPeeringImpl(ParentT parent, ExpressRouteCircuitPeeringInner innerObject, ExpressRouteCircuitPeeringsClient client, ExpressRoutePeeringType type) {
        super(type.toString(), (Object)innerObject);
        this.client = client;
        this.parent = parent;
        this.stats = new ExpressRouteCircuitStatsImpl(innerObject.stats());
        ((ExpressRouteCircuitPeeringInner)((Object)this.innerModel())).withPeeringType(type);
    }

    @Override
    public ExpressRouteCircuitPeeringImpl<ParentModelT, ParentInnerT, ParentT> withAdvertisedPublicPrefixes(String publicPrefix) {
        this.ensureMicrosoftPeeringConfig().withAdvertisedPublicPrefixes(Arrays.asList(publicPrefix));
        return this;
    }

    private ExpressRouteCircuitPeeringConfig ensureMicrosoftPeeringConfig() {
        if (((ExpressRouteCircuitPeeringInner)((Object)this.innerModel())).microsoftPeeringConfig() == null) {
            ((ExpressRouteCircuitPeeringInner)((Object)this.innerModel())).withMicrosoftPeeringConfig(new ExpressRouteCircuitPeeringConfig());
        }
        return ((ExpressRouteCircuitPeeringInner)((Object)this.innerModel())).microsoftPeeringConfig();
    }

    @Override
    public ExpressRouteCircuitPeeringImpl<ParentModelT, ParentInnerT, ParentT> withPrimaryPeerAddressPrefix(String addressPrefix) {
        ((ExpressRouteCircuitPeeringInner)((Object)this.innerModel())).withPrimaryPeerAddressPrefix(addressPrefix);
        return this;
    }

    @Override
    public ExpressRouteCircuitPeeringImpl<ParentModelT, ParentInnerT, ParentT> withSecondaryPeerAddressPrefix(String addressPrefix) {
        ((ExpressRouteCircuitPeeringInner)((Object)this.innerModel())).withSecondaryPeerAddressPrefix(addressPrefix);
        return this;
    }

    @Override
    public ExpressRouteCircuitPeeringImpl<ParentModelT, ParentInnerT, ParentT> withVlanId(int vlanId) {
        ((ExpressRouteCircuitPeeringInner)((Object)this.innerModel())).withVlanId(vlanId);
        return this;
    }

    @Override
    public ExpressRouteCircuitPeeringImpl<ParentModelT, ParentInnerT, ParentT> withPeerAsn(long peerASN) {
        ((ExpressRouteCircuitPeeringInner)((Object)this.innerModel())).withPeerAsn(peerASN);
        return this;
    }

    protected Mono<ExpressRouteCircuitPeeringInner> getInnerAsync() {
        return this.client.getAsync(this.parent.resourceGroupName(), this.parent.name(), this.name());
    }

    public boolean isInCreateMode() {
        return ((ExpressRouteCircuitPeeringInner)((Object)this.innerModel())).id() == null;
    }

    public Mono<ExpressRouteCircuitPeering> createResourceAsync() {
        return this.client.createOrUpdateAsync(this.parent.resourceGroupName(), this.parent.name(), this.name(), (ExpressRouteCircuitPeeringInner)((Object)this.innerModel())).flatMap(innerModel -> {
            this.setInner(innerModel);
            this.stats = new ExpressRouteCircuitStatsImpl(innerModel.stats());
            return ((Refreshable)this.parent).refreshAsync().then(Mono.just((Object)this));
        });
    }

    public String id() {
        return ((ExpressRouteCircuitPeeringInner)((Object)this.innerModel())).id();
    }

    @Override
    public ExpressRoutePeeringType peeringType() {
        return ((ExpressRouteCircuitPeeringInner)((Object)this.innerModel())).peeringType();
    }

    @Override
    public ExpressRoutePeeringState state() {
        return ((ExpressRouteCircuitPeeringInner)((Object)this.innerModel())).state();
    }

    @Override
    public int azureAsn() {
        return ResourceManagerUtils.toPrimitiveInt((Integer)((ExpressRouteCircuitPeeringInner)((Object)this.innerModel())).azureAsn());
    }

    @Override
    public long peerAsn() {
        return ResourceManagerUtils.toPrimitiveLong((Long)((ExpressRouteCircuitPeeringInner)((Object)this.innerModel())).peerAsn());
    }

    @Override
    public String primaryPeerAddressPrefix() {
        return ((ExpressRouteCircuitPeeringInner)((Object)this.innerModel())).primaryPeerAddressPrefix();
    }

    @Override
    public String secondaryPeerAddressPrefix() {
        return ((ExpressRouteCircuitPeeringInner)((Object)this.innerModel())).secondaryPeerAddressPrefix();
    }

    @Override
    public String primaryAzurePort() {
        return ((ExpressRouteCircuitPeeringInner)((Object)this.innerModel())).primaryAzurePort();
    }

    @Override
    public String secondaryAzurePort() {
        return ((ExpressRouteCircuitPeeringInner)((Object)this.innerModel())).secondaryAzurePort();
    }

    @Override
    public String sharedKey() {
        return ((ExpressRouteCircuitPeeringInner)((Object)this.innerModel())).sharedKey();
    }

    @Override
    public int vlanId() {
        return ResourceManagerUtils.toPrimitiveInt((Integer)((ExpressRouteCircuitPeeringInner)((Object)this.innerModel())).vlanId());
    }

    @Override
    public ExpressRouteCircuitPeeringConfig microsoftPeeringConfig() {
        return ((ExpressRouteCircuitPeeringInner)((Object)this.innerModel())).microsoftPeeringConfig();
    }

    @Override
    public ExpressRouteCircuitStatsImpl stats() {
        return this.stats;
    }

    @Override
    public String provisioningState() {
        return ((ExpressRouteCircuitPeeringInner)((Object)this.innerModel())).provisioningState().toString();
    }

    @Override
    public String lastModifiedBy() {
        return ((ExpressRouteCircuitPeeringInner)((Object)this.innerModel())).lastModifiedBy();
    }

    @Override
    public Ipv6ExpressRouteCircuitPeeringConfig ipv6PeeringConfig() {
        return ((ExpressRouteCircuitPeeringInner)((Object)this.innerModel())).ipv6PeeringConfig();
    }

    public NetworkManager manager() {
        return (NetworkManager)((Object)this.parent.manager());
    }

    public String resourceGroupName() {
        return this.parent.resourceGroupName();
    }
}

