/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.management.Region;
import com.azure.resourcemanager.network.fluent.models.SubnetInner;
import com.azure.resourcemanager.network.models.Network;
import com.azure.resourcemanager.network.models.NetworkSecurityGroup;
import com.azure.resourcemanager.network.models.NicIpConfiguration;
import com.azure.resourcemanager.network.models.RouteTable;
import com.azure.resourcemanager.network.models.ServiceEndpointType;
import com.azure.resourcemanager.resources.fluentcore.arm.models.ChildResource;
import com.azure.resourcemanager.resources.fluentcore.model.Attachable;
import com.azure.resourcemanager.resources.fluentcore.model.HasInnerModel;
import com.azure.resourcemanager.resources.fluentcore.model.Settable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface Subnet
extends HasInnerModel<SubnetInner>,
ChildResource<Network> {
    public Collection<NicIpConfiguration> listNetworkInterfaceIPConfigurations();

    public Set<String> listAvailablePrivateIPAddresses();

    public int networkInterfaceIPConfigurationCount();

    public String addressPrefix();

    public NetworkSecurityGroup getNetworkSecurityGroup();

    public String networkSecurityGroupId();

    public RouteTable getRouteTable();

    public String routeTableId();

    public Map<ServiceEndpointType, List<Region>> servicesWithAccess();

    public String id();

    public static interface UpdateDefinition<ParentT>
    extends UpdateDefinitionStages.Blank<ParentT>,
    UpdateDefinitionStages.WithAddressPrefix<ParentT>,
    UpdateDefinitionStages.WithNetworkSecurityGroup<ParentT>,
    UpdateDefinitionStages.WithAttach<ParentT> {
    }

    public static interface UpdateDefinitionStages {

        public static interface WithAttach<ParentT>
        extends Attachable.InUpdate<ParentT>,
        WithNetworkSecurityGroup<ParentT>,
        WithRouteTable<ParentT>,
        WithDelegation<ParentT>,
        WithServiceEndpoint<ParentT>,
        WithPrivateEndpointNetworkPolicies<ParentT> {
        }

        public static interface WithPrivateEndpointNetworkPolicies<ParentT> {
            public WithAttach<ParentT> disableNetworkPoliciesOnPrivateEndpoint();
        }

        public static interface WithServiceEndpoint<ParentT> {
            public WithAttach<ParentT> withAccessFromService(ServiceEndpointType var1);
        }

        public static interface WithDelegation<ParentT> {
            public WithAttach<ParentT> withDelegation(String var1);
        }

        public static interface WithRouteTable<ParentT> {
            public WithAttach<ParentT> withExistingRouteTable(RouteTable var1);

            public WithAttach<ParentT> withExistingRouteTable(String var1);
        }

        public static interface WithNetworkSecurityGroup<ParentT> {
            public WithAttach<ParentT> withExistingNetworkSecurityGroup(String var1);

            public WithAttach<ParentT> withExistingNetworkSecurityGroup(NetworkSecurityGroup var1);
        }

        public static interface WithAddressPrefix<ParentT> {
            public WithAttach<ParentT> withAddressPrefix(String var1);
        }

        public static interface Blank<ParentT>
        extends WithAddressPrefix<ParentT> {
        }
    }

    public static interface Update
    extends UpdateStages.WithAddressPrefix,
    UpdateStages.WithNetworkSecurityGroup,
    UpdateStages.WithRouteTable,
    UpdateStages.WithDelegation,
    UpdateStages.WithServiceEndpoint,
    UpdateStages.WithPrivateEndpointNetworkPolicies,
    UpdateStages.WithPrivateLinkServiceNetworkPolicies,
    Settable<Network.Update> {
    }

    public static interface UpdateStages {

        public static interface WithPrivateLinkServiceNetworkPolicies {
            public Update enableNetworkPoliciesOnPrivateLinkService();

            public Update disableNetworkPoliciesOnPrivateLinkService();
        }

        public static interface WithPrivateEndpointNetworkPolicies {
            public Update enableNetworkPoliciesOnPrivateEndpoint();

            public Update disableNetworkPoliciesOnPrivateEndpoint();
        }

        public static interface WithServiceEndpoint {
            public Update withAccessFromService(ServiceEndpointType var1);

            public Update withoutAccessFromService(ServiceEndpointType var1);
        }

        public static interface WithDelegation {
            public Update withDelegation(String var1);

            public Update withoutDelegation(String var1);
        }

        public static interface WithRouteTable {
            public Update withExistingRouteTable(RouteTable var1);

            public Update withExistingRouteTable(String var1);

            public Update withoutRouteTable();
        }

        public static interface WithNetworkSecurityGroup {
            public Update withExistingNetworkSecurityGroup(String var1);

            public Update withExistingNetworkSecurityGroup(NetworkSecurityGroup var1);

            public Update withoutNetworkSecurityGroup();
        }

        public static interface WithAddressPrefix {
            public Update withAddressPrefix(String var1);
        }
    }

    public static interface Definition<ParentT>
    extends DefinitionStages.Blank<ParentT>,
    DefinitionStages.WithAddressPrefix<ParentT>,
    DefinitionStages.WithAttach<ParentT> {
    }

    public static interface DefinitionStages {

        public static interface WithAttach<ParentT>
        extends Attachable.InDefinition<ParentT>,
        WithNetworkSecurityGroup<ParentT>,
        WithRouteTable<ParentT>,
        WithDelegation<ParentT>,
        WithServiceEndpoint<ParentT>,
        WithPrivateEndpointNetworkPolicies<ParentT>,
        WithPrivateLinkServiceNetworkPolicies<ParentT> {
        }

        public static interface WithPrivateLinkServiceNetworkPolicies<ParentT> {
            public WithAttach<ParentT> disableNetworkPoliciesOnPrivateLinkService();
        }

        public static interface WithPrivateEndpointNetworkPolicies<ParentT> {
            public WithAttach<ParentT> disableNetworkPoliciesOnPrivateEndpoint();
        }

        public static interface WithServiceEndpoint<ParentT> {
            public WithAttach<ParentT> withAccessFromService(ServiceEndpointType var1);
        }

        public static interface WithDelegation<ParentT> {
            public WithAttach<ParentT> withDelegation(String var1);
        }

        public static interface WithRouteTable<ParentT> {
            public WithAttach<ParentT> withExistingRouteTable(RouteTable var1);

            public WithAttach<ParentT> withExistingRouteTable(String var1);
        }

        public static interface WithNetworkSecurityGroup<ParentT> {
            public WithAttach<ParentT> withExistingNetworkSecurityGroup(String var1);

            public WithAttach<ParentT> withExistingNetworkSecurityGroup(NetworkSecurityGroup var1);
        }

        public static interface WithAddressPrefix<ParentT> {
            public WithAttach<ParentT> withAddressPrefix(String var1);
        }

        public static interface Blank<ParentT>
        extends WithAddressPrefix<ParentT> {
        }
    }
}

