/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1alpha1Overhead;
import io.kubernetes.client.openapi.models.V1alpha1Scheduling;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="RuntimeClassSpec is a specification of a RuntimeClass. It contains parameters that are required to describe the RuntimeClass to the Container Runtime Interface (CRI) implementation, as well as any other components that need to understand how the pod will be run. The RuntimeClassSpec is immutable.")
public class V1alpha1RuntimeClassSpec {
    public static final String SERIALIZED_NAME_OVERHEAD = "overhead";
    @SerializedName(value="overhead")
    private V1alpha1Overhead overhead;
    public static final String SERIALIZED_NAME_RUNTIME_HANDLER = "runtimeHandler";
    @SerializedName(value="runtimeHandler")
    private String runtimeHandler;
    public static final String SERIALIZED_NAME_SCHEDULING = "scheduling";
    @SerializedName(value="scheduling")
    private V1alpha1Scheduling scheduling;

    public V1alpha1RuntimeClassSpec overhead(V1alpha1Overhead overhead) {
        this.overhead = overhead;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1alpha1Overhead getOverhead() {
        return this.overhead;
    }

    public void setOverhead(V1alpha1Overhead overhead) {
        this.overhead = overhead;
    }

    public V1alpha1RuntimeClassSpec runtimeHandler(String runtimeHandler) {
        this.runtimeHandler = runtimeHandler;
        return this;
    }

    @ApiModelProperty(required=true, value="RuntimeHandler specifies the underlying runtime and configuration that the CRI implementation will use to handle pods of this class. The possible values are specific to the node & CRI configuration.  It is assumed that all handlers are available on every node, and handlers of the same name are equivalent on every node. For example, a handler called \"runc\" might specify that the runc OCI runtime (using native Linux containers) will be used to run the containers in a pod. The RuntimeHandler must be lowercase, conform to the DNS Label (RFC 1123) requirements, and is immutable.")
    public String getRuntimeHandler() {
        return this.runtimeHandler;
    }

    public void setRuntimeHandler(String runtimeHandler) {
        this.runtimeHandler = runtimeHandler;
    }

    public V1alpha1RuntimeClassSpec scheduling(V1alpha1Scheduling scheduling) {
        this.scheduling = scheduling;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1alpha1Scheduling getScheduling() {
        return this.scheduling;
    }

    public void setScheduling(V1alpha1Scheduling scheduling) {
        this.scheduling = scheduling;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha1RuntimeClassSpec v1alpha1RuntimeClassSpec = (V1alpha1RuntimeClassSpec)o;
        return Objects.equals(this.overhead, v1alpha1RuntimeClassSpec.overhead) && Objects.equals(this.runtimeHandler, v1alpha1RuntimeClassSpec.runtimeHandler) && Objects.equals(this.scheduling, v1alpha1RuntimeClassSpec.scheduling);
    }

    public int hashCode() {
        return Objects.hash(this.overhead, this.runtimeHandler, this.scheduling);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha1RuntimeClassSpec {\n");
        sb.append("    overhead: ").append(this.toIndentedString(this.overhead)).append("\n");
        sb.append("    runtimeHandler: ").append(this.toIndentedString(this.runtimeHandler)).append("\n");
        sb.append("    scheduling: ").append(this.toIndentedString(this.scheduling)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

