/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.datafactory.DataFactoryManager;
import com.azure.resourcemanager.datafactory.fluent.models.DataFlowResourceInner;
import com.azure.resourcemanager.datafactory.implementation.Utils;
import com.azure.resourcemanager.datafactory.models.DataFlow;
import com.azure.resourcemanager.datafactory.models.DataFlowResource;

public final class DataFlowResourceImpl
implements DataFlowResource,
DataFlowResource.Definition,
DataFlowResource.Update {
    private DataFlowResourceInner innerObject;
    private final DataFactoryManager serviceManager;
    private String resourceGroupName;
    private String factoryName;
    private String dataFlowName;
    private String createIfMatch;
    private String updateIfMatch;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public DataFlow properties() {
        return this.innerModel().properties();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public DataFlowResourceInner innerModel() {
        return this.innerObject;
    }

    private DataFactoryManager manager() {
        return this.serviceManager;
    }

    @Override
    public DataFlowResourceImpl withExistingFactory(String resourceGroupName, String factoryName) {
        this.resourceGroupName = resourceGroupName;
        this.factoryName = factoryName;
        return this;
    }

    @Override
    public DataFlowResource create() {
        this.innerObject = (DataFlowResourceInner)((Object)this.serviceManager.serviceClient().getDataFlows().createOrUpdateWithResponse(this.resourceGroupName, this.factoryName, this.dataFlowName, this.innerModel(), this.createIfMatch, Context.NONE).getValue());
        return this;
    }

    @Override
    public DataFlowResource create(Context context) {
        this.innerObject = (DataFlowResourceInner)((Object)this.serviceManager.serviceClient().getDataFlows().createOrUpdateWithResponse(this.resourceGroupName, this.factoryName, this.dataFlowName, this.innerModel(), this.createIfMatch, context).getValue());
        return this;
    }

    DataFlowResourceImpl(String name, DataFactoryManager serviceManager) {
        this.innerObject = new DataFlowResourceInner();
        this.serviceManager = serviceManager;
        this.dataFlowName = name;
        this.createIfMatch = null;
    }

    @Override
    public DataFlowResourceImpl update() {
        this.updateIfMatch = null;
        return this;
    }

    @Override
    public DataFlowResource apply() {
        this.innerObject = (DataFlowResourceInner)((Object)this.serviceManager.serviceClient().getDataFlows().createOrUpdateWithResponse(this.resourceGroupName, this.factoryName, this.dataFlowName, this.innerModel(), this.updateIfMatch, Context.NONE).getValue());
        return this;
    }

    @Override
    public DataFlowResource apply(Context context) {
        this.innerObject = (DataFlowResourceInner)((Object)this.serviceManager.serviceClient().getDataFlows().createOrUpdateWithResponse(this.resourceGroupName, this.factoryName, this.dataFlowName, this.innerModel(), this.updateIfMatch, context).getValue());
        return this;
    }

    DataFlowResourceImpl(DataFlowResourceInner innerObject, DataFactoryManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = Utils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.factoryName = Utils.getValueFromIdByName(innerObject.id(), "factories");
        this.dataFlowName = Utils.getValueFromIdByName(innerObject.id(), "dataflows");
    }

    @Override
    public DataFlowResource refresh() {
        String localIfNoneMatch = null;
        this.innerObject = (DataFlowResourceInner)((Object)this.serviceManager.serviceClient().getDataFlows().getWithResponse(this.resourceGroupName, this.factoryName, this.dataFlowName, localIfNoneMatch, Context.NONE).getValue());
        return this;
    }

    @Override
    public DataFlowResource refresh(Context context) {
        String localIfNoneMatch = null;
        this.innerObject = (DataFlowResourceInner)((Object)this.serviceManager.serviceClient().getDataFlows().getWithResponse(this.resourceGroupName, this.factoryName, this.dataFlowName, localIfNoneMatch, context).getValue());
        return this;
    }

    @Override
    public DataFlowResourceImpl withProperties(DataFlow properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    @Override
    public DataFlowResourceImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

