/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.config;

import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public interface IPropertyDelegate {
    public String get(String var1);

    public String get(String var1, String var2);

    public Set<String> getPropertyKeys();

    default public Optional<String> getOptional(String key) {
        return this.getOptional(key, Function.identity());
    }

    default public Integer getInt(String key) {
        return this.get(key, Integer::parseInt);
    }

    default public Integer getInt(String key, Integer defaultValue) {
        return this.get(key, Integer::parseInt, defaultValue);
    }

    default public Long getLong(String key) {
        return this.get(key, Long::parseLong);
    }

    default public Long getLong(String key, Long defaultValue) {
        return this.get(key, Long::parseLong, defaultValue);
    }

    default public Double getDouble(String key) {
        return this.get(key, Double::parseDouble);
    }

    default public Double getDouble(String key, Double defaultValue) {
        return this.get(key, Double::parseDouble, defaultValue);
    }

    default public Boolean getBoolean(String key) {
        return this.get(key, Boolean::parseBoolean);
    }

    default public Boolean getBoolean(String key, Boolean defaultValue) {
        return this.get(key, Boolean::parseBoolean, defaultValue);
    }

    default public <T> T get(String key, Function<String, T> transformFunction) {
        String value = this.get(key);
        if (value == null) {
            return null;
        }
        return transformFunction.apply(value);
    }

    default public <T> T get(String key, Function<String, T> transformFunction, T defaultValue) {
        String value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return transformFunction.apply(value);
        }
        catch (Exception ignored) {
            return defaultValue;
        }
    }

    default public <T> Optional<T> getOptional(String key, Function<String, T> transformFunction) {
        return Optional.ofNullable(this.get(key, transformFunction));
    }
}

