/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerregistry.models.ProvisioningState;
import com.azure.resourcemanager.containerregistry.models.WebhookAction;
import com.azure.resourcemanager.containerregistry.models.WebhookStatus;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class WebhookProperties {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(WebhookProperties.class);
    @JsonProperty(value="status")
    private WebhookStatus status;
    @JsonProperty(value="scope")
    private String scope;
    @JsonProperty(value="actions", required=true)
    private List<WebhookAction> actions;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    public WebhookStatus status() {
        return this.status;
    }

    public WebhookProperties withStatus(WebhookStatus status) {
        this.status = status;
        return this;
    }

    public String scope() {
        return this.scope;
    }

    public WebhookProperties withScope(String scope) {
        this.scope = scope;
        return this;
    }

    public List<WebhookAction> actions() {
        return this.actions;
    }

    public WebhookProperties withActions(List<WebhookAction> actions) {
        this.actions = actions;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.actions() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property actions in model WebhookProperties"));
        }
    }
}

