/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.EnvironmentParameterRanges;
import com.amazonaws.services.sagemaker.model.ProductionVariantInstanceType;
import com.amazonaws.services.sagemaker.model.transform.EndpointInputConfigurationMarshaller;
import java.io.Serializable;

public class EndpointInputConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String instanceType;
    private String inferenceSpecificationName;
    private EnvironmentParameterRanges environmentParameterRanges;

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public EndpointInputConfiguration withInstanceType(String instanceType) {
        this.setInstanceType(instanceType);
        return this;
    }

    public EndpointInputConfiguration withInstanceType(ProductionVariantInstanceType instanceType) {
        this.instanceType = instanceType.toString();
        return this;
    }

    public void setInferenceSpecificationName(String inferenceSpecificationName) {
        this.inferenceSpecificationName = inferenceSpecificationName;
    }

    public String getInferenceSpecificationName() {
        return this.inferenceSpecificationName;
    }

    public EndpointInputConfiguration withInferenceSpecificationName(String inferenceSpecificationName) {
        this.setInferenceSpecificationName(inferenceSpecificationName);
        return this;
    }

    public void setEnvironmentParameterRanges(EnvironmentParameterRanges environmentParameterRanges) {
        this.environmentParameterRanges = environmentParameterRanges;
    }

    public EnvironmentParameterRanges getEnvironmentParameterRanges() {
        return this.environmentParameterRanges;
    }

    public EndpointInputConfiguration withEnvironmentParameterRanges(EnvironmentParameterRanges environmentParameterRanges) {
        this.setEnvironmentParameterRanges(environmentParameterRanges);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInstanceType() != null) {
            sb.append("InstanceType: ").append(this.getInstanceType()).append(",");
        }
        if (this.getInferenceSpecificationName() != null) {
            sb.append("InferenceSpecificationName: ").append(this.getInferenceSpecificationName()).append(",");
        }
        if (this.getEnvironmentParameterRanges() != null) {
            sb.append("EnvironmentParameterRanges: ").append(this.getEnvironmentParameterRanges());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointInputConfiguration)) {
            return false;
        }
        EndpointInputConfiguration other = (EndpointInputConfiguration)obj;
        if (other.getInstanceType() == null ^ this.getInstanceType() == null) {
            return false;
        }
        if (other.getInstanceType() != null && !other.getInstanceType().equals(this.getInstanceType())) {
            return false;
        }
        if (other.getInferenceSpecificationName() == null ^ this.getInferenceSpecificationName() == null) {
            return false;
        }
        if (other.getInferenceSpecificationName() != null && !other.getInferenceSpecificationName().equals(this.getInferenceSpecificationName())) {
            return false;
        }
        if (other.getEnvironmentParameterRanges() == null ^ this.getEnvironmentParameterRanges() == null) {
            return false;
        }
        return other.getEnvironmentParameterRanges() == null || other.getEnvironmentParameterRanges().equals(this.getEnvironmentParameterRanges());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstanceType() == null ? 0 : this.getInstanceType().hashCode());
        hashCode = 31 * hashCode + (this.getInferenceSpecificationName() == null ? 0 : this.getInferenceSpecificationName().hashCode());
        hashCode = 31 * hashCode + (this.getEnvironmentParameterRanges() == null ? 0 : this.getEnvironmentParameterRanges().hashCode());
        return hashCode;
    }

    public EndpointInputConfiguration clone() {
        try {
            return (EndpointInputConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EndpointInputConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

