/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.tools.lineage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.entity.WorkflowTaskLineage;
import org.apache.dolphinscheduler.dao.mapper.TaskDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.WorkflowTaskRelationMapper;
import org.apache.dolphinscheduler.dao.repository.WorkflowTaskLineageDao;
import org.apache.dolphinscheduler.plugin.task.api.model.DependentItem;
import org.apache.dolphinscheduler.plugin.task.api.model.DependentTaskModel;
import org.apache.dolphinscheduler.plugin.task.api.parameters.DependentParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MigrateLineageService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MigrateLineageService.class);
    @Autowired
    private TaskDefinitionMapper taskDefinitionMapper;
    @Autowired
    private WorkflowTaskLineageDao workflowTaskLineageDao;
    @Autowired
    private WorkflowTaskRelationMapper workflowTaskRelationMapper;

    public void migrateLineageOnce() {
        try {
            List<WorkflowTaskLineage> workflowTaskLineageList = this.getAllProcessLineages();
            int insertResult = this.workflowTaskLineageDao.batchInsert(workflowTaskLineageList);
            if (insertResult > 0) {
                log.info("Migrate lineage successfully, insert count: {}", (Object)insertResult);
            } else {
                log.info("No lineage to migrate.");
            }
        }
        catch (Exception e) {
            log.error("Failed to migrate lineage:", (Throwable)e);
        }
    }

    private List<WorkflowTaskLineage> getAllProcessLineages() {
        List taskDefinitionList = this.taskDefinitionMapper.queryDefinitionsByTaskType("DEPENDENT");
        List workflowTaskRelationList = this.workflowTaskRelationMapper.queryByTaskCodes((Long[])taskDefinitionList.stream().map(TaskDefinition::getCode).toArray(Long[]::new));
        ArrayList<WorkflowTaskLineage> workflowTaskLineageList = new ArrayList<WorkflowTaskLineage>();
        for (TaskDefinition taskDefinition : taskDefinitionList) {
            this.parseDependentTaskParams(taskDefinition, workflowTaskLineageList);
            for (WorkflowTaskLineage workflowTaskLineage : workflowTaskLineageList) {
                workflowTaskRelationList.stream().filter(processTaskRelation -> processTaskRelation.getPreTaskCode() == taskDefinition.getCode() || processTaskRelation.getPostTaskCode() == taskDefinition.getCode()).findFirst().ifPresent(processTaskRelation -> {
                    workflowTaskLineage.setWorkflowDefinitionCode(processTaskRelation.getWorkflowDefinitionCode());
                    workflowTaskLineage.setWorkflowDefinitionVersion(processTaskRelation.getWorkflowDefinitionVersion());
                });
            }
        }
        return workflowTaskLineageList;
    }

    private void parseDependentTaskParams(TaskDefinition taskDefinition, List<WorkflowTaskLineage> taskLineageList) {
        List dependTaskList;
        DependentParameters dependentParameters = (DependentParameters)JSONUtils.parseObject((String)taskDefinition.getTaskParams(), DependentParameters.class);
        if (dependentParameters != null && !CollectionUtils.isEmpty((Collection)(dependTaskList = dependentParameters.getDependence().getDependTaskList()))) {
            for (DependentTaskModel taskModel : dependTaskList) {
                List dependItemList = taskModel.getDependItemList();
                for (DependentItem dependentItem : dependItemList) {
                    WorkflowTaskLineage workflowTaskLineage = new WorkflowTaskLineage();
                    workflowTaskLineage.setDeptProjectCode(dependentItem.getProjectCode());
                    workflowTaskLineage.setDeptWorkflowDefinitionCode(dependentItem.getDefinitionCode());
                    workflowTaskLineage.setDeptTaskDefinitionCode(dependentItem.getDepTaskCode());
                    taskLineageList.add(workflowTaskLineage);
                }
            }
        }
    }
}

