/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.Handlers;
import io.fabric8.kubernetes.client.InternalExtensionAdapter;
import io.fabric8.kubernetes.client.ResourcedHasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.base.ResourceDefinitionContext;
import io.fabric8.kubernetes.client.dsl.internal.HasMetadataOperationsImpl;
import io.fabric8.kubernetes.client.extension.ClientAdapter;
import io.fabric8.kubernetes.client.extension.ExtensibleResourceAdapter;
import io.fabric8.kubernetes.client.extension.ExtensionAdapter;
import io.fabric8.kubernetes.client.utils.KubernetesResourceUtil;
import java.util.Collections;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class Adapters {
    private final Set<ClassLoader> classLoaders = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<Class<?>, ExtensionAdapter<?>> extensionAdapters = new ConcurrentHashMap();
    private final Handlers handlers;

    public Adapters(Handlers handlers) {
        this.handlers = handlers;
        this.discoverServices(Adapters.class.getClassLoader());
        this.discoverServices(Thread.currentThread().getContextClassLoader());
    }

    public <T extends Client, C extends ClientAdapter<C>> void registerClient(final Class<T> type, final ClientAdapter<C> target) {
        if (!type.isAssignableFrom(target.getClass())) {
            throw new IllegalArgumentException("The adapter should implement the type");
        }
        if (target.getClient() != null) {
            throw new IllegalArgumentException("The client adapter should already be initialized");
        }
        ExtensionAdapter adapter = new ExtensionAdapter<C>(){

            public Class getExtensionType() {
                return type;
            }

            public C adapt(Client client) {
                ClientAdapter result = target.newInstance();
                result.init(client);
                return result;
            }
        };
        this.extensionAdapters.put(type, adapter);
        this.extensionAdapters.put(target.getClass(), adapter);
    }

    public <C extends Client> void register(ExtensionAdapter<C> adapter) {
        if (this.extensionAdapters.putIfAbsent(adapter.getExtensionType(), adapter) == null) {
            adapter.registerResources(this::registerResource);
            adapter.registerClients(this::registerClient);
            if (adapter instanceof InternalExtensionAdapter) {
                ((InternalExtensionAdapter)adapter).registerHandlers(this.handlers);
            }
        }
    }

    public <C extends Client> void unregister(ExtensionAdapter<C> adapter) {
        this.extensionAdapters.remove(adapter.getExtensionType());
    }

    public <C extends Client> ExtensionAdapter<C> get(Class<C> type) {
        this.discoverServices(type.getClassLoader());
        return this.extensionAdapters.get(type);
    }

    private void discoverServices(ClassLoader classLoader) {
        if (classLoader != null && this.classLoaders.add(classLoader)) {
            for (ExtensionAdapter adapter : ServiceLoader.load(ExtensionAdapter.class, classLoader)) {
                this.register(adapter);
            }
        }
    }

    public <T extends HasMetadata, R extends ExtensibleResourceAdapter<T>> void registerResource(Class<T> type, R target) {
        ResourceDefinitionContext definitionContest = ResourceDefinitionContext.fromResourceType(type);
        Class listType = KubernetesResourceUtil.inferListType(type);
        this.handlers.register(type, c -> new ResourcedHasMetadataOperation(HasMetadataOperationsImpl.defaultContext(c), definitionContest, type, listType, target));
    }
}

