// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.
suite("test_key_topn", "p0") {

    sql """ set topn_opt_limit_threshold = 1024; """
    sql """ set enable_two_phase_read_opt = 1; """

    sql """
        drop table if exists `test_key_topn`;
    """

    sql """
        CREATE TABLE `test_key_topn` (
            `c1` BIGINT NULL,
            `c2` BIGINT NULL,
            `c3` INT NULL
        ) ENGINE=OLAP
        DUPLICATE KEY(`c1`, `c2`, `c3`)
        COMMENT 'OLAP'
        DISTRIBUTED BY HASH(`c3`) BUCKETS 10
        PROPERTIES("replication_num" = "1");
    """

    sql """
        INSERT INTO test_key_topn(c3,c1,c2) VALUES (0,-8,-140632),(1,6400896,null),(2,-17129,19576),(3,-114,-8367860),(4,18583,-30),(5,null,24605),(6,-16288,5457699124954153990),(7,null,-2324180),(8,97,7223589),(9,-5257668201870192722,-9315),(10,-5500234776311337555,889748246483125914),(11,2936629,null),(12,5209683942987364396,-11834),(13,-85,null),(14,6630530972987800192,1126696919469584977),(15,7870120482580890039,-3952227040791679072),(16,12488,-3244574625629861581),(17,-4637167646579623871,1843644491525337169),(18,-24784,null),(19,-45,-4938988153672078385),(20,-69,3956930198957892804),(21,2542445,-62006),(22,4901657155358112559,73),(23,5669679583552760671,null),(24,1429146,3233817),(25,8018649021639087959,null),(26,-3050,5883238013207034310),(27,4216309787801274221,-5826110629710535006),(28,-9452,-118),(29,1920,-1456869058228849664),(30,-24796,1059786285500070322),(31,-4588962374942520730,170485),(32,-20764,6577998),(33,-81,6210138687355973079),(34,null,null),(35,7546037797146483900,-53),(36,null,29641),(37,-756339841863854604,-9),(38,-15745,-35466828330345475),(39,6755248204758160804,-53),(40,null,7),(41,6106151195780750662,165074),(42,4338441591219673575,27787),(43,null,5039499422240074343),(44,-2614385650879950978,-3912223),(45,8476013011959691437,15635),(46,-1729972,6183922),(47,82,null),(48,66,-83),(49,-1812758552566415927,-3992933685920140816),(50,11128,4749239667530955403),(51,4780603973779442791,-25820),(52,-5112391373869827311,-1159298993397656849),(53,31031,-43),(54,-2940815403865512293,-32597),(55,3712012,7085088191966131982),(56,-9684,-6287923),(57,null,31497),(58,-27233,51),(59,9203,-11645),(60,null,25797),(61,2911882,3347),(62,4977055474041840341,-28),(63,21,8708084501151599566),(64,5539129,-8119070891149332986),(65,null,2645413),(66,1113403177669511677,null),(67,null,-5913397206563296444),(68,-3480665874512066912,-6293667860260560352),(69,-110,null),(70,7266705,5324813),(71,-5030400810544887139,2540),(72,128,-29905),(73,94,-29),(74,null,6965268),(75,-8316410171101509062,2545461205316728320),(76,676368,7071448499379601863),(77,7383956316729621607,15589),(78,-584963,-8681),(79,97,2),(80,-8805787449299901621,-6336997043931428791),(81,2601875,6186600),(82,-3524856932031027068,28354),(83,5979546193407797279,-7111971897557974326),(84,6449,-397714952335076294),(85,null,81),(86,6571515,4026066283886543687),(87,-6811757049162898768,null),(88,null,-92),(89,-6169670,-5957866559850069543),(90,-9112492460996557976,11010),(91,7240920095889764286,null),(92,-128,null),(93,-6702618,-4366224701561519180),(94,-5206619536744853102,3660),(95,null,null),(96,-8173394,-29373),(97,84,-31654),(98,-1773116,null),(99,908,-7445066589834490914),(100,-65,null),(101,-57,-17686),(102,89,126),(103,-1845042,-31792),(104,-13979,-29),(105,null,111),(106,-24385,7853968),(107,18330,-57),(108,64,null),(109,-3419436555601587570,-4441976890610034242),(110,-6934059,-45),(111,-114,-20074),(112,null,571059),(113,-21,-2901952552651948588),(114,19616,-20),(115,-70,-2144847046568893237),(116,-8141512,1751635820313304332),(117,30281,6215111458105370739),(118,3618688,-48),(119,885732,28229),(120,1388487368591474980,-3594183018920498753),(121,-141044,3787940),(122,-7045,-4593829016467871383),(123,-312857701762444619,null),(124,-26269,-565354876190644332),(125,7900584769496689086,null),(126,null,null),(127,-2212,-3799536854819040178),(128,7213773,null),(129,-75,2),(130,18616,9220265239834618671),(131,785071,-5692631673008010918),(132,-4,23869),(133,1292137,199536971854240445),(134,8913311250741174688,-22),(135,60526523359526450,-1666450386823034112),(136,-8568671508968812182,-2952902325530209668),(137,-95,-91),(138,2239120913530861888,327443),(139,null,5473971),(140,-22,-32),(141,6962111,3451149),(142,-8597110388149732177,7903911098879534409),(143,408080,-6),(144,5493184,7313081748114964744),(145,26,27043),(146,5971982601110114648,-8259954790876933885),(147,1232094012207158499,4021379650008438484),(148,2012089,-6771),(149,3074396150366467814,-1333708),(150,2848905,3988569670304459997),(151,-68,null),(152,-2201316426461530399,119),(153,-1183053556135656734,6681276838157774806),(154,-905483424105599954,4107090),(155,null,-1223150373684941391),(156,7356712,114),(157,-995348783360866397,40),(158,100,-2208895000768156396),(159,-1955,7182712264475462896),(160,949862460376616119,-11603),(161,1229004765105765478,-8417916963906793409),(162,-8937734395555642162,-20748),(163,8200433301118607648,1067270148657938075),(164,71,-3166321),(165,21,-315967),(166,null,7155817580828310151),(167,453,7857462057573205429),(168,-3685140687619181221,null),(169,8479065183234591891,6596928),(170,92,10394),(171,-8771677204595036706,-22260),(172,115,-46),(173,106,1955),(174,-449,22081),(175,-7395098278783133707,null),(176,27153,-7259324267827048780),(177,103,null),(178,null,5173912643881578650),(179,-5366104,60),(180,1172462,1777009989836159679),(181,-3594396,70355),(182,null,24841),(183,3905624,null),(184,null,-6458061),(185,-9186970781027415989,119539360136642628),(186,2283391868007299912,null),(187,2064167,111),(188,-121,21503),(189,2897141,-102),(190,67,126),(191,739,-9069768653427984414),(192,36,-901287943919400552),(193,50,7432108476894790473),(194,-3847259062990595829,2603107577892905640),(195,-233591,29349),(196,-604583323016038235,-95),(197,-5229872,2396219373885851535),(198,9054253762649507453,16159),(199,-7793287,-6153263215308491724),(200,-829107000699133193,-14575),(201,-6496,null),(202,3586619903801881234,59),(203,null,-4845988),(204,null,-2261946034016713501),(205,373373,null),(206,34,2517686945256044748),(207,-9236,-6471533),(208,4280,null),(209,26,84),(210,null,3391414626596984002),(211,null,-6655556266136937429),(212,-2986988282791131464,-3666045924707812652),(213,null,2396),(214,-17,-24053),(215,7198296,-20040),(216,-3030423332868415168,-41),(217,-7321261,910431075538527454),(218,-14240,-2271023606008991114),(219,null,null),(220,6982524945412913726,-9137494628484296669),(221,-21625,-12),(222,-27524,-16752),(223,17077,105),(224,1484866029412176608,-94),(225,7202541968368139243,2717160275660329836),(226,22557,8701689750144014741),(227,null,-9373),(228,null,121),(229,null,113),(230,685098,-4304574541928640299),(231,4336691335984621107,-5355392419092963503),(232,-7259159482417078695,-7908085),(233,-90,-1133982684597927986),(234,85,8168010),(235,3545543,-30),(236,29149,-2838692423908235527),(237,31652,12),(238,2166761965582701558,-126),(239,-21674,8794885817553870759),(240,-5084,-6909434851903243196),(241,null,-7985992),(242,null,2631855873937005105),(243,7731139723961605708,-8779304366648716382),(244,7261383,37),(245,-1195072,-3013),(246,null,null),(247,1941384191528559491,26),(248,-2440256119434407790,8281061),(249,null,null),(250,6605463958024301090,4866946726011143610),(251,-8041664746396034842,null),(252,-2555996,7406),(253,5842126,-7109943),(254,427509324607895075,null),(255,-50,-16082),(256,17663,-2336041),(257,-19039,3687168568989747455),(258,-56,122),(259,114,-14003),(260,6285365791681420811,-2820704058402845201),(261,-4782700320889606621,7344074344437182673),(262,null,223352803401068620),(263,495705632856632807,-5924),(264,null,-1773208950706953599),(265,4230934290323233290,-6307544276153615977),(266,105,2408359330903668781),(267,-2869178,3664770045867797953),(268,-8364866066060888824,27),(269,8205719,-3387448879111152631),(270,null,117),(271,-7302085,-7910246878436906735),(272,-4141866309188870822,-11938),(273,-32,-6184369446300461213),(274,-2251117,-2095),(275,121,89),(276,13953,19617),(277,null,22645),(278,-1969401,-8189),(279,-7665151261733372389,-35),(280,5374254,3965927019313775464),(281,-2557157,null),(282,-7848296590980317966,-6255978448805703094),(283,null,1626683),(284,null,8966818862789997799),(285,2215968684158631321,null),(286,7856182,3543286463713710390),(287,-5728600097999898466,322508),(288,24313,null),(289,-35,null),(290,-8043947,55),(291,-5038167992153484831,-11998),(292,32744,-81),(293,-23629,-616230204978280449),(294,4261018,null),(295,15617,54),(296,29830,1710682711511892666),(297,null,3125),(298,null,4693346919643228401),(299,-66,18973),(300,64675146431342265,1566866551475802311),(301,-4179127522708872578,25008),(302,1879203758131163259,null),(303,5774620781009688393,1563282),(304,7662529,8131233881790010036),(305,null,95),(306,2710607082654134234,null),(307,1323840,null),(308,1157526790593334263,-6164),(309,-6602743475472654826,-8204),(310,6196484340281484691,-7304385082398638985),(311,2325144,null),(312,-2229618456570611159,-7628740532066842542),(313,-1113736703378276328,3616657252108725234),(314,-4282728,9014536093282253229),(315,7471261253549247374,-1089735),(316,3376752063137846611,null),(317,null,3924),(318,68,9088530060623592787),(319,-1419368,-94),(320,1716955259314140025,-5914865),(321,27,9203259782959771402),(322,8334601817718692344,null),(323,9688,-1771687288172997544),(324,7401759,4322410),(325,null,1994999173126129272),(326,null,-15492),(327,-233857143729007970,null),(328,2850830232711332121,-8213321),(329,null,6971994830630048729),(330,-2035685525686264051,null),(331,665280648546411727,null),(332,-1943666593366894348,-6840692),(333,-6063321,11),(334,4736954359452070110,15224),(335,1645,3264450680165770271),(336,-6241361210913462458,-18),(337,63,-34),(338,8703592868269757830,4484923019877023241),(339,-30,-6884228),(340,-3369336149001195456,-2750),(341,40,-54),(342,37,2438498),(343,-1552142286639539325,6916988),(344,118,null),(345,null,4951038),(346,null,null),(347,18820,-24),(348,4,1837),(349,-7104820275867182616,-1667141532456254439),(350,-117,null),(351,-6744936,7217169534135891496),(352,-447695054565275264,-435925495821884872),(353,3656188441653042431,30543),(354,6843714,27839),(355,null,null),(356,-2249310,-3),(357,81,-1707889570219571775),(358,-8796747740331820398,-655888726706558577),(359,null,null),(360,-1416684837983101631,663038385424413140),(361,null,null),(362,-7800053568659715093,null),(363,null,null),(364,-100,-4077931526264642164),(365,6169899,null),(366,-21030,4214803518973719620),(367,-40,-6642),(368,-2777272,4131903230121701544),(369,-5849113992119874175,3750084),(370,91,-27533),(371,-21411,6717764235354131714),(372,9013,-7883325217989376345),(373,8127936913316529708,-27340),(374,-3472680424793837126,6206002643029049974),(375,442470265629404831,-303256338860845635),(376,-7849834,-6556828),(377,5636767545601432289,-531518278674076690),(378,-19505,-2432835151194725231),(379,-68,null),(380,-5793,-6460347),(381,-16,-5527847828764000248),(382,null,5185327040744070974),(383,3724,10),(384,25073,-7814),(385,-4651395947148994443,-6387402977255349765),(386,-2890,-6304247456019118651),(387,null,-29115),(388,6581930804521433509,null),(389,null,-60),(390,-127,null),(391,-4350827404362000108,-10997),(392,null,1317638242968700186),(393,8809,-9062081436264506048),(394,null,-4302),(395,14,5268785845053180758),(396,7985227534877938224,-2798211223431631408),(397,-7844484220951394622,-68),(398,697134119540701093,2860),(399,-13557,-3148953900992235555),(400,-5747144,-32713),(401,-4959226813321045648,6186761),(402,14605,-2573056),(403,-5083,null),(404,-7474161409310347280,-2502281517290173647),(405,null,804190495891640215),(406,-6111671,-742547569812211903),(407,-8322695682734605147,-9571),(408,-2965336462181809908,-17457),(409,-6221,-14265),(410,null,null),(411,-2207,null),(412,1466732814169792847,-2408406720845495278),(413,-5908806,-678890249738449769),(414,5679625,46),(415,2752663,null),(416,null,null),(417,619355,32098),(418,12595,-17416),(419,27,-3489256690333573852),(420,-25094,-501935407666810972),(421,64166,null),(422,15782,null),(423,5518250567330571812,null),(424,null,-6796798834383447666),(425,3733710,-106),(426,5555866,6934991),(427,-7176196,5365222),(428,2851,-11799),(429,3065653444548546288,-10868),(430,null,-7690607),(431,-2997178899067498282,-8871912805412510590),(432,5841637401830995172,59),(433,86,null),(434,-9206845599216078345,null),(435,27833,15526),(436,-20,111810),(437,4950260446355524005,-5861817211360506590),(438,-4263899811668843261,3396196457663319445),(439,-6004525709026836832,16990),(440,null,-437704158554061113),(441,709437599990831165,1332780654368059745),(442,-1315182556197702400,1584),(443,69,780971872655426045),(444,5226,85),(445,-108,2913296),(446,4637863517530743503,96),(447,-498806,null),(448,7551436827956853580,null),(449,-2635925351759200458,-25626),(450,null,-6981),(451,null,37),(452,6282316708487412703,-5348263290000538847),(453,null,16258),(454,601812485333522950,-7670318648767514732),(455,-31079,8817783814812073646),(456,-604,1586172469753685397),(457,-860961266086496276,-12464),(458,-972650925493860937,2210941973758020107),(459,80,4615515),(460,-3215182,23),(461,6152077390709826098,103),(462,-11110,1471359),(463,2792485310377877794,7343409),(464,-3906973223205540822,67),(465,-19557,27154),(466,-72,null),(467,null,null),(468,107,108),(469,null,-6358338),(470,-2168458806782934447,-14701),(471,-7603783181512687685,null),(472,-96,null),(473,6856140,81),(474,103,1841323708393098788),(475,null,-1461938948563115091),(476,-77,null),(477,9220103580375373364,-1287316047718825226),(478,-8579219458528958068,119),(479,4290942743842717200,7250764583737109631),(480,-6149487293511490775,-8881247858174191305),(481,-5176,2146837),(482,-2287965,5748781),(483,-50,-8630232766387687115),(484,-174838206885075746,null),(485,-15140,2443544),(486,-98,7339),(487,2951251767430781169,8883213084532572878),(488,-7,14515),(489,-2304,-90),(490,-31612,-3744536455101767837),(491,-5919797480034622909,null),(492,-128,-44),(493,-90,null),(494,3134626166387980736,31),(495,-408221205473544846,-107),(496,null,109030755805747479),(497,96,5451574592413435217),(498,120,-1768340),(499,-5,-4713231460494703071),(500,3891210325057328999,null),(501,1,-6627331),(502,23525,-60),(503,-4304099129947660620,5879933846455976577),(504,-30824,28045),(505,null,8617847357953425503),(506,-2295982530095649692,-79),(507,41,-3703145683305182355),(508,-3372669735195421035,null),(509,-2995629263674105646,null),(510,-7893160100099423744,-6407943713916998326),(511,16820,-3587792650670548936),(512,8690150785744825388,8364538),(513,992482107594450180,null),(514,-5897581391228833358,84),(515,137269107615153242,6880038911039514170),(516,5988656483755741756,null),(517,null,13636),(518,4563152806831688208,null),(519,-3097540736207800097,7752132),(520,-880933,67),(521,8952290043717775640,-4307494164787537435),(522,3527427763481498035,7712268),(523,6597716,16718),(524,-7031607363101411518,8116755),(525,-5998204465924732794,-1744971195370113087),(526,10086,2425096364468342829),(527,-14146,4),(528,null,6580428076367988425),(529,null,1349190871909500122),(530,7070362620994877141,null),(531,3378401,16668),(532,7190009692995712596,6777488172936857745),(533,-857016288162611786,98),(534,34,-11600),(535,null,null),(536,-1760988580014591707,925810737054421753),(537,null,-3903071),(538,null,24114),(539,3733062870284854580,-7189086),(540,253503105966596346,-2475411290912843778),(541,null,193703994145925461),(542,3635533,null),(543,-1051053800372861267,-184375779180267785),(544,11901,1894610368824312339),(545,4228582447038146478,65),(546,120,null),(547,2513224703919657142,30716),(548,8257406436468960462,null),(549,18552,-33),(550,-6227469974914089629,7457412653726204760),(551,5286302,null),(552,-2930502,9925),(553,124,6416202863205706927),(554,3049017610155657057,7633680),(555,4939870809287689413,2182301),(556,120,-64),(557,4168566508993093183,-68),(558,-5850018965358277901,19),(559,55,-5966027319720715721),(560,-323308,null),(561,-106,-6070071881424502415),(562,-11207,28895),(563,null,3910184882959582811),(564,-30932,5076547),(565,6846120627277729228,98),(566,-4121,-7319674740995977899),(567,6942445,null),(568,1962066952802452900,38),(569,7147090,31327),(570,3586717,null),(571,-96,6010200805606631889),(572,17039,null),(573,-5713612,-6982),(574,null,27529),(575,-103,-10000),(576,40,-7326096543944101090),(577,5,-9159085845751967876),(578,6498653,9697),(579,null,8597579075321214841),(580,null,-81),(581,-109,56),(582,2088435324002764288,2633536093730140848),(583,583687136593814170,-15424),(584,6708595070127400576,-1534918),(585,-3224295049917454584,-32),(586,-2238162701648410464,8234297),(587,8845085597903921721,null),(588,-93,68),(589,-8591867649781947679,-3514202428166285093),(590,798646375058855022,-4749665182717136441),(591,null,null),(592,null,-24158),(593,null,2227342761609318294),(594,3951651175581265230,30092),(595,null,-7742669894063249748),(596,8479639755868048244,-24942),(597,7408598239743564568,null),(598,-14971,-6591298895848618624),(599,23857,-3797979),(600,null,null),(601,-13486,6270439432268593366),(602,19,35),(603,56,null),(604,315913481117613754,-1389282),(605,null,-18708),(606,null,null),(607,2209841456199238272,-8052849512034620008),(608,-2282932885965427737,null),(609,91,-5197986763886806277),(610,74,-19510),(611,6741004400929906951,1697149713936359924),(612,null,-15014),(613,23552,4755464),(614,-6029229,94),(615,null,-5769767165374791530),(616,-96,4492473231734677718),(617,-984523602232851081,-8747665859634926548),(618,-4332655,9813),(619,null,8326501877764734345),(620,19440,-5),(621,null,-8980475787402535400),(622,-115,-7045461104223059300),(623,-2864056788929928593,-6399958992130294716),(624,6410825173908622599,26965),(625,-79,5788418),(626,null,-8326161925563888285),(627,-581275800130608796,-5215213923567889996),(628,-2394702,4165445187394671187),(629,-5573403880483602074,3412058),(630,-1854596,7110674854545428647),(631,null,1128),(632,null,-7887427903128303978),(633,108,-2446802071658238247),(634,2354618106477536395,-4268307857697248188),(635,105,-2115862128460349589),(636,4688345769556595816,-88),(637,-2797,3326519),(638,15073,null),(639,null,null),(640,5279215290622676559,-5421114857548721392),(641,2277472,-8601714964140811936),(642,-33,-1987299),(643,null,902743),(644,7223692985242848706,null),(645,66,-4388),(646,null,-8056948055677780347),(647,null,786680),(648,-120285101260613161,843117),(649,null,null),(650,5496496,4553402140904507583),(651,-5808824,null),(652,48,-3938613049350696319),(653,5559515447026175478,29978),(654,-16148,-24548),(655,21225,-2164251),(656,null,5655496712571973163),(657,-8700154969247229297,null),(658,-6998202,-4528984109572676382),(659,-2554147,null),(660,-1712500,-5),(661,6378036718694839017,-19128),(662,-3002195969198719343,1041778414515727603),(663,-4167,6897521763698499985),(664,-6266050955345414493,null),(665,null,-4312382824217691989),(666,-1750123,-941869528540385894),(667,21604,42),(668,-6785,-32244),(669,null,3393063),(670,21772,267535943181465827),(671,349110172718579702,-10096),(672,null,28237),(673,-44,121),(674,-610710294319604021,7950209946130814955),(675,1790790,-36),(676,12196,6780735237565300213),(677,null,8386619),(678,2856703639611471338,null),(679,10054,4692625012337398717),(680,null,-7814359692224868184),(681,-68,-7930403456732618908),(682,4983526690429505704,-280298104226958833),(683,-7168574883957287216,null),(684,11,-128),(685,27768,-5558643589736078309),(686,-65,-8175177821766272156),(687,7050281564004307480,494611677339348264),(688,-8534171922390527323,16474),(689,-3929550019883151560,-25593),(690,-2143783548058858824,-5758712),(691,-9496,-4321),(692,6478725256986659635,23741),(693,818,-1450419281530143196),(694,5103316,-10),(695,-5563360,null),(696,6744180,7353523867006246224),(697,null,10095),(698,-4377932987523751869,2873063425639148476),(699,-18121,-4765784665326523133),(700,-110,15),(701,null,7324957099602376474),(702,7475869526073719371,null),(703,8898910300977922242,655551570670380545),(704,-21045,1064106125932830174),(705,-2701735759922130484,null),(706,-296,-26867),(707,null,-24183),(708,-7856872,6491795091892316304),(709,-1109251,null),(710,-7529225202674503896,5256938300027967103),(711,10354,-110),(712,null,2484702),(713,4122313,-120),(714,3999402,null),(715,-3941748,5527746),(716,1188089960967307503,-7727755228905449014),(717,4200063,null),(718,-5763493365895389131,4595473454801154311),(719,-24889,-4673),(720,2144051559637003895,8291370),(721,-5435372554070585638,6346471572767656306),(722,-8828827798114422195,-68),(723,7177,null),(724,-8271935467316796013,null),(725,-115,6384),(726,-112,4500815470724721294),(727,104,105),(728,-13644,-53),(729,3239657968767027030,6611069),(730,958,-3598371688866869500),(731,-108,null),(732,-3755643352549952919,6652432),(733,19493,-11374),(734,26083,4604719883558871684),(735,null,-113),(736,36,-7277767594894096040),(737,-429589,-10),(738,null,null),(739,null,-17796),(740,-7627805539041130273,41),(741,1291876288757854416,-7683635),(742,null,-6407562161887025781),(743,3711759,null),(744,null,-20),(745,3136820,124),(746,-1836412,-1567766571545758407),(747,21906,-5495751),(748,-11,5505364986146795026),(749,-126,-4939826763567385670),(750,-3521503807478695852,4264922453758672957),(751,-8058660,-1005601338057815899),(752,-1713135268237754394,-2475851),(753,1790,null),(754,-4017960955259849767,null),(755,null,-8001424037846448297),(756,-1615982727696777958,null),(757,5163160,-1153036),(758,6906030095804443582,4180),(759,22937,-20275),(760,-7748683,-734225494112774028),(761,-1354661681283987873,7012233659228552156),(762,2790363622742746988,81),(763,2700754,4357159749635657598),(764,-3294973208892113114,7261615147269332526),(765,2990205949736667802,6483069),(766,4468,7555),(767,-5593337,-36),(768,-37,2289853715588655103),(769,5,4803200514894142472),(770,-188397,null),(771,-1066056582712879012,1584726901525686179),(772,-6477099,-6206454377234717287),(773,26255,-21107),(774,-292873342504139105,43),(775,-7669231501269709753,-2491115882004193058),(776,8439196147987651264,-860941746672011728),(777,null,1466003),(778,3963414652621222900,-2625963564688275136),(779,-25196,-7917677631640358692),(780,-17139,1357754),(781,-507581,19985),(782,null,9190603299686231853),(783,-23895,-61),(784,null,32736),(785,null,17340),(786,2982498348998760616,-28644),(787,-76,-5515015),(788,6079690805520966878,1760488),(789,14,2536961171412718310),(790,66,null),(791,125,1760203104690458404),(792,-2194279806667411689,-4940827),(793,null,8803950325588557838),(794,-51,-6),(795,64,null),(796,116,32442),(797,null,4176888219218988886),(798,113,7687328284307036768),(799,-11312,150973019496131335),(800,-26,-698628),(801,-5,6806),(802,-46,29),(803,4769900,null),(804,2316311,-24110),(805,1683938547968004306,null),(806,6806151064269171484,-6871456570731859106),(807,null,8052978),(808,-8431813574803882283,7778409),(809,-2084186177629164681,-16),(810,7542939570301197121,53),(811,7858423723010964563,2168007143975382636),(812,6986961554317620600,null),(813,-5,-119785396239548906),(814,-29089,-1250544630108652710),(815,-3459148,-71),(816,-746870273272485560,1185171268793705087),(817,7562827563125014415,-33),(818,31352,null),(819,-4421831,-7005),(820,5776278768713352385,-7905446492601009276),(821,-1335233656807895392,-46),(822,18515,1485681325476316934),(823,21088,90),(824,12570,5768623177860156558),(825,4095764537140654956,85),(826,null,null),(827,-69,22079),(828,8103700,null),(829,62,-7102324455763334192),(830,9035,3525146663029679762),(831,3820747045796894552,7320581992910192058),(832,-63,-1255161),(833,-5547376,-29491),(834,null,53),(835,3218284790163123201,-7880958390842920613),(836,1154,39229835191369820),(837,-1229087577203025081,null),(838,-14,-9049),(839,-3164607690335260910,-112),(840,-4213935260143456087,-638),(841,-56,-14006),(842,1475673331992065826,-28126),(843,null,-16938),(844,-6426752,3456846426296149453),(845,null,null),(846,8929169350777144544,24429),(847,-7185743,-4694955876900514360),(848,1678317,null),(849,7320265,-6548611843167469310),(850,-471,-93),(851,1968831,-18),(852,-31,-8143411),(853,49,null),(854,6137792864776437747,5928760),(855,2893277,-3550277254588668019),(856,-5214709218171519858,-41),(857,null,78),(858,-1875,-7517387),(859,null,null),(860,null,-1193304840873000858),(861,5655378639546720424,-5962105432683365677),(862,3514219790672142968,4),(863,88,4945091),(864,-5769040,4811563),(865,3522606452555548763,-7320165546100668028),(866,-4309154280467078058,null),(867,-3586679352621511575,null),(868,-54,3498358297985280020),(869,835178571645602741,65),(870,1597444271942694414,null),(871,21691,-3311157521463715754),(872,null,1021747230755792422),(873,-109,-6337973304896121647),(874,56,null),(875,2570723794979573688,15591),(876,1418154370526477935,21),(877,null,110),(878,88,-92),(879,-3201412,9082883341034398114),(880,-21749,null),(881,-7399848,24),(882,2211500221603946557,-1510274),(883,-1971178287855568813,-6105363136228213975),(884,null,-4745964126403851759),(885,-1987635651567291676,603514810233167464),(886,3242268,-7073688041832961352),(887,-325249370457315039,null),(888,-454354207701789890,-6035716),(889,26699,21436),(890,-5616295932260874660,-4516555),(891,-22553,-6927813011289304138),(892,-4398792968733128739,null),(893,-296423307180971662,-28810),(894,-285023548419915241,19),(895,-5281649970888112061,-76),(896,48,10558),(897,-27391,8012108),(898,null,null),(899,-22990,null),(900,1088299282010118263,20),(901,null,null),(902,7966442324125538382,-28),(903,null,-24197),(904,-22331,-8482206425413388524),(905,-3532432440878039211,683731192984197930),(906,-12811,null),(907,null,-4673849003060102736),(908,null,null),(909,-25998,229813869724801260),(910,905982842345946294,124),(911,-3345094486609164043,-1901635391262683540),(912,null,-293880123118371295),(913,82,6),(914,null,-99),(915,-64,-1750342),(916,4253395580767936377,-3098732854032759681),(917,null,-21),(918,-5785732,7),(919,1293489209199645344,-5381271650534043346),(920,4640524,null),(921,-29,45),(922,-9514,null),(923,null,-3751862127539064557),(924,-7640600010128676294,4013519830059231879),(925,-23023,8117),(926,2158139,5976257),(927,-5340429295027216202,null),(928,24795,-5065627564296030055),(929,8177414818586686986,-917),(930,55,-2855855),(931,4849304002781007952,3877),(932,4626800974147561341,-8009793),(933,-7288980214853872535,-15412),(934,5793261181211223206,null),(935,-7191650793416304975,null),(936,-7853,-8015613600873668755),(937,-20336,15360),(938,4114,-126),(939,-7094240425232474877,-7938297195035300824),(940,null,43),(941,2313581291471737357,7847051289175772573),(942,6630076625854870458,547),(943,9199883092956359658,-21365),(944,null,3710514879055770848),(945,-64,-6871503039317945326),(946,33,-2907920524720520417),(947,-3692,7550394049419760828),(948,-4816071,16453),(949,95,1432929551719041733),(950,-8291431442344247399,5678616249840615154),(951,749,-1792725),(952,-103,-3898474529014109547),(953,6464680535244584537,-24700),(954,3838484147280027690,-31434),(955,-7061506,-4904284903993103573),(956,6256500,-20399),(957,-8225986302923023227,6993559101860123335),(958,7614647,2595457),(959,54,-7158727821823107608),(960,null,-6612894138043031652),(961,1345351661284891290,-2640982085862290239),(962,-83,-2522517),(963,6407653026840236493,null),(964,-90,7489795565874978279),(965,null,1356444),(966,1101876,4934128),(967,-7016350981243562182,-5568253240631312209),(968,43,117),(969,-2757017,-2688193),(970,-6061167665630052677,-4026287),(971,-4651697040147200436,-474888632617137246),(972,-66,17912),(973,84,null),(974,10305,null),(975,103,null),(976,-7511229992791792975,-1916307746435589202),(977,-16,-2708119566394134989),(978,8220047427297719112,-29581),(979,-8327216918111462283,-23),(980,9133968392173759221,-3794493912354749876),(981,1118631,33),(982,-6792297199141224027,6574884479190412543),(983,17063,1546783193403713213),(984,-1669275295725030907,-6216943),(985,1898173,791229611795751784),(986,-4158950,-2215585468072436566),(987,1021,-600),(988,null,-14000),(989,-6161384914187433507,-3713237707965956634),(990,-32702,6118461477468251483),(991,-2768898239162544230,8057517234063384150),(992,7240620443900781942,-2396354),(993,-1035761,4053038705765766306),(994,-70,-4808124740007322198),(995,-192093107388210356,5334347046654923757),(996,-7612336,-13988),(997,null,-1471377032025129113),(998,null,-88),(999,null,-1980931985866165152);
    """

    qt_test1 """ SELECT count() FROM test_key_topn; """

    qt_test2 """ SELECT c1 FROM test_key_topn AS T1 ORDER BY c1 DESC LIMIT 9, 2; """
    qt_test3 """ SELECT c1 FROM test_key_topn AS T1 WHERE (T1.c1 > 4) ORDER BY c1 DESC LIMIT 9, 2; """
    qt_test4 """ SELECT c1 FROM test_key_topn AS T1 WHERE (T1.c1 <> 4) ORDER BY c1 DESC LIMIT 9, 2; """

    qt_test5 """ SELECT c1 FROM test_key_topn AS T1 WHERE T1.c1 IS NOT NULL ORDER BY c1 ASC LIMIT 9, 2; """
    qt_test6 """ SELECT c1 FROM test_key_topn AS T1 WHERE (T1.c1 < 4) ORDER BY c1 ASC LIMIT 9, 2; """
    qt_test7 """ SELECT c1 FROM test_key_topn AS T1 WHERE (T1.c1 <> 4) ORDER BY c1 ASC LIMIT 9, 2; """
}