/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: User.proto

package org.apache.drill.exec.proto;

public final class UserProtos {
  private UserProtos() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistryLite registry) {
  }

  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
    registerAllExtensions(
        (com.google.protobuf.ExtensionRegistryLite) registry);
  }
  /**
   * <pre>
   *&#47;/// User &lt;-&gt; Bit RPC ///////
   * </pre>
   *
   * Protobuf enum {@code exec.user.RpcType}
   */
  public enum RpcType
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>HANDSHAKE = 0;</code>
     */
    HANDSHAKE(0),
    /**
     * <code>ACK = 1;</code>
     */
    ACK(1),
    /**
     * <code>GOODBYE = 2;</code>
     */
    GOODBYE(2),
    /**
     * <pre>
     * user to bit
     * </pre>
     *
     * <code>RUN_QUERY = 3;</code>
     */
    RUN_QUERY(3),
    /**
     * <pre>
     * user is sending a query cancellation request to the drillbit
     * </pre>
     *
     * <code>CANCEL_QUERY = 4;</code>
     */
    CANCEL_QUERY(4),
    /**
     * <code>REQUEST_RESULTS = 5;</code>
     */
    REQUEST_RESULTS(5),
    /**
     * <pre>
     * user is sending a query resume request to the drillbit
     * </pre>
     *
     * <code>RESUME_PAUSED_QUERY = 11;</code>
     */
    RESUME_PAUSED_QUERY(11),
    /**
     * <pre>
     * to get plan fragments from query
     * </pre>
     *
     * <code>GET_QUERY_PLAN_FRAGMENTS = 12;</code>
     */
    GET_QUERY_PLAN_FRAGMENTS(12),
    /**
     * <pre>
     * user is requesting metadata of catalog(s).
     * </pre>
     *
     * <code>GET_CATALOGS = 14;</code>
     */
    GET_CATALOGS(14),
    /**
     * <pre>
     * user is requesting metadata of schema(s)
     * </pre>
     *
     * <code>GET_SCHEMAS = 15;</code>
     */
    GET_SCHEMAS(15),
    /**
     * <pre>
     * user is requesting metadata of table(s)
     * </pre>
     *
     * <code>GET_TABLES = 16;</code>
     */
    GET_TABLES(16),
    /**
     * <pre>
     * user is requesting metadata of column(s)
     * </pre>
     *
     * <code>GET_COLUMNS = 17;</code>
     */
    GET_COLUMNS(17),
    /**
     * <pre>
     * user is sending a request to create prepared statement
     * </pre>
     *
     * <code>CREATE_PREPARED_STATEMENT = 22;</code>
     */
    CREATE_PREPARED_STATEMENT(22),
    /**
     * <pre>
     * user is sending a request to receive server metadata
     * </pre>
     *
     * <code>GET_SERVER_META = 8;</code>
     */
    GET_SERVER_META(8),
    /**
     * <pre>
     * bit to user
     * </pre>
     *
     * <code>QUERY_DATA = 6;</code>
     */
    QUERY_DATA(6),
    /**
     * <code>QUERY_HANDLE = 7;</code>
     */
    QUERY_HANDLE(7),
    /**
     * <pre>
     * return plan fragments
     * </pre>
     *
     * <code>QUERY_PLAN_FRAGMENTS = 13;</code>
     */
    QUERY_PLAN_FRAGMENTS(13),
    /**
     * <pre>
     * return catalogs metadata in response to GET_CATALOGS
     * </pre>
     *
     * <code>CATALOGS = 18;</code>
     */
    CATALOGS(18),
    /**
     * <pre>
     * return schema metadata in response to GET_SCHEMAS
     * </pre>
     *
     * <code>SCHEMAS = 19;</code>
     */
    SCHEMAS(19),
    /**
     * <pre>
     * return table metadata in response to GET_TABLES
     * </pre>
     *
     * <code>TABLES = 20;</code>
     */
    TABLES(20),
    /**
     * <pre>
     * return column metadata in response to GET_COLUMNS
     * </pre>
     *
     * <code>COLUMNS = 21;</code>
     */
    COLUMNS(21),
    /**
     * <pre>
     * return preparated statement in response to CREATE_PREPARED_STATEMENT
     * </pre>
     *
     * <code>PREPARED_STATEMENT = 23;</code>
     */
    PREPARED_STATEMENT(23),
    /**
     * <pre>
     * return server infos in respose to GET_SERVER_META
     * </pre>
     *
     * <code>SERVER_META = 9;</code>
     */
    SERVER_META(9),
    /**
     * <pre>
     * drillbit is reporting a query status change, most likely a terminal message, to the user
     * </pre>
     *
     * <code>QUERY_RESULT = 10;</code>
     */
    QUERY_RESULT(10),
    /**
     * <pre>
     * user to bit and bit to user
     * </pre>
     *
     * <code>SASL_MESSAGE = 24;</code>
     */
    SASL_MESSAGE(24),
    ;

    /**
     * <code>HANDSHAKE = 0;</code>
     */
    public static final int HANDSHAKE_VALUE = 0;
    /**
     * <code>ACK = 1;</code>
     */
    public static final int ACK_VALUE = 1;
    /**
     * <code>GOODBYE = 2;</code>
     */
    public static final int GOODBYE_VALUE = 2;
    /**
     * <pre>
     * user to bit
     * </pre>
     *
     * <code>RUN_QUERY = 3;</code>
     */
    public static final int RUN_QUERY_VALUE = 3;
    /**
     * <pre>
     * user is sending a query cancellation request to the drillbit
     * </pre>
     *
     * <code>CANCEL_QUERY = 4;</code>
     */
    public static final int CANCEL_QUERY_VALUE = 4;
    /**
     * <code>REQUEST_RESULTS = 5;</code>
     */
    public static final int REQUEST_RESULTS_VALUE = 5;
    /**
     * <pre>
     * user is sending a query resume request to the drillbit
     * </pre>
     *
     * <code>RESUME_PAUSED_QUERY = 11;</code>
     */
    public static final int RESUME_PAUSED_QUERY_VALUE = 11;
    /**
     * <pre>
     * to get plan fragments from query
     * </pre>
     *
     * <code>GET_QUERY_PLAN_FRAGMENTS = 12;</code>
     */
    public static final int GET_QUERY_PLAN_FRAGMENTS_VALUE = 12;
    /**
     * <pre>
     * user is requesting metadata of catalog(s).
     * </pre>
     *
     * <code>GET_CATALOGS = 14;</code>
     */
    public static final int GET_CATALOGS_VALUE = 14;
    /**
     * <pre>
     * user is requesting metadata of schema(s)
     * </pre>
     *
     * <code>GET_SCHEMAS = 15;</code>
     */
    public static final int GET_SCHEMAS_VALUE = 15;
    /**
     * <pre>
     * user is requesting metadata of table(s)
     * </pre>
     *
     * <code>GET_TABLES = 16;</code>
     */
    public static final int GET_TABLES_VALUE = 16;
    /**
     * <pre>
     * user is requesting metadata of column(s)
     * </pre>
     *
     * <code>GET_COLUMNS = 17;</code>
     */
    public static final int GET_COLUMNS_VALUE = 17;
    /**
     * <pre>
     * user is sending a request to create prepared statement
     * </pre>
     *
     * <code>CREATE_PREPARED_STATEMENT = 22;</code>
     */
    public static final int CREATE_PREPARED_STATEMENT_VALUE = 22;
    /**
     * <pre>
     * user is sending a request to receive server metadata
     * </pre>
     *
     * <code>GET_SERVER_META = 8;</code>
     */
    public static final int GET_SERVER_META_VALUE = 8;
    /**
     * <pre>
     * bit to user
     * </pre>
     *
     * <code>QUERY_DATA = 6;</code>
     */
    public static final int QUERY_DATA_VALUE = 6;
    /**
     * <code>QUERY_HANDLE = 7;</code>
     */
    public static final int QUERY_HANDLE_VALUE = 7;
    /**
     * <pre>
     * return plan fragments
     * </pre>
     *
     * <code>QUERY_PLAN_FRAGMENTS = 13;</code>
     */
    public static final int QUERY_PLAN_FRAGMENTS_VALUE = 13;
    /**
     * <pre>
     * return catalogs metadata in response to GET_CATALOGS
     * </pre>
     *
     * <code>CATALOGS = 18;</code>
     */
    public static final int CATALOGS_VALUE = 18;
    /**
     * <pre>
     * return schema metadata in response to GET_SCHEMAS
     * </pre>
     *
     * <code>SCHEMAS = 19;</code>
     */
    public static final int SCHEMAS_VALUE = 19;
    /**
     * <pre>
     * return table metadata in response to GET_TABLES
     * </pre>
     *
     * <code>TABLES = 20;</code>
     */
    public static final int TABLES_VALUE = 20;
    /**
     * <pre>
     * return column metadata in response to GET_COLUMNS
     * </pre>
     *
     * <code>COLUMNS = 21;</code>
     */
    public static final int COLUMNS_VALUE = 21;
    /**
     * <pre>
     * return preparated statement in response to CREATE_PREPARED_STATEMENT
     * </pre>
     *
     * <code>PREPARED_STATEMENT = 23;</code>
     */
    public static final int PREPARED_STATEMENT_VALUE = 23;
    /**
     * <pre>
     * return server infos in respose to GET_SERVER_META
     * </pre>
     *
     * <code>SERVER_META = 9;</code>
     */
    public static final int SERVER_META_VALUE = 9;
    /**
     * <pre>
     * drillbit is reporting a query status change, most likely a terminal message, to the user
     * </pre>
     *
     * <code>QUERY_RESULT = 10;</code>
     */
    public static final int QUERY_RESULT_VALUE = 10;
    /**
     * <pre>
     * user to bit and bit to user
     * </pre>
     *
     * <code>SASL_MESSAGE = 24;</code>
     */
    public static final int SASL_MESSAGE_VALUE = 24;


    public final int getNumber() {
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RpcType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static RpcType forNumber(int value) {
      switch (value) {
        case 0: return HANDSHAKE;
        case 1: return ACK;
        case 2: return GOODBYE;
        case 3: return RUN_QUERY;
        case 4: return CANCEL_QUERY;
        case 5: return REQUEST_RESULTS;
        case 11: return RESUME_PAUSED_QUERY;
        case 12: return GET_QUERY_PLAN_FRAGMENTS;
        case 14: return GET_CATALOGS;
        case 15: return GET_SCHEMAS;
        case 16: return GET_TABLES;
        case 17: return GET_COLUMNS;
        case 22: return CREATE_PREPARED_STATEMENT;
        case 8: return GET_SERVER_META;
        case 6: return QUERY_DATA;
        case 7: return QUERY_HANDLE;
        case 13: return QUERY_PLAN_FRAGMENTS;
        case 18: return CATALOGS;
        case 19: return SCHEMAS;
        case 20: return TABLES;
        case 21: return COLUMNS;
        case 23: return PREPARED_STATEMENT;
        case 9: return SERVER_META;
        case 10: return QUERY_RESULT;
        case 24: return SASL_MESSAGE;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<RpcType>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        RpcType> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<RpcType>() {
            public RpcType findValueByNumber(int number) {
              return RpcType.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.getDescriptor().getEnumTypes().get(0);
    }

    private static final RpcType[] VALUES = values();

    public static RpcType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private RpcType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:exec.user.RpcType)
  }

  /**
   * Protobuf enum {@code exec.user.SaslSupport}
   */
  public enum SaslSupport
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>UNKNOWN_SASL_SUPPORT = 0;</code>
     */
    UNKNOWN_SASL_SUPPORT(0),
    /**
     * <code>SASL_AUTH = 1;</code>
     */
    SASL_AUTH(1),
    /**
     * <code>SASL_PRIVACY = 2;</code>
     */
    SASL_PRIVACY(2),
    ;

    /**
     * <code>UNKNOWN_SASL_SUPPORT = 0;</code>
     */
    public static final int UNKNOWN_SASL_SUPPORT_VALUE = 0;
    /**
     * <code>SASL_AUTH = 1;</code>
     */
    public static final int SASL_AUTH_VALUE = 1;
    /**
     * <code>SASL_PRIVACY = 2;</code>
     */
    public static final int SASL_PRIVACY_VALUE = 2;


    public final int getNumber() {
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SaslSupport valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static SaslSupport forNumber(int value) {
      switch (value) {
        case 0: return UNKNOWN_SASL_SUPPORT;
        case 1: return SASL_AUTH;
        case 2: return SASL_PRIVACY;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<SaslSupport>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        SaslSupport> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<SaslSupport>() {
            public SaslSupport findValueByNumber(int number) {
              return SaslSupport.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.getDescriptor().getEnumTypes().get(1);
    }

    private static final SaslSupport[] VALUES = values();

    public static SaslSupport valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private SaslSupport(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:exec.user.SaslSupport)
  }

  /**
   * Protobuf enum {@code exec.user.QueryResultsMode}
   */
  public enum QueryResultsMode
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * Server will inform the client regularly on the status of the query. Once the query is completed, service will inform the client as each query chunk is made available.
     * </pre>
     *
     * <code>STREAM_FULL = 1;</code>
     */
    STREAM_FULL(1),
    ;

    /**
     * <pre>
     * Server will inform the client regularly on the status of the query. Once the query is completed, service will inform the client as each query chunk is made available.
     * </pre>
     *
     * <code>STREAM_FULL = 1;</code>
     */
    public static final int STREAM_FULL_VALUE = 1;


    public final int getNumber() {
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static QueryResultsMode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static QueryResultsMode forNumber(int value) {
      switch (value) {
        case 1: return STREAM_FULL;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<QueryResultsMode>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        QueryResultsMode> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<QueryResultsMode>() {
            public QueryResultsMode findValueByNumber(int number) {
              return QueryResultsMode.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.getDescriptor().getEnumTypes().get(2);
    }

    private static final QueryResultsMode[] VALUES = values();

    public static QueryResultsMode valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private QueryResultsMode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:exec.user.QueryResultsMode)
  }

  /**
   * Protobuf enum {@code exec.user.HandshakeStatus}
   */
  public enum HandshakeStatus
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * Handshake is successful (including authentication if any)
     * </pre>
     *
     * <code>SUCCESS = 1;</code>
     */
    SUCCESS(1),
    /**
     * <pre>
     * Client and Server RPC versions are different
     * </pre>
     *
     * <code>RPC_VERSION_MISMATCH = 2;</code>
     */
    RPC_VERSION_MISMATCH(2),
    /**
     * <pre>
     * User authentication failed
     * </pre>
     *
     * <code>AUTH_FAILED = 3;</code>
     */
    AUTH_FAILED(3),
    /**
     * <pre>
     * Unknown failure, refer to the error message for more details
     * </pre>
     *
     * <code>UNKNOWN_FAILURE = 4;</code>
     */
    UNKNOWN_FAILURE(4),
    /**
     * <pre>
     * User authentication required
     * </pre>
     *
     * <code>AUTH_REQUIRED = 5;</code>
     */
    AUTH_REQUIRED(5),
    ;

    /**
     * <pre>
     * Handshake is successful (including authentication if any)
     * </pre>
     *
     * <code>SUCCESS = 1;</code>
     */
    public static final int SUCCESS_VALUE = 1;
    /**
     * <pre>
     * Client and Server RPC versions are different
     * </pre>
     *
     * <code>RPC_VERSION_MISMATCH = 2;</code>
     */
    public static final int RPC_VERSION_MISMATCH_VALUE = 2;
    /**
     * <pre>
     * User authentication failed
     * </pre>
     *
     * <code>AUTH_FAILED = 3;</code>
     */
    public static final int AUTH_FAILED_VALUE = 3;
    /**
     * <pre>
     * Unknown failure, refer to the error message for more details
     * </pre>
     *
     * <code>UNKNOWN_FAILURE = 4;</code>
     */
    public static final int UNKNOWN_FAILURE_VALUE = 4;
    /**
     * <pre>
     * User authentication required
     * </pre>
     *
     * <code>AUTH_REQUIRED = 5;</code>
     */
    public static final int AUTH_REQUIRED_VALUE = 5;


    public final int getNumber() {
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static HandshakeStatus valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static HandshakeStatus forNumber(int value) {
      switch (value) {
        case 1: return SUCCESS;
        case 2: return RPC_VERSION_MISMATCH;
        case 3: return AUTH_FAILED;
        case 4: return UNKNOWN_FAILURE;
        case 5: return AUTH_REQUIRED;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<HandshakeStatus>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        HandshakeStatus> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<HandshakeStatus>() {
            public HandshakeStatus findValueByNumber(int number) {
              return HandshakeStatus.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.getDescriptor().getEnumTypes().get(3);
    }

    private static final HandshakeStatus[] VALUES = values();

    public static HandshakeStatus valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private HandshakeStatus(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:exec.user.HandshakeStatus)
  }

  /**
   * <pre>
   * Enum indicating the request status.
   * </pre>
   *
   * Protobuf enum {@code exec.user.RequestStatus}
   */
  public enum RequestStatus
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>UNKNOWN_STATUS = 0;</code>
     */
    UNKNOWN_STATUS(0),
    /**
     * <code>OK = 1;</code>
     */
    OK(1),
    /**
     * <code>FAILED = 2;</code>
     */
    FAILED(2),
    /**
     * <pre>
     **
     * Request timed out. Futher attempts can change any API specific parameters and retry or just retry the request.
     * </pre>
     *
     * <code>TIMEOUT = 3;</code>
     */
    TIMEOUT(3),
    ;

    /**
     * <code>UNKNOWN_STATUS = 0;</code>
     */
    public static final int UNKNOWN_STATUS_VALUE = 0;
    /**
     * <code>OK = 1;</code>
     */
    public static final int OK_VALUE = 1;
    /**
     * <code>FAILED = 2;</code>
     */
    public static final int FAILED_VALUE = 2;
    /**
     * <pre>
     **
     * Request timed out. Futher attempts can change any API specific parameters and retry or just retry the request.
     * </pre>
     *
     * <code>TIMEOUT = 3;</code>
     */
    public static final int TIMEOUT_VALUE = 3;


    public final int getNumber() {
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RequestStatus valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static RequestStatus forNumber(int value) {
      switch (value) {
        case 0: return UNKNOWN_STATUS;
        case 1: return OK;
        case 2: return FAILED;
        case 3: return TIMEOUT;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<RequestStatus>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        RequestStatus> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<RequestStatus>() {
            public RequestStatus findValueByNumber(int number) {
              return RequestStatus.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.getDescriptor().getEnumTypes().get(4);
    }

    private static final RequestStatus[] VALUES = values();

    public static RequestStatus valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private RequestStatus(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:exec.user.RequestStatus)
  }

  /**
   * <pre>
   * How a column can be used in WHERE clause
   * </pre>
   *
   * Protobuf enum {@code exec.user.ColumnSearchability}
   */
  public enum ColumnSearchability
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>UNKNOWN_SEARCHABILITY = 0;</code>
     */
    UNKNOWN_SEARCHABILITY(0),
    /**
     * <pre>
     * can't be used in WHERE clause
     * </pre>
     *
     * <code>NONE = 1;</code>
     */
    NONE(1),
    /**
     * <pre>
     * can be used in WHERE clause but only with LIKE predicate
     * </pre>
     *
     * <code>CHAR = 2;</code>
     */
    CHAR(2),
    /**
     * <pre>
     * can be used in a WHERE clause with all the comparison operators except LIKE
     * </pre>
     *
     * <code>NUMBER = 3;</code>
     */
    NUMBER(3),
    /**
     * <pre>
     * can be used in a WHERE clause with all the comparison operators
     * </pre>
     *
     * <code>ALL = 4;</code>
     */
    ALL(4),
    ;

    /**
     * <code>UNKNOWN_SEARCHABILITY = 0;</code>
     */
    public static final int UNKNOWN_SEARCHABILITY_VALUE = 0;
    /**
     * <pre>
     * can't be used in WHERE clause
     * </pre>
     *
     * <code>NONE = 1;</code>
     */
    public static final int NONE_VALUE = 1;
    /**
     * <pre>
     * can be used in WHERE clause but only with LIKE predicate
     * </pre>
     *
     * <code>CHAR = 2;</code>
     */
    public static final int CHAR_VALUE = 2;
    /**
     * <pre>
     * can be used in a WHERE clause with all the comparison operators except LIKE
     * </pre>
     *
     * <code>NUMBER = 3;</code>
     */
    public static final int NUMBER_VALUE = 3;
    /**
     * <pre>
     * can be used in a WHERE clause with all the comparison operators
     * </pre>
     *
     * <code>ALL = 4;</code>
     */
    public static final int ALL_VALUE = 4;


    public final int getNumber() {
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ColumnSearchability valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ColumnSearchability forNumber(int value) {
      switch (value) {
        case 0: return UNKNOWN_SEARCHABILITY;
        case 1: return NONE;
        case 2: return CHAR;
        case 3: return NUMBER;
        case 4: return ALL;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ColumnSearchability>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        ColumnSearchability> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<ColumnSearchability>() {
            public ColumnSearchability findValueByNumber(int number) {
              return ColumnSearchability.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.getDescriptor().getEnumTypes().get(5);
    }

    private static final ColumnSearchability[] VALUES = values();

    public static ColumnSearchability valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ColumnSearchability(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:exec.user.ColumnSearchability)
  }

  /**
   * <pre>
   * Whether a column can be updatable.
   * </pre>
   *
   * Protobuf enum {@code exec.user.ColumnUpdatability}
   */
  public enum ColumnUpdatability
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>UNKNOWN_UPDATABILITY = 0;</code>
     */
    UNKNOWN_UPDATABILITY(0),
    /**
     * <code>READ_ONLY = 1;</code>
     */
    READ_ONLY(1),
    /**
     * <code>WRITABLE = 2;</code>
     */
    WRITABLE(2),
    ;

    /**
     * <code>UNKNOWN_UPDATABILITY = 0;</code>
     */
    public static final int UNKNOWN_UPDATABILITY_VALUE = 0;
    /**
     * <code>READ_ONLY = 1;</code>
     */
    public static final int READ_ONLY_VALUE = 1;
    /**
     * <code>WRITABLE = 2;</code>
     */
    public static final int WRITABLE_VALUE = 2;


    public final int getNumber() {
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ColumnUpdatability valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ColumnUpdatability forNumber(int value) {
      switch (value) {
        case 0: return UNKNOWN_UPDATABILITY;
        case 1: return READ_ONLY;
        case 2: return WRITABLE;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ColumnUpdatability>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        ColumnUpdatability> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<ColumnUpdatability>() {
            public ColumnUpdatability findValueByNumber(int number) {
              return ColumnUpdatability.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.getDescriptor().getEnumTypes().get(6);
    }

    private static final ColumnUpdatability[] VALUES = values();

    public static ColumnUpdatability valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ColumnUpdatability(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:exec.user.ColumnUpdatability)
  }

  /**
   * Protobuf enum {@code exec.user.CollateSupport}
   */
  public enum CollateSupport
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * Unknown support (for forward compatibility)
     * </pre>
     *
     * <code>CS_UNKNOWN = 0;</code>
     */
    CS_UNKNOWN(0),
    /**
     * <pre>
     * COLLATE clause can be added after each grouping column
     * </pre>
     *
     * <code>CS_GROUP_BY = 1;</code>
     */
    CS_GROUP_BY(1),
    ;

    /**
     * <pre>
     * Unknown support (for forward compatibility)
     * </pre>
     *
     * <code>CS_UNKNOWN = 0;</code>
     */
    public static final int CS_UNKNOWN_VALUE = 0;
    /**
     * <pre>
     * COLLATE clause can be added after each grouping column
     * </pre>
     *
     * <code>CS_GROUP_BY = 1;</code>
     */
    public static final int CS_GROUP_BY_VALUE = 1;


    public final int getNumber() {
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static CollateSupport valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static CollateSupport forNumber(int value) {
      switch (value) {
        case 0: return CS_UNKNOWN;
        case 1: return CS_GROUP_BY;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<CollateSupport>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        CollateSupport> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<CollateSupport>() {
            public CollateSupport findValueByNumber(int number) {
              return CollateSupport.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.getDescriptor().getEnumTypes().get(7);
    }

    private static final CollateSupport[] VALUES = values();

    public static CollateSupport valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private CollateSupport(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:exec.user.CollateSupport)
  }

  /**
   * Protobuf enum {@code exec.user.CorrelationNamesSupport}
   */
  public enum CorrelationNamesSupport
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * Correlation names are not supported
     * </pre>
     *
     * <code>CN_NONE = 1;</code>
     */
    CN_NONE(1),
    /**
     * <pre>
     * Correlation names are supported, but names have to
     * </pre>
     *
     * <code>CN_DIFFERENT_NAMES = 2;</code>
     */
    CN_DIFFERENT_NAMES(2),
    /**
     * <pre>
     * be different from the tables they represent
     * </pre>
     *
     * <code>CN_ANY = 3;</code>
     */
    CN_ANY(3),
    ;

    /**
     * <pre>
     * Correlation names are not supported
     * </pre>
     *
     * <code>CN_NONE = 1;</code>
     */
    public static final int CN_NONE_VALUE = 1;
    /**
     * <pre>
     * Correlation names are supported, but names have to
     * </pre>
     *
     * <code>CN_DIFFERENT_NAMES = 2;</code>
     */
    public static final int CN_DIFFERENT_NAMES_VALUE = 2;
    /**
     * <pre>
     * be different from the tables they represent
     * </pre>
     *
     * <code>CN_ANY = 3;</code>
     */
    public static final int CN_ANY_VALUE = 3;


    public final int getNumber() {
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static CorrelationNamesSupport valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static CorrelationNamesSupport forNumber(int value) {
      switch (value) {
        case 1: return CN_NONE;
        case 2: return CN_DIFFERENT_NAMES;
        case 3: return CN_ANY;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<CorrelationNamesSupport>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        CorrelationNamesSupport> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<CorrelationNamesSupport>() {
            public CorrelationNamesSupport findValueByNumber(int number) {
              return CorrelationNamesSupport.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.getDescriptor().getEnumTypes().get(8);
    }

    private static final CorrelationNamesSupport[] VALUES = values();

    public static CorrelationNamesSupport valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private CorrelationNamesSupport(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:exec.user.CorrelationNamesSupport)
  }

  /**
   * Protobuf enum {@code exec.user.DateTimeLiteralsSupport}
   */
  public enum DateTimeLiteralsSupport
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * Unknown support (for forward compatibility)
     * </pre>
     *
     * <code>DL_UNKNOWN = 0;</code>
     */
    DL_UNKNOWN(0),
    /**
     * <pre>
     * DATE literal is supported
     * </pre>
     *
     * <code>DL_DATE = 1;</code>
     */
    DL_DATE(1),
    /**
     * <pre>
     * TIME literal is supported
     * </pre>
     *
     * <code>DL_TIME = 2;</code>
     */
    DL_TIME(2),
    /**
     * <pre>
     * TIMESTAMP literal is supported
     * </pre>
     *
     * <code>DL_TIMESTAMP = 3;</code>
     */
    DL_TIMESTAMP(3),
    /**
     * <pre>
     * INTERVAL YEAR literal is supported
     * </pre>
     *
     * <code>DL_INTERVAL_YEAR = 4;</code>
     */
    DL_INTERVAL_YEAR(4),
    /**
     * <pre>
     * INTERVAL MONTH literal is supported
     * </pre>
     *
     * <code>DL_INTERVAL_MONTH = 5;</code>
     */
    DL_INTERVAL_MONTH(5),
    /**
     * <pre>
     * INTERVAL DAY literal is supported
     * </pre>
     *
     * <code>DL_INTERVAL_DAY = 6;</code>
     */
    DL_INTERVAL_DAY(6),
    /**
     * <pre>
     * INTERVAL HOUR literal is supported
     * </pre>
     *
     * <code>DL_INTERVAL_HOUR = 7;</code>
     */
    DL_INTERVAL_HOUR(7),
    /**
     * <pre>
     * INTERVAL MINUTE literal is supported
     * </pre>
     *
     * <code>DL_INTERVAL_MINUTE = 8;</code>
     */
    DL_INTERVAL_MINUTE(8),
    /**
     * <pre>
     * INTERVAL SECOND literal is supported
     * </pre>
     *
     * <code>DL_INTERVAL_SECOND = 9;</code>
     */
    DL_INTERVAL_SECOND(9),
    /**
     * <pre>
     * INTERVAL YEAR TO MONTH literal is supported
     * </pre>
     *
     * <code>DL_INTERVAL_YEAR_TO_MONTH = 10;</code>
     */
    DL_INTERVAL_YEAR_TO_MONTH(10),
    /**
     * <pre>
     * INTERVAL DAY TO HOUR literal is supported
     * </pre>
     *
     * <code>DL_INTERVAL_DAY_TO_HOUR = 11;</code>
     */
    DL_INTERVAL_DAY_TO_HOUR(11),
    /**
     * <pre>
     * INTERVAL DAY TO MINUTE literal is supported
     * </pre>
     *
     * <code>DL_INTERVAL_DAY_TO_MINUTE = 12;</code>
     */
    DL_INTERVAL_DAY_TO_MINUTE(12),
    /**
     * <pre>
     * INTERVAL DAY TO SECOND literal is supported
     * </pre>
     *
     * <code>DL_INTERVAL_DAY_TO_SECOND = 13;</code>
     */
    DL_INTERVAL_DAY_TO_SECOND(13),
    /**
     * <pre>
     * INTERVAL HOUR TO MINUTE literal is supported
     * </pre>
     *
     * <code>DL_INTERVAL_HOUR_TO_MINUTE = 14;</code>
     */
    DL_INTERVAL_HOUR_TO_MINUTE(14),
    /**
     * <pre>
     * INTERVAL HOUR TO SECOND literal is supported
     * </pre>
     *
     * <code>DL_INTERVAL_HOUR_TO_SECOND = 15;</code>
     */
    DL_INTERVAL_HOUR_TO_SECOND(15),
    /**
     * <pre>
     * INTERVAL MINUTE TO SECOND literal is supported
     * </pre>
     *
     * <code>DL_INTERVAL_MINUTE_TO_SECOND = 16;</code>
     */
    DL_INTERVAL_MINUTE_TO_SECOND(16),
    ;

    /**
     * <pre>
     * Unknown support (for forward compatibility)
     * </pre>
     *
     * <code>DL_UNKNOWN = 0;</code>
     */
    public static final int DL_UNKNOWN_VALUE = 0;
    /**
     * <pre>
     * DATE literal is supported
     * </pre>
     *
     * <code>DL_DATE = 1;</code>
     */
    public static final int DL_DATE_VALUE = 1;
    /**
     * <pre>
     * TIME literal is supported
     * </pre>
     *
     * <code>DL_TIME = 2;</code>
     */
    public static final int DL_TIME_VALUE = 2;
    /**
     * <pre>
     * TIMESTAMP literal is supported
     * </pre>
     *
     * <code>DL_TIMESTAMP = 3;</code>
     */
    public static final int DL_TIMESTAMP_VALUE = 3;
    /**
     * <pre>
     * INTERVAL YEAR literal is supported
     * </pre>
     *
     * <code>DL_INTERVAL_YEAR = 4;</code>
     */
    public static final int DL_INTERVAL_YEAR_VALUE = 4;
    /**
     * <pre>
     * INTERVAL MONTH literal is supported
     * </pre>
     *
     * <code>DL_INTERVAL_MONTH = 5;</code>
     */
    public static final int DL_INTERVAL_MONTH_VALUE = 5;
    /**
     * <pre>
     * INTERVAL DAY literal is supported
     * </pre>
     *
     * <code>DL_INTERVAL_DAY = 6;</code>
     */
    public static final int DL_INTERVAL_DAY_VALUE = 6;
    /**
     * <pre>
     * INTERVAL HOUR literal is supported
     * </pre>
     *
     * <code>DL_INTERVAL_HOUR = 7;</code>
     */
    public static final int DL_INTERVAL_HOUR_VALUE = 7;
    /**
     * <pre>
     * INTERVAL MINUTE literal is supported
     * </pre>
     *
     * <code>DL_INTERVAL_MINUTE = 8;</code>
     */
    public static final int DL_INTERVAL_MINUTE_VALUE = 8;
    /**
     * <pre>
     * INTERVAL SECOND literal is supported
     * </pre>
     *
     * <code>DL_INTERVAL_SECOND = 9;</code>
     */
    public static final int DL_INTERVAL_SECOND_VALUE = 9;
    /**
     * <pre>
     * INTERVAL YEAR TO MONTH literal is supported
     * </pre>
     *
     * <code>DL_INTERVAL_YEAR_TO_MONTH = 10;</code>
     */
    public static final int DL_INTERVAL_YEAR_TO_MONTH_VALUE = 10;
    /**
     * <pre>
     * INTERVAL DAY TO HOUR literal is supported
     * </pre>
     *
     * <code>DL_INTERVAL_DAY_TO_HOUR = 11;</code>
     */
    public static final int DL_INTERVAL_DAY_TO_HOUR_VALUE = 11;
    /**
     * <pre>
     * INTERVAL DAY TO MINUTE literal is supported
     * </pre>
     *
     * <code>DL_INTERVAL_DAY_TO_MINUTE = 12;</code>
     */
    public static final int DL_INTERVAL_DAY_TO_MINUTE_VALUE = 12;
    /**
     * <pre>
     * INTERVAL DAY TO SECOND literal is supported
     * </pre>
     *
     * <code>DL_INTERVAL_DAY_TO_SECOND = 13;</code>
     */
    public static final int DL_INTERVAL_DAY_TO_SECOND_VALUE = 13;
    /**
     * <pre>
     * INTERVAL HOUR TO MINUTE literal is supported
     * </pre>
     *
     * <code>DL_INTERVAL_HOUR_TO_MINUTE = 14;</code>
     */
    public static final int DL_INTERVAL_HOUR_TO_MINUTE_VALUE = 14;
    /**
     * <pre>
     * INTERVAL HOUR TO SECOND literal is supported
     * </pre>
     *
     * <code>DL_INTERVAL_HOUR_TO_SECOND = 15;</code>
     */
    public static final int DL_INTERVAL_HOUR_TO_SECOND_VALUE = 15;
    /**
     * <pre>
     * INTERVAL MINUTE TO SECOND literal is supported
     * </pre>
     *
     * <code>DL_INTERVAL_MINUTE_TO_SECOND = 16;</code>
     */
    public static final int DL_INTERVAL_MINUTE_TO_SECOND_VALUE = 16;


    public final int getNumber() {
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DateTimeLiteralsSupport valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static DateTimeLiteralsSupport forNumber(int value) {
      switch (value) {
        case 0: return DL_UNKNOWN;
        case 1: return DL_DATE;
        case 2: return DL_TIME;
        case 3: return DL_TIMESTAMP;
        case 4: return DL_INTERVAL_YEAR;
        case 5: return DL_INTERVAL_MONTH;
        case 6: return DL_INTERVAL_DAY;
        case 7: return DL_INTERVAL_HOUR;
        case 8: return DL_INTERVAL_MINUTE;
        case 9: return DL_INTERVAL_SECOND;
        case 10: return DL_INTERVAL_YEAR_TO_MONTH;
        case 11: return DL_INTERVAL_DAY_TO_HOUR;
        case 12: return DL_INTERVAL_DAY_TO_MINUTE;
        case 13: return DL_INTERVAL_DAY_TO_SECOND;
        case 14: return DL_INTERVAL_HOUR_TO_MINUTE;
        case 15: return DL_INTERVAL_HOUR_TO_SECOND;
        case 16: return DL_INTERVAL_MINUTE_TO_SECOND;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<DateTimeLiteralsSupport>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        DateTimeLiteralsSupport> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<DateTimeLiteralsSupport>() {
            public DateTimeLiteralsSupport findValueByNumber(int number) {
              return DateTimeLiteralsSupport.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.getDescriptor().getEnumTypes().get(9);
    }

    private static final DateTimeLiteralsSupport[] VALUES = values();

    public static DateTimeLiteralsSupport valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private DateTimeLiteralsSupport(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:exec.user.DateTimeLiteralsSupport)
  }

  /**
   * Protobuf enum {@code exec.user.GroupBySupport}
   */
  public enum GroupBySupport
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * Group by is not supported
     * </pre>
     *
     * <code>GB_NONE = 1;</code>
     */
    GB_NONE(1),
    /**
     * <pre>
     * Group by supported with non aggregated columns in select
     * </pre>
     *
     * <code>GB_SELECT_ONLY = 2;</code>
     */
    GB_SELECT_ONLY(2),
    /**
     * <pre>
     * Group by supported with columns absent from the select list
     *if all the non-aggregated colums from the select list are also added 
     * </pre>
     *
     * <code>GB_BEYOND_SELECT = 3;</code>
     */
    GB_BEYOND_SELECT(3),
    /**
     * <pre>
     * Group by supported with columns absent from the select list
     * </pre>
     *
     * <code>GB_UNRELATED = 4;</code>
     */
    GB_UNRELATED(4),
    ;

    /**
     * <pre>
     * Group by is not supported
     * </pre>
     *
     * <code>GB_NONE = 1;</code>
     */
    public static final int GB_NONE_VALUE = 1;
    /**
     * <pre>
     * Group by supported with non aggregated columns in select
     * </pre>
     *
     * <code>GB_SELECT_ONLY = 2;</code>
     */
    public static final int GB_SELECT_ONLY_VALUE = 2;
    /**
     * <pre>
     * Group by supported with columns absent from the select list
     *if all the non-aggregated colums from the select list are also added 
     * </pre>
     *
     * <code>GB_BEYOND_SELECT = 3;</code>
     */
    public static final int GB_BEYOND_SELECT_VALUE = 3;
    /**
     * <pre>
     * Group by supported with columns absent from the select list
     * </pre>
     *
     * <code>GB_UNRELATED = 4;</code>
     */
    public static final int GB_UNRELATED_VALUE = 4;


    public final int getNumber() {
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static GroupBySupport valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static GroupBySupport forNumber(int value) {
      switch (value) {
        case 1: return GB_NONE;
        case 2: return GB_SELECT_ONLY;
        case 3: return GB_BEYOND_SELECT;
        case 4: return GB_UNRELATED;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<GroupBySupport>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        GroupBySupport> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<GroupBySupport>() {
            public GroupBySupport findValueByNumber(int number) {
              return GroupBySupport.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.getDescriptor().getEnumTypes().get(10);
    }

    private static final GroupBySupport[] VALUES = values();

    public static GroupBySupport valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private GroupBySupport(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:exec.user.GroupBySupport)
  }

  /**
   * Protobuf enum {@code exec.user.IdentifierCasing}
   */
  public enum IdentifierCasing
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * Unknown support (for forward compatibility)
     * </pre>
     *
     * <code>IC_UNKNOWN = 0;</code>
     */
    IC_UNKNOWN(0),
    /**
     * <pre>
     * Mixed case identifier is treated as case insensitive
     *and stored in lower case 
     * </pre>
     *
     * <code>IC_STORES_LOWER = 1;</code>
     */
    IC_STORES_LOWER(1),
    /**
     * <pre>
     * Mixed case identifier is treated as case insensitive
     *and stored in mixed case 
     * </pre>
     *
     * <code>IC_STORES_MIXED = 2;</code>
     */
    IC_STORES_MIXED(2),
    /**
     * <pre>
     * Mixed case identifier is treated as case insensitive
     *and stored in upper case 
     * </pre>
     *
     * <code>IC_STORES_UPPER = 3;</code>
     */
    IC_STORES_UPPER(3),
    /**
     * <pre>
     * Mixed case identifier is treated as case sensitive
     *and stored in mixed case 
     * </pre>
     *
     * <code>IC_SUPPORTS_MIXED = 4;</code>
     */
    IC_SUPPORTS_MIXED(4),
    ;

    /**
     * <pre>
     * Unknown support (for forward compatibility)
     * </pre>
     *
     * <code>IC_UNKNOWN = 0;</code>
     */
    public static final int IC_UNKNOWN_VALUE = 0;
    /**
     * <pre>
     * Mixed case identifier is treated as case insensitive
     *and stored in lower case 
     * </pre>
     *
     * <code>IC_STORES_LOWER = 1;</code>
     */
    public static final int IC_STORES_LOWER_VALUE = 1;
    /**
     * <pre>
     * Mixed case identifier is treated as case insensitive
     *and stored in mixed case 
     * </pre>
     *
     * <code>IC_STORES_MIXED = 2;</code>
     */
    public static final int IC_STORES_MIXED_VALUE = 2;
    /**
     * <pre>
     * Mixed case identifier is treated as case insensitive
     *and stored in upper case 
     * </pre>
     *
     * <code>IC_STORES_UPPER = 3;</code>
     */
    public static final int IC_STORES_UPPER_VALUE = 3;
    /**
     * <pre>
     * Mixed case identifier is treated as case sensitive
     *and stored in mixed case 
     * </pre>
     *
     * <code>IC_SUPPORTS_MIXED = 4;</code>
     */
    public static final int IC_SUPPORTS_MIXED_VALUE = 4;


    public final int getNumber() {
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static IdentifierCasing valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static IdentifierCasing forNumber(int value) {
      switch (value) {
        case 0: return IC_UNKNOWN;
        case 1: return IC_STORES_LOWER;
        case 2: return IC_STORES_MIXED;
        case 3: return IC_STORES_UPPER;
        case 4: return IC_SUPPORTS_MIXED;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<IdentifierCasing>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        IdentifierCasing> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<IdentifierCasing>() {
            public IdentifierCasing findValueByNumber(int number) {
              return IdentifierCasing.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.getDescriptor().getEnumTypes().get(11);
    }

    private static final IdentifierCasing[] VALUES = values();

    public static IdentifierCasing valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private IdentifierCasing(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:exec.user.IdentifierCasing)
  }

  /**
   * Protobuf enum {@code exec.user.NullCollation}
   */
  public enum NullCollation
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * Unknown support (for forward compatibility)
     * </pre>
     *
     * <code>NC_UNKNOWN = 0;</code>
     */
    NC_UNKNOWN(0),
    /**
     * <pre>
     * NULL values are sorted at the start regardless of the order
     * </pre>
     *
     * <code>NC_AT_START = 1;</code>
     */
    NC_AT_START(1),
    /**
     * <pre>
     * NULL values are sorted at the end regardless of the order
     * </pre>
     *
     * <code>NC_AT_END = 2;</code>
     */
    NC_AT_END(2),
    /**
     * <pre>
     * NULL is the highest value
     * </pre>
     *
     * <code>NC_HIGH = 3;</code>
     */
    NC_HIGH(3),
    /**
     * <pre>
     * NULL is the lowest value
     * </pre>
     *
     * <code>NC_LOW = 4;</code>
     */
    NC_LOW(4),
    ;

    /**
     * <pre>
     * Unknown support (for forward compatibility)
     * </pre>
     *
     * <code>NC_UNKNOWN = 0;</code>
     */
    public static final int NC_UNKNOWN_VALUE = 0;
    /**
     * <pre>
     * NULL values are sorted at the start regardless of the order
     * </pre>
     *
     * <code>NC_AT_START = 1;</code>
     */
    public static final int NC_AT_START_VALUE = 1;
    /**
     * <pre>
     * NULL values are sorted at the end regardless of the order
     * </pre>
     *
     * <code>NC_AT_END = 2;</code>
     */
    public static final int NC_AT_END_VALUE = 2;
    /**
     * <pre>
     * NULL is the highest value
     * </pre>
     *
     * <code>NC_HIGH = 3;</code>
     */
    public static final int NC_HIGH_VALUE = 3;
    /**
     * <pre>
     * NULL is the lowest value
     * </pre>
     *
     * <code>NC_LOW = 4;</code>
     */
    public static final int NC_LOW_VALUE = 4;


    public final int getNumber() {
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static NullCollation valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static NullCollation forNumber(int value) {
      switch (value) {
        case 0: return NC_UNKNOWN;
        case 1: return NC_AT_START;
        case 2: return NC_AT_END;
        case 3: return NC_HIGH;
        case 4: return NC_LOW;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<NullCollation>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        NullCollation> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<NullCollation>() {
            public NullCollation findValueByNumber(int number) {
              return NullCollation.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.getDescriptor().getEnumTypes().get(12);
    }

    private static final NullCollation[] VALUES = values();

    public static NullCollation valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private NullCollation(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:exec.user.NullCollation)
  }

  /**
   * Protobuf enum {@code exec.user.OrderBySupport}
   */
  public enum OrderBySupport
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * Unknown support (for forward compatibility)
     * </pre>
     *
     * <code>OB_UNKNOWN = 0;</code>
     */
    OB_UNKNOWN(0),
    /**
     * <pre>
     * ORDER BY supported with columns not in SELECT list
     * </pre>
     *
     * <code>OB_UNRELATED = 1;</code>
     */
    OB_UNRELATED(1),
    /**
     * <pre>
     * ORDER BY with expressions is supported
     * </pre>
     *
     * <code>OB_EXPRESSION = 2;</code>
     */
    OB_EXPRESSION(2),
    ;

    /**
     * <pre>
     * Unknown support (for forward compatibility)
     * </pre>
     *
     * <code>OB_UNKNOWN = 0;</code>
     */
    public static final int OB_UNKNOWN_VALUE = 0;
    /**
     * <pre>
     * ORDER BY supported with columns not in SELECT list
     * </pre>
     *
     * <code>OB_UNRELATED = 1;</code>
     */
    public static final int OB_UNRELATED_VALUE = 1;
    /**
     * <pre>
     * ORDER BY with expressions is supported
     * </pre>
     *
     * <code>OB_EXPRESSION = 2;</code>
     */
    public static final int OB_EXPRESSION_VALUE = 2;


    public final int getNumber() {
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static OrderBySupport valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static OrderBySupport forNumber(int value) {
      switch (value) {
        case 0: return OB_UNKNOWN;
        case 1: return OB_UNRELATED;
        case 2: return OB_EXPRESSION;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<OrderBySupport>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        OrderBySupport> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<OrderBySupport>() {
            public OrderBySupport findValueByNumber(int number) {
              return OrderBySupport.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.getDescriptor().getEnumTypes().get(13);
    }

    private static final OrderBySupport[] VALUES = values();

    public static OrderBySupport valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private OrderBySupport(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:exec.user.OrderBySupport)
  }

  /**
   * Protobuf enum {@code exec.user.OuterJoinSupport}
   */
  public enum OuterJoinSupport
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * Unknown support (for forward compatibility)
     * </pre>
     *
     * <code>OJ_UNKNOWN = 0;</code>
     */
    OJ_UNKNOWN(0),
    /**
     * <pre>
     * Left outer join is supported
     * </pre>
     *
     * <code>OJ_LEFT = 1;</code>
     */
    OJ_LEFT(1),
    /**
     * <pre>
     * Right outer join is supported
     * </pre>
     *
     * <code>OJ_RIGHT = 2;</code>
     */
    OJ_RIGHT(2),
    /**
     * <pre>
     * Full outer join is supported
     * </pre>
     *
     * <code>OJ_FULL = 3;</code>
     */
    OJ_FULL(3),
    /**
     * <pre>
     * Nested outer join is supported
     * </pre>
     *
     * <code>OJ_NESTED = 4;</code>
     */
    OJ_NESTED(4),
    /**
     * <pre>
     * Column names in the ON clause don't have to share the same order
     *as their respective table names in the OUTER JOIN clase 
     * </pre>
     *
     * <code>OJ_NOT_ORDERED = 5;</code>
     */
    OJ_NOT_ORDERED(5),
    /**
     * <pre>
     * Inner table can also be used in an inner join
     * </pre>
     *
     * <code>OJ_INNER = 6;</code>
     */
    OJ_INNER(6),
    /**
     * <pre>
     * Any comparison operator is supported in the ON clause
     * </pre>
     *
     * <code>OJ_ALL_COMPARISON_OPS = 7;</code>
     */
    OJ_ALL_COMPARISON_OPS(7),
    ;

    /**
     * <pre>
     * Unknown support (for forward compatibility)
     * </pre>
     *
     * <code>OJ_UNKNOWN = 0;</code>
     */
    public static final int OJ_UNKNOWN_VALUE = 0;
    /**
     * <pre>
     * Left outer join is supported
     * </pre>
     *
     * <code>OJ_LEFT = 1;</code>
     */
    public static final int OJ_LEFT_VALUE = 1;
    /**
     * <pre>
     * Right outer join is supported
     * </pre>
     *
     * <code>OJ_RIGHT = 2;</code>
     */
    public static final int OJ_RIGHT_VALUE = 2;
    /**
     * <pre>
     * Full outer join is supported
     * </pre>
     *
     * <code>OJ_FULL = 3;</code>
     */
    public static final int OJ_FULL_VALUE = 3;
    /**
     * <pre>
     * Nested outer join is supported
     * </pre>
     *
     * <code>OJ_NESTED = 4;</code>
     */
    public static final int OJ_NESTED_VALUE = 4;
    /**
     * <pre>
     * Column names in the ON clause don't have to share the same order
     *as their respective table names in the OUTER JOIN clase 
     * </pre>
     *
     * <code>OJ_NOT_ORDERED = 5;</code>
     */
    public static final int OJ_NOT_ORDERED_VALUE = 5;
    /**
     * <pre>
     * Inner table can also be used in an inner join
     * </pre>
     *
     * <code>OJ_INNER = 6;</code>
     */
    public static final int OJ_INNER_VALUE = 6;
    /**
     * <pre>
     * Any comparison operator is supported in the ON clause
     * </pre>
     *
     * <code>OJ_ALL_COMPARISON_OPS = 7;</code>
     */
    public static final int OJ_ALL_COMPARISON_OPS_VALUE = 7;


    public final int getNumber() {
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static OuterJoinSupport valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static OuterJoinSupport forNumber(int value) {
      switch (value) {
        case 0: return OJ_UNKNOWN;
        case 1: return OJ_LEFT;
        case 2: return OJ_RIGHT;
        case 3: return OJ_FULL;
        case 4: return OJ_NESTED;
        case 5: return OJ_NOT_ORDERED;
        case 6: return OJ_INNER;
        case 7: return OJ_ALL_COMPARISON_OPS;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<OuterJoinSupport>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        OuterJoinSupport> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<OuterJoinSupport>() {
            public OuterJoinSupport findValueByNumber(int number) {
              return OuterJoinSupport.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.getDescriptor().getEnumTypes().get(14);
    }

    private static final OuterJoinSupport[] VALUES = values();

    public static OuterJoinSupport valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private OuterJoinSupport(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:exec.user.OuterJoinSupport)
  }

  /**
   * Protobuf enum {@code exec.user.SubQuerySupport}
   */
  public enum SubQuerySupport
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * Unknown support (for forward compatibility)
     * </pre>
     *
     * <code>SQ_UNKNOWN = 0;</code>
     */
    SQ_UNKNOWN(0),
    /**
     * <pre>
     * Correlated subquery is supported
     * </pre>
     *
     * <code>SQ_CORRELATED = 1;</code>
     */
    SQ_CORRELATED(1),
    /**
     * <pre>
     * Subquery in comparison expression is supported
     * </pre>
     *
     * <code>SQ_IN_COMPARISON = 2;</code>
     */
    SQ_IN_COMPARISON(2),
    /**
     * <pre>
     * Subquery in EXISTS expression is supported
     * </pre>
     *
     * <code>SQ_IN_EXISTS = 3;</code>
     */
    SQ_IN_EXISTS(3),
    /**
     * <pre>
     * Subquery in INSERT expression is supported
     * </pre>
     *
     * <code>SQ_IN_INSERT = 4;</code>
     */
    SQ_IN_INSERT(4),
    /**
     * <pre>
     * Subquery in quantified expression is supported
     * </pre>
     *
     * <code>SQ_IN_QUANTIFIED = 5;</code>
     */
    SQ_IN_QUANTIFIED(5),
    ;

    /**
     * <pre>
     * Unknown support (for forward compatibility)
     * </pre>
     *
     * <code>SQ_UNKNOWN = 0;</code>
     */
    public static final int SQ_UNKNOWN_VALUE = 0;
    /**
     * <pre>
     * Correlated subquery is supported
     * </pre>
     *
     * <code>SQ_CORRELATED = 1;</code>
     */
    public static final int SQ_CORRELATED_VALUE = 1;
    /**
     * <pre>
     * Subquery in comparison expression is supported
     * </pre>
     *
     * <code>SQ_IN_COMPARISON = 2;</code>
     */
    public static final int SQ_IN_COMPARISON_VALUE = 2;
    /**
     * <pre>
     * Subquery in EXISTS expression is supported
     * </pre>
     *
     * <code>SQ_IN_EXISTS = 3;</code>
     */
    public static final int SQ_IN_EXISTS_VALUE = 3;
    /**
     * <pre>
     * Subquery in INSERT expression is supported
     * </pre>
     *
     * <code>SQ_IN_INSERT = 4;</code>
     */
    public static final int SQ_IN_INSERT_VALUE = 4;
    /**
     * <pre>
     * Subquery in quantified expression is supported
     * </pre>
     *
     * <code>SQ_IN_QUANTIFIED = 5;</code>
     */
    public static final int SQ_IN_QUANTIFIED_VALUE = 5;


    public final int getNumber() {
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SubQuerySupport valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static SubQuerySupport forNumber(int value) {
      switch (value) {
        case 0: return SQ_UNKNOWN;
        case 1: return SQ_CORRELATED;
        case 2: return SQ_IN_COMPARISON;
        case 3: return SQ_IN_EXISTS;
        case 4: return SQ_IN_INSERT;
        case 5: return SQ_IN_QUANTIFIED;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<SubQuerySupport>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        SubQuerySupport> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<SubQuerySupport>() {
            public SubQuerySupport findValueByNumber(int number) {
              return SubQuerySupport.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.getDescriptor().getEnumTypes().get(15);
    }

    private static final SubQuerySupport[] VALUES = values();

    public static SubQuerySupport valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private SubQuerySupport(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:exec.user.SubQuerySupport)
  }

  /**
   * Protobuf enum {@code exec.user.UnionSupport}
   */
  public enum UnionSupport
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * Unknown support (for forward compatibility)
     * </pre>
     *
     * <code>U_UNKNOWN = 0;</code>
     */
    U_UNKNOWN(0),
    /**
     * <pre>
     * UNION is supported
     * </pre>
     *
     * <code>U_UNION = 1;</code>
     */
    U_UNION(1),
    /**
     * <pre>
     * UNION_ALL is supported
     * </pre>
     *
     * <code>U_UNION_ALL = 2;</code>
     */
    U_UNION_ALL(2),
    ;

    /**
     * <pre>
     * Unknown support (for forward compatibility)
     * </pre>
     *
     * <code>U_UNKNOWN = 0;</code>
     */
    public static final int U_UNKNOWN_VALUE = 0;
    /**
     * <pre>
     * UNION is supported
     * </pre>
     *
     * <code>U_UNION = 1;</code>
     */
    public static final int U_UNION_VALUE = 1;
    /**
     * <pre>
     * UNION_ALL is supported
     * </pre>
     *
     * <code>U_UNION_ALL = 2;</code>
     */
    public static final int U_UNION_ALL_VALUE = 2;


    public final int getNumber() {
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static UnionSupport valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static UnionSupport forNumber(int value) {
      switch (value) {
        case 0: return U_UNKNOWN;
        case 1: return U_UNION;
        case 2: return U_UNION_ALL;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<UnionSupport>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        UnionSupport> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<UnionSupport>() {
            public UnionSupport findValueByNumber(int number) {
              return UnionSupport.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.getDescriptor().getEnumTypes().get(16);
    }

    private static final UnionSupport[] VALUES = values();

    public static UnionSupport valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private UnionSupport(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:exec.user.UnionSupport)
  }

  public interface PropertyOrBuilder extends
      // @@protoc_insertion_point(interface_extends:exec.user.Property)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>required string key = 1;</code>
     * @return Whether the key field is set.
     */
    boolean hasKey();
    /**
     * <code>required string key = 1;</code>
     * @return The key.
     */
    java.lang.String getKey();
    /**
     * <code>required string key = 1;</code>
     * @return The bytes for key.
     */
    com.google.protobuf.ByteString
        getKeyBytes();

    /**
     * <code>required string value = 2;</code>
     * @return Whether the value field is set.
     */
    boolean hasValue();
    /**
     * <code>required string value = 2;</code>
     * @return The value.
     */
    java.lang.String getValue();
    /**
     * <code>required string value = 2;</code>
     * @return The bytes for value.
     */
    com.google.protobuf.ByteString
        getValueBytes();
  }
  /**
   * Protobuf type {@code exec.user.Property}
   */
  public static final class Property extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:exec.user.Property)
      PropertyOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Property.newBuilder() to construct.
    private Property(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Property() {
      key_ = "";
      value_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new Property();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_Property_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_Property_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.UserProtos.Property.class, org.apache.drill.exec.proto.UserProtos.Property.Builder.class);
    }

    private int bitField0_;
    public static final int KEY_FIELD_NUMBER = 1;
    private volatile java.lang.Object key_;
    /**
     * <code>required string key = 1;</code>
     * @return Whether the key field is set.
     */
    @java.lang.Override
    public boolean hasKey() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>required string key = 1;</code>
     * @return The key.
     */
    @java.lang.Override
    public java.lang.String getKey() {
      java.lang.Object ref = key_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          key_ = s;
        }
        return s;
      }
    }
    /**
     * <code>required string key = 1;</code>
     * @return The bytes for key.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getKeyBytes() {
      java.lang.Object ref = key_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        key_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int VALUE_FIELD_NUMBER = 2;
    private volatile java.lang.Object value_;
    /**
     * <code>required string value = 2;</code>
     * @return Whether the value field is set.
     */
    @java.lang.Override
    public boolean hasValue() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <code>required string value = 2;</code>
     * @return The value.
     */
    @java.lang.Override
    public java.lang.String getValue() {
      java.lang.Object ref = value_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          value_ = s;
        }
        return s;
      }
    }
    /**
     * <code>required string value = 2;</code>
     * @return The bytes for value.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getValueBytes() {
      java.lang.Object ref = value_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        value_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasKey()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasValue()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, key_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, value_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, key_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, value_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.drill.exec.proto.UserProtos.Property)) {
        return super.equals(obj);
      }
      org.apache.drill.exec.proto.UserProtos.Property other = (org.apache.drill.exec.proto.UserProtos.Property) obj;

      if (hasKey() != other.hasKey()) return false;
      if (hasKey()) {
        if (!getKey()
            .equals(other.getKey())) return false;
      }
      if (hasValue() != other.hasValue()) return false;
      if (hasValue()) {
        if (!getValue()
            .equals(other.getValue())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasKey()) {
        hash = (37 * hash) + KEY_FIELD_NUMBER;
        hash = (53 * hash) + getKey().hashCode();
      }
      if (hasValue()) {
        hash = (37 * hash) + VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getValue().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.drill.exec.proto.UserProtos.Property parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.Property parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.Property parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.Property parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.Property parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.Property parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.Property parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.Property parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.Property parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.Property parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.Property parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.Property parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.drill.exec.proto.UserProtos.Property prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code exec.user.Property}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:exec.user.Property)
        org.apache.drill.exec.proto.UserProtos.PropertyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_Property_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_Property_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.UserProtos.Property.class, org.apache.drill.exec.proto.UserProtos.Property.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.UserProtos.Property.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        key_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        value_ = "";
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_Property_descriptor;
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.Property getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.UserProtos.Property.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.Property build() {
        org.apache.drill.exec.proto.UserProtos.Property result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.Property buildPartial() {
        org.apache.drill.exec.proto.UserProtos.Property result = new org.apache.drill.exec.proto.UserProtos.Property(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          to_bitField0_ |= 0x00000001;
        }
        result.key_ = key_;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          to_bitField0_ |= 0x00000002;
        }
        result.value_ = value_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.UserProtos.Property) {
          return mergeFrom((org.apache.drill.exec.proto.UserProtos.Property)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.UserProtos.Property other) {
        if (other == org.apache.drill.exec.proto.UserProtos.Property.getDefaultInstance()) return this;
        if (other.hasKey()) {
          bitField0_ |= 0x00000001;
          key_ = other.key_;
          onChanged();
        }
        if (other.hasValue()) {
          bitField0_ |= 0x00000002;
          value_ = other.value_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (!hasKey()) {
          return false;
        }
        if (!hasValue()) {
          return false;
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                key_ = input.readBytes();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
              case 18: {
                value_ = input.readBytes();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private java.lang.Object key_ = "";
      /**
       * <code>required string key = 1;</code>
       * @return Whether the key field is set.
       */
      public boolean hasKey() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>required string key = 1;</code>
       * @return The key.
       */
      public java.lang.String getKey() {
        java.lang.Object ref = key_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            key_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>required string key = 1;</code>
       * @return The bytes for key.
       */
      public com.google.protobuf.ByteString
          getKeyBytes() {
        java.lang.Object ref = key_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          key_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>required string key = 1;</code>
       * @param value The key to set.
       * @return This builder for chaining.
       */
      public Builder setKey(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        key_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required string key = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearKey() {
        bitField0_ = (bitField0_ & ~0x00000001);
        key_ = getDefaultInstance().getKey();
        onChanged();
        return this;
      }
      /**
       * <code>required string key = 1;</code>
       * @param value The bytes for key to set.
       * @return This builder for chaining.
       */
      public Builder setKeyBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        key_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object value_ = "";
      /**
       * <code>required string value = 2;</code>
       * @return Whether the value field is set.
       */
      public boolean hasValue() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <code>required string value = 2;</code>
       * @return The value.
       */
      public java.lang.String getValue() {
        java.lang.Object ref = value_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            value_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>required string value = 2;</code>
       * @return The bytes for value.
       */
      public com.google.protobuf.ByteString
          getValueBytes() {
        java.lang.Object ref = value_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          value_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>required string value = 2;</code>
       * @param value The value to set.
       * @return This builder for chaining.
       */
      public Builder setValue(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        value_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required string value = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearValue() {
        bitField0_ = (bitField0_ & ~0x00000002);
        value_ = getDefaultInstance().getValue();
        onChanged();
        return this;
      }
      /**
       * <code>required string value = 2;</code>
       * @param value The bytes for value to set.
       * @return This builder for chaining.
       */
      public Builder setValueBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        value_ = value;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:exec.user.Property)
    }

    // @@protoc_insertion_point(class_scope:exec.user.Property)
    private static final org.apache.drill.exec.proto.UserProtos.Property DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.drill.exec.proto.UserProtos.Property();
    }

    public static org.apache.drill.exec.proto.UserProtos.Property getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final com.google.protobuf.Parser<Property>
        PARSER = new com.google.protobuf.AbstractParser<Property>() {
      @java.lang.Override
      public Property parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<Property> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Property> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.drill.exec.proto.UserProtos.Property getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface UserPropertiesOrBuilder extends
      // @@protoc_insertion_point(interface_extends:exec.user.UserProperties)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>repeated .exec.user.Property properties = 1;</code>
     */
    java.util.List<org.apache.drill.exec.proto.UserProtos.Property> 
        getPropertiesList();
    /**
     * <code>repeated .exec.user.Property properties = 1;</code>
     */
    org.apache.drill.exec.proto.UserProtos.Property getProperties(int index);
    /**
     * <code>repeated .exec.user.Property properties = 1;</code>
     */
    int getPropertiesCount();
    /**
     * <code>repeated .exec.user.Property properties = 1;</code>
     */
    java.util.List<? extends org.apache.drill.exec.proto.UserProtos.PropertyOrBuilder> 
        getPropertiesOrBuilderList();
    /**
     * <code>repeated .exec.user.Property properties = 1;</code>
     */
    org.apache.drill.exec.proto.UserProtos.PropertyOrBuilder getPropertiesOrBuilder(
        int index);
  }
  /**
   * Protobuf type {@code exec.user.UserProperties}
   */
  public static final class UserProperties extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:exec.user.UserProperties)
      UserPropertiesOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use UserProperties.newBuilder() to construct.
    private UserProperties(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private UserProperties() {
      properties_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new UserProperties();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_UserProperties_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_UserProperties_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.UserProtos.UserProperties.class, org.apache.drill.exec.proto.UserProtos.UserProperties.Builder.class);
    }

    public static final int PROPERTIES_FIELD_NUMBER = 1;
    private java.util.List<org.apache.drill.exec.proto.UserProtos.Property> properties_;
    /**
     * <code>repeated .exec.user.Property properties = 1;</code>
     */
    @java.lang.Override
    public java.util.List<org.apache.drill.exec.proto.UserProtos.Property> getPropertiesList() {
      return properties_;
    }
    /**
     * <code>repeated .exec.user.Property properties = 1;</code>
     */
    @java.lang.Override
    public java.util.List<? extends org.apache.drill.exec.proto.UserProtos.PropertyOrBuilder> 
        getPropertiesOrBuilderList() {
      return properties_;
    }
    /**
     * <code>repeated .exec.user.Property properties = 1;</code>
     */
    @java.lang.Override
    public int getPropertiesCount() {
      return properties_.size();
    }
    /**
     * <code>repeated .exec.user.Property properties = 1;</code>
     */
    @java.lang.Override
    public org.apache.drill.exec.proto.UserProtos.Property getProperties(int index) {
      return properties_.get(index);
    }
    /**
     * <code>repeated .exec.user.Property properties = 1;</code>
     */
    @java.lang.Override
    public org.apache.drill.exec.proto.UserProtos.PropertyOrBuilder getPropertiesOrBuilder(
        int index) {
      return properties_.get(index);
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      for (int i = 0; i < getPropertiesCount(); i++) {
        if (!getProperties(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      for (int i = 0; i < properties_.size(); i++) {
        output.writeMessage(1, properties_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < properties_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, properties_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.drill.exec.proto.UserProtos.UserProperties)) {
        return super.equals(obj);
      }
      org.apache.drill.exec.proto.UserProtos.UserProperties other = (org.apache.drill.exec.proto.UserProtos.UserProperties) obj;

      if (!getPropertiesList()
          .equals(other.getPropertiesList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getPropertiesCount() > 0) {
        hash = (37 * hash) + PROPERTIES_FIELD_NUMBER;
        hash = (53 * hash) + getPropertiesList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.drill.exec.proto.UserProtos.UserProperties parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.UserProperties parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.UserProperties parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.UserProperties parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.UserProperties parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.UserProperties parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.UserProperties parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.UserProperties parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.UserProperties parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.UserProperties parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.UserProperties parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.UserProperties parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.drill.exec.proto.UserProtos.UserProperties prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code exec.user.UserProperties}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:exec.user.UserProperties)
        org.apache.drill.exec.proto.UserProtos.UserPropertiesOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_UserProperties_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_UserProperties_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.UserProtos.UserProperties.class, org.apache.drill.exec.proto.UserProtos.UserProperties.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.UserProtos.UserProperties.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (propertiesBuilder_ == null) {
          properties_ = java.util.Collections.emptyList();
        } else {
          properties_ = null;
          propertiesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_UserProperties_descriptor;
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.UserProperties getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.UserProtos.UserProperties.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.UserProperties build() {
        org.apache.drill.exec.proto.UserProtos.UserProperties result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.UserProperties buildPartial() {
        org.apache.drill.exec.proto.UserProtos.UserProperties result = new org.apache.drill.exec.proto.UserProtos.UserProperties(this);
        int from_bitField0_ = bitField0_;
        if (propertiesBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            properties_ = java.util.Collections.unmodifiableList(properties_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.properties_ = properties_;
        } else {
          result.properties_ = propertiesBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.UserProtos.UserProperties) {
          return mergeFrom((org.apache.drill.exec.proto.UserProtos.UserProperties)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.UserProtos.UserProperties other) {
        if (other == org.apache.drill.exec.proto.UserProtos.UserProperties.getDefaultInstance()) return this;
        if (propertiesBuilder_ == null) {
          if (!other.properties_.isEmpty()) {
            if (properties_.isEmpty()) {
              properties_ = other.properties_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensurePropertiesIsMutable();
              properties_.addAll(other.properties_);
            }
            onChanged();
          }
        } else {
          if (!other.properties_.isEmpty()) {
            if (propertiesBuilder_.isEmpty()) {
              propertiesBuilder_.dispose();
              propertiesBuilder_ = null;
              properties_ = other.properties_;
              bitField0_ = (bitField0_ & ~0x00000001);
              propertiesBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getPropertiesFieldBuilder() : null;
            } else {
              propertiesBuilder_.addAllMessages(other.properties_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        for (int i = 0; i < getPropertiesCount(); i++) {
          if (!getProperties(i).isInitialized()) {
            return false;
          }
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                org.apache.drill.exec.proto.UserProtos.Property m =
                    input.readMessage(
                        org.apache.drill.exec.proto.UserProtos.Property.PARSER,
                        extensionRegistry);
                if (propertiesBuilder_ == null) {
                  ensurePropertiesIsMutable();
                  properties_.add(m);
                } else {
                  propertiesBuilder_.addMessage(m);
                }
                break;
              } // case 10
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private java.util.List<org.apache.drill.exec.proto.UserProtos.Property> properties_ =
        java.util.Collections.emptyList();
      private void ensurePropertiesIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          properties_ = new java.util.ArrayList<org.apache.drill.exec.proto.UserProtos.Property>(properties_);
          bitField0_ |= 0x00000001;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          org.apache.drill.exec.proto.UserProtos.Property, org.apache.drill.exec.proto.UserProtos.Property.Builder, org.apache.drill.exec.proto.UserProtos.PropertyOrBuilder> propertiesBuilder_;

      /**
       * <code>repeated .exec.user.Property properties = 1;</code>
       */
      public java.util.List<org.apache.drill.exec.proto.UserProtos.Property> getPropertiesList() {
        if (propertiesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(properties_);
        } else {
          return propertiesBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .exec.user.Property properties = 1;</code>
       */
      public int getPropertiesCount() {
        if (propertiesBuilder_ == null) {
          return properties_.size();
        } else {
          return propertiesBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .exec.user.Property properties = 1;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.Property getProperties(int index) {
        if (propertiesBuilder_ == null) {
          return properties_.get(index);
        } else {
          return propertiesBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .exec.user.Property properties = 1;</code>
       */
      public Builder setProperties(
          int index, org.apache.drill.exec.proto.UserProtos.Property value) {
        if (propertiesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePropertiesIsMutable();
          properties_.set(index, value);
          onChanged();
        } else {
          propertiesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.Property properties = 1;</code>
       */
      public Builder setProperties(
          int index, org.apache.drill.exec.proto.UserProtos.Property.Builder builderForValue) {
        if (propertiesBuilder_ == null) {
          ensurePropertiesIsMutable();
          properties_.set(index, builderForValue.build());
          onChanged();
        } else {
          propertiesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.Property properties = 1;</code>
       */
      public Builder addProperties(org.apache.drill.exec.proto.UserProtos.Property value) {
        if (propertiesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePropertiesIsMutable();
          properties_.add(value);
          onChanged();
        } else {
          propertiesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.Property properties = 1;</code>
       */
      public Builder addProperties(
          int index, org.apache.drill.exec.proto.UserProtos.Property value) {
        if (propertiesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePropertiesIsMutable();
          properties_.add(index, value);
          onChanged();
        } else {
          propertiesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.Property properties = 1;</code>
       */
      public Builder addProperties(
          org.apache.drill.exec.proto.UserProtos.Property.Builder builderForValue) {
        if (propertiesBuilder_ == null) {
          ensurePropertiesIsMutable();
          properties_.add(builderForValue.build());
          onChanged();
        } else {
          propertiesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.Property properties = 1;</code>
       */
      public Builder addProperties(
          int index, org.apache.drill.exec.proto.UserProtos.Property.Builder builderForValue) {
        if (propertiesBuilder_ == null) {
          ensurePropertiesIsMutable();
          properties_.add(index, builderForValue.build());
          onChanged();
        } else {
          propertiesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.Property properties = 1;</code>
       */
      public Builder addAllProperties(
          java.lang.Iterable<? extends org.apache.drill.exec.proto.UserProtos.Property> values) {
        if (propertiesBuilder_ == null) {
          ensurePropertiesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, properties_);
          onChanged();
        } else {
          propertiesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.Property properties = 1;</code>
       */
      public Builder clearProperties() {
        if (propertiesBuilder_ == null) {
          properties_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          propertiesBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.Property properties = 1;</code>
       */
      public Builder removeProperties(int index) {
        if (propertiesBuilder_ == null) {
          ensurePropertiesIsMutable();
          properties_.remove(index);
          onChanged();
        } else {
          propertiesBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.Property properties = 1;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.Property.Builder getPropertiesBuilder(
          int index) {
        return getPropertiesFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .exec.user.Property properties = 1;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.PropertyOrBuilder getPropertiesOrBuilder(
          int index) {
        if (propertiesBuilder_ == null) {
          return properties_.get(index);  } else {
          return propertiesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .exec.user.Property properties = 1;</code>
       */
      public java.util.List<? extends org.apache.drill.exec.proto.UserProtos.PropertyOrBuilder> 
           getPropertiesOrBuilderList() {
        if (propertiesBuilder_ != null) {
          return propertiesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(properties_);
        }
      }
      /**
       * <code>repeated .exec.user.Property properties = 1;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.Property.Builder addPropertiesBuilder() {
        return getPropertiesFieldBuilder().addBuilder(
            org.apache.drill.exec.proto.UserProtos.Property.getDefaultInstance());
      }
      /**
       * <code>repeated .exec.user.Property properties = 1;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.Property.Builder addPropertiesBuilder(
          int index) {
        return getPropertiesFieldBuilder().addBuilder(
            index, org.apache.drill.exec.proto.UserProtos.Property.getDefaultInstance());
      }
      /**
       * <code>repeated .exec.user.Property properties = 1;</code>
       */
      public java.util.List<org.apache.drill.exec.proto.UserProtos.Property.Builder> 
           getPropertiesBuilderList() {
        return getPropertiesFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          org.apache.drill.exec.proto.UserProtos.Property, org.apache.drill.exec.proto.UserProtos.Property.Builder, org.apache.drill.exec.proto.UserProtos.PropertyOrBuilder> 
          getPropertiesFieldBuilder() {
        if (propertiesBuilder_ == null) {
          propertiesBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              org.apache.drill.exec.proto.UserProtos.Property, org.apache.drill.exec.proto.UserProtos.Property.Builder, org.apache.drill.exec.proto.UserProtos.PropertyOrBuilder>(
                  properties_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          properties_ = null;
        }
        return propertiesBuilder_;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:exec.user.UserProperties)
    }

    // @@protoc_insertion_point(class_scope:exec.user.UserProperties)
    private static final org.apache.drill.exec.proto.UserProtos.UserProperties DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.drill.exec.proto.UserProtos.UserProperties();
    }

    public static org.apache.drill.exec.proto.UserProtos.UserProperties getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final com.google.protobuf.Parser<UserProperties>
        PARSER = new com.google.protobuf.AbstractParser<UserProperties>() {
      @java.lang.Override
      public UserProperties parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<UserProperties> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<UserProperties> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.drill.exec.proto.UserProtos.UserProperties getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface RpcEndpointInfosOrBuilder extends
      // @@protoc_insertion_point(interface_extends:exec.user.RpcEndpointInfos)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * example: Apache Drill Server, Apache Drill C++ client
     * </pre>
     *
     * <code>optional string name = 1;</code>
     * @return Whether the name field is set.
     */
    boolean hasName();
    /**
     * <pre>
     * example: Apache Drill Server, Apache Drill C++ client
     * </pre>
     *
     * <code>optional string name = 1;</code>
     * @return The name.
     */
    java.lang.String getName();
    /**
     * <pre>
     * example: Apache Drill Server, Apache Drill C++ client
     * </pre>
     *
     * <code>optional string name = 1;</code>
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString
        getNameBytes();

    /**
     * <pre>
     * example: 1.9.0
     * </pre>
     *
     * <code>optional string version = 2;</code>
     * @return Whether the version field is set.
     */
    boolean hasVersion();
    /**
     * <pre>
     * example: 1.9.0
     * </pre>
     *
     * <code>optional string version = 2;</code>
     * @return The version.
     */
    java.lang.String getVersion();
    /**
     * <pre>
     * example: 1.9.0
     * </pre>
     *
     * <code>optional string version = 2;</code>
     * @return The bytes for version.
     */
    com.google.protobuf.ByteString
        getVersionBytes();

    /**
     * <pre>
     * example: 1
     * </pre>
     *
     * <code>optional uint32 majorVersion = 3;</code>
     * @return Whether the majorVersion field is set.
     */
    boolean hasMajorVersion();
    /**
     * <pre>
     * example: 1
     * </pre>
     *
     * <code>optional uint32 majorVersion = 3;</code>
     * @return The majorVersion.
     */
    int getMajorVersion();

    /**
     * <pre>
     * example: 9
     * </pre>
     *
     * <code>optional uint32 minorVersion = 4;</code>
     * @return Whether the minorVersion field is set.
     */
    boolean hasMinorVersion();
    /**
     * <pre>
     * example: 9
     * </pre>
     *
     * <code>optional uint32 minorVersion = 4;</code>
     * @return The minorVersion.
     */
    int getMinorVersion();

    /**
     * <pre>
     * example: 0
     * </pre>
     *
     * <code>optional uint32 patchVersion = 5;</code>
     * @return Whether the patchVersion field is set.
     */
    boolean hasPatchVersion();
    /**
     * <pre>
     * example: 0
     * </pre>
     *
     * <code>optional uint32 patchVersion = 5;</code>
     * @return The patchVersion.
     */
    int getPatchVersion();

    /**
     * <pre>
     * example: Tableau 9.3
     * </pre>
     *
     * <code>optional string application = 6;</code>
     * @return Whether the application field is set.
     */
    boolean hasApplication();
    /**
     * <pre>
     * example: Tableau 9.3
     * </pre>
     *
     * <code>optional string application = 6;</code>
     * @return The application.
     */
    java.lang.String getApplication();
    /**
     * <pre>
     * example: Tableau 9.3
     * </pre>
     *
     * <code>optional string application = 6;</code>
     * @return The bytes for application.
     */
    com.google.protobuf.ByteString
        getApplicationBytes();

    /**
     * <pre>
     * example: 32
     * </pre>
     *
     * <code>optional uint32 buildNumber = 7;</code>
     * @return Whether the buildNumber field is set.
     */
    boolean hasBuildNumber();
    /**
     * <pre>
     * example: 32
     * </pre>
     *
     * <code>optional uint32 buildNumber = 7;</code>
     * @return The buildNumber.
     */
    int getBuildNumber();

    /**
     * <pre>
     * example: SNAPSHOT
     * </pre>
     *
     * <code>optional string versionQualifier = 8;</code>
     * @return Whether the versionQualifier field is set.
     */
    boolean hasVersionQualifier();
    /**
     * <pre>
     * example: SNAPSHOT
     * </pre>
     *
     * <code>optional string versionQualifier = 8;</code>
     * @return The versionQualifier.
     */
    java.lang.String getVersionQualifier();
    /**
     * <pre>
     * example: SNAPSHOT
     * </pre>
     *
     * <code>optional string versionQualifier = 8;</code>
     * @return The bytes for versionQualifier.
     */
    com.google.protobuf.ByteString
        getVersionQualifierBytes();
  }
  /**
   * Protobuf type {@code exec.user.RpcEndpointInfos}
   */
  public static final class RpcEndpointInfos extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:exec.user.RpcEndpointInfos)
      RpcEndpointInfosOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use RpcEndpointInfos.newBuilder() to construct.
    private RpcEndpointInfos(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private RpcEndpointInfos() {
      name_ = "";
      version_ = "";
      application_ = "";
      versionQualifier_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new RpcEndpointInfos();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_RpcEndpointInfos_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_RpcEndpointInfos_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos.class, org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos.Builder.class);
    }

    private int bitField0_;
    public static final int NAME_FIELD_NUMBER = 1;
    private volatile java.lang.Object name_;
    /**
     * <pre>
     * example: Apache Drill Server, Apache Drill C++ client
     * </pre>
     *
     * <code>optional string name = 1;</code>
     * @return Whether the name field is set.
     */
    @java.lang.Override
    public boolean hasName() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * example: Apache Drill Server, Apache Drill C++ client
     * </pre>
     *
     * <code>optional string name = 1;</code>
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          name_ = s;
        }
        return s;
      }
    }
    /**
     * <pre>
     * example: Apache Drill Server, Apache Drill C++ client
     * </pre>
     *
     * <code>optional string name = 1;</code>
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int VERSION_FIELD_NUMBER = 2;
    private volatile java.lang.Object version_;
    /**
     * <pre>
     * example: 1.9.0
     * </pre>
     *
     * <code>optional string version = 2;</code>
     * @return Whether the version field is set.
     */
    @java.lang.Override
    public boolean hasVersion() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <pre>
     * example: 1.9.0
     * </pre>
     *
     * <code>optional string version = 2;</code>
     * @return The version.
     */
    @java.lang.Override
    public java.lang.String getVersion() {
      java.lang.Object ref = version_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          version_ = s;
        }
        return s;
      }
    }
    /**
     * <pre>
     * example: 1.9.0
     * </pre>
     *
     * <code>optional string version = 2;</code>
     * @return The bytes for version.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getVersionBytes() {
      java.lang.Object ref = version_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        version_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int MAJORVERSION_FIELD_NUMBER = 3;
    private int majorVersion_;
    /**
     * <pre>
     * example: 1
     * </pre>
     *
     * <code>optional uint32 majorVersion = 3;</code>
     * @return Whether the majorVersion field is set.
     */
    @java.lang.Override
    public boolean hasMajorVersion() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <pre>
     * example: 1
     * </pre>
     *
     * <code>optional uint32 majorVersion = 3;</code>
     * @return The majorVersion.
     */
    @java.lang.Override
    public int getMajorVersion() {
      return majorVersion_;
    }

    public static final int MINORVERSION_FIELD_NUMBER = 4;
    private int minorVersion_;
    /**
     * <pre>
     * example: 9
     * </pre>
     *
     * <code>optional uint32 minorVersion = 4;</code>
     * @return Whether the minorVersion field is set.
     */
    @java.lang.Override
    public boolean hasMinorVersion() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     * <pre>
     * example: 9
     * </pre>
     *
     * <code>optional uint32 minorVersion = 4;</code>
     * @return The minorVersion.
     */
    @java.lang.Override
    public int getMinorVersion() {
      return minorVersion_;
    }

    public static final int PATCHVERSION_FIELD_NUMBER = 5;
    private int patchVersion_;
    /**
     * <pre>
     * example: 0
     * </pre>
     *
     * <code>optional uint32 patchVersion = 5;</code>
     * @return Whether the patchVersion field is set.
     */
    @java.lang.Override
    public boolean hasPatchVersion() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     * <pre>
     * example: 0
     * </pre>
     *
     * <code>optional uint32 patchVersion = 5;</code>
     * @return The patchVersion.
     */
    @java.lang.Override
    public int getPatchVersion() {
      return patchVersion_;
    }

    public static final int APPLICATION_FIELD_NUMBER = 6;
    private volatile java.lang.Object application_;
    /**
     * <pre>
     * example: Tableau 9.3
     * </pre>
     *
     * <code>optional string application = 6;</code>
     * @return Whether the application field is set.
     */
    @java.lang.Override
    public boolean hasApplication() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     * <pre>
     * example: Tableau 9.3
     * </pre>
     *
     * <code>optional string application = 6;</code>
     * @return The application.
     */
    @java.lang.Override
    public java.lang.String getApplication() {
      java.lang.Object ref = application_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          application_ = s;
        }
        return s;
      }
    }
    /**
     * <pre>
     * example: Tableau 9.3
     * </pre>
     *
     * <code>optional string application = 6;</code>
     * @return The bytes for application.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getApplicationBytes() {
      java.lang.Object ref = application_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        application_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int BUILDNUMBER_FIELD_NUMBER = 7;
    private int buildNumber_;
    /**
     * <pre>
     * example: 32
     * </pre>
     *
     * <code>optional uint32 buildNumber = 7;</code>
     * @return Whether the buildNumber field is set.
     */
    @java.lang.Override
    public boolean hasBuildNumber() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     * <pre>
     * example: 32
     * </pre>
     *
     * <code>optional uint32 buildNumber = 7;</code>
     * @return The buildNumber.
     */
    @java.lang.Override
    public int getBuildNumber() {
      return buildNumber_;
    }

    public static final int VERSIONQUALIFIER_FIELD_NUMBER = 8;
    private volatile java.lang.Object versionQualifier_;
    /**
     * <pre>
     * example: SNAPSHOT
     * </pre>
     *
     * <code>optional string versionQualifier = 8;</code>
     * @return Whether the versionQualifier field is set.
     */
    @java.lang.Override
    public boolean hasVersionQualifier() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     * <pre>
     * example: SNAPSHOT
     * </pre>
     *
     * <code>optional string versionQualifier = 8;</code>
     * @return The versionQualifier.
     */
    @java.lang.Override
    public java.lang.String getVersionQualifier() {
      java.lang.Object ref = versionQualifier_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          versionQualifier_ = s;
        }
        return s;
      }
    }
    /**
     * <pre>
     * example: SNAPSHOT
     * </pre>
     *
     * <code>optional string versionQualifier = 8;</code>
     * @return The bytes for versionQualifier.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getVersionQualifierBytes() {
      java.lang.Object ref = versionQualifier_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        versionQualifier_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, version_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeUInt32(3, majorVersion_);
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        output.writeUInt32(4, minorVersion_);
      }
      if (((bitField0_ & 0x00000010) != 0)) {
        output.writeUInt32(5, patchVersion_);
      }
      if (((bitField0_ & 0x00000020) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 6, application_);
      }
      if (((bitField0_ & 0x00000040) != 0)) {
        output.writeUInt32(7, buildNumber_);
      }
      if (((bitField0_ & 0x00000080) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 8, versionQualifier_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, version_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(3, majorVersion_);
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(4, minorVersion_);
      }
      if (((bitField0_ & 0x00000010) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(5, patchVersion_);
      }
      if (((bitField0_ & 0x00000020) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, application_);
      }
      if (((bitField0_ & 0x00000040) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(7, buildNumber_);
      }
      if (((bitField0_ & 0x00000080) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, versionQualifier_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos)) {
        return super.equals(obj);
      }
      org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos other = (org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos) obj;

      if (hasName() != other.hasName()) return false;
      if (hasName()) {
        if (!getName()
            .equals(other.getName())) return false;
      }
      if (hasVersion() != other.hasVersion()) return false;
      if (hasVersion()) {
        if (!getVersion()
            .equals(other.getVersion())) return false;
      }
      if (hasMajorVersion() != other.hasMajorVersion()) return false;
      if (hasMajorVersion()) {
        if (getMajorVersion()
            != other.getMajorVersion()) return false;
      }
      if (hasMinorVersion() != other.hasMinorVersion()) return false;
      if (hasMinorVersion()) {
        if (getMinorVersion()
            != other.getMinorVersion()) return false;
      }
      if (hasPatchVersion() != other.hasPatchVersion()) return false;
      if (hasPatchVersion()) {
        if (getPatchVersion()
            != other.getPatchVersion()) return false;
      }
      if (hasApplication() != other.hasApplication()) return false;
      if (hasApplication()) {
        if (!getApplication()
            .equals(other.getApplication())) return false;
      }
      if (hasBuildNumber() != other.hasBuildNumber()) return false;
      if (hasBuildNumber()) {
        if (getBuildNumber()
            != other.getBuildNumber()) return false;
      }
      if (hasVersionQualifier() != other.hasVersionQualifier()) return false;
      if (hasVersionQualifier()) {
        if (!getVersionQualifier()
            .equals(other.getVersionQualifier())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasName()) {
        hash = (37 * hash) + NAME_FIELD_NUMBER;
        hash = (53 * hash) + getName().hashCode();
      }
      if (hasVersion()) {
        hash = (37 * hash) + VERSION_FIELD_NUMBER;
        hash = (53 * hash) + getVersion().hashCode();
      }
      if (hasMajorVersion()) {
        hash = (37 * hash) + MAJORVERSION_FIELD_NUMBER;
        hash = (53 * hash) + getMajorVersion();
      }
      if (hasMinorVersion()) {
        hash = (37 * hash) + MINORVERSION_FIELD_NUMBER;
        hash = (53 * hash) + getMinorVersion();
      }
      if (hasPatchVersion()) {
        hash = (37 * hash) + PATCHVERSION_FIELD_NUMBER;
        hash = (53 * hash) + getPatchVersion();
      }
      if (hasApplication()) {
        hash = (37 * hash) + APPLICATION_FIELD_NUMBER;
        hash = (53 * hash) + getApplication().hashCode();
      }
      if (hasBuildNumber()) {
        hash = (37 * hash) + BUILDNUMBER_FIELD_NUMBER;
        hash = (53 * hash) + getBuildNumber();
      }
      if (hasVersionQualifier()) {
        hash = (37 * hash) + VERSIONQUALIFIER_FIELD_NUMBER;
        hash = (53 * hash) + getVersionQualifier().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code exec.user.RpcEndpointInfos}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:exec.user.RpcEndpointInfos)
        org.apache.drill.exec.proto.UserProtos.RpcEndpointInfosOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_RpcEndpointInfos_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_RpcEndpointInfos_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos.class, org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        name_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        version_ = "";
        bitField0_ = (bitField0_ & ~0x00000002);
        majorVersion_ = 0;
        bitField0_ = (bitField0_ & ~0x00000004);
        minorVersion_ = 0;
        bitField0_ = (bitField0_ & ~0x00000008);
        patchVersion_ = 0;
        bitField0_ = (bitField0_ & ~0x00000010);
        application_ = "";
        bitField0_ = (bitField0_ & ~0x00000020);
        buildNumber_ = 0;
        bitField0_ = (bitField0_ & ~0x00000040);
        versionQualifier_ = "";
        bitField0_ = (bitField0_ & ~0x00000080);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_RpcEndpointInfos_descriptor;
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos build() {
        org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos buildPartial() {
        org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos result = new org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          to_bitField0_ |= 0x00000001;
        }
        result.name_ = name_;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          to_bitField0_ |= 0x00000002;
        }
        result.version_ = version_;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.majorVersion_ = majorVersion_;
          to_bitField0_ |= 0x00000004;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.minorVersion_ = minorVersion_;
          to_bitField0_ |= 0x00000008;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.patchVersion_ = patchVersion_;
          to_bitField0_ |= 0x00000010;
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          to_bitField0_ |= 0x00000020;
        }
        result.application_ = application_;
        if (((from_bitField0_ & 0x00000040) != 0)) {
          result.buildNumber_ = buildNumber_;
          to_bitField0_ |= 0x00000040;
        }
        if (((from_bitField0_ & 0x00000080) != 0)) {
          to_bitField0_ |= 0x00000080;
        }
        result.versionQualifier_ = versionQualifier_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos) {
          return mergeFrom((org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos other) {
        if (other == org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos.getDefaultInstance()) return this;
        if (other.hasName()) {
          bitField0_ |= 0x00000001;
          name_ = other.name_;
          onChanged();
        }
        if (other.hasVersion()) {
          bitField0_ |= 0x00000002;
          version_ = other.version_;
          onChanged();
        }
        if (other.hasMajorVersion()) {
          setMajorVersion(other.getMajorVersion());
        }
        if (other.hasMinorVersion()) {
          setMinorVersion(other.getMinorVersion());
        }
        if (other.hasPatchVersion()) {
          setPatchVersion(other.getPatchVersion());
        }
        if (other.hasApplication()) {
          bitField0_ |= 0x00000020;
          application_ = other.application_;
          onChanged();
        }
        if (other.hasBuildNumber()) {
          setBuildNumber(other.getBuildNumber());
        }
        if (other.hasVersionQualifier()) {
          bitField0_ |= 0x00000080;
          versionQualifier_ = other.versionQualifier_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                name_ = input.readBytes();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
              case 18: {
                version_ = input.readBytes();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
              case 24: {
                majorVersion_ = input.readUInt32();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
              case 32: {
                minorVersion_ = input.readUInt32();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
              case 40: {
                patchVersion_ = input.readUInt32();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
              case 50: {
                application_ = input.readBytes();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
              case 56: {
                buildNumber_ = input.readUInt32();
                bitField0_ |= 0x00000040;
                break;
              } // case 56
              case 66: {
                versionQualifier_ = input.readBytes();
                bitField0_ |= 0x00000080;
                break;
              } // case 66
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private java.lang.Object name_ = "";
      /**
       * <pre>
       * example: Apache Drill Server, Apache Drill C++ client
       * </pre>
       *
       * <code>optional string name = 1;</code>
       * @return Whether the name field is set.
       */
      public boolean hasName() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       * example: Apache Drill Server, Apache Drill C++ client
       * </pre>
       *
       * <code>optional string name = 1;</code>
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            name_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * example: Apache Drill Server, Apache Drill C++ client
       * </pre>
       *
       * <code>optional string name = 1;</code>
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString
          getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * example: Apache Drill Server, Apache Drill C++ client
       * </pre>
       *
       * <code>optional string name = 1;</code>
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        name_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * example: Apache Drill Server, Apache Drill C++ client
       * </pre>
       *
       * <code>optional string name = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearName() {
        bitField0_ = (bitField0_ & ~0x00000001);
        name_ = getDefaultInstance().getName();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * example: Apache Drill Server, Apache Drill C++ client
       * </pre>
       *
       * <code>optional string name = 1;</code>
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        name_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object version_ = "";
      /**
       * <pre>
       * example: 1.9.0
       * </pre>
       *
       * <code>optional string version = 2;</code>
       * @return Whether the version field is set.
       */
      public boolean hasVersion() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <pre>
       * example: 1.9.0
       * </pre>
       *
       * <code>optional string version = 2;</code>
       * @return The version.
       */
      public java.lang.String getVersion() {
        java.lang.Object ref = version_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            version_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * example: 1.9.0
       * </pre>
       *
       * <code>optional string version = 2;</code>
       * @return The bytes for version.
       */
      public com.google.protobuf.ByteString
          getVersionBytes() {
        java.lang.Object ref = version_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          version_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * example: 1.9.0
       * </pre>
       *
       * <code>optional string version = 2;</code>
       * @param value The version to set.
       * @return This builder for chaining.
       */
      public Builder setVersion(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        version_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * example: 1.9.0
       * </pre>
       *
       * <code>optional string version = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearVersion() {
        bitField0_ = (bitField0_ & ~0x00000002);
        version_ = getDefaultInstance().getVersion();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * example: 1.9.0
       * </pre>
       *
       * <code>optional string version = 2;</code>
       * @param value The bytes for version to set.
       * @return This builder for chaining.
       */
      public Builder setVersionBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        version_ = value;
        onChanged();
        return this;
      }

      private int majorVersion_ ;
      /**
       * <pre>
       * example: 1
       * </pre>
       *
       * <code>optional uint32 majorVersion = 3;</code>
       * @return Whether the majorVersion field is set.
       */
      @java.lang.Override
      public boolean hasMajorVersion() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <pre>
       * example: 1
       * </pre>
       *
       * <code>optional uint32 majorVersion = 3;</code>
       * @return The majorVersion.
       */
      @java.lang.Override
      public int getMajorVersion() {
        return majorVersion_;
      }
      /**
       * <pre>
       * example: 1
       * </pre>
       *
       * <code>optional uint32 majorVersion = 3;</code>
       * @param value The majorVersion to set.
       * @return This builder for chaining.
       */
      public Builder setMajorVersion(int value) {
        bitField0_ |= 0x00000004;
        majorVersion_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * example: 1
       * </pre>
       *
       * <code>optional uint32 majorVersion = 3;</code>
       * @return This builder for chaining.
       */
      public Builder clearMajorVersion() {
        bitField0_ = (bitField0_ & ~0x00000004);
        majorVersion_ = 0;
        onChanged();
        return this;
      }

      private int minorVersion_ ;
      /**
       * <pre>
       * example: 9
       * </pre>
       *
       * <code>optional uint32 minorVersion = 4;</code>
       * @return Whether the minorVersion field is set.
       */
      @java.lang.Override
      public boolean hasMinorVersion() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       * <pre>
       * example: 9
       * </pre>
       *
       * <code>optional uint32 minorVersion = 4;</code>
       * @return The minorVersion.
       */
      @java.lang.Override
      public int getMinorVersion() {
        return minorVersion_;
      }
      /**
       * <pre>
       * example: 9
       * </pre>
       *
       * <code>optional uint32 minorVersion = 4;</code>
       * @param value The minorVersion to set.
       * @return This builder for chaining.
       */
      public Builder setMinorVersion(int value) {
        bitField0_ |= 0x00000008;
        minorVersion_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * example: 9
       * </pre>
       *
       * <code>optional uint32 minorVersion = 4;</code>
       * @return This builder for chaining.
       */
      public Builder clearMinorVersion() {
        bitField0_ = (bitField0_ & ~0x00000008);
        minorVersion_ = 0;
        onChanged();
        return this;
      }

      private int patchVersion_ ;
      /**
       * <pre>
       * example: 0
       * </pre>
       *
       * <code>optional uint32 patchVersion = 5;</code>
       * @return Whether the patchVersion field is set.
       */
      @java.lang.Override
      public boolean hasPatchVersion() {
        return ((bitField0_ & 0x00000010) != 0);
      }
      /**
       * <pre>
       * example: 0
       * </pre>
       *
       * <code>optional uint32 patchVersion = 5;</code>
       * @return The patchVersion.
       */
      @java.lang.Override
      public int getPatchVersion() {
        return patchVersion_;
      }
      /**
       * <pre>
       * example: 0
       * </pre>
       *
       * <code>optional uint32 patchVersion = 5;</code>
       * @param value The patchVersion to set.
       * @return This builder for chaining.
       */
      public Builder setPatchVersion(int value) {
        bitField0_ |= 0x00000010;
        patchVersion_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * example: 0
       * </pre>
       *
       * <code>optional uint32 patchVersion = 5;</code>
       * @return This builder for chaining.
       */
      public Builder clearPatchVersion() {
        bitField0_ = (bitField0_ & ~0x00000010);
        patchVersion_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object application_ = "";
      /**
       * <pre>
       * example: Tableau 9.3
       * </pre>
       *
       * <code>optional string application = 6;</code>
       * @return Whether the application field is set.
       */
      public boolean hasApplication() {
        return ((bitField0_ & 0x00000020) != 0);
      }
      /**
       * <pre>
       * example: Tableau 9.3
       * </pre>
       *
       * <code>optional string application = 6;</code>
       * @return The application.
       */
      public java.lang.String getApplication() {
        java.lang.Object ref = application_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            application_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * example: Tableau 9.3
       * </pre>
       *
       * <code>optional string application = 6;</code>
       * @return The bytes for application.
       */
      public com.google.protobuf.ByteString
          getApplicationBytes() {
        java.lang.Object ref = application_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          application_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * example: Tableau 9.3
       * </pre>
       *
       * <code>optional string application = 6;</code>
       * @param value The application to set.
       * @return This builder for chaining.
       */
      public Builder setApplication(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000020;
        application_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * example: Tableau 9.3
       * </pre>
       *
       * <code>optional string application = 6;</code>
       * @return This builder for chaining.
       */
      public Builder clearApplication() {
        bitField0_ = (bitField0_ & ~0x00000020);
        application_ = getDefaultInstance().getApplication();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * example: Tableau 9.3
       * </pre>
       *
       * <code>optional string application = 6;</code>
       * @param value The bytes for application to set.
       * @return This builder for chaining.
       */
      public Builder setApplicationBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000020;
        application_ = value;
        onChanged();
        return this;
      }

      private int buildNumber_ ;
      /**
       * <pre>
       * example: 32
       * </pre>
       *
       * <code>optional uint32 buildNumber = 7;</code>
       * @return Whether the buildNumber field is set.
       */
      @java.lang.Override
      public boolean hasBuildNumber() {
        return ((bitField0_ & 0x00000040) != 0);
      }
      /**
       * <pre>
       * example: 32
       * </pre>
       *
       * <code>optional uint32 buildNumber = 7;</code>
       * @return The buildNumber.
       */
      @java.lang.Override
      public int getBuildNumber() {
        return buildNumber_;
      }
      /**
       * <pre>
       * example: 32
       * </pre>
       *
       * <code>optional uint32 buildNumber = 7;</code>
       * @param value The buildNumber to set.
       * @return This builder for chaining.
       */
      public Builder setBuildNumber(int value) {
        bitField0_ |= 0x00000040;
        buildNumber_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * example: 32
       * </pre>
       *
       * <code>optional uint32 buildNumber = 7;</code>
       * @return This builder for chaining.
       */
      public Builder clearBuildNumber() {
        bitField0_ = (bitField0_ & ~0x00000040);
        buildNumber_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object versionQualifier_ = "";
      /**
       * <pre>
       * example: SNAPSHOT
       * </pre>
       *
       * <code>optional string versionQualifier = 8;</code>
       * @return Whether the versionQualifier field is set.
       */
      public boolean hasVersionQualifier() {
        return ((bitField0_ & 0x00000080) != 0);
      }
      /**
       * <pre>
       * example: SNAPSHOT
       * </pre>
       *
       * <code>optional string versionQualifier = 8;</code>
       * @return The versionQualifier.
       */
      public java.lang.String getVersionQualifier() {
        java.lang.Object ref = versionQualifier_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            versionQualifier_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * example: SNAPSHOT
       * </pre>
       *
       * <code>optional string versionQualifier = 8;</code>
       * @return The bytes for versionQualifier.
       */
      public com.google.protobuf.ByteString
          getVersionQualifierBytes() {
        java.lang.Object ref = versionQualifier_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          versionQualifier_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * example: SNAPSHOT
       * </pre>
       *
       * <code>optional string versionQualifier = 8;</code>
       * @param value The versionQualifier to set.
       * @return This builder for chaining.
       */
      public Builder setVersionQualifier(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000080;
        versionQualifier_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * example: SNAPSHOT
       * </pre>
       *
       * <code>optional string versionQualifier = 8;</code>
       * @return This builder for chaining.
       */
      public Builder clearVersionQualifier() {
        bitField0_ = (bitField0_ & ~0x00000080);
        versionQualifier_ = getDefaultInstance().getVersionQualifier();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * example: SNAPSHOT
       * </pre>
       *
       * <code>optional string versionQualifier = 8;</code>
       * @param value The bytes for versionQualifier to set.
       * @return This builder for chaining.
       */
      public Builder setVersionQualifierBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000080;
        versionQualifier_ = value;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:exec.user.RpcEndpointInfos)
    }

    // @@protoc_insertion_point(class_scope:exec.user.RpcEndpointInfos)
    private static final org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos();
    }

    public static org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final com.google.protobuf.Parser<RpcEndpointInfos>
        PARSER = new com.google.protobuf.AbstractParser<RpcEndpointInfos>() {
      @java.lang.Override
      public RpcEndpointInfos parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<RpcEndpointInfos> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<RpcEndpointInfos> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface UserToBitHandshakeOrBuilder extends
      // @@protoc_insertion_point(interface_extends:exec.user.UserToBitHandshake)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>optional .exec.shared.RpcChannel channel = 1 [default = USER];</code>
     * @return Whether the channel field is set.
     */
    boolean hasChannel();
    /**
     * <code>optional .exec.shared.RpcChannel channel = 1 [default = USER];</code>
     * @return The channel.
     */
    org.apache.drill.exec.proto.UserBitShared.RpcChannel getChannel();

    /**
     * <code>optional bool support_listening = 2;</code>
     * @return Whether the supportListening field is set.
     */
    boolean hasSupportListening();
    /**
     * <code>optional bool support_listening = 2;</code>
     * @return The supportListening.
     */
    boolean getSupportListening();

    /**
     * <code>optional int32 rpc_version = 3;</code>
     * @return Whether the rpcVersion field is set.
     */
    boolean hasRpcVersion();
    /**
     * <code>optional int32 rpc_version = 3;</code>
     * @return The rpcVersion.
     */
    int getRpcVersion();

    /**
     * <code>optional .exec.shared.UserCredentials credentials = 4;</code>
     * @return Whether the credentials field is set.
     */
    boolean hasCredentials();
    /**
     * <code>optional .exec.shared.UserCredentials credentials = 4;</code>
     * @return The credentials.
     */
    org.apache.drill.exec.proto.UserBitShared.UserCredentials getCredentials();
    /**
     * <code>optional .exec.shared.UserCredentials credentials = 4;</code>
     */
    org.apache.drill.exec.proto.UserBitShared.UserCredentialsOrBuilder getCredentialsOrBuilder();

    /**
     * <code>optional .exec.user.UserProperties properties = 5;</code>
     * @return Whether the properties field is set.
     */
    boolean hasProperties();
    /**
     * <code>optional .exec.user.UserProperties properties = 5;</code>
     * @return The properties.
     */
    org.apache.drill.exec.proto.UserProtos.UserProperties getProperties();
    /**
     * <code>optional .exec.user.UserProperties properties = 5;</code>
     */
    org.apache.drill.exec.proto.UserProtos.UserPropertiesOrBuilder getPropertiesOrBuilder();

    /**
     * <code>optional bool support_complex_types = 6 [default = false];</code>
     * @return Whether the supportComplexTypes field is set.
     */
    boolean hasSupportComplexTypes();
    /**
     * <code>optional bool support_complex_types = 6 [default = false];</code>
     * @return The supportComplexTypes.
     */
    boolean getSupportComplexTypes();

    /**
     * <code>optional bool support_timeout = 7 [default = false];</code>
     * @return Whether the supportTimeout field is set.
     */
    boolean hasSupportTimeout();
    /**
     * <code>optional bool support_timeout = 7 [default = false];</code>
     * @return The supportTimeout.
     */
    boolean getSupportTimeout();

    /**
     * <code>optional .exec.user.RpcEndpointInfos client_infos = 8;</code>
     * @return Whether the clientInfos field is set.
     */
    boolean hasClientInfos();
    /**
     * <code>optional .exec.user.RpcEndpointInfos client_infos = 8;</code>
     * @return The clientInfos.
     */
    org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos getClientInfos();
    /**
     * <code>optional .exec.user.RpcEndpointInfos client_infos = 8;</code>
     */
    org.apache.drill.exec.proto.UserProtos.RpcEndpointInfosOrBuilder getClientInfosOrBuilder();

    /**
     * <code>optional .exec.user.SaslSupport sasl_support = 9;</code>
     * @return Whether the saslSupport field is set.
     */
    boolean hasSaslSupport();
    /**
     * <code>optional .exec.user.SaslSupport sasl_support = 9;</code>
     * @return The saslSupport.
     */
    org.apache.drill.exec.proto.UserProtos.SaslSupport getSaslSupport();
  }
  /**
   * Protobuf type {@code exec.user.UserToBitHandshake}
   */
  public static final class UserToBitHandshake extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:exec.user.UserToBitHandshake)
      UserToBitHandshakeOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use UserToBitHandshake.newBuilder() to construct.
    private UserToBitHandshake(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private UserToBitHandshake() {
      channel_ = 2;
      saslSupport_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new UserToBitHandshake();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_UserToBitHandshake_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_UserToBitHandshake_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.UserProtos.UserToBitHandshake.class, org.apache.drill.exec.proto.UserProtos.UserToBitHandshake.Builder.class);
    }

    private int bitField0_;
    public static final int CHANNEL_FIELD_NUMBER = 1;
    private int channel_;
    /**
     * <code>optional .exec.shared.RpcChannel channel = 1 [default = USER];</code>
     * @return Whether the channel field is set.
     */
    @java.lang.Override public boolean hasChannel() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>optional .exec.shared.RpcChannel channel = 1 [default = USER];</code>
     * @return The channel.
     */
    @java.lang.Override public org.apache.drill.exec.proto.UserBitShared.RpcChannel getChannel() {
      @SuppressWarnings("deprecation")
      org.apache.drill.exec.proto.UserBitShared.RpcChannel result = org.apache.drill.exec.proto.UserBitShared.RpcChannel.valueOf(channel_);
      return result == null ? org.apache.drill.exec.proto.UserBitShared.RpcChannel.USER : result;
    }

    public static final int SUPPORT_LISTENING_FIELD_NUMBER = 2;
    private boolean supportListening_;
    /**
     * <code>optional bool support_listening = 2;</code>
     * @return Whether the supportListening field is set.
     */
    @java.lang.Override
    public boolean hasSupportListening() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <code>optional bool support_listening = 2;</code>
     * @return The supportListening.
     */
    @java.lang.Override
    public boolean getSupportListening() {
      return supportListening_;
    }

    public static final int RPC_VERSION_FIELD_NUMBER = 3;
    private int rpcVersion_;
    /**
     * <code>optional int32 rpc_version = 3;</code>
     * @return Whether the rpcVersion field is set.
     */
    @java.lang.Override
    public boolean hasRpcVersion() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <code>optional int32 rpc_version = 3;</code>
     * @return The rpcVersion.
     */
    @java.lang.Override
    public int getRpcVersion() {
      return rpcVersion_;
    }

    public static final int CREDENTIALS_FIELD_NUMBER = 4;
    private org.apache.drill.exec.proto.UserBitShared.UserCredentials credentials_;
    /**
     * <code>optional .exec.shared.UserCredentials credentials = 4;</code>
     * @return Whether the credentials field is set.
     */
    @java.lang.Override
    public boolean hasCredentials() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     * <code>optional .exec.shared.UserCredentials credentials = 4;</code>
     * @return The credentials.
     */
    @java.lang.Override
    public org.apache.drill.exec.proto.UserBitShared.UserCredentials getCredentials() {
      return credentials_ == null ? org.apache.drill.exec.proto.UserBitShared.UserCredentials.getDefaultInstance() : credentials_;
    }
    /**
     * <code>optional .exec.shared.UserCredentials credentials = 4;</code>
     */
    @java.lang.Override
    public org.apache.drill.exec.proto.UserBitShared.UserCredentialsOrBuilder getCredentialsOrBuilder() {
      return credentials_ == null ? org.apache.drill.exec.proto.UserBitShared.UserCredentials.getDefaultInstance() : credentials_;
    }

    public static final int PROPERTIES_FIELD_NUMBER = 5;
    private org.apache.drill.exec.proto.UserProtos.UserProperties properties_;
    /**
     * <code>optional .exec.user.UserProperties properties = 5;</code>
     * @return Whether the properties field is set.
     */
    @java.lang.Override
    public boolean hasProperties() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     * <code>optional .exec.user.UserProperties properties = 5;</code>
     * @return The properties.
     */
    @java.lang.Override
    public org.apache.drill.exec.proto.UserProtos.UserProperties getProperties() {
      return properties_ == null ? org.apache.drill.exec.proto.UserProtos.UserProperties.getDefaultInstance() : properties_;
    }
    /**
     * <code>optional .exec.user.UserProperties properties = 5;</code>
     */
    @java.lang.Override
    public org.apache.drill.exec.proto.UserProtos.UserPropertiesOrBuilder getPropertiesOrBuilder() {
      return properties_ == null ? org.apache.drill.exec.proto.UserProtos.UserProperties.getDefaultInstance() : properties_;
    }

    public static final int SUPPORT_COMPLEX_TYPES_FIELD_NUMBER = 6;
    private boolean supportComplexTypes_;
    /**
     * <code>optional bool support_complex_types = 6 [default = false];</code>
     * @return Whether the supportComplexTypes field is set.
     */
    @java.lang.Override
    public boolean hasSupportComplexTypes() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     * <code>optional bool support_complex_types = 6 [default = false];</code>
     * @return The supportComplexTypes.
     */
    @java.lang.Override
    public boolean getSupportComplexTypes() {
      return supportComplexTypes_;
    }

    public static final int SUPPORT_TIMEOUT_FIELD_NUMBER = 7;
    private boolean supportTimeout_;
    /**
     * <code>optional bool support_timeout = 7 [default = false];</code>
     * @return Whether the supportTimeout field is set.
     */
    @java.lang.Override
    public boolean hasSupportTimeout() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     * <code>optional bool support_timeout = 7 [default = false];</code>
     * @return The supportTimeout.
     */
    @java.lang.Override
    public boolean getSupportTimeout() {
      return supportTimeout_;
    }

    public static final int CLIENT_INFOS_FIELD_NUMBER = 8;
    private org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos clientInfos_;
    /**
     * <code>optional .exec.user.RpcEndpointInfos client_infos = 8;</code>
     * @return Whether the clientInfos field is set.
     */
    @java.lang.Override
    public boolean hasClientInfos() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     * <code>optional .exec.user.RpcEndpointInfos client_infos = 8;</code>
     * @return The clientInfos.
     */
    @java.lang.Override
    public org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos getClientInfos() {
      return clientInfos_ == null ? org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos.getDefaultInstance() : clientInfos_;
    }
    /**
     * <code>optional .exec.user.RpcEndpointInfos client_infos = 8;</code>
     */
    @java.lang.Override
    public org.apache.drill.exec.proto.UserProtos.RpcEndpointInfosOrBuilder getClientInfosOrBuilder() {
      return clientInfos_ == null ? org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos.getDefaultInstance() : clientInfos_;
    }

    public static final int SASL_SUPPORT_FIELD_NUMBER = 9;
    private int saslSupport_;
    /**
     * <code>optional .exec.user.SaslSupport sasl_support = 9;</code>
     * @return Whether the saslSupport field is set.
     */
    @java.lang.Override public boolean hasSaslSupport() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     * <code>optional .exec.user.SaslSupport sasl_support = 9;</code>
     * @return The saslSupport.
     */
    @java.lang.Override public org.apache.drill.exec.proto.UserProtos.SaslSupport getSaslSupport() {
      @SuppressWarnings("deprecation")
      org.apache.drill.exec.proto.UserProtos.SaslSupport result = org.apache.drill.exec.proto.UserProtos.SaslSupport.valueOf(saslSupport_);
      return result == null ? org.apache.drill.exec.proto.UserProtos.SaslSupport.UNKNOWN_SASL_SUPPORT : result;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (hasProperties()) {
        if (!getProperties().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeEnum(1, channel_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeBool(2, supportListening_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeInt32(3, rpcVersion_);
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        output.writeMessage(4, getCredentials());
      }
      if (((bitField0_ & 0x00000010) != 0)) {
        output.writeMessage(5, getProperties());
      }
      if (((bitField0_ & 0x00000020) != 0)) {
        output.writeBool(6, supportComplexTypes_);
      }
      if (((bitField0_ & 0x00000040) != 0)) {
        output.writeBool(7, supportTimeout_);
      }
      if (((bitField0_ & 0x00000080) != 0)) {
        output.writeMessage(8, getClientInfos());
      }
      if (((bitField0_ & 0x00000100) != 0)) {
        output.writeEnum(9, saslSupport_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(1, channel_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(2, supportListening_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(3, rpcVersion_);
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(4, getCredentials());
      }
      if (((bitField0_ & 0x00000010) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(5, getProperties());
      }
      if (((bitField0_ & 0x00000020) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(6, supportComplexTypes_);
      }
      if (((bitField0_ & 0x00000040) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(7, supportTimeout_);
      }
      if (((bitField0_ & 0x00000080) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(8, getClientInfos());
      }
      if (((bitField0_ & 0x00000100) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(9, saslSupport_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.drill.exec.proto.UserProtos.UserToBitHandshake)) {
        return super.equals(obj);
      }
      org.apache.drill.exec.proto.UserProtos.UserToBitHandshake other = (org.apache.drill.exec.proto.UserProtos.UserToBitHandshake) obj;

      if (hasChannel() != other.hasChannel()) return false;
      if (hasChannel()) {
        if (channel_ != other.channel_) return false;
      }
      if (hasSupportListening() != other.hasSupportListening()) return false;
      if (hasSupportListening()) {
        if (getSupportListening()
            != other.getSupportListening()) return false;
      }
      if (hasRpcVersion() != other.hasRpcVersion()) return false;
      if (hasRpcVersion()) {
        if (getRpcVersion()
            != other.getRpcVersion()) return false;
      }
      if (hasCredentials() != other.hasCredentials()) return false;
      if (hasCredentials()) {
        if (!getCredentials()
            .equals(other.getCredentials())) return false;
      }
      if (hasProperties() != other.hasProperties()) return false;
      if (hasProperties()) {
        if (!getProperties()
            .equals(other.getProperties())) return false;
      }
      if (hasSupportComplexTypes() != other.hasSupportComplexTypes()) return false;
      if (hasSupportComplexTypes()) {
        if (getSupportComplexTypes()
            != other.getSupportComplexTypes()) return false;
      }
      if (hasSupportTimeout() != other.hasSupportTimeout()) return false;
      if (hasSupportTimeout()) {
        if (getSupportTimeout()
            != other.getSupportTimeout()) return false;
      }
      if (hasClientInfos() != other.hasClientInfos()) return false;
      if (hasClientInfos()) {
        if (!getClientInfos()
            .equals(other.getClientInfos())) return false;
      }
      if (hasSaslSupport() != other.hasSaslSupport()) return false;
      if (hasSaslSupport()) {
        if (saslSupport_ != other.saslSupport_) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasChannel()) {
        hash = (37 * hash) + CHANNEL_FIELD_NUMBER;
        hash = (53 * hash) + channel_;
      }
      if (hasSupportListening()) {
        hash = (37 * hash) + SUPPORT_LISTENING_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
            getSupportListening());
      }
      if (hasRpcVersion()) {
        hash = (37 * hash) + RPC_VERSION_FIELD_NUMBER;
        hash = (53 * hash) + getRpcVersion();
      }
      if (hasCredentials()) {
        hash = (37 * hash) + CREDENTIALS_FIELD_NUMBER;
        hash = (53 * hash) + getCredentials().hashCode();
      }
      if (hasProperties()) {
        hash = (37 * hash) + PROPERTIES_FIELD_NUMBER;
        hash = (53 * hash) + getProperties().hashCode();
      }
      if (hasSupportComplexTypes()) {
        hash = (37 * hash) + SUPPORT_COMPLEX_TYPES_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
            getSupportComplexTypes());
      }
      if (hasSupportTimeout()) {
        hash = (37 * hash) + SUPPORT_TIMEOUT_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
            getSupportTimeout());
      }
      if (hasClientInfos()) {
        hash = (37 * hash) + CLIENT_INFOS_FIELD_NUMBER;
        hash = (53 * hash) + getClientInfos().hashCode();
      }
      if (hasSaslSupport()) {
        hash = (37 * hash) + SASL_SUPPORT_FIELD_NUMBER;
        hash = (53 * hash) + saslSupport_;
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.drill.exec.proto.UserProtos.UserToBitHandshake parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.UserToBitHandshake parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.UserToBitHandshake parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.UserToBitHandshake parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.UserToBitHandshake parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.UserToBitHandshake parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.UserToBitHandshake parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.UserToBitHandshake parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.UserToBitHandshake parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.UserToBitHandshake parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.UserToBitHandshake parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.UserToBitHandshake parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.drill.exec.proto.UserProtos.UserToBitHandshake prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code exec.user.UserToBitHandshake}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:exec.user.UserToBitHandshake)
        org.apache.drill.exec.proto.UserProtos.UserToBitHandshakeOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_UserToBitHandshake_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_UserToBitHandshake_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.UserProtos.UserToBitHandshake.class, org.apache.drill.exec.proto.UserProtos.UserToBitHandshake.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.UserProtos.UserToBitHandshake.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getCredentialsFieldBuilder();
          getPropertiesFieldBuilder();
          getClientInfosFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        channel_ = 2;
        bitField0_ = (bitField0_ & ~0x00000001);
        supportListening_ = false;
        bitField0_ = (bitField0_ & ~0x00000002);
        rpcVersion_ = 0;
        bitField0_ = (bitField0_ & ~0x00000004);
        if (credentialsBuilder_ == null) {
          credentials_ = null;
        } else {
          credentialsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000008);
        if (propertiesBuilder_ == null) {
          properties_ = null;
        } else {
          propertiesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000010);
        supportComplexTypes_ = false;
        bitField0_ = (bitField0_ & ~0x00000020);
        supportTimeout_ = false;
        bitField0_ = (bitField0_ & ~0x00000040);
        if (clientInfosBuilder_ == null) {
          clientInfos_ = null;
        } else {
          clientInfosBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000080);
        saslSupport_ = 0;
        bitField0_ = (bitField0_ & ~0x00000100);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_UserToBitHandshake_descriptor;
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.UserToBitHandshake getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.UserProtos.UserToBitHandshake.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.UserToBitHandshake build() {
        org.apache.drill.exec.proto.UserProtos.UserToBitHandshake result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.UserToBitHandshake buildPartial() {
        org.apache.drill.exec.proto.UserProtos.UserToBitHandshake result = new org.apache.drill.exec.proto.UserProtos.UserToBitHandshake(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          to_bitField0_ |= 0x00000001;
        }
        result.channel_ = channel_;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.supportListening_ = supportListening_;
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.rpcVersion_ = rpcVersion_;
          to_bitField0_ |= 0x00000004;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          if (credentialsBuilder_ == null) {
            result.credentials_ = credentials_;
          } else {
            result.credentials_ = credentialsBuilder_.build();
          }
          to_bitField0_ |= 0x00000008;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          if (propertiesBuilder_ == null) {
            result.properties_ = properties_;
          } else {
            result.properties_ = propertiesBuilder_.build();
          }
          to_bitField0_ |= 0x00000010;
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.supportComplexTypes_ = supportComplexTypes_;
          to_bitField0_ |= 0x00000020;
        }
        if (((from_bitField0_ & 0x00000040) != 0)) {
          result.supportTimeout_ = supportTimeout_;
          to_bitField0_ |= 0x00000040;
        }
        if (((from_bitField0_ & 0x00000080) != 0)) {
          if (clientInfosBuilder_ == null) {
            result.clientInfos_ = clientInfos_;
          } else {
            result.clientInfos_ = clientInfosBuilder_.build();
          }
          to_bitField0_ |= 0x00000080;
        }
        if (((from_bitField0_ & 0x00000100) != 0)) {
          to_bitField0_ |= 0x00000100;
        }
        result.saslSupport_ = saslSupport_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.UserProtos.UserToBitHandshake) {
          return mergeFrom((org.apache.drill.exec.proto.UserProtos.UserToBitHandshake)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.UserProtos.UserToBitHandshake other) {
        if (other == org.apache.drill.exec.proto.UserProtos.UserToBitHandshake.getDefaultInstance()) return this;
        if (other.hasChannel()) {
          setChannel(other.getChannel());
        }
        if (other.hasSupportListening()) {
          setSupportListening(other.getSupportListening());
        }
        if (other.hasRpcVersion()) {
          setRpcVersion(other.getRpcVersion());
        }
        if (other.hasCredentials()) {
          mergeCredentials(other.getCredentials());
        }
        if (other.hasProperties()) {
          mergeProperties(other.getProperties());
        }
        if (other.hasSupportComplexTypes()) {
          setSupportComplexTypes(other.getSupportComplexTypes());
        }
        if (other.hasSupportTimeout()) {
          setSupportTimeout(other.getSupportTimeout());
        }
        if (other.hasClientInfos()) {
          mergeClientInfos(other.getClientInfos());
        }
        if (other.hasSaslSupport()) {
          setSaslSupport(other.getSaslSupport());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (hasProperties()) {
          if (!getProperties().isInitialized()) {
            return false;
          }
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8: {
                int tmpRaw = input.readEnum();
                org.apache.drill.exec.proto.UserBitShared.RpcChannel tmpValue =
                    org.apache.drill.exec.proto.UserBitShared.RpcChannel.forNumber(tmpRaw);
                if (tmpValue == null) {
                  mergeUnknownVarintField(1, tmpRaw);
                } else {
                  channel_ = tmpRaw;
                  bitField0_ |= 0x00000001;
                }
                break;
              } // case 8
              case 16: {
                supportListening_ = input.readBool();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
              case 24: {
                rpcVersion_ = input.readInt32();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
              case 34: {
                input.readMessage(
                    getCredentialsFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
              case 42: {
                input.readMessage(
                    getPropertiesFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
              case 48: {
                supportComplexTypes_ = input.readBool();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
              case 56: {
                supportTimeout_ = input.readBool();
                bitField0_ |= 0x00000040;
                break;
              } // case 56
              case 66: {
                input.readMessage(
                    getClientInfosFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 66
              case 72: {
                int tmpRaw = input.readEnum();
                org.apache.drill.exec.proto.UserProtos.SaslSupport tmpValue =
                    org.apache.drill.exec.proto.UserProtos.SaslSupport.forNumber(tmpRaw);
                if (tmpValue == null) {
                  mergeUnknownVarintField(9, tmpRaw);
                } else {
                  saslSupport_ = tmpRaw;
                  bitField0_ |= 0x00000100;
                }
                break;
              } // case 72
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private int channel_ = 2;
      /**
       * <code>optional .exec.shared.RpcChannel channel = 1 [default = USER];</code>
       * @return Whether the channel field is set.
       */
      @java.lang.Override public boolean hasChannel() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>optional .exec.shared.RpcChannel channel = 1 [default = USER];</code>
       * @return The channel.
       */
      @java.lang.Override
      public org.apache.drill.exec.proto.UserBitShared.RpcChannel getChannel() {
        @SuppressWarnings("deprecation")
        org.apache.drill.exec.proto.UserBitShared.RpcChannel result = org.apache.drill.exec.proto.UserBitShared.RpcChannel.valueOf(channel_);
        return result == null ? org.apache.drill.exec.proto.UserBitShared.RpcChannel.USER : result;
      }
      /**
       * <code>optional .exec.shared.RpcChannel channel = 1 [default = USER];</code>
       * @param value The channel to set.
       * @return This builder for chaining.
       */
      public Builder setChannel(org.apache.drill.exec.proto.UserBitShared.RpcChannel value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        channel_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <code>optional .exec.shared.RpcChannel channel = 1 [default = USER];</code>
       * @return This builder for chaining.
       */
      public Builder clearChannel() {
        bitField0_ = (bitField0_ & ~0x00000001);
        channel_ = 2;
        onChanged();
        return this;
      }

      private boolean supportListening_ ;
      /**
       * <code>optional bool support_listening = 2;</code>
       * @return Whether the supportListening field is set.
       */
      @java.lang.Override
      public boolean hasSupportListening() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <code>optional bool support_listening = 2;</code>
       * @return The supportListening.
       */
      @java.lang.Override
      public boolean getSupportListening() {
        return supportListening_;
      }
      /**
       * <code>optional bool support_listening = 2;</code>
       * @param value The supportListening to set.
       * @return This builder for chaining.
       */
      public Builder setSupportListening(boolean value) {
        bitField0_ |= 0x00000002;
        supportListening_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool support_listening = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearSupportListening() {
        bitField0_ = (bitField0_ & ~0x00000002);
        supportListening_ = false;
        onChanged();
        return this;
      }

      private int rpcVersion_ ;
      /**
       * <code>optional int32 rpc_version = 3;</code>
       * @return Whether the rpcVersion field is set.
       */
      @java.lang.Override
      public boolean hasRpcVersion() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <code>optional int32 rpc_version = 3;</code>
       * @return The rpcVersion.
       */
      @java.lang.Override
      public int getRpcVersion() {
        return rpcVersion_;
      }
      /**
       * <code>optional int32 rpc_version = 3;</code>
       * @param value The rpcVersion to set.
       * @return This builder for chaining.
       */
      public Builder setRpcVersion(int value) {
        bitField0_ |= 0x00000004;
        rpcVersion_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional int32 rpc_version = 3;</code>
       * @return This builder for chaining.
       */
      public Builder clearRpcVersion() {
        bitField0_ = (bitField0_ & ~0x00000004);
        rpcVersion_ = 0;
        onChanged();
        return this;
      }

      private org.apache.drill.exec.proto.UserBitShared.UserCredentials credentials_;
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.drill.exec.proto.UserBitShared.UserCredentials, org.apache.drill.exec.proto.UserBitShared.UserCredentials.Builder, org.apache.drill.exec.proto.UserBitShared.UserCredentialsOrBuilder> credentialsBuilder_;
      /**
       * <code>optional .exec.shared.UserCredentials credentials = 4;</code>
       * @return Whether the credentials field is set.
       */
      public boolean hasCredentials() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       * <code>optional .exec.shared.UserCredentials credentials = 4;</code>
       * @return The credentials.
       */
      public org.apache.drill.exec.proto.UserBitShared.UserCredentials getCredentials() {
        if (credentialsBuilder_ == null) {
          return credentials_ == null ? org.apache.drill.exec.proto.UserBitShared.UserCredentials.getDefaultInstance() : credentials_;
        } else {
          return credentialsBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .exec.shared.UserCredentials credentials = 4;</code>
       */
      public Builder setCredentials(org.apache.drill.exec.proto.UserBitShared.UserCredentials value) {
        if (credentialsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          credentials_ = value;
          onChanged();
        } else {
          credentialsBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        return this;
      }
      /**
       * <code>optional .exec.shared.UserCredentials credentials = 4;</code>
       */
      public Builder setCredentials(
          org.apache.drill.exec.proto.UserBitShared.UserCredentials.Builder builderForValue) {
        if (credentialsBuilder_ == null) {
          credentials_ = builderForValue.build();
          onChanged();
        } else {
          credentialsBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        return this;
      }
      /**
       * <code>optional .exec.shared.UserCredentials credentials = 4;</code>
       */
      public Builder mergeCredentials(org.apache.drill.exec.proto.UserBitShared.UserCredentials value) {
        if (credentialsBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0) &&
              credentials_ != null &&
              credentials_ != org.apache.drill.exec.proto.UserBitShared.UserCredentials.getDefaultInstance()) {
            credentials_ =
              org.apache.drill.exec.proto.UserBitShared.UserCredentials.newBuilder(credentials_).mergeFrom(value).buildPartial();
          } else {
            credentials_ = value;
          }
          onChanged();
        } else {
          credentialsBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000008;
        return this;
      }
      /**
       * <code>optional .exec.shared.UserCredentials credentials = 4;</code>
       */
      public Builder clearCredentials() {
        if (credentialsBuilder_ == null) {
          credentials_ = null;
          onChanged();
        } else {
          credentialsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000008);
        return this;
      }
      /**
       * <code>optional .exec.shared.UserCredentials credentials = 4;</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.UserCredentials.Builder getCredentialsBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getCredentialsFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .exec.shared.UserCredentials credentials = 4;</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.UserCredentialsOrBuilder getCredentialsOrBuilder() {
        if (credentialsBuilder_ != null) {
          return credentialsBuilder_.getMessageOrBuilder();
        } else {
          return credentials_ == null ?
              org.apache.drill.exec.proto.UserBitShared.UserCredentials.getDefaultInstance() : credentials_;
        }
      }
      /**
       * <code>optional .exec.shared.UserCredentials credentials = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.drill.exec.proto.UserBitShared.UserCredentials, org.apache.drill.exec.proto.UserBitShared.UserCredentials.Builder, org.apache.drill.exec.proto.UserBitShared.UserCredentialsOrBuilder> 
          getCredentialsFieldBuilder() {
        if (credentialsBuilder_ == null) {
          credentialsBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.apache.drill.exec.proto.UserBitShared.UserCredentials, org.apache.drill.exec.proto.UserBitShared.UserCredentials.Builder, org.apache.drill.exec.proto.UserBitShared.UserCredentialsOrBuilder>(
                  getCredentials(),
                  getParentForChildren(),
                  isClean());
          credentials_ = null;
        }
        return credentialsBuilder_;
      }

      private org.apache.drill.exec.proto.UserProtos.UserProperties properties_;
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.drill.exec.proto.UserProtos.UserProperties, org.apache.drill.exec.proto.UserProtos.UserProperties.Builder, org.apache.drill.exec.proto.UserProtos.UserPropertiesOrBuilder> propertiesBuilder_;
      /**
       * <code>optional .exec.user.UserProperties properties = 5;</code>
       * @return Whether the properties field is set.
       */
      public boolean hasProperties() {
        return ((bitField0_ & 0x00000010) != 0);
      }
      /**
       * <code>optional .exec.user.UserProperties properties = 5;</code>
       * @return The properties.
       */
      public org.apache.drill.exec.proto.UserProtos.UserProperties getProperties() {
        if (propertiesBuilder_ == null) {
          return properties_ == null ? org.apache.drill.exec.proto.UserProtos.UserProperties.getDefaultInstance() : properties_;
        } else {
          return propertiesBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .exec.user.UserProperties properties = 5;</code>
       */
      public Builder setProperties(org.apache.drill.exec.proto.UserProtos.UserProperties value) {
        if (propertiesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          properties_ = value;
          onChanged();
        } else {
          propertiesBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000010;
        return this;
      }
      /**
       * <code>optional .exec.user.UserProperties properties = 5;</code>
       */
      public Builder setProperties(
          org.apache.drill.exec.proto.UserProtos.UserProperties.Builder builderForValue) {
        if (propertiesBuilder_ == null) {
          properties_ = builderForValue.build();
          onChanged();
        } else {
          propertiesBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000010;
        return this;
      }
      /**
       * <code>optional .exec.user.UserProperties properties = 5;</code>
       */
      public Builder mergeProperties(org.apache.drill.exec.proto.UserProtos.UserProperties value) {
        if (propertiesBuilder_ == null) {
          if (((bitField0_ & 0x00000010) != 0) &&
              properties_ != null &&
              properties_ != org.apache.drill.exec.proto.UserProtos.UserProperties.getDefaultInstance()) {
            properties_ =
              org.apache.drill.exec.proto.UserProtos.UserProperties.newBuilder(properties_).mergeFrom(value).buildPartial();
          } else {
            properties_ = value;
          }
          onChanged();
        } else {
          propertiesBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000010;
        return this;
      }
      /**
       * <code>optional .exec.user.UserProperties properties = 5;</code>
       */
      public Builder clearProperties() {
        if (propertiesBuilder_ == null) {
          properties_ = null;
          onChanged();
        } else {
          propertiesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000010);
        return this;
      }
      /**
       * <code>optional .exec.user.UserProperties properties = 5;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.UserProperties.Builder getPropertiesBuilder() {
        bitField0_ |= 0x00000010;
        onChanged();
        return getPropertiesFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .exec.user.UserProperties properties = 5;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.UserPropertiesOrBuilder getPropertiesOrBuilder() {
        if (propertiesBuilder_ != null) {
          return propertiesBuilder_.getMessageOrBuilder();
        } else {
          return properties_ == null ?
              org.apache.drill.exec.proto.UserProtos.UserProperties.getDefaultInstance() : properties_;
        }
      }
      /**
       * <code>optional .exec.user.UserProperties properties = 5;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.drill.exec.proto.UserProtos.UserProperties, org.apache.drill.exec.proto.UserProtos.UserProperties.Builder, org.apache.drill.exec.proto.UserProtos.UserPropertiesOrBuilder> 
          getPropertiesFieldBuilder() {
        if (propertiesBuilder_ == null) {
          propertiesBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.apache.drill.exec.proto.UserProtos.UserProperties, org.apache.drill.exec.proto.UserProtos.UserProperties.Builder, org.apache.drill.exec.proto.UserProtos.UserPropertiesOrBuilder>(
                  getProperties(),
                  getParentForChildren(),
                  isClean());
          properties_ = null;
        }
        return propertiesBuilder_;
      }

      private boolean supportComplexTypes_ ;
      /**
       * <code>optional bool support_complex_types = 6 [default = false];</code>
       * @return Whether the supportComplexTypes field is set.
       */
      @java.lang.Override
      public boolean hasSupportComplexTypes() {
        return ((bitField0_ & 0x00000020) != 0);
      }
      /**
       * <code>optional bool support_complex_types = 6 [default = false];</code>
       * @return The supportComplexTypes.
       */
      @java.lang.Override
      public boolean getSupportComplexTypes() {
        return supportComplexTypes_;
      }
      /**
       * <code>optional bool support_complex_types = 6 [default = false];</code>
       * @param value The supportComplexTypes to set.
       * @return This builder for chaining.
       */
      public Builder setSupportComplexTypes(boolean value) {
        bitField0_ |= 0x00000020;
        supportComplexTypes_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool support_complex_types = 6 [default = false];</code>
       * @return This builder for chaining.
       */
      public Builder clearSupportComplexTypes() {
        bitField0_ = (bitField0_ & ~0x00000020);
        supportComplexTypes_ = false;
        onChanged();
        return this;
      }

      private boolean supportTimeout_ ;
      /**
       * <code>optional bool support_timeout = 7 [default = false];</code>
       * @return Whether the supportTimeout field is set.
       */
      @java.lang.Override
      public boolean hasSupportTimeout() {
        return ((bitField0_ & 0x00000040) != 0);
      }
      /**
       * <code>optional bool support_timeout = 7 [default = false];</code>
       * @return The supportTimeout.
       */
      @java.lang.Override
      public boolean getSupportTimeout() {
        return supportTimeout_;
      }
      /**
       * <code>optional bool support_timeout = 7 [default = false];</code>
       * @param value The supportTimeout to set.
       * @return This builder for chaining.
       */
      public Builder setSupportTimeout(boolean value) {
        bitField0_ |= 0x00000040;
        supportTimeout_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool support_timeout = 7 [default = false];</code>
       * @return This builder for chaining.
       */
      public Builder clearSupportTimeout() {
        bitField0_ = (bitField0_ & ~0x00000040);
        supportTimeout_ = false;
        onChanged();
        return this;
      }

      private org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos clientInfos_;
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos, org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos.Builder, org.apache.drill.exec.proto.UserProtos.RpcEndpointInfosOrBuilder> clientInfosBuilder_;
      /**
       * <code>optional .exec.user.RpcEndpointInfos client_infos = 8;</code>
       * @return Whether the clientInfos field is set.
       */
      public boolean hasClientInfos() {
        return ((bitField0_ & 0x00000080) != 0);
      }
      /**
       * <code>optional .exec.user.RpcEndpointInfos client_infos = 8;</code>
       * @return The clientInfos.
       */
      public org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos getClientInfos() {
        if (clientInfosBuilder_ == null) {
          return clientInfos_ == null ? org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos.getDefaultInstance() : clientInfos_;
        } else {
          return clientInfosBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .exec.user.RpcEndpointInfos client_infos = 8;</code>
       */
      public Builder setClientInfos(org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos value) {
        if (clientInfosBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          clientInfos_ = value;
          onChanged();
        } else {
          clientInfosBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000080;
        return this;
      }
      /**
       * <code>optional .exec.user.RpcEndpointInfos client_infos = 8;</code>
       */
      public Builder setClientInfos(
          org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos.Builder builderForValue) {
        if (clientInfosBuilder_ == null) {
          clientInfos_ = builderForValue.build();
          onChanged();
        } else {
          clientInfosBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000080;
        return this;
      }
      /**
       * <code>optional .exec.user.RpcEndpointInfos client_infos = 8;</code>
       */
      public Builder mergeClientInfos(org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos value) {
        if (clientInfosBuilder_ == null) {
          if (((bitField0_ & 0x00000080) != 0) &&
              clientInfos_ != null &&
              clientInfos_ != org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos.getDefaultInstance()) {
            clientInfos_ =
              org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos.newBuilder(clientInfos_).mergeFrom(value).buildPartial();
          } else {
            clientInfos_ = value;
          }
          onChanged();
        } else {
          clientInfosBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000080;
        return this;
      }
      /**
       * <code>optional .exec.user.RpcEndpointInfos client_infos = 8;</code>
       */
      public Builder clearClientInfos() {
        if (clientInfosBuilder_ == null) {
          clientInfos_ = null;
          onChanged();
        } else {
          clientInfosBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000080);
        return this;
      }
      /**
       * <code>optional .exec.user.RpcEndpointInfos client_infos = 8;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos.Builder getClientInfosBuilder() {
        bitField0_ |= 0x00000080;
        onChanged();
        return getClientInfosFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .exec.user.RpcEndpointInfos client_infos = 8;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.RpcEndpointInfosOrBuilder getClientInfosOrBuilder() {
        if (clientInfosBuilder_ != null) {
          return clientInfosBuilder_.getMessageOrBuilder();
        } else {
          return clientInfos_ == null ?
              org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos.getDefaultInstance() : clientInfos_;
        }
      }
      /**
       * <code>optional .exec.user.RpcEndpointInfos client_infos = 8;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos, org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos.Builder, org.apache.drill.exec.proto.UserProtos.RpcEndpointInfosOrBuilder> 
          getClientInfosFieldBuilder() {
        if (clientInfosBuilder_ == null) {
          clientInfosBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos, org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos.Builder, org.apache.drill.exec.proto.UserProtos.RpcEndpointInfosOrBuilder>(
                  getClientInfos(),
                  getParentForChildren(),
                  isClean());
          clientInfos_ = null;
        }
        return clientInfosBuilder_;
      }

      private int saslSupport_ = 0;
      /**
       * <code>optional .exec.user.SaslSupport sasl_support = 9;</code>
       * @return Whether the saslSupport field is set.
       */
      @java.lang.Override public boolean hasSaslSupport() {
        return ((bitField0_ & 0x00000100) != 0);
      }
      /**
       * <code>optional .exec.user.SaslSupport sasl_support = 9;</code>
       * @return The saslSupport.
       */
      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.SaslSupport getSaslSupport() {
        @SuppressWarnings("deprecation")
        org.apache.drill.exec.proto.UserProtos.SaslSupport result = org.apache.drill.exec.proto.UserProtos.SaslSupport.valueOf(saslSupport_);
        return result == null ? org.apache.drill.exec.proto.UserProtos.SaslSupport.UNKNOWN_SASL_SUPPORT : result;
      }
      /**
       * <code>optional .exec.user.SaslSupport sasl_support = 9;</code>
       * @param value The saslSupport to set.
       * @return This builder for chaining.
       */
      public Builder setSaslSupport(org.apache.drill.exec.proto.UserProtos.SaslSupport value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000100;
        saslSupport_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <code>optional .exec.user.SaslSupport sasl_support = 9;</code>
       * @return This builder for chaining.
       */
      public Builder clearSaslSupport() {
        bitField0_ = (bitField0_ & ~0x00000100);
        saslSupport_ = 0;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:exec.user.UserToBitHandshake)
    }

    // @@protoc_insertion_point(class_scope:exec.user.UserToBitHandshake)
    private static final org.apache.drill.exec.proto.UserProtos.UserToBitHandshake DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.drill.exec.proto.UserProtos.UserToBitHandshake();
    }

    public static org.apache.drill.exec.proto.UserProtos.UserToBitHandshake getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final com.google.protobuf.Parser<UserToBitHandshake>
        PARSER = new com.google.protobuf.AbstractParser<UserToBitHandshake>() {
      @java.lang.Override
      public UserToBitHandshake parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<UserToBitHandshake> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<UserToBitHandshake> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.drill.exec.proto.UserProtos.UserToBitHandshake getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface RequestResultsOrBuilder extends
      // @@protoc_insertion_point(interface_extends:exec.user.RequestResults)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>optional .exec.shared.QueryId query_id = 1;</code>
     * @return Whether the queryId field is set.
     */
    boolean hasQueryId();
    /**
     * <code>optional .exec.shared.QueryId query_id = 1;</code>
     * @return The queryId.
     */
    org.apache.drill.exec.proto.UserBitShared.QueryId getQueryId();
    /**
     * <code>optional .exec.shared.QueryId query_id = 1;</code>
     */
    org.apache.drill.exec.proto.UserBitShared.QueryIdOrBuilder getQueryIdOrBuilder();

    /**
     * <code>optional int32 maximum_responses = 2;</code>
     * @return Whether the maximumResponses field is set.
     */
    boolean hasMaximumResponses();
    /**
     * <code>optional int32 maximum_responses = 2;</code>
     * @return The maximumResponses.
     */
    int getMaximumResponses();
  }
  /**
   * Protobuf type {@code exec.user.RequestResults}
   */
  public static final class RequestResults extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:exec.user.RequestResults)
      RequestResultsOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use RequestResults.newBuilder() to construct.
    private RequestResults(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private RequestResults() {
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new RequestResults();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_RequestResults_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_RequestResults_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.UserProtos.RequestResults.class, org.apache.drill.exec.proto.UserProtos.RequestResults.Builder.class);
    }

    private int bitField0_;
    public static final int QUERY_ID_FIELD_NUMBER = 1;
    private org.apache.drill.exec.proto.UserBitShared.QueryId queryId_;
    /**
     * <code>optional .exec.shared.QueryId query_id = 1;</code>
     * @return Whether the queryId field is set.
     */
    @java.lang.Override
    public boolean hasQueryId() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>optional .exec.shared.QueryId query_id = 1;</code>
     * @return The queryId.
     */
    @java.lang.Override
    public org.apache.drill.exec.proto.UserBitShared.QueryId getQueryId() {
      return queryId_ == null ? org.apache.drill.exec.proto.UserBitShared.QueryId.getDefaultInstance() : queryId_;
    }
    /**
     * <code>optional .exec.shared.QueryId query_id = 1;</code>
     */
    @java.lang.Override
    public org.apache.drill.exec.proto.UserBitShared.QueryIdOrBuilder getQueryIdOrBuilder() {
      return queryId_ == null ? org.apache.drill.exec.proto.UserBitShared.QueryId.getDefaultInstance() : queryId_;
    }

    public static final int MAXIMUM_RESPONSES_FIELD_NUMBER = 2;
    private int maximumResponses_;
    /**
     * <code>optional int32 maximum_responses = 2;</code>
     * @return Whether the maximumResponses field is set.
     */
    @java.lang.Override
    public boolean hasMaximumResponses() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <code>optional int32 maximum_responses = 2;</code>
     * @return The maximumResponses.
     */
    @java.lang.Override
    public int getMaximumResponses() {
      return maximumResponses_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getQueryId());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeInt32(2, maximumResponses_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, getQueryId());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(2, maximumResponses_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.drill.exec.proto.UserProtos.RequestResults)) {
        return super.equals(obj);
      }
      org.apache.drill.exec.proto.UserProtos.RequestResults other = (org.apache.drill.exec.proto.UserProtos.RequestResults) obj;

      if (hasQueryId() != other.hasQueryId()) return false;
      if (hasQueryId()) {
        if (!getQueryId()
            .equals(other.getQueryId())) return false;
      }
      if (hasMaximumResponses() != other.hasMaximumResponses()) return false;
      if (hasMaximumResponses()) {
        if (getMaximumResponses()
            != other.getMaximumResponses()) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasQueryId()) {
        hash = (37 * hash) + QUERY_ID_FIELD_NUMBER;
        hash = (53 * hash) + getQueryId().hashCode();
      }
      if (hasMaximumResponses()) {
        hash = (37 * hash) + MAXIMUM_RESPONSES_FIELD_NUMBER;
        hash = (53 * hash) + getMaximumResponses();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.drill.exec.proto.UserProtos.RequestResults parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.RequestResults parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.RequestResults parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.RequestResults parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.RequestResults parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.RequestResults parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.RequestResults parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.RequestResults parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.RequestResults parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.RequestResults parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.RequestResults parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.RequestResults parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.drill.exec.proto.UserProtos.RequestResults prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code exec.user.RequestResults}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:exec.user.RequestResults)
        org.apache.drill.exec.proto.UserProtos.RequestResultsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_RequestResults_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_RequestResults_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.UserProtos.RequestResults.class, org.apache.drill.exec.proto.UserProtos.RequestResults.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.UserProtos.RequestResults.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getQueryIdFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (queryIdBuilder_ == null) {
          queryId_ = null;
        } else {
          queryIdBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        maximumResponses_ = 0;
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_RequestResults_descriptor;
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.RequestResults getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.UserProtos.RequestResults.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.RequestResults build() {
        org.apache.drill.exec.proto.UserProtos.RequestResults result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.RequestResults buildPartial() {
        org.apache.drill.exec.proto.UserProtos.RequestResults result = new org.apache.drill.exec.proto.UserProtos.RequestResults(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          if (queryIdBuilder_ == null) {
            result.queryId_ = queryId_;
          } else {
            result.queryId_ = queryIdBuilder_.build();
          }
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.maximumResponses_ = maximumResponses_;
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.UserProtos.RequestResults) {
          return mergeFrom((org.apache.drill.exec.proto.UserProtos.RequestResults)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.UserProtos.RequestResults other) {
        if (other == org.apache.drill.exec.proto.UserProtos.RequestResults.getDefaultInstance()) return this;
        if (other.hasQueryId()) {
          mergeQueryId(other.getQueryId());
        }
        if (other.hasMaximumResponses()) {
          setMaximumResponses(other.getMaximumResponses());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                input.readMessage(
                    getQueryIdFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
              case 16: {
                maximumResponses_ = input.readInt32();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private org.apache.drill.exec.proto.UserBitShared.QueryId queryId_;
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.drill.exec.proto.UserBitShared.QueryId, org.apache.drill.exec.proto.UserBitShared.QueryId.Builder, org.apache.drill.exec.proto.UserBitShared.QueryIdOrBuilder> queryIdBuilder_;
      /**
       * <code>optional .exec.shared.QueryId query_id = 1;</code>
       * @return Whether the queryId field is set.
       */
      public boolean hasQueryId() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>optional .exec.shared.QueryId query_id = 1;</code>
       * @return The queryId.
       */
      public org.apache.drill.exec.proto.UserBitShared.QueryId getQueryId() {
        if (queryIdBuilder_ == null) {
          return queryId_ == null ? org.apache.drill.exec.proto.UserBitShared.QueryId.getDefaultInstance() : queryId_;
        } else {
          return queryIdBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .exec.shared.QueryId query_id = 1;</code>
       */
      public Builder setQueryId(org.apache.drill.exec.proto.UserBitShared.QueryId value) {
        if (queryIdBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          queryId_ = value;
          onChanged();
        } else {
          queryIdBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>optional .exec.shared.QueryId query_id = 1;</code>
       */
      public Builder setQueryId(
          org.apache.drill.exec.proto.UserBitShared.QueryId.Builder builderForValue) {
        if (queryIdBuilder_ == null) {
          queryId_ = builderForValue.build();
          onChanged();
        } else {
          queryIdBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>optional .exec.shared.QueryId query_id = 1;</code>
       */
      public Builder mergeQueryId(org.apache.drill.exec.proto.UserBitShared.QueryId value) {
        if (queryIdBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0) &&
              queryId_ != null &&
              queryId_ != org.apache.drill.exec.proto.UserBitShared.QueryId.getDefaultInstance()) {
            queryId_ =
              org.apache.drill.exec.proto.UserBitShared.QueryId.newBuilder(queryId_).mergeFrom(value).buildPartial();
          } else {
            queryId_ = value;
          }
          onChanged();
        } else {
          queryIdBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>optional .exec.shared.QueryId query_id = 1;</code>
       */
      public Builder clearQueryId() {
        if (queryIdBuilder_ == null) {
          queryId_ = null;
          onChanged();
        } else {
          queryIdBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }
      /**
       * <code>optional .exec.shared.QueryId query_id = 1;</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.QueryId.Builder getQueryIdBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getQueryIdFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .exec.shared.QueryId query_id = 1;</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.QueryIdOrBuilder getQueryIdOrBuilder() {
        if (queryIdBuilder_ != null) {
          return queryIdBuilder_.getMessageOrBuilder();
        } else {
          return queryId_ == null ?
              org.apache.drill.exec.proto.UserBitShared.QueryId.getDefaultInstance() : queryId_;
        }
      }
      /**
       * <code>optional .exec.shared.QueryId query_id = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.drill.exec.proto.UserBitShared.QueryId, org.apache.drill.exec.proto.UserBitShared.QueryId.Builder, org.apache.drill.exec.proto.UserBitShared.QueryIdOrBuilder> 
          getQueryIdFieldBuilder() {
        if (queryIdBuilder_ == null) {
          queryIdBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.apache.drill.exec.proto.UserBitShared.QueryId, org.apache.drill.exec.proto.UserBitShared.QueryId.Builder, org.apache.drill.exec.proto.UserBitShared.QueryIdOrBuilder>(
                  getQueryId(),
                  getParentForChildren(),
                  isClean());
          queryId_ = null;
        }
        return queryIdBuilder_;
      }

      private int maximumResponses_ ;
      /**
       * <code>optional int32 maximum_responses = 2;</code>
       * @return Whether the maximumResponses field is set.
       */
      @java.lang.Override
      public boolean hasMaximumResponses() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <code>optional int32 maximum_responses = 2;</code>
       * @return The maximumResponses.
       */
      @java.lang.Override
      public int getMaximumResponses() {
        return maximumResponses_;
      }
      /**
       * <code>optional int32 maximum_responses = 2;</code>
       * @param value The maximumResponses to set.
       * @return This builder for chaining.
       */
      public Builder setMaximumResponses(int value) {
        bitField0_ |= 0x00000002;
        maximumResponses_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional int32 maximum_responses = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearMaximumResponses() {
        bitField0_ = (bitField0_ & ~0x00000002);
        maximumResponses_ = 0;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:exec.user.RequestResults)
    }

    // @@protoc_insertion_point(class_scope:exec.user.RequestResults)
    private static final org.apache.drill.exec.proto.UserProtos.RequestResults DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.drill.exec.proto.UserProtos.RequestResults();
    }

    public static org.apache.drill.exec.proto.UserProtos.RequestResults getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final com.google.protobuf.Parser<RequestResults>
        PARSER = new com.google.protobuf.AbstractParser<RequestResults>() {
      @java.lang.Override
      public RequestResults parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<RequestResults> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<RequestResults> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.drill.exec.proto.UserProtos.RequestResults getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface GetQueryPlanFragmentsOrBuilder extends
      // @@protoc_insertion_point(interface_extends:exec.user.GetQueryPlanFragments)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>required string query = 1;</code>
     * @return Whether the query field is set.
     */
    boolean hasQuery();
    /**
     * <code>required string query = 1;</code>
     * @return The query.
     */
    java.lang.String getQuery();
    /**
     * <code>required string query = 1;</code>
     * @return The bytes for query.
     */
    com.google.protobuf.ByteString
        getQueryBytes();

    /**
     * <code>optional .exec.shared.QueryType type = 2;</code>
     * @return Whether the type field is set.
     */
    boolean hasType();
    /**
     * <code>optional .exec.shared.QueryType type = 2;</code>
     * @return The type.
     */
    org.apache.drill.exec.proto.UserBitShared.QueryType getType();

    /**
     * <code>optional bool split_plan = 3 [default = false];</code>
     * @return Whether the splitPlan field is set.
     */
    boolean hasSplitPlan();
    /**
     * <code>optional bool split_plan = 3 [default = false];</code>
     * @return The splitPlan.
     */
    boolean getSplitPlan();
  }
  /**
   * Protobuf type {@code exec.user.GetQueryPlanFragments}
   */
  public static final class GetQueryPlanFragments extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:exec.user.GetQueryPlanFragments)
      GetQueryPlanFragmentsOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use GetQueryPlanFragments.newBuilder() to construct.
    private GetQueryPlanFragments(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private GetQueryPlanFragments() {
      query_ = "";
      type_ = 1;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new GetQueryPlanFragments();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetQueryPlanFragments_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetQueryPlanFragments_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments.class, org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments.Builder.class);
    }

    private int bitField0_;
    public static final int QUERY_FIELD_NUMBER = 1;
    private volatile java.lang.Object query_;
    /**
     * <code>required string query = 1;</code>
     * @return Whether the query field is set.
     */
    @java.lang.Override
    public boolean hasQuery() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>required string query = 1;</code>
     * @return The query.
     */
    @java.lang.Override
    public java.lang.String getQuery() {
      java.lang.Object ref = query_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          query_ = s;
        }
        return s;
      }
    }
    /**
     * <code>required string query = 1;</code>
     * @return The bytes for query.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getQueryBytes() {
      java.lang.Object ref = query_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        query_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TYPE_FIELD_NUMBER = 2;
    private int type_;
    /**
     * <code>optional .exec.shared.QueryType type = 2;</code>
     * @return Whether the type field is set.
     */
    @java.lang.Override public boolean hasType() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <code>optional .exec.shared.QueryType type = 2;</code>
     * @return The type.
     */
    @java.lang.Override public org.apache.drill.exec.proto.UserBitShared.QueryType getType() {
      @SuppressWarnings("deprecation")
      org.apache.drill.exec.proto.UserBitShared.QueryType result = org.apache.drill.exec.proto.UserBitShared.QueryType.valueOf(type_);
      return result == null ? org.apache.drill.exec.proto.UserBitShared.QueryType.SQL : result;
    }

    public static final int SPLIT_PLAN_FIELD_NUMBER = 3;
    private boolean splitPlan_;
    /**
     * <code>optional bool split_plan = 3 [default = false];</code>
     * @return Whether the splitPlan field is set.
     */
    @java.lang.Override
    public boolean hasSplitPlan() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <code>optional bool split_plan = 3 [default = false];</code>
     * @return The splitPlan.
     */
    @java.lang.Override
    public boolean getSplitPlan() {
      return splitPlan_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasQuery()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, query_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeEnum(2, type_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeBool(3, splitPlan_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, query_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(2, type_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(3, splitPlan_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments)) {
        return super.equals(obj);
      }
      org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments other = (org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments) obj;

      if (hasQuery() != other.hasQuery()) return false;
      if (hasQuery()) {
        if (!getQuery()
            .equals(other.getQuery())) return false;
      }
      if (hasType() != other.hasType()) return false;
      if (hasType()) {
        if (type_ != other.type_) return false;
      }
      if (hasSplitPlan() != other.hasSplitPlan()) return false;
      if (hasSplitPlan()) {
        if (getSplitPlan()
            != other.getSplitPlan()) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasQuery()) {
        hash = (37 * hash) + QUERY_FIELD_NUMBER;
        hash = (53 * hash) + getQuery().hashCode();
      }
      if (hasType()) {
        hash = (37 * hash) + TYPE_FIELD_NUMBER;
        hash = (53 * hash) + type_;
      }
      if (hasSplitPlan()) {
        hash = (37 * hash) + SPLIT_PLAN_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
            getSplitPlan());
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code exec.user.GetQueryPlanFragments}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:exec.user.GetQueryPlanFragments)
        org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragmentsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetQueryPlanFragments_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetQueryPlanFragments_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments.class, org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        query_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        type_ = 1;
        bitField0_ = (bitField0_ & ~0x00000002);
        splitPlan_ = false;
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetQueryPlanFragments_descriptor;
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments build() {
        org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments buildPartial() {
        org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments result = new org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          to_bitField0_ |= 0x00000001;
        }
        result.query_ = query_;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          to_bitField0_ |= 0x00000002;
        }
        result.type_ = type_;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.splitPlan_ = splitPlan_;
          to_bitField0_ |= 0x00000004;
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments) {
          return mergeFrom((org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments other) {
        if (other == org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments.getDefaultInstance()) return this;
        if (other.hasQuery()) {
          bitField0_ |= 0x00000001;
          query_ = other.query_;
          onChanged();
        }
        if (other.hasType()) {
          setType(other.getType());
        }
        if (other.hasSplitPlan()) {
          setSplitPlan(other.getSplitPlan());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (!hasQuery()) {
          return false;
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                query_ = input.readBytes();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
              case 16: {
                int tmpRaw = input.readEnum();
                org.apache.drill.exec.proto.UserBitShared.QueryType tmpValue =
                    org.apache.drill.exec.proto.UserBitShared.QueryType.forNumber(tmpRaw);
                if (tmpValue == null) {
                  mergeUnknownVarintField(2, tmpRaw);
                } else {
                  type_ = tmpRaw;
                  bitField0_ |= 0x00000002;
                }
                break;
              } // case 16
              case 24: {
                splitPlan_ = input.readBool();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private java.lang.Object query_ = "";
      /**
       * <code>required string query = 1;</code>
       * @return Whether the query field is set.
       */
      public boolean hasQuery() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>required string query = 1;</code>
       * @return The query.
       */
      public java.lang.String getQuery() {
        java.lang.Object ref = query_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            query_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>required string query = 1;</code>
       * @return The bytes for query.
       */
      public com.google.protobuf.ByteString
          getQueryBytes() {
        java.lang.Object ref = query_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          query_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>required string query = 1;</code>
       * @param value The query to set.
       * @return This builder for chaining.
       */
      public Builder setQuery(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        query_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required string query = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearQuery() {
        bitField0_ = (bitField0_ & ~0x00000001);
        query_ = getDefaultInstance().getQuery();
        onChanged();
        return this;
      }
      /**
       * <code>required string query = 1;</code>
       * @param value The bytes for query to set.
       * @return This builder for chaining.
       */
      public Builder setQueryBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        query_ = value;
        onChanged();
        return this;
      }

      private int type_ = 1;
      /**
       * <code>optional .exec.shared.QueryType type = 2;</code>
       * @return Whether the type field is set.
       */
      @java.lang.Override public boolean hasType() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <code>optional .exec.shared.QueryType type = 2;</code>
       * @return The type.
       */
      @java.lang.Override
      public org.apache.drill.exec.proto.UserBitShared.QueryType getType() {
        @SuppressWarnings("deprecation")
        org.apache.drill.exec.proto.UserBitShared.QueryType result = org.apache.drill.exec.proto.UserBitShared.QueryType.valueOf(type_);
        return result == null ? org.apache.drill.exec.proto.UserBitShared.QueryType.SQL : result;
      }
      /**
       * <code>optional .exec.shared.QueryType type = 2;</code>
       * @param value The type to set.
       * @return This builder for chaining.
       */
      public Builder setType(org.apache.drill.exec.proto.UserBitShared.QueryType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        type_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <code>optional .exec.shared.QueryType type = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearType() {
        bitField0_ = (bitField0_ & ~0x00000002);
        type_ = 1;
        onChanged();
        return this;
      }

      private boolean splitPlan_ ;
      /**
       * <code>optional bool split_plan = 3 [default = false];</code>
       * @return Whether the splitPlan field is set.
       */
      @java.lang.Override
      public boolean hasSplitPlan() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <code>optional bool split_plan = 3 [default = false];</code>
       * @return The splitPlan.
       */
      @java.lang.Override
      public boolean getSplitPlan() {
        return splitPlan_;
      }
      /**
       * <code>optional bool split_plan = 3 [default = false];</code>
       * @param value The splitPlan to set.
       * @return This builder for chaining.
       */
      public Builder setSplitPlan(boolean value) {
        bitField0_ |= 0x00000004;
        splitPlan_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool split_plan = 3 [default = false];</code>
       * @return This builder for chaining.
       */
      public Builder clearSplitPlan() {
        bitField0_ = (bitField0_ & ~0x00000004);
        splitPlan_ = false;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:exec.user.GetQueryPlanFragments)
    }

    // @@protoc_insertion_point(class_scope:exec.user.GetQueryPlanFragments)
    private static final org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments();
    }

    public static org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final com.google.protobuf.Parser<GetQueryPlanFragments>
        PARSER = new com.google.protobuf.AbstractParser<GetQueryPlanFragments>() {
      @java.lang.Override
      public GetQueryPlanFragments parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<GetQueryPlanFragments> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GetQueryPlanFragments> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.drill.exec.proto.UserProtos.GetQueryPlanFragments getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface QueryPlanFragmentsOrBuilder extends
      // @@protoc_insertion_point(interface_extends:exec.user.QueryPlanFragments)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>required .exec.shared.QueryResult.QueryState status = 1;</code>
     * @return Whether the status field is set.
     */
    boolean hasStatus();
    /**
     * <code>required .exec.shared.QueryResult.QueryState status = 1;</code>
     * @return The status.
     */
    org.apache.drill.exec.proto.UserBitShared.QueryResult.QueryState getStatus();

    /**
     * <code>optional .exec.shared.QueryId query_id = 2;</code>
     * @return Whether the queryId field is set.
     */
    boolean hasQueryId();
    /**
     * <code>optional .exec.shared.QueryId query_id = 2;</code>
     * @return The queryId.
     */
    org.apache.drill.exec.proto.UserBitShared.QueryId getQueryId();
    /**
     * <code>optional .exec.shared.QueryId query_id = 2;</code>
     */
    org.apache.drill.exec.proto.UserBitShared.QueryIdOrBuilder getQueryIdOrBuilder();

    /**
     * <code>repeated .exec.bit.control.PlanFragment fragments = 3;</code>
     */
    java.util.List<org.apache.drill.exec.proto.BitControl.PlanFragment> 
        getFragmentsList();
    /**
     * <code>repeated .exec.bit.control.PlanFragment fragments = 3;</code>
     */
    org.apache.drill.exec.proto.BitControl.PlanFragment getFragments(int index);
    /**
     * <code>repeated .exec.bit.control.PlanFragment fragments = 3;</code>
     */
    int getFragmentsCount();
    /**
     * <code>repeated .exec.bit.control.PlanFragment fragments = 3;</code>
     */
    java.util.List<? extends org.apache.drill.exec.proto.BitControl.PlanFragmentOrBuilder> 
        getFragmentsOrBuilderList();
    /**
     * <code>repeated .exec.bit.control.PlanFragment fragments = 3;</code>
     */
    org.apache.drill.exec.proto.BitControl.PlanFragmentOrBuilder getFragmentsOrBuilder(
        int index);

    /**
     * <code>optional .exec.shared.DrillPBError error = 4;</code>
     * @return Whether the error field is set.
     */
    boolean hasError();
    /**
     * <code>optional .exec.shared.DrillPBError error = 4;</code>
     * @return The error.
     */
    org.apache.drill.exec.proto.UserBitShared.DrillPBError getError();
    /**
     * <code>optional .exec.shared.DrillPBError error = 4;</code>
     */
    org.apache.drill.exec.proto.UserBitShared.DrillPBErrorOrBuilder getErrorOrBuilder();
  }
  /**
   * Protobuf type {@code exec.user.QueryPlanFragments}
   */
  public static final class QueryPlanFragments extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:exec.user.QueryPlanFragments)
      QueryPlanFragmentsOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use QueryPlanFragments.newBuilder() to construct.
    private QueryPlanFragments(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private QueryPlanFragments() {
      status_ = 0;
      fragments_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new QueryPlanFragments();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_QueryPlanFragments_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_QueryPlanFragments_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.UserProtos.QueryPlanFragments.class, org.apache.drill.exec.proto.UserProtos.QueryPlanFragments.Builder.class);
    }

    private int bitField0_;
    public static final int STATUS_FIELD_NUMBER = 1;
    private int status_;
    /**
     * <code>required .exec.shared.QueryResult.QueryState status = 1;</code>
     * @return Whether the status field is set.
     */
    @java.lang.Override public boolean hasStatus() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>required .exec.shared.QueryResult.QueryState status = 1;</code>
     * @return The status.
     */
    @java.lang.Override public org.apache.drill.exec.proto.UserBitShared.QueryResult.QueryState getStatus() {
      @SuppressWarnings("deprecation")
      org.apache.drill.exec.proto.UserBitShared.QueryResult.QueryState result = org.apache.drill.exec.proto.UserBitShared.QueryResult.QueryState.valueOf(status_);
      return result == null ? org.apache.drill.exec.proto.UserBitShared.QueryResult.QueryState.STARTING : result;
    }

    public static final int QUERY_ID_FIELD_NUMBER = 2;
    private org.apache.drill.exec.proto.UserBitShared.QueryId queryId_;
    /**
     * <code>optional .exec.shared.QueryId query_id = 2;</code>
     * @return Whether the queryId field is set.
     */
    @java.lang.Override
    public boolean hasQueryId() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <code>optional .exec.shared.QueryId query_id = 2;</code>
     * @return The queryId.
     */
    @java.lang.Override
    public org.apache.drill.exec.proto.UserBitShared.QueryId getQueryId() {
      return queryId_ == null ? org.apache.drill.exec.proto.UserBitShared.QueryId.getDefaultInstance() : queryId_;
    }
    /**
     * <code>optional .exec.shared.QueryId query_id = 2;</code>
     */
    @java.lang.Override
    public org.apache.drill.exec.proto.UserBitShared.QueryIdOrBuilder getQueryIdOrBuilder() {
      return queryId_ == null ? org.apache.drill.exec.proto.UserBitShared.QueryId.getDefaultInstance() : queryId_;
    }

    public static final int FRAGMENTS_FIELD_NUMBER = 3;
    private java.util.List<org.apache.drill.exec.proto.BitControl.PlanFragment> fragments_;
    /**
     * <code>repeated .exec.bit.control.PlanFragment fragments = 3;</code>
     */
    @java.lang.Override
    public java.util.List<org.apache.drill.exec.proto.BitControl.PlanFragment> getFragmentsList() {
      return fragments_;
    }
    /**
     * <code>repeated .exec.bit.control.PlanFragment fragments = 3;</code>
     */
    @java.lang.Override
    public java.util.List<? extends org.apache.drill.exec.proto.BitControl.PlanFragmentOrBuilder> 
        getFragmentsOrBuilderList() {
      return fragments_;
    }
    /**
     * <code>repeated .exec.bit.control.PlanFragment fragments = 3;</code>
     */
    @java.lang.Override
    public int getFragmentsCount() {
      return fragments_.size();
    }
    /**
     * <code>repeated .exec.bit.control.PlanFragment fragments = 3;</code>
     */
    @java.lang.Override
    public org.apache.drill.exec.proto.BitControl.PlanFragment getFragments(int index) {
      return fragments_.get(index);
    }
    /**
     * <code>repeated .exec.bit.control.PlanFragment fragments = 3;</code>
     */
    @java.lang.Override
    public org.apache.drill.exec.proto.BitControl.PlanFragmentOrBuilder getFragmentsOrBuilder(
        int index) {
      return fragments_.get(index);
    }

    public static final int ERROR_FIELD_NUMBER = 4;
    private org.apache.drill.exec.proto.UserBitShared.DrillPBError error_;
    /**
     * <code>optional .exec.shared.DrillPBError error = 4;</code>
     * @return Whether the error field is set.
     */
    @java.lang.Override
    public boolean hasError() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <code>optional .exec.shared.DrillPBError error = 4;</code>
     * @return The error.
     */
    @java.lang.Override
    public org.apache.drill.exec.proto.UserBitShared.DrillPBError getError() {
      return error_ == null ? org.apache.drill.exec.proto.UserBitShared.DrillPBError.getDefaultInstance() : error_;
    }
    /**
     * <code>optional .exec.shared.DrillPBError error = 4;</code>
     */
    @java.lang.Override
    public org.apache.drill.exec.proto.UserBitShared.DrillPBErrorOrBuilder getErrorOrBuilder() {
      return error_ == null ? org.apache.drill.exec.proto.UserBitShared.DrillPBError.getDefaultInstance() : error_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasStatus()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeEnum(1, status_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(2, getQueryId());
      }
      for (int i = 0; i < fragments_.size(); i++) {
        output.writeMessage(3, fragments_.get(i));
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeMessage(4, getError());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(1, status_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, getQueryId());
      }
      for (int i = 0; i < fragments_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, fragments_.get(i));
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(4, getError());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.drill.exec.proto.UserProtos.QueryPlanFragments)) {
        return super.equals(obj);
      }
      org.apache.drill.exec.proto.UserProtos.QueryPlanFragments other = (org.apache.drill.exec.proto.UserProtos.QueryPlanFragments) obj;

      if (hasStatus() != other.hasStatus()) return false;
      if (hasStatus()) {
        if (status_ != other.status_) return false;
      }
      if (hasQueryId() != other.hasQueryId()) return false;
      if (hasQueryId()) {
        if (!getQueryId()
            .equals(other.getQueryId())) return false;
      }
      if (!getFragmentsList()
          .equals(other.getFragmentsList())) return false;
      if (hasError() != other.hasError()) return false;
      if (hasError()) {
        if (!getError()
            .equals(other.getError())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasStatus()) {
        hash = (37 * hash) + STATUS_FIELD_NUMBER;
        hash = (53 * hash) + status_;
      }
      if (hasQueryId()) {
        hash = (37 * hash) + QUERY_ID_FIELD_NUMBER;
        hash = (53 * hash) + getQueryId().hashCode();
      }
      if (getFragmentsCount() > 0) {
        hash = (37 * hash) + FRAGMENTS_FIELD_NUMBER;
        hash = (53 * hash) + getFragmentsList().hashCode();
      }
      if (hasError()) {
        hash = (37 * hash) + ERROR_FIELD_NUMBER;
        hash = (53 * hash) + getError().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.drill.exec.proto.UserProtos.QueryPlanFragments parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.QueryPlanFragments parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.QueryPlanFragments parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.QueryPlanFragments parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.QueryPlanFragments parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.QueryPlanFragments parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.QueryPlanFragments parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.QueryPlanFragments parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.QueryPlanFragments parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.QueryPlanFragments parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.QueryPlanFragments parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.QueryPlanFragments parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.drill.exec.proto.UserProtos.QueryPlanFragments prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code exec.user.QueryPlanFragments}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:exec.user.QueryPlanFragments)
        org.apache.drill.exec.proto.UserProtos.QueryPlanFragmentsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_QueryPlanFragments_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_QueryPlanFragments_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.UserProtos.QueryPlanFragments.class, org.apache.drill.exec.proto.UserProtos.QueryPlanFragments.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.UserProtos.QueryPlanFragments.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getQueryIdFieldBuilder();
          getFragmentsFieldBuilder();
          getErrorFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        status_ = 0;
        bitField0_ = (bitField0_ & ~0x00000001);
        if (queryIdBuilder_ == null) {
          queryId_ = null;
        } else {
          queryIdBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        if (fragmentsBuilder_ == null) {
          fragments_ = java.util.Collections.emptyList();
        } else {
          fragments_ = null;
          fragmentsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        if (errorBuilder_ == null) {
          error_ = null;
        } else {
          errorBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000008);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_QueryPlanFragments_descriptor;
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.QueryPlanFragments getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.UserProtos.QueryPlanFragments.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.QueryPlanFragments build() {
        org.apache.drill.exec.proto.UserProtos.QueryPlanFragments result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.QueryPlanFragments buildPartial() {
        org.apache.drill.exec.proto.UserProtos.QueryPlanFragments result = new org.apache.drill.exec.proto.UserProtos.QueryPlanFragments(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          to_bitField0_ |= 0x00000001;
        }
        result.status_ = status_;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          if (queryIdBuilder_ == null) {
            result.queryId_ = queryId_;
          } else {
            result.queryId_ = queryIdBuilder_.build();
          }
          to_bitField0_ |= 0x00000002;
        }
        if (fragmentsBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)) {
            fragments_ = java.util.Collections.unmodifiableList(fragments_);
            bitField0_ = (bitField0_ & ~0x00000004);
          }
          result.fragments_ = fragments_;
        } else {
          result.fragments_ = fragmentsBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          if (errorBuilder_ == null) {
            result.error_ = error_;
          } else {
            result.error_ = errorBuilder_.build();
          }
          to_bitField0_ |= 0x00000004;
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.UserProtos.QueryPlanFragments) {
          return mergeFrom((org.apache.drill.exec.proto.UserProtos.QueryPlanFragments)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.UserProtos.QueryPlanFragments other) {
        if (other == org.apache.drill.exec.proto.UserProtos.QueryPlanFragments.getDefaultInstance()) return this;
        if (other.hasStatus()) {
          setStatus(other.getStatus());
        }
        if (other.hasQueryId()) {
          mergeQueryId(other.getQueryId());
        }
        if (fragmentsBuilder_ == null) {
          if (!other.fragments_.isEmpty()) {
            if (fragments_.isEmpty()) {
              fragments_ = other.fragments_;
              bitField0_ = (bitField0_ & ~0x00000004);
            } else {
              ensureFragmentsIsMutable();
              fragments_.addAll(other.fragments_);
            }
            onChanged();
          }
        } else {
          if (!other.fragments_.isEmpty()) {
            if (fragmentsBuilder_.isEmpty()) {
              fragmentsBuilder_.dispose();
              fragmentsBuilder_ = null;
              fragments_ = other.fragments_;
              bitField0_ = (bitField0_ & ~0x00000004);
              fragmentsBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getFragmentsFieldBuilder() : null;
            } else {
              fragmentsBuilder_.addAllMessages(other.fragments_);
            }
          }
        }
        if (other.hasError()) {
          mergeError(other.getError());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (!hasStatus()) {
          return false;
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8: {
                int tmpRaw = input.readEnum();
                org.apache.drill.exec.proto.UserBitShared.QueryResult.QueryState tmpValue =
                    org.apache.drill.exec.proto.UserBitShared.QueryResult.QueryState.forNumber(tmpRaw);
                if (tmpValue == null) {
                  mergeUnknownVarintField(1, tmpRaw);
                } else {
                  status_ = tmpRaw;
                  bitField0_ |= 0x00000001;
                }
                break;
              } // case 8
              case 18: {
                input.readMessage(
                    getQueryIdFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
              case 26: {
                org.apache.drill.exec.proto.BitControl.PlanFragment m =
                    input.readMessage(
                        org.apache.drill.exec.proto.BitControl.PlanFragment.PARSER,
                        extensionRegistry);
                if (fragmentsBuilder_ == null) {
                  ensureFragmentsIsMutable();
                  fragments_.add(m);
                } else {
                  fragmentsBuilder_.addMessage(m);
                }
                break;
              } // case 26
              case 34: {
                input.readMessage(
                    getErrorFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private int status_ = 0;
      /**
       * <code>required .exec.shared.QueryResult.QueryState status = 1;</code>
       * @return Whether the status field is set.
       */
      @java.lang.Override public boolean hasStatus() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>required .exec.shared.QueryResult.QueryState status = 1;</code>
       * @return The status.
       */
      @java.lang.Override
      public org.apache.drill.exec.proto.UserBitShared.QueryResult.QueryState getStatus() {
        @SuppressWarnings("deprecation")
        org.apache.drill.exec.proto.UserBitShared.QueryResult.QueryState result = org.apache.drill.exec.proto.UserBitShared.QueryResult.QueryState.valueOf(status_);
        return result == null ? org.apache.drill.exec.proto.UserBitShared.QueryResult.QueryState.STARTING : result;
      }
      /**
       * <code>required .exec.shared.QueryResult.QueryState status = 1;</code>
       * @param value The status to set.
       * @return This builder for chaining.
       */
      public Builder setStatus(org.apache.drill.exec.proto.UserBitShared.QueryResult.QueryState value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        status_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <code>required .exec.shared.QueryResult.QueryState status = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearStatus() {
        bitField0_ = (bitField0_ & ~0x00000001);
        status_ = 0;
        onChanged();
        return this;
      }

      private org.apache.drill.exec.proto.UserBitShared.QueryId queryId_;
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.drill.exec.proto.UserBitShared.QueryId, org.apache.drill.exec.proto.UserBitShared.QueryId.Builder, org.apache.drill.exec.proto.UserBitShared.QueryIdOrBuilder> queryIdBuilder_;
      /**
       * <code>optional .exec.shared.QueryId query_id = 2;</code>
       * @return Whether the queryId field is set.
       */
      public boolean hasQueryId() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <code>optional .exec.shared.QueryId query_id = 2;</code>
       * @return The queryId.
       */
      public org.apache.drill.exec.proto.UserBitShared.QueryId getQueryId() {
        if (queryIdBuilder_ == null) {
          return queryId_ == null ? org.apache.drill.exec.proto.UserBitShared.QueryId.getDefaultInstance() : queryId_;
        } else {
          return queryIdBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .exec.shared.QueryId query_id = 2;</code>
       */
      public Builder setQueryId(org.apache.drill.exec.proto.UserBitShared.QueryId value) {
        if (queryIdBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          queryId_ = value;
          onChanged();
        } else {
          queryIdBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       * <code>optional .exec.shared.QueryId query_id = 2;</code>
       */
      public Builder setQueryId(
          org.apache.drill.exec.proto.UserBitShared.QueryId.Builder builderForValue) {
        if (queryIdBuilder_ == null) {
          queryId_ = builderForValue.build();
          onChanged();
        } else {
          queryIdBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       * <code>optional .exec.shared.QueryId query_id = 2;</code>
       */
      public Builder mergeQueryId(org.apache.drill.exec.proto.UserBitShared.QueryId value) {
        if (queryIdBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0) &&
              queryId_ != null &&
              queryId_ != org.apache.drill.exec.proto.UserBitShared.QueryId.getDefaultInstance()) {
            queryId_ =
              org.apache.drill.exec.proto.UserBitShared.QueryId.newBuilder(queryId_).mergeFrom(value).buildPartial();
          } else {
            queryId_ = value;
          }
          onChanged();
        } else {
          queryIdBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       * <code>optional .exec.shared.QueryId query_id = 2;</code>
       */
      public Builder clearQueryId() {
        if (queryIdBuilder_ == null) {
          queryId_ = null;
          onChanged();
        } else {
          queryIdBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }
      /**
       * <code>optional .exec.shared.QueryId query_id = 2;</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.QueryId.Builder getQueryIdBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getQueryIdFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .exec.shared.QueryId query_id = 2;</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.QueryIdOrBuilder getQueryIdOrBuilder() {
        if (queryIdBuilder_ != null) {
          return queryIdBuilder_.getMessageOrBuilder();
        } else {
          return queryId_ == null ?
              org.apache.drill.exec.proto.UserBitShared.QueryId.getDefaultInstance() : queryId_;
        }
      }
      /**
       * <code>optional .exec.shared.QueryId query_id = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.drill.exec.proto.UserBitShared.QueryId, org.apache.drill.exec.proto.UserBitShared.QueryId.Builder, org.apache.drill.exec.proto.UserBitShared.QueryIdOrBuilder> 
          getQueryIdFieldBuilder() {
        if (queryIdBuilder_ == null) {
          queryIdBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.apache.drill.exec.proto.UserBitShared.QueryId, org.apache.drill.exec.proto.UserBitShared.QueryId.Builder, org.apache.drill.exec.proto.UserBitShared.QueryIdOrBuilder>(
                  getQueryId(),
                  getParentForChildren(),
                  isClean());
          queryId_ = null;
        }
        return queryIdBuilder_;
      }

      private java.util.List<org.apache.drill.exec.proto.BitControl.PlanFragment> fragments_ =
        java.util.Collections.emptyList();
      private void ensureFragmentsIsMutable() {
        if (!((bitField0_ & 0x00000004) != 0)) {
          fragments_ = new java.util.ArrayList<org.apache.drill.exec.proto.BitControl.PlanFragment>(fragments_);
          bitField0_ |= 0x00000004;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          org.apache.drill.exec.proto.BitControl.PlanFragment, org.apache.drill.exec.proto.BitControl.PlanFragment.Builder, org.apache.drill.exec.proto.BitControl.PlanFragmentOrBuilder> fragmentsBuilder_;

      /**
       * <code>repeated .exec.bit.control.PlanFragment fragments = 3;</code>
       */
      public java.util.List<org.apache.drill.exec.proto.BitControl.PlanFragment> getFragmentsList() {
        if (fragmentsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(fragments_);
        } else {
          return fragmentsBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .exec.bit.control.PlanFragment fragments = 3;</code>
       */
      public int getFragmentsCount() {
        if (fragmentsBuilder_ == null) {
          return fragments_.size();
        } else {
          return fragmentsBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .exec.bit.control.PlanFragment fragments = 3;</code>
       */
      public org.apache.drill.exec.proto.BitControl.PlanFragment getFragments(int index) {
        if (fragmentsBuilder_ == null) {
          return fragments_.get(index);
        } else {
          return fragmentsBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .exec.bit.control.PlanFragment fragments = 3;</code>
       */
      public Builder setFragments(
          int index, org.apache.drill.exec.proto.BitControl.PlanFragment value) {
        if (fragmentsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFragmentsIsMutable();
          fragments_.set(index, value);
          onChanged();
        } else {
          fragmentsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .exec.bit.control.PlanFragment fragments = 3;</code>
       */
      public Builder setFragments(
          int index, org.apache.drill.exec.proto.BitControl.PlanFragment.Builder builderForValue) {
        if (fragmentsBuilder_ == null) {
          ensureFragmentsIsMutable();
          fragments_.set(index, builderForValue.build());
          onChanged();
        } else {
          fragmentsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .exec.bit.control.PlanFragment fragments = 3;</code>
       */
      public Builder addFragments(org.apache.drill.exec.proto.BitControl.PlanFragment value) {
        if (fragmentsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFragmentsIsMutable();
          fragments_.add(value);
          onChanged();
        } else {
          fragmentsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .exec.bit.control.PlanFragment fragments = 3;</code>
       */
      public Builder addFragments(
          int index, org.apache.drill.exec.proto.BitControl.PlanFragment value) {
        if (fragmentsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFragmentsIsMutable();
          fragments_.add(index, value);
          onChanged();
        } else {
          fragmentsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .exec.bit.control.PlanFragment fragments = 3;</code>
       */
      public Builder addFragments(
          org.apache.drill.exec.proto.BitControl.PlanFragment.Builder builderForValue) {
        if (fragmentsBuilder_ == null) {
          ensureFragmentsIsMutable();
          fragments_.add(builderForValue.build());
          onChanged();
        } else {
          fragmentsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .exec.bit.control.PlanFragment fragments = 3;</code>
       */
      public Builder addFragments(
          int index, org.apache.drill.exec.proto.BitControl.PlanFragment.Builder builderForValue) {
        if (fragmentsBuilder_ == null) {
          ensureFragmentsIsMutable();
          fragments_.add(index, builderForValue.build());
          onChanged();
        } else {
          fragmentsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .exec.bit.control.PlanFragment fragments = 3;</code>
       */
      public Builder addAllFragments(
          java.lang.Iterable<? extends org.apache.drill.exec.proto.BitControl.PlanFragment> values) {
        if (fragmentsBuilder_ == null) {
          ensureFragmentsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, fragments_);
          onChanged();
        } else {
          fragmentsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .exec.bit.control.PlanFragment fragments = 3;</code>
       */
      public Builder clearFragments() {
        if (fragmentsBuilder_ == null) {
          fragments_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
        } else {
          fragmentsBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .exec.bit.control.PlanFragment fragments = 3;</code>
       */
      public Builder removeFragments(int index) {
        if (fragmentsBuilder_ == null) {
          ensureFragmentsIsMutable();
          fragments_.remove(index);
          onChanged();
        } else {
          fragmentsBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .exec.bit.control.PlanFragment fragments = 3;</code>
       */
      public org.apache.drill.exec.proto.BitControl.PlanFragment.Builder getFragmentsBuilder(
          int index) {
        return getFragmentsFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .exec.bit.control.PlanFragment fragments = 3;</code>
       */
      public org.apache.drill.exec.proto.BitControl.PlanFragmentOrBuilder getFragmentsOrBuilder(
          int index) {
        if (fragmentsBuilder_ == null) {
          return fragments_.get(index);  } else {
          return fragmentsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .exec.bit.control.PlanFragment fragments = 3;</code>
       */
      public java.util.List<? extends org.apache.drill.exec.proto.BitControl.PlanFragmentOrBuilder> 
           getFragmentsOrBuilderList() {
        if (fragmentsBuilder_ != null) {
          return fragmentsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(fragments_);
        }
      }
      /**
       * <code>repeated .exec.bit.control.PlanFragment fragments = 3;</code>
       */
      public org.apache.drill.exec.proto.BitControl.PlanFragment.Builder addFragmentsBuilder() {
        return getFragmentsFieldBuilder().addBuilder(
            org.apache.drill.exec.proto.BitControl.PlanFragment.getDefaultInstance());
      }
      /**
       * <code>repeated .exec.bit.control.PlanFragment fragments = 3;</code>
       */
      public org.apache.drill.exec.proto.BitControl.PlanFragment.Builder addFragmentsBuilder(
          int index) {
        return getFragmentsFieldBuilder().addBuilder(
            index, org.apache.drill.exec.proto.BitControl.PlanFragment.getDefaultInstance());
      }
      /**
       * <code>repeated .exec.bit.control.PlanFragment fragments = 3;</code>
       */
      public java.util.List<org.apache.drill.exec.proto.BitControl.PlanFragment.Builder> 
           getFragmentsBuilderList() {
        return getFragmentsFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          org.apache.drill.exec.proto.BitControl.PlanFragment, org.apache.drill.exec.proto.BitControl.PlanFragment.Builder, org.apache.drill.exec.proto.BitControl.PlanFragmentOrBuilder> 
          getFragmentsFieldBuilder() {
        if (fragmentsBuilder_ == null) {
          fragmentsBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              org.apache.drill.exec.proto.BitControl.PlanFragment, org.apache.drill.exec.proto.BitControl.PlanFragment.Builder, org.apache.drill.exec.proto.BitControl.PlanFragmentOrBuilder>(
                  fragments_,
                  ((bitField0_ & 0x00000004) != 0),
                  getParentForChildren(),
                  isClean());
          fragments_ = null;
        }
        return fragmentsBuilder_;
      }

      private org.apache.drill.exec.proto.UserBitShared.DrillPBError error_;
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.drill.exec.proto.UserBitShared.DrillPBError, org.apache.drill.exec.proto.UserBitShared.DrillPBError.Builder, org.apache.drill.exec.proto.UserBitShared.DrillPBErrorOrBuilder> errorBuilder_;
      /**
       * <code>optional .exec.shared.DrillPBError error = 4;</code>
       * @return Whether the error field is set.
       */
      public boolean hasError() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 4;</code>
       * @return The error.
       */
      public org.apache.drill.exec.proto.UserBitShared.DrillPBError getError() {
        if (errorBuilder_ == null) {
          return error_ == null ? org.apache.drill.exec.proto.UserBitShared.DrillPBError.getDefaultInstance() : error_;
        } else {
          return errorBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 4;</code>
       */
      public Builder setError(org.apache.drill.exec.proto.UserBitShared.DrillPBError value) {
        if (errorBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          error_ = value;
          onChanged();
        } else {
          errorBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        return this;
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 4;</code>
       */
      public Builder setError(
          org.apache.drill.exec.proto.UserBitShared.DrillPBError.Builder builderForValue) {
        if (errorBuilder_ == null) {
          error_ = builderForValue.build();
          onChanged();
        } else {
          errorBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        return this;
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 4;</code>
       */
      public Builder mergeError(org.apache.drill.exec.proto.UserBitShared.DrillPBError value) {
        if (errorBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0) &&
              error_ != null &&
              error_ != org.apache.drill.exec.proto.UserBitShared.DrillPBError.getDefaultInstance()) {
            error_ =
              org.apache.drill.exec.proto.UserBitShared.DrillPBError.newBuilder(error_).mergeFrom(value).buildPartial();
          } else {
            error_ = value;
          }
          onChanged();
        } else {
          errorBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000008;
        return this;
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 4;</code>
       */
      public Builder clearError() {
        if (errorBuilder_ == null) {
          error_ = null;
          onChanged();
        } else {
          errorBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000008);
        return this;
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 4;</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.DrillPBError.Builder getErrorBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getErrorFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 4;</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.DrillPBErrorOrBuilder getErrorOrBuilder() {
        if (errorBuilder_ != null) {
          return errorBuilder_.getMessageOrBuilder();
        } else {
          return error_ == null ?
              org.apache.drill.exec.proto.UserBitShared.DrillPBError.getDefaultInstance() : error_;
        }
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.drill.exec.proto.UserBitShared.DrillPBError, org.apache.drill.exec.proto.UserBitShared.DrillPBError.Builder, org.apache.drill.exec.proto.UserBitShared.DrillPBErrorOrBuilder> 
          getErrorFieldBuilder() {
        if (errorBuilder_ == null) {
          errorBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.apache.drill.exec.proto.UserBitShared.DrillPBError, org.apache.drill.exec.proto.UserBitShared.DrillPBError.Builder, org.apache.drill.exec.proto.UserBitShared.DrillPBErrorOrBuilder>(
                  getError(),
                  getParentForChildren(),
                  isClean());
          error_ = null;
        }
        return errorBuilder_;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:exec.user.QueryPlanFragments)
    }

    // @@protoc_insertion_point(class_scope:exec.user.QueryPlanFragments)
    private static final org.apache.drill.exec.proto.UserProtos.QueryPlanFragments DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.drill.exec.proto.UserProtos.QueryPlanFragments();
    }

    public static org.apache.drill.exec.proto.UserProtos.QueryPlanFragments getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final com.google.protobuf.Parser<QueryPlanFragments>
        PARSER = new com.google.protobuf.AbstractParser<QueryPlanFragments>() {
      @java.lang.Override
      public QueryPlanFragments parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<QueryPlanFragments> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<QueryPlanFragments> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.drill.exec.proto.UserProtos.QueryPlanFragments getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface BitToUserHandshakeOrBuilder extends
      // @@protoc_insertion_point(interface_extends:exec.user.BitToUserHandshake)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>optional int32 rpc_version = 2;</code>
     * @return Whether the rpcVersion field is set.
     */
    boolean hasRpcVersion();
    /**
     * <code>optional int32 rpc_version = 2;</code>
     * @return The rpcVersion.
     */
    int getRpcVersion();

    /**
     * <code>optional .exec.user.HandshakeStatus status = 3;</code>
     * @return Whether the status field is set.
     */
    boolean hasStatus();
    /**
     * <code>optional .exec.user.HandshakeStatus status = 3;</code>
     * @return The status.
     */
    org.apache.drill.exec.proto.UserProtos.HandshakeStatus getStatus();

    /**
     * <code>optional string errorId = 4;</code>
     * @return Whether the errorId field is set.
     */
    boolean hasErrorId();
    /**
     * <code>optional string errorId = 4;</code>
     * @return The errorId.
     */
    java.lang.String getErrorId();
    /**
     * <code>optional string errorId = 4;</code>
     * @return The bytes for errorId.
     */
    com.google.protobuf.ByteString
        getErrorIdBytes();

    /**
     * <code>optional string errorMessage = 5;</code>
     * @return Whether the errorMessage field is set.
     */
    boolean hasErrorMessage();
    /**
     * <code>optional string errorMessage = 5;</code>
     * @return The errorMessage.
     */
    java.lang.String getErrorMessage();
    /**
     * <code>optional string errorMessage = 5;</code>
     * @return The bytes for errorMessage.
     */
    com.google.protobuf.ByteString
        getErrorMessageBytes();

    /**
     * <code>optional .exec.user.RpcEndpointInfos server_infos = 6;</code>
     * @return Whether the serverInfos field is set.
     */
    boolean hasServerInfos();
    /**
     * <code>optional .exec.user.RpcEndpointInfos server_infos = 6;</code>
     * @return The serverInfos.
     */
    org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos getServerInfos();
    /**
     * <code>optional .exec.user.RpcEndpointInfos server_infos = 6;</code>
     */
    org.apache.drill.exec.proto.UserProtos.RpcEndpointInfosOrBuilder getServerInfosOrBuilder();

    /**
     * <code>repeated string authenticationMechanisms = 7;</code>
     * @return A list containing the authenticationMechanisms.
     */
    java.util.List<java.lang.String>
        getAuthenticationMechanismsList();
    /**
     * <code>repeated string authenticationMechanisms = 7;</code>
     * @return The count of authenticationMechanisms.
     */
    int getAuthenticationMechanismsCount();
    /**
     * <code>repeated string authenticationMechanisms = 7;</code>
     * @param index The index of the element to return.
     * @return The authenticationMechanisms at the given index.
     */
    java.lang.String getAuthenticationMechanisms(int index);
    /**
     * <code>repeated string authenticationMechanisms = 7;</code>
     * @param index The index of the value to return.
     * @return The bytes of the authenticationMechanisms at the given index.
     */
    com.google.protobuf.ByteString
        getAuthenticationMechanismsBytes(int index);

    /**
     * <code>repeated .exec.user.RpcType supported_methods = 8;</code>
     * @return A list containing the supportedMethods.
     */
    java.util.List<org.apache.drill.exec.proto.UserProtos.RpcType> getSupportedMethodsList();
    /**
     * <code>repeated .exec.user.RpcType supported_methods = 8;</code>
     * @return The count of supportedMethods.
     */
    int getSupportedMethodsCount();
    /**
     * <code>repeated .exec.user.RpcType supported_methods = 8;</code>
     * @param index The index of the element to return.
     * @return The supportedMethods at the given index.
     */
    org.apache.drill.exec.proto.UserProtos.RpcType getSupportedMethods(int index);

    /**
     * <code>optional bool encrypted = 9;</code>
     * @return Whether the encrypted field is set.
     */
    boolean hasEncrypted();
    /**
     * <code>optional bool encrypted = 9;</code>
     * @return The encrypted.
     */
    boolean getEncrypted();

    /**
     * <code>optional int32 maxWrappedSize = 10;</code>
     * @return Whether the maxWrappedSize field is set.
     */
    boolean hasMaxWrappedSize();
    /**
     * <code>optional int32 maxWrappedSize = 10;</code>
     * @return The maxWrappedSize.
     */
    int getMaxWrappedSize();
  }
  /**
   * Protobuf type {@code exec.user.BitToUserHandshake}
   */
  public static final class BitToUserHandshake extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:exec.user.BitToUserHandshake)
      BitToUserHandshakeOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use BitToUserHandshake.newBuilder() to construct.
    private BitToUserHandshake(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private BitToUserHandshake() {
      status_ = 1;
      errorId_ = "";
      errorMessage_ = "";
      authenticationMechanisms_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      supportedMethods_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new BitToUserHandshake();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_BitToUserHandshake_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_BitToUserHandshake_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.UserProtos.BitToUserHandshake.class, org.apache.drill.exec.proto.UserProtos.BitToUserHandshake.Builder.class);
    }

    private int bitField0_;
    public static final int RPC_VERSION_FIELD_NUMBER = 2;
    private int rpcVersion_;
    /**
     * <code>optional int32 rpc_version = 2;</code>
     * @return Whether the rpcVersion field is set.
     */
    @java.lang.Override
    public boolean hasRpcVersion() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>optional int32 rpc_version = 2;</code>
     * @return The rpcVersion.
     */
    @java.lang.Override
    public int getRpcVersion() {
      return rpcVersion_;
    }

    public static final int STATUS_FIELD_NUMBER = 3;
    private int status_;
    /**
     * <code>optional .exec.user.HandshakeStatus status = 3;</code>
     * @return Whether the status field is set.
     */
    @java.lang.Override public boolean hasStatus() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <code>optional .exec.user.HandshakeStatus status = 3;</code>
     * @return The status.
     */
    @java.lang.Override public org.apache.drill.exec.proto.UserProtos.HandshakeStatus getStatus() {
      @SuppressWarnings("deprecation")
      org.apache.drill.exec.proto.UserProtos.HandshakeStatus result = org.apache.drill.exec.proto.UserProtos.HandshakeStatus.valueOf(status_);
      return result == null ? org.apache.drill.exec.proto.UserProtos.HandshakeStatus.SUCCESS : result;
    }

    public static final int ERRORID_FIELD_NUMBER = 4;
    private volatile java.lang.Object errorId_;
    /**
     * <code>optional string errorId = 4;</code>
     * @return Whether the errorId field is set.
     */
    @java.lang.Override
    public boolean hasErrorId() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <code>optional string errorId = 4;</code>
     * @return The errorId.
     */
    @java.lang.Override
    public java.lang.String getErrorId() {
      java.lang.Object ref = errorId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          errorId_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string errorId = 4;</code>
     * @return The bytes for errorId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getErrorIdBytes() {
      java.lang.Object ref = errorId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        errorId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ERRORMESSAGE_FIELD_NUMBER = 5;
    private volatile java.lang.Object errorMessage_;
    /**
     * <code>optional string errorMessage = 5;</code>
     * @return Whether the errorMessage field is set.
     */
    @java.lang.Override
    public boolean hasErrorMessage() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     * <code>optional string errorMessage = 5;</code>
     * @return The errorMessage.
     */
    @java.lang.Override
    public java.lang.String getErrorMessage() {
      java.lang.Object ref = errorMessage_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          errorMessage_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string errorMessage = 5;</code>
     * @return The bytes for errorMessage.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getErrorMessageBytes() {
      java.lang.Object ref = errorMessage_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        errorMessage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SERVER_INFOS_FIELD_NUMBER = 6;
    private org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos serverInfos_;
    /**
     * <code>optional .exec.user.RpcEndpointInfos server_infos = 6;</code>
     * @return Whether the serverInfos field is set.
     */
    @java.lang.Override
    public boolean hasServerInfos() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     * <code>optional .exec.user.RpcEndpointInfos server_infos = 6;</code>
     * @return The serverInfos.
     */
    @java.lang.Override
    public org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos getServerInfos() {
      return serverInfos_ == null ? org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos.getDefaultInstance() : serverInfos_;
    }
    /**
     * <code>optional .exec.user.RpcEndpointInfos server_infos = 6;</code>
     */
    @java.lang.Override
    public org.apache.drill.exec.proto.UserProtos.RpcEndpointInfosOrBuilder getServerInfosOrBuilder() {
      return serverInfos_ == null ? org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos.getDefaultInstance() : serverInfos_;
    }

    public static final int AUTHENTICATIONMECHANISMS_FIELD_NUMBER = 7;
    private com.google.protobuf.LazyStringList authenticationMechanisms_;
    /**
     * <code>repeated string authenticationMechanisms = 7;</code>
     * @return A list containing the authenticationMechanisms.
     */
    public com.google.protobuf.ProtocolStringList
        getAuthenticationMechanismsList() {
      return authenticationMechanisms_;
    }
    /**
     * <code>repeated string authenticationMechanisms = 7;</code>
     * @return The count of authenticationMechanisms.
     */
    public int getAuthenticationMechanismsCount() {
      return authenticationMechanisms_.size();
    }
    /**
     * <code>repeated string authenticationMechanisms = 7;</code>
     * @param index The index of the element to return.
     * @return The authenticationMechanisms at the given index.
     */
    public java.lang.String getAuthenticationMechanisms(int index) {
      return authenticationMechanisms_.get(index);
    }
    /**
     * <code>repeated string authenticationMechanisms = 7;</code>
     * @param index The index of the value to return.
     * @return The bytes of the authenticationMechanisms at the given index.
     */
    public com.google.protobuf.ByteString
        getAuthenticationMechanismsBytes(int index) {
      return authenticationMechanisms_.getByteString(index);
    }

    public static final int SUPPORTED_METHODS_FIELD_NUMBER = 8;
    private java.util.List<java.lang.Integer> supportedMethods_;
    private static final com.google.protobuf.Internal.ListAdapter.Converter<
        java.lang.Integer, org.apache.drill.exec.proto.UserProtos.RpcType> supportedMethods_converter_ =
            new com.google.protobuf.Internal.ListAdapter.Converter<
                java.lang.Integer, org.apache.drill.exec.proto.UserProtos.RpcType>() {
              public org.apache.drill.exec.proto.UserProtos.RpcType convert(java.lang.Integer from) {
                @SuppressWarnings("deprecation")
                org.apache.drill.exec.proto.UserProtos.RpcType result = org.apache.drill.exec.proto.UserProtos.RpcType.valueOf(from);
                return result == null ? org.apache.drill.exec.proto.UserProtos.RpcType.HANDSHAKE : result;
              }
            };
    /**
     * <code>repeated .exec.user.RpcType supported_methods = 8;</code>
     * @return A list containing the supportedMethods.
     */
    @java.lang.Override
    public java.util.List<org.apache.drill.exec.proto.UserProtos.RpcType> getSupportedMethodsList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, org.apache.drill.exec.proto.UserProtos.RpcType>(supportedMethods_, supportedMethods_converter_);
    }
    /**
     * <code>repeated .exec.user.RpcType supported_methods = 8;</code>
     * @return The count of supportedMethods.
     */
    @java.lang.Override
    public int getSupportedMethodsCount() {
      return supportedMethods_.size();
    }
    /**
     * <code>repeated .exec.user.RpcType supported_methods = 8;</code>
     * @param index The index of the element to return.
     * @return The supportedMethods at the given index.
     */
    @java.lang.Override
    public org.apache.drill.exec.proto.UserProtos.RpcType getSupportedMethods(int index) {
      return supportedMethods_converter_.convert(supportedMethods_.get(index));
    }

    public static final int ENCRYPTED_FIELD_NUMBER = 9;
    private boolean encrypted_;
    /**
     * <code>optional bool encrypted = 9;</code>
     * @return Whether the encrypted field is set.
     */
    @java.lang.Override
    public boolean hasEncrypted() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     * <code>optional bool encrypted = 9;</code>
     * @return The encrypted.
     */
    @java.lang.Override
    public boolean getEncrypted() {
      return encrypted_;
    }

    public static final int MAXWRAPPEDSIZE_FIELD_NUMBER = 10;
    private int maxWrappedSize_;
    /**
     * <code>optional int32 maxWrappedSize = 10;</code>
     * @return Whether the maxWrappedSize field is set.
     */
    @java.lang.Override
    public boolean hasMaxWrappedSize() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     * <code>optional int32 maxWrappedSize = 10;</code>
     * @return The maxWrappedSize.
     */
    @java.lang.Override
    public int getMaxWrappedSize() {
      return maxWrappedSize_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeInt32(2, rpcVersion_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeEnum(3, status_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, errorId_);
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, errorMessage_);
      }
      if (((bitField0_ & 0x00000010) != 0)) {
        output.writeMessage(6, getServerInfos());
      }
      for (int i = 0; i < authenticationMechanisms_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 7, authenticationMechanisms_.getRaw(i));
      }
      for (int i = 0; i < supportedMethods_.size(); i++) {
        output.writeEnum(8, supportedMethods_.get(i));
      }
      if (((bitField0_ & 0x00000020) != 0)) {
        output.writeBool(9, encrypted_);
      }
      if (((bitField0_ & 0x00000040) != 0)) {
        output.writeInt32(10, maxWrappedSize_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(2, rpcVersion_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(3, status_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, errorId_);
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, errorMessage_);
      }
      if (((bitField0_ & 0x00000010) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(6, getServerInfos());
      }
      {
        int dataSize = 0;
        for (int i = 0; i < authenticationMechanisms_.size(); i++) {
          dataSize += computeStringSizeNoTag(authenticationMechanisms_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getAuthenticationMechanismsList().size();
      }
      {
        int dataSize = 0;
        for (int i = 0; i < supportedMethods_.size(); i++) {
          dataSize += com.google.protobuf.CodedOutputStream
            .computeEnumSizeNoTag(supportedMethods_.get(i));
        }
        size += dataSize;
        size += 1 * supportedMethods_.size();
      }
      if (((bitField0_ & 0x00000020) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(9, encrypted_);
      }
      if (((bitField0_ & 0x00000040) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(10, maxWrappedSize_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.drill.exec.proto.UserProtos.BitToUserHandshake)) {
        return super.equals(obj);
      }
      org.apache.drill.exec.proto.UserProtos.BitToUserHandshake other = (org.apache.drill.exec.proto.UserProtos.BitToUserHandshake) obj;

      if (hasRpcVersion() != other.hasRpcVersion()) return false;
      if (hasRpcVersion()) {
        if (getRpcVersion()
            != other.getRpcVersion()) return false;
      }
      if (hasStatus() != other.hasStatus()) return false;
      if (hasStatus()) {
        if (status_ != other.status_) return false;
      }
      if (hasErrorId() != other.hasErrorId()) return false;
      if (hasErrorId()) {
        if (!getErrorId()
            .equals(other.getErrorId())) return false;
      }
      if (hasErrorMessage() != other.hasErrorMessage()) return false;
      if (hasErrorMessage()) {
        if (!getErrorMessage()
            .equals(other.getErrorMessage())) return false;
      }
      if (hasServerInfos() != other.hasServerInfos()) return false;
      if (hasServerInfos()) {
        if (!getServerInfos()
            .equals(other.getServerInfos())) return false;
      }
      if (!getAuthenticationMechanismsList()
          .equals(other.getAuthenticationMechanismsList())) return false;
      if (!supportedMethods_.equals(other.supportedMethods_)) return false;
      if (hasEncrypted() != other.hasEncrypted()) return false;
      if (hasEncrypted()) {
        if (getEncrypted()
            != other.getEncrypted()) return false;
      }
      if (hasMaxWrappedSize() != other.hasMaxWrappedSize()) return false;
      if (hasMaxWrappedSize()) {
        if (getMaxWrappedSize()
            != other.getMaxWrappedSize()) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasRpcVersion()) {
        hash = (37 * hash) + RPC_VERSION_FIELD_NUMBER;
        hash = (53 * hash) + getRpcVersion();
      }
      if (hasStatus()) {
        hash = (37 * hash) + STATUS_FIELD_NUMBER;
        hash = (53 * hash) + status_;
      }
      if (hasErrorId()) {
        hash = (37 * hash) + ERRORID_FIELD_NUMBER;
        hash = (53 * hash) + getErrorId().hashCode();
      }
      if (hasErrorMessage()) {
        hash = (37 * hash) + ERRORMESSAGE_FIELD_NUMBER;
        hash = (53 * hash) + getErrorMessage().hashCode();
      }
      if (hasServerInfos()) {
        hash = (37 * hash) + SERVER_INFOS_FIELD_NUMBER;
        hash = (53 * hash) + getServerInfos().hashCode();
      }
      if (getAuthenticationMechanismsCount() > 0) {
        hash = (37 * hash) + AUTHENTICATIONMECHANISMS_FIELD_NUMBER;
        hash = (53 * hash) + getAuthenticationMechanismsList().hashCode();
      }
      if (getSupportedMethodsCount() > 0) {
        hash = (37 * hash) + SUPPORTED_METHODS_FIELD_NUMBER;
        hash = (53 * hash) + supportedMethods_.hashCode();
      }
      if (hasEncrypted()) {
        hash = (37 * hash) + ENCRYPTED_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
            getEncrypted());
      }
      if (hasMaxWrappedSize()) {
        hash = (37 * hash) + MAXWRAPPEDSIZE_FIELD_NUMBER;
        hash = (53 * hash) + getMaxWrappedSize();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.drill.exec.proto.UserProtos.BitToUserHandshake parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.BitToUserHandshake parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.BitToUserHandshake parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.BitToUserHandshake parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.BitToUserHandshake parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.BitToUserHandshake parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.BitToUserHandshake parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.BitToUserHandshake parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.BitToUserHandshake parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.BitToUserHandshake parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.BitToUserHandshake parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.BitToUserHandshake parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.drill.exec.proto.UserProtos.BitToUserHandshake prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code exec.user.BitToUserHandshake}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:exec.user.BitToUserHandshake)
        org.apache.drill.exec.proto.UserProtos.BitToUserHandshakeOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_BitToUserHandshake_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_BitToUserHandshake_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.UserProtos.BitToUserHandshake.class, org.apache.drill.exec.proto.UserProtos.BitToUserHandshake.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.UserProtos.BitToUserHandshake.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getServerInfosFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        rpcVersion_ = 0;
        bitField0_ = (bitField0_ & ~0x00000001);
        status_ = 1;
        bitField0_ = (bitField0_ & ~0x00000002);
        errorId_ = "";
        bitField0_ = (bitField0_ & ~0x00000004);
        errorMessage_ = "";
        bitField0_ = (bitField0_ & ~0x00000008);
        if (serverInfosBuilder_ == null) {
          serverInfos_ = null;
        } else {
          serverInfosBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000010);
        authenticationMechanisms_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000020);
        supportedMethods_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000040);
        encrypted_ = false;
        bitField0_ = (bitField0_ & ~0x00000080);
        maxWrappedSize_ = 0;
        bitField0_ = (bitField0_ & ~0x00000100);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_BitToUserHandshake_descriptor;
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.BitToUserHandshake getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.UserProtos.BitToUserHandshake.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.BitToUserHandshake build() {
        org.apache.drill.exec.proto.UserProtos.BitToUserHandshake result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.BitToUserHandshake buildPartial() {
        org.apache.drill.exec.proto.UserProtos.BitToUserHandshake result = new org.apache.drill.exec.proto.UserProtos.BitToUserHandshake(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.rpcVersion_ = rpcVersion_;
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          to_bitField0_ |= 0x00000002;
        }
        result.status_ = status_;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          to_bitField0_ |= 0x00000004;
        }
        result.errorId_ = errorId_;
        if (((from_bitField0_ & 0x00000008) != 0)) {
          to_bitField0_ |= 0x00000008;
        }
        result.errorMessage_ = errorMessage_;
        if (((from_bitField0_ & 0x00000010) != 0)) {
          if (serverInfosBuilder_ == null) {
            result.serverInfos_ = serverInfos_;
          } else {
            result.serverInfos_ = serverInfosBuilder_.build();
          }
          to_bitField0_ |= 0x00000010;
        }
        if (((bitField0_ & 0x00000020) != 0)) {
          authenticationMechanisms_ = authenticationMechanisms_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.authenticationMechanisms_ = authenticationMechanisms_;
        if (((bitField0_ & 0x00000040) != 0)) {
          supportedMethods_ = java.util.Collections.unmodifiableList(supportedMethods_);
          bitField0_ = (bitField0_ & ~0x00000040);
        }
        result.supportedMethods_ = supportedMethods_;
        if (((from_bitField0_ & 0x00000080) != 0)) {
          result.encrypted_ = encrypted_;
          to_bitField0_ |= 0x00000020;
        }
        if (((from_bitField0_ & 0x00000100) != 0)) {
          result.maxWrappedSize_ = maxWrappedSize_;
          to_bitField0_ |= 0x00000040;
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.UserProtos.BitToUserHandshake) {
          return mergeFrom((org.apache.drill.exec.proto.UserProtos.BitToUserHandshake)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.UserProtos.BitToUserHandshake other) {
        if (other == org.apache.drill.exec.proto.UserProtos.BitToUserHandshake.getDefaultInstance()) return this;
        if (other.hasRpcVersion()) {
          setRpcVersion(other.getRpcVersion());
        }
        if (other.hasStatus()) {
          setStatus(other.getStatus());
        }
        if (other.hasErrorId()) {
          bitField0_ |= 0x00000004;
          errorId_ = other.errorId_;
          onChanged();
        }
        if (other.hasErrorMessage()) {
          bitField0_ |= 0x00000008;
          errorMessage_ = other.errorMessage_;
          onChanged();
        }
        if (other.hasServerInfos()) {
          mergeServerInfos(other.getServerInfos());
        }
        if (!other.authenticationMechanisms_.isEmpty()) {
          if (authenticationMechanisms_.isEmpty()) {
            authenticationMechanisms_ = other.authenticationMechanisms_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureAuthenticationMechanismsIsMutable();
            authenticationMechanisms_.addAll(other.authenticationMechanisms_);
          }
          onChanged();
        }
        if (!other.supportedMethods_.isEmpty()) {
          if (supportedMethods_.isEmpty()) {
            supportedMethods_ = other.supportedMethods_;
            bitField0_ = (bitField0_ & ~0x00000040);
          } else {
            ensureSupportedMethodsIsMutable();
            supportedMethods_.addAll(other.supportedMethods_);
          }
          onChanged();
        }
        if (other.hasEncrypted()) {
          setEncrypted(other.getEncrypted());
        }
        if (other.hasMaxWrappedSize()) {
          setMaxWrappedSize(other.getMaxWrappedSize());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 16: {
                rpcVersion_ = input.readInt32();
                bitField0_ |= 0x00000001;
                break;
              } // case 16
              case 24: {
                int tmpRaw = input.readEnum();
                org.apache.drill.exec.proto.UserProtos.HandshakeStatus tmpValue =
                    org.apache.drill.exec.proto.UserProtos.HandshakeStatus.forNumber(tmpRaw);
                if (tmpValue == null) {
                  mergeUnknownVarintField(3, tmpRaw);
                } else {
                  status_ = tmpRaw;
                  bitField0_ |= 0x00000002;
                }
                break;
              } // case 24
              case 34: {
                errorId_ = input.readBytes();
                bitField0_ |= 0x00000004;
                break;
              } // case 34
              case 42: {
                errorMessage_ = input.readBytes();
                bitField0_ |= 0x00000008;
                break;
              } // case 42
              case 50: {
                input.readMessage(
                    getServerInfosFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 50
              case 58: {
                com.google.protobuf.ByteString bs = input.readBytes();
                ensureAuthenticationMechanismsIsMutable();
                authenticationMechanisms_.add(bs);
                break;
              } // case 58
              case 64: {
                int tmpRaw = input.readEnum();
                org.apache.drill.exec.proto.UserProtos.RpcType tmpValue =
                    org.apache.drill.exec.proto.UserProtos.RpcType.forNumber(tmpRaw);
                if (tmpValue == null) {
                  mergeUnknownVarintField(8, tmpRaw);
                } else {
                  ensureSupportedMethodsIsMutable();
                  supportedMethods_.add(tmpRaw);
                }
                break;
              } // case 64
              case 66: {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while(input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  org.apache.drill.exec.proto.UserProtos.RpcType tmpValue =
                      org.apache.drill.exec.proto.UserProtos.RpcType.forNumber(tmpRaw);
                  if (tmpValue == null) {
                    mergeUnknownVarintField(8, tmpRaw);
                  } else {
                    ensureSupportedMethodsIsMutable();
                    supportedMethods_.add(tmpRaw);
                  }
                }
                input.popLimit(oldLimit);
                break;
              } // case 66
              case 72: {
                encrypted_ = input.readBool();
                bitField0_ |= 0x00000080;
                break;
              } // case 72
              case 80: {
                maxWrappedSize_ = input.readInt32();
                bitField0_ |= 0x00000100;
                break;
              } // case 80
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private int rpcVersion_ ;
      /**
       * <code>optional int32 rpc_version = 2;</code>
       * @return Whether the rpcVersion field is set.
       */
      @java.lang.Override
      public boolean hasRpcVersion() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>optional int32 rpc_version = 2;</code>
       * @return The rpcVersion.
       */
      @java.lang.Override
      public int getRpcVersion() {
        return rpcVersion_;
      }
      /**
       * <code>optional int32 rpc_version = 2;</code>
       * @param value The rpcVersion to set.
       * @return This builder for chaining.
       */
      public Builder setRpcVersion(int value) {
        bitField0_ |= 0x00000001;
        rpcVersion_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional int32 rpc_version = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearRpcVersion() {
        bitField0_ = (bitField0_ & ~0x00000001);
        rpcVersion_ = 0;
        onChanged();
        return this;
      }

      private int status_ = 1;
      /**
       * <code>optional .exec.user.HandshakeStatus status = 3;</code>
       * @return Whether the status field is set.
       */
      @java.lang.Override public boolean hasStatus() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <code>optional .exec.user.HandshakeStatus status = 3;</code>
       * @return The status.
       */
      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.HandshakeStatus getStatus() {
        @SuppressWarnings("deprecation")
        org.apache.drill.exec.proto.UserProtos.HandshakeStatus result = org.apache.drill.exec.proto.UserProtos.HandshakeStatus.valueOf(status_);
        return result == null ? org.apache.drill.exec.proto.UserProtos.HandshakeStatus.SUCCESS : result;
      }
      /**
       * <code>optional .exec.user.HandshakeStatus status = 3;</code>
       * @param value The status to set.
       * @return This builder for chaining.
       */
      public Builder setStatus(org.apache.drill.exec.proto.UserProtos.HandshakeStatus value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        status_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <code>optional .exec.user.HandshakeStatus status = 3;</code>
       * @return This builder for chaining.
       */
      public Builder clearStatus() {
        bitField0_ = (bitField0_ & ~0x00000002);
        status_ = 1;
        onChanged();
        return this;
      }

      private java.lang.Object errorId_ = "";
      /**
       * <code>optional string errorId = 4;</code>
       * @return Whether the errorId field is set.
       */
      public boolean hasErrorId() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <code>optional string errorId = 4;</code>
       * @return The errorId.
       */
      public java.lang.String getErrorId() {
        java.lang.Object ref = errorId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            errorId_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string errorId = 4;</code>
       * @return The bytes for errorId.
       */
      public com.google.protobuf.ByteString
          getErrorIdBytes() {
        java.lang.Object ref = errorId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          errorId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string errorId = 4;</code>
       * @param value The errorId to set.
       * @return This builder for chaining.
       */
      public Builder setErrorId(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        errorId_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string errorId = 4;</code>
       * @return This builder for chaining.
       */
      public Builder clearErrorId() {
        bitField0_ = (bitField0_ & ~0x00000004);
        errorId_ = getDefaultInstance().getErrorId();
        onChanged();
        return this;
      }
      /**
       * <code>optional string errorId = 4;</code>
       * @param value The bytes for errorId to set.
       * @return This builder for chaining.
       */
      public Builder setErrorIdBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        errorId_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object errorMessage_ = "";
      /**
       * <code>optional string errorMessage = 5;</code>
       * @return Whether the errorMessage field is set.
       */
      public boolean hasErrorMessage() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       * <code>optional string errorMessage = 5;</code>
       * @return The errorMessage.
       */
      public java.lang.String getErrorMessage() {
        java.lang.Object ref = errorMessage_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            errorMessage_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string errorMessage = 5;</code>
       * @return The bytes for errorMessage.
       */
      public com.google.protobuf.ByteString
          getErrorMessageBytes() {
        java.lang.Object ref = errorMessage_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          errorMessage_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string errorMessage = 5;</code>
       * @param value The errorMessage to set.
       * @return This builder for chaining.
       */
      public Builder setErrorMessage(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000008;
        errorMessage_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string errorMessage = 5;</code>
       * @return This builder for chaining.
       */
      public Builder clearErrorMessage() {
        bitField0_ = (bitField0_ & ~0x00000008);
        errorMessage_ = getDefaultInstance().getErrorMessage();
        onChanged();
        return this;
      }
      /**
       * <code>optional string errorMessage = 5;</code>
       * @param value The bytes for errorMessage to set.
       * @return This builder for chaining.
       */
      public Builder setErrorMessageBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000008;
        errorMessage_ = value;
        onChanged();
        return this;
      }

      private org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos serverInfos_;
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos, org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos.Builder, org.apache.drill.exec.proto.UserProtos.RpcEndpointInfosOrBuilder> serverInfosBuilder_;
      /**
       * <code>optional .exec.user.RpcEndpointInfos server_infos = 6;</code>
       * @return Whether the serverInfos field is set.
       */
      public boolean hasServerInfos() {
        return ((bitField0_ & 0x00000010) != 0);
      }
      /**
       * <code>optional .exec.user.RpcEndpointInfos server_infos = 6;</code>
       * @return The serverInfos.
       */
      public org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos getServerInfos() {
        if (serverInfosBuilder_ == null) {
          return serverInfos_ == null ? org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos.getDefaultInstance() : serverInfos_;
        } else {
          return serverInfosBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .exec.user.RpcEndpointInfos server_infos = 6;</code>
       */
      public Builder setServerInfos(org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos value) {
        if (serverInfosBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          serverInfos_ = value;
          onChanged();
        } else {
          serverInfosBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000010;
        return this;
      }
      /**
       * <code>optional .exec.user.RpcEndpointInfos server_infos = 6;</code>
       */
      public Builder setServerInfos(
          org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos.Builder builderForValue) {
        if (serverInfosBuilder_ == null) {
          serverInfos_ = builderForValue.build();
          onChanged();
        } else {
          serverInfosBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000010;
        return this;
      }
      /**
       * <code>optional .exec.user.RpcEndpointInfos server_infos = 6;</code>
       */
      public Builder mergeServerInfos(org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos value) {
        if (serverInfosBuilder_ == null) {
          if (((bitField0_ & 0x00000010) != 0) &&
              serverInfos_ != null &&
              serverInfos_ != org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos.getDefaultInstance()) {
            serverInfos_ =
              org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos.newBuilder(serverInfos_).mergeFrom(value).buildPartial();
          } else {
            serverInfos_ = value;
          }
          onChanged();
        } else {
          serverInfosBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000010;
        return this;
      }
      /**
       * <code>optional .exec.user.RpcEndpointInfos server_infos = 6;</code>
       */
      public Builder clearServerInfos() {
        if (serverInfosBuilder_ == null) {
          serverInfos_ = null;
          onChanged();
        } else {
          serverInfosBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000010);
        return this;
      }
      /**
       * <code>optional .exec.user.RpcEndpointInfos server_infos = 6;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos.Builder getServerInfosBuilder() {
        bitField0_ |= 0x00000010;
        onChanged();
        return getServerInfosFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .exec.user.RpcEndpointInfos server_infos = 6;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.RpcEndpointInfosOrBuilder getServerInfosOrBuilder() {
        if (serverInfosBuilder_ != null) {
          return serverInfosBuilder_.getMessageOrBuilder();
        } else {
          return serverInfos_ == null ?
              org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos.getDefaultInstance() : serverInfos_;
        }
      }
      /**
       * <code>optional .exec.user.RpcEndpointInfos server_infos = 6;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos, org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos.Builder, org.apache.drill.exec.proto.UserProtos.RpcEndpointInfosOrBuilder> 
          getServerInfosFieldBuilder() {
        if (serverInfosBuilder_ == null) {
          serverInfosBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos, org.apache.drill.exec.proto.UserProtos.RpcEndpointInfos.Builder, org.apache.drill.exec.proto.UserProtos.RpcEndpointInfosOrBuilder>(
                  getServerInfos(),
                  getParentForChildren(),
                  isClean());
          serverInfos_ = null;
        }
        return serverInfosBuilder_;
      }

      private com.google.protobuf.LazyStringList authenticationMechanisms_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      private void ensureAuthenticationMechanismsIsMutable() {
        if (!((bitField0_ & 0x00000020) != 0)) {
          authenticationMechanisms_ = new com.google.protobuf.LazyStringArrayList(authenticationMechanisms_);
          bitField0_ |= 0x00000020;
         }
      }
      /**
       * <code>repeated string authenticationMechanisms = 7;</code>
       * @return A list containing the authenticationMechanisms.
       */
      public com.google.protobuf.ProtocolStringList
          getAuthenticationMechanismsList() {
        return authenticationMechanisms_.getUnmodifiableView();
      }
      /**
       * <code>repeated string authenticationMechanisms = 7;</code>
       * @return The count of authenticationMechanisms.
       */
      public int getAuthenticationMechanismsCount() {
        return authenticationMechanisms_.size();
      }
      /**
       * <code>repeated string authenticationMechanisms = 7;</code>
       * @param index The index of the element to return.
       * @return The authenticationMechanisms at the given index.
       */
      public java.lang.String getAuthenticationMechanisms(int index) {
        return authenticationMechanisms_.get(index);
      }
      /**
       * <code>repeated string authenticationMechanisms = 7;</code>
       * @param index The index of the value to return.
       * @return The bytes of the authenticationMechanisms at the given index.
       */
      public com.google.protobuf.ByteString
          getAuthenticationMechanismsBytes(int index) {
        return authenticationMechanisms_.getByteString(index);
      }
      /**
       * <code>repeated string authenticationMechanisms = 7;</code>
       * @param index The index to set the value at.
       * @param value The authenticationMechanisms to set.
       * @return This builder for chaining.
       */
      public Builder setAuthenticationMechanisms(
          int index, java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureAuthenticationMechanismsIsMutable();
        authenticationMechanisms_.set(index, value);
        onChanged();
        return this;
      }
      /**
       * <code>repeated string authenticationMechanisms = 7;</code>
       * @param value The authenticationMechanisms to add.
       * @return This builder for chaining.
       */
      public Builder addAuthenticationMechanisms(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureAuthenticationMechanismsIsMutable();
        authenticationMechanisms_.add(value);
        onChanged();
        return this;
      }
      /**
       * <code>repeated string authenticationMechanisms = 7;</code>
       * @param values The authenticationMechanisms to add.
       * @return This builder for chaining.
       */
      public Builder addAllAuthenticationMechanisms(
          java.lang.Iterable<java.lang.String> values) {
        ensureAuthenticationMechanismsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, authenticationMechanisms_);
        onChanged();
        return this;
      }
      /**
       * <code>repeated string authenticationMechanisms = 7;</code>
       * @return This builder for chaining.
       */
      public Builder clearAuthenticationMechanisms() {
        authenticationMechanisms_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
        return this;
      }
      /**
       * <code>repeated string authenticationMechanisms = 7;</code>
       * @param value The bytes of the authenticationMechanisms to add.
       * @return This builder for chaining.
       */
      public Builder addAuthenticationMechanismsBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureAuthenticationMechanismsIsMutable();
        authenticationMechanisms_.add(value);
        onChanged();
        return this;
      }

      private java.util.List<java.lang.Integer> supportedMethods_ =
        java.util.Collections.emptyList();
      private void ensureSupportedMethodsIsMutable() {
        if (!((bitField0_ & 0x00000040) != 0)) {
          supportedMethods_ = new java.util.ArrayList<java.lang.Integer>(supportedMethods_);
          bitField0_ |= 0x00000040;
        }
      }
      /**
       * <code>repeated .exec.user.RpcType supported_methods = 8;</code>
       * @return A list containing the supportedMethods.
       */
      public java.util.List<org.apache.drill.exec.proto.UserProtos.RpcType> getSupportedMethodsList() {
        return new com.google.protobuf.Internal.ListAdapter<
            java.lang.Integer, org.apache.drill.exec.proto.UserProtos.RpcType>(supportedMethods_, supportedMethods_converter_);
      }
      /**
       * <code>repeated .exec.user.RpcType supported_methods = 8;</code>
       * @return The count of supportedMethods.
       */
      public int getSupportedMethodsCount() {
        return supportedMethods_.size();
      }
      /**
       * <code>repeated .exec.user.RpcType supported_methods = 8;</code>
       * @param index The index of the element to return.
       * @return The supportedMethods at the given index.
       */
      public org.apache.drill.exec.proto.UserProtos.RpcType getSupportedMethods(int index) {
        return supportedMethods_converter_.convert(supportedMethods_.get(index));
      }
      /**
       * <code>repeated .exec.user.RpcType supported_methods = 8;</code>
       * @param index The index to set the value at.
       * @param value The supportedMethods to set.
       * @return This builder for chaining.
       */
      public Builder setSupportedMethods(
          int index, org.apache.drill.exec.proto.UserProtos.RpcType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSupportedMethodsIsMutable();
        supportedMethods_.set(index, value.getNumber());
        onChanged();
        return this;
      }
      /**
       * <code>repeated .exec.user.RpcType supported_methods = 8;</code>
       * @param value The supportedMethods to add.
       * @return This builder for chaining.
       */
      public Builder addSupportedMethods(org.apache.drill.exec.proto.UserProtos.RpcType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSupportedMethodsIsMutable();
        supportedMethods_.add(value.getNumber());
        onChanged();
        return this;
      }
      /**
       * <code>repeated .exec.user.RpcType supported_methods = 8;</code>
       * @param values The supportedMethods to add.
       * @return This builder for chaining.
       */
      public Builder addAllSupportedMethods(
          java.lang.Iterable<? extends org.apache.drill.exec.proto.UserProtos.RpcType> values) {
        ensureSupportedMethodsIsMutable();
        for (org.apache.drill.exec.proto.UserProtos.RpcType value : values) {
          supportedMethods_.add(value.getNumber());
        }
        onChanged();
        return this;
      }
      /**
       * <code>repeated .exec.user.RpcType supported_methods = 8;</code>
       * @return This builder for chaining.
       */
      public Builder clearSupportedMethods() {
        supportedMethods_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000040);
        onChanged();
        return this;
      }

      private boolean encrypted_ ;
      /**
       * <code>optional bool encrypted = 9;</code>
       * @return Whether the encrypted field is set.
       */
      @java.lang.Override
      public boolean hasEncrypted() {
        return ((bitField0_ & 0x00000080) != 0);
      }
      /**
       * <code>optional bool encrypted = 9;</code>
       * @return The encrypted.
       */
      @java.lang.Override
      public boolean getEncrypted() {
        return encrypted_;
      }
      /**
       * <code>optional bool encrypted = 9;</code>
       * @param value The encrypted to set.
       * @return This builder for chaining.
       */
      public Builder setEncrypted(boolean value) {
        bitField0_ |= 0x00000080;
        encrypted_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool encrypted = 9;</code>
       * @return This builder for chaining.
       */
      public Builder clearEncrypted() {
        bitField0_ = (bitField0_ & ~0x00000080);
        encrypted_ = false;
        onChanged();
        return this;
      }

      private int maxWrappedSize_ ;
      /**
       * <code>optional int32 maxWrappedSize = 10;</code>
       * @return Whether the maxWrappedSize field is set.
       */
      @java.lang.Override
      public boolean hasMaxWrappedSize() {
        return ((bitField0_ & 0x00000100) != 0);
      }
      /**
       * <code>optional int32 maxWrappedSize = 10;</code>
       * @return The maxWrappedSize.
       */
      @java.lang.Override
      public int getMaxWrappedSize() {
        return maxWrappedSize_;
      }
      /**
       * <code>optional int32 maxWrappedSize = 10;</code>
       * @param value The maxWrappedSize to set.
       * @return This builder for chaining.
       */
      public Builder setMaxWrappedSize(int value) {
        bitField0_ |= 0x00000100;
        maxWrappedSize_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional int32 maxWrappedSize = 10;</code>
       * @return This builder for chaining.
       */
      public Builder clearMaxWrappedSize() {
        bitField0_ = (bitField0_ & ~0x00000100);
        maxWrappedSize_ = 0;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:exec.user.BitToUserHandshake)
    }

    // @@protoc_insertion_point(class_scope:exec.user.BitToUserHandshake)
    private static final org.apache.drill.exec.proto.UserProtos.BitToUserHandshake DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.drill.exec.proto.UserProtos.BitToUserHandshake();
    }

    public static org.apache.drill.exec.proto.UserProtos.BitToUserHandshake getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final com.google.protobuf.Parser<BitToUserHandshake>
        PARSER = new com.google.protobuf.AbstractParser<BitToUserHandshake>() {
      @java.lang.Override
      public BitToUserHandshake parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<BitToUserHandshake> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<BitToUserHandshake> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.drill.exec.proto.UserProtos.BitToUserHandshake getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface LikeFilterOrBuilder extends
      // @@protoc_insertion_point(interface_extends:exec.user.LikeFilter)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * pattern to match
     * </pre>
     *
     * <code>optional string pattern = 1;</code>
     * @return Whether the pattern field is set.
     */
    boolean hasPattern();
    /**
     * <pre>
     * pattern to match
     * </pre>
     *
     * <code>optional string pattern = 1;</code>
     * @return The pattern.
     */
    java.lang.String getPattern();
    /**
     * <pre>
     * pattern to match
     * </pre>
     *
     * <code>optional string pattern = 1;</code>
     * @return The bytes for pattern.
     */
    com.google.protobuf.ByteString
        getPatternBytes();

    /**
     * <pre>
     * escape character (if any) present in the pattern
     * </pre>
     *
     * <code>optional string escape = 2;</code>
     * @return Whether the escape field is set.
     */
    boolean hasEscape();
    /**
     * <pre>
     * escape character (if any) present in the pattern
     * </pre>
     *
     * <code>optional string escape = 2;</code>
     * @return The escape.
     */
    java.lang.String getEscape();
    /**
     * <pre>
     * escape character (if any) present in the pattern
     * </pre>
     *
     * <code>optional string escape = 2;</code>
     * @return The bytes for escape.
     */
    com.google.protobuf.ByteString
        getEscapeBytes();
  }
  /**
   * <pre>
   * Simple filter which encapsulates the SQL LIKE ... ESCAPE function
   * </pre>
   *
   * Protobuf type {@code exec.user.LikeFilter}
   */
  public static final class LikeFilter extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:exec.user.LikeFilter)
      LikeFilterOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use LikeFilter.newBuilder() to construct.
    private LikeFilter(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private LikeFilter() {
      pattern_ = "";
      escape_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new LikeFilter();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_LikeFilter_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_LikeFilter_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.UserProtos.LikeFilter.class, org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder.class);
    }

    private int bitField0_;
    public static final int PATTERN_FIELD_NUMBER = 1;
    private volatile java.lang.Object pattern_;
    /**
     * <pre>
     * pattern to match
     * </pre>
     *
     * <code>optional string pattern = 1;</code>
     * @return Whether the pattern field is set.
     */
    @java.lang.Override
    public boolean hasPattern() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * pattern to match
     * </pre>
     *
     * <code>optional string pattern = 1;</code>
     * @return The pattern.
     */
    @java.lang.Override
    public java.lang.String getPattern() {
      java.lang.Object ref = pattern_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          pattern_ = s;
        }
        return s;
      }
    }
    /**
     * <pre>
     * pattern to match
     * </pre>
     *
     * <code>optional string pattern = 1;</code>
     * @return The bytes for pattern.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getPatternBytes() {
      java.lang.Object ref = pattern_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        pattern_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ESCAPE_FIELD_NUMBER = 2;
    private volatile java.lang.Object escape_;
    /**
     * <pre>
     * escape character (if any) present in the pattern
     * </pre>
     *
     * <code>optional string escape = 2;</code>
     * @return Whether the escape field is set.
     */
    @java.lang.Override
    public boolean hasEscape() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <pre>
     * escape character (if any) present in the pattern
     * </pre>
     *
     * <code>optional string escape = 2;</code>
     * @return The escape.
     */
    @java.lang.Override
    public java.lang.String getEscape() {
      java.lang.Object ref = escape_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          escape_ = s;
        }
        return s;
      }
    }
    /**
     * <pre>
     * escape character (if any) present in the pattern
     * </pre>
     *
     * <code>optional string escape = 2;</code>
     * @return The bytes for escape.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getEscapeBytes() {
      java.lang.Object ref = escape_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        escape_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, pattern_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, escape_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, pattern_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, escape_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.drill.exec.proto.UserProtos.LikeFilter)) {
        return super.equals(obj);
      }
      org.apache.drill.exec.proto.UserProtos.LikeFilter other = (org.apache.drill.exec.proto.UserProtos.LikeFilter) obj;

      if (hasPattern() != other.hasPattern()) return false;
      if (hasPattern()) {
        if (!getPattern()
            .equals(other.getPattern())) return false;
      }
      if (hasEscape() != other.hasEscape()) return false;
      if (hasEscape()) {
        if (!getEscape()
            .equals(other.getEscape())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasPattern()) {
        hash = (37 * hash) + PATTERN_FIELD_NUMBER;
        hash = (53 * hash) + getPattern().hashCode();
      }
      if (hasEscape()) {
        hash = (37 * hash) + ESCAPE_FIELD_NUMBER;
        hash = (53 * hash) + getEscape().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.drill.exec.proto.UserProtos.LikeFilter parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.LikeFilter parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.LikeFilter parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.LikeFilter parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.LikeFilter parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.LikeFilter parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.LikeFilter parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.LikeFilter parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.LikeFilter parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.LikeFilter parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.LikeFilter parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.LikeFilter parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.drill.exec.proto.UserProtos.LikeFilter prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Simple filter which encapsulates the SQL LIKE ... ESCAPE function
     * </pre>
     *
     * Protobuf type {@code exec.user.LikeFilter}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:exec.user.LikeFilter)
        org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_LikeFilter_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_LikeFilter_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.UserProtos.LikeFilter.class, org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.UserProtos.LikeFilter.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        pattern_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        escape_ = "";
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_LikeFilter_descriptor;
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.LikeFilter getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.LikeFilter build() {
        org.apache.drill.exec.proto.UserProtos.LikeFilter result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.LikeFilter buildPartial() {
        org.apache.drill.exec.proto.UserProtos.LikeFilter result = new org.apache.drill.exec.proto.UserProtos.LikeFilter(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          to_bitField0_ |= 0x00000001;
        }
        result.pattern_ = pattern_;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          to_bitField0_ |= 0x00000002;
        }
        result.escape_ = escape_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.UserProtos.LikeFilter) {
          return mergeFrom((org.apache.drill.exec.proto.UserProtos.LikeFilter)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.UserProtos.LikeFilter other) {
        if (other == org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance()) return this;
        if (other.hasPattern()) {
          bitField0_ |= 0x00000001;
          pattern_ = other.pattern_;
          onChanged();
        }
        if (other.hasEscape()) {
          bitField0_ |= 0x00000002;
          escape_ = other.escape_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                pattern_ = input.readBytes();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
              case 18: {
                escape_ = input.readBytes();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private java.lang.Object pattern_ = "";
      /**
       * <pre>
       * pattern to match
       * </pre>
       *
       * <code>optional string pattern = 1;</code>
       * @return Whether the pattern field is set.
       */
      public boolean hasPattern() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       * pattern to match
       * </pre>
       *
       * <code>optional string pattern = 1;</code>
       * @return The pattern.
       */
      public java.lang.String getPattern() {
        java.lang.Object ref = pattern_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            pattern_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * pattern to match
       * </pre>
       *
       * <code>optional string pattern = 1;</code>
       * @return The bytes for pattern.
       */
      public com.google.protobuf.ByteString
          getPatternBytes() {
        java.lang.Object ref = pattern_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          pattern_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * pattern to match
       * </pre>
       *
       * <code>optional string pattern = 1;</code>
       * @param value The pattern to set.
       * @return This builder for chaining.
       */
      public Builder setPattern(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        pattern_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * pattern to match
       * </pre>
       *
       * <code>optional string pattern = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearPattern() {
        bitField0_ = (bitField0_ & ~0x00000001);
        pattern_ = getDefaultInstance().getPattern();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * pattern to match
       * </pre>
       *
       * <code>optional string pattern = 1;</code>
       * @param value The bytes for pattern to set.
       * @return This builder for chaining.
       */
      public Builder setPatternBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        pattern_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object escape_ = "";
      /**
       * <pre>
       * escape character (if any) present in the pattern
       * </pre>
       *
       * <code>optional string escape = 2;</code>
       * @return Whether the escape field is set.
       */
      public boolean hasEscape() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <pre>
       * escape character (if any) present in the pattern
       * </pre>
       *
       * <code>optional string escape = 2;</code>
       * @return The escape.
       */
      public java.lang.String getEscape() {
        java.lang.Object ref = escape_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            escape_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * escape character (if any) present in the pattern
       * </pre>
       *
       * <code>optional string escape = 2;</code>
       * @return The bytes for escape.
       */
      public com.google.protobuf.ByteString
          getEscapeBytes() {
        java.lang.Object ref = escape_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          escape_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * escape character (if any) present in the pattern
       * </pre>
       *
       * <code>optional string escape = 2;</code>
       * @param value The escape to set.
       * @return This builder for chaining.
       */
      public Builder setEscape(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        escape_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * escape character (if any) present in the pattern
       * </pre>
       *
       * <code>optional string escape = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearEscape() {
        bitField0_ = (bitField0_ & ~0x00000002);
        escape_ = getDefaultInstance().getEscape();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * escape character (if any) present in the pattern
       * </pre>
       *
       * <code>optional string escape = 2;</code>
       * @param value The bytes for escape to set.
       * @return This builder for chaining.
       */
      public Builder setEscapeBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        escape_ = value;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:exec.user.LikeFilter)
    }

    // @@protoc_insertion_point(class_scope:exec.user.LikeFilter)
    private static final org.apache.drill.exec.proto.UserProtos.LikeFilter DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.drill.exec.proto.UserProtos.LikeFilter();
    }

    public static org.apache.drill.exec.proto.UserProtos.LikeFilter getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final com.google.protobuf.Parser<LikeFilter>
        PARSER = new com.google.protobuf.AbstractParser<LikeFilter>() {
      @java.lang.Override
      public LikeFilter parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<LikeFilter> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<LikeFilter> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.drill.exec.proto.UserProtos.LikeFilter getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface GetCatalogsReqOrBuilder extends
      // @@protoc_insertion_point(interface_extends:exec.user.GetCatalogsReq)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
     * @return Whether the catalogNameFilter field is set.
     */
    boolean hasCatalogNameFilter();
    /**
     * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
     * @return The catalogNameFilter.
     */
    org.apache.drill.exec.proto.UserProtos.LikeFilter getCatalogNameFilter();
    /**
     * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
     */
    org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder getCatalogNameFilterOrBuilder();
  }
  /**
   * <pre>
   * Request message for getting the metadata for catalogs satisfying the given optional filter.
   * </pre>
   *
   * Protobuf type {@code exec.user.GetCatalogsReq}
   */
  public static final class GetCatalogsReq extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:exec.user.GetCatalogsReq)
      GetCatalogsReqOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use GetCatalogsReq.newBuilder() to construct.
    private GetCatalogsReq(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private GetCatalogsReq() {
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new GetCatalogsReq();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetCatalogsReq_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetCatalogsReq_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.UserProtos.GetCatalogsReq.class, org.apache.drill.exec.proto.UserProtos.GetCatalogsReq.Builder.class);
    }

    private int bitField0_;
    public static final int CATALOG_NAME_FILTER_FIELD_NUMBER = 1;
    private org.apache.drill.exec.proto.UserProtos.LikeFilter catalogNameFilter_;
    /**
     * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
     * @return Whether the catalogNameFilter field is set.
     */
    @java.lang.Override
    public boolean hasCatalogNameFilter() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
     * @return The catalogNameFilter.
     */
    @java.lang.Override
    public org.apache.drill.exec.proto.UserProtos.LikeFilter getCatalogNameFilter() {
      return catalogNameFilter_ == null ? org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance() : catalogNameFilter_;
    }
    /**
     * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
     */
    @java.lang.Override
    public org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder getCatalogNameFilterOrBuilder() {
      return catalogNameFilter_ == null ? org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance() : catalogNameFilter_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getCatalogNameFilter());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, getCatalogNameFilter());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.drill.exec.proto.UserProtos.GetCatalogsReq)) {
        return super.equals(obj);
      }
      org.apache.drill.exec.proto.UserProtos.GetCatalogsReq other = (org.apache.drill.exec.proto.UserProtos.GetCatalogsReq) obj;

      if (hasCatalogNameFilter() != other.hasCatalogNameFilter()) return false;
      if (hasCatalogNameFilter()) {
        if (!getCatalogNameFilter()
            .equals(other.getCatalogNameFilter())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasCatalogNameFilter()) {
        hash = (37 * hash) + CATALOG_NAME_FILTER_FIELD_NUMBER;
        hash = (53 * hash) + getCatalogNameFilter().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.drill.exec.proto.UserProtos.GetCatalogsReq parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetCatalogsReq parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetCatalogsReq parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetCatalogsReq parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetCatalogsReq parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetCatalogsReq parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetCatalogsReq parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetCatalogsReq parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetCatalogsReq parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetCatalogsReq parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetCatalogsReq parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetCatalogsReq parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.drill.exec.proto.UserProtos.GetCatalogsReq prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Request message for getting the metadata for catalogs satisfying the given optional filter.
     * </pre>
     *
     * Protobuf type {@code exec.user.GetCatalogsReq}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:exec.user.GetCatalogsReq)
        org.apache.drill.exec.proto.UserProtos.GetCatalogsReqOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetCatalogsReq_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetCatalogsReq_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.UserProtos.GetCatalogsReq.class, org.apache.drill.exec.proto.UserProtos.GetCatalogsReq.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.UserProtos.GetCatalogsReq.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getCatalogNameFilterFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (catalogNameFilterBuilder_ == null) {
          catalogNameFilter_ = null;
        } else {
          catalogNameFilterBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetCatalogsReq_descriptor;
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.GetCatalogsReq getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.UserProtos.GetCatalogsReq.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.GetCatalogsReq build() {
        org.apache.drill.exec.proto.UserProtos.GetCatalogsReq result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.GetCatalogsReq buildPartial() {
        org.apache.drill.exec.proto.UserProtos.GetCatalogsReq result = new org.apache.drill.exec.proto.UserProtos.GetCatalogsReq(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          if (catalogNameFilterBuilder_ == null) {
            result.catalogNameFilter_ = catalogNameFilter_;
          } else {
            result.catalogNameFilter_ = catalogNameFilterBuilder_.build();
          }
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.UserProtos.GetCatalogsReq) {
          return mergeFrom((org.apache.drill.exec.proto.UserProtos.GetCatalogsReq)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.UserProtos.GetCatalogsReq other) {
        if (other == org.apache.drill.exec.proto.UserProtos.GetCatalogsReq.getDefaultInstance()) return this;
        if (other.hasCatalogNameFilter()) {
          mergeCatalogNameFilter(other.getCatalogNameFilter());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                input.readMessage(
                    getCatalogNameFilterFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private org.apache.drill.exec.proto.UserProtos.LikeFilter catalogNameFilter_;
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.drill.exec.proto.UserProtos.LikeFilter, org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder, org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder> catalogNameFilterBuilder_;
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       * @return Whether the catalogNameFilter field is set.
       */
      public boolean hasCatalogNameFilter() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       * @return The catalogNameFilter.
       */
      public org.apache.drill.exec.proto.UserProtos.LikeFilter getCatalogNameFilter() {
        if (catalogNameFilterBuilder_ == null) {
          return catalogNameFilter_ == null ? org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance() : catalogNameFilter_;
        } else {
          return catalogNameFilterBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       */
      public Builder setCatalogNameFilter(org.apache.drill.exec.proto.UserProtos.LikeFilter value) {
        if (catalogNameFilterBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          catalogNameFilter_ = value;
          onChanged();
        } else {
          catalogNameFilterBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       */
      public Builder setCatalogNameFilter(
          org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder builderForValue) {
        if (catalogNameFilterBuilder_ == null) {
          catalogNameFilter_ = builderForValue.build();
          onChanged();
        } else {
          catalogNameFilterBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       */
      public Builder mergeCatalogNameFilter(org.apache.drill.exec.proto.UserProtos.LikeFilter value) {
        if (catalogNameFilterBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0) &&
              catalogNameFilter_ != null &&
              catalogNameFilter_ != org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance()) {
            catalogNameFilter_ =
              org.apache.drill.exec.proto.UserProtos.LikeFilter.newBuilder(catalogNameFilter_).mergeFrom(value).buildPartial();
          } else {
            catalogNameFilter_ = value;
          }
          onChanged();
        } else {
          catalogNameFilterBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       */
      public Builder clearCatalogNameFilter() {
        if (catalogNameFilterBuilder_ == null) {
          catalogNameFilter_ = null;
          onChanged();
        } else {
          catalogNameFilterBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder getCatalogNameFilterBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getCatalogNameFilterFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder getCatalogNameFilterOrBuilder() {
        if (catalogNameFilterBuilder_ != null) {
          return catalogNameFilterBuilder_.getMessageOrBuilder();
        } else {
          return catalogNameFilter_ == null ?
              org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance() : catalogNameFilter_;
        }
      }
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.drill.exec.proto.UserProtos.LikeFilter, org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder, org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder> 
          getCatalogNameFilterFieldBuilder() {
        if (catalogNameFilterBuilder_ == null) {
          catalogNameFilterBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.apache.drill.exec.proto.UserProtos.LikeFilter, org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder, org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder>(
                  getCatalogNameFilter(),
                  getParentForChildren(),
                  isClean());
          catalogNameFilter_ = null;
        }
        return catalogNameFilterBuilder_;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:exec.user.GetCatalogsReq)
    }

    // @@protoc_insertion_point(class_scope:exec.user.GetCatalogsReq)
    private static final org.apache.drill.exec.proto.UserProtos.GetCatalogsReq DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.drill.exec.proto.UserProtos.GetCatalogsReq();
    }

    public static org.apache.drill.exec.proto.UserProtos.GetCatalogsReq getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final com.google.protobuf.Parser<GetCatalogsReq>
        PARSER = new com.google.protobuf.AbstractParser<GetCatalogsReq>() {
      @java.lang.Override
      public GetCatalogsReq parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<GetCatalogsReq> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GetCatalogsReq> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.drill.exec.proto.UserProtos.GetCatalogsReq getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface CatalogMetadataOrBuilder extends
      // @@protoc_insertion_point(interface_extends:exec.user.CatalogMetadata)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>optional string catalog_name = 1;</code>
     * @return Whether the catalogName field is set.
     */
    boolean hasCatalogName();
    /**
     * <code>optional string catalog_name = 1;</code>
     * @return The catalogName.
     */
    java.lang.String getCatalogName();
    /**
     * <code>optional string catalog_name = 1;</code>
     * @return The bytes for catalogName.
     */
    com.google.protobuf.ByteString
        getCatalogNameBytes();

    /**
     * <code>optional string description = 2;</code>
     * @return Whether the description field is set.
     */
    boolean hasDescription();
    /**
     * <code>optional string description = 2;</code>
     * @return The description.
     */
    java.lang.String getDescription();
    /**
     * <code>optional string description = 2;</code>
     * @return The bytes for description.
     */
    com.google.protobuf.ByteString
        getDescriptionBytes();

    /**
     * <code>optional string connect = 3;</code>
     * @return Whether the connect field is set.
     */
    boolean hasConnect();
    /**
     * <code>optional string connect = 3;</code>
     * @return The connect.
     */
    java.lang.String getConnect();
    /**
     * <code>optional string connect = 3;</code>
     * @return The bytes for connect.
     */
    com.google.protobuf.ByteString
        getConnectBytes();
  }
  /**
   * <pre>
   * Message encapsulating metadata for a Catalog.
   * </pre>
   *
   * Protobuf type {@code exec.user.CatalogMetadata}
   */
  public static final class CatalogMetadata extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:exec.user.CatalogMetadata)
      CatalogMetadataOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use CatalogMetadata.newBuilder() to construct.
    private CatalogMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private CatalogMetadata() {
      catalogName_ = "";
      description_ = "";
      connect_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new CatalogMetadata();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_CatalogMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_CatalogMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.UserProtos.CatalogMetadata.class, org.apache.drill.exec.proto.UserProtos.CatalogMetadata.Builder.class);
    }

    private int bitField0_;
    public static final int CATALOG_NAME_FIELD_NUMBER = 1;
    private volatile java.lang.Object catalogName_;
    /**
     * <code>optional string catalog_name = 1;</code>
     * @return Whether the catalogName field is set.
     */
    @java.lang.Override
    public boolean hasCatalogName() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>optional string catalog_name = 1;</code>
     * @return The catalogName.
     */
    @java.lang.Override
    public java.lang.String getCatalogName() {
      java.lang.Object ref = catalogName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          catalogName_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string catalog_name = 1;</code>
     * @return The bytes for catalogName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getCatalogNameBytes() {
      java.lang.Object ref = catalogName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        catalogName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DESCRIPTION_FIELD_NUMBER = 2;
    private volatile java.lang.Object description_;
    /**
     * <code>optional string description = 2;</code>
     * @return Whether the description field is set.
     */
    @java.lang.Override
    public boolean hasDescription() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <code>optional string description = 2;</code>
     * @return The description.
     */
    @java.lang.Override
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          description_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string description = 2;</code>
     * @return The bytes for description.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CONNECT_FIELD_NUMBER = 3;
    private volatile java.lang.Object connect_;
    /**
     * <code>optional string connect = 3;</code>
     * @return Whether the connect field is set.
     */
    @java.lang.Override
    public boolean hasConnect() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <code>optional string connect = 3;</code>
     * @return The connect.
     */
    @java.lang.Override
    public java.lang.String getConnect() {
      java.lang.Object ref = connect_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          connect_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string connect = 3;</code>
     * @return The bytes for connect.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getConnectBytes() {
      java.lang.Object ref = connect_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        connect_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, catalogName_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, description_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, connect_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, catalogName_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, description_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, connect_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.drill.exec.proto.UserProtos.CatalogMetadata)) {
        return super.equals(obj);
      }
      org.apache.drill.exec.proto.UserProtos.CatalogMetadata other = (org.apache.drill.exec.proto.UserProtos.CatalogMetadata) obj;

      if (hasCatalogName() != other.hasCatalogName()) return false;
      if (hasCatalogName()) {
        if (!getCatalogName()
            .equals(other.getCatalogName())) return false;
      }
      if (hasDescription() != other.hasDescription()) return false;
      if (hasDescription()) {
        if (!getDescription()
            .equals(other.getDescription())) return false;
      }
      if (hasConnect() != other.hasConnect()) return false;
      if (hasConnect()) {
        if (!getConnect()
            .equals(other.getConnect())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasCatalogName()) {
        hash = (37 * hash) + CATALOG_NAME_FIELD_NUMBER;
        hash = (53 * hash) + getCatalogName().hashCode();
      }
      if (hasDescription()) {
        hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
        hash = (53 * hash) + getDescription().hashCode();
      }
      if (hasConnect()) {
        hash = (37 * hash) + CONNECT_FIELD_NUMBER;
        hash = (53 * hash) + getConnect().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.drill.exec.proto.UserProtos.CatalogMetadata parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.CatalogMetadata parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.CatalogMetadata parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.CatalogMetadata parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.CatalogMetadata parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.CatalogMetadata parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.CatalogMetadata parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.CatalogMetadata parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.CatalogMetadata parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.CatalogMetadata parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.CatalogMetadata parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.CatalogMetadata parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.drill.exec.proto.UserProtos.CatalogMetadata prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Message encapsulating metadata for a Catalog.
     * </pre>
     *
     * Protobuf type {@code exec.user.CatalogMetadata}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:exec.user.CatalogMetadata)
        org.apache.drill.exec.proto.UserProtos.CatalogMetadataOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_CatalogMetadata_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_CatalogMetadata_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.UserProtos.CatalogMetadata.class, org.apache.drill.exec.proto.UserProtos.CatalogMetadata.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.UserProtos.CatalogMetadata.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        catalogName_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        description_ = "";
        bitField0_ = (bitField0_ & ~0x00000002);
        connect_ = "";
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_CatalogMetadata_descriptor;
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.CatalogMetadata getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.UserProtos.CatalogMetadata.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.CatalogMetadata build() {
        org.apache.drill.exec.proto.UserProtos.CatalogMetadata result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.CatalogMetadata buildPartial() {
        org.apache.drill.exec.proto.UserProtos.CatalogMetadata result = new org.apache.drill.exec.proto.UserProtos.CatalogMetadata(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          to_bitField0_ |= 0x00000001;
        }
        result.catalogName_ = catalogName_;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          to_bitField0_ |= 0x00000002;
        }
        result.description_ = description_;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          to_bitField0_ |= 0x00000004;
        }
        result.connect_ = connect_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.UserProtos.CatalogMetadata) {
          return mergeFrom((org.apache.drill.exec.proto.UserProtos.CatalogMetadata)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.UserProtos.CatalogMetadata other) {
        if (other == org.apache.drill.exec.proto.UserProtos.CatalogMetadata.getDefaultInstance()) return this;
        if (other.hasCatalogName()) {
          bitField0_ |= 0x00000001;
          catalogName_ = other.catalogName_;
          onChanged();
        }
        if (other.hasDescription()) {
          bitField0_ |= 0x00000002;
          description_ = other.description_;
          onChanged();
        }
        if (other.hasConnect()) {
          bitField0_ |= 0x00000004;
          connect_ = other.connect_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                catalogName_ = input.readBytes();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
              case 18: {
                description_ = input.readBytes();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
              case 26: {
                connect_ = input.readBytes();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private java.lang.Object catalogName_ = "";
      /**
       * <code>optional string catalog_name = 1;</code>
       * @return Whether the catalogName field is set.
       */
      public boolean hasCatalogName() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>optional string catalog_name = 1;</code>
       * @return The catalogName.
       */
      public java.lang.String getCatalogName() {
        java.lang.Object ref = catalogName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            catalogName_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string catalog_name = 1;</code>
       * @return The bytes for catalogName.
       */
      public com.google.protobuf.ByteString
          getCatalogNameBytes() {
        java.lang.Object ref = catalogName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          catalogName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string catalog_name = 1;</code>
       * @param value The catalogName to set.
       * @return This builder for chaining.
       */
      public Builder setCatalogName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        catalogName_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string catalog_name = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearCatalogName() {
        bitField0_ = (bitField0_ & ~0x00000001);
        catalogName_ = getDefaultInstance().getCatalogName();
        onChanged();
        return this;
      }
      /**
       * <code>optional string catalog_name = 1;</code>
       * @param value The bytes for catalogName to set.
       * @return This builder for chaining.
       */
      public Builder setCatalogNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        catalogName_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object description_ = "";
      /**
       * <code>optional string description = 2;</code>
       * @return Whether the description field is set.
       */
      public boolean hasDescription() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <code>optional string description = 2;</code>
       * @return The description.
       */
      public java.lang.String getDescription() {
        java.lang.Object ref = description_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            description_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string description = 2;</code>
       * @return The bytes for description.
       */
      public com.google.protobuf.ByteString
          getDescriptionBytes() {
        java.lang.Object ref = description_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          description_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string description = 2;</code>
       * @param value The description to set.
       * @return This builder for chaining.
       */
      public Builder setDescription(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        description_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string description = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearDescription() {
        bitField0_ = (bitField0_ & ~0x00000002);
        description_ = getDefaultInstance().getDescription();
        onChanged();
        return this;
      }
      /**
       * <code>optional string description = 2;</code>
       * @param value The bytes for description to set.
       * @return This builder for chaining.
       */
      public Builder setDescriptionBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        description_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object connect_ = "";
      /**
       * <code>optional string connect = 3;</code>
       * @return Whether the connect field is set.
       */
      public boolean hasConnect() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <code>optional string connect = 3;</code>
       * @return The connect.
       */
      public java.lang.String getConnect() {
        java.lang.Object ref = connect_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            connect_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string connect = 3;</code>
       * @return The bytes for connect.
       */
      public com.google.protobuf.ByteString
          getConnectBytes() {
        java.lang.Object ref = connect_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          connect_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string connect = 3;</code>
       * @param value The connect to set.
       * @return This builder for chaining.
       */
      public Builder setConnect(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        connect_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string connect = 3;</code>
       * @return This builder for chaining.
       */
      public Builder clearConnect() {
        bitField0_ = (bitField0_ & ~0x00000004);
        connect_ = getDefaultInstance().getConnect();
        onChanged();
        return this;
      }
      /**
       * <code>optional string connect = 3;</code>
       * @param value The bytes for connect to set.
       * @return This builder for chaining.
       */
      public Builder setConnectBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        connect_ = value;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:exec.user.CatalogMetadata)
    }

    // @@protoc_insertion_point(class_scope:exec.user.CatalogMetadata)
    private static final org.apache.drill.exec.proto.UserProtos.CatalogMetadata DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.drill.exec.proto.UserProtos.CatalogMetadata();
    }

    public static org.apache.drill.exec.proto.UserProtos.CatalogMetadata getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final com.google.protobuf.Parser<CatalogMetadata>
        PARSER = new com.google.protobuf.AbstractParser<CatalogMetadata>() {
      @java.lang.Override
      public CatalogMetadata parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<CatalogMetadata> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CatalogMetadata> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.drill.exec.proto.UserProtos.CatalogMetadata getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface GetCatalogsRespOrBuilder extends
      // @@protoc_insertion_point(interface_extends:exec.user.GetCatalogsResp)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>optional .exec.user.RequestStatus status = 1;</code>
     * @return Whether the status field is set.
     */
    boolean hasStatus();
    /**
     * <code>optional .exec.user.RequestStatus status = 1;</code>
     * @return The status.
     */
    org.apache.drill.exec.proto.UserProtos.RequestStatus getStatus();

    /**
     * <code>repeated .exec.user.CatalogMetadata catalogs = 2;</code>
     */
    java.util.List<org.apache.drill.exec.proto.UserProtos.CatalogMetadata> 
        getCatalogsList();
    /**
     * <code>repeated .exec.user.CatalogMetadata catalogs = 2;</code>
     */
    org.apache.drill.exec.proto.UserProtos.CatalogMetadata getCatalogs(int index);
    /**
     * <code>repeated .exec.user.CatalogMetadata catalogs = 2;</code>
     */
    int getCatalogsCount();
    /**
     * <code>repeated .exec.user.CatalogMetadata catalogs = 2;</code>
     */
    java.util.List<? extends org.apache.drill.exec.proto.UserProtos.CatalogMetadataOrBuilder> 
        getCatalogsOrBuilderList();
    /**
     * <code>repeated .exec.user.CatalogMetadata catalogs = 2;</code>
     */
    org.apache.drill.exec.proto.UserProtos.CatalogMetadataOrBuilder getCatalogsOrBuilder(
        int index);

    /**
     * <code>optional .exec.shared.DrillPBError error = 3;</code>
     * @return Whether the error field is set.
     */
    boolean hasError();
    /**
     * <code>optional .exec.shared.DrillPBError error = 3;</code>
     * @return The error.
     */
    org.apache.drill.exec.proto.UserBitShared.DrillPBError getError();
    /**
     * <code>optional .exec.shared.DrillPBError error = 3;</code>
     */
    org.apache.drill.exec.proto.UserBitShared.DrillPBErrorOrBuilder getErrorOrBuilder();
  }
  /**
   * <pre>
   * Response message for GetCatalogReq.
   * </pre>
   *
   * Protobuf type {@code exec.user.GetCatalogsResp}
   */
  public static final class GetCatalogsResp extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:exec.user.GetCatalogsResp)
      GetCatalogsRespOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use GetCatalogsResp.newBuilder() to construct.
    private GetCatalogsResp(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private GetCatalogsResp() {
      status_ = 0;
      catalogs_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new GetCatalogsResp();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetCatalogsResp_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetCatalogsResp_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.UserProtos.GetCatalogsResp.class, org.apache.drill.exec.proto.UserProtos.GetCatalogsResp.Builder.class);
    }

    private int bitField0_;
    public static final int STATUS_FIELD_NUMBER = 1;
    private int status_;
    /**
     * <code>optional .exec.user.RequestStatus status = 1;</code>
     * @return Whether the status field is set.
     */
    @java.lang.Override public boolean hasStatus() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>optional .exec.user.RequestStatus status = 1;</code>
     * @return The status.
     */
    @java.lang.Override public org.apache.drill.exec.proto.UserProtos.RequestStatus getStatus() {
      @SuppressWarnings("deprecation")
      org.apache.drill.exec.proto.UserProtos.RequestStatus result = org.apache.drill.exec.proto.UserProtos.RequestStatus.valueOf(status_);
      return result == null ? org.apache.drill.exec.proto.UserProtos.RequestStatus.UNKNOWN_STATUS : result;
    }

    public static final int CATALOGS_FIELD_NUMBER = 2;
    private java.util.List<org.apache.drill.exec.proto.UserProtos.CatalogMetadata> catalogs_;
    /**
     * <code>repeated .exec.user.CatalogMetadata catalogs = 2;</code>
     */
    @java.lang.Override
    public java.util.List<org.apache.drill.exec.proto.UserProtos.CatalogMetadata> getCatalogsList() {
      return catalogs_;
    }
    /**
     * <code>repeated .exec.user.CatalogMetadata catalogs = 2;</code>
     */
    @java.lang.Override
    public java.util.List<? extends org.apache.drill.exec.proto.UserProtos.CatalogMetadataOrBuilder> 
        getCatalogsOrBuilderList() {
      return catalogs_;
    }
    /**
     * <code>repeated .exec.user.CatalogMetadata catalogs = 2;</code>
     */
    @java.lang.Override
    public int getCatalogsCount() {
      return catalogs_.size();
    }
    /**
     * <code>repeated .exec.user.CatalogMetadata catalogs = 2;</code>
     */
    @java.lang.Override
    public org.apache.drill.exec.proto.UserProtos.CatalogMetadata getCatalogs(int index) {
      return catalogs_.get(index);
    }
    /**
     * <code>repeated .exec.user.CatalogMetadata catalogs = 2;</code>
     */
    @java.lang.Override
    public org.apache.drill.exec.proto.UserProtos.CatalogMetadataOrBuilder getCatalogsOrBuilder(
        int index) {
      return catalogs_.get(index);
    }

    public static final int ERROR_FIELD_NUMBER = 3;
    private org.apache.drill.exec.proto.UserBitShared.DrillPBError error_;
    /**
     * <code>optional .exec.shared.DrillPBError error = 3;</code>
     * @return Whether the error field is set.
     */
    @java.lang.Override
    public boolean hasError() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <code>optional .exec.shared.DrillPBError error = 3;</code>
     * @return The error.
     */
    @java.lang.Override
    public org.apache.drill.exec.proto.UserBitShared.DrillPBError getError() {
      return error_ == null ? org.apache.drill.exec.proto.UserBitShared.DrillPBError.getDefaultInstance() : error_;
    }
    /**
     * <code>optional .exec.shared.DrillPBError error = 3;</code>
     */
    @java.lang.Override
    public org.apache.drill.exec.proto.UserBitShared.DrillPBErrorOrBuilder getErrorOrBuilder() {
      return error_ == null ? org.apache.drill.exec.proto.UserBitShared.DrillPBError.getDefaultInstance() : error_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeEnum(1, status_);
      }
      for (int i = 0; i < catalogs_.size(); i++) {
        output.writeMessage(2, catalogs_.get(i));
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(3, getError());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(1, status_);
      }
      for (int i = 0; i < catalogs_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, catalogs_.get(i));
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, getError());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.drill.exec.proto.UserProtos.GetCatalogsResp)) {
        return super.equals(obj);
      }
      org.apache.drill.exec.proto.UserProtos.GetCatalogsResp other = (org.apache.drill.exec.proto.UserProtos.GetCatalogsResp) obj;

      if (hasStatus() != other.hasStatus()) return false;
      if (hasStatus()) {
        if (status_ != other.status_) return false;
      }
      if (!getCatalogsList()
          .equals(other.getCatalogsList())) return false;
      if (hasError() != other.hasError()) return false;
      if (hasError()) {
        if (!getError()
            .equals(other.getError())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasStatus()) {
        hash = (37 * hash) + STATUS_FIELD_NUMBER;
        hash = (53 * hash) + status_;
      }
      if (getCatalogsCount() > 0) {
        hash = (37 * hash) + CATALOGS_FIELD_NUMBER;
        hash = (53 * hash) + getCatalogsList().hashCode();
      }
      if (hasError()) {
        hash = (37 * hash) + ERROR_FIELD_NUMBER;
        hash = (53 * hash) + getError().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.drill.exec.proto.UserProtos.GetCatalogsResp parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetCatalogsResp parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetCatalogsResp parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetCatalogsResp parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetCatalogsResp parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetCatalogsResp parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetCatalogsResp parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetCatalogsResp parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetCatalogsResp parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetCatalogsResp parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetCatalogsResp parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetCatalogsResp parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.drill.exec.proto.UserProtos.GetCatalogsResp prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Response message for GetCatalogReq.
     * </pre>
     *
     * Protobuf type {@code exec.user.GetCatalogsResp}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:exec.user.GetCatalogsResp)
        org.apache.drill.exec.proto.UserProtos.GetCatalogsRespOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetCatalogsResp_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetCatalogsResp_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.UserProtos.GetCatalogsResp.class, org.apache.drill.exec.proto.UserProtos.GetCatalogsResp.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.UserProtos.GetCatalogsResp.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getCatalogsFieldBuilder();
          getErrorFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        status_ = 0;
        bitField0_ = (bitField0_ & ~0x00000001);
        if (catalogsBuilder_ == null) {
          catalogs_ = java.util.Collections.emptyList();
        } else {
          catalogs_ = null;
          catalogsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        if (errorBuilder_ == null) {
          error_ = null;
        } else {
          errorBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetCatalogsResp_descriptor;
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.GetCatalogsResp getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.UserProtos.GetCatalogsResp.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.GetCatalogsResp build() {
        org.apache.drill.exec.proto.UserProtos.GetCatalogsResp result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.GetCatalogsResp buildPartial() {
        org.apache.drill.exec.proto.UserProtos.GetCatalogsResp result = new org.apache.drill.exec.proto.UserProtos.GetCatalogsResp(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          to_bitField0_ |= 0x00000001;
        }
        result.status_ = status_;
        if (catalogsBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            catalogs_ = java.util.Collections.unmodifiableList(catalogs_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.catalogs_ = catalogs_;
        } else {
          result.catalogs_ = catalogsBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          if (errorBuilder_ == null) {
            result.error_ = error_;
          } else {
            result.error_ = errorBuilder_.build();
          }
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.UserProtos.GetCatalogsResp) {
          return mergeFrom((org.apache.drill.exec.proto.UserProtos.GetCatalogsResp)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.UserProtos.GetCatalogsResp other) {
        if (other == org.apache.drill.exec.proto.UserProtos.GetCatalogsResp.getDefaultInstance()) return this;
        if (other.hasStatus()) {
          setStatus(other.getStatus());
        }
        if (catalogsBuilder_ == null) {
          if (!other.catalogs_.isEmpty()) {
            if (catalogs_.isEmpty()) {
              catalogs_ = other.catalogs_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureCatalogsIsMutable();
              catalogs_.addAll(other.catalogs_);
            }
            onChanged();
          }
        } else {
          if (!other.catalogs_.isEmpty()) {
            if (catalogsBuilder_.isEmpty()) {
              catalogsBuilder_.dispose();
              catalogsBuilder_ = null;
              catalogs_ = other.catalogs_;
              bitField0_ = (bitField0_ & ~0x00000002);
              catalogsBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getCatalogsFieldBuilder() : null;
            } else {
              catalogsBuilder_.addAllMessages(other.catalogs_);
            }
          }
        }
        if (other.hasError()) {
          mergeError(other.getError());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8: {
                int tmpRaw = input.readEnum();
                org.apache.drill.exec.proto.UserProtos.RequestStatus tmpValue =
                    org.apache.drill.exec.proto.UserProtos.RequestStatus.forNumber(tmpRaw);
                if (tmpValue == null) {
                  mergeUnknownVarintField(1, tmpRaw);
                } else {
                  status_ = tmpRaw;
                  bitField0_ |= 0x00000001;
                }
                break;
              } // case 8
              case 18: {
                org.apache.drill.exec.proto.UserProtos.CatalogMetadata m =
                    input.readMessage(
                        org.apache.drill.exec.proto.UserProtos.CatalogMetadata.PARSER,
                        extensionRegistry);
                if (catalogsBuilder_ == null) {
                  ensureCatalogsIsMutable();
                  catalogs_.add(m);
                } else {
                  catalogsBuilder_.addMessage(m);
                }
                break;
              } // case 18
              case 26: {
                input.readMessage(
                    getErrorFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private int status_ = 0;
      /**
       * <code>optional .exec.user.RequestStatus status = 1;</code>
       * @return Whether the status field is set.
       */
      @java.lang.Override public boolean hasStatus() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>optional .exec.user.RequestStatus status = 1;</code>
       * @return The status.
       */
      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.RequestStatus getStatus() {
        @SuppressWarnings("deprecation")
        org.apache.drill.exec.proto.UserProtos.RequestStatus result = org.apache.drill.exec.proto.UserProtos.RequestStatus.valueOf(status_);
        return result == null ? org.apache.drill.exec.proto.UserProtos.RequestStatus.UNKNOWN_STATUS : result;
      }
      /**
       * <code>optional .exec.user.RequestStatus status = 1;</code>
       * @param value The status to set.
       * @return This builder for chaining.
       */
      public Builder setStatus(org.apache.drill.exec.proto.UserProtos.RequestStatus value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        status_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <code>optional .exec.user.RequestStatus status = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearStatus() {
        bitField0_ = (bitField0_ & ~0x00000001);
        status_ = 0;
        onChanged();
        return this;
      }

      private java.util.List<org.apache.drill.exec.proto.UserProtos.CatalogMetadata> catalogs_ =
        java.util.Collections.emptyList();
      private void ensureCatalogsIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          catalogs_ = new java.util.ArrayList<org.apache.drill.exec.proto.UserProtos.CatalogMetadata>(catalogs_);
          bitField0_ |= 0x00000002;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          org.apache.drill.exec.proto.UserProtos.CatalogMetadata, org.apache.drill.exec.proto.UserProtos.CatalogMetadata.Builder, org.apache.drill.exec.proto.UserProtos.CatalogMetadataOrBuilder> catalogsBuilder_;

      /**
       * <code>repeated .exec.user.CatalogMetadata catalogs = 2;</code>
       */
      public java.util.List<org.apache.drill.exec.proto.UserProtos.CatalogMetadata> getCatalogsList() {
        if (catalogsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(catalogs_);
        } else {
          return catalogsBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .exec.user.CatalogMetadata catalogs = 2;</code>
       */
      public int getCatalogsCount() {
        if (catalogsBuilder_ == null) {
          return catalogs_.size();
        } else {
          return catalogsBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .exec.user.CatalogMetadata catalogs = 2;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.CatalogMetadata getCatalogs(int index) {
        if (catalogsBuilder_ == null) {
          return catalogs_.get(index);
        } else {
          return catalogsBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .exec.user.CatalogMetadata catalogs = 2;</code>
       */
      public Builder setCatalogs(
          int index, org.apache.drill.exec.proto.UserProtos.CatalogMetadata value) {
        if (catalogsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureCatalogsIsMutable();
          catalogs_.set(index, value);
          onChanged();
        } else {
          catalogsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.CatalogMetadata catalogs = 2;</code>
       */
      public Builder setCatalogs(
          int index, org.apache.drill.exec.proto.UserProtos.CatalogMetadata.Builder builderForValue) {
        if (catalogsBuilder_ == null) {
          ensureCatalogsIsMutable();
          catalogs_.set(index, builderForValue.build());
          onChanged();
        } else {
          catalogsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.CatalogMetadata catalogs = 2;</code>
       */
      public Builder addCatalogs(org.apache.drill.exec.proto.UserProtos.CatalogMetadata value) {
        if (catalogsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureCatalogsIsMutable();
          catalogs_.add(value);
          onChanged();
        } else {
          catalogsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.CatalogMetadata catalogs = 2;</code>
       */
      public Builder addCatalogs(
          int index, org.apache.drill.exec.proto.UserProtos.CatalogMetadata value) {
        if (catalogsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureCatalogsIsMutable();
          catalogs_.add(index, value);
          onChanged();
        } else {
          catalogsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.CatalogMetadata catalogs = 2;</code>
       */
      public Builder addCatalogs(
          org.apache.drill.exec.proto.UserProtos.CatalogMetadata.Builder builderForValue) {
        if (catalogsBuilder_ == null) {
          ensureCatalogsIsMutable();
          catalogs_.add(builderForValue.build());
          onChanged();
        } else {
          catalogsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.CatalogMetadata catalogs = 2;</code>
       */
      public Builder addCatalogs(
          int index, org.apache.drill.exec.proto.UserProtos.CatalogMetadata.Builder builderForValue) {
        if (catalogsBuilder_ == null) {
          ensureCatalogsIsMutable();
          catalogs_.add(index, builderForValue.build());
          onChanged();
        } else {
          catalogsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.CatalogMetadata catalogs = 2;</code>
       */
      public Builder addAllCatalogs(
          java.lang.Iterable<? extends org.apache.drill.exec.proto.UserProtos.CatalogMetadata> values) {
        if (catalogsBuilder_ == null) {
          ensureCatalogsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, catalogs_);
          onChanged();
        } else {
          catalogsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.CatalogMetadata catalogs = 2;</code>
       */
      public Builder clearCatalogs() {
        if (catalogsBuilder_ == null) {
          catalogs_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          catalogsBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.CatalogMetadata catalogs = 2;</code>
       */
      public Builder removeCatalogs(int index) {
        if (catalogsBuilder_ == null) {
          ensureCatalogsIsMutable();
          catalogs_.remove(index);
          onChanged();
        } else {
          catalogsBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.CatalogMetadata catalogs = 2;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.CatalogMetadata.Builder getCatalogsBuilder(
          int index) {
        return getCatalogsFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .exec.user.CatalogMetadata catalogs = 2;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.CatalogMetadataOrBuilder getCatalogsOrBuilder(
          int index) {
        if (catalogsBuilder_ == null) {
          return catalogs_.get(index);  } else {
          return catalogsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .exec.user.CatalogMetadata catalogs = 2;</code>
       */
      public java.util.List<? extends org.apache.drill.exec.proto.UserProtos.CatalogMetadataOrBuilder> 
           getCatalogsOrBuilderList() {
        if (catalogsBuilder_ != null) {
          return catalogsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(catalogs_);
        }
      }
      /**
       * <code>repeated .exec.user.CatalogMetadata catalogs = 2;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.CatalogMetadata.Builder addCatalogsBuilder() {
        return getCatalogsFieldBuilder().addBuilder(
            org.apache.drill.exec.proto.UserProtos.CatalogMetadata.getDefaultInstance());
      }
      /**
       * <code>repeated .exec.user.CatalogMetadata catalogs = 2;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.CatalogMetadata.Builder addCatalogsBuilder(
          int index) {
        return getCatalogsFieldBuilder().addBuilder(
            index, org.apache.drill.exec.proto.UserProtos.CatalogMetadata.getDefaultInstance());
      }
      /**
       * <code>repeated .exec.user.CatalogMetadata catalogs = 2;</code>
       */
      public java.util.List<org.apache.drill.exec.proto.UserProtos.CatalogMetadata.Builder> 
           getCatalogsBuilderList() {
        return getCatalogsFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          org.apache.drill.exec.proto.UserProtos.CatalogMetadata, org.apache.drill.exec.proto.UserProtos.CatalogMetadata.Builder, org.apache.drill.exec.proto.UserProtos.CatalogMetadataOrBuilder> 
          getCatalogsFieldBuilder() {
        if (catalogsBuilder_ == null) {
          catalogsBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              org.apache.drill.exec.proto.UserProtos.CatalogMetadata, org.apache.drill.exec.proto.UserProtos.CatalogMetadata.Builder, org.apache.drill.exec.proto.UserProtos.CatalogMetadataOrBuilder>(
                  catalogs_,
                  ((bitField0_ & 0x00000002) != 0),
                  getParentForChildren(),
                  isClean());
          catalogs_ = null;
        }
        return catalogsBuilder_;
      }

      private org.apache.drill.exec.proto.UserBitShared.DrillPBError error_;
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.drill.exec.proto.UserBitShared.DrillPBError, org.apache.drill.exec.proto.UserBitShared.DrillPBError.Builder, org.apache.drill.exec.proto.UserBitShared.DrillPBErrorOrBuilder> errorBuilder_;
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       * @return Whether the error field is set.
       */
      public boolean hasError() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       * @return The error.
       */
      public org.apache.drill.exec.proto.UserBitShared.DrillPBError getError() {
        if (errorBuilder_ == null) {
          return error_ == null ? org.apache.drill.exec.proto.UserBitShared.DrillPBError.getDefaultInstance() : error_;
        } else {
          return errorBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       */
      public Builder setError(org.apache.drill.exec.proto.UserBitShared.DrillPBError value) {
        if (errorBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          error_ = value;
          onChanged();
        } else {
          errorBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       */
      public Builder setError(
          org.apache.drill.exec.proto.UserBitShared.DrillPBError.Builder builderForValue) {
        if (errorBuilder_ == null) {
          error_ = builderForValue.build();
          onChanged();
        } else {
          errorBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       */
      public Builder mergeError(org.apache.drill.exec.proto.UserBitShared.DrillPBError value) {
        if (errorBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0) &&
              error_ != null &&
              error_ != org.apache.drill.exec.proto.UserBitShared.DrillPBError.getDefaultInstance()) {
            error_ =
              org.apache.drill.exec.proto.UserBitShared.DrillPBError.newBuilder(error_).mergeFrom(value).buildPartial();
          } else {
            error_ = value;
          }
          onChanged();
        } else {
          errorBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       */
      public Builder clearError() {
        if (errorBuilder_ == null) {
          error_ = null;
          onChanged();
        } else {
          errorBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.DrillPBError.Builder getErrorBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getErrorFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.DrillPBErrorOrBuilder getErrorOrBuilder() {
        if (errorBuilder_ != null) {
          return errorBuilder_.getMessageOrBuilder();
        } else {
          return error_ == null ?
              org.apache.drill.exec.proto.UserBitShared.DrillPBError.getDefaultInstance() : error_;
        }
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.drill.exec.proto.UserBitShared.DrillPBError, org.apache.drill.exec.proto.UserBitShared.DrillPBError.Builder, org.apache.drill.exec.proto.UserBitShared.DrillPBErrorOrBuilder> 
          getErrorFieldBuilder() {
        if (errorBuilder_ == null) {
          errorBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.apache.drill.exec.proto.UserBitShared.DrillPBError, org.apache.drill.exec.proto.UserBitShared.DrillPBError.Builder, org.apache.drill.exec.proto.UserBitShared.DrillPBErrorOrBuilder>(
                  getError(),
                  getParentForChildren(),
                  isClean());
          error_ = null;
        }
        return errorBuilder_;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:exec.user.GetCatalogsResp)
    }

    // @@protoc_insertion_point(class_scope:exec.user.GetCatalogsResp)
    private static final org.apache.drill.exec.proto.UserProtos.GetCatalogsResp DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.drill.exec.proto.UserProtos.GetCatalogsResp();
    }

    public static org.apache.drill.exec.proto.UserProtos.GetCatalogsResp getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final com.google.protobuf.Parser<GetCatalogsResp>
        PARSER = new com.google.protobuf.AbstractParser<GetCatalogsResp>() {
      @java.lang.Override
      public GetCatalogsResp parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<GetCatalogsResp> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GetCatalogsResp> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.drill.exec.proto.UserProtos.GetCatalogsResp getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface GetSchemasReqOrBuilder extends
      // @@protoc_insertion_point(interface_extends:exec.user.GetSchemasReq)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
     * @return Whether the catalogNameFilter field is set.
     */
    boolean hasCatalogNameFilter();
    /**
     * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
     * @return The catalogNameFilter.
     */
    org.apache.drill.exec.proto.UserProtos.LikeFilter getCatalogNameFilter();
    /**
     * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
     */
    org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder getCatalogNameFilterOrBuilder();

    /**
     * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
     * @return Whether the schemaNameFilter field is set.
     */
    boolean hasSchemaNameFilter();
    /**
     * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
     * @return The schemaNameFilter.
     */
    org.apache.drill.exec.proto.UserProtos.LikeFilter getSchemaNameFilter();
    /**
     * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
     */
    org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder getSchemaNameFilterOrBuilder();
  }
  /**
   * <pre>
   * Request message for getting the metadata for schemas satisfying the given optional filters.
   * </pre>
   *
   * Protobuf type {@code exec.user.GetSchemasReq}
   */
  public static final class GetSchemasReq extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:exec.user.GetSchemasReq)
      GetSchemasReqOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use GetSchemasReq.newBuilder() to construct.
    private GetSchemasReq(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private GetSchemasReq() {
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new GetSchemasReq();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetSchemasReq_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetSchemasReq_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.UserProtos.GetSchemasReq.class, org.apache.drill.exec.proto.UserProtos.GetSchemasReq.Builder.class);
    }

    private int bitField0_;
    public static final int CATALOG_NAME_FILTER_FIELD_NUMBER = 1;
    private org.apache.drill.exec.proto.UserProtos.LikeFilter catalogNameFilter_;
    /**
     * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
     * @return Whether the catalogNameFilter field is set.
     */
    @java.lang.Override
    public boolean hasCatalogNameFilter() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
     * @return The catalogNameFilter.
     */
    @java.lang.Override
    public org.apache.drill.exec.proto.UserProtos.LikeFilter getCatalogNameFilter() {
      return catalogNameFilter_ == null ? org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance() : catalogNameFilter_;
    }
    /**
     * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
     */
    @java.lang.Override
    public org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder getCatalogNameFilterOrBuilder() {
      return catalogNameFilter_ == null ? org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance() : catalogNameFilter_;
    }

    public static final int SCHEMA_NAME_FILTER_FIELD_NUMBER = 2;
    private org.apache.drill.exec.proto.UserProtos.LikeFilter schemaNameFilter_;
    /**
     * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
     * @return Whether the schemaNameFilter field is set.
     */
    @java.lang.Override
    public boolean hasSchemaNameFilter() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
     * @return The schemaNameFilter.
     */
    @java.lang.Override
    public org.apache.drill.exec.proto.UserProtos.LikeFilter getSchemaNameFilter() {
      return schemaNameFilter_ == null ? org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance() : schemaNameFilter_;
    }
    /**
     * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
     */
    @java.lang.Override
    public org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder getSchemaNameFilterOrBuilder() {
      return schemaNameFilter_ == null ? org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance() : schemaNameFilter_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getCatalogNameFilter());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(2, getSchemaNameFilter());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, getCatalogNameFilter());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, getSchemaNameFilter());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.drill.exec.proto.UserProtos.GetSchemasReq)) {
        return super.equals(obj);
      }
      org.apache.drill.exec.proto.UserProtos.GetSchemasReq other = (org.apache.drill.exec.proto.UserProtos.GetSchemasReq) obj;

      if (hasCatalogNameFilter() != other.hasCatalogNameFilter()) return false;
      if (hasCatalogNameFilter()) {
        if (!getCatalogNameFilter()
            .equals(other.getCatalogNameFilter())) return false;
      }
      if (hasSchemaNameFilter() != other.hasSchemaNameFilter()) return false;
      if (hasSchemaNameFilter()) {
        if (!getSchemaNameFilter()
            .equals(other.getSchemaNameFilter())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasCatalogNameFilter()) {
        hash = (37 * hash) + CATALOG_NAME_FILTER_FIELD_NUMBER;
        hash = (53 * hash) + getCatalogNameFilter().hashCode();
      }
      if (hasSchemaNameFilter()) {
        hash = (37 * hash) + SCHEMA_NAME_FILTER_FIELD_NUMBER;
        hash = (53 * hash) + getSchemaNameFilter().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.drill.exec.proto.UserProtos.GetSchemasReq parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetSchemasReq parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetSchemasReq parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetSchemasReq parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetSchemasReq parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetSchemasReq parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetSchemasReq parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetSchemasReq parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetSchemasReq parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetSchemasReq parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetSchemasReq parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetSchemasReq parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.drill.exec.proto.UserProtos.GetSchemasReq prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Request message for getting the metadata for schemas satisfying the given optional filters.
     * </pre>
     *
     * Protobuf type {@code exec.user.GetSchemasReq}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:exec.user.GetSchemasReq)
        org.apache.drill.exec.proto.UserProtos.GetSchemasReqOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetSchemasReq_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetSchemasReq_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.UserProtos.GetSchemasReq.class, org.apache.drill.exec.proto.UserProtos.GetSchemasReq.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.UserProtos.GetSchemasReq.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getCatalogNameFilterFieldBuilder();
          getSchemaNameFilterFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (catalogNameFilterBuilder_ == null) {
          catalogNameFilter_ = null;
        } else {
          catalogNameFilterBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        if (schemaNameFilterBuilder_ == null) {
          schemaNameFilter_ = null;
        } else {
          schemaNameFilterBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetSchemasReq_descriptor;
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.GetSchemasReq getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.UserProtos.GetSchemasReq.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.GetSchemasReq build() {
        org.apache.drill.exec.proto.UserProtos.GetSchemasReq result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.GetSchemasReq buildPartial() {
        org.apache.drill.exec.proto.UserProtos.GetSchemasReq result = new org.apache.drill.exec.proto.UserProtos.GetSchemasReq(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          if (catalogNameFilterBuilder_ == null) {
            result.catalogNameFilter_ = catalogNameFilter_;
          } else {
            result.catalogNameFilter_ = catalogNameFilterBuilder_.build();
          }
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          if (schemaNameFilterBuilder_ == null) {
            result.schemaNameFilter_ = schemaNameFilter_;
          } else {
            result.schemaNameFilter_ = schemaNameFilterBuilder_.build();
          }
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.UserProtos.GetSchemasReq) {
          return mergeFrom((org.apache.drill.exec.proto.UserProtos.GetSchemasReq)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.UserProtos.GetSchemasReq other) {
        if (other == org.apache.drill.exec.proto.UserProtos.GetSchemasReq.getDefaultInstance()) return this;
        if (other.hasCatalogNameFilter()) {
          mergeCatalogNameFilter(other.getCatalogNameFilter());
        }
        if (other.hasSchemaNameFilter()) {
          mergeSchemaNameFilter(other.getSchemaNameFilter());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                input.readMessage(
                    getCatalogNameFilterFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
              case 18: {
                input.readMessage(
                    getSchemaNameFilterFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private org.apache.drill.exec.proto.UserProtos.LikeFilter catalogNameFilter_;
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.drill.exec.proto.UserProtos.LikeFilter, org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder, org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder> catalogNameFilterBuilder_;
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       * @return Whether the catalogNameFilter field is set.
       */
      public boolean hasCatalogNameFilter() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       * @return The catalogNameFilter.
       */
      public org.apache.drill.exec.proto.UserProtos.LikeFilter getCatalogNameFilter() {
        if (catalogNameFilterBuilder_ == null) {
          return catalogNameFilter_ == null ? org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance() : catalogNameFilter_;
        } else {
          return catalogNameFilterBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       */
      public Builder setCatalogNameFilter(org.apache.drill.exec.proto.UserProtos.LikeFilter value) {
        if (catalogNameFilterBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          catalogNameFilter_ = value;
          onChanged();
        } else {
          catalogNameFilterBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       */
      public Builder setCatalogNameFilter(
          org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder builderForValue) {
        if (catalogNameFilterBuilder_ == null) {
          catalogNameFilter_ = builderForValue.build();
          onChanged();
        } else {
          catalogNameFilterBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       */
      public Builder mergeCatalogNameFilter(org.apache.drill.exec.proto.UserProtos.LikeFilter value) {
        if (catalogNameFilterBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0) &&
              catalogNameFilter_ != null &&
              catalogNameFilter_ != org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance()) {
            catalogNameFilter_ =
              org.apache.drill.exec.proto.UserProtos.LikeFilter.newBuilder(catalogNameFilter_).mergeFrom(value).buildPartial();
          } else {
            catalogNameFilter_ = value;
          }
          onChanged();
        } else {
          catalogNameFilterBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       */
      public Builder clearCatalogNameFilter() {
        if (catalogNameFilterBuilder_ == null) {
          catalogNameFilter_ = null;
          onChanged();
        } else {
          catalogNameFilterBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder getCatalogNameFilterBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getCatalogNameFilterFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder getCatalogNameFilterOrBuilder() {
        if (catalogNameFilterBuilder_ != null) {
          return catalogNameFilterBuilder_.getMessageOrBuilder();
        } else {
          return catalogNameFilter_ == null ?
              org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance() : catalogNameFilter_;
        }
      }
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.drill.exec.proto.UserProtos.LikeFilter, org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder, org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder> 
          getCatalogNameFilterFieldBuilder() {
        if (catalogNameFilterBuilder_ == null) {
          catalogNameFilterBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.apache.drill.exec.proto.UserProtos.LikeFilter, org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder, org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder>(
                  getCatalogNameFilter(),
                  getParentForChildren(),
                  isClean());
          catalogNameFilter_ = null;
        }
        return catalogNameFilterBuilder_;
      }

      private org.apache.drill.exec.proto.UserProtos.LikeFilter schemaNameFilter_;
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.drill.exec.proto.UserProtos.LikeFilter, org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder, org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder> schemaNameFilterBuilder_;
      /**
       * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
       * @return Whether the schemaNameFilter field is set.
       */
      public boolean hasSchemaNameFilter() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
       * @return The schemaNameFilter.
       */
      public org.apache.drill.exec.proto.UserProtos.LikeFilter getSchemaNameFilter() {
        if (schemaNameFilterBuilder_ == null) {
          return schemaNameFilter_ == null ? org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance() : schemaNameFilter_;
        } else {
          return schemaNameFilterBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
       */
      public Builder setSchemaNameFilter(org.apache.drill.exec.proto.UserProtos.LikeFilter value) {
        if (schemaNameFilterBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          schemaNameFilter_ = value;
          onChanged();
        } else {
          schemaNameFilterBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
       */
      public Builder setSchemaNameFilter(
          org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder builderForValue) {
        if (schemaNameFilterBuilder_ == null) {
          schemaNameFilter_ = builderForValue.build();
          onChanged();
        } else {
          schemaNameFilterBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
       */
      public Builder mergeSchemaNameFilter(org.apache.drill.exec.proto.UserProtos.LikeFilter value) {
        if (schemaNameFilterBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0) &&
              schemaNameFilter_ != null &&
              schemaNameFilter_ != org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance()) {
            schemaNameFilter_ =
              org.apache.drill.exec.proto.UserProtos.LikeFilter.newBuilder(schemaNameFilter_).mergeFrom(value).buildPartial();
          } else {
            schemaNameFilter_ = value;
          }
          onChanged();
        } else {
          schemaNameFilterBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
       */
      public Builder clearSchemaNameFilter() {
        if (schemaNameFilterBuilder_ == null) {
          schemaNameFilter_ = null;
          onChanged();
        } else {
          schemaNameFilterBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder getSchemaNameFilterBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getSchemaNameFilterFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder getSchemaNameFilterOrBuilder() {
        if (schemaNameFilterBuilder_ != null) {
          return schemaNameFilterBuilder_.getMessageOrBuilder();
        } else {
          return schemaNameFilter_ == null ?
              org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance() : schemaNameFilter_;
        }
      }
      /**
       * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.drill.exec.proto.UserProtos.LikeFilter, org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder, org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder> 
          getSchemaNameFilterFieldBuilder() {
        if (schemaNameFilterBuilder_ == null) {
          schemaNameFilterBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.apache.drill.exec.proto.UserProtos.LikeFilter, org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder, org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder>(
                  getSchemaNameFilter(),
                  getParentForChildren(),
                  isClean());
          schemaNameFilter_ = null;
        }
        return schemaNameFilterBuilder_;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:exec.user.GetSchemasReq)
    }

    // @@protoc_insertion_point(class_scope:exec.user.GetSchemasReq)
    private static final org.apache.drill.exec.proto.UserProtos.GetSchemasReq DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.drill.exec.proto.UserProtos.GetSchemasReq();
    }

    public static org.apache.drill.exec.proto.UserProtos.GetSchemasReq getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final com.google.protobuf.Parser<GetSchemasReq>
        PARSER = new com.google.protobuf.AbstractParser<GetSchemasReq>() {
      @java.lang.Override
      public GetSchemasReq parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<GetSchemasReq> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GetSchemasReq> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.drill.exec.proto.UserProtos.GetSchemasReq getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface SchemaMetadataOrBuilder extends
      // @@protoc_insertion_point(interface_extends:exec.user.SchemaMetadata)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>optional string catalog_name = 1;</code>
     * @return Whether the catalogName field is set.
     */
    boolean hasCatalogName();
    /**
     * <code>optional string catalog_name = 1;</code>
     * @return The catalogName.
     */
    java.lang.String getCatalogName();
    /**
     * <code>optional string catalog_name = 1;</code>
     * @return The bytes for catalogName.
     */
    com.google.protobuf.ByteString
        getCatalogNameBytes();

    /**
     * <code>optional string schema_name = 2;</code>
     * @return Whether the schemaName field is set.
     */
    boolean hasSchemaName();
    /**
     * <code>optional string schema_name = 2;</code>
     * @return The schemaName.
     */
    java.lang.String getSchemaName();
    /**
     * <code>optional string schema_name = 2;</code>
     * @return The bytes for schemaName.
     */
    com.google.protobuf.ByteString
        getSchemaNameBytes();

    /**
     * <code>optional string owner = 3;</code>
     * @return Whether the owner field is set.
     */
    boolean hasOwner();
    /**
     * <code>optional string owner = 3;</code>
     * @return The owner.
     */
    java.lang.String getOwner();
    /**
     * <code>optional string owner = 3;</code>
     * @return The bytes for owner.
     */
    com.google.protobuf.ByteString
        getOwnerBytes();

    /**
     * <pre>
     * Type. Ex. "file", "mongodb", "hive" etc.
     * </pre>
     *
     * <code>optional string type = 4;</code>
     * @return Whether the type field is set.
     */
    boolean hasType();
    /**
     * <pre>
     * Type. Ex. "file", "mongodb", "hive" etc.
     * </pre>
     *
     * <code>optional string type = 4;</code>
     * @return The type.
     */
    java.lang.String getType();
    /**
     * <pre>
     * Type. Ex. "file", "mongodb", "hive" etc.
     * </pre>
     *
     * <code>optional string type = 4;</code>
     * @return The bytes for type.
     */
    com.google.protobuf.ByteString
        getTypeBytes();

    /**
     * <code>optional string mutable = 5;</code>
     * @return Whether the mutable field is set.
     */
    boolean hasMutable();
    /**
     * <code>optional string mutable = 5;</code>
     * @return The mutable.
     */
    java.lang.String getMutable();
    /**
     * <code>optional string mutable = 5;</code>
     * @return The bytes for mutable.
     */
    com.google.protobuf.ByteString
        getMutableBytes();
  }
  /**
   * <pre>
   * Message encapsulating metadata for a Schema.
   * </pre>
   *
   * Protobuf type {@code exec.user.SchemaMetadata}
   */
  public static final class SchemaMetadata extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:exec.user.SchemaMetadata)
      SchemaMetadataOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use SchemaMetadata.newBuilder() to construct.
    private SchemaMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private SchemaMetadata() {
      catalogName_ = "";
      schemaName_ = "";
      owner_ = "";
      type_ = "";
      mutable_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new SchemaMetadata();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_SchemaMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_SchemaMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.UserProtos.SchemaMetadata.class, org.apache.drill.exec.proto.UserProtos.SchemaMetadata.Builder.class);
    }

    private int bitField0_;
    public static final int CATALOG_NAME_FIELD_NUMBER = 1;
    private volatile java.lang.Object catalogName_;
    /**
     * <code>optional string catalog_name = 1;</code>
     * @return Whether the catalogName field is set.
     */
    @java.lang.Override
    public boolean hasCatalogName() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>optional string catalog_name = 1;</code>
     * @return The catalogName.
     */
    @java.lang.Override
    public java.lang.String getCatalogName() {
      java.lang.Object ref = catalogName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          catalogName_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string catalog_name = 1;</code>
     * @return The bytes for catalogName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getCatalogNameBytes() {
      java.lang.Object ref = catalogName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        catalogName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SCHEMA_NAME_FIELD_NUMBER = 2;
    private volatile java.lang.Object schemaName_;
    /**
     * <code>optional string schema_name = 2;</code>
     * @return Whether the schemaName field is set.
     */
    @java.lang.Override
    public boolean hasSchemaName() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <code>optional string schema_name = 2;</code>
     * @return The schemaName.
     */
    @java.lang.Override
    public java.lang.String getSchemaName() {
      java.lang.Object ref = schemaName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          schemaName_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string schema_name = 2;</code>
     * @return The bytes for schemaName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getSchemaNameBytes() {
      java.lang.Object ref = schemaName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        schemaName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int OWNER_FIELD_NUMBER = 3;
    private volatile java.lang.Object owner_;
    /**
     * <code>optional string owner = 3;</code>
     * @return Whether the owner field is set.
     */
    @java.lang.Override
    public boolean hasOwner() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <code>optional string owner = 3;</code>
     * @return The owner.
     */
    @java.lang.Override
    public java.lang.String getOwner() {
      java.lang.Object ref = owner_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          owner_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string owner = 3;</code>
     * @return The bytes for owner.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getOwnerBytes() {
      java.lang.Object ref = owner_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        owner_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TYPE_FIELD_NUMBER = 4;
    private volatile java.lang.Object type_;
    /**
     * <pre>
     * Type. Ex. "file", "mongodb", "hive" etc.
     * </pre>
     *
     * <code>optional string type = 4;</code>
     * @return Whether the type field is set.
     */
    @java.lang.Override
    public boolean hasType() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     * <pre>
     * Type. Ex. "file", "mongodb", "hive" etc.
     * </pre>
     *
     * <code>optional string type = 4;</code>
     * @return The type.
     */
    @java.lang.Override
    public java.lang.String getType() {
      java.lang.Object ref = type_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          type_ = s;
        }
        return s;
      }
    }
    /**
     * <pre>
     * Type. Ex. "file", "mongodb", "hive" etc.
     * </pre>
     *
     * <code>optional string type = 4;</code>
     * @return The bytes for type.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getTypeBytes() {
      java.lang.Object ref = type_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        type_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int MUTABLE_FIELD_NUMBER = 5;
    private volatile java.lang.Object mutable_;
    /**
     * <code>optional string mutable = 5;</code>
     * @return Whether the mutable field is set.
     */
    @java.lang.Override
    public boolean hasMutable() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     * <code>optional string mutable = 5;</code>
     * @return The mutable.
     */
    @java.lang.Override
    public java.lang.String getMutable() {
      java.lang.Object ref = mutable_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          mutable_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string mutable = 5;</code>
     * @return The bytes for mutable.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getMutableBytes() {
      java.lang.Object ref = mutable_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        mutable_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, catalogName_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, schemaName_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, owner_);
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, type_);
      }
      if (((bitField0_ & 0x00000010) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, mutable_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, catalogName_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, schemaName_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, owner_);
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, type_);
      }
      if (((bitField0_ & 0x00000010) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, mutable_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.drill.exec.proto.UserProtos.SchemaMetadata)) {
        return super.equals(obj);
      }
      org.apache.drill.exec.proto.UserProtos.SchemaMetadata other = (org.apache.drill.exec.proto.UserProtos.SchemaMetadata) obj;

      if (hasCatalogName() != other.hasCatalogName()) return false;
      if (hasCatalogName()) {
        if (!getCatalogName()
            .equals(other.getCatalogName())) return false;
      }
      if (hasSchemaName() != other.hasSchemaName()) return false;
      if (hasSchemaName()) {
        if (!getSchemaName()
            .equals(other.getSchemaName())) return false;
      }
      if (hasOwner() != other.hasOwner()) return false;
      if (hasOwner()) {
        if (!getOwner()
            .equals(other.getOwner())) return false;
      }
      if (hasType() != other.hasType()) return false;
      if (hasType()) {
        if (!getType()
            .equals(other.getType())) return false;
      }
      if (hasMutable() != other.hasMutable()) return false;
      if (hasMutable()) {
        if (!getMutable()
            .equals(other.getMutable())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasCatalogName()) {
        hash = (37 * hash) + CATALOG_NAME_FIELD_NUMBER;
        hash = (53 * hash) + getCatalogName().hashCode();
      }
      if (hasSchemaName()) {
        hash = (37 * hash) + SCHEMA_NAME_FIELD_NUMBER;
        hash = (53 * hash) + getSchemaName().hashCode();
      }
      if (hasOwner()) {
        hash = (37 * hash) + OWNER_FIELD_NUMBER;
        hash = (53 * hash) + getOwner().hashCode();
      }
      if (hasType()) {
        hash = (37 * hash) + TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getType().hashCode();
      }
      if (hasMutable()) {
        hash = (37 * hash) + MUTABLE_FIELD_NUMBER;
        hash = (53 * hash) + getMutable().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.drill.exec.proto.UserProtos.SchemaMetadata parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.SchemaMetadata parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.SchemaMetadata parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.SchemaMetadata parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.SchemaMetadata parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.SchemaMetadata parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.SchemaMetadata parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.SchemaMetadata parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.SchemaMetadata parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.SchemaMetadata parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.SchemaMetadata parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.SchemaMetadata parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.drill.exec.proto.UserProtos.SchemaMetadata prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Message encapsulating metadata for a Schema.
     * </pre>
     *
     * Protobuf type {@code exec.user.SchemaMetadata}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:exec.user.SchemaMetadata)
        org.apache.drill.exec.proto.UserProtos.SchemaMetadataOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_SchemaMetadata_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_SchemaMetadata_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.UserProtos.SchemaMetadata.class, org.apache.drill.exec.proto.UserProtos.SchemaMetadata.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.UserProtos.SchemaMetadata.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        catalogName_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        schemaName_ = "";
        bitField0_ = (bitField0_ & ~0x00000002);
        owner_ = "";
        bitField0_ = (bitField0_ & ~0x00000004);
        type_ = "";
        bitField0_ = (bitField0_ & ~0x00000008);
        mutable_ = "";
        bitField0_ = (bitField0_ & ~0x00000010);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_SchemaMetadata_descriptor;
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.SchemaMetadata getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.UserProtos.SchemaMetadata.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.SchemaMetadata build() {
        org.apache.drill.exec.proto.UserProtos.SchemaMetadata result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.SchemaMetadata buildPartial() {
        org.apache.drill.exec.proto.UserProtos.SchemaMetadata result = new org.apache.drill.exec.proto.UserProtos.SchemaMetadata(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          to_bitField0_ |= 0x00000001;
        }
        result.catalogName_ = catalogName_;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          to_bitField0_ |= 0x00000002;
        }
        result.schemaName_ = schemaName_;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          to_bitField0_ |= 0x00000004;
        }
        result.owner_ = owner_;
        if (((from_bitField0_ & 0x00000008) != 0)) {
          to_bitField0_ |= 0x00000008;
        }
        result.type_ = type_;
        if (((from_bitField0_ & 0x00000010) != 0)) {
          to_bitField0_ |= 0x00000010;
        }
        result.mutable_ = mutable_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.UserProtos.SchemaMetadata) {
          return mergeFrom((org.apache.drill.exec.proto.UserProtos.SchemaMetadata)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.UserProtos.SchemaMetadata other) {
        if (other == org.apache.drill.exec.proto.UserProtos.SchemaMetadata.getDefaultInstance()) return this;
        if (other.hasCatalogName()) {
          bitField0_ |= 0x00000001;
          catalogName_ = other.catalogName_;
          onChanged();
        }
        if (other.hasSchemaName()) {
          bitField0_ |= 0x00000002;
          schemaName_ = other.schemaName_;
          onChanged();
        }
        if (other.hasOwner()) {
          bitField0_ |= 0x00000004;
          owner_ = other.owner_;
          onChanged();
        }
        if (other.hasType()) {
          bitField0_ |= 0x00000008;
          type_ = other.type_;
          onChanged();
        }
        if (other.hasMutable()) {
          bitField0_ |= 0x00000010;
          mutable_ = other.mutable_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                catalogName_ = input.readBytes();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
              case 18: {
                schemaName_ = input.readBytes();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
              case 26: {
                owner_ = input.readBytes();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
              case 34: {
                type_ = input.readBytes();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
              case 42: {
                mutable_ = input.readBytes();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private java.lang.Object catalogName_ = "";
      /**
       * <code>optional string catalog_name = 1;</code>
       * @return Whether the catalogName field is set.
       */
      public boolean hasCatalogName() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>optional string catalog_name = 1;</code>
       * @return The catalogName.
       */
      public java.lang.String getCatalogName() {
        java.lang.Object ref = catalogName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            catalogName_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string catalog_name = 1;</code>
       * @return The bytes for catalogName.
       */
      public com.google.protobuf.ByteString
          getCatalogNameBytes() {
        java.lang.Object ref = catalogName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          catalogName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string catalog_name = 1;</code>
       * @param value The catalogName to set.
       * @return This builder for chaining.
       */
      public Builder setCatalogName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        catalogName_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string catalog_name = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearCatalogName() {
        bitField0_ = (bitField0_ & ~0x00000001);
        catalogName_ = getDefaultInstance().getCatalogName();
        onChanged();
        return this;
      }
      /**
       * <code>optional string catalog_name = 1;</code>
       * @param value The bytes for catalogName to set.
       * @return This builder for chaining.
       */
      public Builder setCatalogNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        catalogName_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object schemaName_ = "";
      /**
       * <code>optional string schema_name = 2;</code>
       * @return Whether the schemaName field is set.
       */
      public boolean hasSchemaName() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <code>optional string schema_name = 2;</code>
       * @return The schemaName.
       */
      public java.lang.String getSchemaName() {
        java.lang.Object ref = schemaName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            schemaName_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string schema_name = 2;</code>
       * @return The bytes for schemaName.
       */
      public com.google.protobuf.ByteString
          getSchemaNameBytes() {
        java.lang.Object ref = schemaName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          schemaName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string schema_name = 2;</code>
       * @param value The schemaName to set.
       * @return This builder for chaining.
       */
      public Builder setSchemaName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        schemaName_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string schema_name = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearSchemaName() {
        bitField0_ = (bitField0_ & ~0x00000002);
        schemaName_ = getDefaultInstance().getSchemaName();
        onChanged();
        return this;
      }
      /**
       * <code>optional string schema_name = 2;</code>
       * @param value The bytes for schemaName to set.
       * @return This builder for chaining.
       */
      public Builder setSchemaNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        schemaName_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object owner_ = "";
      /**
       * <code>optional string owner = 3;</code>
       * @return Whether the owner field is set.
       */
      public boolean hasOwner() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <code>optional string owner = 3;</code>
       * @return The owner.
       */
      public java.lang.String getOwner() {
        java.lang.Object ref = owner_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            owner_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string owner = 3;</code>
       * @return The bytes for owner.
       */
      public com.google.protobuf.ByteString
          getOwnerBytes() {
        java.lang.Object ref = owner_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          owner_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string owner = 3;</code>
       * @param value The owner to set.
       * @return This builder for chaining.
       */
      public Builder setOwner(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        owner_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string owner = 3;</code>
       * @return This builder for chaining.
       */
      public Builder clearOwner() {
        bitField0_ = (bitField0_ & ~0x00000004);
        owner_ = getDefaultInstance().getOwner();
        onChanged();
        return this;
      }
      /**
       * <code>optional string owner = 3;</code>
       * @param value The bytes for owner to set.
       * @return This builder for chaining.
       */
      public Builder setOwnerBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        owner_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object type_ = "";
      /**
       * <pre>
       * Type. Ex. "file", "mongodb", "hive" etc.
       * </pre>
       *
       * <code>optional string type = 4;</code>
       * @return Whether the type field is set.
       */
      public boolean hasType() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       * <pre>
       * Type. Ex. "file", "mongodb", "hive" etc.
       * </pre>
       *
       * <code>optional string type = 4;</code>
       * @return The type.
       */
      public java.lang.String getType() {
        java.lang.Object ref = type_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            type_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Type. Ex. "file", "mongodb", "hive" etc.
       * </pre>
       *
       * <code>optional string type = 4;</code>
       * @return The bytes for type.
       */
      public com.google.protobuf.ByteString
          getTypeBytes() {
        java.lang.Object ref = type_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          type_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Type. Ex. "file", "mongodb", "hive" etc.
       * </pre>
       *
       * <code>optional string type = 4;</code>
       * @param value The type to set.
       * @return This builder for chaining.
       */
      public Builder setType(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000008;
        type_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Type. Ex. "file", "mongodb", "hive" etc.
       * </pre>
       *
       * <code>optional string type = 4;</code>
       * @return This builder for chaining.
       */
      public Builder clearType() {
        bitField0_ = (bitField0_ & ~0x00000008);
        type_ = getDefaultInstance().getType();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Type. Ex. "file", "mongodb", "hive" etc.
       * </pre>
       *
       * <code>optional string type = 4;</code>
       * @param value The bytes for type to set.
       * @return This builder for chaining.
       */
      public Builder setTypeBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000008;
        type_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object mutable_ = "";
      /**
       * <code>optional string mutable = 5;</code>
       * @return Whether the mutable field is set.
       */
      public boolean hasMutable() {
        return ((bitField0_ & 0x00000010) != 0);
      }
      /**
       * <code>optional string mutable = 5;</code>
       * @return The mutable.
       */
      public java.lang.String getMutable() {
        java.lang.Object ref = mutable_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            mutable_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string mutable = 5;</code>
       * @return The bytes for mutable.
       */
      public com.google.protobuf.ByteString
          getMutableBytes() {
        java.lang.Object ref = mutable_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          mutable_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string mutable = 5;</code>
       * @param value The mutable to set.
       * @return This builder for chaining.
       */
      public Builder setMutable(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000010;
        mutable_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string mutable = 5;</code>
       * @return This builder for chaining.
       */
      public Builder clearMutable() {
        bitField0_ = (bitField0_ & ~0x00000010);
        mutable_ = getDefaultInstance().getMutable();
        onChanged();
        return this;
      }
      /**
       * <code>optional string mutable = 5;</code>
       * @param value The bytes for mutable to set.
       * @return This builder for chaining.
       */
      public Builder setMutableBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000010;
        mutable_ = value;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:exec.user.SchemaMetadata)
    }

    // @@protoc_insertion_point(class_scope:exec.user.SchemaMetadata)
    private static final org.apache.drill.exec.proto.UserProtos.SchemaMetadata DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.drill.exec.proto.UserProtos.SchemaMetadata();
    }

    public static org.apache.drill.exec.proto.UserProtos.SchemaMetadata getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final com.google.protobuf.Parser<SchemaMetadata>
        PARSER = new com.google.protobuf.AbstractParser<SchemaMetadata>() {
      @java.lang.Override
      public SchemaMetadata parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<SchemaMetadata> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SchemaMetadata> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.drill.exec.proto.UserProtos.SchemaMetadata getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface GetSchemasRespOrBuilder extends
      // @@protoc_insertion_point(interface_extends:exec.user.GetSchemasResp)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>optional .exec.user.RequestStatus status = 1;</code>
     * @return Whether the status field is set.
     */
    boolean hasStatus();
    /**
     * <code>optional .exec.user.RequestStatus status = 1;</code>
     * @return The status.
     */
    org.apache.drill.exec.proto.UserProtos.RequestStatus getStatus();

    /**
     * <code>repeated .exec.user.SchemaMetadata schemas = 2;</code>
     */
    java.util.List<org.apache.drill.exec.proto.UserProtos.SchemaMetadata> 
        getSchemasList();
    /**
     * <code>repeated .exec.user.SchemaMetadata schemas = 2;</code>
     */
    org.apache.drill.exec.proto.UserProtos.SchemaMetadata getSchemas(int index);
    /**
     * <code>repeated .exec.user.SchemaMetadata schemas = 2;</code>
     */
    int getSchemasCount();
    /**
     * <code>repeated .exec.user.SchemaMetadata schemas = 2;</code>
     */
    java.util.List<? extends org.apache.drill.exec.proto.UserProtos.SchemaMetadataOrBuilder> 
        getSchemasOrBuilderList();
    /**
     * <code>repeated .exec.user.SchemaMetadata schemas = 2;</code>
     */
    org.apache.drill.exec.proto.UserProtos.SchemaMetadataOrBuilder getSchemasOrBuilder(
        int index);

    /**
     * <code>optional .exec.shared.DrillPBError error = 3;</code>
     * @return Whether the error field is set.
     */
    boolean hasError();
    /**
     * <code>optional .exec.shared.DrillPBError error = 3;</code>
     * @return The error.
     */
    org.apache.drill.exec.proto.UserBitShared.DrillPBError getError();
    /**
     * <code>optional .exec.shared.DrillPBError error = 3;</code>
     */
    org.apache.drill.exec.proto.UserBitShared.DrillPBErrorOrBuilder getErrorOrBuilder();
  }
  /**
   * <pre>
   * Response message for GetSchemasReq.
   * </pre>
   *
   * Protobuf type {@code exec.user.GetSchemasResp}
   */
  public static final class GetSchemasResp extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:exec.user.GetSchemasResp)
      GetSchemasRespOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use GetSchemasResp.newBuilder() to construct.
    private GetSchemasResp(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private GetSchemasResp() {
      status_ = 0;
      schemas_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new GetSchemasResp();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetSchemasResp_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetSchemasResp_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.UserProtos.GetSchemasResp.class, org.apache.drill.exec.proto.UserProtos.GetSchemasResp.Builder.class);
    }

    private int bitField0_;
    public static final int STATUS_FIELD_NUMBER = 1;
    private int status_;
    /**
     * <code>optional .exec.user.RequestStatus status = 1;</code>
     * @return Whether the status field is set.
     */
    @java.lang.Override public boolean hasStatus() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>optional .exec.user.RequestStatus status = 1;</code>
     * @return The status.
     */
    @java.lang.Override public org.apache.drill.exec.proto.UserProtos.RequestStatus getStatus() {
      @SuppressWarnings("deprecation")
      org.apache.drill.exec.proto.UserProtos.RequestStatus result = org.apache.drill.exec.proto.UserProtos.RequestStatus.valueOf(status_);
      return result == null ? org.apache.drill.exec.proto.UserProtos.RequestStatus.UNKNOWN_STATUS : result;
    }

    public static final int SCHEMAS_FIELD_NUMBER = 2;
    private java.util.List<org.apache.drill.exec.proto.UserProtos.SchemaMetadata> schemas_;
    /**
     * <code>repeated .exec.user.SchemaMetadata schemas = 2;</code>
     */
    @java.lang.Override
    public java.util.List<org.apache.drill.exec.proto.UserProtos.SchemaMetadata> getSchemasList() {
      return schemas_;
    }
    /**
     * <code>repeated .exec.user.SchemaMetadata schemas = 2;</code>
     */
    @java.lang.Override
    public java.util.List<? extends org.apache.drill.exec.proto.UserProtos.SchemaMetadataOrBuilder> 
        getSchemasOrBuilderList() {
      return schemas_;
    }
    /**
     * <code>repeated .exec.user.SchemaMetadata schemas = 2;</code>
     */
    @java.lang.Override
    public int getSchemasCount() {
      return schemas_.size();
    }
    /**
     * <code>repeated .exec.user.SchemaMetadata schemas = 2;</code>
     */
    @java.lang.Override
    public org.apache.drill.exec.proto.UserProtos.SchemaMetadata getSchemas(int index) {
      return schemas_.get(index);
    }
    /**
     * <code>repeated .exec.user.SchemaMetadata schemas = 2;</code>
     */
    @java.lang.Override
    public org.apache.drill.exec.proto.UserProtos.SchemaMetadataOrBuilder getSchemasOrBuilder(
        int index) {
      return schemas_.get(index);
    }

    public static final int ERROR_FIELD_NUMBER = 3;
    private org.apache.drill.exec.proto.UserBitShared.DrillPBError error_;
    /**
     * <code>optional .exec.shared.DrillPBError error = 3;</code>
     * @return Whether the error field is set.
     */
    @java.lang.Override
    public boolean hasError() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <code>optional .exec.shared.DrillPBError error = 3;</code>
     * @return The error.
     */
    @java.lang.Override
    public org.apache.drill.exec.proto.UserBitShared.DrillPBError getError() {
      return error_ == null ? org.apache.drill.exec.proto.UserBitShared.DrillPBError.getDefaultInstance() : error_;
    }
    /**
     * <code>optional .exec.shared.DrillPBError error = 3;</code>
     */
    @java.lang.Override
    public org.apache.drill.exec.proto.UserBitShared.DrillPBErrorOrBuilder getErrorOrBuilder() {
      return error_ == null ? org.apache.drill.exec.proto.UserBitShared.DrillPBError.getDefaultInstance() : error_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeEnum(1, status_);
      }
      for (int i = 0; i < schemas_.size(); i++) {
        output.writeMessage(2, schemas_.get(i));
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(3, getError());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(1, status_);
      }
      for (int i = 0; i < schemas_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, schemas_.get(i));
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, getError());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.drill.exec.proto.UserProtos.GetSchemasResp)) {
        return super.equals(obj);
      }
      org.apache.drill.exec.proto.UserProtos.GetSchemasResp other = (org.apache.drill.exec.proto.UserProtos.GetSchemasResp) obj;

      if (hasStatus() != other.hasStatus()) return false;
      if (hasStatus()) {
        if (status_ != other.status_) return false;
      }
      if (!getSchemasList()
          .equals(other.getSchemasList())) return false;
      if (hasError() != other.hasError()) return false;
      if (hasError()) {
        if (!getError()
            .equals(other.getError())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasStatus()) {
        hash = (37 * hash) + STATUS_FIELD_NUMBER;
        hash = (53 * hash) + status_;
      }
      if (getSchemasCount() > 0) {
        hash = (37 * hash) + SCHEMAS_FIELD_NUMBER;
        hash = (53 * hash) + getSchemasList().hashCode();
      }
      if (hasError()) {
        hash = (37 * hash) + ERROR_FIELD_NUMBER;
        hash = (53 * hash) + getError().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.drill.exec.proto.UserProtos.GetSchemasResp parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetSchemasResp parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetSchemasResp parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetSchemasResp parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetSchemasResp parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetSchemasResp parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetSchemasResp parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetSchemasResp parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetSchemasResp parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetSchemasResp parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetSchemasResp parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetSchemasResp parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.drill.exec.proto.UserProtos.GetSchemasResp prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Response message for GetSchemasReq.
     * </pre>
     *
     * Protobuf type {@code exec.user.GetSchemasResp}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:exec.user.GetSchemasResp)
        org.apache.drill.exec.proto.UserProtos.GetSchemasRespOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetSchemasResp_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetSchemasResp_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.UserProtos.GetSchemasResp.class, org.apache.drill.exec.proto.UserProtos.GetSchemasResp.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.UserProtos.GetSchemasResp.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getSchemasFieldBuilder();
          getErrorFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        status_ = 0;
        bitField0_ = (bitField0_ & ~0x00000001);
        if (schemasBuilder_ == null) {
          schemas_ = java.util.Collections.emptyList();
        } else {
          schemas_ = null;
          schemasBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        if (errorBuilder_ == null) {
          error_ = null;
        } else {
          errorBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetSchemasResp_descriptor;
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.GetSchemasResp getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.UserProtos.GetSchemasResp.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.GetSchemasResp build() {
        org.apache.drill.exec.proto.UserProtos.GetSchemasResp result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.GetSchemasResp buildPartial() {
        org.apache.drill.exec.proto.UserProtos.GetSchemasResp result = new org.apache.drill.exec.proto.UserProtos.GetSchemasResp(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          to_bitField0_ |= 0x00000001;
        }
        result.status_ = status_;
        if (schemasBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            schemas_ = java.util.Collections.unmodifiableList(schemas_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.schemas_ = schemas_;
        } else {
          result.schemas_ = schemasBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          if (errorBuilder_ == null) {
            result.error_ = error_;
          } else {
            result.error_ = errorBuilder_.build();
          }
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.UserProtos.GetSchemasResp) {
          return mergeFrom((org.apache.drill.exec.proto.UserProtos.GetSchemasResp)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.UserProtos.GetSchemasResp other) {
        if (other == org.apache.drill.exec.proto.UserProtos.GetSchemasResp.getDefaultInstance()) return this;
        if (other.hasStatus()) {
          setStatus(other.getStatus());
        }
        if (schemasBuilder_ == null) {
          if (!other.schemas_.isEmpty()) {
            if (schemas_.isEmpty()) {
              schemas_ = other.schemas_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureSchemasIsMutable();
              schemas_.addAll(other.schemas_);
            }
            onChanged();
          }
        } else {
          if (!other.schemas_.isEmpty()) {
            if (schemasBuilder_.isEmpty()) {
              schemasBuilder_.dispose();
              schemasBuilder_ = null;
              schemas_ = other.schemas_;
              bitField0_ = (bitField0_ & ~0x00000002);
              schemasBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getSchemasFieldBuilder() : null;
            } else {
              schemasBuilder_.addAllMessages(other.schemas_);
            }
          }
        }
        if (other.hasError()) {
          mergeError(other.getError());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8: {
                int tmpRaw = input.readEnum();
                org.apache.drill.exec.proto.UserProtos.RequestStatus tmpValue =
                    org.apache.drill.exec.proto.UserProtos.RequestStatus.forNumber(tmpRaw);
                if (tmpValue == null) {
                  mergeUnknownVarintField(1, tmpRaw);
                } else {
                  status_ = tmpRaw;
                  bitField0_ |= 0x00000001;
                }
                break;
              } // case 8
              case 18: {
                org.apache.drill.exec.proto.UserProtos.SchemaMetadata m =
                    input.readMessage(
                        org.apache.drill.exec.proto.UserProtos.SchemaMetadata.PARSER,
                        extensionRegistry);
                if (schemasBuilder_ == null) {
                  ensureSchemasIsMutable();
                  schemas_.add(m);
                } else {
                  schemasBuilder_.addMessage(m);
                }
                break;
              } // case 18
              case 26: {
                input.readMessage(
                    getErrorFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private int status_ = 0;
      /**
       * <code>optional .exec.user.RequestStatus status = 1;</code>
       * @return Whether the status field is set.
       */
      @java.lang.Override public boolean hasStatus() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>optional .exec.user.RequestStatus status = 1;</code>
       * @return The status.
       */
      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.RequestStatus getStatus() {
        @SuppressWarnings("deprecation")
        org.apache.drill.exec.proto.UserProtos.RequestStatus result = org.apache.drill.exec.proto.UserProtos.RequestStatus.valueOf(status_);
        return result == null ? org.apache.drill.exec.proto.UserProtos.RequestStatus.UNKNOWN_STATUS : result;
      }
      /**
       * <code>optional .exec.user.RequestStatus status = 1;</code>
       * @param value The status to set.
       * @return This builder for chaining.
       */
      public Builder setStatus(org.apache.drill.exec.proto.UserProtos.RequestStatus value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        status_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <code>optional .exec.user.RequestStatus status = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearStatus() {
        bitField0_ = (bitField0_ & ~0x00000001);
        status_ = 0;
        onChanged();
        return this;
      }

      private java.util.List<org.apache.drill.exec.proto.UserProtos.SchemaMetadata> schemas_ =
        java.util.Collections.emptyList();
      private void ensureSchemasIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          schemas_ = new java.util.ArrayList<org.apache.drill.exec.proto.UserProtos.SchemaMetadata>(schemas_);
          bitField0_ |= 0x00000002;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          org.apache.drill.exec.proto.UserProtos.SchemaMetadata, org.apache.drill.exec.proto.UserProtos.SchemaMetadata.Builder, org.apache.drill.exec.proto.UserProtos.SchemaMetadataOrBuilder> schemasBuilder_;

      /**
       * <code>repeated .exec.user.SchemaMetadata schemas = 2;</code>
       */
      public java.util.List<org.apache.drill.exec.proto.UserProtos.SchemaMetadata> getSchemasList() {
        if (schemasBuilder_ == null) {
          return java.util.Collections.unmodifiableList(schemas_);
        } else {
          return schemasBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .exec.user.SchemaMetadata schemas = 2;</code>
       */
      public int getSchemasCount() {
        if (schemasBuilder_ == null) {
          return schemas_.size();
        } else {
          return schemasBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .exec.user.SchemaMetadata schemas = 2;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.SchemaMetadata getSchemas(int index) {
        if (schemasBuilder_ == null) {
          return schemas_.get(index);
        } else {
          return schemasBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .exec.user.SchemaMetadata schemas = 2;</code>
       */
      public Builder setSchemas(
          int index, org.apache.drill.exec.proto.UserProtos.SchemaMetadata value) {
        if (schemasBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSchemasIsMutable();
          schemas_.set(index, value);
          onChanged();
        } else {
          schemasBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.SchemaMetadata schemas = 2;</code>
       */
      public Builder setSchemas(
          int index, org.apache.drill.exec.proto.UserProtos.SchemaMetadata.Builder builderForValue) {
        if (schemasBuilder_ == null) {
          ensureSchemasIsMutable();
          schemas_.set(index, builderForValue.build());
          onChanged();
        } else {
          schemasBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.SchemaMetadata schemas = 2;</code>
       */
      public Builder addSchemas(org.apache.drill.exec.proto.UserProtos.SchemaMetadata value) {
        if (schemasBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSchemasIsMutable();
          schemas_.add(value);
          onChanged();
        } else {
          schemasBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.SchemaMetadata schemas = 2;</code>
       */
      public Builder addSchemas(
          int index, org.apache.drill.exec.proto.UserProtos.SchemaMetadata value) {
        if (schemasBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSchemasIsMutable();
          schemas_.add(index, value);
          onChanged();
        } else {
          schemasBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.SchemaMetadata schemas = 2;</code>
       */
      public Builder addSchemas(
          org.apache.drill.exec.proto.UserProtos.SchemaMetadata.Builder builderForValue) {
        if (schemasBuilder_ == null) {
          ensureSchemasIsMutable();
          schemas_.add(builderForValue.build());
          onChanged();
        } else {
          schemasBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.SchemaMetadata schemas = 2;</code>
       */
      public Builder addSchemas(
          int index, org.apache.drill.exec.proto.UserProtos.SchemaMetadata.Builder builderForValue) {
        if (schemasBuilder_ == null) {
          ensureSchemasIsMutable();
          schemas_.add(index, builderForValue.build());
          onChanged();
        } else {
          schemasBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.SchemaMetadata schemas = 2;</code>
       */
      public Builder addAllSchemas(
          java.lang.Iterable<? extends org.apache.drill.exec.proto.UserProtos.SchemaMetadata> values) {
        if (schemasBuilder_ == null) {
          ensureSchemasIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, schemas_);
          onChanged();
        } else {
          schemasBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.SchemaMetadata schemas = 2;</code>
       */
      public Builder clearSchemas() {
        if (schemasBuilder_ == null) {
          schemas_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          schemasBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.SchemaMetadata schemas = 2;</code>
       */
      public Builder removeSchemas(int index) {
        if (schemasBuilder_ == null) {
          ensureSchemasIsMutable();
          schemas_.remove(index);
          onChanged();
        } else {
          schemasBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.SchemaMetadata schemas = 2;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.SchemaMetadata.Builder getSchemasBuilder(
          int index) {
        return getSchemasFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .exec.user.SchemaMetadata schemas = 2;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.SchemaMetadataOrBuilder getSchemasOrBuilder(
          int index) {
        if (schemasBuilder_ == null) {
          return schemas_.get(index);  } else {
          return schemasBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .exec.user.SchemaMetadata schemas = 2;</code>
       */
      public java.util.List<? extends org.apache.drill.exec.proto.UserProtos.SchemaMetadataOrBuilder> 
           getSchemasOrBuilderList() {
        if (schemasBuilder_ != null) {
          return schemasBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(schemas_);
        }
      }
      /**
       * <code>repeated .exec.user.SchemaMetadata schemas = 2;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.SchemaMetadata.Builder addSchemasBuilder() {
        return getSchemasFieldBuilder().addBuilder(
            org.apache.drill.exec.proto.UserProtos.SchemaMetadata.getDefaultInstance());
      }
      /**
       * <code>repeated .exec.user.SchemaMetadata schemas = 2;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.SchemaMetadata.Builder addSchemasBuilder(
          int index) {
        return getSchemasFieldBuilder().addBuilder(
            index, org.apache.drill.exec.proto.UserProtos.SchemaMetadata.getDefaultInstance());
      }
      /**
       * <code>repeated .exec.user.SchemaMetadata schemas = 2;</code>
       */
      public java.util.List<org.apache.drill.exec.proto.UserProtos.SchemaMetadata.Builder> 
           getSchemasBuilderList() {
        return getSchemasFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          org.apache.drill.exec.proto.UserProtos.SchemaMetadata, org.apache.drill.exec.proto.UserProtos.SchemaMetadata.Builder, org.apache.drill.exec.proto.UserProtos.SchemaMetadataOrBuilder> 
          getSchemasFieldBuilder() {
        if (schemasBuilder_ == null) {
          schemasBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              org.apache.drill.exec.proto.UserProtos.SchemaMetadata, org.apache.drill.exec.proto.UserProtos.SchemaMetadata.Builder, org.apache.drill.exec.proto.UserProtos.SchemaMetadataOrBuilder>(
                  schemas_,
                  ((bitField0_ & 0x00000002) != 0),
                  getParentForChildren(),
                  isClean());
          schemas_ = null;
        }
        return schemasBuilder_;
      }

      private org.apache.drill.exec.proto.UserBitShared.DrillPBError error_;
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.drill.exec.proto.UserBitShared.DrillPBError, org.apache.drill.exec.proto.UserBitShared.DrillPBError.Builder, org.apache.drill.exec.proto.UserBitShared.DrillPBErrorOrBuilder> errorBuilder_;
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       * @return Whether the error field is set.
       */
      public boolean hasError() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       * @return The error.
       */
      public org.apache.drill.exec.proto.UserBitShared.DrillPBError getError() {
        if (errorBuilder_ == null) {
          return error_ == null ? org.apache.drill.exec.proto.UserBitShared.DrillPBError.getDefaultInstance() : error_;
        } else {
          return errorBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       */
      public Builder setError(org.apache.drill.exec.proto.UserBitShared.DrillPBError value) {
        if (errorBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          error_ = value;
          onChanged();
        } else {
          errorBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       */
      public Builder setError(
          org.apache.drill.exec.proto.UserBitShared.DrillPBError.Builder builderForValue) {
        if (errorBuilder_ == null) {
          error_ = builderForValue.build();
          onChanged();
        } else {
          errorBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       */
      public Builder mergeError(org.apache.drill.exec.proto.UserBitShared.DrillPBError value) {
        if (errorBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0) &&
              error_ != null &&
              error_ != org.apache.drill.exec.proto.UserBitShared.DrillPBError.getDefaultInstance()) {
            error_ =
              org.apache.drill.exec.proto.UserBitShared.DrillPBError.newBuilder(error_).mergeFrom(value).buildPartial();
          } else {
            error_ = value;
          }
          onChanged();
        } else {
          errorBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       */
      public Builder clearError() {
        if (errorBuilder_ == null) {
          error_ = null;
          onChanged();
        } else {
          errorBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.DrillPBError.Builder getErrorBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getErrorFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.DrillPBErrorOrBuilder getErrorOrBuilder() {
        if (errorBuilder_ != null) {
          return errorBuilder_.getMessageOrBuilder();
        } else {
          return error_ == null ?
              org.apache.drill.exec.proto.UserBitShared.DrillPBError.getDefaultInstance() : error_;
        }
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.drill.exec.proto.UserBitShared.DrillPBError, org.apache.drill.exec.proto.UserBitShared.DrillPBError.Builder, org.apache.drill.exec.proto.UserBitShared.DrillPBErrorOrBuilder> 
          getErrorFieldBuilder() {
        if (errorBuilder_ == null) {
          errorBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.apache.drill.exec.proto.UserBitShared.DrillPBError, org.apache.drill.exec.proto.UserBitShared.DrillPBError.Builder, org.apache.drill.exec.proto.UserBitShared.DrillPBErrorOrBuilder>(
                  getError(),
                  getParentForChildren(),
                  isClean());
          error_ = null;
        }
        return errorBuilder_;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:exec.user.GetSchemasResp)
    }

    // @@protoc_insertion_point(class_scope:exec.user.GetSchemasResp)
    private static final org.apache.drill.exec.proto.UserProtos.GetSchemasResp DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.drill.exec.proto.UserProtos.GetSchemasResp();
    }

    public static org.apache.drill.exec.proto.UserProtos.GetSchemasResp getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final com.google.protobuf.Parser<GetSchemasResp>
        PARSER = new com.google.protobuf.AbstractParser<GetSchemasResp>() {
      @java.lang.Override
      public GetSchemasResp parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<GetSchemasResp> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GetSchemasResp> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.drill.exec.proto.UserProtos.GetSchemasResp getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface GetTablesReqOrBuilder extends
      // @@protoc_insertion_point(interface_extends:exec.user.GetTablesReq)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
     * @return Whether the catalogNameFilter field is set.
     */
    boolean hasCatalogNameFilter();
    /**
     * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
     * @return The catalogNameFilter.
     */
    org.apache.drill.exec.proto.UserProtos.LikeFilter getCatalogNameFilter();
    /**
     * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
     */
    org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder getCatalogNameFilterOrBuilder();

    /**
     * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
     * @return Whether the schemaNameFilter field is set.
     */
    boolean hasSchemaNameFilter();
    /**
     * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
     * @return The schemaNameFilter.
     */
    org.apache.drill.exec.proto.UserProtos.LikeFilter getSchemaNameFilter();
    /**
     * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
     */
    org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder getSchemaNameFilterOrBuilder();

    /**
     * <code>optional .exec.user.LikeFilter table_name_filter = 3;</code>
     * @return Whether the tableNameFilter field is set.
     */
    boolean hasTableNameFilter();
    /**
     * <code>optional .exec.user.LikeFilter table_name_filter = 3;</code>
     * @return The tableNameFilter.
     */
    org.apache.drill.exec.proto.UserProtos.LikeFilter getTableNameFilter();
    /**
     * <code>optional .exec.user.LikeFilter table_name_filter = 3;</code>
     */
    org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder getTableNameFilterOrBuilder();

    /**
     * <code>repeated string table_type_filter = 4;</code>
     * @return A list containing the tableTypeFilter.
     */
    java.util.List<java.lang.String>
        getTableTypeFilterList();
    /**
     * <code>repeated string table_type_filter = 4;</code>
     * @return The count of tableTypeFilter.
     */
    int getTableTypeFilterCount();
    /**
     * <code>repeated string table_type_filter = 4;</code>
     * @param index The index of the element to return.
     * @return The tableTypeFilter at the given index.
     */
    java.lang.String getTableTypeFilter(int index);
    /**
     * <code>repeated string table_type_filter = 4;</code>
     * @param index The index of the value to return.
     * @return The bytes of the tableTypeFilter at the given index.
     */
    com.google.protobuf.ByteString
        getTableTypeFilterBytes(int index);
  }
  /**
   * <pre>
   * Request message for getting the metadata for tables satisfying the given optional filters.
   * </pre>
   *
   * Protobuf type {@code exec.user.GetTablesReq}
   */
  public static final class GetTablesReq extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:exec.user.GetTablesReq)
      GetTablesReqOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use GetTablesReq.newBuilder() to construct.
    private GetTablesReq(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private GetTablesReq() {
      tableTypeFilter_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new GetTablesReq();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetTablesReq_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetTablesReq_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.UserProtos.GetTablesReq.class, org.apache.drill.exec.proto.UserProtos.GetTablesReq.Builder.class);
    }

    private int bitField0_;
    public static final int CATALOG_NAME_FILTER_FIELD_NUMBER = 1;
    private org.apache.drill.exec.proto.UserProtos.LikeFilter catalogNameFilter_;
    /**
     * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
     * @return Whether the catalogNameFilter field is set.
     */
    @java.lang.Override
    public boolean hasCatalogNameFilter() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
     * @return The catalogNameFilter.
     */
    @java.lang.Override
    public org.apache.drill.exec.proto.UserProtos.LikeFilter getCatalogNameFilter() {
      return catalogNameFilter_ == null ? org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance() : catalogNameFilter_;
    }
    /**
     * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
     */
    @java.lang.Override
    public org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder getCatalogNameFilterOrBuilder() {
      return catalogNameFilter_ == null ? org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance() : catalogNameFilter_;
    }

    public static final int SCHEMA_NAME_FILTER_FIELD_NUMBER = 2;
    private org.apache.drill.exec.proto.UserProtos.LikeFilter schemaNameFilter_;
    /**
     * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
     * @return Whether the schemaNameFilter field is set.
     */
    @java.lang.Override
    public boolean hasSchemaNameFilter() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
     * @return The schemaNameFilter.
     */
    @java.lang.Override
    public org.apache.drill.exec.proto.UserProtos.LikeFilter getSchemaNameFilter() {
      return schemaNameFilter_ == null ? org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance() : schemaNameFilter_;
    }
    /**
     * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
     */
    @java.lang.Override
    public org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder getSchemaNameFilterOrBuilder() {
      return schemaNameFilter_ == null ? org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance() : schemaNameFilter_;
    }

    public static final int TABLE_NAME_FILTER_FIELD_NUMBER = 3;
    private org.apache.drill.exec.proto.UserProtos.LikeFilter tableNameFilter_;
    /**
     * <code>optional .exec.user.LikeFilter table_name_filter = 3;</code>
     * @return Whether the tableNameFilter field is set.
     */
    @java.lang.Override
    public boolean hasTableNameFilter() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <code>optional .exec.user.LikeFilter table_name_filter = 3;</code>
     * @return The tableNameFilter.
     */
    @java.lang.Override
    public org.apache.drill.exec.proto.UserProtos.LikeFilter getTableNameFilter() {
      return tableNameFilter_ == null ? org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance() : tableNameFilter_;
    }
    /**
     * <code>optional .exec.user.LikeFilter table_name_filter = 3;</code>
     */
    @java.lang.Override
    public org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder getTableNameFilterOrBuilder() {
      return tableNameFilter_ == null ? org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance() : tableNameFilter_;
    }

    public static final int TABLE_TYPE_FILTER_FIELD_NUMBER = 4;
    private com.google.protobuf.LazyStringList tableTypeFilter_;
    /**
     * <code>repeated string table_type_filter = 4;</code>
     * @return A list containing the tableTypeFilter.
     */
    public com.google.protobuf.ProtocolStringList
        getTableTypeFilterList() {
      return tableTypeFilter_;
    }
    /**
     * <code>repeated string table_type_filter = 4;</code>
     * @return The count of tableTypeFilter.
     */
    public int getTableTypeFilterCount() {
      return tableTypeFilter_.size();
    }
    /**
     * <code>repeated string table_type_filter = 4;</code>
     * @param index The index of the element to return.
     * @return The tableTypeFilter at the given index.
     */
    public java.lang.String getTableTypeFilter(int index) {
      return tableTypeFilter_.get(index);
    }
    /**
     * <code>repeated string table_type_filter = 4;</code>
     * @param index The index of the value to return.
     * @return The bytes of the tableTypeFilter at the given index.
     */
    public com.google.protobuf.ByteString
        getTableTypeFilterBytes(int index) {
      return tableTypeFilter_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getCatalogNameFilter());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(2, getSchemaNameFilter());
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeMessage(3, getTableNameFilter());
      }
      for (int i = 0; i < tableTypeFilter_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, tableTypeFilter_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, getCatalogNameFilter());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, getSchemaNameFilter());
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, getTableNameFilter());
      }
      {
        int dataSize = 0;
        for (int i = 0; i < tableTypeFilter_.size(); i++) {
          dataSize += computeStringSizeNoTag(tableTypeFilter_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getTableTypeFilterList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.drill.exec.proto.UserProtos.GetTablesReq)) {
        return super.equals(obj);
      }
      org.apache.drill.exec.proto.UserProtos.GetTablesReq other = (org.apache.drill.exec.proto.UserProtos.GetTablesReq) obj;

      if (hasCatalogNameFilter() != other.hasCatalogNameFilter()) return false;
      if (hasCatalogNameFilter()) {
        if (!getCatalogNameFilter()
            .equals(other.getCatalogNameFilter())) return false;
      }
      if (hasSchemaNameFilter() != other.hasSchemaNameFilter()) return false;
      if (hasSchemaNameFilter()) {
        if (!getSchemaNameFilter()
            .equals(other.getSchemaNameFilter())) return false;
      }
      if (hasTableNameFilter() != other.hasTableNameFilter()) return false;
      if (hasTableNameFilter()) {
        if (!getTableNameFilter()
            .equals(other.getTableNameFilter())) return false;
      }
      if (!getTableTypeFilterList()
          .equals(other.getTableTypeFilterList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasCatalogNameFilter()) {
        hash = (37 * hash) + CATALOG_NAME_FILTER_FIELD_NUMBER;
        hash = (53 * hash) + getCatalogNameFilter().hashCode();
      }
      if (hasSchemaNameFilter()) {
        hash = (37 * hash) + SCHEMA_NAME_FILTER_FIELD_NUMBER;
        hash = (53 * hash) + getSchemaNameFilter().hashCode();
      }
      if (hasTableNameFilter()) {
        hash = (37 * hash) + TABLE_NAME_FILTER_FIELD_NUMBER;
        hash = (53 * hash) + getTableNameFilter().hashCode();
      }
      if (getTableTypeFilterCount() > 0) {
        hash = (37 * hash) + TABLE_TYPE_FILTER_FIELD_NUMBER;
        hash = (53 * hash) + getTableTypeFilterList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.drill.exec.proto.UserProtos.GetTablesReq parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetTablesReq parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetTablesReq parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetTablesReq parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetTablesReq parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetTablesReq parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetTablesReq parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetTablesReq parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetTablesReq parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetTablesReq parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetTablesReq parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetTablesReq parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.drill.exec.proto.UserProtos.GetTablesReq prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Request message for getting the metadata for tables satisfying the given optional filters.
     * </pre>
     *
     * Protobuf type {@code exec.user.GetTablesReq}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:exec.user.GetTablesReq)
        org.apache.drill.exec.proto.UserProtos.GetTablesReqOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetTablesReq_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetTablesReq_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.UserProtos.GetTablesReq.class, org.apache.drill.exec.proto.UserProtos.GetTablesReq.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.UserProtos.GetTablesReq.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getCatalogNameFilterFieldBuilder();
          getSchemaNameFilterFieldBuilder();
          getTableNameFilterFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (catalogNameFilterBuilder_ == null) {
          catalogNameFilter_ = null;
        } else {
          catalogNameFilterBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        if (schemaNameFilterBuilder_ == null) {
          schemaNameFilter_ = null;
        } else {
          schemaNameFilterBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        if (tableNameFilterBuilder_ == null) {
          tableNameFilter_ = null;
        } else {
          tableNameFilterBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        tableTypeFilter_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000008);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetTablesReq_descriptor;
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.GetTablesReq getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.UserProtos.GetTablesReq.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.GetTablesReq build() {
        org.apache.drill.exec.proto.UserProtos.GetTablesReq result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.GetTablesReq buildPartial() {
        org.apache.drill.exec.proto.UserProtos.GetTablesReq result = new org.apache.drill.exec.proto.UserProtos.GetTablesReq(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          if (catalogNameFilterBuilder_ == null) {
            result.catalogNameFilter_ = catalogNameFilter_;
          } else {
            result.catalogNameFilter_ = catalogNameFilterBuilder_.build();
          }
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          if (schemaNameFilterBuilder_ == null) {
            result.schemaNameFilter_ = schemaNameFilter_;
          } else {
            result.schemaNameFilter_ = schemaNameFilterBuilder_.build();
          }
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          if (tableNameFilterBuilder_ == null) {
            result.tableNameFilter_ = tableNameFilter_;
          } else {
            result.tableNameFilter_ = tableNameFilterBuilder_.build();
          }
          to_bitField0_ |= 0x00000004;
        }
        if (((bitField0_ & 0x00000008) != 0)) {
          tableTypeFilter_ = tableTypeFilter_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.tableTypeFilter_ = tableTypeFilter_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.UserProtos.GetTablesReq) {
          return mergeFrom((org.apache.drill.exec.proto.UserProtos.GetTablesReq)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.UserProtos.GetTablesReq other) {
        if (other == org.apache.drill.exec.proto.UserProtos.GetTablesReq.getDefaultInstance()) return this;
        if (other.hasCatalogNameFilter()) {
          mergeCatalogNameFilter(other.getCatalogNameFilter());
        }
        if (other.hasSchemaNameFilter()) {
          mergeSchemaNameFilter(other.getSchemaNameFilter());
        }
        if (other.hasTableNameFilter()) {
          mergeTableNameFilter(other.getTableNameFilter());
        }
        if (!other.tableTypeFilter_.isEmpty()) {
          if (tableTypeFilter_.isEmpty()) {
            tableTypeFilter_ = other.tableTypeFilter_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureTableTypeFilterIsMutable();
            tableTypeFilter_.addAll(other.tableTypeFilter_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                input.readMessage(
                    getCatalogNameFilterFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
              case 18: {
                input.readMessage(
                    getSchemaNameFilterFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
              case 26: {
                input.readMessage(
                    getTableNameFilterFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
              case 34: {
                com.google.protobuf.ByteString bs = input.readBytes();
                ensureTableTypeFilterIsMutable();
                tableTypeFilter_.add(bs);
                break;
              } // case 34
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private org.apache.drill.exec.proto.UserProtos.LikeFilter catalogNameFilter_;
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.drill.exec.proto.UserProtos.LikeFilter, org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder, org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder> catalogNameFilterBuilder_;
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       * @return Whether the catalogNameFilter field is set.
       */
      public boolean hasCatalogNameFilter() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       * @return The catalogNameFilter.
       */
      public org.apache.drill.exec.proto.UserProtos.LikeFilter getCatalogNameFilter() {
        if (catalogNameFilterBuilder_ == null) {
          return catalogNameFilter_ == null ? org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance() : catalogNameFilter_;
        } else {
          return catalogNameFilterBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       */
      public Builder setCatalogNameFilter(org.apache.drill.exec.proto.UserProtos.LikeFilter value) {
        if (catalogNameFilterBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          catalogNameFilter_ = value;
          onChanged();
        } else {
          catalogNameFilterBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       */
      public Builder setCatalogNameFilter(
          org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder builderForValue) {
        if (catalogNameFilterBuilder_ == null) {
          catalogNameFilter_ = builderForValue.build();
          onChanged();
        } else {
          catalogNameFilterBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       */
      public Builder mergeCatalogNameFilter(org.apache.drill.exec.proto.UserProtos.LikeFilter value) {
        if (catalogNameFilterBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0) &&
              catalogNameFilter_ != null &&
              catalogNameFilter_ != org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance()) {
            catalogNameFilter_ =
              org.apache.drill.exec.proto.UserProtos.LikeFilter.newBuilder(catalogNameFilter_).mergeFrom(value).buildPartial();
          } else {
            catalogNameFilter_ = value;
          }
          onChanged();
        } else {
          catalogNameFilterBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       */
      public Builder clearCatalogNameFilter() {
        if (catalogNameFilterBuilder_ == null) {
          catalogNameFilter_ = null;
          onChanged();
        } else {
          catalogNameFilterBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder getCatalogNameFilterBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getCatalogNameFilterFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder getCatalogNameFilterOrBuilder() {
        if (catalogNameFilterBuilder_ != null) {
          return catalogNameFilterBuilder_.getMessageOrBuilder();
        } else {
          return catalogNameFilter_ == null ?
              org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance() : catalogNameFilter_;
        }
      }
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.drill.exec.proto.UserProtos.LikeFilter, org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder, org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder> 
          getCatalogNameFilterFieldBuilder() {
        if (catalogNameFilterBuilder_ == null) {
          catalogNameFilterBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.apache.drill.exec.proto.UserProtos.LikeFilter, org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder, org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder>(
                  getCatalogNameFilter(),
                  getParentForChildren(),
                  isClean());
          catalogNameFilter_ = null;
        }
        return catalogNameFilterBuilder_;
      }

      private org.apache.drill.exec.proto.UserProtos.LikeFilter schemaNameFilter_;
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.drill.exec.proto.UserProtos.LikeFilter, org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder, org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder> schemaNameFilterBuilder_;
      /**
       * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
       * @return Whether the schemaNameFilter field is set.
       */
      public boolean hasSchemaNameFilter() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
       * @return The schemaNameFilter.
       */
      public org.apache.drill.exec.proto.UserProtos.LikeFilter getSchemaNameFilter() {
        if (schemaNameFilterBuilder_ == null) {
          return schemaNameFilter_ == null ? org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance() : schemaNameFilter_;
        } else {
          return schemaNameFilterBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
       */
      public Builder setSchemaNameFilter(org.apache.drill.exec.proto.UserProtos.LikeFilter value) {
        if (schemaNameFilterBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          schemaNameFilter_ = value;
          onChanged();
        } else {
          schemaNameFilterBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
       */
      public Builder setSchemaNameFilter(
          org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder builderForValue) {
        if (schemaNameFilterBuilder_ == null) {
          schemaNameFilter_ = builderForValue.build();
          onChanged();
        } else {
          schemaNameFilterBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
       */
      public Builder mergeSchemaNameFilter(org.apache.drill.exec.proto.UserProtos.LikeFilter value) {
        if (schemaNameFilterBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0) &&
              schemaNameFilter_ != null &&
              schemaNameFilter_ != org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance()) {
            schemaNameFilter_ =
              org.apache.drill.exec.proto.UserProtos.LikeFilter.newBuilder(schemaNameFilter_).mergeFrom(value).buildPartial();
          } else {
            schemaNameFilter_ = value;
          }
          onChanged();
        } else {
          schemaNameFilterBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
       */
      public Builder clearSchemaNameFilter() {
        if (schemaNameFilterBuilder_ == null) {
          schemaNameFilter_ = null;
          onChanged();
        } else {
          schemaNameFilterBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder getSchemaNameFilterBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getSchemaNameFilterFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder getSchemaNameFilterOrBuilder() {
        if (schemaNameFilterBuilder_ != null) {
          return schemaNameFilterBuilder_.getMessageOrBuilder();
        } else {
          return schemaNameFilter_ == null ?
              org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance() : schemaNameFilter_;
        }
      }
      /**
       * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.drill.exec.proto.UserProtos.LikeFilter, org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder, org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder> 
          getSchemaNameFilterFieldBuilder() {
        if (schemaNameFilterBuilder_ == null) {
          schemaNameFilterBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.apache.drill.exec.proto.UserProtos.LikeFilter, org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder, org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder>(
                  getSchemaNameFilter(),
                  getParentForChildren(),
                  isClean());
          schemaNameFilter_ = null;
        }
        return schemaNameFilterBuilder_;
      }

      private org.apache.drill.exec.proto.UserProtos.LikeFilter tableNameFilter_;
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.drill.exec.proto.UserProtos.LikeFilter, org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder, org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder> tableNameFilterBuilder_;
      /**
       * <code>optional .exec.user.LikeFilter table_name_filter = 3;</code>
       * @return Whether the tableNameFilter field is set.
       */
      public boolean hasTableNameFilter() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <code>optional .exec.user.LikeFilter table_name_filter = 3;</code>
       * @return The tableNameFilter.
       */
      public org.apache.drill.exec.proto.UserProtos.LikeFilter getTableNameFilter() {
        if (tableNameFilterBuilder_ == null) {
          return tableNameFilter_ == null ? org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance() : tableNameFilter_;
        } else {
          return tableNameFilterBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .exec.user.LikeFilter table_name_filter = 3;</code>
       */
      public Builder setTableNameFilter(org.apache.drill.exec.proto.UserProtos.LikeFilter value) {
        if (tableNameFilterBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          tableNameFilter_ = value;
          onChanged();
        } else {
          tableNameFilterBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter table_name_filter = 3;</code>
       */
      public Builder setTableNameFilter(
          org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder builderForValue) {
        if (tableNameFilterBuilder_ == null) {
          tableNameFilter_ = builderForValue.build();
          onChanged();
        } else {
          tableNameFilterBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter table_name_filter = 3;</code>
       */
      public Builder mergeTableNameFilter(org.apache.drill.exec.proto.UserProtos.LikeFilter value) {
        if (tableNameFilterBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0) &&
              tableNameFilter_ != null &&
              tableNameFilter_ != org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance()) {
            tableNameFilter_ =
              org.apache.drill.exec.proto.UserProtos.LikeFilter.newBuilder(tableNameFilter_).mergeFrom(value).buildPartial();
          } else {
            tableNameFilter_ = value;
          }
          onChanged();
        } else {
          tableNameFilterBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter table_name_filter = 3;</code>
       */
      public Builder clearTableNameFilter() {
        if (tableNameFilterBuilder_ == null) {
          tableNameFilter_ = null;
          onChanged();
        } else {
          tableNameFilterBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter table_name_filter = 3;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder getTableNameFilterBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getTableNameFilterFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .exec.user.LikeFilter table_name_filter = 3;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder getTableNameFilterOrBuilder() {
        if (tableNameFilterBuilder_ != null) {
          return tableNameFilterBuilder_.getMessageOrBuilder();
        } else {
          return tableNameFilter_ == null ?
              org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance() : tableNameFilter_;
        }
      }
      /**
       * <code>optional .exec.user.LikeFilter table_name_filter = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.drill.exec.proto.UserProtos.LikeFilter, org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder, org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder> 
          getTableNameFilterFieldBuilder() {
        if (tableNameFilterBuilder_ == null) {
          tableNameFilterBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.apache.drill.exec.proto.UserProtos.LikeFilter, org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder, org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder>(
                  getTableNameFilter(),
                  getParentForChildren(),
                  isClean());
          tableNameFilter_ = null;
        }
        return tableNameFilterBuilder_;
      }

      private com.google.protobuf.LazyStringList tableTypeFilter_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      private void ensureTableTypeFilterIsMutable() {
        if (!((bitField0_ & 0x00000008) != 0)) {
          tableTypeFilter_ = new com.google.protobuf.LazyStringArrayList(tableTypeFilter_);
          bitField0_ |= 0x00000008;
         }
      }
      /**
       * <code>repeated string table_type_filter = 4;</code>
       * @return A list containing the tableTypeFilter.
       */
      public com.google.protobuf.ProtocolStringList
          getTableTypeFilterList() {
        return tableTypeFilter_.getUnmodifiableView();
      }
      /**
       * <code>repeated string table_type_filter = 4;</code>
       * @return The count of tableTypeFilter.
       */
      public int getTableTypeFilterCount() {
        return tableTypeFilter_.size();
      }
      /**
       * <code>repeated string table_type_filter = 4;</code>
       * @param index The index of the element to return.
       * @return The tableTypeFilter at the given index.
       */
      public java.lang.String getTableTypeFilter(int index) {
        return tableTypeFilter_.get(index);
      }
      /**
       * <code>repeated string table_type_filter = 4;</code>
       * @param index The index of the value to return.
       * @return The bytes of the tableTypeFilter at the given index.
       */
      public com.google.protobuf.ByteString
          getTableTypeFilterBytes(int index) {
        return tableTypeFilter_.getByteString(index);
      }
      /**
       * <code>repeated string table_type_filter = 4;</code>
       * @param index The index to set the value at.
       * @param value The tableTypeFilter to set.
       * @return This builder for chaining.
       */
      public Builder setTableTypeFilter(
          int index, java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureTableTypeFilterIsMutable();
        tableTypeFilter_.set(index, value);
        onChanged();
        return this;
      }
      /**
       * <code>repeated string table_type_filter = 4;</code>
       * @param value The tableTypeFilter to add.
       * @return This builder for chaining.
       */
      public Builder addTableTypeFilter(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureTableTypeFilterIsMutable();
        tableTypeFilter_.add(value);
        onChanged();
        return this;
      }
      /**
       * <code>repeated string table_type_filter = 4;</code>
       * @param values The tableTypeFilter to add.
       * @return This builder for chaining.
       */
      public Builder addAllTableTypeFilter(
          java.lang.Iterable<java.lang.String> values) {
        ensureTableTypeFilterIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, tableTypeFilter_);
        onChanged();
        return this;
      }
      /**
       * <code>repeated string table_type_filter = 4;</code>
       * @return This builder for chaining.
       */
      public Builder clearTableTypeFilter() {
        tableTypeFilter_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }
      /**
       * <code>repeated string table_type_filter = 4;</code>
       * @param value The bytes of the tableTypeFilter to add.
       * @return This builder for chaining.
       */
      public Builder addTableTypeFilterBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureTableTypeFilterIsMutable();
        tableTypeFilter_.add(value);
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:exec.user.GetTablesReq)
    }

    // @@protoc_insertion_point(class_scope:exec.user.GetTablesReq)
    private static final org.apache.drill.exec.proto.UserProtos.GetTablesReq DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.drill.exec.proto.UserProtos.GetTablesReq();
    }

    public static org.apache.drill.exec.proto.UserProtos.GetTablesReq getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final com.google.protobuf.Parser<GetTablesReq>
        PARSER = new com.google.protobuf.AbstractParser<GetTablesReq>() {
      @java.lang.Override
      public GetTablesReq parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<GetTablesReq> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GetTablesReq> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.drill.exec.proto.UserProtos.GetTablesReq getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface TableMetadataOrBuilder extends
      // @@protoc_insertion_point(interface_extends:exec.user.TableMetadata)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>optional string catalog_name = 1;</code>
     * @return Whether the catalogName field is set.
     */
    boolean hasCatalogName();
    /**
     * <code>optional string catalog_name = 1;</code>
     * @return The catalogName.
     */
    java.lang.String getCatalogName();
    /**
     * <code>optional string catalog_name = 1;</code>
     * @return The bytes for catalogName.
     */
    com.google.protobuf.ByteString
        getCatalogNameBytes();

    /**
     * <code>optional string schema_name = 2;</code>
     * @return Whether the schemaName field is set.
     */
    boolean hasSchemaName();
    /**
     * <code>optional string schema_name = 2;</code>
     * @return The schemaName.
     */
    java.lang.String getSchemaName();
    /**
     * <code>optional string schema_name = 2;</code>
     * @return The bytes for schemaName.
     */
    com.google.protobuf.ByteString
        getSchemaNameBytes();

    /**
     * <code>optional string table_name = 3;</code>
     * @return Whether the tableName field is set.
     */
    boolean hasTableName();
    /**
     * <code>optional string table_name = 3;</code>
     * @return The tableName.
     */
    java.lang.String getTableName();
    /**
     * <code>optional string table_name = 3;</code>
     * @return The bytes for tableName.
     */
    com.google.protobuf.ByteString
        getTableNameBytes();

    /**
     * <pre>
     * Type. Ex. "TABLE", "VIEW" etc.
     * </pre>
     *
     * <code>optional string type = 4;</code>
     * @return Whether the type field is set.
     */
    boolean hasType();
    /**
     * <pre>
     * Type. Ex. "TABLE", "VIEW" etc.
     * </pre>
     *
     * <code>optional string type = 4;</code>
     * @return The type.
     */
    java.lang.String getType();
    /**
     * <pre>
     * Type. Ex. "TABLE", "VIEW" etc.
     * </pre>
     *
     * <code>optional string type = 4;</code>
     * @return The bytes for type.
     */
    com.google.protobuf.ByteString
        getTypeBytes();
  }
  /**
   * <pre>
   * Message encapsulating metadata for a Table.
   * </pre>
   *
   * Protobuf type {@code exec.user.TableMetadata}
   */
  public static final class TableMetadata extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:exec.user.TableMetadata)
      TableMetadataOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use TableMetadata.newBuilder() to construct.
    private TableMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private TableMetadata() {
      catalogName_ = "";
      schemaName_ = "";
      tableName_ = "";
      type_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new TableMetadata();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_TableMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_TableMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.UserProtos.TableMetadata.class, org.apache.drill.exec.proto.UserProtos.TableMetadata.Builder.class);
    }

    private int bitField0_;
    public static final int CATALOG_NAME_FIELD_NUMBER = 1;
    private volatile java.lang.Object catalogName_;
    /**
     * <code>optional string catalog_name = 1;</code>
     * @return Whether the catalogName field is set.
     */
    @java.lang.Override
    public boolean hasCatalogName() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>optional string catalog_name = 1;</code>
     * @return The catalogName.
     */
    @java.lang.Override
    public java.lang.String getCatalogName() {
      java.lang.Object ref = catalogName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          catalogName_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string catalog_name = 1;</code>
     * @return The bytes for catalogName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getCatalogNameBytes() {
      java.lang.Object ref = catalogName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        catalogName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SCHEMA_NAME_FIELD_NUMBER = 2;
    private volatile java.lang.Object schemaName_;
    /**
     * <code>optional string schema_name = 2;</code>
     * @return Whether the schemaName field is set.
     */
    @java.lang.Override
    public boolean hasSchemaName() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <code>optional string schema_name = 2;</code>
     * @return The schemaName.
     */
    @java.lang.Override
    public java.lang.String getSchemaName() {
      java.lang.Object ref = schemaName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          schemaName_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string schema_name = 2;</code>
     * @return The bytes for schemaName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getSchemaNameBytes() {
      java.lang.Object ref = schemaName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        schemaName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TABLE_NAME_FIELD_NUMBER = 3;
    private volatile java.lang.Object tableName_;
    /**
     * <code>optional string table_name = 3;</code>
     * @return Whether the tableName field is set.
     */
    @java.lang.Override
    public boolean hasTableName() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <code>optional string table_name = 3;</code>
     * @return The tableName.
     */
    @java.lang.Override
    public java.lang.String getTableName() {
      java.lang.Object ref = tableName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          tableName_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string table_name = 3;</code>
     * @return The bytes for tableName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getTableNameBytes() {
      java.lang.Object ref = tableName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        tableName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TYPE_FIELD_NUMBER = 4;
    private volatile java.lang.Object type_;
    /**
     * <pre>
     * Type. Ex. "TABLE", "VIEW" etc.
     * </pre>
     *
     * <code>optional string type = 4;</code>
     * @return Whether the type field is set.
     */
    @java.lang.Override
    public boolean hasType() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     * <pre>
     * Type. Ex. "TABLE", "VIEW" etc.
     * </pre>
     *
     * <code>optional string type = 4;</code>
     * @return The type.
     */
    @java.lang.Override
    public java.lang.String getType() {
      java.lang.Object ref = type_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          type_ = s;
        }
        return s;
      }
    }
    /**
     * <pre>
     * Type. Ex. "TABLE", "VIEW" etc.
     * </pre>
     *
     * <code>optional string type = 4;</code>
     * @return The bytes for type.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getTypeBytes() {
      java.lang.Object ref = type_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        type_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, catalogName_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, schemaName_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, tableName_);
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, type_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, catalogName_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, schemaName_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, tableName_);
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, type_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.drill.exec.proto.UserProtos.TableMetadata)) {
        return super.equals(obj);
      }
      org.apache.drill.exec.proto.UserProtos.TableMetadata other = (org.apache.drill.exec.proto.UserProtos.TableMetadata) obj;

      if (hasCatalogName() != other.hasCatalogName()) return false;
      if (hasCatalogName()) {
        if (!getCatalogName()
            .equals(other.getCatalogName())) return false;
      }
      if (hasSchemaName() != other.hasSchemaName()) return false;
      if (hasSchemaName()) {
        if (!getSchemaName()
            .equals(other.getSchemaName())) return false;
      }
      if (hasTableName() != other.hasTableName()) return false;
      if (hasTableName()) {
        if (!getTableName()
            .equals(other.getTableName())) return false;
      }
      if (hasType() != other.hasType()) return false;
      if (hasType()) {
        if (!getType()
            .equals(other.getType())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasCatalogName()) {
        hash = (37 * hash) + CATALOG_NAME_FIELD_NUMBER;
        hash = (53 * hash) + getCatalogName().hashCode();
      }
      if (hasSchemaName()) {
        hash = (37 * hash) + SCHEMA_NAME_FIELD_NUMBER;
        hash = (53 * hash) + getSchemaName().hashCode();
      }
      if (hasTableName()) {
        hash = (37 * hash) + TABLE_NAME_FIELD_NUMBER;
        hash = (53 * hash) + getTableName().hashCode();
      }
      if (hasType()) {
        hash = (37 * hash) + TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getType().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.drill.exec.proto.UserProtos.TableMetadata parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.TableMetadata parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.TableMetadata parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.TableMetadata parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.TableMetadata parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.TableMetadata parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.TableMetadata parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.TableMetadata parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.TableMetadata parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.TableMetadata parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.TableMetadata parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.TableMetadata parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.drill.exec.proto.UserProtos.TableMetadata prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Message encapsulating metadata for a Table.
     * </pre>
     *
     * Protobuf type {@code exec.user.TableMetadata}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:exec.user.TableMetadata)
        org.apache.drill.exec.proto.UserProtos.TableMetadataOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_TableMetadata_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_TableMetadata_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.UserProtos.TableMetadata.class, org.apache.drill.exec.proto.UserProtos.TableMetadata.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.UserProtos.TableMetadata.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        catalogName_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        schemaName_ = "";
        bitField0_ = (bitField0_ & ~0x00000002);
        tableName_ = "";
        bitField0_ = (bitField0_ & ~0x00000004);
        type_ = "";
        bitField0_ = (bitField0_ & ~0x00000008);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_TableMetadata_descriptor;
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.TableMetadata getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.UserProtos.TableMetadata.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.TableMetadata build() {
        org.apache.drill.exec.proto.UserProtos.TableMetadata result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.TableMetadata buildPartial() {
        org.apache.drill.exec.proto.UserProtos.TableMetadata result = new org.apache.drill.exec.proto.UserProtos.TableMetadata(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          to_bitField0_ |= 0x00000001;
        }
        result.catalogName_ = catalogName_;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          to_bitField0_ |= 0x00000002;
        }
        result.schemaName_ = schemaName_;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          to_bitField0_ |= 0x00000004;
        }
        result.tableName_ = tableName_;
        if (((from_bitField0_ & 0x00000008) != 0)) {
          to_bitField0_ |= 0x00000008;
        }
        result.type_ = type_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.UserProtos.TableMetadata) {
          return mergeFrom((org.apache.drill.exec.proto.UserProtos.TableMetadata)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.UserProtos.TableMetadata other) {
        if (other == org.apache.drill.exec.proto.UserProtos.TableMetadata.getDefaultInstance()) return this;
        if (other.hasCatalogName()) {
          bitField0_ |= 0x00000001;
          catalogName_ = other.catalogName_;
          onChanged();
        }
        if (other.hasSchemaName()) {
          bitField0_ |= 0x00000002;
          schemaName_ = other.schemaName_;
          onChanged();
        }
        if (other.hasTableName()) {
          bitField0_ |= 0x00000004;
          tableName_ = other.tableName_;
          onChanged();
        }
        if (other.hasType()) {
          bitField0_ |= 0x00000008;
          type_ = other.type_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                catalogName_ = input.readBytes();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
              case 18: {
                schemaName_ = input.readBytes();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
              case 26: {
                tableName_ = input.readBytes();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
              case 34: {
                type_ = input.readBytes();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private java.lang.Object catalogName_ = "";
      /**
       * <code>optional string catalog_name = 1;</code>
       * @return Whether the catalogName field is set.
       */
      public boolean hasCatalogName() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>optional string catalog_name = 1;</code>
       * @return The catalogName.
       */
      public java.lang.String getCatalogName() {
        java.lang.Object ref = catalogName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            catalogName_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string catalog_name = 1;</code>
       * @return The bytes for catalogName.
       */
      public com.google.protobuf.ByteString
          getCatalogNameBytes() {
        java.lang.Object ref = catalogName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          catalogName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string catalog_name = 1;</code>
       * @param value The catalogName to set.
       * @return This builder for chaining.
       */
      public Builder setCatalogName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        catalogName_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string catalog_name = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearCatalogName() {
        bitField0_ = (bitField0_ & ~0x00000001);
        catalogName_ = getDefaultInstance().getCatalogName();
        onChanged();
        return this;
      }
      /**
       * <code>optional string catalog_name = 1;</code>
       * @param value The bytes for catalogName to set.
       * @return This builder for chaining.
       */
      public Builder setCatalogNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        catalogName_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object schemaName_ = "";
      /**
       * <code>optional string schema_name = 2;</code>
       * @return Whether the schemaName field is set.
       */
      public boolean hasSchemaName() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <code>optional string schema_name = 2;</code>
       * @return The schemaName.
       */
      public java.lang.String getSchemaName() {
        java.lang.Object ref = schemaName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            schemaName_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string schema_name = 2;</code>
       * @return The bytes for schemaName.
       */
      public com.google.protobuf.ByteString
          getSchemaNameBytes() {
        java.lang.Object ref = schemaName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          schemaName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string schema_name = 2;</code>
       * @param value The schemaName to set.
       * @return This builder for chaining.
       */
      public Builder setSchemaName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        schemaName_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string schema_name = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearSchemaName() {
        bitField0_ = (bitField0_ & ~0x00000002);
        schemaName_ = getDefaultInstance().getSchemaName();
        onChanged();
        return this;
      }
      /**
       * <code>optional string schema_name = 2;</code>
       * @param value The bytes for schemaName to set.
       * @return This builder for chaining.
       */
      public Builder setSchemaNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        schemaName_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object tableName_ = "";
      /**
       * <code>optional string table_name = 3;</code>
       * @return Whether the tableName field is set.
       */
      public boolean hasTableName() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <code>optional string table_name = 3;</code>
       * @return The tableName.
       */
      public java.lang.String getTableName() {
        java.lang.Object ref = tableName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            tableName_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string table_name = 3;</code>
       * @return The bytes for tableName.
       */
      public com.google.protobuf.ByteString
          getTableNameBytes() {
        java.lang.Object ref = tableName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          tableName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string table_name = 3;</code>
       * @param value The tableName to set.
       * @return This builder for chaining.
       */
      public Builder setTableName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        tableName_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string table_name = 3;</code>
       * @return This builder for chaining.
       */
      public Builder clearTableName() {
        bitField0_ = (bitField0_ & ~0x00000004);
        tableName_ = getDefaultInstance().getTableName();
        onChanged();
        return this;
      }
      /**
       * <code>optional string table_name = 3;</code>
       * @param value The bytes for tableName to set.
       * @return This builder for chaining.
       */
      public Builder setTableNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        tableName_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object type_ = "";
      /**
       * <pre>
       * Type. Ex. "TABLE", "VIEW" etc.
       * </pre>
       *
       * <code>optional string type = 4;</code>
       * @return Whether the type field is set.
       */
      public boolean hasType() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       * <pre>
       * Type. Ex. "TABLE", "VIEW" etc.
       * </pre>
       *
       * <code>optional string type = 4;</code>
       * @return The type.
       */
      public java.lang.String getType() {
        java.lang.Object ref = type_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            type_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Type. Ex. "TABLE", "VIEW" etc.
       * </pre>
       *
       * <code>optional string type = 4;</code>
       * @return The bytes for type.
       */
      public com.google.protobuf.ByteString
          getTypeBytes() {
        java.lang.Object ref = type_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          type_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Type. Ex. "TABLE", "VIEW" etc.
       * </pre>
       *
       * <code>optional string type = 4;</code>
       * @param value The type to set.
       * @return This builder for chaining.
       */
      public Builder setType(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000008;
        type_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Type. Ex. "TABLE", "VIEW" etc.
       * </pre>
       *
       * <code>optional string type = 4;</code>
       * @return This builder for chaining.
       */
      public Builder clearType() {
        bitField0_ = (bitField0_ & ~0x00000008);
        type_ = getDefaultInstance().getType();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Type. Ex. "TABLE", "VIEW" etc.
       * </pre>
       *
       * <code>optional string type = 4;</code>
       * @param value The bytes for type to set.
       * @return This builder for chaining.
       */
      public Builder setTypeBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000008;
        type_ = value;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:exec.user.TableMetadata)
    }

    // @@protoc_insertion_point(class_scope:exec.user.TableMetadata)
    private static final org.apache.drill.exec.proto.UserProtos.TableMetadata DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.drill.exec.proto.UserProtos.TableMetadata();
    }

    public static org.apache.drill.exec.proto.UserProtos.TableMetadata getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final com.google.protobuf.Parser<TableMetadata>
        PARSER = new com.google.protobuf.AbstractParser<TableMetadata>() {
      @java.lang.Override
      public TableMetadata parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<TableMetadata> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TableMetadata> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.drill.exec.proto.UserProtos.TableMetadata getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface GetTablesRespOrBuilder extends
      // @@protoc_insertion_point(interface_extends:exec.user.GetTablesResp)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>optional .exec.user.RequestStatus status = 1;</code>
     * @return Whether the status field is set.
     */
    boolean hasStatus();
    /**
     * <code>optional .exec.user.RequestStatus status = 1;</code>
     * @return The status.
     */
    org.apache.drill.exec.proto.UserProtos.RequestStatus getStatus();

    /**
     * <code>repeated .exec.user.TableMetadata tables = 2;</code>
     */
    java.util.List<org.apache.drill.exec.proto.UserProtos.TableMetadata> 
        getTablesList();
    /**
     * <code>repeated .exec.user.TableMetadata tables = 2;</code>
     */
    org.apache.drill.exec.proto.UserProtos.TableMetadata getTables(int index);
    /**
     * <code>repeated .exec.user.TableMetadata tables = 2;</code>
     */
    int getTablesCount();
    /**
     * <code>repeated .exec.user.TableMetadata tables = 2;</code>
     */
    java.util.List<? extends org.apache.drill.exec.proto.UserProtos.TableMetadataOrBuilder> 
        getTablesOrBuilderList();
    /**
     * <code>repeated .exec.user.TableMetadata tables = 2;</code>
     */
    org.apache.drill.exec.proto.UserProtos.TableMetadataOrBuilder getTablesOrBuilder(
        int index);

    /**
     * <code>optional .exec.shared.DrillPBError error = 3;</code>
     * @return Whether the error field is set.
     */
    boolean hasError();
    /**
     * <code>optional .exec.shared.DrillPBError error = 3;</code>
     * @return The error.
     */
    org.apache.drill.exec.proto.UserBitShared.DrillPBError getError();
    /**
     * <code>optional .exec.shared.DrillPBError error = 3;</code>
     */
    org.apache.drill.exec.proto.UserBitShared.DrillPBErrorOrBuilder getErrorOrBuilder();
  }
  /**
   * <pre>
   * Response message for GetTablesReq.
   * </pre>
   *
   * Protobuf type {@code exec.user.GetTablesResp}
   */
  public static final class GetTablesResp extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:exec.user.GetTablesResp)
      GetTablesRespOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use GetTablesResp.newBuilder() to construct.
    private GetTablesResp(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private GetTablesResp() {
      status_ = 0;
      tables_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new GetTablesResp();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetTablesResp_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetTablesResp_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.UserProtos.GetTablesResp.class, org.apache.drill.exec.proto.UserProtos.GetTablesResp.Builder.class);
    }

    private int bitField0_;
    public static final int STATUS_FIELD_NUMBER = 1;
    private int status_;
    /**
     * <code>optional .exec.user.RequestStatus status = 1;</code>
     * @return Whether the status field is set.
     */
    @java.lang.Override public boolean hasStatus() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>optional .exec.user.RequestStatus status = 1;</code>
     * @return The status.
     */
    @java.lang.Override public org.apache.drill.exec.proto.UserProtos.RequestStatus getStatus() {
      @SuppressWarnings("deprecation")
      org.apache.drill.exec.proto.UserProtos.RequestStatus result = org.apache.drill.exec.proto.UserProtos.RequestStatus.valueOf(status_);
      return result == null ? org.apache.drill.exec.proto.UserProtos.RequestStatus.UNKNOWN_STATUS : result;
    }

    public static final int TABLES_FIELD_NUMBER = 2;
    private java.util.List<org.apache.drill.exec.proto.UserProtos.TableMetadata> tables_;
    /**
     * <code>repeated .exec.user.TableMetadata tables = 2;</code>
     */
    @java.lang.Override
    public java.util.List<org.apache.drill.exec.proto.UserProtos.TableMetadata> getTablesList() {
      return tables_;
    }
    /**
     * <code>repeated .exec.user.TableMetadata tables = 2;</code>
     */
    @java.lang.Override
    public java.util.List<? extends org.apache.drill.exec.proto.UserProtos.TableMetadataOrBuilder> 
        getTablesOrBuilderList() {
      return tables_;
    }
    /**
     * <code>repeated .exec.user.TableMetadata tables = 2;</code>
     */
    @java.lang.Override
    public int getTablesCount() {
      return tables_.size();
    }
    /**
     * <code>repeated .exec.user.TableMetadata tables = 2;</code>
     */
    @java.lang.Override
    public org.apache.drill.exec.proto.UserProtos.TableMetadata getTables(int index) {
      return tables_.get(index);
    }
    /**
     * <code>repeated .exec.user.TableMetadata tables = 2;</code>
     */
    @java.lang.Override
    public org.apache.drill.exec.proto.UserProtos.TableMetadataOrBuilder getTablesOrBuilder(
        int index) {
      return tables_.get(index);
    }

    public static final int ERROR_FIELD_NUMBER = 3;
    private org.apache.drill.exec.proto.UserBitShared.DrillPBError error_;
    /**
     * <code>optional .exec.shared.DrillPBError error = 3;</code>
     * @return Whether the error field is set.
     */
    @java.lang.Override
    public boolean hasError() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <code>optional .exec.shared.DrillPBError error = 3;</code>
     * @return The error.
     */
    @java.lang.Override
    public org.apache.drill.exec.proto.UserBitShared.DrillPBError getError() {
      return error_ == null ? org.apache.drill.exec.proto.UserBitShared.DrillPBError.getDefaultInstance() : error_;
    }
    /**
     * <code>optional .exec.shared.DrillPBError error = 3;</code>
     */
    @java.lang.Override
    public org.apache.drill.exec.proto.UserBitShared.DrillPBErrorOrBuilder getErrorOrBuilder() {
      return error_ == null ? org.apache.drill.exec.proto.UserBitShared.DrillPBError.getDefaultInstance() : error_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeEnum(1, status_);
      }
      for (int i = 0; i < tables_.size(); i++) {
        output.writeMessage(2, tables_.get(i));
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(3, getError());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(1, status_);
      }
      for (int i = 0; i < tables_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, tables_.get(i));
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, getError());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.drill.exec.proto.UserProtos.GetTablesResp)) {
        return super.equals(obj);
      }
      org.apache.drill.exec.proto.UserProtos.GetTablesResp other = (org.apache.drill.exec.proto.UserProtos.GetTablesResp) obj;

      if (hasStatus() != other.hasStatus()) return false;
      if (hasStatus()) {
        if (status_ != other.status_) return false;
      }
      if (!getTablesList()
          .equals(other.getTablesList())) return false;
      if (hasError() != other.hasError()) return false;
      if (hasError()) {
        if (!getError()
            .equals(other.getError())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasStatus()) {
        hash = (37 * hash) + STATUS_FIELD_NUMBER;
        hash = (53 * hash) + status_;
      }
      if (getTablesCount() > 0) {
        hash = (37 * hash) + TABLES_FIELD_NUMBER;
        hash = (53 * hash) + getTablesList().hashCode();
      }
      if (hasError()) {
        hash = (37 * hash) + ERROR_FIELD_NUMBER;
        hash = (53 * hash) + getError().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.drill.exec.proto.UserProtos.GetTablesResp parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetTablesResp parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetTablesResp parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetTablesResp parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetTablesResp parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetTablesResp parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetTablesResp parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetTablesResp parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetTablesResp parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetTablesResp parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetTablesResp parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetTablesResp parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.drill.exec.proto.UserProtos.GetTablesResp prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Response message for GetTablesReq.
     * </pre>
     *
     * Protobuf type {@code exec.user.GetTablesResp}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:exec.user.GetTablesResp)
        org.apache.drill.exec.proto.UserProtos.GetTablesRespOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetTablesResp_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetTablesResp_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.UserProtos.GetTablesResp.class, org.apache.drill.exec.proto.UserProtos.GetTablesResp.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.UserProtos.GetTablesResp.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getTablesFieldBuilder();
          getErrorFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        status_ = 0;
        bitField0_ = (bitField0_ & ~0x00000001);
        if (tablesBuilder_ == null) {
          tables_ = java.util.Collections.emptyList();
        } else {
          tables_ = null;
          tablesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        if (errorBuilder_ == null) {
          error_ = null;
        } else {
          errorBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetTablesResp_descriptor;
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.GetTablesResp getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.UserProtos.GetTablesResp.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.GetTablesResp build() {
        org.apache.drill.exec.proto.UserProtos.GetTablesResp result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.GetTablesResp buildPartial() {
        org.apache.drill.exec.proto.UserProtos.GetTablesResp result = new org.apache.drill.exec.proto.UserProtos.GetTablesResp(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          to_bitField0_ |= 0x00000001;
        }
        result.status_ = status_;
        if (tablesBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            tables_ = java.util.Collections.unmodifiableList(tables_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.tables_ = tables_;
        } else {
          result.tables_ = tablesBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          if (errorBuilder_ == null) {
            result.error_ = error_;
          } else {
            result.error_ = errorBuilder_.build();
          }
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.UserProtos.GetTablesResp) {
          return mergeFrom((org.apache.drill.exec.proto.UserProtos.GetTablesResp)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.UserProtos.GetTablesResp other) {
        if (other == org.apache.drill.exec.proto.UserProtos.GetTablesResp.getDefaultInstance()) return this;
        if (other.hasStatus()) {
          setStatus(other.getStatus());
        }
        if (tablesBuilder_ == null) {
          if (!other.tables_.isEmpty()) {
            if (tables_.isEmpty()) {
              tables_ = other.tables_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureTablesIsMutable();
              tables_.addAll(other.tables_);
            }
            onChanged();
          }
        } else {
          if (!other.tables_.isEmpty()) {
            if (tablesBuilder_.isEmpty()) {
              tablesBuilder_.dispose();
              tablesBuilder_ = null;
              tables_ = other.tables_;
              bitField0_ = (bitField0_ & ~0x00000002);
              tablesBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getTablesFieldBuilder() : null;
            } else {
              tablesBuilder_.addAllMessages(other.tables_);
            }
          }
        }
        if (other.hasError()) {
          mergeError(other.getError());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8: {
                int tmpRaw = input.readEnum();
                org.apache.drill.exec.proto.UserProtos.RequestStatus tmpValue =
                    org.apache.drill.exec.proto.UserProtos.RequestStatus.forNumber(tmpRaw);
                if (tmpValue == null) {
                  mergeUnknownVarintField(1, tmpRaw);
                } else {
                  status_ = tmpRaw;
                  bitField0_ |= 0x00000001;
                }
                break;
              } // case 8
              case 18: {
                org.apache.drill.exec.proto.UserProtos.TableMetadata m =
                    input.readMessage(
                        org.apache.drill.exec.proto.UserProtos.TableMetadata.PARSER,
                        extensionRegistry);
                if (tablesBuilder_ == null) {
                  ensureTablesIsMutable();
                  tables_.add(m);
                } else {
                  tablesBuilder_.addMessage(m);
                }
                break;
              } // case 18
              case 26: {
                input.readMessage(
                    getErrorFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private int status_ = 0;
      /**
       * <code>optional .exec.user.RequestStatus status = 1;</code>
       * @return Whether the status field is set.
       */
      @java.lang.Override public boolean hasStatus() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>optional .exec.user.RequestStatus status = 1;</code>
       * @return The status.
       */
      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.RequestStatus getStatus() {
        @SuppressWarnings("deprecation")
        org.apache.drill.exec.proto.UserProtos.RequestStatus result = org.apache.drill.exec.proto.UserProtos.RequestStatus.valueOf(status_);
        return result == null ? org.apache.drill.exec.proto.UserProtos.RequestStatus.UNKNOWN_STATUS : result;
      }
      /**
       * <code>optional .exec.user.RequestStatus status = 1;</code>
       * @param value The status to set.
       * @return This builder for chaining.
       */
      public Builder setStatus(org.apache.drill.exec.proto.UserProtos.RequestStatus value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        status_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <code>optional .exec.user.RequestStatus status = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearStatus() {
        bitField0_ = (bitField0_ & ~0x00000001);
        status_ = 0;
        onChanged();
        return this;
      }

      private java.util.List<org.apache.drill.exec.proto.UserProtos.TableMetadata> tables_ =
        java.util.Collections.emptyList();
      private void ensureTablesIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          tables_ = new java.util.ArrayList<org.apache.drill.exec.proto.UserProtos.TableMetadata>(tables_);
          bitField0_ |= 0x00000002;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          org.apache.drill.exec.proto.UserProtos.TableMetadata, org.apache.drill.exec.proto.UserProtos.TableMetadata.Builder, org.apache.drill.exec.proto.UserProtos.TableMetadataOrBuilder> tablesBuilder_;

      /**
       * <code>repeated .exec.user.TableMetadata tables = 2;</code>
       */
      public java.util.List<org.apache.drill.exec.proto.UserProtos.TableMetadata> getTablesList() {
        if (tablesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(tables_);
        } else {
          return tablesBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .exec.user.TableMetadata tables = 2;</code>
       */
      public int getTablesCount() {
        if (tablesBuilder_ == null) {
          return tables_.size();
        } else {
          return tablesBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .exec.user.TableMetadata tables = 2;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.TableMetadata getTables(int index) {
        if (tablesBuilder_ == null) {
          return tables_.get(index);
        } else {
          return tablesBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .exec.user.TableMetadata tables = 2;</code>
       */
      public Builder setTables(
          int index, org.apache.drill.exec.proto.UserProtos.TableMetadata value) {
        if (tablesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTablesIsMutable();
          tables_.set(index, value);
          onChanged();
        } else {
          tablesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.TableMetadata tables = 2;</code>
       */
      public Builder setTables(
          int index, org.apache.drill.exec.proto.UserProtos.TableMetadata.Builder builderForValue) {
        if (tablesBuilder_ == null) {
          ensureTablesIsMutable();
          tables_.set(index, builderForValue.build());
          onChanged();
        } else {
          tablesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.TableMetadata tables = 2;</code>
       */
      public Builder addTables(org.apache.drill.exec.proto.UserProtos.TableMetadata value) {
        if (tablesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTablesIsMutable();
          tables_.add(value);
          onChanged();
        } else {
          tablesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.TableMetadata tables = 2;</code>
       */
      public Builder addTables(
          int index, org.apache.drill.exec.proto.UserProtos.TableMetadata value) {
        if (tablesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTablesIsMutable();
          tables_.add(index, value);
          onChanged();
        } else {
          tablesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.TableMetadata tables = 2;</code>
       */
      public Builder addTables(
          org.apache.drill.exec.proto.UserProtos.TableMetadata.Builder builderForValue) {
        if (tablesBuilder_ == null) {
          ensureTablesIsMutable();
          tables_.add(builderForValue.build());
          onChanged();
        } else {
          tablesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.TableMetadata tables = 2;</code>
       */
      public Builder addTables(
          int index, org.apache.drill.exec.proto.UserProtos.TableMetadata.Builder builderForValue) {
        if (tablesBuilder_ == null) {
          ensureTablesIsMutable();
          tables_.add(index, builderForValue.build());
          onChanged();
        } else {
          tablesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.TableMetadata tables = 2;</code>
       */
      public Builder addAllTables(
          java.lang.Iterable<? extends org.apache.drill.exec.proto.UserProtos.TableMetadata> values) {
        if (tablesBuilder_ == null) {
          ensureTablesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, tables_);
          onChanged();
        } else {
          tablesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.TableMetadata tables = 2;</code>
       */
      public Builder clearTables() {
        if (tablesBuilder_ == null) {
          tables_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          tablesBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.TableMetadata tables = 2;</code>
       */
      public Builder removeTables(int index) {
        if (tablesBuilder_ == null) {
          ensureTablesIsMutable();
          tables_.remove(index);
          onChanged();
        } else {
          tablesBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.TableMetadata tables = 2;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.TableMetadata.Builder getTablesBuilder(
          int index) {
        return getTablesFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .exec.user.TableMetadata tables = 2;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.TableMetadataOrBuilder getTablesOrBuilder(
          int index) {
        if (tablesBuilder_ == null) {
          return tables_.get(index);  } else {
          return tablesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .exec.user.TableMetadata tables = 2;</code>
       */
      public java.util.List<? extends org.apache.drill.exec.proto.UserProtos.TableMetadataOrBuilder> 
           getTablesOrBuilderList() {
        if (tablesBuilder_ != null) {
          return tablesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(tables_);
        }
      }
      /**
       * <code>repeated .exec.user.TableMetadata tables = 2;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.TableMetadata.Builder addTablesBuilder() {
        return getTablesFieldBuilder().addBuilder(
            org.apache.drill.exec.proto.UserProtos.TableMetadata.getDefaultInstance());
      }
      /**
       * <code>repeated .exec.user.TableMetadata tables = 2;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.TableMetadata.Builder addTablesBuilder(
          int index) {
        return getTablesFieldBuilder().addBuilder(
            index, org.apache.drill.exec.proto.UserProtos.TableMetadata.getDefaultInstance());
      }
      /**
       * <code>repeated .exec.user.TableMetadata tables = 2;</code>
       */
      public java.util.List<org.apache.drill.exec.proto.UserProtos.TableMetadata.Builder> 
           getTablesBuilderList() {
        return getTablesFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          org.apache.drill.exec.proto.UserProtos.TableMetadata, org.apache.drill.exec.proto.UserProtos.TableMetadata.Builder, org.apache.drill.exec.proto.UserProtos.TableMetadataOrBuilder> 
          getTablesFieldBuilder() {
        if (tablesBuilder_ == null) {
          tablesBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              org.apache.drill.exec.proto.UserProtos.TableMetadata, org.apache.drill.exec.proto.UserProtos.TableMetadata.Builder, org.apache.drill.exec.proto.UserProtos.TableMetadataOrBuilder>(
                  tables_,
                  ((bitField0_ & 0x00000002) != 0),
                  getParentForChildren(),
                  isClean());
          tables_ = null;
        }
        return tablesBuilder_;
      }

      private org.apache.drill.exec.proto.UserBitShared.DrillPBError error_;
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.drill.exec.proto.UserBitShared.DrillPBError, org.apache.drill.exec.proto.UserBitShared.DrillPBError.Builder, org.apache.drill.exec.proto.UserBitShared.DrillPBErrorOrBuilder> errorBuilder_;
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       * @return Whether the error field is set.
       */
      public boolean hasError() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       * @return The error.
       */
      public org.apache.drill.exec.proto.UserBitShared.DrillPBError getError() {
        if (errorBuilder_ == null) {
          return error_ == null ? org.apache.drill.exec.proto.UserBitShared.DrillPBError.getDefaultInstance() : error_;
        } else {
          return errorBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       */
      public Builder setError(org.apache.drill.exec.proto.UserBitShared.DrillPBError value) {
        if (errorBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          error_ = value;
          onChanged();
        } else {
          errorBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       */
      public Builder setError(
          org.apache.drill.exec.proto.UserBitShared.DrillPBError.Builder builderForValue) {
        if (errorBuilder_ == null) {
          error_ = builderForValue.build();
          onChanged();
        } else {
          errorBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       */
      public Builder mergeError(org.apache.drill.exec.proto.UserBitShared.DrillPBError value) {
        if (errorBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0) &&
              error_ != null &&
              error_ != org.apache.drill.exec.proto.UserBitShared.DrillPBError.getDefaultInstance()) {
            error_ =
              org.apache.drill.exec.proto.UserBitShared.DrillPBError.newBuilder(error_).mergeFrom(value).buildPartial();
          } else {
            error_ = value;
          }
          onChanged();
        } else {
          errorBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       */
      public Builder clearError() {
        if (errorBuilder_ == null) {
          error_ = null;
          onChanged();
        } else {
          errorBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.DrillPBError.Builder getErrorBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getErrorFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.DrillPBErrorOrBuilder getErrorOrBuilder() {
        if (errorBuilder_ != null) {
          return errorBuilder_.getMessageOrBuilder();
        } else {
          return error_ == null ?
              org.apache.drill.exec.proto.UserBitShared.DrillPBError.getDefaultInstance() : error_;
        }
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.drill.exec.proto.UserBitShared.DrillPBError, org.apache.drill.exec.proto.UserBitShared.DrillPBError.Builder, org.apache.drill.exec.proto.UserBitShared.DrillPBErrorOrBuilder> 
          getErrorFieldBuilder() {
        if (errorBuilder_ == null) {
          errorBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.apache.drill.exec.proto.UserBitShared.DrillPBError, org.apache.drill.exec.proto.UserBitShared.DrillPBError.Builder, org.apache.drill.exec.proto.UserBitShared.DrillPBErrorOrBuilder>(
                  getError(),
                  getParentForChildren(),
                  isClean());
          error_ = null;
        }
        return errorBuilder_;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:exec.user.GetTablesResp)
    }

    // @@protoc_insertion_point(class_scope:exec.user.GetTablesResp)
    private static final org.apache.drill.exec.proto.UserProtos.GetTablesResp DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.drill.exec.proto.UserProtos.GetTablesResp();
    }

    public static org.apache.drill.exec.proto.UserProtos.GetTablesResp getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final com.google.protobuf.Parser<GetTablesResp>
        PARSER = new com.google.protobuf.AbstractParser<GetTablesResp>() {
      @java.lang.Override
      public GetTablesResp parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<GetTablesResp> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GetTablesResp> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.drill.exec.proto.UserProtos.GetTablesResp getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface GetColumnsReqOrBuilder extends
      // @@protoc_insertion_point(interface_extends:exec.user.GetColumnsReq)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
     * @return Whether the catalogNameFilter field is set.
     */
    boolean hasCatalogNameFilter();
    /**
     * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
     * @return The catalogNameFilter.
     */
    org.apache.drill.exec.proto.UserProtos.LikeFilter getCatalogNameFilter();
    /**
     * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
     */
    org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder getCatalogNameFilterOrBuilder();

    /**
     * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
     * @return Whether the schemaNameFilter field is set.
     */
    boolean hasSchemaNameFilter();
    /**
     * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
     * @return The schemaNameFilter.
     */
    org.apache.drill.exec.proto.UserProtos.LikeFilter getSchemaNameFilter();
    /**
     * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
     */
    org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder getSchemaNameFilterOrBuilder();

    /**
     * <code>optional .exec.user.LikeFilter table_name_filter = 3;</code>
     * @return Whether the tableNameFilter field is set.
     */
    boolean hasTableNameFilter();
    /**
     * <code>optional .exec.user.LikeFilter table_name_filter = 3;</code>
     * @return The tableNameFilter.
     */
    org.apache.drill.exec.proto.UserProtos.LikeFilter getTableNameFilter();
    /**
     * <code>optional .exec.user.LikeFilter table_name_filter = 3;</code>
     */
    org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder getTableNameFilterOrBuilder();

    /**
     * <code>optional .exec.user.LikeFilter column_name_filter = 4;</code>
     * @return Whether the columnNameFilter field is set.
     */
    boolean hasColumnNameFilter();
    /**
     * <code>optional .exec.user.LikeFilter column_name_filter = 4;</code>
     * @return The columnNameFilter.
     */
    org.apache.drill.exec.proto.UserProtos.LikeFilter getColumnNameFilter();
    /**
     * <code>optional .exec.user.LikeFilter column_name_filter = 4;</code>
     */
    org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder getColumnNameFilterOrBuilder();
  }
  /**
   * <pre>
   * Request message for getting the metadata for columns satisfying the given optional filters.
   * </pre>
   *
   * Protobuf type {@code exec.user.GetColumnsReq}
   */
  public static final class GetColumnsReq extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:exec.user.GetColumnsReq)
      GetColumnsReqOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use GetColumnsReq.newBuilder() to construct.
    private GetColumnsReq(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private GetColumnsReq() {
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new GetColumnsReq();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetColumnsReq_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetColumnsReq_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.UserProtos.GetColumnsReq.class, org.apache.drill.exec.proto.UserProtos.GetColumnsReq.Builder.class);
    }

    private int bitField0_;
    public static final int CATALOG_NAME_FILTER_FIELD_NUMBER = 1;
    private org.apache.drill.exec.proto.UserProtos.LikeFilter catalogNameFilter_;
    /**
     * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
     * @return Whether the catalogNameFilter field is set.
     */
    @java.lang.Override
    public boolean hasCatalogNameFilter() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
     * @return The catalogNameFilter.
     */
    @java.lang.Override
    public org.apache.drill.exec.proto.UserProtos.LikeFilter getCatalogNameFilter() {
      return catalogNameFilter_ == null ? org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance() : catalogNameFilter_;
    }
    /**
     * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
     */
    @java.lang.Override
    public org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder getCatalogNameFilterOrBuilder() {
      return catalogNameFilter_ == null ? org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance() : catalogNameFilter_;
    }

    public static final int SCHEMA_NAME_FILTER_FIELD_NUMBER = 2;
    private org.apache.drill.exec.proto.UserProtos.LikeFilter schemaNameFilter_;
    /**
     * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
     * @return Whether the schemaNameFilter field is set.
     */
    @java.lang.Override
    public boolean hasSchemaNameFilter() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
     * @return The schemaNameFilter.
     */
    @java.lang.Override
    public org.apache.drill.exec.proto.UserProtos.LikeFilter getSchemaNameFilter() {
      return schemaNameFilter_ == null ? org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance() : schemaNameFilter_;
    }
    /**
     * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
     */
    @java.lang.Override
    public org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder getSchemaNameFilterOrBuilder() {
      return schemaNameFilter_ == null ? org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance() : schemaNameFilter_;
    }

    public static final int TABLE_NAME_FILTER_FIELD_NUMBER = 3;
    private org.apache.drill.exec.proto.UserProtos.LikeFilter tableNameFilter_;
    /**
     * <code>optional .exec.user.LikeFilter table_name_filter = 3;</code>
     * @return Whether the tableNameFilter field is set.
     */
    @java.lang.Override
    public boolean hasTableNameFilter() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <code>optional .exec.user.LikeFilter table_name_filter = 3;</code>
     * @return The tableNameFilter.
     */
    @java.lang.Override
    public org.apache.drill.exec.proto.UserProtos.LikeFilter getTableNameFilter() {
      return tableNameFilter_ == null ? org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance() : tableNameFilter_;
    }
    /**
     * <code>optional .exec.user.LikeFilter table_name_filter = 3;</code>
     */
    @java.lang.Override
    public org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder getTableNameFilterOrBuilder() {
      return tableNameFilter_ == null ? org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance() : tableNameFilter_;
    }

    public static final int COLUMN_NAME_FILTER_FIELD_NUMBER = 4;
    private org.apache.drill.exec.proto.UserProtos.LikeFilter columnNameFilter_;
    /**
     * <code>optional .exec.user.LikeFilter column_name_filter = 4;</code>
     * @return Whether the columnNameFilter field is set.
     */
    @java.lang.Override
    public boolean hasColumnNameFilter() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     * <code>optional .exec.user.LikeFilter column_name_filter = 4;</code>
     * @return The columnNameFilter.
     */
    @java.lang.Override
    public org.apache.drill.exec.proto.UserProtos.LikeFilter getColumnNameFilter() {
      return columnNameFilter_ == null ? org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance() : columnNameFilter_;
    }
    /**
     * <code>optional .exec.user.LikeFilter column_name_filter = 4;</code>
     */
    @java.lang.Override
    public org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder getColumnNameFilterOrBuilder() {
      return columnNameFilter_ == null ? org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance() : columnNameFilter_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getCatalogNameFilter());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(2, getSchemaNameFilter());
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeMessage(3, getTableNameFilter());
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        output.writeMessage(4, getColumnNameFilter());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, getCatalogNameFilter());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, getSchemaNameFilter());
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, getTableNameFilter());
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(4, getColumnNameFilter());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.drill.exec.proto.UserProtos.GetColumnsReq)) {
        return super.equals(obj);
      }
      org.apache.drill.exec.proto.UserProtos.GetColumnsReq other = (org.apache.drill.exec.proto.UserProtos.GetColumnsReq) obj;

      if (hasCatalogNameFilter() != other.hasCatalogNameFilter()) return false;
      if (hasCatalogNameFilter()) {
        if (!getCatalogNameFilter()
            .equals(other.getCatalogNameFilter())) return false;
      }
      if (hasSchemaNameFilter() != other.hasSchemaNameFilter()) return false;
      if (hasSchemaNameFilter()) {
        if (!getSchemaNameFilter()
            .equals(other.getSchemaNameFilter())) return false;
      }
      if (hasTableNameFilter() != other.hasTableNameFilter()) return false;
      if (hasTableNameFilter()) {
        if (!getTableNameFilter()
            .equals(other.getTableNameFilter())) return false;
      }
      if (hasColumnNameFilter() != other.hasColumnNameFilter()) return false;
      if (hasColumnNameFilter()) {
        if (!getColumnNameFilter()
            .equals(other.getColumnNameFilter())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasCatalogNameFilter()) {
        hash = (37 * hash) + CATALOG_NAME_FILTER_FIELD_NUMBER;
        hash = (53 * hash) + getCatalogNameFilter().hashCode();
      }
      if (hasSchemaNameFilter()) {
        hash = (37 * hash) + SCHEMA_NAME_FILTER_FIELD_NUMBER;
        hash = (53 * hash) + getSchemaNameFilter().hashCode();
      }
      if (hasTableNameFilter()) {
        hash = (37 * hash) + TABLE_NAME_FILTER_FIELD_NUMBER;
        hash = (53 * hash) + getTableNameFilter().hashCode();
      }
      if (hasColumnNameFilter()) {
        hash = (37 * hash) + COLUMN_NAME_FILTER_FIELD_NUMBER;
        hash = (53 * hash) + getColumnNameFilter().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.drill.exec.proto.UserProtos.GetColumnsReq parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetColumnsReq parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetColumnsReq parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetColumnsReq parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetColumnsReq parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetColumnsReq parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetColumnsReq parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetColumnsReq parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetColumnsReq parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetColumnsReq parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetColumnsReq parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetColumnsReq parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.drill.exec.proto.UserProtos.GetColumnsReq prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Request message for getting the metadata for columns satisfying the given optional filters.
     * </pre>
     *
     * Protobuf type {@code exec.user.GetColumnsReq}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:exec.user.GetColumnsReq)
        org.apache.drill.exec.proto.UserProtos.GetColumnsReqOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetColumnsReq_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetColumnsReq_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.UserProtos.GetColumnsReq.class, org.apache.drill.exec.proto.UserProtos.GetColumnsReq.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.UserProtos.GetColumnsReq.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getCatalogNameFilterFieldBuilder();
          getSchemaNameFilterFieldBuilder();
          getTableNameFilterFieldBuilder();
          getColumnNameFilterFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (catalogNameFilterBuilder_ == null) {
          catalogNameFilter_ = null;
        } else {
          catalogNameFilterBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        if (schemaNameFilterBuilder_ == null) {
          schemaNameFilter_ = null;
        } else {
          schemaNameFilterBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        if (tableNameFilterBuilder_ == null) {
          tableNameFilter_ = null;
        } else {
          tableNameFilterBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        if (columnNameFilterBuilder_ == null) {
          columnNameFilter_ = null;
        } else {
          columnNameFilterBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000008);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetColumnsReq_descriptor;
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.GetColumnsReq getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.UserProtos.GetColumnsReq.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.GetColumnsReq build() {
        org.apache.drill.exec.proto.UserProtos.GetColumnsReq result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.GetColumnsReq buildPartial() {
        org.apache.drill.exec.proto.UserProtos.GetColumnsReq result = new org.apache.drill.exec.proto.UserProtos.GetColumnsReq(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          if (catalogNameFilterBuilder_ == null) {
            result.catalogNameFilter_ = catalogNameFilter_;
          } else {
            result.catalogNameFilter_ = catalogNameFilterBuilder_.build();
          }
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          if (schemaNameFilterBuilder_ == null) {
            result.schemaNameFilter_ = schemaNameFilter_;
          } else {
            result.schemaNameFilter_ = schemaNameFilterBuilder_.build();
          }
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          if (tableNameFilterBuilder_ == null) {
            result.tableNameFilter_ = tableNameFilter_;
          } else {
            result.tableNameFilter_ = tableNameFilterBuilder_.build();
          }
          to_bitField0_ |= 0x00000004;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          if (columnNameFilterBuilder_ == null) {
            result.columnNameFilter_ = columnNameFilter_;
          } else {
            result.columnNameFilter_ = columnNameFilterBuilder_.build();
          }
          to_bitField0_ |= 0x00000008;
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.UserProtos.GetColumnsReq) {
          return mergeFrom((org.apache.drill.exec.proto.UserProtos.GetColumnsReq)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.UserProtos.GetColumnsReq other) {
        if (other == org.apache.drill.exec.proto.UserProtos.GetColumnsReq.getDefaultInstance()) return this;
        if (other.hasCatalogNameFilter()) {
          mergeCatalogNameFilter(other.getCatalogNameFilter());
        }
        if (other.hasSchemaNameFilter()) {
          mergeSchemaNameFilter(other.getSchemaNameFilter());
        }
        if (other.hasTableNameFilter()) {
          mergeTableNameFilter(other.getTableNameFilter());
        }
        if (other.hasColumnNameFilter()) {
          mergeColumnNameFilter(other.getColumnNameFilter());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                input.readMessage(
                    getCatalogNameFilterFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
              case 18: {
                input.readMessage(
                    getSchemaNameFilterFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
              case 26: {
                input.readMessage(
                    getTableNameFilterFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
              case 34: {
                input.readMessage(
                    getColumnNameFilterFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private org.apache.drill.exec.proto.UserProtos.LikeFilter catalogNameFilter_;
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.drill.exec.proto.UserProtos.LikeFilter, org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder, org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder> catalogNameFilterBuilder_;
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       * @return Whether the catalogNameFilter field is set.
       */
      public boolean hasCatalogNameFilter() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       * @return The catalogNameFilter.
       */
      public org.apache.drill.exec.proto.UserProtos.LikeFilter getCatalogNameFilter() {
        if (catalogNameFilterBuilder_ == null) {
          return catalogNameFilter_ == null ? org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance() : catalogNameFilter_;
        } else {
          return catalogNameFilterBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       */
      public Builder setCatalogNameFilter(org.apache.drill.exec.proto.UserProtos.LikeFilter value) {
        if (catalogNameFilterBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          catalogNameFilter_ = value;
          onChanged();
        } else {
          catalogNameFilterBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       */
      public Builder setCatalogNameFilter(
          org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder builderForValue) {
        if (catalogNameFilterBuilder_ == null) {
          catalogNameFilter_ = builderForValue.build();
          onChanged();
        } else {
          catalogNameFilterBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       */
      public Builder mergeCatalogNameFilter(org.apache.drill.exec.proto.UserProtos.LikeFilter value) {
        if (catalogNameFilterBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0) &&
              catalogNameFilter_ != null &&
              catalogNameFilter_ != org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance()) {
            catalogNameFilter_ =
              org.apache.drill.exec.proto.UserProtos.LikeFilter.newBuilder(catalogNameFilter_).mergeFrom(value).buildPartial();
          } else {
            catalogNameFilter_ = value;
          }
          onChanged();
        } else {
          catalogNameFilterBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       */
      public Builder clearCatalogNameFilter() {
        if (catalogNameFilterBuilder_ == null) {
          catalogNameFilter_ = null;
          onChanged();
        } else {
          catalogNameFilterBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder getCatalogNameFilterBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getCatalogNameFilterFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder getCatalogNameFilterOrBuilder() {
        if (catalogNameFilterBuilder_ != null) {
          return catalogNameFilterBuilder_.getMessageOrBuilder();
        } else {
          return catalogNameFilter_ == null ?
              org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance() : catalogNameFilter_;
        }
      }
      /**
       * <code>optional .exec.user.LikeFilter catalog_name_filter = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.drill.exec.proto.UserProtos.LikeFilter, org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder, org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder> 
          getCatalogNameFilterFieldBuilder() {
        if (catalogNameFilterBuilder_ == null) {
          catalogNameFilterBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.apache.drill.exec.proto.UserProtos.LikeFilter, org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder, org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder>(
                  getCatalogNameFilter(),
                  getParentForChildren(),
                  isClean());
          catalogNameFilter_ = null;
        }
        return catalogNameFilterBuilder_;
      }

      private org.apache.drill.exec.proto.UserProtos.LikeFilter schemaNameFilter_;
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.drill.exec.proto.UserProtos.LikeFilter, org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder, org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder> schemaNameFilterBuilder_;
      /**
       * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
       * @return Whether the schemaNameFilter field is set.
       */
      public boolean hasSchemaNameFilter() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
       * @return The schemaNameFilter.
       */
      public org.apache.drill.exec.proto.UserProtos.LikeFilter getSchemaNameFilter() {
        if (schemaNameFilterBuilder_ == null) {
          return schemaNameFilter_ == null ? org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance() : schemaNameFilter_;
        } else {
          return schemaNameFilterBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
       */
      public Builder setSchemaNameFilter(org.apache.drill.exec.proto.UserProtos.LikeFilter value) {
        if (schemaNameFilterBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          schemaNameFilter_ = value;
          onChanged();
        } else {
          schemaNameFilterBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
       */
      public Builder setSchemaNameFilter(
          org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder builderForValue) {
        if (schemaNameFilterBuilder_ == null) {
          schemaNameFilter_ = builderForValue.build();
          onChanged();
        } else {
          schemaNameFilterBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
       */
      public Builder mergeSchemaNameFilter(org.apache.drill.exec.proto.UserProtos.LikeFilter value) {
        if (schemaNameFilterBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0) &&
              schemaNameFilter_ != null &&
              schemaNameFilter_ != org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance()) {
            schemaNameFilter_ =
              org.apache.drill.exec.proto.UserProtos.LikeFilter.newBuilder(schemaNameFilter_).mergeFrom(value).buildPartial();
          } else {
            schemaNameFilter_ = value;
          }
          onChanged();
        } else {
          schemaNameFilterBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
       */
      public Builder clearSchemaNameFilter() {
        if (schemaNameFilterBuilder_ == null) {
          schemaNameFilter_ = null;
          onChanged();
        } else {
          schemaNameFilterBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder getSchemaNameFilterBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getSchemaNameFilterFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder getSchemaNameFilterOrBuilder() {
        if (schemaNameFilterBuilder_ != null) {
          return schemaNameFilterBuilder_.getMessageOrBuilder();
        } else {
          return schemaNameFilter_ == null ?
              org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance() : schemaNameFilter_;
        }
      }
      /**
       * <code>optional .exec.user.LikeFilter schema_name_filter = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.drill.exec.proto.UserProtos.LikeFilter, org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder, org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder> 
          getSchemaNameFilterFieldBuilder() {
        if (schemaNameFilterBuilder_ == null) {
          schemaNameFilterBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.apache.drill.exec.proto.UserProtos.LikeFilter, org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder, org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder>(
                  getSchemaNameFilter(),
                  getParentForChildren(),
                  isClean());
          schemaNameFilter_ = null;
        }
        return schemaNameFilterBuilder_;
      }

      private org.apache.drill.exec.proto.UserProtos.LikeFilter tableNameFilter_;
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.drill.exec.proto.UserProtos.LikeFilter, org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder, org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder> tableNameFilterBuilder_;
      /**
       * <code>optional .exec.user.LikeFilter table_name_filter = 3;</code>
       * @return Whether the tableNameFilter field is set.
       */
      public boolean hasTableNameFilter() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <code>optional .exec.user.LikeFilter table_name_filter = 3;</code>
       * @return The tableNameFilter.
       */
      public org.apache.drill.exec.proto.UserProtos.LikeFilter getTableNameFilter() {
        if (tableNameFilterBuilder_ == null) {
          return tableNameFilter_ == null ? org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance() : tableNameFilter_;
        } else {
          return tableNameFilterBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .exec.user.LikeFilter table_name_filter = 3;</code>
       */
      public Builder setTableNameFilter(org.apache.drill.exec.proto.UserProtos.LikeFilter value) {
        if (tableNameFilterBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          tableNameFilter_ = value;
          onChanged();
        } else {
          tableNameFilterBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter table_name_filter = 3;</code>
       */
      public Builder setTableNameFilter(
          org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder builderForValue) {
        if (tableNameFilterBuilder_ == null) {
          tableNameFilter_ = builderForValue.build();
          onChanged();
        } else {
          tableNameFilterBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter table_name_filter = 3;</code>
       */
      public Builder mergeTableNameFilter(org.apache.drill.exec.proto.UserProtos.LikeFilter value) {
        if (tableNameFilterBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0) &&
              tableNameFilter_ != null &&
              tableNameFilter_ != org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance()) {
            tableNameFilter_ =
              org.apache.drill.exec.proto.UserProtos.LikeFilter.newBuilder(tableNameFilter_).mergeFrom(value).buildPartial();
          } else {
            tableNameFilter_ = value;
          }
          onChanged();
        } else {
          tableNameFilterBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter table_name_filter = 3;</code>
       */
      public Builder clearTableNameFilter() {
        if (tableNameFilterBuilder_ == null) {
          tableNameFilter_ = null;
          onChanged();
        } else {
          tableNameFilterBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter table_name_filter = 3;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder getTableNameFilterBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getTableNameFilterFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .exec.user.LikeFilter table_name_filter = 3;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder getTableNameFilterOrBuilder() {
        if (tableNameFilterBuilder_ != null) {
          return tableNameFilterBuilder_.getMessageOrBuilder();
        } else {
          return tableNameFilter_ == null ?
              org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance() : tableNameFilter_;
        }
      }
      /**
       * <code>optional .exec.user.LikeFilter table_name_filter = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.drill.exec.proto.UserProtos.LikeFilter, org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder, org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder> 
          getTableNameFilterFieldBuilder() {
        if (tableNameFilterBuilder_ == null) {
          tableNameFilterBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.apache.drill.exec.proto.UserProtos.LikeFilter, org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder, org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder>(
                  getTableNameFilter(),
                  getParentForChildren(),
                  isClean());
          tableNameFilter_ = null;
        }
        return tableNameFilterBuilder_;
      }

      private org.apache.drill.exec.proto.UserProtos.LikeFilter columnNameFilter_;
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.drill.exec.proto.UserProtos.LikeFilter, org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder, org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder> columnNameFilterBuilder_;
      /**
       * <code>optional .exec.user.LikeFilter column_name_filter = 4;</code>
       * @return Whether the columnNameFilter field is set.
       */
      public boolean hasColumnNameFilter() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       * <code>optional .exec.user.LikeFilter column_name_filter = 4;</code>
       * @return The columnNameFilter.
       */
      public org.apache.drill.exec.proto.UserProtos.LikeFilter getColumnNameFilter() {
        if (columnNameFilterBuilder_ == null) {
          return columnNameFilter_ == null ? org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance() : columnNameFilter_;
        } else {
          return columnNameFilterBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .exec.user.LikeFilter column_name_filter = 4;</code>
       */
      public Builder setColumnNameFilter(org.apache.drill.exec.proto.UserProtos.LikeFilter value) {
        if (columnNameFilterBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          columnNameFilter_ = value;
          onChanged();
        } else {
          columnNameFilterBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter column_name_filter = 4;</code>
       */
      public Builder setColumnNameFilter(
          org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder builderForValue) {
        if (columnNameFilterBuilder_ == null) {
          columnNameFilter_ = builderForValue.build();
          onChanged();
        } else {
          columnNameFilterBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter column_name_filter = 4;</code>
       */
      public Builder mergeColumnNameFilter(org.apache.drill.exec.proto.UserProtos.LikeFilter value) {
        if (columnNameFilterBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0) &&
              columnNameFilter_ != null &&
              columnNameFilter_ != org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance()) {
            columnNameFilter_ =
              org.apache.drill.exec.proto.UserProtos.LikeFilter.newBuilder(columnNameFilter_).mergeFrom(value).buildPartial();
          } else {
            columnNameFilter_ = value;
          }
          onChanged();
        } else {
          columnNameFilterBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000008;
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter column_name_filter = 4;</code>
       */
      public Builder clearColumnNameFilter() {
        if (columnNameFilterBuilder_ == null) {
          columnNameFilter_ = null;
          onChanged();
        } else {
          columnNameFilterBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000008);
        return this;
      }
      /**
       * <code>optional .exec.user.LikeFilter column_name_filter = 4;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder getColumnNameFilterBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getColumnNameFilterFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .exec.user.LikeFilter column_name_filter = 4;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder getColumnNameFilterOrBuilder() {
        if (columnNameFilterBuilder_ != null) {
          return columnNameFilterBuilder_.getMessageOrBuilder();
        } else {
          return columnNameFilter_ == null ?
              org.apache.drill.exec.proto.UserProtos.LikeFilter.getDefaultInstance() : columnNameFilter_;
        }
      }
      /**
       * <code>optional .exec.user.LikeFilter column_name_filter = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.drill.exec.proto.UserProtos.LikeFilter, org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder, org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder> 
          getColumnNameFilterFieldBuilder() {
        if (columnNameFilterBuilder_ == null) {
          columnNameFilterBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.apache.drill.exec.proto.UserProtos.LikeFilter, org.apache.drill.exec.proto.UserProtos.LikeFilter.Builder, org.apache.drill.exec.proto.UserProtos.LikeFilterOrBuilder>(
                  getColumnNameFilter(),
                  getParentForChildren(),
                  isClean());
          columnNameFilter_ = null;
        }
        return columnNameFilterBuilder_;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:exec.user.GetColumnsReq)
    }

    // @@protoc_insertion_point(class_scope:exec.user.GetColumnsReq)
    private static final org.apache.drill.exec.proto.UserProtos.GetColumnsReq DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.drill.exec.proto.UserProtos.GetColumnsReq();
    }

    public static org.apache.drill.exec.proto.UserProtos.GetColumnsReq getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final com.google.protobuf.Parser<GetColumnsReq>
        PARSER = new com.google.protobuf.AbstractParser<GetColumnsReq>() {
      @java.lang.Override
      public GetColumnsReq parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<GetColumnsReq> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GetColumnsReq> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.drill.exec.proto.UserProtos.GetColumnsReq getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ColumnMetadataOrBuilder extends
      // @@protoc_insertion_point(interface_extends:exec.user.ColumnMetadata)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>optional string catalog_name = 1;</code>
     * @return Whether the catalogName field is set.
     */
    boolean hasCatalogName();
    /**
     * <code>optional string catalog_name = 1;</code>
     * @return The catalogName.
     */
    java.lang.String getCatalogName();
    /**
     * <code>optional string catalog_name = 1;</code>
     * @return The bytes for catalogName.
     */
    com.google.protobuf.ByteString
        getCatalogNameBytes();

    /**
     * <code>optional string schema_name = 2;</code>
     * @return Whether the schemaName field is set.
     */
    boolean hasSchemaName();
    /**
     * <code>optional string schema_name = 2;</code>
     * @return The schemaName.
     */
    java.lang.String getSchemaName();
    /**
     * <code>optional string schema_name = 2;</code>
     * @return The bytes for schemaName.
     */
    com.google.protobuf.ByteString
        getSchemaNameBytes();

    /**
     * <code>optional string table_name = 3;</code>
     * @return Whether the tableName field is set.
     */
    boolean hasTableName();
    /**
     * <code>optional string table_name = 3;</code>
     * @return The tableName.
     */
    java.lang.String getTableName();
    /**
     * <code>optional string table_name = 3;</code>
     * @return The bytes for tableName.
     */
    com.google.protobuf.ByteString
        getTableNameBytes();

    /**
     * <code>optional string column_name = 4;</code>
     * @return Whether the columnName field is set.
     */
    boolean hasColumnName();
    /**
     * <code>optional string column_name = 4;</code>
     * @return The columnName.
     */
    java.lang.String getColumnName();
    /**
     * <code>optional string column_name = 4;</code>
     * @return The bytes for columnName.
     */
    com.google.protobuf.ByteString
        getColumnNameBytes();

    /**
     * <code>optional int32 ordinal_position = 5;</code>
     * @return Whether the ordinalPosition field is set.
     */
    boolean hasOrdinalPosition();
    /**
     * <code>optional int32 ordinal_position = 5;</code>
     * @return The ordinalPosition.
     */
    int getOrdinalPosition();

    /**
     * <code>optional string default_value = 6;</code>
     * @return Whether the defaultValue field is set.
     */
    boolean hasDefaultValue();
    /**
     * <code>optional string default_value = 6;</code>
     * @return The defaultValue.
     */
    java.lang.String getDefaultValue();
    /**
     * <code>optional string default_value = 6;</code>
     * @return The bytes for defaultValue.
     */
    com.google.protobuf.ByteString
        getDefaultValueBytes();

    /**
     * <code>optional bool is_nullable = 7;</code>
     * @return Whether the isNullable field is set.
     */
    boolean hasIsNullable();
    /**
     * <code>optional bool is_nullable = 7;</code>
     * @return The isNullable.
     */
    boolean getIsNullable();

    /**
     * <code>optional string data_type = 8;</code>
     * @return Whether the dataType field is set.
     */
    boolean hasDataType();
    /**
     * <code>optional string data_type = 8;</code>
     * @return The dataType.
     */
    java.lang.String getDataType();
    /**
     * <code>optional string data_type = 8;</code>
     * @return The bytes for dataType.
     */
    com.google.protobuf.ByteString
        getDataTypeBytes();

    /**
     * <code>optional int32 char_max_length = 9;</code>
     * @return Whether the charMaxLength field is set.
     */
    boolean hasCharMaxLength();
    /**
     * <code>optional int32 char_max_length = 9;</code>
     * @return The charMaxLength.
     */
    int getCharMaxLength();

    /**
     * <code>optional int32 char_octet_length = 10;</code>
     * @return Whether the charOctetLength field is set.
     */
    boolean hasCharOctetLength();
    /**
     * <code>optional int32 char_octet_length = 10;</code>
     * @return The charOctetLength.
     */
    int getCharOctetLength();

    /**
     * <code>optional int32 numeric_precision = 11;</code>
     * @return Whether the numericPrecision field is set.
     */
    boolean hasNumericPrecision();
    /**
     * <code>optional int32 numeric_precision = 11;</code>
     * @return The numericPrecision.
     */
    int getNumericPrecision();

    /**
     * <code>optional int32 numeric_precision_radix = 12;</code>
     * @return Whether the numericPrecisionRadix field is set.
     */
    boolean hasNumericPrecisionRadix();
    /**
     * <code>optional int32 numeric_precision_radix = 12;</code>
     * @return The numericPrecisionRadix.
     */
    int getNumericPrecisionRadix();

    /**
     * <code>optional int32 numeric_scale = 13;</code>
     * @return Whether the numericScale field is set.
     */
    boolean hasNumericScale();
    /**
     * <code>optional int32 numeric_scale = 13;</code>
     * @return The numericScale.
     */
    int getNumericScale();

    /**
     * <code>optional int32 date_time_precision = 14;</code>
     * @return Whether the dateTimePrecision field is set.
     */
    boolean hasDateTimePrecision();
    /**
     * <code>optional int32 date_time_precision = 14;</code>
     * @return The dateTimePrecision.
     */
    int getDateTimePrecision();

    /**
     * <code>optional string interval_type = 15;</code>
     * @return Whether the intervalType field is set.
     */
    boolean hasIntervalType();
    /**
     * <code>optional string interval_type = 15;</code>
     * @return The intervalType.
     */
    java.lang.String getIntervalType();
    /**
     * <code>optional string interval_type = 15;</code>
     * @return The bytes for intervalType.
     */
    com.google.protobuf.ByteString
        getIntervalTypeBytes();

    /**
     * <code>optional int32 interval_precision = 16;</code>
     * @return Whether the intervalPrecision field is set.
     */
    boolean hasIntervalPrecision();
    /**
     * <code>optional int32 interval_precision = 16;</code>
     * @return The intervalPrecision.
     */
    int getIntervalPrecision();

    /**
     * <code>optional int32 column_size = 17;</code>
     * @return Whether the columnSize field is set.
     */
    boolean hasColumnSize();
    /**
     * <code>optional int32 column_size = 17;</code>
     * @return The columnSize.
     */
    int getColumnSize();
  }
  /**
   * <pre>
   * Message encapsulating metadata for a Column.
   * </pre>
   *
   * Protobuf type {@code exec.user.ColumnMetadata}
   */
  public static final class ColumnMetadata extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:exec.user.ColumnMetadata)
      ColumnMetadataOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use ColumnMetadata.newBuilder() to construct.
    private ColumnMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private ColumnMetadata() {
      catalogName_ = "";
      schemaName_ = "";
      tableName_ = "";
      columnName_ = "";
      defaultValue_ = "";
      dataType_ = "";
      intervalType_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new ColumnMetadata();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_ColumnMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_ColumnMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.UserProtos.ColumnMetadata.class, org.apache.drill.exec.proto.UserProtos.ColumnMetadata.Builder.class);
    }

    private int bitField0_;
    public static final int CATALOG_NAME_FIELD_NUMBER = 1;
    private volatile java.lang.Object catalogName_;
    /**
     * <code>optional string catalog_name = 1;</code>
     * @return Whether the catalogName field is set.
     */
    @java.lang.Override
    public boolean hasCatalogName() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>optional string catalog_name = 1;</code>
     * @return The catalogName.
     */
    @java.lang.Override
    public java.lang.String getCatalogName() {
      java.lang.Object ref = catalogName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          catalogName_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string catalog_name = 1;</code>
     * @return The bytes for catalogName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getCatalogNameBytes() {
      java.lang.Object ref = catalogName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        catalogName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SCHEMA_NAME_FIELD_NUMBER = 2;
    private volatile java.lang.Object schemaName_;
    /**
     * <code>optional string schema_name = 2;</code>
     * @return Whether the schemaName field is set.
     */
    @java.lang.Override
    public boolean hasSchemaName() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <code>optional string schema_name = 2;</code>
     * @return The schemaName.
     */
    @java.lang.Override
    public java.lang.String getSchemaName() {
      java.lang.Object ref = schemaName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          schemaName_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string schema_name = 2;</code>
     * @return The bytes for schemaName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getSchemaNameBytes() {
      java.lang.Object ref = schemaName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        schemaName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TABLE_NAME_FIELD_NUMBER = 3;
    private volatile java.lang.Object tableName_;
    /**
     * <code>optional string table_name = 3;</code>
     * @return Whether the tableName field is set.
     */
    @java.lang.Override
    public boolean hasTableName() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <code>optional string table_name = 3;</code>
     * @return The tableName.
     */
    @java.lang.Override
    public java.lang.String getTableName() {
      java.lang.Object ref = tableName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          tableName_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string table_name = 3;</code>
     * @return The bytes for tableName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getTableNameBytes() {
      java.lang.Object ref = tableName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        tableName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int COLUMN_NAME_FIELD_NUMBER = 4;
    private volatile java.lang.Object columnName_;
    /**
     * <code>optional string column_name = 4;</code>
     * @return Whether the columnName field is set.
     */
    @java.lang.Override
    public boolean hasColumnName() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     * <code>optional string column_name = 4;</code>
     * @return The columnName.
     */
    @java.lang.Override
    public java.lang.String getColumnName() {
      java.lang.Object ref = columnName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          columnName_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string column_name = 4;</code>
     * @return The bytes for columnName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getColumnNameBytes() {
      java.lang.Object ref = columnName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        columnName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ORDINAL_POSITION_FIELD_NUMBER = 5;
    private int ordinalPosition_;
    /**
     * <code>optional int32 ordinal_position = 5;</code>
     * @return Whether the ordinalPosition field is set.
     */
    @java.lang.Override
    public boolean hasOrdinalPosition() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     * <code>optional int32 ordinal_position = 5;</code>
     * @return The ordinalPosition.
     */
    @java.lang.Override
    public int getOrdinalPosition() {
      return ordinalPosition_;
    }

    public static final int DEFAULT_VALUE_FIELD_NUMBER = 6;
    private volatile java.lang.Object defaultValue_;
    /**
     * <code>optional string default_value = 6;</code>
     * @return Whether the defaultValue field is set.
     */
    @java.lang.Override
    public boolean hasDefaultValue() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     * <code>optional string default_value = 6;</code>
     * @return The defaultValue.
     */
    @java.lang.Override
    public java.lang.String getDefaultValue() {
      java.lang.Object ref = defaultValue_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          defaultValue_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string default_value = 6;</code>
     * @return The bytes for defaultValue.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getDefaultValueBytes() {
      java.lang.Object ref = defaultValue_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        defaultValue_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int IS_NULLABLE_FIELD_NUMBER = 7;
    private boolean isNullable_;
    /**
     * <code>optional bool is_nullable = 7;</code>
     * @return Whether the isNullable field is set.
     */
    @java.lang.Override
    public boolean hasIsNullable() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     * <code>optional bool is_nullable = 7;</code>
     * @return The isNullable.
     */
    @java.lang.Override
    public boolean getIsNullable() {
      return isNullable_;
    }

    public static final int DATA_TYPE_FIELD_NUMBER = 8;
    private volatile java.lang.Object dataType_;
    /**
     * <code>optional string data_type = 8;</code>
     * @return Whether the dataType field is set.
     */
    @java.lang.Override
    public boolean hasDataType() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     * <code>optional string data_type = 8;</code>
     * @return The dataType.
     */
    @java.lang.Override
    public java.lang.String getDataType() {
      java.lang.Object ref = dataType_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          dataType_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string data_type = 8;</code>
     * @return The bytes for dataType.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getDataTypeBytes() {
      java.lang.Object ref = dataType_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        dataType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CHAR_MAX_LENGTH_FIELD_NUMBER = 9;
    private int charMaxLength_;
    /**
     * <code>optional int32 char_max_length = 9;</code>
     * @return Whether the charMaxLength field is set.
     */
    @java.lang.Override
    public boolean hasCharMaxLength() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     * <code>optional int32 char_max_length = 9;</code>
     * @return The charMaxLength.
     */
    @java.lang.Override
    public int getCharMaxLength() {
      return charMaxLength_;
    }

    public static final int CHAR_OCTET_LENGTH_FIELD_NUMBER = 10;
    private int charOctetLength_;
    /**
     * <code>optional int32 char_octet_length = 10;</code>
     * @return Whether the charOctetLength field is set.
     */
    @java.lang.Override
    public boolean hasCharOctetLength() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     * <code>optional int32 char_octet_length = 10;</code>
     * @return The charOctetLength.
     */
    @java.lang.Override
    public int getCharOctetLength() {
      return charOctetLength_;
    }

    public static final int NUMERIC_PRECISION_FIELD_NUMBER = 11;
    private int numericPrecision_;
    /**
     * <code>optional int32 numeric_precision = 11;</code>
     * @return Whether the numericPrecision field is set.
     */
    @java.lang.Override
    public boolean hasNumericPrecision() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     * <code>optional int32 numeric_precision = 11;</code>
     * @return The numericPrecision.
     */
    @java.lang.Override
    public int getNumericPrecision() {
      return numericPrecision_;
    }

    public static final int NUMERIC_PRECISION_RADIX_FIELD_NUMBER = 12;
    private int numericPrecisionRadix_;
    /**
     * <code>optional int32 numeric_precision_radix = 12;</code>
     * @return Whether the numericPrecisionRadix field is set.
     */
    @java.lang.Override
    public boolean hasNumericPrecisionRadix() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     * <code>optional int32 numeric_precision_radix = 12;</code>
     * @return The numericPrecisionRadix.
     */
    @java.lang.Override
    public int getNumericPrecisionRadix() {
      return numericPrecisionRadix_;
    }

    public static final int NUMERIC_SCALE_FIELD_NUMBER = 13;
    private int numericScale_;
    /**
     * <code>optional int32 numeric_scale = 13;</code>
     * @return Whether the numericScale field is set.
     */
    @java.lang.Override
    public boolean hasNumericScale() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     * <code>optional int32 numeric_scale = 13;</code>
     * @return The numericScale.
     */
    @java.lang.Override
    public int getNumericScale() {
      return numericScale_;
    }

    public static final int DATE_TIME_PRECISION_FIELD_NUMBER = 14;
    private int dateTimePrecision_;
    /**
     * <code>optional int32 date_time_precision = 14;</code>
     * @return Whether the dateTimePrecision field is set.
     */
    @java.lang.Override
    public boolean hasDateTimePrecision() {
      return ((bitField0_ & 0x00002000) != 0);
    }
    /**
     * <code>optional int32 date_time_precision = 14;</code>
     * @return The dateTimePrecision.
     */
    @java.lang.Override
    public int getDateTimePrecision() {
      return dateTimePrecision_;
    }

    public static final int INTERVAL_TYPE_FIELD_NUMBER = 15;
    private volatile java.lang.Object intervalType_;
    /**
     * <code>optional string interval_type = 15;</code>
     * @return Whether the intervalType field is set.
     */
    @java.lang.Override
    public boolean hasIntervalType() {
      return ((bitField0_ & 0x00004000) != 0);
    }
    /**
     * <code>optional string interval_type = 15;</code>
     * @return The intervalType.
     */
    @java.lang.Override
    public java.lang.String getIntervalType() {
      java.lang.Object ref = intervalType_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          intervalType_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string interval_type = 15;</code>
     * @return The bytes for intervalType.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getIntervalTypeBytes() {
      java.lang.Object ref = intervalType_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        intervalType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int INTERVAL_PRECISION_FIELD_NUMBER = 16;
    private int intervalPrecision_;
    /**
     * <code>optional int32 interval_precision = 16;</code>
     * @return Whether the intervalPrecision field is set.
     */
    @java.lang.Override
    public boolean hasIntervalPrecision() {
      return ((bitField0_ & 0x00008000) != 0);
    }
    /**
     * <code>optional int32 interval_precision = 16;</code>
     * @return The intervalPrecision.
     */
    @java.lang.Override
    public int getIntervalPrecision() {
      return intervalPrecision_;
    }

    public static final int COLUMN_SIZE_FIELD_NUMBER = 17;
    private int columnSize_;
    /**
     * <code>optional int32 column_size = 17;</code>
     * @return Whether the columnSize field is set.
     */
    @java.lang.Override
    public boolean hasColumnSize() {
      return ((bitField0_ & 0x00010000) != 0);
    }
    /**
     * <code>optional int32 column_size = 17;</code>
     * @return The columnSize.
     */
    @java.lang.Override
    public int getColumnSize() {
      return columnSize_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, catalogName_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, schemaName_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, tableName_);
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, columnName_);
      }
      if (((bitField0_ & 0x00000010) != 0)) {
        output.writeInt32(5, ordinalPosition_);
      }
      if (((bitField0_ & 0x00000020) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 6, defaultValue_);
      }
      if (((bitField0_ & 0x00000040) != 0)) {
        output.writeBool(7, isNullable_);
      }
      if (((bitField0_ & 0x00000080) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 8, dataType_);
      }
      if (((bitField0_ & 0x00000100) != 0)) {
        output.writeInt32(9, charMaxLength_);
      }
      if (((bitField0_ & 0x00000200) != 0)) {
        output.writeInt32(10, charOctetLength_);
      }
      if (((bitField0_ & 0x00000400) != 0)) {
        output.writeInt32(11, numericPrecision_);
      }
      if (((bitField0_ & 0x00000800) != 0)) {
        output.writeInt32(12, numericPrecisionRadix_);
      }
      if (((bitField0_ & 0x00001000) != 0)) {
        output.writeInt32(13, numericScale_);
      }
      if (((bitField0_ & 0x00002000) != 0)) {
        output.writeInt32(14, dateTimePrecision_);
      }
      if (((bitField0_ & 0x00004000) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 15, intervalType_);
      }
      if (((bitField0_ & 0x00008000) != 0)) {
        output.writeInt32(16, intervalPrecision_);
      }
      if (((bitField0_ & 0x00010000) != 0)) {
        output.writeInt32(17, columnSize_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, catalogName_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, schemaName_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, tableName_);
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, columnName_);
      }
      if (((bitField0_ & 0x00000010) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(5, ordinalPosition_);
      }
      if (((bitField0_ & 0x00000020) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, defaultValue_);
      }
      if (((bitField0_ & 0x00000040) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(7, isNullable_);
      }
      if (((bitField0_ & 0x00000080) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, dataType_);
      }
      if (((bitField0_ & 0x00000100) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(9, charMaxLength_);
      }
      if (((bitField0_ & 0x00000200) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(10, charOctetLength_);
      }
      if (((bitField0_ & 0x00000400) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(11, numericPrecision_);
      }
      if (((bitField0_ & 0x00000800) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(12, numericPrecisionRadix_);
      }
      if (((bitField0_ & 0x00001000) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(13, numericScale_);
      }
      if (((bitField0_ & 0x00002000) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(14, dateTimePrecision_);
      }
      if (((bitField0_ & 0x00004000) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(15, intervalType_);
      }
      if (((bitField0_ & 0x00008000) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(16, intervalPrecision_);
      }
      if (((bitField0_ & 0x00010000) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(17, columnSize_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.drill.exec.proto.UserProtos.ColumnMetadata)) {
        return super.equals(obj);
      }
      org.apache.drill.exec.proto.UserProtos.ColumnMetadata other = (org.apache.drill.exec.proto.UserProtos.ColumnMetadata) obj;

      if (hasCatalogName() != other.hasCatalogName()) return false;
      if (hasCatalogName()) {
        if (!getCatalogName()
            .equals(other.getCatalogName())) return false;
      }
      if (hasSchemaName() != other.hasSchemaName()) return false;
      if (hasSchemaName()) {
        if (!getSchemaName()
            .equals(other.getSchemaName())) return false;
      }
      if (hasTableName() != other.hasTableName()) return false;
      if (hasTableName()) {
        if (!getTableName()
            .equals(other.getTableName())) return false;
      }
      if (hasColumnName() != other.hasColumnName()) return false;
      if (hasColumnName()) {
        if (!getColumnName()
            .equals(other.getColumnName())) return false;
      }
      if (hasOrdinalPosition() != other.hasOrdinalPosition()) return false;
      if (hasOrdinalPosition()) {
        if (getOrdinalPosition()
            != other.getOrdinalPosition()) return false;
      }
      if (hasDefaultValue() != other.hasDefaultValue()) return false;
      if (hasDefaultValue()) {
        if (!getDefaultValue()
            .equals(other.getDefaultValue())) return false;
      }
      if (hasIsNullable() != other.hasIsNullable()) return false;
      if (hasIsNullable()) {
        if (getIsNullable()
            != other.getIsNullable()) return false;
      }
      if (hasDataType() != other.hasDataType()) return false;
      if (hasDataType()) {
        if (!getDataType()
            .equals(other.getDataType())) return false;
      }
      if (hasCharMaxLength() != other.hasCharMaxLength()) return false;
      if (hasCharMaxLength()) {
        if (getCharMaxLength()
            != other.getCharMaxLength()) return false;
      }
      if (hasCharOctetLength() != other.hasCharOctetLength()) return false;
      if (hasCharOctetLength()) {
        if (getCharOctetLength()
            != other.getCharOctetLength()) return false;
      }
      if (hasNumericPrecision() != other.hasNumericPrecision()) return false;
      if (hasNumericPrecision()) {
        if (getNumericPrecision()
            != other.getNumericPrecision()) return false;
      }
      if (hasNumericPrecisionRadix() != other.hasNumericPrecisionRadix()) return false;
      if (hasNumericPrecisionRadix()) {
        if (getNumericPrecisionRadix()
            != other.getNumericPrecisionRadix()) return false;
      }
      if (hasNumericScale() != other.hasNumericScale()) return false;
      if (hasNumericScale()) {
        if (getNumericScale()
            != other.getNumericScale()) return false;
      }
      if (hasDateTimePrecision() != other.hasDateTimePrecision()) return false;
      if (hasDateTimePrecision()) {
        if (getDateTimePrecision()
            != other.getDateTimePrecision()) return false;
      }
      if (hasIntervalType() != other.hasIntervalType()) return false;
      if (hasIntervalType()) {
        if (!getIntervalType()
            .equals(other.getIntervalType())) return false;
      }
      if (hasIntervalPrecision() != other.hasIntervalPrecision()) return false;
      if (hasIntervalPrecision()) {
        if (getIntervalPrecision()
            != other.getIntervalPrecision()) return false;
      }
      if (hasColumnSize() != other.hasColumnSize()) return false;
      if (hasColumnSize()) {
        if (getColumnSize()
            != other.getColumnSize()) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasCatalogName()) {
        hash = (37 * hash) + CATALOG_NAME_FIELD_NUMBER;
        hash = (53 * hash) + getCatalogName().hashCode();
      }
      if (hasSchemaName()) {
        hash = (37 * hash) + SCHEMA_NAME_FIELD_NUMBER;
        hash = (53 * hash) + getSchemaName().hashCode();
      }
      if (hasTableName()) {
        hash = (37 * hash) + TABLE_NAME_FIELD_NUMBER;
        hash = (53 * hash) + getTableName().hashCode();
      }
      if (hasColumnName()) {
        hash = (37 * hash) + COLUMN_NAME_FIELD_NUMBER;
        hash = (53 * hash) + getColumnName().hashCode();
      }
      if (hasOrdinalPosition()) {
        hash = (37 * hash) + ORDINAL_POSITION_FIELD_NUMBER;
        hash = (53 * hash) + getOrdinalPosition();
      }
      if (hasDefaultValue()) {
        hash = (37 * hash) + DEFAULT_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getDefaultValue().hashCode();
      }
      if (hasIsNullable()) {
        hash = (37 * hash) + IS_NULLABLE_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
            getIsNullable());
      }
      if (hasDataType()) {
        hash = (37 * hash) + DATA_TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getDataType().hashCode();
      }
      if (hasCharMaxLength()) {
        hash = (37 * hash) + CHAR_MAX_LENGTH_FIELD_NUMBER;
        hash = (53 * hash) + getCharMaxLength();
      }
      if (hasCharOctetLength()) {
        hash = (37 * hash) + CHAR_OCTET_LENGTH_FIELD_NUMBER;
        hash = (53 * hash) + getCharOctetLength();
      }
      if (hasNumericPrecision()) {
        hash = (37 * hash) + NUMERIC_PRECISION_FIELD_NUMBER;
        hash = (53 * hash) + getNumericPrecision();
      }
      if (hasNumericPrecisionRadix()) {
        hash = (37 * hash) + NUMERIC_PRECISION_RADIX_FIELD_NUMBER;
        hash = (53 * hash) + getNumericPrecisionRadix();
      }
      if (hasNumericScale()) {
        hash = (37 * hash) + NUMERIC_SCALE_FIELD_NUMBER;
        hash = (53 * hash) + getNumericScale();
      }
      if (hasDateTimePrecision()) {
        hash = (37 * hash) + DATE_TIME_PRECISION_FIELD_NUMBER;
        hash = (53 * hash) + getDateTimePrecision();
      }
      if (hasIntervalType()) {
        hash = (37 * hash) + INTERVAL_TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getIntervalType().hashCode();
      }
      if (hasIntervalPrecision()) {
        hash = (37 * hash) + INTERVAL_PRECISION_FIELD_NUMBER;
        hash = (53 * hash) + getIntervalPrecision();
      }
      if (hasColumnSize()) {
        hash = (37 * hash) + COLUMN_SIZE_FIELD_NUMBER;
        hash = (53 * hash) + getColumnSize();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.drill.exec.proto.UserProtos.ColumnMetadata parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.ColumnMetadata parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.ColumnMetadata parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.ColumnMetadata parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.ColumnMetadata parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.ColumnMetadata parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.ColumnMetadata parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.ColumnMetadata parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.ColumnMetadata parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.ColumnMetadata parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.ColumnMetadata parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.ColumnMetadata parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.drill.exec.proto.UserProtos.ColumnMetadata prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Message encapsulating metadata for a Column.
     * </pre>
     *
     * Protobuf type {@code exec.user.ColumnMetadata}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:exec.user.ColumnMetadata)
        org.apache.drill.exec.proto.UserProtos.ColumnMetadataOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_ColumnMetadata_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_ColumnMetadata_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.UserProtos.ColumnMetadata.class, org.apache.drill.exec.proto.UserProtos.ColumnMetadata.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.UserProtos.ColumnMetadata.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        catalogName_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        schemaName_ = "";
        bitField0_ = (bitField0_ & ~0x00000002);
        tableName_ = "";
        bitField0_ = (bitField0_ & ~0x00000004);
        columnName_ = "";
        bitField0_ = (bitField0_ & ~0x00000008);
        ordinalPosition_ = 0;
        bitField0_ = (bitField0_ & ~0x00000010);
        defaultValue_ = "";
        bitField0_ = (bitField0_ & ~0x00000020);
        isNullable_ = false;
        bitField0_ = (bitField0_ & ~0x00000040);
        dataType_ = "";
        bitField0_ = (bitField0_ & ~0x00000080);
        charMaxLength_ = 0;
        bitField0_ = (bitField0_ & ~0x00000100);
        charOctetLength_ = 0;
        bitField0_ = (bitField0_ & ~0x00000200);
        numericPrecision_ = 0;
        bitField0_ = (bitField0_ & ~0x00000400);
        numericPrecisionRadix_ = 0;
        bitField0_ = (bitField0_ & ~0x00000800);
        numericScale_ = 0;
        bitField0_ = (bitField0_ & ~0x00001000);
        dateTimePrecision_ = 0;
        bitField0_ = (bitField0_ & ~0x00002000);
        intervalType_ = "";
        bitField0_ = (bitField0_ & ~0x00004000);
        intervalPrecision_ = 0;
        bitField0_ = (bitField0_ & ~0x00008000);
        columnSize_ = 0;
        bitField0_ = (bitField0_ & ~0x00010000);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_ColumnMetadata_descriptor;
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.ColumnMetadata getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.UserProtos.ColumnMetadata.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.ColumnMetadata build() {
        org.apache.drill.exec.proto.UserProtos.ColumnMetadata result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.ColumnMetadata buildPartial() {
        org.apache.drill.exec.proto.UserProtos.ColumnMetadata result = new org.apache.drill.exec.proto.UserProtos.ColumnMetadata(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          to_bitField0_ |= 0x00000001;
        }
        result.catalogName_ = catalogName_;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          to_bitField0_ |= 0x00000002;
        }
        result.schemaName_ = schemaName_;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          to_bitField0_ |= 0x00000004;
        }
        result.tableName_ = tableName_;
        if (((from_bitField0_ & 0x00000008) != 0)) {
          to_bitField0_ |= 0x00000008;
        }
        result.columnName_ = columnName_;
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.ordinalPosition_ = ordinalPosition_;
          to_bitField0_ |= 0x00000010;
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          to_bitField0_ |= 0x00000020;
        }
        result.defaultValue_ = defaultValue_;
        if (((from_bitField0_ & 0x00000040) != 0)) {
          result.isNullable_ = isNullable_;
          to_bitField0_ |= 0x00000040;
        }
        if (((from_bitField0_ & 0x00000080) != 0)) {
          to_bitField0_ |= 0x00000080;
        }
        result.dataType_ = dataType_;
        if (((from_bitField0_ & 0x00000100) != 0)) {
          result.charMaxLength_ = charMaxLength_;
          to_bitField0_ |= 0x00000100;
        }
        if (((from_bitField0_ & 0x00000200) != 0)) {
          result.charOctetLength_ = charOctetLength_;
          to_bitField0_ |= 0x00000200;
        }
        if (((from_bitField0_ & 0x00000400) != 0)) {
          result.numericPrecision_ = numericPrecision_;
          to_bitField0_ |= 0x00000400;
        }
        if (((from_bitField0_ & 0x00000800) != 0)) {
          result.numericPrecisionRadix_ = numericPrecisionRadix_;
          to_bitField0_ |= 0x00000800;
        }
        if (((from_bitField0_ & 0x00001000) != 0)) {
          result.numericScale_ = numericScale_;
          to_bitField0_ |= 0x00001000;
        }
        if (((from_bitField0_ & 0x00002000) != 0)) {
          result.dateTimePrecision_ = dateTimePrecision_;
          to_bitField0_ |= 0x00002000;
        }
        if (((from_bitField0_ & 0x00004000) != 0)) {
          to_bitField0_ |= 0x00004000;
        }
        result.intervalType_ = intervalType_;
        if (((from_bitField0_ & 0x00008000) != 0)) {
          result.intervalPrecision_ = intervalPrecision_;
          to_bitField0_ |= 0x00008000;
        }
        if (((from_bitField0_ & 0x00010000) != 0)) {
          result.columnSize_ = columnSize_;
          to_bitField0_ |= 0x00010000;
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.UserProtos.ColumnMetadata) {
          return mergeFrom((org.apache.drill.exec.proto.UserProtos.ColumnMetadata)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.UserProtos.ColumnMetadata other) {
        if (other == org.apache.drill.exec.proto.UserProtos.ColumnMetadata.getDefaultInstance()) return this;
        if (other.hasCatalogName()) {
          bitField0_ |= 0x00000001;
          catalogName_ = other.catalogName_;
          onChanged();
        }
        if (other.hasSchemaName()) {
          bitField0_ |= 0x00000002;
          schemaName_ = other.schemaName_;
          onChanged();
        }
        if (other.hasTableName()) {
          bitField0_ |= 0x00000004;
          tableName_ = other.tableName_;
          onChanged();
        }
        if (other.hasColumnName()) {
          bitField0_ |= 0x00000008;
          columnName_ = other.columnName_;
          onChanged();
        }
        if (other.hasOrdinalPosition()) {
          setOrdinalPosition(other.getOrdinalPosition());
        }
        if (other.hasDefaultValue()) {
          bitField0_ |= 0x00000020;
          defaultValue_ = other.defaultValue_;
          onChanged();
        }
        if (other.hasIsNullable()) {
          setIsNullable(other.getIsNullable());
        }
        if (other.hasDataType()) {
          bitField0_ |= 0x00000080;
          dataType_ = other.dataType_;
          onChanged();
        }
        if (other.hasCharMaxLength()) {
          setCharMaxLength(other.getCharMaxLength());
        }
        if (other.hasCharOctetLength()) {
          setCharOctetLength(other.getCharOctetLength());
        }
        if (other.hasNumericPrecision()) {
          setNumericPrecision(other.getNumericPrecision());
        }
        if (other.hasNumericPrecisionRadix()) {
          setNumericPrecisionRadix(other.getNumericPrecisionRadix());
        }
        if (other.hasNumericScale()) {
          setNumericScale(other.getNumericScale());
        }
        if (other.hasDateTimePrecision()) {
          setDateTimePrecision(other.getDateTimePrecision());
        }
        if (other.hasIntervalType()) {
          bitField0_ |= 0x00004000;
          intervalType_ = other.intervalType_;
          onChanged();
        }
        if (other.hasIntervalPrecision()) {
          setIntervalPrecision(other.getIntervalPrecision());
        }
        if (other.hasColumnSize()) {
          setColumnSize(other.getColumnSize());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                catalogName_ = input.readBytes();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
              case 18: {
                schemaName_ = input.readBytes();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
              case 26: {
                tableName_ = input.readBytes();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
              case 34: {
                columnName_ = input.readBytes();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
              case 40: {
                ordinalPosition_ = input.readInt32();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
              case 50: {
                defaultValue_ = input.readBytes();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
              case 56: {
                isNullable_ = input.readBool();
                bitField0_ |= 0x00000040;
                break;
              } // case 56
              case 66: {
                dataType_ = input.readBytes();
                bitField0_ |= 0x00000080;
                break;
              } // case 66
              case 72: {
                charMaxLength_ = input.readInt32();
                bitField0_ |= 0x00000100;
                break;
              } // case 72
              case 80: {
                charOctetLength_ = input.readInt32();
                bitField0_ |= 0x00000200;
                break;
              } // case 80
              case 88: {
                numericPrecision_ = input.readInt32();
                bitField0_ |= 0x00000400;
                break;
              } // case 88
              case 96: {
                numericPrecisionRadix_ = input.readInt32();
                bitField0_ |= 0x00000800;
                break;
              } // case 96
              case 104: {
                numericScale_ = input.readInt32();
                bitField0_ |= 0x00001000;
                break;
              } // case 104
              case 112: {
                dateTimePrecision_ = input.readInt32();
                bitField0_ |= 0x00002000;
                break;
              } // case 112
              case 122: {
                intervalType_ = input.readBytes();
                bitField0_ |= 0x00004000;
                break;
              } // case 122
              case 128: {
                intervalPrecision_ = input.readInt32();
                bitField0_ |= 0x00008000;
                break;
              } // case 128
              case 136: {
                columnSize_ = input.readInt32();
                bitField0_ |= 0x00010000;
                break;
              } // case 136
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private java.lang.Object catalogName_ = "";
      /**
       * <code>optional string catalog_name = 1;</code>
       * @return Whether the catalogName field is set.
       */
      public boolean hasCatalogName() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>optional string catalog_name = 1;</code>
       * @return The catalogName.
       */
      public java.lang.String getCatalogName() {
        java.lang.Object ref = catalogName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            catalogName_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string catalog_name = 1;</code>
       * @return The bytes for catalogName.
       */
      public com.google.protobuf.ByteString
          getCatalogNameBytes() {
        java.lang.Object ref = catalogName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          catalogName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string catalog_name = 1;</code>
       * @param value The catalogName to set.
       * @return This builder for chaining.
       */
      public Builder setCatalogName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        catalogName_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string catalog_name = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearCatalogName() {
        bitField0_ = (bitField0_ & ~0x00000001);
        catalogName_ = getDefaultInstance().getCatalogName();
        onChanged();
        return this;
      }
      /**
       * <code>optional string catalog_name = 1;</code>
       * @param value The bytes for catalogName to set.
       * @return This builder for chaining.
       */
      public Builder setCatalogNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        catalogName_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object schemaName_ = "";
      /**
       * <code>optional string schema_name = 2;</code>
       * @return Whether the schemaName field is set.
       */
      public boolean hasSchemaName() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <code>optional string schema_name = 2;</code>
       * @return The schemaName.
       */
      public java.lang.String getSchemaName() {
        java.lang.Object ref = schemaName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            schemaName_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string schema_name = 2;</code>
       * @return The bytes for schemaName.
       */
      public com.google.protobuf.ByteString
          getSchemaNameBytes() {
        java.lang.Object ref = schemaName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          schemaName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string schema_name = 2;</code>
       * @param value The schemaName to set.
       * @return This builder for chaining.
       */
      public Builder setSchemaName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        schemaName_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string schema_name = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearSchemaName() {
        bitField0_ = (bitField0_ & ~0x00000002);
        schemaName_ = getDefaultInstance().getSchemaName();
        onChanged();
        return this;
      }
      /**
       * <code>optional string schema_name = 2;</code>
       * @param value The bytes for schemaName to set.
       * @return This builder for chaining.
       */
      public Builder setSchemaNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        schemaName_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object tableName_ = "";
      /**
       * <code>optional string table_name = 3;</code>
       * @return Whether the tableName field is set.
       */
      public boolean hasTableName() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <code>optional string table_name = 3;</code>
       * @return The tableName.
       */
      public java.lang.String getTableName() {
        java.lang.Object ref = tableName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            tableName_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string table_name = 3;</code>
       * @return The bytes for tableName.
       */
      public com.google.protobuf.ByteString
          getTableNameBytes() {
        java.lang.Object ref = tableName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          tableName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string table_name = 3;</code>
       * @param value The tableName to set.
       * @return This builder for chaining.
       */
      public Builder setTableName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        tableName_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string table_name = 3;</code>
       * @return This builder for chaining.
       */
      public Builder clearTableName() {
        bitField0_ = (bitField0_ & ~0x00000004);
        tableName_ = getDefaultInstance().getTableName();
        onChanged();
        return this;
      }
      /**
       * <code>optional string table_name = 3;</code>
       * @param value The bytes for tableName to set.
       * @return This builder for chaining.
       */
      public Builder setTableNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        tableName_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object columnName_ = "";
      /**
       * <code>optional string column_name = 4;</code>
       * @return Whether the columnName field is set.
       */
      public boolean hasColumnName() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       * <code>optional string column_name = 4;</code>
       * @return The columnName.
       */
      public java.lang.String getColumnName() {
        java.lang.Object ref = columnName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            columnName_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string column_name = 4;</code>
       * @return The bytes for columnName.
       */
      public com.google.protobuf.ByteString
          getColumnNameBytes() {
        java.lang.Object ref = columnName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          columnName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string column_name = 4;</code>
       * @param value The columnName to set.
       * @return This builder for chaining.
       */
      public Builder setColumnName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000008;
        columnName_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string column_name = 4;</code>
       * @return This builder for chaining.
       */
      public Builder clearColumnName() {
        bitField0_ = (bitField0_ & ~0x00000008);
        columnName_ = getDefaultInstance().getColumnName();
        onChanged();
        return this;
      }
      /**
       * <code>optional string column_name = 4;</code>
       * @param value The bytes for columnName to set.
       * @return This builder for chaining.
       */
      public Builder setColumnNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000008;
        columnName_ = value;
        onChanged();
        return this;
      }

      private int ordinalPosition_ ;
      /**
       * <code>optional int32 ordinal_position = 5;</code>
       * @return Whether the ordinalPosition field is set.
       */
      @java.lang.Override
      public boolean hasOrdinalPosition() {
        return ((bitField0_ & 0x00000010) != 0);
      }
      /**
       * <code>optional int32 ordinal_position = 5;</code>
       * @return The ordinalPosition.
       */
      @java.lang.Override
      public int getOrdinalPosition() {
        return ordinalPosition_;
      }
      /**
       * <code>optional int32 ordinal_position = 5;</code>
       * @param value The ordinalPosition to set.
       * @return This builder for chaining.
       */
      public Builder setOrdinalPosition(int value) {
        bitField0_ |= 0x00000010;
        ordinalPosition_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional int32 ordinal_position = 5;</code>
       * @return This builder for chaining.
       */
      public Builder clearOrdinalPosition() {
        bitField0_ = (bitField0_ & ~0x00000010);
        ordinalPosition_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object defaultValue_ = "";
      /**
       * <code>optional string default_value = 6;</code>
       * @return Whether the defaultValue field is set.
       */
      public boolean hasDefaultValue() {
        return ((bitField0_ & 0x00000020) != 0);
      }
      /**
       * <code>optional string default_value = 6;</code>
       * @return The defaultValue.
       */
      public java.lang.String getDefaultValue() {
        java.lang.Object ref = defaultValue_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            defaultValue_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string default_value = 6;</code>
       * @return The bytes for defaultValue.
       */
      public com.google.protobuf.ByteString
          getDefaultValueBytes() {
        java.lang.Object ref = defaultValue_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          defaultValue_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string default_value = 6;</code>
       * @param value The defaultValue to set.
       * @return This builder for chaining.
       */
      public Builder setDefaultValue(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000020;
        defaultValue_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string default_value = 6;</code>
       * @return This builder for chaining.
       */
      public Builder clearDefaultValue() {
        bitField0_ = (bitField0_ & ~0x00000020);
        defaultValue_ = getDefaultInstance().getDefaultValue();
        onChanged();
        return this;
      }
      /**
       * <code>optional string default_value = 6;</code>
       * @param value The bytes for defaultValue to set.
       * @return This builder for chaining.
       */
      public Builder setDefaultValueBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000020;
        defaultValue_ = value;
        onChanged();
        return this;
      }

      private boolean isNullable_ ;
      /**
       * <code>optional bool is_nullable = 7;</code>
       * @return Whether the isNullable field is set.
       */
      @java.lang.Override
      public boolean hasIsNullable() {
        return ((bitField0_ & 0x00000040) != 0);
      }
      /**
       * <code>optional bool is_nullable = 7;</code>
       * @return The isNullable.
       */
      @java.lang.Override
      public boolean getIsNullable() {
        return isNullable_;
      }
      /**
       * <code>optional bool is_nullable = 7;</code>
       * @param value The isNullable to set.
       * @return This builder for chaining.
       */
      public Builder setIsNullable(boolean value) {
        bitField0_ |= 0x00000040;
        isNullable_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool is_nullable = 7;</code>
       * @return This builder for chaining.
       */
      public Builder clearIsNullable() {
        bitField0_ = (bitField0_ & ~0x00000040);
        isNullable_ = false;
        onChanged();
        return this;
      }

      private java.lang.Object dataType_ = "";
      /**
       * <code>optional string data_type = 8;</code>
       * @return Whether the dataType field is set.
       */
      public boolean hasDataType() {
        return ((bitField0_ & 0x00000080) != 0);
      }
      /**
       * <code>optional string data_type = 8;</code>
       * @return The dataType.
       */
      public java.lang.String getDataType() {
        java.lang.Object ref = dataType_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            dataType_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string data_type = 8;</code>
       * @return The bytes for dataType.
       */
      public com.google.protobuf.ByteString
          getDataTypeBytes() {
        java.lang.Object ref = dataType_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          dataType_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string data_type = 8;</code>
       * @param value The dataType to set.
       * @return This builder for chaining.
       */
      public Builder setDataType(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000080;
        dataType_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string data_type = 8;</code>
       * @return This builder for chaining.
       */
      public Builder clearDataType() {
        bitField0_ = (bitField0_ & ~0x00000080);
        dataType_ = getDefaultInstance().getDataType();
        onChanged();
        return this;
      }
      /**
       * <code>optional string data_type = 8;</code>
       * @param value The bytes for dataType to set.
       * @return This builder for chaining.
       */
      public Builder setDataTypeBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000080;
        dataType_ = value;
        onChanged();
        return this;
      }

      private int charMaxLength_ ;
      /**
       * <code>optional int32 char_max_length = 9;</code>
       * @return Whether the charMaxLength field is set.
       */
      @java.lang.Override
      public boolean hasCharMaxLength() {
        return ((bitField0_ & 0x00000100) != 0);
      }
      /**
       * <code>optional int32 char_max_length = 9;</code>
       * @return The charMaxLength.
       */
      @java.lang.Override
      public int getCharMaxLength() {
        return charMaxLength_;
      }
      /**
       * <code>optional int32 char_max_length = 9;</code>
       * @param value The charMaxLength to set.
       * @return This builder for chaining.
       */
      public Builder setCharMaxLength(int value) {
        bitField0_ |= 0x00000100;
        charMaxLength_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional int32 char_max_length = 9;</code>
       * @return This builder for chaining.
       */
      public Builder clearCharMaxLength() {
        bitField0_ = (bitField0_ & ~0x00000100);
        charMaxLength_ = 0;
        onChanged();
        return this;
      }

      private int charOctetLength_ ;
      /**
       * <code>optional int32 char_octet_length = 10;</code>
       * @return Whether the charOctetLength field is set.
       */
      @java.lang.Override
      public boolean hasCharOctetLength() {
        return ((bitField0_ & 0x00000200) != 0);
      }
      /**
       * <code>optional int32 char_octet_length = 10;</code>
       * @return The charOctetLength.
       */
      @java.lang.Override
      public int getCharOctetLength() {
        return charOctetLength_;
      }
      /**
       * <code>optional int32 char_octet_length = 10;</code>
       * @param value The charOctetLength to set.
       * @return This builder for chaining.
       */
      public Builder setCharOctetLength(int value) {
        bitField0_ |= 0x00000200;
        charOctetLength_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional int32 char_octet_length = 10;</code>
       * @return This builder for chaining.
       */
      public Builder clearCharOctetLength() {
        bitField0_ = (bitField0_ & ~0x00000200);
        charOctetLength_ = 0;
        onChanged();
        return this;
      }

      private int numericPrecision_ ;
      /**
       * <code>optional int32 numeric_precision = 11;</code>
       * @return Whether the numericPrecision field is set.
       */
      @java.lang.Override
      public boolean hasNumericPrecision() {
        return ((bitField0_ & 0x00000400) != 0);
      }
      /**
       * <code>optional int32 numeric_precision = 11;</code>
       * @return The numericPrecision.
       */
      @java.lang.Override
      public int getNumericPrecision() {
        return numericPrecision_;
      }
      /**
       * <code>optional int32 numeric_precision = 11;</code>
       * @param value The numericPrecision to set.
       * @return This builder for chaining.
       */
      public Builder setNumericPrecision(int value) {
        bitField0_ |= 0x00000400;
        numericPrecision_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional int32 numeric_precision = 11;</code>
       * @return This builder for chaining.
       */
      public Builder clearNumericPrecision() {
        bitField0_ = (bitField0_ & ~0x00000400);
        numericPrecision_ = 0;
        onChanged();
        return this;
      }

      private int numericPrecisionRadix_ ;
      /**
       * <code>optional int32 numeric_precision_radix = 12;</code>
       * @return Whether the numericPrecisionRadix field is set.
       */
      @java.lang.Override
      public boolean hasNumericPrecisionRadix() {
        return ((bitField0_ & 0x00000800) != 0);
      }
      /**
       * <code>optional int32 numeric_precision_radix = 12;</code>
       * @return The numericPrecisionRadix.
       */
      @java.lang.Override
      public int getNumericPrecisionRadix() {
        return numericPrecisionRadix_;
      }
      /**
       * <code>optional int32 numeric_precision_radix = 12;</code>
       * @param value The numericPrecisionRadix to set.
       * @return This builder for chaining.
       */
      public Builder setNumericPrecisionRadix(int value) {
        bitField0_ |= 0x00000800;
        numericPrecisionRadix_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional int32 numeric_precision_radix = 12;</code>
       * @return This builder for chaining.
       */
      public Builder clearNumericPrecisionRadix() {
        bitField0_ = (bitField0_ & ~0x00000800);
        numericPrecisionRadix_ = 0;
        onChanged();
        return this;
      }

      private int numericScale_ ;
      /**
       * <code>optional int32 numeric_scale = 13;</code>
       * @return Whether the numericScale field is set.
       */
      @java.lang.Override
      public boolean hasNumericScale() {
        return ((bitField0_ & 0x00001000) != 0);
      }
      /**
       * <code>optional int32 numeric_scale = 13;</code>
       * @return The numericScale.
       */
      @java.lang.Override
      public int getNumericScale() {
        return numericScale_;
      }
      /**
       * <code>optional int32 numeric_scale = 13;</code>
       * @param value The numericScale to set.
       * @return This builder for chaining.
       */
      public Builder setNumericScale(int value) {
        bitField0_ |= 0x00001000;
        numericScale_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional int32 numeric_scale = 13;</code>
       * @return This builder for chaining.
       */
      public Builder clearNumericScale() {
        bitField0_ = (bitField0_ & ~0x00001000);
        numericScale_ = 0;
        onChanged();
        return this;
      }

      private int dateTimePrecision_ ;
      /**
       * <code>optional int32 date_time_precision = 14;</code>
       * @return Whether the dateTimePrecision field is set.
       */
      @java.lang.Override
      public boolean hasDateTimePrecision() {
        return ((bitField0_ & 0x00002000) != 0);
      }
      /**
       * <code>optional int32 date_time_precision = 14;</code>
       * @return The dateTimePrecision.
       */
      @java.lang.Override
      public int getDateTimePrecision() {
        return dateTimePrecision_;
      }
      /**
       * <code>optional int32 date_time_precision = 14;</code>
       * @param value The dateTimePrecision to set.
       * @return This builder for chaining.
       */
      public Builder setDateTimePrecision(int value) {
        bitField0_ |= 0x00002000;
        dateTimePrecision_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional int32 date_time_precision = 14;</code>
       * @return This builder for chaining.
       */
      public Builder clearDateTimePrecision() {
        bitField0_ = (bitField0_ & ~0x00002000);
        dateTimePrecision_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object intervalType_ = "";
      /**
       * <code>optional string interval_type = 15;</code>
       * @return Whether the intervalType field is set.
       */
      public boolean hasIntervalType() {
        return ((bitField0_ & 0x00004000) != 0);
      }
      /**
       * <code>optional string interval_type = 15;</code>
       * @return The intervalType.
       */
      public java.lang.String getIntervalType() {
        java.lang.Object ref = intervalType_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            intervalType_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string interval_type = 15;</code>
       * @return The bytes for intervalType.
       */
      public com.google.protobuf.ByteString
          getIntervalTypeBytes() {
        java.lang.Object ref = intervalType_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          intervalType_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string interval_type = 15;</code>
       * @param value The intervalType to set.
       * @return This builder for chaining.
       */
      public Builder setIntervalType(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00004000;
        intervalType_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string interval_type = 15;</code>
       * @return This builder for chaining.
       */
      public Builder clearIntervalType() {
        bitField0_ = (bitField0_ & ~0x00004000);
        intervalType_ = getDefaultInstance().getIntervalType();
        onChanged();
        return this;
      }
      /**
       * <code>optional string interval_type = 15;</code>
       * @param value The bytes for intervalType to set.
       * @return This builder for chaining.
       */
      public Builder setIntervalTypeBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00004000;
        intervalType_ = value;
        onChanged();
        return this;
      }

      private int intervalPrecision_ ;
      /**
       * <code>optional int32 interval_precision = 16;</code>
       * @return Whether the intervalPrecision field is set.
       */
      @java.lang.Override
      public boolean hasIntervalPrecision() {
        return ((bitField0_ & 0x00008000) != 0);
      }
      /**
       * <code>optional int32 interval_precision = 16;</code>
       * @return The intervalPrecision.
       */
      @java.lang.Override
      public int getIntervalPrecision() {
        return intervalPrecision_;
      }
      /**
       * <code>optional int32 interval_precision = 16;</code>
       * @param value The intervalPrecision to set.
       * @return This builder for chaining.
       */
      public Builder setIntervalPrecision(int value) {
        bitField0_ |= 0x00008000;
        intervalPrecision_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional int32 interval_precision = 16;</code>
       * @return This builder for chaining.
       */
      public Builder clearIntervalPrecision() {
        bitField0_ = (bitField0_ & ~0x00008000);
        intervalPrecision_ = 0;
        onChanged();
        return this;
      }

      private int columnSize_ ;
      /**
       * <code>optional int32 column_size = 17;</code>
       * @return Whether the columnSize field is set.
       */
      @java.lang.Override
      public boolean hasColumnSize() {
        return ((bitField0_ & 0x00010000) != 0);
      }
      /**
       * <code>optional int32 column_size = 17;</code>
       * @return The columnSize.
       */
      @java.lang.Override
      public int getColumnSize() {
        return columnSize_;
      }
      /**
       * <code>optional int32 column_size = 17;</code>
       * @param value The columnSize to set.
       * @return This builder for chaining.
       */
      public Builder setColumnSize(int value) {
        bitField0_ |= 0x00010000;
        columnSize_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional int32 column_size = 17;</code>
       * @return This builder for chaining.
       */
      public Builder clearColumnSize() {
        bitField0_ = (bitField0_ & ~0x00010000);
        columnSize_ = 0;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:exec.user.ColumnMetadata)
    }

    // @@protoc_insertion_point(class_scope:exec.user.ColumnMetadata)
    private static final org.apache.drill.exec.proto.UserProtos.ColumnMetadata DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.drill.exec.proto.UserProtos.ColumnMetadata();
    }

    public static org.apache.drill.exec.proto.UserProtos.ColumnMetadata getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final com.google.protobuf.Parser<ColumnMetadata>
        PARSER = new com.google.protobuf.AbstractParser<ColumnMetadata>() {
      @java.lang.Override
      public ColumnMetadata parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<ColumnMetadata> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ColumnMetadata> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.drill.exec.proto.UserProtos.ColumnMetadata getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface GetColumnsRespOrBuilder extends
      // @@protoc_insertion_point(interface_extends:exec.user.GetColumnsResp)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>optional .exec.user.RequestStatus status = 1;</code>
     * @return Whether the status field is set.
     */
    boolean hasStatus();
    /**
     * <code>optional .exec.user.RequestStatus status = 1;</code>
     * @return The status.
     */
    org.apache.drill.exec.proto.UserProtos.RequestStatus getStatus();

    /**
     * <code>repeated .exec.user.ColumnMetadata columns = 2;</code>
     */
    java.util.List<org.apache.drill.exec.proto.UserProtos.ColumnMetadata> 
        getColumnsList();
    /**
     * <code>repeated .exec.user.ColumnMetadata columns = 2;</code>
     */
    org.apache.drill.exec.proto.UserProtos.ColumnMetadata getColumns(int index);
    /**
     * <code>repeated .exec.user.ColumnMetadata columns = 2;</code>
     */
    int getColumnsCount();
    /**
     * <code>repeated .exec.user.ColumnMetadata columns = 2;</code>
     */
    java.util.List<? extends org.apache.drill.exec.proto.UserProtos.ColumnMetadataOrBuilder> 
        getColumnsOrBuilderList();
    /**
     * <code>repeated .exec.user.ColumnMetadata columns = 2;</code>
     */
    org.apache.drill.exec.proto.UserProtos.ColumnMetadataOrBuilder getColumnsOrBuilder(
        int index);

    /**
     * <code>optional .exec.shared.DrillPBError error = 3;</code>
     * @return Whether the error field is set.
     */
    boolean hasError();
    /**
     * <code>optional .exec.shared.DrillPBError error = 3;</code>
     * @return The error.
     */
    org.apache.drill.exec.proto.UserBitShared.DrillPBError getError();
    /**
     * <code>optional .exec.shared.DrillPBError error = 3;</code>
     */
    org.apache.drill.exec.proto.UserBitShared.DrillPBErrorOrBuilder getErrorOrBuilder();
  }
  /**
   * <pre>
   * Response message for GetColumnsReq.
   * </pre>
   *
   * Protobuf type {@code exec.user.GetColumnsResp}
   */
  public static final class GetColumnsResp extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:exec.user.GetColumnsResp)
      GetColumnsRespOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use GetColumnsResp.newBuilder() to construct.
    private GetColumnsResp(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private GetColumnsResp() {
      status_ = 0;
      columns_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new GetColumnsResp();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetColumnsResp_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetColumnsResp_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.UserProtos.GetColumnsResp.class, org.apache.drill.exec.proto.UserProtos.GetColumnsResp.Builder.class);
    }

    private int bitField0_;
    public static final int STATUS_FIELD_NUMBER = 1;
    private int status_;
    /**
     * <code>optional .exec.user.RequestStatus status = 1;</code>
     * @return Whether the status field is set.
     */
    @java.lang.Override public boolean hasStatus() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>optional .exec.user.RequestStatus status = 1;</code>
     * @return The status.
     */
    @java.lang.Override public org.apache.drill.exec.proto.UserProtos.RequestStatus getStatus() {
      @SuppressWarnings("deprecation")
      org.apache.drill.exec.proto.UserProtos.RequestStatus result = org.apache.drill.exec.proto.UserProtos.RequestStatus.valueOf(status_);
      return result == null ? org.apache.drill.exec.proto.UserProtos.RequestStatus.UNKNOWN_STATUS : result;
    }

    public static final int COLUMNS_FIELD_NUMBER = 2;
    private java.util.List<org.apache.drill.exec.proto.UserProtos.ColumnMetadata> columns_;
    /**
     * <code>repeated .exec.user.ColumnMetadata columns = 2;</code>
     */
    @java.lang.Override
    public java.util.List<org.apache.drill.exec.proto.UserProtos.ColumnMetadata> getColumnsList() {
      return columns_;
    }
    /**
     * <code>repeated .exec.user.ColumnMetadata columns = 2;</code>
     */
    @java.lang.Override
    public java.util.List<? extends org.apache.drill.exec.proto.UserProtos.ColumnMetadataOrBuilder> 
        getColumnsOrBuilderList() {
      return columns_;
    }
    /**
     * <code>repeated .exec.user.ColumnMetadata columns = 2;</code>
     */
    @java.lang.Override
    public int getColumnsCount() {
      return columns_.size();
    }
    /**
     * <code>repeated .exec.user.ColumnMetadata columns = 2;</code>
     */
    @java.lang.Override
    public org.apache.drill.exec.proto.UserProtos.ColumnMetadata getColumns(int index) {
      return columns_.get(index);
    }
    /**
     * <code>repeated .exec.user.ColumnMetadata columns = 2;</code>
     */
    @java.lang.Override
    public org.apache.drill.exec.proto.UserProtos.ColumnMetadataOrBuilder getColumnsOrBuilder(
        int index) {
      return columns_.get(index);
    }

    public static final int ERROR_FIELD_NUMBER = 3;
    private org.apache.drill.exec.proto.UserBitShared.DrillPBError error_;
    /**
     * <code>optional .exec.shared.DrillPBError error = 3;</code>
     * @return Whether the error field is set.
     */
    @java.lang.Override
    public boolean hasError() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <code>optional .exec.shared.DrillPBError error = 3;</code>
     * @return The error.
     */
    @java.lang.Override
    public org.apache.drill.exec.proto.UserBitShared.DrillPBError getError() {
      return error_ == null ? org.apache.drill.exec.proto.UserBitShared.DrillPBError.getDefaultInstance() : error_;
    }
    /**
     * <code>optional .exec.shared.DrillPBError error = 3;</code>
     */
    @java.lang.Override
    public org.apache.drill.exec.proto.UserBitShared.DrillPBErrorOrBuilder getErrorOrBuilder() {
      return error_ == null ? org.apache.drill.exec.proto.UserBitShared.DrillPBError.getDefaultInstance() : error_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeEnum(1, status_);
      }
      for (int i = 0; i < columns_.size(); i++) {
        output.writeMessage(2, columns_.get(i));
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(3, getError());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(1, status_);
      }
      for (int i = 0; i < columns_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, columns_.get(i));
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, getError());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.drill.exec.proto.UserProtos.GetColumnsResp)) {
        return super.equals(obj);
      }
      org.apache.drill.exec.proto.UserProtos.GetColumnsResp other = (org.apache.drill.exec.proto.UserProtos.GetColumnsResp) obj;

      if (hasStatus() != other.hasStatus()) return false;
      if (hasStatus()) {
        if (status_ != other.status_) return false;
      }
      if (!getColumnsList()
          .equals(other.getColumnsList())) return false;
      if (hasError() != other.hasError()) return false;
      if (hasError()) {
        if (!getError()
            .equals(other.getError())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasStatus()) {
        hash = (37 * hash) + STATUS_FIELD_NUMBER;
        hash = (53 * hash) + status_;
      }
      if (getColumnsCount() > 0) {
        hash = (37 * hash) + COLUMNS_FIELD_NUMBER;
        hash = (53 * hash) + getColumnsList().hashCode();
      }
      if (hasError()) {
        hash = (37 * hash) + ERROR_FIELD_NUMBER;
        hash = (53 * hash) + getError().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.drill.exec.proto.UserProtos.GetColumnsResp parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetColumnsResp parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetColumnsResp parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetColumnsResp parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetColumnsResp parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetColumnsResp parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetColumnsResp parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetColumnsResp parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetColumnsResp parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetColumnsResp parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetColumnsResp parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.GetColumnsResp parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.drill.exec.proto.UserProtos.GetColumnsResp prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Response message for GetColumnsReq.
     * </pre>
     *
     * Protobuf type {@code exec.user.GetColumnsResp}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:exec.user.GetColumnsResp)
        org.apache.drill.exec.proto.UserProtos.GetColumnsRespOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetColumnsResp_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetColumnsResp_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.UserProtos.GetColumnsResp.class, org.apache.drill.exec.proto.UserProtos.GetColumnsResp.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.UserProtos.GetColumnsResp.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getColumnsFieldBuilder();
          getErrorFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        status_ = 0;
        bitField0_ = (bitField0_ & ~0x00000001);
        if (columnsBuilder_ == null) {
          columns_ = java.util.Collections.emptyList();
        } else {
          columns_ = null;
          columnsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        if (errorBuilder_ == null) {
          error_ = null;
        } else {
          errorBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_GetColumnsResp_descriptor;
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.GetColumnsResp getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.UserProtos.GetColumnsResp.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.GetColumnsResp build() {
        org.apache.drill.exec.proto.UserProtos.GetColumnsResp result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.GetColumnsResp buildPartial() {
        org.apache.drill.exec.proto.UserProtos.GetColumnsResp result = new org.apache.drill.exec.proto.UserProtos.GetColumnsResp(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          to_bitField0_ |= 0x00000001;
        }
        result.status_ = status_;
        if (columnsBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            columns_ = java.util.Collections.unmodifiableList(columns_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.columns_ = columns_;
        } else {
          result.columns_ = columnsBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          if (errorBuilder_ == null) {
            result.error_ = error_;
          } else {
            result.error_ = errorBuilder_.build();
          }
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.UserProtos.GetColumnsResp) {
          return mergeFrom((org.apache.drill.exec.proto.UserProtos.GetColumnsResp)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.UserProtos.GetColumnsResp other) {
        if (other == org.apache.drill.exec.proto.UserProtos.GetColumnsResp.getDefaultInstance()) return this;
        if (other.hasStatus()) {
          setStatus(other.getStatus());
        }
        if (columnsBuilder_ == null) {
          if (!other.columns_.isEmpty()) {
            if (columns_.isEmpty()) {
              columns_ = other.columns_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureColumnsIsMutable();
              columns_.addAll(other.columns_);
            }
            onChanged();
          }
        } else {
          if (!other.columns_.isEmpty()) {
            if (columnsBuilder_.isEmpty()) {
              columnsBuilder_.dispose();
              columnsBuilder_ = null;
              columns_ = other.columns_;
              bitField0_ = (bitField0_ & ~0x00000002);
              columnsBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getColumnsFieldBuilder() : null;
            } else {
              columnsBuilder_.addAllMessages(other.columns_);
            }
          }
        }
        if (other.hasError()) {
          mergeError(other.getError());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8: {
                int tmpRaw = input.readEnum();
                org.apache.drill.exec.proto.UserProtos.RequestStatus tmpValue =
                    org.apache.drill.exec.proto.UserProtos.RequestStatus.forNumber(tmpRaw);
                if (tmpValue == null) {
                  mergeUnknownVarintField(1, tmpRaw);
                } else {
                  status_ = tmpRaw;
                  bitField0_ |= 0x00000001;
                }
                break;
              } // case 8
              case 18: {
                org.apache.drill.exec.proto.UserProtos.ColumnMetadata m =
                    input.readMessage(
                        org.apache.drill.exec.proto.UserProtos.ColumnMetadata.PARSER,
                        extensionRegistry);
                if (columnsBuilder_ == null) {
                  ensureColumnsIsMutable();
                  columns_.add(m);
                } else {
                  columnsBuilder_.addMessage(m);
                }
                break;
              } // case 18
              case 26: {
                input.readMessage(
                    getErrorFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private int status_ = 0;
      /**
       * <code>optional .exec.user.RequestStatus status = 1;</code>
       * @return Whether the status field is set.
       */
      @java.lang.Override public boolean hasStatus() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>optional .exec.user.RequestStatus status = 1;</code>
       * @return The status.
       */
      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.RequestStatus getStatus() {
        @SuppressWarnings("deprecation")
        org.apache.drill.exec.proto.UserProtos.RequestStatus result = org.apache.drill.exec.proto.UserProtos.RequestStatus.valueOf(status_);
        return result == null ? org.apache.drill.exec.proto.UserProtos.RequestStatus.UNKNOWN_STATUS : result;
      }
      /**
       * <code>optional .exec.user.RequestStatus status = 1;</code>
       * @param value The status to set.
       * @return This builder for chaining.
       */
      public Builder setStatus(org.apache.drill.exec.proto.UserProtos.RequestStatus value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        status_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <code>optional .exec.user.RequestStatus status = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearStatus() {
        bitField0_ = (bitField0_ & ~0x00000001);
        status_ = 0;
        onChanged();
        return this;
      }

      private java.util.List<org.apache.drill.exec.proto.UserProtos.ColumnMetadata> columns_ =
        java.util.Collections.emptyList();
      private void ensureColumnsIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          columns_ = new java.util.ArrayList<org.apache.drill.exec.proto.UserProtos.ColumnMetadata>(columns_);
          bitField0_ |= 0x00000002;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          org.apache.drill.exec.proto.UserProtos.ColumnMetadata, org.apache.drill.exec.proto.UserProtos.ColumnMetadata.Builder, org.apache.drill.exec.proto.UserProtos.ColumnMetadataOrBuilder> columnsBuilder_;

      /**
       * <code>repeated .exec.user.ColumnMetadata columns = 2;</code>
       */
      public java.util.List<org.apache.drill.exec.proto.UserProtos.ColumnMetadata> getColumnsList() {
        if (columnsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(columns_);
        } else {
          return columnsBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .exec.user.ColumnMetadata columns = 2;</code>
       */
      public int getColumnsCount() {
        if (columnsBuilder_ == null) {
          return columns_.size();
        } else {
          return columnsBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .exec.user.ColumnMetadata columns = 2;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.ColumnMetadata getColumns(int index) {
        if (columnsBuilder_ == null) {
          return columns_.get(index);
        } else {
          return columnsBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .exec.user.ColumnMetadata columns = 2;</code>
       */
      public Builder setColumns(
          int index, org.apache.drill.exec.proto.UserProtos.ColumnMetadata value) {
        if (columnsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureColumnsIsMutable();
          columns_.set(index, value);
          onChanged();
        } else {
          columnsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.ColumnMetadata columns = 2;</code>
       */
      public Builder setColumns(
          int index, org.apache.drill.exec.proto.UserProtos.ColumnMetadata.Builder builderForValue) {
        if (columnsBuilder_ == null) {
          ensureColumnsIsMutable();
          columns_.set(index, builderForValue.build());
          onChanged();
        } else {
          columnsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.ColumnMetadata columns = 2;</code>
       */
      public Builder addColumns(org.apache.drill.exec.proto.UserProtos.ColumnMetadata value) {
        if (columnsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureColumnsIsMutable();
          columns_.add(value);
          onChanged();
        } else {
          columnsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.ColumnMetadata columns = 2;</code>
       */
      public Builder addColumns(
          int index, org.apache.drill.exec.proto.UserProtos.ColumnMetadata value) {
        if (columnsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureColumnsIsMutable();
          columns_.add(index, value);
          onChanged();
        } else {
          columnsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.ColumnMetadata columns = 2;</code>
       */
      public Builder addColumns(
          org.apache.drill.exec.proto.UserProtos.ColumnMetadata.Builder builderForValue) {
        if (columnsBuilder_ == null) {
          ensureColumnsIsMutable();
          columns_.add(builderForValue.build());
          onChanged();
        } else {
          columnsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.ColumnMetadata columns = 2;</code>
       */
      public Builder addColumns(
          int index, org.apache.drill.exec.proto.UserProtos.ColumnMetadata.Builder builderForValue) {
        if (columnsBuilder_ == null) {
          ensureColumnsIsMutable();
          columns_.add(index, builderForValue.build());
          onChanged();
        } else {
          columnsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.ColumnMetadata columns = 2;</code>
       */
      public Builder addAllColumns(
          java.lang.Iterable<? extends org.apache.drill.exec.proto.UserProtos.ColumnMetadata> values) {
        if (columnsBuilder_ == null) {
          ensureColumnsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, columns_);
          onChanged();
        } else {
          columnsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.ColumnMetadata columns = 2;</code>
       */
      public Builder clearColumns() {
        if (columnsBuilder_ == null) {
          columns_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          columnsBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.ColumnMetadata columns = 2;</code>
       */
      public Builder removeColumns(int index) {
        if (columnsBuilder_ == null) {
          ensureColumnsIsMutable();
          columns_.remove(index);
          onChanged();
        } else {
          columnsBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.ColumnMetadata columns = 2;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.ColumnMetadata.Builder getColumnsBuilder(
          int index) {
        return getColumnsFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .exec.user.ColumnMetadata columns = 2;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.ColumnMetadataOrBuilder getColumnsOrBuilder(
          int index) {
        if (columnsBuilder_ == null) {
          return columns_.get(index);  } else {
          return columnsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .exec.user.ColumnMetadata columns = 2;</code>
       */
      public java.util.List<? extends org.apache.drill.exec.proto.UserProtos.ColumnMetadataOrBuilder> 
           getColumnsOrBuilderList() {
        if (columnsBuilder_ != null) {
          return columnsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(columns_);
        }
      }
      /**
       * <code>repeated .exec.user.ColumnMetadata columns = 2;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.ColumnMetadata.Builder addColumnsBuilder() {
        return getColumnsFieldBuilder().addBuilder(
            org.apache.drill.exec.proto.UserProtos.ColumnMetadata.getDefaultInstance());
      }
      /**
       * <code>repeated .exec.user.ColumnMetadata columns = 2;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.ColumnMetadata.Builder addColumnsBuilder(
          int index) {
        return getColumnsFieldBuilder().addBuilder(
            index, org.apache.drill.exec.proto.UserProtos.ColumnMetadata.getDefaultInstance());
      }
      /**
       * <code>repeated .exec.user.ColumnMetadata columns = 2;</code>
       */
      public java.util.List<org.apache.drill.exec.proto.UserProtos.ColumnMetadata.Builder> 
           getColumnsBuilderList() {
        return getColumnsFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          org.apache.drill.exec.proto.UserProtos.ColumnMetadata, org.apache.drill.exec.proto.UserProtos.ColumnMetadata.Builder, org.apache.drill.exec.proto.UserProtos.ColumnMetadataOrBuilder> 
          getColumnsFieldBuilder() {
        if (columnsBuilder_ == null) {
          columnsBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              org.apache.drill.exec.proto.UserProtos.ColumnMetadata, org.apache.drill.exec.proto.UserProtos.ColumnMetadata.Builder, org.apache.drill.exec.proto.UserProtos.ColumnMetadataOrBuilder>(
                  columns_,
                  ((bitField0_ & 0x00000002) != 0),
                  getParentForChildren(),
                  isClean());
          columns_ = null;
        }
        return columnsBuilder_;
      }

      private org.apache.drill.exec.proto.UserBitShared.DrillPBError error_;
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.drill.exec.proto.UserBitShared.DrillPBError, org.apache.drill.exec.proto.UserBitShared.DrillPBError.Builder, org.apache.drill.exec.proto.UserBitShared.DrillPBErrorOrBuilder> errorBuilder_;
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       * @return Whether the error field is set.
       */
      public boolean hasError() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       * @return The error.
       */
      public org.apache.drill.exec.proto.UserBitShared.DrillPBError getError() {
        if (errorBuilder_ == null) {
          return error_ == null ? org.apache.drill.exec.proto.UserBitShared.DrillPBError.getDefaultInstance() : error_;
        } else {
          return errorBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       */
      public Builder setError(org.apache.drill.exec.proto.UserBitShared.DrillPBError value) {
        if (errorBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          error_ = value;
          onChanged();
        } else {
          errorBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       */
      public Builder setError(
          org.apache.drill.exec.proto.UserBitShared.DrillPBError.Builder builderForValue) {
        if (errorBuilder_ == null) {
          error_ = builderForValue.build();
          onChanged();
        } else {
          errorBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       */
      public Builder mergeError(org.apache.drill.exec.proto.UserBitShared.DrillPBError value) {
        if (errorBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0) &&
              error_ != null &&
              error_ != org.apache.drill.exec.proto.UserBitShared.DrillPBError.getDefaultInstance()) {
            error_ =
              org.apache.drill.exec.proto.UserBitShared.DrillPBError.newBuilder(error_).mergeFrom(value).buildPartial();
          } else {
            error_ = value;
          }
          onChanged();
        } else {
          errorBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       */
      public Builder clearError() {
        if (errorBuilder_ == null) {
          error_ = null;
          onChanged();
        } else {
          errorBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.DrillPBError.Builder getErrorBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getErrorFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.DrillPBErrorOrBuilder getErrorOrBuilder() {
        if (errorBuilder_ != null) {
          return errorBuilder_.getMessageOrBuilder();
        } else {
          return error_ == null ?
              org.apache.drill.exec.proto.UserBitShared.DrillPBError.getDefaultInstance() : error_;
        }
      }
      /**
       * <code>optional .exec.shared.DrillPBError error = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.drill.exec.proto.UserBitShared.DrillPBError, org.apache.drill.exec.proto.UserBitShared.DrillPBError.Builder, org.apache.drill.exec.proto.UserBitShared.DrillPBErrorOrBuilder> 
          getErrorFieldBuilder() {
        if (errorBuilder_ == null) {
          errorBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.apache.drill.exec.proto.UserBitShared.DrillPBError, org.apache.drill.exec.proto.UserBitShared.DrillPBError.Builder, org.apache.drill.exec.proto.UserBitShared.DrillPBErrorOrBuilder>(
                  getError(),
                  getParentForChildren(),
                  isClean());
          error_ = null;
        }
        return errorBuilder_;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:exec.user.GetColumnsResp)
    }

    // @@protoc_insertion_point(class_scope:exec.user.GetColumnsResp)
    private static final org.apache.drill.exec.proto.UserProtos.GetColumnsResp DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.drill.exec.proto.UserProtos.GetColumnsResp();
    }

    public static org.apache.drill.exec.proto.UserProtos.GetColumnsResp getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final com.google.protobuf.Parser<GetColumnsResp>
        PARSER = new com.google.protobuf.AbstractParser<GetColumnsResp>() {
      @java.lang.Override
      public GetColumnsResp parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<GetColumnsResp> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GetColumnsResp> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.drill.exec.proto.UserProtos.GetColumnsResp getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface CreatePreparedStatementReqOrBuilder extends
      // @@protoc_insertion_point(interface_extends:exec.user.CreatePreparedStatementReq)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>optional string sql_query = 1;</code>
     * @return Whether the sqlQuery field is set.
     */
    boolean hasSqlQuery();
    /**
     * <code>optional string sql_query = 1;</code>
     * @return The sqlQuery.
     */
    java.lang.String getSqlQuery();
    /**
     * <code>optional string sql_query = 1;</code>
     * @return The bytes for sqlQuery.
     */
    com.google.protobuf.ByteString
        getSqlQueryBytes();
  }
  /**
   * <pre>
   * Request message to create a prepared statement. Currently prepared
   * statement only accepts a SQL query. Query parameter support is not
   * included in current implementation.
   * </pre>
   *
   * Protobuf type {@code exec.user.CreatePreparedStatementReq}
   */
  public static final class CreatePreparedStatementReq extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:exec.user.CreatePreparedStatementReq)
      CreatePreparedStatementReqOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use CreatePreparedStatementReq.newBuilder() to construct.
    private CreatePreparedStatementReq(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private CreatePreparedStatementReq() {
      sqlQuery_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new CreatePreparedStatementReq();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_CreatePreparedStatementReq_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_CreatePreparedStatementReq_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq.class, org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq.Builder.class);
    }

    private int bitField0_;
    public static final int SQL_QUERY_FIELD_NUMBER = 1;
    private volatile java.lang.Object sqlQuery_;
    /**
     * <code>optional string sql_query = 1;</code>
     * @return Whether the sqlQuery field is set.
     */
    @java.lang.Override
    public boolean hasSqlQuery() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>optional string sql_query = 1;</code>
     * @return The sqlQuery.
     */
    @java.lang.Override
    public java.lang.String getSqlQuery() {
      java.lang.Object ref = sqlQuery_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          sqlQuery_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string sql_query = 1;</code>
     * @return The bytes for sqlQuery.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getSqlQueryBytes() {
      java.lang.Object ref = sqlQuery_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        sqlQuery_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, sqlQuery_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, sqlQuery_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq)) {
        return super.equals(obj);
      }
      org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq other = (org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq) obj;

      if (hasSqlQuery() != other.hasSqlQuery()) return false;
      if (hasSqlQuery()) {
        if (!getSqlQuery()
            .equals(other.getSqlQuery())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasSqlQuery()) {
        hash = (37 * hash) + SQL_QUERY_FIELD_NUMBER;
        hash = (53 * hash) + getSqlQuery().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Request message to create a prepared statement. Currently prepared
     * statement only accepts a SQL query. Query parameter support is not
     * included in current implementation.
     * </pre>
     *
     * Protobuf type {@code exec.user.CreatePreparedStatementReq}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:exec.user.CreatePreparedStatementReq)
        org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReqOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_CreatePreparedStatementReq_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_CreatePreparedStatementReq_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq.class, org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        sqlQuery_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_CreatePreparedStatementReq_descriptor;
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq build() {
        org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq buildPartial() {
        org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq result = new org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          to_bitField0_ |= 0x00000001;
        }
        result.sqlQuery_ = sqlQuery_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq) {
          return mergeFrom((org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq other) {
        if (other == org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq.getDefaultInstance()) return this;
        if (other.hasSqlQuery()) {
          bitField0_ |= 0x00000001;
          sqlQuery_ = other.sqlQuery_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                sqlQuery_ = input.readBytes();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private java.lang.Object sqlQuery_ = "";
      /**
       * <code>optional string sql_query = 1;</code>
       * @return Whether the sqlQuery field is set.
       */
      public boolean hasSqlQuery() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>optional string sql_query = 1;</code>
       * @return The sqlQuery.
       */
      public java.lang.String getSqlQuery() {
        java.lang.Object ref = sqlQuery_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            sqlQuery_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string sql_query = 1;</code>
       * @return The bytes for sqlQuery.
       */
      public com.google.protobuf.ByteString
          getSqlQueryBytes() {
        java.lang.Object ref = sqlQuery_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          sqlQuery_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string sql_query = 1;</code>
       * @param value The sqlQuery to set.
       * @return This builder for chaining.
       */
      public Builder setSqlQuery(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        sqlQuery_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string sql_query = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearSqlQuery() {
        bitField0_ = (bitField0_ & ~0x00000001);
        sqlQuery_ = getDefaultInstance().getSqlQuery();
        onChanged();
        return this;
      }
      /**
       * <code>optional string sql_query = 1;</code>
       * @param value The bytes for sqlQuery to set.
       * @return This builder for chaining.
       */
      public Builder setSqlQueryBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        sqlQuery_ = value;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:exec.user.CreatePreparedStatementReq)
    }

    // @@protoc_insertion_point(class_scope:exec.user.CreatePreparedStatementReq)
    private static final org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq();
    }

    public static org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final com.google.protobuf.Parser<CreatePreparedStatementReq>
        PARSER = new com.google.protobuf.AbstractParser<CreatePreparedStatementReq>() {
      @java.lang.Override
      public CreatePreparedStatementReq parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<CreatePreparedStatementReq> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CreatePreparedStatementReq> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.drill.exec.proto.UserProtos.CreatePreparedStatementReq getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ResultColumnMetadataOrBuilder extends
      // @@protoc_insertion_point(interface_extends:exec.user.ResultColumnMetadata)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Designated column's catalog name. Empty string if not applicable.
     * Defaults to "DRILL" as drill has only one catalog.
     * </pre>
     *
     * <code>optional string catalog_name = 1;</code>
     * @return Whether the catalogName field is set.
     */
    boolean hasCatalogName();
    /**
     * <pre>
     * Designated column's catalog name. Empty string if not applicable.
     * Defaults to "DRILL" as drill has only one catalog.
     * </pre>
     *
     * <code>optional string catalog_name = 1;</code>
     * @return The catalogName.
     */
    java.lang.String getCatalogName();
    /**
     * <pre>
     * Designated column's catalog name. Empty string if not applicable.
     * Defaults to "DRILL" as drill has only one catalog.
     * </pre>
     *
     * <code>optional string catalog_name = 1;</code>
     * @return The bytes for catalogName.
     */
    com.google.protobuf.ByteString
        getCatalogNameBytes();

    /**
     * <pre>
     * Designated column's schema name. Not set if not applicable. Initial implementation
     * defaults to no value as we use LIMIT 0 queries to get the schema and schema info
     * is lost. If we derive the schema from plan, we may get the right value.
     * </pre>
     *
     * <code>optional string schema_name = 2;</code>
     * @return Whether the schemaName field is set.
     */
    boolean hasSchemaName();
    /**
     * <pre>
     * Designated column's schema name. Not set if not applicable. Initial implementation
     * defaults to no value as we use LIMIT 0 queries to get the schema and schema info
     * is lost. If we derive the schema from plan, we may get the right value.
     * </pre>
     *
     * <code>optional string schema_name = 2;</code>
     * @return The schemaName.
     */
    java.lang.String getSchemaName();
    /**
     * <pre>
     * Designated column's schema name. Not set if not applicable. Initial implementation
     * defaults to no value as we use LIMIT 0 queries to get the schema and schema info
     * is lost. If we derive the schema from plan,