/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.app;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.ExceptionQueuedEvent;
import javax.faces.event.ExceptionQueuedEventContext;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.context.DBRollbackManager;
import org.apache.empire.exceptions.EmpireException;
import org.apache.empire.exceptions.InternalException;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.InvalidOperationException;
import org.apache.empire.exceptions.NotSupportedException;
import org.apache.empire.exceptions.UnexpectedReturnValueException;
import org.apache.empire.jsf2.app.FacesUtils;
import org.apache.empire.jsf2.app.TextResolver;
import org.apache.empire.jsf2.impl.FacesImplementation;
import org.apache.empire.jsf2.impl.ResourceTextResolver;
import org.apache.empire.jsf2.pages.Page;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WebApplication {
    private static final Logger log = LoggerFactory.getLogger(WebApplication.class);
    private static final String REQUEST_CONNECTION_MAP = "requestConnectionMap";
    private static final String CONN_ROLLBACK_MANAGER = "connRollbackManager";
    public static String APPLICATION_BEAN_NAME = "webApplication";
    protected TextResolver[] textResolvers = null;
    private String webRoot = null;
    private FacesImplementation facesImpl = null;
    private static WebApplication appInstance = null;

    public static <T extends WebApplication> T getInstance() {
        if (appInstance == null) {
            log.warn("No WebApplication instance available. Please add a PostConstructApplicationEvent using WebAppStartupListener in your faces-config.xml to create the WebApplication object.");
        }
        return (T)appInstance;
    }

    protected abstract void init(ServletContext var1);

    protected abstract DataSource getAppDataSource(DBDatabase var1);

    protected WebApplication() {
        log.info("WebApplication {} created", (Object)this.getClass().getName());
        if (appInstance != null) {
            throw new RuntimeException("An attempt was made to create second instance of WebApplication. WebApplication must be a Singleton!");
        }
        appInstance = this;
    }

    public final void init(FacesImplementation facesImpl, FacesContext startupContext) {
        if (this.facesImpl != null || this.webRoot != null) {
            log.warn("WARNING: WebApplication has already been initialized! Continuing without init...");
            return;
        }
        this.facesImpl = facesImpl;
        ServletContext servletContext = (ServletContext)startupContext.getExternalContext().getContext();
        this.webRoot = servletContext.getContextPath();
        servletContext.setAttribute("webRoot", (Object)this.webRoot);
        servletContext.setAttribute("app", (Object)this);
        this.init(servletContext);
        if (this.textResolvers == null) {
            log.info("*** initTextResolvers() ***");
            this.initTextResolvers(startupContext.getApplication());
        }
        log.info("*** WebApplication initialization complete ***");
        log.info("JSF-Implementation is '{}'", (Object)facesImpl.getClass().getName());
        log.info("WebRoot is '{}'", (Object)this.webRoot);
    }

    public void destroy() {
    }

    public void onRequestComplete(FacesContext ctx) {
        this.releaseAllConnections(ctx);
    }

    public void onViewNotFound(FacesContext fc, HttpServletRequest req) {
        log.warn("No view found for request to '{}'. Use FacesUtils.redirectDirectly() to redirect to valid view.", (Object)req.getRequestURI());
        this.redirectDirectly(fc, "");
    }

    public void onChangeView(FacesContext fc, String viewId) {
        Map<String, Object> sm = FacesUtils.getSessionMap(fc);
        if (sm != null) {
            sm.remove("pageResources");
        }
    }

    public void addJavascriptCall(FacesContext fc, String function) {
        throw new NotSupportedException((Object)this, "addJavascriptCall");
    }

    public FacesImplementation getFacesImplementation() {
        return this.facesImpl;
    }

    public String getWebRoot() {
        return this.webRoot;
    }

    public Locale getContextLocale(FacesContext ctx) {
        Locale defaultLocale;
        Locale locale = defaultLocale = Locale.getDefault();
        UIViewRoot root = ctx.getViewRoot();
        if (null != root && null == (locale = root.getLocale())) {
            locale = defaultLocale;
        }
        return locale;
    }

    public TextResolver getTextResolver(Locale locale) {
        if (this.textResolvers == null || this.textResolvers.length == 0) {
            throw new NotSupportedException((Object)this, "getTextResolver");
        }
        for (int i = 0; i < this.textResolvers.length; ++i) {
            if (!locale.equals(this.textResolvers[i].getLocale())) continue;
            return this.textResolvers[i];
        }
        return this.textResolvers[0];
    }

    public TextResolver getTextResolver(FacesContext ctx) {
        return this.getTextResolver(this.getContextLocale(ctx));
    }

    public FacesMessage getFacesMessage(FacesContext ctx, FacesMessage.Severity severity, String msg, Object ... params) {
        TextResolver resolver = this.getTextResolver(this.getContextLocale(ctx));
        msg = resolver.resolveText(msg);
        if (params.length > 0) {
            for (int i = 0; i < params.length; ++i) {
                if (params[i] instanceof String) {
                    params[i] = resolver.resolveText((String)params[i]);
                    continue;
                }
                if (!(params[i] instanceof Integer) && !(params[i] instanceof Long)) continue;
                params[i] = String.valueOf(params[i]);
            }
            msg = MessageFormat.format(msg, params);
        }
        return new FacesMessage(severity, msg, null);
    }

    public FacesMessage getFacesErrorMessage(FacesContext ctx, String errorContext, Throwable t) {
        EmpireException e = t instanceof EmpireException ? (EmpireException)t : new InternalException(t);
        TextResolver tr = this.getTextResolver(ctx);
        String msg = tr.getExceptionMessage((Exception)e);
        String msgDetail = this.extractErrorMessageDetail(errorContext, t, 3);
        return new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, msgDetail);
    }

    protected String extractErrorMessageDetail(String errorContext, Throwable e, int stackTraceElements) {
        StringBuilder b = new StringBuilder();
        if (errorContext != null) {
            b.append(errorContext);
            b.append(": ");
        }
        b.append(e.toString());
        b.append("\r\nat:");
        StackTraceElement[] stack = e.getStackTrace();
        int len = stack.length > stackTraceElements ? stackTraceElements : stack.length;
        for (int i = 0; i < len; ++i) {
            b.append(stack[i].toString());
            b.append("\r\n");
        }
        return b.toString();
    }

    public boolean hasError(FacesContext fc) {
        Iterator msgIterator = fc.getMessages();
        if (msgIterator != null) {
            while (msgIterator.hasNext()) {
                FacesMessage.Severity fms = ((FacesMessage)msgIterator.next()).getSeverity();
                if (fms != FacesMessage.SEVERITY_ERROR && fms != FacesMessage.SEVERITY_FATAL) continue;
                return true;
            }
        }
        return false;
    }

    public void redirectDirectly(FacesContext fc, String url) {
        try {
            if (fc == null) {
                throw new InvalidArgumentException("fc", (Object)fc);
            }
            if (fc.getResponseComplete()) {
                throw new InvalidOperationException("Unable to redirect. Response is already complete!");
            }
            if (url == null) {
                url = "";
            }
            ExternalContext ec = fc.getExternalContext();
            String ctxPath = ec.getRequestContextPath();
            if (url.indexOf("://") > 0) {
                if (url.startsWith("http") && url.indexOf(ctxPath) > 0) {
                    log.warn("Redirect url \"{}\" contains protokoll and context-path. Please remove.", (Object)url);
                } else {
                    log.info("Redirecting to absolute url {}", (Object)url);
                }
            } else if (!url.startsWith(ctxPath)) {
                String sep = url.length() > 0 && url.charAt(0) != '/' ? "/" : null;
                url = StringUtils.concat((String[])new String[]{ctxPath, sep, url});
                log.debug("Redirecting to relative url {}", (Object)url);
            } else {
                log.warn("Redirect url \"{}\" already contains context-path. Please remove.", (Object)url);
            }
            ec.redirect(url);
            fc.responseComplete();
        }
        catch (IOException e) {
            log.error("Failed to redirect to {}", (Object)url, (Object)e);
        }
    }

    public void handleException(FacesContext context, Page source, Throwable e) {
        String origin = source != null ? source.getPageDefinition().getPageBeanName() : "[Unknown]";
        log.error("Fatal error of type {} from \"{}\": {}: {}", new Object[]{e.getClass().getName(), origin, e.getMessage()});
        if (source != null) {
            ExceptionQueuedEventContext event = new ExceptionQueuedEventContext(context, e, null, context.getCurrentPhaseId());
            event.getAttributes().put(ExceptionQueuedEventContext.IN_BEFORE_PHASE_KEY, Boolean.TRUE);
            context.getApplication().publishEvent(context, ExceptionQueuedEvent.class, (Object)event);
            context.getExceptionHandler().handle();
            if (context.getResponseComplete()) {
                return;
            }
        }
        this.redirectDirectly(context, "");
    }

    public boolean isPartialSubmit(FacesContext fc) {
        return false;
    }

    public String getPartialSubmitComponentId(FacesContext fc) {
        Map parameterMap = fc.getExternalContext().getRequestParameterMap();
        return (String)parameterMap.get("javax.faces.source");
    }

    public UIComponent findComponent(FacesContext fc, String componentId, UIComponent nearComponent) {
        if (StringUtils.isEmpty((String)componentId)) {
            throw new InvalidArgumentException("componentId", (Object)componentId);
        }
        UIComponent component = null;
        if (nearComponent != null && (component = nearComponent.findComponent(componentId)) == null) {
            UIComponent nextParent = nearComponent;
            do {
                for (nextParent = nextParent.getParent(); nextParent != null && !(nextParent instanceof NamingContainer); nextParent = nextParent.getParent()) {
                }
            } while (nextParent != null && (component = nextParent.findComponent(componentId)) == null);
        }
        if (component == null) {
            component = WebApplication.findChildComponent((UIComponent)fc.getViewRoot(), componentId);
        }
        return component;
    }

    public static UIComponent findChildComponent(UIComponent parent, String componentId) {
        UIComponent component = null;
        if (parent.getChildCount() == 0) {
            return null;
        }
        for (UIComponent nextChild : parent.getChildren()) {
            if (nextChild instanceof NamingContainer) {
                component = nextChild.findComponent(componentId);
            }
            if (component == null) {
                component = WebApplication.findChildComponent(nextChild, componentId);
            }
            if (component == null) continue;
            break;
        }
        return component;
    }

    public String getDefaultControlType(DataType dataType) {
        switch (dataType) {
            case CLOB: {
                return "textarea";
            }
        }
        return "text";
    }

    protected void initTextResolvers(Application app) {
        int count = 0;
        Iterator locales = app.getSupportedLocales();
        count = 0;
        while (locales.hasNext()) {
            locales.next();
            ++count;
        }
        String messageBundle = app.getMessageBundle();
        this.textResolvers = new TextResolver[count];
        locales = app.getSupportedLocales();
        int i = 0;
        while (locales.hasNext()) {
            Locale locale = (Locale)locales.next();
            this.textResolvers[i] = new ResourceTextResolver(ResourceBundle.getBundle(messageBundle, locale));
            log.info("added TextResolver for {} bundle='{}'", (Object)locale.getLanguage(), (Object)messageBundle);
            ++i;
        }
    }

    protected Connection getConnection(DBDatabase db) {
        try {
            Connection conn = this.getAppDataSource(db).getConnection();
            conn.setAutoCommit(false);
            log.trace("Connection {} obtained from pool", (Object)conn.hashCode());
            return conn;
        }
        catch (SQLException e) {
            log.error("Failed to get connection from pool.", (Throwable)e);
            throw new InternalException((Throwable)e);
        }
    }

    protected void releaseConnection(Connection conn, boolean commit, DBRollbackManager dbrm) {
        try {
            if (conn == null) {
                return;
            }
            log.trace("releasing Connection {}", (Object)conn.hashCode());
            if (commit) {
                if (dbrm != null) {
                    dbrm.releaseConnection(conn, DBRollbackManager.ReleaseAction.Discard);
                }
                conn.commit();
                log.debug("REQUEST commited.");
            } else {
                conn.rollback();
                if (dbrm != null) {
                    dbrm.releaseConnection(conn, DBRollbackManager.ReleaseAction.Rollback);
                }
                log.debug("REQUEST rolled back.");
            }
            conn.close();
            if (log.isDebugEnabled()) {
                log.debug("REQUEST returned connection to pool.");
            }
        }
        catch (SQLException e) {
            log.error("Error releasing connection", (Throwable)e);
            e.printStackTrace();
        }
    }

    public DBRollbackManager getRollbackManagerForRequest(FacesContext fc, boolean create) {
        DBRollbackManager dbrm = (DBRollbackManager)FacesUtils.getRequestAttribute(fc, CONN_ROLLBACK_MANAGER);
        if (dbrm == null && create) {
            dbrm = new DBRollbackManager(1, 8);
            FacesUtils.setRequestAttribute(fc, CONN_ROLLBACK_MANAGER, dbrm);
        }
        return dbrm;
    }

    public Connection getConnectionForRequest(FacesContext fc, DBDatabase db, boolean create) {
        if (fc == null) {
            throw new InvalidArgumentException("FacesContext", (Object)fc);
        }
        if (db == null) {
            throw new InvalidArgumentException("DBDatabase", (Object)db);
        }
        HashMap<DBDatabase, Connection> connMap = (HashMap<DBDatabase, Connection>)FacesUtils.getRequestAttribute(fc, REQUEST_CONNECTION_MAP);
        if (connMap == null && create) {
            connMap = new HashMap<DBDatabase, Connection>(1);
            FacesUtils.setRequestAttribute(fc, REQUEST_CONNECTION_MAP, connMap);
        } else if (connMap == null) {
            return null;
        }
        Connection conn = (Connection)connMap.get(db);
        if (conn == null && create) {
            conn = this.getConnection(db);
            if (conn == null) {
                throw new UnexpectedReturnValueException((Object)this, "getConnection");
            }
            connMap.put(db, conn);
        }
        return conn;
    }

    public void releaseAllConnections(FacesContext fc, boolean commit) {
        Map connMap = (Map)FacesUtils.getRequestAttribute(fc, REQUEST_CONNECTION_MAP);
        if (connMap == null) {
            return;
        }
        DBRollbackManager dbrm = this.getRollbackManagerForRequest(fc, false);
        for (Connection conn : connMap.values()) {
            this.releaseConnection(conn, commit, dbrm);
        }
        FacesUtils.setRequestAttribute(fc, REQUEST_CONNECTION_MAP, null);
    }

    public void releaseAllConnections(FacesContext fc) {
        this.releaseAllConnections(fc, !this.hasError(fc));
    }

    public void releaseConnection(FacesContext fc, DBDatabase db, boolean commit) {
        Map connMap = (Map)FacesUtils.getRequestAttribute(fc, REQUEST_CONNECTION_MAP);
        if (connMap == null || !connMap.containsKey(db)) {
            return;
        }
        DBRollbackManager dbrm = this.getRollbackManagerForRequest(fc, false);
        Connection conn = (Connection)connMap.get(db);
        this.releaseConnection(conn, commit, dbrm);
        connMap.remove(db);
    }

    public void releaseConnection(FacesContext fc, DBDatabase db) {
        this.releaseConnection(fc, db, !this.hasError(fc));
    }
}

