/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.components;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.html.HtmlOutputLabel;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.context.FacesContext;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.jsf2.utils.TagEncodingHelper;
import org.apache.empire.jsf2.utils.TagEncodingHelperFactory;
import org.apache.empire.jsf2.utils.TagStyleClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabelTag
extends UIOutput {
    private static final Logger log = LoggerFactory.getLogger(LabelTag.class);
    protected final TagEncodingHelper helper = TagEncodingHelperFactory.create(this, TagStyleClass.LABEL.get());
    private boolean creatingComponents = false;
    private String treeClientId = null;

    public LabelTag() {
        log.trace("component LabelTag created");
    }

    public String getFamily() {
        return "javax.faces.NamingContainer";
    }

    public boolean visitTree(VisitContext visitContext, VisitCallback callback) {
        FacesContext context = visitContext.getFacesContext();
        this.treeClientId = this.getClientId(context);
        return super.visitTree(visitContext, callback);
    }

    public String getClientId(FacesContext context) {
        if (this.treeClientId != null && this.creatingComponents) {
            return this.treeClientId;
        }
        return super.getClientId(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encodeBegin(FacesContext context) throws IOException {
        String forInput;
        super.encodeBegin(context);
        HtmlOutputLabel labelComponent = null;
        if (this.getChildCount() > 0) {
            labelComponent = (HtmlOutputLabel)this.getChildren().get(0);
            forInput = this.helper.getTagAttributeString("for");
            this.helper.updateLabelComponent(context, labelComponent, forInput);
        }
        if (labelComponent == null) {
            try {
                this.creatingComponents = true;
                forInput = this.helper.getTagAttributeString("for");
                String styleClass = this.helper.getTagStyleClass(null, null);
                String style = this.helper.getTagAttributeString("style");
                labelComponent = this.helper.createLabelComponent(context, forInput, styleClass, style, this.getColon());
                this.getChildren().add(labelComponent);
                this.helper.resetComponentId((UIComponent)labelComponent);
            }
            finally {
                this.creatingComponents = false;
            }
        }
        labelComponent.encodeAll(context);
    }

    protected boolean getColon() {
        Object colon = this.getAttributes().get("colon");
        if (colon != null) {
            return ObjectUtils.getBoolean(colon);
        }
        return true;
    }
}

