/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.components;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.jsf2.utils.TagEncodingHelper;
import org.apache.empire.jsf2.utils.TagEncodingHelperFactory;
import org.apache.empire.jsf2.utils.TagStyleClass;

public class MenuListTag
extends UIOutput {
    protected final TagEncodingHelper helper = TagEncodingHelperFactory.create(this, TagStyleClass.MENU.get());
    protected String currentId = null;
    protected String currentClass = null;
    protected String parentClass = null;
    protected String disabledClass = null;
    protected String expandedClass = null;
    protected String itemWrapTag = null;
    protected String defaultItemClass = null;
    protected int level = 0;
    private MenuListTag parentMenu = null;

    public String getFamily() {
        return "javax.faces.NamingContainer";
    }

    public void encodeBegin(FacesContext context) throws IOException {
        super.encodeBegin(context);
        this.initMenuAttributes(context);
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("ul", (UIComponent)this);
        this.helper.writeComponentId(writer);
        this.helper.writeAttribute(writer, "class", this.getMenuStyleClass());
        this.helper.writeAttribute(writer, "style", this.helper.getTagAttributeString("style"));
    }

    public boolean getRendersChildren() {
        boolean test = super.getRendersChildren();
        return test;
    }

    public void encodeChildren(FacesContext context) throws IOException {
        super.encodeChildren(context);
    }

    public void encodeEnd(FacesContext context) throws IOException {
        super.encodeEnd(context);
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("ul");
    }

    protected void initMenuAttributes(FacesContext context) {
        this.currentId = this.helper.getTagAttributeString(MenuProperty.currentId.name());
        this.currentClass = this.helper.getTagAttributeString(MenuProperty.currentClass.name());
        this.parentClass = this.helper.getTagAttributeString(MenuProperty.parentClass.name());
        this.disabledClass = this.helper.getTagAttributeString(MenuProperty.disabledClass.name());
        this.expandedClass = this.helper.getTagAttributeString(MenuProperty.expandedClass.name());
        this.itemWrapTag = this.helper.getTagAttributeString(MenuProperty.itemWrapTag.name());
        this.defaultItemClass = this.helper.getTagAttributeString(MenuProperty.defaultItemClass.name());
        if (this.parentMenu == null) {
            this.parentMenu = this.findParentMenu();
        }
        if (this.parentMenu == null) {
            if (this.currentClass == null) {
                this.currentClass = "current";
            }
            if (this.parentClass == null) {
                this.parentClass = "parent";
            }
            if (this.disabledClass == null) {
                this.disabledClass = "parent";
            }
            if (this.expandedClass == null) {
                this.expandedClass = "expanded";
            }
            this.level = 0;
        } else {
            if (this.currentId == null) {
                this.currentId = this.parentMenu.getCurrentItemId();
            }
            if (this.currentClass == null) {
                this.currentClass = this.parentMenu.getCurrentItemClass();
            }
            if (this.parentClass == null) {
                this.parentClass = this.parentMenu.getParentItemClass();
            }
            if (this.disabledClass == null) {
                this.disabledClass = this.parentMenu.getItemDisabledClass();
            }
            if (this.expandedClass == null) {
                this.expandedClass = this.parentMenu.getItemExpandedClass();
            }
            if (this.itemWrapTag == null) {
                this.itemWrapTag = this.parentMenu.getItemWrapperTagName();
            }
            if (this.defaultItemClass == null) {
                this.defaultItemClass = this.parentMenu.defaultItemClass;
            }
            this.level = this.parentMenu.level + 1;
        }
    }

    public String getCurrentItemId() {
        return this.currentId;
    }

    public String getCurrentItemClass() {
        return this.currentClass;
    }

    public String getParentItemClass() {
        return this.parentClass;
    }

    public String getItemDisabledClass() {
        return this.disabledClass;
    }

    public String getItemExpandedClass() {
        return this.expandedClass;
    }

    public String getItemWrapperTagName() {
        return this.itemWrapTag;
    }

    public int getLevel() {
        return this.level;
    }

    public String getMenuStyleClass() {
        String styleClass = this.helper.getTagAttributeString("styleClass");
        if (styleClass != null && styleClass.indexOf("{}") > 0) {
            styleClass = StringUtils.replace((String)styleClass, (String)"{}", (String)String.valueOf(this.level));
        }
        return styleClass;
    }

    public String getItemStyleClass() {
        if (this.defaultItemClass != null && this.defaultItemClass.indexOf("{}") > 0) {
            return StringUtils.replace((String)this.defaultItemClass, (String)"{}", (String)String.valueOf(this.level));
        }
        return this.defaultItemClass;
    }

    protected MenuListTag findParentMenu() {
        MenuListTag parent = this;
        while ((parent = parent.getParent()) != null) {
            if (!(parent instanceof MenuListTag)) continue;
            return parent;
        }
        return null;
    }

    private static enum MenuProperty {
        currentId,
        currentClass,
        parentClass,
        disabledClass,
        expandedClass,
        itemWrapTag,
        defaultItemClass;

    }
}

