/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.components;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.Column;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.jsf2.utils.TagEncodingHelper;
import org.apache.empire.jsf2.utils.TagEncodingHelperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnitTag
extends UIOutput {
    private static final Logger log = LoggerFactory.getLogger(UnitTag.class);
    public static final String SPAN_ELEM = "span";
    protected final TagEncodingHelper helper = TagEncodingHelperFactory.create(this, "eUnit");

    public UnitTag() {
        log.trace("component LabelTag created");
    }

    public String getFamily() {
        return "javax.faces.NamingContainer";
    }

    public void encodeBegin(FacesContext context) throws IOException {
        super.encodeBegin(context);
        Column column = this.helper.getColumn();
        if (column == null) {
            throw new InvalidArgumentException("column", (Object)column);
        }
        String unitLabel = StringUtils.toString((Object)column.getAttribute("format:unit"));
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement(SPAN_ELEM, (UIComponent)this);
        this.helper.writeAttribute(writer, "class", "eUnit");
        if (StringUtils.isNotEmpty((String)unitLabel)) {
            writer.append((CharSequence)unitLabel);
        }
        writer.endElement(SPAN_ELEM);
    }
}

