/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.controls;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIParameter;
import javax.faces.component.UISelectItems;
import javax.faces.component.UISelectOne;
import javax.faces.component.html.HtmlSelectOneListbox;
import javax.faces.component.html.HtmlSelectOneMenu;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.OptionEntry;
import org.apache.empire.commons.Options;
import org.apache.empire.data.Column;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.UnexpectedReturnValueException;
import org.apache.empire.jsf2.app.TextResolver;
import org.apache.empire.jsf2.controls.InputControl;
import org.apache.empire.jsf2.controls.InputControlManager;
import org.apache.empire.jsf2.utils.TagStyleClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectInputControl
extends InputControl {
    private static final Logger log = LoggerFactory.getLogger(SelectInputControl.class);
    public static final String COLATTR_ABBR_OPTIONS = "ABBR_OPTIONS";
    public static final String VALUE_EXPRESSION_TYPE = "VALUE_EXPRESSION_TYPE";
    public static final String FORMAT_SIZE = "size:";
    public static final String FORMAT_SIZE_ATTR = "format:size";
    public static final String NAME = "select";
    private final Class<? extends HtmlSelectOneMenu> menuComponentClass;
    private final Class<? extends HtmlSelectOneListbox> listComponentClass;

    public SelectInputControl(String name, Class<? extends HtmlSelectOneMenu> menuComponentClass, Class<? extends HtmlSelectOneListbox> listComponentClass) {
        super(name);
        this.menuComponentClass = menuComponentClass;
        this.listComponentClass = listComponentClass;
    }

    public SelectInputControl() {
        this(NAME, HtmlSelectOneMenu.class, HtmlSelectOneListbox.class);
    }

    public UISelectOne createSelectComponent(UIComponent parent, FacesContext context, Object formatSize) {
        int listSize = ObjectUtils.getInteger((Object)formatSize, (int)1);
        Class<Object> selectOneClass = listSize == -1 || listSize > 1 ? this.listComponentClass : this.menuComponentClass;
        UISelectOne selectOne = (UISelectOne)InputControlManager.createComponent(context, selectOneClass);
        if (selectOne instanceof HtmlSelectOneListbox && listSize > 1) {
            ((HtmlSelectOneListbox)selectOne).setSize(listSize);
        }
        return selectOne;
    }

    @Override
    protected void createInputComponents(UIComponent parent, InputControl.InputInfo ii, FacesContext context, List<UIComponent> compList) {
        if (!compList.isEmpty()) {
            throw new InvalidArgumentException("compList", compList);
        }
        Object formatSize = this.getFormatOption(ii, FORMAT_SIZE, FORMAT_SIZE_ATTR);
        UISelectOne input = this.createSelectComponent(parent, context, formatSize);
        Object value = ii.getValue(false);
        if (value instanceof ValueExpression) {
            Class exprType = ((ValueExpression)value).getType(context.getELContext());
            input.getAttributes().put(VALUE_EXPRESSION_TYPE, exprType);
        }
        this.copyAttributes(parent, ii, (UIInput)input);
        boolean disabled = this.setDisabled(input, ii);
        this.initOptions(input, ii.getTextResolver(), ii);
        compList.add((UIComponent)input);
        this.addRemoveDisabledStyle((UIInput)input, disabled);
        this.addRemoveInvalidStyle((UIInput)input, ii.hasError());
        this.setInputValue((UIInput)input, ii);
    }

    @Override
    protected void updateInputState(List<UIComponent> compList, InputControl.InputInfo ii, FacesContext context, PhaseId phaseId) {
        UIComponent comp = compList.get(0);
        if (!(comp instanceof UISelectOne)) {
            throw new UnexpectedReturnValueException((Object)comp.getClass().getName(), "parent.getChildren()");
        }
        UISelectOne input = (UISelectOne)comp;
        this.addRemoveStyle((UIInput)input, TagStyleClass.INPUT_REQ, ii.isRequired());
        boolean disabled = this.setDisabled(input, ii);
        if (phaseId != PhaseId.APPLY_REQUEST_VALUES) {
            this.syncOptions(input, ii.getTextResolver(), ii);
        }
        if (phaseId == PhaseId.RENDER_RESPONSE) {
            this.addRemoveDisabledStyle((UIInput)input, disabled);
            this.addRemoveInvalidStyle((UIInput)input, ii.hasError());
            this.setInputValue((UIInput)input, ii);
        }
    }

    protected boolean setDisabled(UISelectOne input, InputControl.InputInfo ii) {
        boolean disabled = ii.isDisabled();
        if (input instanceof HtmlSelectOneMenu) {
            ((HtmlSelectOneMenu)input).setDisabled(disabled);
        } else if (input instanceof HtmlSelectOneListbox) {
            ((HtmlSelectOneListbox)input).setDisabled(disabled);
        } else {
            log.warn("Unable to set disabled attribute!");
        }
        return disabled;
    }

    protected boolean isEmptyEntryRequired(UISelectOne input, Options options, InputControl.InputInfo ii, Object currentValue) {
        if (input instanceof HtmlSelectOneListbox) {
            return false;
        }
        if (options != null && options.containsNull()) {
            return false;
        }
        if (!ii.isRequired()) {
            return true;
        }
        return ObjectUtils.isEmpty((Object)currentValue);
    }

    public void initOptions(UISelectOne input, TextResolver textResolver, InputControl.InputInfo ii) {
        Options options = ii.getOptions();
        if (options == null) {
            if (ii.getColumn() != null) {
                log.warn("No options given for column {}", (Object)ii.getColumn().getName());
            } else {
                log.warn("No options given for select tag {}", (Object)input.getClientId());
            }
            options = new Options();
        }
        Class exprType = (Class)input.getAttributes().get(VALUE_EXPRESSION_TYPE);
        List<SelectItem> selectItemList = this.getSelectItemList(input);
        Object currentValue = ii.getValue(true);
        if (this.isEmptyEntryRequired(input, options, ii, currentValue)) {
            this.addSelectItem(selectItemList, textResolver, new OptionEntry(null, this.getNullText(ii)), exprType);
        }
        if (options != null && options.size() > 0) {
            Options.OptionGroupResolver optionGroupResolver = options.getOptionGroupResolver();
            HashMap<Object, SelectGroup> groupMap = optionGroupResolver != null ? new HashMap<Object, SelectGroup>() : null;
            for (OptionEntry oe : options) {
                if (oe.isActive() || ObjectUtils.compareEqual((Object)oe.getValue(), (Object)currentValue)) {
                    Object group;
                    List<SelectItem> list = selectItemList;
                    if (optionGroupResolver != null && (group = optionGroupResolver.getGroup(oe)) != null) {
                        SelectGroup selectGroup = (SelectGroup)groupMap.get(group);
                        if (selectGroup == null) {
                            String groupLabel = group != null ? textResolver.resolveText(group.toString()) : null;
                            SelectItemGroup selectItemGroup = new SelectItemGroup(groupLabel);
                            selectItemList.add((SelectItem)selectItemGroup);
                            selectGroup = new SelectGroup(selectItemGroup);
                            groupMap.put(group, selectGroup);
                        }
                        list = selectGroup.getItemList();
                    }
                    this.addSelectItem(list, textResolver, oe, exprType);
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug("Select item {} is not active.", oe.getValue());
            }
            if (groupMap != null) {
                for (SelectGroup group : groupMap.values()) {
                    group.peg();
                }
                groupMap.clear();
            }
        }
    }

    public void syncOptions(UISelectOne input, TextResolver textResolver, InputControl.InputInfo ii) {
        Options.OptionGroupResolver optionGroupResolver;
        Options options = ii.getOptions();
        if (options == null) {
            if (ii.getColumn() != null) {
                log.warn("No options given for column {}", (Object)ii.getColumn().getName());
            } else {
                log.warn("No options given for select tag {}", (Object)input.getClientId());
            }
            options = new Options();
        }
        if ((optionGroupResolver = options.getOptionGroupResolver()) != null) {
            log.debug("SyncOptions is not supported for grouped SelectItems for column {}", (Object)ii.getColumn().getName());
            return;
        }
        Class exprType = (Class)input.getAttributes().get(VALUE_EXPRESSION_TYPE);
        List<SelectItem> selectItemList = this.getSelectItemList(input);
        Object currentValue = ii.getValue(true);
        boolean hasEmpty = this.isEmptyEntryRequired(input, options, ii, currentValue);
        Iterator ioe = options.iterator();
        OptionEntry oe = ioe.hasNext() ? (OptionEntry)ioe.next() : null;
        Iterator<SelectItem> ico = selectItemList.iterator();
        int lastIndex = 0;
        boolean emptyPresent = false;
        while (ico.hasNext()) {
            ++lastIndex;
            SelectItem si = ico.next();
            Object ov = si.getValue();
            if (ObjectUtils.isEmpty((Object)ov) && hasEmpty) {
                emptyPresent = true;
                continue;
            }
            while (oe != null && !oe.isActive() && !ObjectUtils.compareEqual((Object)oe.getValue(), (Object)currentValue)) {
                oe = ioe.hasNext() ? (OptionEntry)ioe.next() : null;
            }
            if (oe == null) {
                --lastIndex;
                for (int index = selectItemList.size() - 1; index >= lastIndex; --index) {
                    selectItemList.remove(index);
                }
                return;
            }
            if (ObjectUtils.compareEqual((Object)ov, (Object)oe.getValue())) {
                this.setItemLabel(si, textResolver, oe);
                oe = ioe.hasNext() ? (OptionEntry)ioe.next() : null;
                continue;
            }
            selectItemList.clear();
            if (hasEmpty) {
                this.addSelectItem(selectItemList, textResolver, new OptionEntry((Object)"", this.getNullText(ii)), exprType);
            }
            for (OptionEntry opt : options) {
                if (!opt.isActive() && !ObjectUtils.compareEqual((Object)opt.getValue(), (Object)currentValue)) continue;
                this.addSelectItem(selectItemList, textResolver, opt, exprType);
            }
            return;
        }
        if (hasEmpty && !emptyPresent) {
            this.addSelectItem(selectItemList, textResolver, new OptionEntry((Object)"", this.getNullText(ii)), exprType, 0);
        }
        while (oe != null) {
            if (oe.isActive() || ObjectUtils.compareEqual((Object)oe.getValue(), (Object)currentValue)) {
                this.addSelectItem(selectItemList, textResolver, oe, exprType);
            }
            oe = ioe.hasNext() ? (OptionEntry)ioe.next() : null;
        }
    }

    protected List<SelectItem> getSelectItemList(UISelectOne input) {
        List children = input.getChildren();
        if (children.isEmpty()) {
            children.add(new UISelectItems());
        } else if (children.size() > 1 && !(children.get(1) instanceof UIParameter)) {
            log.warn("Unexpected number of child items ({}) for SelectInputControl", (Object)children.size());
        }
        UISelectItems items = (UISelectItems)children.get(0);
        ArrayList selectItemList = (ArrayList)items.getValue();
        if (selectItemList == null) {
            selectItemList = new ArrayList();
            items.setValue(selectItemList);
        }
        return selectItemList;
    }

    public void addSelectItem(List<SelectItem> list, TextResolver textResolver, OptionEntry oe, Class<?> exprType, int pos) {
        Object value = exprType != null ? this.formatInputValue(oe.getValue(), exprType) : oe.getValueString();
        SelectItem selectItem = new SelectItem();
        selectItem.setValue(value);
        this.setItemLabel(selectItem, textResolver, oe);
        if (pos >= 0) {
            list.add(pos, selectItem);
        } else {
            list.add(selectItem);
        }
    }

    public void addSelectItem(List<SelectItem> list, TextResolver textResolver, OptionEntry e, Class<?> exprType) {
        this.addSelectItem(list, textResolver, e, exprType, -1);
    }

    protected void setItemLabel(SelectItem si, TextResolver textResolver, OptionEntry oe) {
        String text = oe.getText();
        if (si.getLabel() != null && text != null && text.startsWith("!")) {
            return;
        }
        text = textResolver.resolveText(text);
        si.setLabel(text);
    }

    protected String getNullText(InputControl.InputInfo ii) {
        String nullText = this.getFormatString(ii, "null:", "format:null");
        return nullText != null ? ii.getText(nullText) : "";
    }

    @Override
    protected String formatValue(Object value, InputControl.ValueInfo vi) {
        String text;
        Object attrValue;
        Column column;
        if (vi.getOptions() == null) {
            if (!this.hasFormatOption(vi, "nolookup")) {
                log.warn("Select field {} has no Option list attached!", (Object)vi.getColumn().getName());
            }
            return super.formatValue(value, vi);
        }
        if (this.hasFormatOption(vi, "short") && (column = vi.getColumn()) != null && (attrValue = column.getAttribute(COLATTR_ABBR_OPTIONS)) instanceof Options && (text = this.getOptionText((Options)attrValue, value, vi)) != null) {
            return text;
        }
        return super.formatValue(value, vi);
    }

    @Override
    protected Object formatInputValue(Object value, InputControl.InputInfo ii) {
        Class enumType;
        if (value instanceof Number && (enumType = ii.getColumn().getEnumType()) != null) {
            value = ObjectUtils.getEnum((Class)enumType, (Object)value);
        }
        return this.formatInputValue(value, Object.class);
    }

    protected Object formatInputValue(Object value, Class<?> targetClass) {
        if (value instanceof Enum && !targetClass.isEnum()) {
            return ObjectUtils.getString((Object)value);
        }
        return value;
    }

    @Override
    protected Object parseInputValue(String value, InputControl.InputInfo ii) {
        Class enumType = ii.getColumn().getEnumType();
        if (enumType != null) {
            return ObjectUtils.getEnum((Class)enumType, (Object)value);
        }
        return value;
    }

    protected static class SelectGroup {
        private final SelectItemGroup selectItemGroup;
        private final List<SelectItem> groupItemList;

        public SelectGroup(SelectItemGroup selectItemGroup) {
            this.selectItemGroup = selectItemGroup;
            this.groupItemList = new ArrayList<SelectItem>();
        }

        public List<SelectItem> getItemList() {
            return this.groupItemList;
        }

        public void peg() {
            SelectItem[] items = (SelectItem[])ObjectUtils.listToArray(SelectItem[].class, this.groupItemList);
            this.selectItemGroup.setSelectItems(items);
        }
    }
}

