/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.pages;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.application.NavigationHandler;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.exceptions.InvalidOperationException;
import org.apache.empire.exceptions.ItemNotFoundException;
import org.apache.empire.jsf2.app.FacesUtils;
import org.apache.empire.jsf2.app.TextResolver;
import org.apache.empire.jsf2.app.WebApplication;
import org.apache.empire.jsf2.pages.PageDefinition;
import org.apache.empire.jsf2.pages.PageElement;
import org.apache.empire.jsf2.pages.PageOutcome;
import org.apache.empire.jsf2.utils.ParameterMap;
import org.apache.empire.jsf2.utils.ParameterObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Page {
    public static final String SESSION_MESSAGE = "PAGE_SESSION_MESSAGE";
    private static final Logger log = LoggerFactory.getLogger(Page.class);
    private String action = null;
    private short initialized = (short)-1;
    private PageDefinition pageDefinition = null;
    private List<PageElement<?>> pageElements = null;

    protected Page() {
        if (log.isDebugEnabled()) {
            String name = this.getClass().getSimpleName();
            log.debug("PageBean {} created.", (Object)name);
        }
    }

    public String getPageName() {
        return this.pageDefinition != null ? this.pageDefinition.getPageBeanName() : "{" + this.getClass().getSimpleName() + "}";
    }

    public String getName() {
        String className = this.pageDefinition.getPageBeanClass().getName();
        int lastDot = className.lastIndexOf(".");
        String name = className.substring(lastDot + 1);
        return name;
    }

    public boolean isInitialized() {
        return this.initialized > 0;
    }

    public String getAction() {
        if (this.action == null) {
            return null;
        }
        ParameterMap pm = FacesUtils.getParameterMap(FacesUtils.getContext());
        String actionParam = pm != null ? pm.encodeString(this.action) : this.action;
        return actionParam;
    }

    public void setAction(String actionParam) {
        if (this.initialized > 0) {
            log.debug("Setting PageBean action {} for bean {}.", (Object)this.action, (Object)this.getPageName());
        } else {
            log.trace("Re-setting PageBeanAction {} for bean {}.", (Object)this.action, (Object)this.getPageName());
        }
        if (StringUtils.isEmpty((String)actionParam)) {
            return;
        }
        this.action = PageDefinition.decodeActionParam(actionParam);
        if (this.action == null) {
            throw new ItemNotFoundException((Object)actionParam);
        }
    }

    public PageDefinition getPageDefinition() {
        return this.pageDefinition;
    }

    public void setPageDefinition(PageDefinition pageDefinition) {
        this.pageDefinition = pageDefinition;
    }

    public PageDefinition getParentPage() {
        return this.pageDefinition.getParent();
    }

    public void preRenderPage(FacesContext context) {
        if (this.initialized > 0) {
            try {
                log.debug("PageBean {} is already initialized. Calling doRefresh().", (Object)this.getPageName());
                this.doRefresh();
            }
            catch (Exception e) {
                this.logAndHandleActionException("doRefresh", e);
            }
            return;
        }
        if (this.initialized == 0) {
            InvalidOperationException e = new InvalidOperationException("Page Initialization pending.");
            ((WebApplication)WebApplication.getInstance()).handleException(context, this, (Throwable)e);
        }
        this.initialized = 0;
        try {
            this.checkPageAccess();
            if (context.getResponseComplete()) {
                return;
            }
        }
        catch (Exception e) {
            this.logAndHandleActionException("checkAccess", e);
            if (context.getResponseComplete()) {
                return;
            }
            if (this.getParentPage() != null) {
                this.navigateTo(this.getParentOutcome(true));
            }
            return;
        }
        if (this.action != null && "null".equals(this.action)) {
            log.warn("Invalid action name 'null' for {}", (Object)this.getClass().getName());
            this.action = null;
        }
        if (this.action != null && this.action.length() > 0) {
            try {
                log.debug("Processing action {} on page {}.", (Object)this.action, (Object)this.getPageName());
                this.executeAction(this.action, context);
            }
            finally {
                this.action = null;
            }
        }
        try {
            log.debug("Initializing page {} using doInit()", (Object)this.getPageName());
            this.doInit();
            if (!context.getResponseComplete()) {
                this.restoreSessionMessage();
            }
        }
        catch (Exception e) {
            this.logAndHandleActionException("doInit", e);
        }
        this.initialized = (short)(context.getResponseComplete() ? -1 : 1);
    }

    protected void executeAction(String action, FacesContext context) {
        try {
            Method method = this.getClass().getMethod(action, new Class[0]);
            Object result = method.invoke((Object)this, new Object[0]);
            if (result != null) {
                String outcome = result.toString();
                NavigationHandler navHandler = context.getApplication().getNavigationHandler();
                navHandler.handleNavigation(context, action, outcome);
                context.renderResponse();
                return;
            }
            this.restoreSessionMessage();
        }
        catch (NoSuchMethodException e) {
            this.logAndHandleActionException(action, e);
        }
        catch (Exception e) {
            this.logAndHandleActionException(action, e.getCause());
        }
    }

    public boolean isHasMessages() {
        Iterator fmi = FacesContext.getCurrentInstance().getMessages();
        return fmi.hasNext();
    }

    protected void checkPageAccess() {
    }

    private void restoreSessionMessage() {
        ExternalContext ec = FacesContext.getCurrentInstance().getExternalContext();
        Map map = ec.getSessionMap();
        if (map.containsKey(SESSION_MESSAGE)) {
            FacesMessage errorMsg = (FacesMessage)map.get(SESSION_MESSAGE);
            FacesContext.getCurrentInstance().addMessage(this.getPageName(), errorMsg);
            map.remove(SESSION_MESSAGE);
        }
    }

    protected void logAndHandleActionException(String action, Throwable e) {
        String msg = "Failed to perform action " + action + " on " + this.getPageName();
        log.error(msg, e);
        if (!this.handleActionError(action, e)) {
            FacesContext context = FacesContext.getCurrentInstance();
            ((WebApplication)WebApplication.getInstance()).handleException(context, this, e);
        }
    }

    protected void setSessionMessage(FacesMessage facesMsg) {
        ExternalContext ec = FacesContext.getCurrentInstance().getExternalContext();
        ec.getSessionMap().put(SESSION_MESSAGE, facesMsg);
    }

    protected void setSessionError(Throwable t) {
        FacesContext fc = FacesContext.getCurrentInstance();
        FacesMessage facesMsg = FacesUtils.getFacesErrorMessage(fc, t);
        this.setSessionMessage(facesMsg);
    }

    protected boolean handleActionError(String action, Throwable t) {
        String errorContext = StringUtils.concat((String[])new String[]{this.getPageName(), ":", action});
        WebApplication app = FacesUtils.getWebApplication();
        FacesContext fc = FacesContext.getCurrentInstance();
        FacesMessage facesMsg = app.getFacesErrorMessage(fc, errorContext, t);
        PageDefinition parentPage = this.getParentPage();
        if (parentPage == null) {
            FacesContext.getCurrentInstance().addMessage(this.getPageName(), facesMsg);
            return false;
        }
        this.setSessionMessage(facesMsg);
        this.navigateTo(parentPage.getRedirect());
        return true;
    }

    protected void addFacesMessage(FacesMessage.Severity severity, String msg, Object ... params) {
        FacesUtils.addFacesMessage(null, severity, msg, params);
    }

    public final void addInfoMessage(String msg, Object ... params) {
        this.addFacesMessage(FacesMessage.SEVERITY_INFO, msg, params);
    }

    public final void addWarnMessage(String msg, Object ... params) {
        this.addFacesMessage(FacesMessage.SEVERITY_WARN, msg, params);
    }

    public final void addErrorMessage(String msg, Object ... params) {
        this.addFacesMessage(FacesMessage.SEVERITY_ERROR, msg, params);
    }

    public void setErrorMessage(Throwable t) {
        FacesUtils.addErrorMessage(t);
    }

    protected void navigateTo(PageOutcome outcome) {
        if (log.isDebugEnabled()) {
            log.debug("Redirecting from page {} to page {}.", (Object)this.getPageName(), (Object)outcome.toString());
        }
        FacesContext context = FacesContext.getCurrentInstance();
        NavigationHandler navHandler = context.getApplication().getNavigationHandler();
        navHandler.handleNavigation(context, this.action, outcome.toString());
        context.renderResponse();
    }

    protected void registerPageElement(PageElement<?> element) {
        if (this.pageElements == null) {
            this.pageElements = new ArrayList(1);
        }
        if (!this.pageElements.contains(element)) {
            this.pageElements.add(element);
        } else {
            log.warn("PageElement {} was registered twice!", (Object)element.getPropertyName());
        }
    }

    protected PageOutcome getParentOutcome(String action, boolean redirect) {
        PageDefinition parentPage = this.getParentPage();
        if (parentPage == null) {
            throw new InvalidOperationException("No Parent Page defined for " + this.getPageName());
        }
        if (redirect) {
            return parentPage.getRedirect(action);
        }
        return parentPage.getOutcome(action);
    }

    protected PageOutcome getParentOutcome(boolean redirect) {
        return this.getParentOutcome(null, redirect);
    }

    public <T extends ParameterObject> T getObjectFromParam(Class<T> paramType, String idParam) {
        FacesContext fc = FacesUtils.getContext();
        ParameterMap paramMap = FacesUtils.getParameterMap(fc);
        return paramMap.get(paramType, idParam);
    }

    public Object[] getKeyFromParam(DBRowSet rowset, String idParam) {
        FacesContext fc = FacesUtils.getContext();
        return FacesUtils.getParameterMap(fc).getKey(rowset, idParam);
    }

    public Object[] getKeyFromParam(PageDefinition page, DBRowSet rowset, String idParam) {
        FacesContext fc = FacesUtils.getContext();
        return FacesUtils.getParameterMap(fc).getKey(page, rowset, idParam);
    }

    public String getIdParamForKey(DBRowSet rowset, Object[] key) {
        FacesContext fc = FacesUtils.getContext();
        return FacesUtils.getParameterMap(fc).put(rowset, key);
    }

    public String getIdParamForKey(PageDefinition page, DBRowSet rowset, Object[] key) {
        FacesContext fc = FacesUtils.getContext();
        return FacesUtils.getParameterMap(fc).put(page, rowset, key);
    }

    public void addJavascriptCall(String function) {
        FacesContext fc = FacesUtils.getContext();
        WebApplication app = FacesUtils.getWebApplication();
        app.addJavascriptCall(fc, function);
    }

    public void addJavascriptCall(String function, Object ... args) {
        for (int i = 0; i < args.length; ++i) {
            String placeholder = "{" + String.valueOf(i) + "}";
            function = StringUtils.replace((String)function, (String)placeholder, (String)String.valueOf(args[i]));
        }
        this.addJavascriptCall(function);
    }

    public void addPageResource(String name, Object resource) {
        Map<String, Object> prm = FacesUtils.getPageResourceMap(FacesUtils.getContext());
        prm.put(name, this);
    }

    public Object getPageResource(String name) {
        Map<String, Object> prm = FacesUtils.getPageResourceMap(FacesUtils.getContext());
        return prm.get(name);
    }

    public void doInit() {
        if (this.pageElements != null) {
            for (PageElement<?> pe : this.pageElements) {
                this.doInitElement(pe);
            }
        }
    }

    public void doRefresh() {
        if (this.pageElements != null) {
            for (PageElement<?> pe : this.pageElements) {
                this.doRefreshElement(pe);
            }
        }
    }

    protected void doInitElement(PageElement<?> pe) {
        pe.onInitPage();
    }

    protected void doRefreshElement(PageElement<?> pe) {
        pe.onRefreshPage();
    }

    protected final TextResolver getTextResolver() {
        FacesContext fc = FacesUtils.getContext();
        return FacesUtils.getTextResolver(fc);
    }
}

