/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.utils;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.jsf2.components.ControlTag;
import org.apache.empire.jsf2.utils.TagEncodingHelper;
import org.apache.empire.jsf2.utils.TagStyleClass;

public class ControlRenderInfo {
    private static ControlRenderInfo DEFAULT_CONTROL_RENDER_INFO = new DefaultControlRenderInfo();
    public static final String PLACEHOLDER_ATTRIBUTE = "placeholder";
    private static boolean renderPlaceholderDefault = false;
    private static boolean renderExtraWrapperStyles = false;
    public final String CONTROL_TAG;
    public final String LABEL_WRAPPER_TAG;
    public final String INPUT_WRAPPER_TAG;
    public final Character AUTO_CONTROL_ID;

    public static ControlRenderInfo getDefault() {
        return DEFAULT_CONTROL_RENDER_INFO;
    }

    public static void setDefault(ControlRenderInfo renderInfo) {
        DEFAULT_CONTROL_RENDER_INFO = renderInfo;
    }

    public static boolean isRenderExtraWrapperStyles() {
        return renderExtraWrapperStyles;
    }

    public static void setRenderExtraWrapperStyles(boolean renderExtraWrapperStyles) {
        ControlRenderInfo.renderExtraWrapperStyles = renderExtraWrapperStyles;
    }

    public static boolean isRenderPlaceholderDefault() {
        return renderPlaceholderDefault;
    }

    public static void setRenderPlaceholderDefault(boolean renderPlaceholderDefault) {
        ControlRenderInfo.renderPlaceholderDefault = renderPlaceholderDefault;
    }

    public static boolean isRenderPlaceholder(UIComponent component) {
        return ObjectUtils.getBoolean(component.getAttributes().get(PLACEHOLDER_ATTRIBUTE), (boolean)renderPlaceholderDefault);
    }

    public ControlRenderInfo(String controlTag, String labelTag, String inputTag, Character autoControlId) {
        this.CONTROL_TAG = StringUtils.nullIfEmpty((Object)controlTag);
        this.LABEL_WRAPPER_TAG = StringUtils.nullIfEmpty((Object)labelTag);
        this.INPUT_WRAPPER_TAG = StringUtils.nullIfEmpty((Object)inputTag);
        this.AUTO_CONTROL_ID = autoControlId;
    }

    public void writeLabelWrapperAttributes(ResponseWriter writer, TagEncodingHelper helper) throws IOException {
        String extraStyleClass = helper.getControlExtraLabelWrapperStyle();
        helper.writeStyleClass(writer, TagStyleClass.CONTROL_LABEL.get(), extraStyleClass);
    }

    public void writeInputWrapperAttributes(ResponseWriter writer, TagEncodingHelper helper) throws IOException {
        String colSpan;
        String wrapperClass = helper.getTagAttributeStringEx("wrapperClass", true);
        if (wrapperClass != null && wrapperClass.equals("-")) {
            wrapperClass = null;
        }
        String extraStyleClass = helper.getControlExtraInputWrapperStyle();
        helper.writeStyleClass(writer, TagStyleClass.CONTROL_INPUT.get(), wrapperClass, extraStyleClass);
        String string = colSpan = "td".equalsIgnoreCase(this.INPUT_WRAPPER_TAG) ? helper.getTagAttributeStringEx("colspan", false) : null;
        if (colSpan != null) {
            writer.writeAttribute("colspan", (Object)colSpan, null);
        }
    }

    public void renderPlaceholder(FacesContext context, ControlTag controlTag) throws IOException {
    }

    private static class DefaultControlRenderInfo
    extends ControlRenderInfo {
        public DefaultControlRenderInfo() {
            super(null, "td", "td", null);
        }

        @Override
        public void renderPlaceholder(FacesContext context, ControlTag controlTag) throws IOException {
            if (DefaultControlRenderInfo.isRenderPlaceholder((UIComponent)controlTag)) {
                ResponseWriter writer = context.getResponseWriter();
                writer.startElement("td", (UIComponent)controlTag);
                writer.writeAttribute("class", (Object)TagStyleClass.CONTROL_PLACEHOLDER.get(), null);
                writer.writeAttribute("colspan", (Object)2, null);
                writer.endElement("td");
            }
        }
    }
}

