/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.utils;

import java.util.Map;
import javax.faces.context.FacesContext;
import org.apache.empire.jsf2.pages.Page;

public class SessionMap {
    public static <T> T get(String objectName, Class<T> type) {
        Map map = FacesContext.getCurrentInstance().getExternalContext().getSessionMap();
        return (T)map.get(objectName);
    }

    public static <T> T get(Page page, String propertyName, Class<T> type) {
        String objectName = page.getPageName() + "." + propertyName + "." + type.getSimpleName();
        return SessionMap.get(objectName, type);
    }

    public static <T> void put(String objectName, Class<T> type, T object) {
        Map map = FacesContext.getCurrentInstance().getExternalContext().getSessionMap();
        if (object != null) {
            map.put(objectName, object);
        } else {
            map.remove(objectName);
        }
    }

    public static <T> void remove(Page page, String propertyName, Class<T> type, T object) {
        String objectName = page.getPageName() + "." + propertyName + "." + type.getSimpleName();
        SessionMap.put(objectName, type, object);
    }

    public static <T> void remove(String objectName, Class<T> type) {
        SessionMap.put(objectName, type, null);
    }

    public static <T> void remove(Page page, String propertyName, Class<T> type) {
        SessionMap.remove(page, propertyName, type, null);
    }
}

