/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.utils;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import javax.el.ValueExpression;
import javax.faces.application.FacesMessage;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.UIInput;
import javax.faces.component.UIOutput;
import javax.faces.component.html.HtmlOutputLabel;
import javax.faces.component.html.HtmlOutputText;
import javax.faces.component.html.HtmlPanelGroup;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.empire.commons.Attributes;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.Options;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.commons.Unwrappable;
import org.apache.empire.data.Column;
import org.apache.empire.data.ColumnExpr;
import org.apache.empire.data.DataType;
import org.apache.empire.data.EntityType;
import org.apache.empire.data.Record;
import org.apache.empire.data.RecordData;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBRecordBase;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.exceptions.FieldIllegalValueException;
import org.apache.empire.db.exceptions.FieldNotNullException;
import org.apache.empire.exceptions.BeanPropertyGetException;
import org.apache.empire.exceptions.BeanPropertySetException;
import org.apache.empire.exceptions.EmpireException;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.InvalidPropertyException;
import org.apache.empire.exceptions.NotSupportedException;
import org.apache.empire.exceptions.PropertyReadOnlyException;
import org.apache.empire.jsf2.app.FacesUtils;
import org.apache.empire.jsf2.app.TextResolver;
import org.apache.empire.jsf2.app.WebApplication;
import org.apache.empire.jsf2.components.ControlTag;
import org.apache.empire.jsf2.components.FormGridTag;
import org.apache.empire.jsf2.components.InputTag;
import org.apache.empire.jsf2.components.LabelTag;
import org.apache.empire.jsf2.components.LinkTag;
import org.apache.empire.jsf2.components.RecordTag;
import org.apache.empire.jsf2.controls.InputControl;
import org.apache.empire.jsf2.controls.InputControlManager;
import org.apache.empire.jsf2.utils.ControlRenderInfo;
import org.apache.empire.jsf2.utils.TagContextInfo;
import org.apache.empire.jsf2.utils.TagStyleClass;
import org.apache.empire.jsf2.utils.ValueExpressionUnwrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagEncodingHelper
implements NamingContainer {
    public static final String FACES_ID_PREFIX = "j_id";
    public static boolean CSS_STYLE_USE_INPUT_TYPE_INSTEAD_OF_DATA_TYPE = true;
    private static final String SPACE = " ";
    private static final Logger log = LoggerFactory.getLogger(TagEncodingHelper.class);
    public static final String ORIGINAL_COMPONENT_ID = "ORIGINAL_COMPONENT_ID";
    public static final String COLATTR_TOOLTIP = "TOOLTIP";
    public static final String COLATTR_ABBR_TITLE = "ABBR_TITLE";
    protected final UIOutput component;
    protected final String cssStyleClass;
    protected Column column = null;
    protected Object record = null;
    protected RecordTag recordTag = null;
    protected UIData uiDataTag = null;
    protected FormGridTag formGridTag = null;
    protected InputControl control = null;
    protected TextResolver textResolver = null;
    protected byte hasValueExpr = (byte)-1;
    protected byte insideUIData = (byte)-1;
    protected byte readOnly = (byte)-1;
    protected byte valueRequired = (byte)-1;
    protected boolean optionsDetected = false;
    protected Options options = null;
    protected InputControl.ValueInfo valueInfo = null;
    protected boolean skipValidation = false;
    protected Object mostRecentValue = null;
    public static final char PH_COLUMN_NAME = '@';
    public static final char PH_COLUMN_FULL = '$';
    public static final char PH_COLUMN_SMART = '*';
    public static final char[] ALLOWED_COLUMN_PH = new char[]{'@', '$', '*'};
    public static final Set<String> SMART_COLUMN_NAME_SET = new HashSet<String>();
    protected static final String CC_ATTR_EXPR = "#{cc.attrs.";
    protected static String TAGLIB_ATTR_PREFIX;
    public static final String CSS_DATA_TYPE_NONE;
    public static final String CSS_DATA_TYPE_INT = " eTypeInt";
    public static final String CSS_DATA_TYPE_NUMBER = " eTypeNumber";
    public static final String CSS_DATA_TYPE_TEXT = " eTypeText";
    public static final String CSS_DATA_TYPE_LONGTEXT = " eTypeLongText";
    public static final String CSS_DATA_TYPE_DATE = " eTypeDate";
    public static final String CSS_DATA_TYPE_DATETIME = " eTypeDateTime";
    public static final String CSS_DATA_TYPE_BOOL = " eTypeBool";

    protected TagEncodingHelper(UIOutput component, String cssStyleClass) {
        this.component = component;
        this.cssStyleClass = cssStyleClass;
    }

    public void encodeBegin() {
        if (this.component instanceof UIInput && ((UIInput)this.component).isLocalValueSet()) {
            if (log.isDebugEnabled()) {
                log.debug("clearing local value for {}. value is {}.", (Object)this.getColumnName(), ((UIInput)this.component).getLocalValue());
            }
            ((UIInput)this.component).setValue(null);
            ((UIInput)this.component).setLocalValueSet(false);
        }
        this.checkRecord();
        this.reset();
    }

    public void prepareData() {
        this.checkRecord();
    }

    public String completeInputTagId(String id) {
        String name;
        if (StringUtils.isEmpty((String)id)) {
            id = "*";
        } else if (id.startsWith(FACES_ID_PREFIX)) {
            return id;
        }
        int idx = id.indexOf(64);
        if (idx >= 0) {
            name = this.getColumnName();
        } else {
            idx = id.indexOf(42);
            if (idx >= 0) {
                name = this.getColumnSmartName();
            } else {
                idx = id.indexOf(36);
                if (idx >= 0) {
                    name = this.getColumnFullName();
                } else {
                    return id;
                }
            }
        }
        id = id.length() > 1 ? StringUtils.concat((String[])new String[]{id.substring(0, idx), name, id.substring(idx + 1)}) : name;
        return id;
    }

    public InputControl getInputControl() {
        Object attr;
        if (this.control != null) {
            return this.control;
        }
        if (this.getColumn() == null) {
            throw new NotSupportedException((Object)this, "getInputControl");
        }
        String controlType = this.getTagAttributeString("controlType");
        if (controlType == null && "text".equalsIgnoreCase(controlType = this.column.getControlType()) && (attr = this.getTagAttributeValue("options")) != null && attr instanceof Options && !((Options)attr).isEmpty()) {
            controlType = "select";
        }
        this.control = this.detectInputControl(controlType, this.column.getDataType());
        return this.control;
    }

    protected InputControl detectInputControl(String controlType, DataType dataType) {
        if (dataType == null) {
            throw new InvalidArgumentException("dataType", (Object)dataType);
        }
        InputControl control = null;
        if (StringUtils.isNotEmpty((String)controlType)) {
            control = InputControlManager.getControl(controlType);
        }
        if (control == null && (control = InputControlManager.getControl(controlType = this.getValueOptions() != null ? "select" : ((WebApplication)WebApplication.getInstance()).getDefaultControlType(dataType))) == null) {
            control = InputControlManager.getControl("text");
        }
        return control;
    }

    protected void checkRecord() {
        if (this.record == null) {
            return;
        }
        Object rec = this.getTagAttributeValue("record");
        if (rec != null) {
            if (rec != this.record) {
                if (log.isTraceEnabled()) {
                    if (rec instanceof DBRecordBase && this.record instanceof DBRecordBase) {
                        String keyOld = StringUtils.toString((Object)((DBRecordBase)this.record).getKey());
                        String keyNew = StringUtils.toString((Object)((DBRecordBase)rec).getKey());
                        String rowSet = ((DBRecordBase)rec).getRowSet().getName();
                        log.trace("Changing {} record of rowset {} from {} to {}", new Object[]{this.component.getClass().getSimpleName(), rowSet, keyOld, keyNew});
                    } else {
                        log.trace("Changing {} record of class {}", (Object)this.component.getClass().getSimpleName(), (Object)rec.getClass().getName());
                    }
                }
                this.setRecord(rec);
            }
        } else if (this.recordTag != null) {
            rec = this.recordTag.getRecord();
            if (rec != this.record) {
                this.setRecord(rec);
            }
        } else if (this.isInsideUIData()) {
            this.setRecord(null);
        }
    }

    public InputControl.ValueInfo getValueInfo(FacesContext ctx) {
        if (this.valueInfo == null) {
            this.valueInfo = new ValueInfoImpl(this.getColumn(), this.getTextResolver(ctx));
        }
        return this.valueInfo;
    }

    public InputControl.InputInfo getInputInfo(FacesContext ctx) {
        if (!(this.valueInfo instanceof InputControl.InputInfo)) {
            this.skipValidation = FacesUtils.isSkipInputValidation(ctx);
            this.valueInfo = new InputInfoImpl(this.getColumn(), this.getTextResolver(ctx));
        }
        return (InputControl.InputInfo)this.valueInfo;
    }

    public boolean isSkipValidation() {
        return this.skipValidation;
    }

    public boolean hasColumn() {
        if (this.column == null) {
            this.setColumn(this.findColumn());
        }
        return this.column != null;
    }

    public Column getColumn() {
        if (this.hasColumn()) {
            return this.column;
        }
        throw new InvalidArgumentException("column", (Object)this.column);
    }

    public String getColumnName() {
        if (this.column == null) {
            this.setColumn(this.findColumn());
        }
        return this.column != null ? this.column.getName() : "null";
    }

    public String getColumnFullName() {
        if (this.column == null) {
            this.setColumn(this.findColumn());
        }
        if (this.column == null) {
            return "null";
        }
        EntityType entity = this.column.getEntityType();
        if (entity != null) {
            return StringUtils.concat((String[])new String[]{entity.getEntityName(), "_", this.column.getName()});
        }
        return this.column.getName();
    }

    public String getColumnSmartName() {
        String name = this.getColumnName();
        if (SMART_COLUMN_NAME_SET.contains(name)) {
            name = this.getColumnFullName();
        }
        return name;
    }

    public void setColumn(Column column) {
        this.column = column;
    }

    public Object getRecord() {
        Object found;
        if (this.record == null && (found = this.findRecord()) != null) {
            this.setRecord(found);
        }
        return this.record;
    }

    public void setRecord(Object record) {
        if (this.record != null) {
            this.reset();
        }
        this.record = record;
    }

    public void reset() {
        this.readOnly = (byte)-1;
        this.valueRequired = (byte)-1;
        this.optionsDetected = false;
        this.options = null;
        this.mostRecentValue = null;
        if (this.valueInfo != null) {
            ((ValueInfoImpl)this.valueInfo).reset();
        }
    }

    public Object findRecordComponent() {
        if (this.recordTag != null) {
            return this.recordTag.getRecord();
        }
        if (this.uiDataTag != null) {
            if (this.uiDataTag.isRowAvailable()) {
                return this.uiDataTag.getRowData();
            }
            return null;
        }
        UIOutput parent = this.component;
        while ((parent = parent.getParent()) != null) {
            if (parent instanceof RecordTag) {
                this.recordTag = (RecordTag)parent;
                return this.recordTag.getRecord();
            }
            if (!(parent instanceof UIData)) continue;
            this.uiDataTag = (UIData)parent;
            this.insideUIData = 1;
            return this.uiDataTag.isRowAvailable() ? this.uiDataTag.getRowData() : null;
        }
        return null;
    }

    protected boolean isDetectFieldChange() {
        Object v = this.getTagAttributeValue("detectFieldChange");
        if (v == null && this.recordTag != null) {
            v = this.recordTag.getAttributes().get("detectFieldChange");
        }
        return v != null ? ObjectUtils.getBoolean((Object)v) : true;
    }

    public Object getDataValue(boolean evalExpression) {
        if (this.getRecord() != null) {
            if (this.record instanceof RecordData) {
                if (this.record instanceof Record && !((Record)this.record).isValid()) {
                    return null;
                }
                ColumnExpr col = this.unwrapColumnExpr(this.getColumn());
                this.mostRecentValue = ((RecordData)this.record).get(col);
                return this.mostRecentValue;
            }
            String prop = this.getColumn().getBeanPropertyName();
            return this.getBeanPropertyValue(this.record, prop);
        }
        if (evalExpression) {
            Object value = this.component.getValue();
            return value;
        }
        Object value = this.component.getLocalValue();
        if (value != null && this.component instanceof UIInput && !((UIInput)this.component).isLocalValueSet()) {
            value = null;
        }
        if (value == null) {
            value = this.getValueExpression();
        }
        return value;
    }

    public void setDataValue(Object value) {
        if (this.getRecord() != null) {
            if (this.record instanceof Record) {
                Object currentValue;
                this.getColumn();
                if (this.mostRecentValue != null && this.isDetectFieldChange() && !ObjectUtils.compareEqual((Object)(currentValue = ((Record)this.record).get((ColumnExpr)this.column)), (Object)this.mostRecentValue)) {
                    log.info("Concurrent data change for column {}. Current Value is \"{}\". Ignoring new value \"{}\"", new Object[]{this.column.getName(), currentValue, value});
                    return;
                }
                boolean reenableValidation = false;
                if (this.skipValidation && this.record instanceof DBRecordBase) {
                    if (this.isReadOnly()) {
                        return;
                    }
                    reenableValidation = ((DBRecordBase)this.record).isValidateFieldValues();
                    if (reenableValidation) {
                        ((DBRecordBase)this.record).setValidateFieldValues(false);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("Input Validation skipped for {}.", (Object)this.column.getName());
                    }
                }
                try {
                    ((Record)this.record).set(this.column, value);
                    this.mostRecentValue = value;
                }
                finally {
                    if (reenableValidation) {
                        ((DBRecordBase)this.record).setValidateFieldValues(true);
                    }
                }
            } else {
                if (this.record instanceof RecordData) {
                    throw new PropertyReadOnlyException("record");
                }
                String prop = this.getColumn().getBeanPropertyName();
                this.setBeanPropertyValue(this.record, prop, value);
            }
        } else {
            ValueExpression ve = this.getValueExpression();
            if (ve == null) {
                throw new PropertyReadOnlyException("value");
            }
            FacesContext ctx = FacesContext.getCurrentInstance();
            ve.setValue(ctx.getELContext(), value);
        }
    }

    public boolean isRenderValueComponent() {
        return this.isReadOnly();
    }

    public boolean isRecordReadOnly() {
        return this.getRecordReadOnly() == Boolean.TRUE;
    }

    public Boolean getRecordReadOnly() {
        if (this.getRecord() instanceof RecordData ? !(this.record instanceof Record) : this.record == null && !this.hasValueExpression()) {
            return true;
        }
        Object val = this.getTagAttributeValue("readonly");
        if (!ObjectUtils.isEmpty((Object)val)) {
            return ObjectUtils.getBoolean((Object)val);
        }
        if (this.hasValueExpression()) {
            ValueExpression ve = this.getValueExpression();
            return ve != null ? Boolean.valueOf(ve.isReadOnly(FacesContext.getCurrentInstance().getELContext())) : null;
        }
        if (this.recordTag != null && this.recordTag.isReadOnly()) {
            return true;
        }
        if (this.record instanceof Record && ((Record)this.record).isReadOnly()) {
            return true;
        }
        return null;
    }

    public boolean isVisible() {
        Object recordTagValue;
        Object val = this.getTagAttributeValue("visible");
        if (!ObjectUtils.isEmpty((Object)val)) {
            return ObjectUtils.getBoolean((Object)val);
        }
        if (this.record != null && (recordTagValue = this.getTagAttributeValue("record")) instanceof DBRecordBase && this.record != recordTagValue) {
            log.warn("Record in call to IsVisible has unexpectedly changed!");
            this.record = null;
        }
        if (this.getRecord() instanceof Record) {
            Record r = (Record)this.record;
            return r.isValid() && r.isFieldVisible(this.getColumn());
        }
        return true;
    }

    public final boolean isReadOnly() {
        if (this.readOnly < 0) {
            this.readOnly = this.detectReadOnly() ? (byte)1 : 0;
        }
        return this.readOnly > 0;
    }

    protected boolean detectReadOnly() {
        if (!(this.component instanceof UIInput)) {
            if (!(this.component instanceof LabelTag)) {
                log.warn("Component for {} is not of type UIInput but {}", (Object)this.getColumn().getName(), (Object)this.component.getClass().getName());
            }
            return true;
        }
        Boolean readOnly = this.getRecordReadOnly();
        if (readOnly != null) {
            return readOnly;
        }
        if (this.getRecord() instanceof Record) {
            Record r = (Record)this.record;
            return r.isValid() && r.isFieldReadOnly(this.getColumn());
        }
        return this.getColumn().isReadOnly();
    }

    public final boolean isValueRequired() {
        if (this.valueRequired < 0) {
            this.valueRequired = this.detectValueRequired() ? (byte)1 : 0;
        }
        return this.valueRequired > 0;
    }

    protected boolean detectValueRequired() {
        Object mandatory = this.getTagAttributeValue("mandatory");
        if (mandatory != null) {
            return ObjectUtils.getBoolean((Object)mandatory);
        }
        if (this.isReadOnly()) {
            return false;
        }
        if (this.hasValueExpression()) {
            return false;
        }
        if (this.getRecord() instanceof Record) {
            Record r = (Record)this.record;
            return r.isValid() && r.isFieldRequired(this.getColumn());
        }
        if (this.recordTag != null && (mandatory = this.recordTag.getAttributes().get("mandatory")) != null) {
            return ObjectUtils.getBoolean((Object)mandatory);
        }
        return this.getColumn().isRequired();
    }

    public final boolean isDisabled() {
        InputControl.DisabledType disabled = this.getDisabled();
        return disabled != null && disabled != InputControl.DisabledType.NO;
    }

    public InputControl.DisabledType getDisabled() {
        if (!(this.component instanceof UIInput)) {
            log.warn("Component is not of type UIInput");
            return InputControl.DisabledType.READONLY;
        }
        Object dis = this.getTagAttributeValueEx("disabled", false);
        if (ObjectUtils.isEmpty((Object)dis)) {
            return null;
        }
        if (dis instanceof InputControl.DisabledType) {
            return (InputControl.DisabledType)((Object)dis);
        }
        if (String.valueOf(dis).equalsIgnoreCase("readonly")) {
            return InputControl.DisabledType.READONLY;
        }
        return ObjectUtils.getBoolean((Object)dis) ? InputControl.DisabledType.DISABLED : InputControl.DisabledType.NO;
    }

    public boolean isValueModified() {
        Object modified = this.getTagAttributeValue("modified");
        if (modified != null) {
            return ObjectUtils.getBoolean((Object)modified);
        }
        if (this.getRecord() instanceof Record) {
            Record r = (Record)this.record;
            return r.isValid() && r.wasModified(this.getColumn());
        }
        return false;
    }

    public boolean validateNullValue() {
        if (this.isValueRequired()) {
            throw new FieldNotNullException(this.column);
        }
        return true;
    }

    public boolean beginValidateValue(FacesContext ctx, Object value) {
        return !UIInput.isEmpty((Object)value) || !FacesUtils.getWebApplication().isPartialSubmit(ctx);
    }

    public boolean beginUpdateModel(FacesContext ctx, Object value) {
        if (UIInput.isEmpty((Object)value) && FacesUtils.getWebApplication().isPartialSubmit(ctx)) {
            String partialCompId = FacesUtils.getWebApplication().getPartialSubmitComponentId(ctx);
            if (log.isInfoEnabled()) {
                log.info("Performing UpdateModel for PartialSubmit on column {} from {}", (Object)this.getColumnFullName(), (Object)partialCompId);
            }
        }
        return true;
    }

    protected Column findColumn() {
        Object col = this.getTagAttributeValue("column");
        if (col instanceof Column) {
            return (Column)col;
        }
        if (col instanceof ColumnExpr) {
            if (this.component instanceof InputTag || this.component instanceof ControlTag) {
                log.warn("ColumnExpresion cannot be used with InputTag or ControlTag");
                throw new InvalidPropertyException("column", (Object)this.column);
            }
            return this.createColumnExprWrapper((ColumnExpr)col);
        }
        if (col instanceof String) {
            String name = String.valueOf(col);
            int dbix = name.indexOf(46);
            if (dbix <= 0) {
                log.error("Invalid column expression '{}'!", (Object)name);
                return null;
            }
            DBDatabase db = DBDatabase.findByIdentifier((String)name.substring(0, dbix));
            if (db == null) {
                log.error("Database '{}' not found!", (Object)name.substring(0, dbix));
                return null;
            }
            int co = name.lastIndexOf(46);
            int to = name.lastIndexOf(46, co - 1);
            String cn = name.substring(co + 1);
            String tn = name.substring(to + 1, co);
            DBRowSet rs = db.getRowSet(tn);
            if (rs == null) {
                log.error("Table/View '{}' not found in database!", (Object)tn);
                return null;
            }
            DBColumn column = rs.getColumn(cn);
            if (column == null) {
                log.error("Column '{}' not found in table/view '{}'!", (Object)cn, (Object)tn);
                return null;
            }
            return column;
        }
        if (log.isDebugEnabled() && !(this.component instanceof LinkTag)) {
            log.warn("No Column provided for value tag!");
        }
        return null;
    }

    protected Column findColumnFromValue() {
        Object col = this.component.getValue();
        if (col instanceof Column) {
            return (Column)col;
        }
        if (col instanceof ColumnExpr) {
            Column source = ((ColumnExpr)col).getUpdateColumn();
            if (source != null) {
                return source;
            }
            return this.createColumnExprWrapper((ColumnExpr)col);
        }
        return null;
    }

    protected Column createColumnExprWrapper(ColumnExpr colExpr) {
        return new ColumnExprWrapper(colExpr);
    }

    protected ColumnExpr unwrapColumnExpr(Column col) {
        if (col instanceof ColumnExprWrapper) {
            return ((ColumnExprWrapper)col).getExpr();
        }
        return col;
    }

    protected Column unwrapColumn(Column col) {
        if (col instanceof ColumnExprWrapper) {
            return ((ColumnExprWrapper)col).getUpdateColumn();
        }
        return col;
    }

    protected Object findRecord() {
        Object rec = this.getTagAttributeValue("record");
        if (rec != null) {
            return rec;
        }
        if (this.hasValueExpression()) {
            return null;
        }
        rec = this.findRecordComponent();
        if (rec == null && this.component instanceof ControlTag && !((ControlTag)this.component).isCustomInput()) {
            log.warn("No record supplied for {} and column {}.", (Object)this.component.getClass().getSimpleName(), (Object)this.getColumnName());
        }
        return rec;
    }

    protected ValueExpression getValueExpression() {
        return this.component.getValueExpression("value");
    }

    protected boolean hasValueExpression() {
        if (this.hasValueExpr < 0) {
            ValueExpression ve = this.findTopValueExpression("value");
            this.hasValueExpr = ve != null ? (byte)1 : 0;
        }
        return this.hasValueExpr > 0;
    }

    protected ValueExpression findTopValueExpression(String attribute) {
        ValueExpression ve = this.component.getValueExpression(attribute);
        UIOutput parent = this.component;
        while (ve != null) {
            String expr = ve.getExpressionString();
            if (expr.startsWith(CC_ATTR_EXPR)) {
                if ((parent = UIComponent.getCompositeComponentParent((UIComponent)parent)) == null) {
                    log.error("No CompositeComponentParent for {} expression was {}", (Object)this.getColumnName(), (Object)expr);
                    return null;
                }
                int end = expr.indexOf(125);
                String attrib = expr.substring(CC_ATTR_EXPR.length(), end);
                if (attrib.indexOf(46) > 0) break;
                ve = parent.getValueExpression(attrib);
                continue;
            }
            ValueExpression next = ValueExpressionUnwrapper.getInstance().unwrap(ve, TAGLIB_ATTR_PREFIX);
            if (ve == next) break;
            ve = next;
            if (!log.isDebugEnabled()) continue;
            if (ve != null && !expr.equals(ve.getExpressionString())) {
                log.debug("ValueExpression \"{}\" has been resolved to \"{}\" from class {}", new Object[]{expr, ve.getExpressionString(), ve.getClass().getName()});
                continue;
            }
            if (ve != null) continue;
            log.debug("ValueExpression \"{}\" has been resolved to NULL", (Object)expr);
        }
        return ve;
    }

    protected Object getBeanPropertyValue(Object bean, String property) {
        try {
            PropertyUtilsBean pub = BeanUtilsBean.getInstance().getPropertyUtils();
            return pub.getSimpleProperty(bean, property);
        }
        catch (IllegalAccessException e) {
            log.error(bean.getClass().getName() + ": unable to get property '" + property + "'");
            throw new BeanPropertyGetException(bean, property, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.error(bean.getClass().getName() + ": unable to get property '" + property + "'");
            throw new BeanPropertyGetException(bean, property, (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            log.warn(bean.getClass().getName() + ": no getter available for property '" + property + "'");
            throw new BeanPropertyGetException(bean, property, (Throwable)e);
        }
    }

    protected void setBeanPropertyValue(Object bean, String property, Object value) {
        try {
            if (ObjectUtils.isEmpty((Object)value)) {
                value = null;
            }
            if (value != null) {
                BeanUtils.setProperty((Object)bean, (String)property, (Object)value);
            } else {
                PropertyUtils.setProperty((Object)bean, (String)property, null);
            }
        }
        catch (IllegalArgumentException e) {
            log.error(bean.getClass().getName() + ": invalid argument for property '" + property + "'");
            throw new BeanPropertySetException(bean, property, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error(bean.getClass().getName() + ": unable to set property '" + property + "'");
            throw new BeanPropertySetException(bean, property, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.error(bean.getClass().getName() + ": unable to set property '" + property + "'");
            throw new BeanPropertySetException(bean, property, (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            log.error(bean.getClass().getName() + ": no setter available for property '" + property + "'");
            throw new BeanPropertySetException(bean, property, (Throwable)e);
        }
    }

    protected final Options getValueOptions() {
        if (!this.optionsDetected) {
            this.options = this.detectValueOptions();
            this.optionsDetected = true;
        }
        return this.options;
    }

    protected Options detectValueOptions() {
        Object attr = this.getTagAttributeValue("options");
        if (attr != null && attr instanceof Options) {
            return (Options)attr;
        }
        if (this.hasColumn()) {
            Object rec;
            Object object = rec = this.record != null ? this.record : this.findRecord();
            if (rec instanceof Record && ((Record)rec).isValid()) {
                return ((Record)rec).getFieldOptions(this.unwrapColumn(this.column));
            }
            return this.column.getOptions();
        }
        return null;
    }

    public String getValueTooltip(Object value) {
        Options options;
        if (value == null) {
            return null;
        }
        if (value instanceof Column) {
            Column ttc = (Column)value;
            if (this.getRecord() != null) {
                Options options2;
                if (this.record instanceof RecordData) {
                    value = ((RecordData)this.record).get((ColumnExpr)ttc);
                    Class enumType = ttc.getEnumType();
                    if (enumType != null && !(value instanceof Enum)) {
                        value = ObjectUtils.getEnum((Class)enumType, (Object)value);
                    }
                } else {
                    String prop = ttc.getBeanPropertyName();
                    value = this.getBeanPropertyValue(this.record, prop);
                }
                Options options3 = options2 = value == null || value instanceof Enum ? null : ttc.getOptions();
                if (options2 != null && !this.hasFormat("notitlelookup")) {
                    value = options2.get(value);
                }
                return this.getDisplayText(value);
            }
            log.warn("Unable to resolve Tooltip-value for column {}.", (Object)ttc.getName());
            return null;
        }
        String templ = StringUtils.valueOf((Object)value);
        int valIndex = templ.indexOf("{}");
        if (valIndex >= 0) {
            value = this.getDataValue(true);
        }
        String text = null;
        if (!this.hasFormat("notitlelookup") && (options = this.getValueOptions()) != null) {
            String optValue = options.get(value);
            text = this.getDisplayText(optValue);
        } else {
            text = this.getDisplayText(value);
        }
        if (valIndex >= 0 && text != null) {
            text = StringUtils.replace((String)templ, (String)"{}", (String)text);
        }
        return text;
    }

    public String getLabelTooltip(Column column) {
        String title = this.getTagAttributeString("title");
        if (title == null) {
            title = StringUtils.toString((Object)column.getAttribute("tooltip"));
        }
        if (title != null) {
            return this.getDisplayText(title);
        }
        if (this.hasFormat("short") && !ObjectUtils.isEmpty((Object)column.getAttribute(COLATTR_ABBR_TITLE))) {
            return this.getDisplayText(column.getTitle());
        }
        return null;
    }

    public boolean hasFormat(String format) {
        String f = this.getTagAttributeString("format");
        return f != null && f.indexOf(format) >= 0;
    }

    public boolean hasFormat(InputControl.ValueInfo vi, String format) {
        String f = vi.getFormat();
        return f != null && f.indexOf(format) >= 0;
    }

    public String getDisplayText(Object value) {
        if (ObjectUtils.isEmpty((Object)value)) {
            return null;
        }
        if (value instanceof Number) {
            return String.valueOf(value);
        }
        if (this.textResolver == null) {
            this.getTextResolver(FacesContext.getCurrentInstance());
        }
        return this.textResolver.resolveText(value.toString());
    }

    public TextResolver getTextResolver(FacesContext context) {
        if (this.textResolver == null) {
            this.textResolver = ((WebApplication)WebApplication.getInstance()).getTextResolver(context);
        }
        return this.textResolver;
    }

    protected boolean detectError(FacesContext context) {
        Iterator iter = context.getMessages(this.component.getClientId());
        while (iter.hasNext()) {
            FacesMessage m = (FacesMessage)iter.next();
            if (m.getSeverity() != FacesMessage.SEVERITY_ERROR) continue;
            return true;
        }
        return false;
    }

    public FacesMessage getFieldValueErrorMessage(FacesContext context, Exception e, Object value) {
        if (!(e instanceof EmpireException)) {
            e = new FieldIllegalValueException(this.getColumn(), StringUtils.valueOf((Object)value), (Throwable)e);
        }
        String msgText = this.getTextResolver(context).getExceptionMessage(e);
        return new FacesMessage(FacesMessage.SEVERITY_ERROR, msgText, msgText);
    }

    public void addFieldValueErrorMessage(FacesContext context, Exception e, Object value) {
        FacesMessage msg = this.getFieldValueErrorMessage(context, e, value);
        context.addMessage(this.component.getClientId(), msg);
    }

    protected FormGridTag getFormGrid() {
        if (this.formGridTag != null) {
            return this.formGridTag;
        }
        UIOutput parent = this.component;
        while ((parent = parent.getParent()) != null) {
            if (!(parent instanceof FormGridTag)) continue;
            this.formGridTag = (FormGridTag)parent;
            return this.formGridTag;
        }
        return null;
    }

    public ControlRenderInfo getControlRenderInfo() {
        FormGridTag formGrid = this.getFormGrid();
        return formGrid != null ? formGrid.getControlRenderInfo() : null;
    }

    public String getControlExtraLabelWrapperStyle() {
        if (!ControlRenderInfo.isRenderExtraWrapperStyles()) {
            return null;
        }
        String labelClass = this.getTagAttributeStringEx("labelClass", true);
        return labelClass;
    }

    public String getControlExtraInputWrapperStyle() {
        String inputClass;
        if (!ControlRenderInfo.isRenderExtraWrapperStyles()) {
            return null;
        }
        String string = inputClass = this.isControlTagElementValid() ? this.getTagAttributeStringEx("styleClass", true) : this.getTagAttributeString("inputClass");
        if (this.isRenderValueComponent()) {
            inputClass = inputClass != null ? StringUtils.concat((String[])new String[]{inputClass, SPACE, TagStyleClass.INPUT_DIS.get()}) : TagStyleClass.INPUT_DIS.get();
        }
        return inputClass;
    }

    protected boolean isControlTagElementValid() {
        ControlRenderInfo cri = this.getControlRenderInfo();
        return cri != null && cri.CONTROL_TAG != null;
    }

    protected String getLabelValue(Column column, boolean colon) {
        String label = this.getTagAttributeString("label");
        if (label == null) {
            if (this.hasFormat("short") && (label = StringUtils.toString((Object)column.getAttribute(COLATTR_ABBR_TITLE))) == null) {
                log.warn("No Abbreviation available for column {}. Using normal title.", (Object)column.getName());
            }
            if (label == null) {
                label = column.getTitle();
            }
            label = this.getDisplayText(label);
        }
        if (StringUtils.isEmpty((String)label)) {
            return "";
        }
        if (colon) {
            label = label.trim() + ":";
        }
        return label;
    }

    public HtmlOutputLabel createLabelComponent(FacesContext context, String forInput, String styleClass, String style, boolean colon) {
        String title;
        if (StringUtils.isNotEmpty((String)forInput)) {
            if (!forInput.equals("*")) {
                UIComponent input = FacesUtils.getWebApplication().findComponent(context, forInput, (UIComponent)this.component);
                if (input != null && input instanceof InputTag) {
                    InputTag inputTag = (InputTag)input;
                    this.setColumn(inputTag.getInputColumn());
                    this.readOnly = inputTag.isInputReadOnly() ? (byte)1 : 0;
                    this.valueRequired = inputTag.isInputRequired() ? (byte)1 : 0;
                } else {
                    log.warn("Input component {} not found for label {}.", (Object)forInput, (Object)this.getColumn().getName());
                }
            } else if (this.component instanceof LabelTag) {
                forInput = this.getColumnName();
                Object val = this.getTagAttributeValueEx("readOnly", false);
                if (val != null) {
                    this.readOnly = ObjectUtils.getBoolean((Object)val) ? (byte)1 : 0;
                }
            }
        }
        HtmlOutputLabel label = InputControlManager.createComponent(context, InputControlManager.getLabelComponentClass());
        String labelText = this.getLabelValue(this.getColumn(), colon);
        if (StringUtils.isEmpty((String)labelText)) {
            label.setRendered(false);
        } else {
            label.setValue((Object)labelText);
        }
        String labelClass = null;
        if (!ControlRenderInfo.isRenderExtraWrapperStyles()) {
            labelClass = this.getTagAttributeStringEx("labelClass", true);
        }
        if (labelClass != null) {
            styleClass = this.assembleStyleClassString(styleClass, labelClass);
        }
        if (StringUtils.isNotEmpty((String)styleClass)) {
            label.setStyleClass(this.completeLabelStyleClass(styleClass, this.isValueRequired()));
        }
        if (StringUtils.isNotEmpty((String)forInput) && !this.isReadOnly()) {
            InputControl.InputInfo ii = this.getInputInfo(context);
            String inputId = this.getInputControl().getLabelForId(ii);
            if (StringUtils.isNotEmpty((String)inputId)) {
                if (forInput.equals("*")) {
                    label.setFor(inputId);
                } else {
                    label.setFor(forInput + ":" + inputId);
                }
            } else {
                log.info("No input-id provided for {}.", (Object)this.getColumn().getName());
            }
        }
        if (StringUtils.isNotEmpty((String)style)) {
            label.setStyle(style);
        }
        if ((title = this.getLabelTooltip(this.column)) != null) {
            label.setTitle(title);
        }
        if (this.isValueRequired() && InputControlManager.isShowLabelRequiredMark()) {
            this.addRequiredMark(label);
        }
        return label;
    }

    public void updateLabelComponent(FacesContext context, HtmlOutputLabel label, String forInput) {
        boolean hasMark;
        InputTag inputTag = null;
        if (StringUtils.isNotEmpty((String)forInput)) {
            Object val;
            if (!forInput.equals("*")) {
                UIComponent input = FacesUtils.getWebApplication().findComponent(context, forInput, (UIComponent)this.component);
                if (input != null && input instanceof InputTag) {
                    inputTag = (InputTag)input;
                }
            } else if (this.component instanceof LabelTag && (val = this.getTagAttributeValueEx("readOnly", false)) != null) {
                this.readOnly = ObjectUtils.getBoolean((Object)val) ? (byte)1 : 0;
            }
        }
        boolean required = inputTag != null ? inputTag.isInputRequired() : this.isValueRequired();
        String styleClass = label.getStyleClass();
        label.setStyleClass(this.completeLabelStyleClass(styleClass, required));
        boolean bl = hasMark = label.getChildCount() > 0;
        if (required == hasMark) {
            return;
        }
        if (required && InputControlManager.isShowLabelRequiredMark()) {
            this.addRequiredMark(label);
        } else {
            label.getChildren().clear();
        }
    }

    protected String completeLabelStyleClass(String styleClasses, boolean required) {
        styleClasses = TagStyleClass.INPUT_REQ.addOrRemove(styleClasses, required);
        return styleClasses;
    }

    protected void addRequiredMark(HtmlOutputLabel label) {
        HtmlPanelGroup span = new HtmlPanelGroup();
        span.setStyleClass("required");
        HtmlOutputText text = new HtmlOutputText();
        text.setValue((Object)"*");
        span.getChildren().add(text);
        label.getChildren().add(span);
    }

    protected String assembleStyleClassString(String ... styles) {
        int totalLength = 0;
        String current = null;
        for (int i = 0; i < styles.length; ++i) {
            int len;
            int n = len = styles[i] != null ? styles[i].length() : 0;
            if (len <= 0 || current != null && current.equals(styles[i])) continue;
            current = styles[i];
            if (totalLength > 0 && !current.startsWith(SPACE)) {
                ++len;
            }
            totalLength += len;
        }
        if (current == null || current.length() == totalLength) {
            return current;
        }
        current = null;
        StringBuilder b = new StringBuilder(totalLength);
        for (int i = 0; i < styles.length; ++i) {
            int len;
            int n = len = styles[i] != null ? styles[i].length() : 0;
            if (len <= 0 || current != null && current.equals(styles[i])) continue;
            current = styles[i];
            if (b.length() > 0 && !current.startsWith(SPACE)) {
                b.append(SPACE);
            }
            b.append(current);
        }
        return b.toString();
    }

    @Deprecated
    protected String getDataTypeClass(DataType type) {
        switch (type) {
            case AUTOINC: 
            case INTEGER: {
                return CSS_DATA_TYPE_INT;
            }
            case DECIMAL: {
                return this.getValueOptions() != null ? CSS_DATA_TYPE_TEXT : CSS_DATA_TYPE_NUMBER;
            }
            case FLOAT: {
                return CSS_DATA_TYPE_NUMBER;
            }
            case VARCHAR: 
            case CHAR: {
                return CSS_DATA_TYPE_TEXT;
            }
            case DATE: {
                return CSS_DATA_TYPE_DATE;
            }
            case DATETIME: 
            case TIMESTAMP: {
                return CSS_DATA_TYPE_DATETIME;
            }
            case BOOL: {
                return CSS_DATA_TYPE_BOOL;
            }
            case CLOB: {
                return CSS_DATA_TYPE_LONGTEXT;
            }
        }
        return CSS_DATA_TYPE_NONE;
    }

    public String getSimpleStyleClass(String userStyle) {
        return this.assembleStyleClassString(this.cssStyleClass, userStyle);
    }

    public String getSimpleStyleClass() {
        String userStyle = this.getTagAttributeString("styleClass");
        return this.getSimpleStyleClass(userStyle);
    }

    public String getTagStyleClass(String typeClass, String addlStyle, String userStyle) {
        String contextStyle = this.getContextStyleClass();
        return this.assembleStyleClassString(this.cssStyleClass, typeClass, addlStyle, userStyle, contextStyle);
    }

    public String getTagStyleClass(String typeClass, String addlStyle) {
        String userStyle = this.getTagAttributeStringEx("styleClass", true);
        return this.getTagStyleClass(typeClass, addlStyle, userStyle);
    }

    public String getTagStyleClass(String addlStyle) {
        String typeClass = this.control != null ? this.control.getCssStyleClass() : null;
        return this.getTagStyleClass(typeClass, addlStyle);
    }

    public String getContextStyleClass() {
        if (this.getRecord() instanceof TagContextInfo && this.hasColumn()) {
            return ((TagContextInfo)this.getRecord()).getContextStyleClass(this.getColumn());
        }
        return null;
    }

    protected boolean detectInsideUIData() {
        for (UIComponent p = this.component.getParent(); p != null; p = p.getParent()) {
            if (p instanceof UIData) {
                return true;
            }
            if (!"facelets.ui.Repeat".equals(p.getRendererType())) continue;
            return true;
        }
        return false;
    }

    public final boolean isInsideUIData() {
        if (this.component == null) {
            return false;
        }
        if (this.insideUIData < 0) {
            this.insideUIData = this.detectInsideUIData() ? (byte)1 : 0;
        }
        return this.insideUIData > 0;
    }

    public static String buildComponentId(String s) {
        if (s == null || s.length() == 0) {
            return null;
        }
        StringBuilder b = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            int c = s.charAt(i);
            if (!(c == 95 || StringUtils.isCharBetween((char)c, (char)'A', (char)'Z') || StringUtils.isCharBetween((char)c, (char)'a', (char)'z') || StringUtils.isNumber((char)c))) {
                c = 45;
            }
            b.append((char)c);
        }
        return b.toString();
    }

    public static boolean hasComponentId(UIComponent component) {
        String id = component.getId();
        return id != null && id.length() > 0 && !id.startsWith(FACES_ID_PREFIX);
    }

    public boolean hasComponentId() {
        return TagEncodingHelper.hasComponentId((UIComponent)this.component);
    }

    public void saveComponentId(UIComponent comp) {
        if (comp == null || comp.getId() == null) {
            return;
        }
        String compId = comp.getId();
        comp.getAttributes().put(ORIGINAL_COMPONENT_ID, compId);
        comp.setId(compId);
    }

    public void restoreComponentId(UIComponent comp) {
        if (comp == null) {
            return;
        }
        String compId = StringUtils.toString(comp.getAttributes().get(ORIGINAL_COMPONENT_ID));
        if (compId == null) {
            return;
        }
        if (!StringUtils.compareEqual((String)compId, (String)comp.getId(), (boolean)false)) {
            log.warn("Restoring original Component-id from {} to {}", (Object)comp.getId(), (Object)compId);
            comp.setId(compId);
        }
    }

    public void resetComponentId(UIComponent comp) {
        if (comp == null || comp.getId() == null) {
            return;
        }
        if (this.isInsideUIData()) {
            String resetId = comp.getId();
            if (log.isInfoEnabled()) {
                log.info("Resetting Component-id inside UIData to {}", (Object)resetId);
            }
            comp.setId(resetId);
        }
    }

    public Object getTagAttributeValue(String name) {
        Object value = this.component.getAttributes().get(name);
        return value;
    }

    public String getTagAttributeString(String name, String defValue) {
        Object value = this.getTagAttributeValue(name);
        String sval = StringUtils.nullIfEmpty((Object)value);
        return sval == null ? defValue : sval;
    }

    public String getTagAttributeString(String name) {
        return this.getTagAttributeString(name, null);
    }

    public Object getTagAttributeValueEx(String name, boolean isCssStyleClass) {
        boolean useControlTagOverride = "styleClass".equals(name) && this.component instanceof ControlTag && this.isControlTagElementValid();
        Object value = this.getTagAttributeValue(useControlTagOverride ? "inputClass" : name);
        boolean append = false;
        if (isCssStyleClass && value instanceof String && ((String)value).length() > 0) {
            if (((String)value).charAt(0) == '!') {
                value = ((String)value).substring(1);
            } else {
                if (((String)value).equals("-")) {
                    return null;
                }
                append = true;
            }
        }
        if ((value == null || append) && this.hasColumn()) {
            Object colValue = this.column.getAttribute(name);
            if (append) {
                if (ObjectUtils.isNotEmpty((Object)colValue) && !colValue.equals(value)) {
                    value = StringUtils.concat((String[])new String[]{colValue.toString(), SPACE, value.toString()});
                }
            } else {
                value = colValue;
            }
        }
        if (value instanceof Column) {
            Column col = (Column)value;
            Object rec = this.getRecord();
            if (rec instanceof Record) {
                return ((Record)rec).get((ColumnExpr)col);
            }
            if (rec != null) {
                String property = col.getBeanPropertyName();
                try {
                    PropertyUtilsBean pub = BeanUtilsBean.getInstance().getPropertyUtils();
                    return pub.getSimpleProperty(rec, property);
                }
                catch (Exception e) {
                    log.error("BeanUtils.getSimpleProperty failed for " + property, (Throwable)e);
                    return null;
                }
            }
            return null;
        }
        return value;
    }

    public String getTagAttributeStringEx(String name, boolean isCssStyleClass) {
        Object value = this.getTagAttributeValueEx(name, isCssStyleClass);
        return value != null ? StringUtils.nullIfEmpty((Object)value) : null;
    }

    public void writeComponentId(ResponseWriter writer, boolean renderAutoId) throws IOException {
        if (renderAutoId || this.hasComponentId()) {
            writer.writeAttribute("id", (Object)this.component.getClientId(), null);
        }
    }

    public void writeComponentId(ResponseWriter writer) throws IOException {
        this.writeComponentId(writer, this.component instanceof NamingContainer);
    }

    public void writeAttribute(ResponseWriter writer, String attribute, Object value) throws IOException {
        if (value != null && !ObjectUtils.isEmpty((Object)value)) {
            writer.writeAttribute(attribute, value, null);
        }
    }

    public void writeStyleClass(ResponseWriter writer, String ... styleClasses) throws IOException {
        int i;
        String styleClass = null;
        for (i = 0; i < styleClasses.length; ++i) {
            if (styleClasses[i] == null) continue;
            if (styleClass != null) break;
            styleClass = styleClasses[i];
        }
        if (i < styleClasses.length) {
            styleClass = StringUtils.arrayToString((Object[])styleClasses, (String)SPACE, null);
        }
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, null);
        }
    }

    public void writeStyleClass(ResponseWriter writer) throws IOException {
        String userStyle = this.getTagAttributeStringEx("styleClass", true);
        this.writeStyleClass(writer, this.cssStyleClass, userStyle);
    }

    public String writeWrapperTag(FacesContext context, boolean renderId, boolean renderValue) throws IOException {
        String wrapperClass = this.getTagAttributeStringEx("wrapperClass", true);
        if (wrapperClass == null || wrapperClass.equals("-")) {
            return null;
        }
        String tagName = "div";
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement(tagName, (UIComponent)this.component);
        if (renderId) {
            this.writeComponentId(writer);
        }
        String contextClass = renderValue ? TagStyleClass.VALUE_WRAPPER.get() : TagStyleClass.INPUT_WRAPPER.get();
        this.writeStyleClass(writer, contextClass, wrapperClass);
        return tagName;
    }

    static {
        SMART_COLUMN_NAME_SET.add("ID");
        SMART_COLUMN_NAME_SET.add("NAME");
        SMART_COLUMN_NAME_SET.add("STATUS");
        TAGLIB_ATTR_PREFIX = "${";
        CSS_DATA_TYPE_NONE = null;
    }

    protected class InputInfoImpl
    extends ValueInfoImpl
    implements InputControl.InputInfo {
        public InputInfoImpl(Column column, TextResolver resolver) {
            super(column, resolver);
        }

        @Override
        public void setValue(Object value) {
            TagEncodingHelper.this.setDataValue(value);
        }

        @Override
        public void validate(Object value) {
            if (TagEncodingHelper.this.skipValidation) {
                return;
            }
            boolean isNull = ObjectUtils.isEmpty((Object)value);
            if (isNull && TagEncodingHelper.this.validateNullValue()) {
                return;
            }
            if (TagEncodingHelper.this.getRecord() instanceof Record) {
                ((Record)TagEncodingHelper.this.getRecord()).validateValue(TagEncodingHelper.this.column, value);
            } else {
                TagEncodingHelper.this.column.validateValue(value);
            }
        }

        @Override
        public boolean isRequired() {
            return TagEncodingHelper.this.isValueRequired();
        }

        @Override
        public boolean isModified() {
            return TagEncodingHelper.this.isValueModified();
        }

        @Override
        public boolean isDisabled() {
            return TagEncodingHelper.this.isDisabled();
        }

        @Override
        public InputControl.DisabledType getDisabled() {
            return TagEncodingHelper.this.getDisabled();
        }

        @Override
        public String getInputId() {
            return "inp";
        }

        @Override
        public boolean hasError() {
            return TagEncodingHelper.this.detectError(FacesContext.getCurrentInstance());
        }

        @Override
        public Object getAttribute(String name) {
            return TagEncodingHelper.this.getTagAttributeValue(name);
        }

        @Override
        public Object getAttributeEx(String name) {
            return TagEncodingHelper.this.getTagAttributeValueEx(name, "styleClass".equals(name));
        }
    }

    protected class ValueInfoImpl
    implements InputControl.ValueInfo {
        private String format = null;

        public ValueInfoImpl(Column column, TextResolver resolver) {
            if (column == null) {
                throw new InvalidArgumentException("column", (Object)resolver);
            }
            if (resolver == null) {
                throw new InvalidArgumentException("resolver", (Object)resolver);
            }
        }

        protected void reset() {
            this.format = null;
        }

        protected boolean hasColumn() {
            return TagEncodingHelper.this.column != null || TagEncodingHelper.this.hasColumn();
        }

        @Override
        public Column getColumn() {
            return TagEncodingHelper.this.column;
        }

        @Override
        public Object getValue(boolean evalExpression) {
            return TagEncodingHelper.this.getDataValue(evalExpression);
        }

        @Override
        public Options getOptions() {
            return TagEncodingHelper.this.getValueOptions();
        }

        @Override
        public String getStyleClass(String addlStyle) {
            String style = TagEncodingHelper.this.getTagStyleClass(addlStyle);
            return style;
        }

        @Override
        public String getFormat() {
            if (this.format == null) {
                this.format = TagEncodingHelper.this.getTagAttributeString("format");
                if (this.format == null && this.hasColumn()) {
                    this.format = StringUtils.toString((Object)TagEncodingHelper.this.column.getAttribute("format"));
                }
                if (this.format == null) {
                    this.format = "";
                }
            }
            return this.format;
        }

        @Override
        public Locale getLocale() {
            return TagEncodingHelper.this.textResolver.getLocale();
        }

        @Override
        public String getText(String text) {
            return TagEncodingHelper.this.textResolver.resolveText(text);
        }

        @Override
        public TextResolver getTextResolver() {
            return TagEncodingHelper.this.textResolver;
        }

        @Override
        public boolean isInsideUIData() {
            return TagEncodingHelper.this.isInsideUIData();
        }
    }

    protected static class ColumnExprWrapper
    implements Column,
    Unwrappable<ColumnExpr> {
        private final ColumnExpr expr;

        public ColumnExprWrapper(ColumnExpr expr) {
            this.expr = expr;
        }

        public ColumnExpr getExpr() {
            return this.expr;
        }

        public DataType getDataType() {
            return this.expr.getDataType();
        }

        public Class<Enum<?>> getEnumType() {
            return this.expr.getEnumType();
        }

        public EntityType getEntityType() {
            Column column = this.getUpdateColumn();
            return column != null ? column.getEntityType() : null;
        }

        public String getName() {
            return this.expr.getName();
        }

        public String getTitle() {
            return this.expr.getTitle();
        }

        public String getControlType() {
            return this.expr.getControlType();
        }

        public Object getAttribute(String name) {
            return this.expr.getAttribute(name);
        }

        public Set<Attributes.Attribute> getAttributes() {
            return this.expr.getUpdateColumn().getAttributes();
        }

        public Options getOptions() {
            return this.expr.getOptions();
        }

        public String getBeanPropertyName() {
            return this.expr.getBeanPropertyName();
        }

        public Column getUpdateColumn() {
            return this.expr.getUpdateColumn();
        }

        @Deprecated
        public Column getSourceColumn() {
            return this.getUpdateColumn();
        }

        public boolean isWrapper() {
            return true;
        }

        public ColumnExpr unwrap() {
            return this.expr;
        }

        public double getSize() {
            return 0.0;
        }

        public boolean isRequired() {
            return false;
        }

        public boolean isAutoGenerated() {
            return false;
        }

        public boolean isReadOnly() {
            return true;
        }

        public Object validateValue(Object value) {
            log.warn("validate not supported for {}", (Object)this.expr.getName());
            return value;
        }
    }
}

