/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.data.bean;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.Options;
import org.apache.empire.data.Column;
import org.apache.empire.data.ColumnExpr;
import org.apache.empire.data.EntityType;
import org.apache.empire.data.Record;
import org.apache.empire.data.bean.BeanClass;
import org.apache.empire.exceptions.BeanPropertyGetException;
import org.apache.empire.exceptions.BeanPropertySetException;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.ItemNotFoundException;
import org.apache.empire.exceptions.ObjectNotValidException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanRecordProxy<T>
implements Record {
    protected static final Logger log = LoggerFactory.getLogger(BeanRecordProxy.class);
    protected final EntityType entity;
    protected final List<Column> columns;
    protected final Column[] keyColumns;
    protected T data;
    protected boolean[] modified;

    public BeanRecordProxy(T data, List<Column> columns, Column[] keyColumns, EntityType entity) {
        this.data = data;
        this.columns = columns;
        this.keyColumns = keyColumns;
        this.entity = entity;
    }

    public BeanRecordProxy(List<Column> columns, Column[] keyColumns, EntityType entity) {
        this(null, columns, keyColumns, entity);
    }

    public BeanRecordProxy(T data, BeanClass beanClass) {
        this(data, ObjectUtils.convert(Column.class, beanClass.getProperties()), beanClass.getKeyColumns(), beanClass);
    }

    public BeanRecordProxy(BeanClass beanClass) {
        this(null, beanClass);
    }

    public T getBean() {
        return this.data;
    }

    public void setBean(T data) {
        this.data = data;
    }

    @Override
    public Column getColumn(int index) {
        return this.columns.get(index);
    }

    @Override
    public Column[] getKeyColumns() {
        return this.keyColumns;
    }

    @Override
    public Object[] getKey() {
        if (this.keyColumns == null) {
            return null;
        }
        Object[] key = new Object[this.keyColumns.length];
        for (int i = 0; i < this.keyColumns.length; ++i) {
            key[i] = this.get(this.keyColumns[i]);
        }
        return key;
    }

    @Override
    public int getFieldCount() {
        return this.columns.size();
    }

    @Override
    public int getFieldIndex(ColumnExpr column) {
        for (int i = 0; i < this.columns.size(); ++i) {
            if (!this.columns.get(i).equals(column)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getFieldIndex(String columnName) {
        for (int i = 0; i < this.columns.size(); ++i) {
            if (!this.columns.get(i).getName().equals(columnName)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Options getFieldOptions(Column column) {
        return column.getOptions();
    }

    @Override
    public boolean isFieldVisible(Column column) {
        return true;
    }

    @Override
    public boolean isFieldReadOnly(Column column) {
        if (!this.isNew() && ObjectUtils.contains(this.keyColumns, column)) {
            return true;
        }
        if (column.isAutoGenerated()) {
            return true;
        }
        return column.isReadOnly();
    }

    @Override
    public boolean isFieldRequired(Column column) {
        return column.isRequired();
    }

    @Override
    public boolean isModified() {
        return this.modified != null;
    }

    @Override
    public boolean isNew() {
        if (!this.isValid()) {
            throw new ObjectNotValidException(this);
        }
        if (this.keyColumns != null) {
            for (int i = 0; i < this.keyColumns.length; ++i) {
                Object value = this.get(this.keyColumns[i]);
                if (value instanceof Number && ((Number)value).longValue() == 0L) {
                    return true;
                }
                if (!ObjectUtils.isEmpty(value)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public EntityType getEntityType() {
        return this.entity;
    }

    @Override
    public boolean isValid() {
        return this.data != null;
    }

    @Override
    public boolean isReadOnly() {
        return !this.isValid();
    }

    @Override
    public Object get(ColumnExpr column) {
        if (!this.isValid()) {
            throw new ObjectNotValidException(this);
        }
        return this.getBeanProperty(this.data, column);
    }

    @Override
    public Object getValue(int index) {
        return this.get(this.getColumn(index));
    }

    @Override
    public boolean isNull(ColumnExpr column) {
        return ObjectUtils.isEmpty(this.get(column));
    }

    @Override
    public boolean isNull(int index) {
        return this.isNull(this.getColumn(index));
    }

    @Override
    public Object validateValue(Column column, Object value) {
        return column.validateValue(value);
    }

    @Override
    public BeanRecordProxy<T> set(Column column, Object value) {
        if (!this.isValid()) {
            throw new ObjectNotValidException(this);
        }
        if (!ObjectUtils.compareEqual(this.get(column), value)) {
            if (this.modified == null) {
                this.modified = new boolean[this.columns.size()];
            }
            this.modified[this.getFieldIndex((ColumnExpr)column)] = true;
        }
        value = this.validateValue(column, value);
        this.setBeanProperty(this.data, column, value);
        return this;
    }

    @Override
    public final void setValue(int i, Object value) {
        this.set(this.getColumn(i), value);
    }

    @Override
    public boolean wasModified(Column column) {
        int index = this.getFieldIndex(column);
        if (index < 0) {
            throw new ItemNotFoundException((Object)column.getName());
        }
        return this.modified != null && this.modified[index];
    }

    public void clearModified() {
        this.modified = null;
    }

    public int setBeanProperties(Object bean) {
        return this.setBeanProperties(bean, null);
    }

    @Override
    public int setBeanProperties(Object bean, Collection<? extends ColumnExpr> ignoreList) {
        int count = 0;
        for (int i = 0; i < this.getFieldCount(); ++i) {
            Column column = this.getColumn(i);
            if (column.isReadOnly() || ignoreList != null && ignoreList.contains(column)) continue;
            this.setBeanProperty(bean, column, this.getValue(i));
        }
        return count;
    }

    @Override
    public int setRecordValues(Object bean, Collection<Column> ignoreList) {
        int count = 0;
        for (int i = 0; i < this.getFieldCount(); ++i) {
            Column column = this.getColumn(i);
            if (column.isReadOnly() || ignoreList != null && ignoreList.contains(column)) continue;
            String property = column.getBeanPropertyName();
            Object value = this.getBeanProperty(bean, property);
            this.set(column, value);
            ++count;
        }
        return count;
    }

    @Override
    public int setRecordValues(Object bean) {
        return this.setRecordValues(bean, null);
    }

    protected final Object getBeanProperty(Object bean, ColumnExpr column) {
        if (bean == null) {
            throw new InvalidArgumentException("bean", bean);
        }
        if (column == null) {
            throw new InvalidArgumentException("column", column);
        }
        return this.getBeanProperty(bean, column.getBeanPropertyName());
    }

    protected Object getBeanProperty(Object bean, String property) {
        if (bean == null) {
            throw new InvalidArgumentException("bean", bean);
        }
        if (property == null) {
            throw new InvalidArgumentException("property", property);
        }
        try {
            PropertyUtilsBean pub = BeanUtilsBean.getInstance().getPropertyUtils();
            return pub.getSimpleProperty(bean, property);
        }
        catch (IllegalAccessException e) {
            log.error(bean.getClass().getName() + ": unable to get property '" + property + "'");
            throw new BeanPropertyGetException(bean, property, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.error(bean.getClass().getName() + ": unable to get property '" + property + "'");
            throw new BeanPropertyGetException(bean, property, (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            log.warn(bean.getClass().getName() + ": no getter available for property '" + property + "'");
            throw new BeanPropertyGetException(bean, property, (Throwable)e);
        }
    }

    protected void setBeanProperty(Object bean, Column column, Object value) {
        if (bean == null) {
            throw new InvalidArgumentException("bean", bean);
        }
        if (column == null) {
            throw new InvalidArgumentException("column", column);
        }
        String property = column.getBeanPropertyName();
        try {
            if (ObjectUtils.isEmpty(value)) {
                value = null;
            }
            if (value != null) {
                BeanUtils.setProperty((Object)bean, (String)property, (Object)value);
            } else {
                PropertyUtils.setProperty((Object)bean, (String)property, null);
            }
        }
        catch (IllegalArgumentException e) {
            log.error(bean.getClass().getName() + ": invalid argument for property '" + property + "'");
            throw new BeanPropertySetException(bean, property, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error(bean.getClass().getName() + ": unable to set property '" + property + "'");
            throw new BeanPropertySetException(bean, property, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.error(bean.getClass().getName() + ": unable to set property '" + property + "'");
            throw new BeanPropertySetException(bean, property, (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            log.error(bean.getClass().getName() + ": no setter available for property '" + property + "'");
            throw new BeanPropertySetException(bean, property, (Throwable)e);
        }
    }
}

