/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.data.list;

import java.io.Serializable;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.Options;
import org.apache.empire.data.ColumnExpr;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBObject;

public class DataListHead
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final ColumnExpr[] columns;
    protected String columnSeparator = "\t";

    public DataListHead(ColumnExpr[] columns) {
        this.columns = columns;
    }

    public ColumnExpr[] getColumns() {
        return this.columns;
    }

    public int getColumnIndex(ColumnExpr column) {
        int i = ObjectUtils.indexOf(this.columns, column);
        if (i >= 0) {
            return i;
        }
        return this.getColumnIndex(column.getName());
    }

    public int getColumnIndex(String columnName) {
        for (int i = 0; i < this.columns.length; ++i) {
            if (!columnName.equalsIgnoreCase(this.columns[i].getName())) continue;
            return i;
        }
        return -1;
    }

    public <T extends DBDatabase> T getDatabase(Class<T> dbClass) {
        for (int i = 0; i < this.columns.length; ++i) {
            Object db;
            if (!(this.columns[i] instanceof DBObject) || (db = ((DBObject)((Object)this.columns[i])).getDatabase()) == null || !dbClass.isAssignableFrom(db.getClass())) continue;
            return db;
        }
        return null;
    }

    public String getText(int idx, Object value) {
        String text;
        ColumnExpr column = this.columns[idx];
        Options options = column.getOptions();
        if (options != null && options.has(value)) {
            text = options.get(value);
        } else if (value instanceof String) {
            text = (String)value;
        } else if (ObjectUtils.isEmpty(value)) {
            value = column.getAttribute("nullText");
            text = value != null ? value.toString() : "";
        } else {
            text = this.formatValue(column, value);
            if (text == null) {
                text = "";
            }
        }
        return text;
    }

    protected String formatValue(ColumnExpr column, Object value) {
        return ObjectUtils.getString(value);
    }
}

