/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db;

import java.util.Set;
import org.apache.empire.commons.DateUtils;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBBlobData;
import org.apache.empire.db.DBClobData;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBExpr;
import org.apache.empire.db.DBSQLBuilder;
import org.apache.empire.db.expr.column.DBValueExpr;
import org.apache.empire.exceptions.InvalidOperationException;

public class DBCmdParam
extends DBExpr {
    protected DBCommand cmd;
    protected DataType type;
    protected Object value;
    protected Object reference;

    protected DBCmdParam(DBCommand cmd, DataType type, Object value) {
        this.cmd = cmd;
        this.type = type;
        this.value = this.getCmdParamValue(value);
    }

    public DBValueExpr getValueExpr(DBDatabase db) {
        return db.getValueExpr(this, this.type);
    }

    protected Object getCmdParamValue(Object value) {
        if (value instanceof DBExpr) {
            throw new InvalidOperationException("DBCmdParam does not accept DBExpr");
        }
        if (value != null) {
            value = ObjectUtils.convertValue(this.type, value);
        }
        if (value == null) {
            return value;
        }
        if (value instanceof Enum) {
            value = ObjectUtils.getEnumValue((Enum)value, this.type.isNumeric());
        }
        switch (this.type) {
            case BLOB: {
                if (value instanceof DBBlobData) {
                    return value;
                }
                if (value instanceof byte[]) {
                    return new DBBlobData((byte[])value);
                }
                return new DBBlobData(value.toString());
            }
            case CLOB: {
                if (value instanceof DBClobData) {
                    return value;
                }
                return new DBClobData(value.toString());
            }
            case DATE: {
                if (DBDatabase.SYSDATE.equals(value)) {
                    value = DateUtils.getDateNow();
                }
                return value;
            }
            case DATETIME: {
                if (DBDatabase.SYSDATE.equals(value)) {
                    value = DateUtils.getTimeNow();
                }
                return value;
            }
            case TIMESTAMP: 
            case UNKNOWN: {
                if (DBDatabase.SYSDATE.equals(value)) {
                    value = DateUtils.getTimestamp();
                }
                return value;
            }
        }
        return value;
    }

    @Override
    public void addSQL(DBSQLBuilder sql, long context) {
        sql.append("?");
        this.cmd.cmdParams.notifyParamUsage(this);
    }

    @Override
    public void addReferencedColumns(Set<DBColumn> list) {
    }

    public final DBDatabase getDatabase() {
        return this.cmd.getDatabase();
    }

    public DBCommand getCmd() {
        return this.cmd;
    }

    public DataType getDataType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = this.getCmdParamValue(value);
    }

    public Object getReference() {
        return this.reference;
    }

    public DBCmdParam setReference(Object reference) {
        this.reference = reference;
        return this;
    }
}

