/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.empire.commons.Attributes;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.OptionEntry;
import org.apache.empire.commons.Options;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.ColumnExpr;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBCmpType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBExpr;
import org.apache.empire.db.DBJoinType;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.expr.column.DBAliasExpr;
import org.apache.empire.db.expr.column.DBCalcExpr;
import org.apache.empire.db.expr.column.DBCaseExpr;
import org.apache.empire.db.expr.column.DBCaseWhenExpr;
import org.apache.empire.db.expr.column.DBCoalesceExpr;
import org.apache.empire.db.expr.column.DBConcatExpr;
import org.apache.empire.db.expr.column.DBConcatFuncExpr;
import org.apache.empire.db.expr.column.DBConvertExpr;
import org.apache.empire.db.expr.column.DBCountExpr;
import org.apache.empire.db.expr.column.DBDecodeExpr;
import org.apache.empire.db.expr.column.DBFuncExpr;
import org.apache.empire.db.expr.column.DBParenthesisExpr;
import org.apache.empire.db.expr.column.DBValueExpr;
import org.apache.empire.db.expr.compare.DBCompareColExpr;
import org.apache.empire.db.expr.compare.DBCompareExpr;
import org.apache.empire.db.expr.join.DBColumnJoinExpr;
import org.apache.empire.db.expr.order.DBOrderByExpr;
import org.apache.empire.dbms.DBSqlPhrase;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.NotSupportedException;
import org.w3c.dom.Element;

public abstract class DBColumnExpr
extends DBExpr
implements ColumnExpr {
    public static final String DBCOLATTR_TITLE = "title";
    public static final String DBCOLATTR_TYPE = "type";
    protected Attributes attributes = null;
    protected Options options = null;
    protected String beanPropertyName = null;

    @Override
    public abstract DataType getDataType();

    @Override
    public abstract String getName();

    public abstract DBRowSet getRowSet();

    @Override
    public abstract DBColumn getUpdateColumn();

    @Override
    @Deprecated
    public final DBColumn getSourceColumn() {
        return this.getUpdateColumn();
    }

    public abstract boolean isAggregate();

    public abstract Element addXml(Element var1, long var2);

    public DBColumnExpr qualified() {
        return this.as(this.getName());
    }

    @Override
    public Object getAttribute(String name) {
        if (this.attributes != null && this.attributes.indexOf(name) >= 0) {
            return this.attributes.get(name);
        }
        DBColumn column = this.getUpdateColumn();
        if (column == null || column == this) {
            return null;
        }
        return column.getAttribute(name);
    }

    public synchronized <T extends DBColumnExpr> T setAttribute(String name, Object value) {
        if (this.attributes == null) {
            this.attributes = new Attributes();
        }
        this.attributes.set(name, value);
        return (T)this;
    }

    @Override
    public Options getOptions() {
        if (this.options != null) {
            return this.options;
        }
        DBColumn column = this.getUpdateColumn();
        if (column == null || column == this) {
            return null;
        }
        return column.getOptions();
    }

    public <T extends DBColumnExpr> T setOptions(Options options) {
        this.options = options;
        return (T)this;
    }

    @Override
    public final String getTitle() {
        Object title = this.getAttribute(DBCOLATTR_TITLE);
        return StringUtils.toString(title);
    }

    public <T extends DBColumnExpr> T setTitle(String title) {
        return this.setAttribute(DBCOLATTR_TITLE, title);
    }

    @Override
    public final String getControlType() {
        Object type = this.getAttribute(DBCOLATTR_TYPE);
        return StringUtils.toString(type);
    }

    public final <T extends DBColumnExpr> T setControlType(String controlType) {
        return this.setAttribute(DBCOLATTR_TYPE, controlType);
    }

    @Override
    public String getBeanPropertyName() {
        if (this.beanPropertyName == null) {
            this.beanPropertyName = StringUtils.toCamelCase(this.getName(), false);
        }
        return this.beanPropertyName;
    }

    public <T extends DBColumnExpr> T setBeanPropertyName(String propertyName) {
        this.beanPropertyName = propertyName;
        return (T)this;
    }

    public DBColumnExpr append(Object value) {
        return new DBConcatExpr(this, value);
    }

    public DBColumnExpr as(String alias) {
        return new DBAliasExpr(this, alias);
    }

    public final DBColumnExpr as(DBColumn column) {
        return this.as(column.getName());
    }

    public DBCompareColExpr cmp(DBCmpType op, Object value) {
        return new DBCompareColExpr(this, op, value);
    }

    public final DBCompareColExpr like(Object value) {
        return this.cmp(DBCmpType.LIKE, value);
    }

    public DBCompareColExpr likeUpper(String value) {
        DBValueExpr expr = new DBValueExpr((DBDatabase)this.getDatabase(), value, DataType.VARCHAR);
        return new DBCompareColExpr(this.upper(), DBCmpType.LIKE, expr.upper());
    }

    public DBCompareColExpr likeLower(String value) {
        DBValueExpr expr = new DBValueExpr((DBDatabase)this.getDatabase(), value, DataType.VARCHAR);
        return new DBCompareColExpr(this.lower(), DBCmpType.LIKE, expr.lower());
    }

    public DBCompareColExpr like(String value, char escape) {
        DBValueExpr textExpr = new DBValueExpr((DBDatabase)this.getDatabase(), value, DataType.VARCHAR);
        DBFuncExpr escapeExpr = new DBFuncExpr(textExpr, DBSqlPhrase.SQL_FUNC_ESCAPE, new Object[]{String.valueOf(escape)}, DataType.VARCHAR);
        return this.cmp(DBCmpType.LIKE, escapeExpr);
    }

    public final DBCompareColExpr notLike(Object value) {
        return this.cmp(DBCmpType.NOTLIKE, value);
    }

    public final DBCompareColExpr is(Object value) {
        return this.cmp(DBCmpType.EQUAL, value);
    }

    public final DBCompareColExpr isNot(Object value) {
        return this.cmp(DBCmpType.NOTEQUAL, value);
    }

    public final DBCompareColExpr in(Collection<?> values) {
        if (values == null || values.isEmpty()) {
            return this.cmp(DBCmpType.EQUAL, null);
        }
        return this.cmp(DBCmpType.IN, values);
    }

    @SafeVarargs
    public final <T> DBCompareColExpr in(T ... values) {
        if (values == null || values.length == 0) {
            return this.cmp(DBCmpType.EQUAL, null);
        }
        return this.cmp(DBCmpType.IN, values);
    }

    public final DBCompareColExpr in(DBExpr expr) {
        return this.cmp(DBCmpType.IN, expr);
    }

    public final DBCompareColExpr notIn(Collection<?> values) {
        if (values == null || values.isEmpty()) {
            return this.cmp(DBCmpType.NOTEQUAL, null);
        }
        return this.cmp(DBCmpType.NOTIN, values);
    }

    @SafeVarargs
    public final <T> DBCompareColExpr notIn(T ... values) {
        if (values == null || values.length == 0) {
            return this.cmp(DBCmpType.NOTEQUAL, null);
        }
        return this.cmp(DBCmpType.NOTIN, values);
    }

    public final DBCompareColExpr notIn(DBExpr expr) {
        return this.cmp(DBCmpType.NOTIN, expr);
    }

    public final DBCompareColExpr isBetween(Object minValue, Object maxValue) {
        return this.cmp(DBCmpType.BETWEEN, new Object[]{minValue, maxValue});
    }

    public final DBCompareColExpr isNotBetween(Object minValue, Object maxValue) {
        return this.cmp(DBCmpType.NOTBETWEEN, new Object[]{minValue, maxValue});
    }

    public final DBCompareColExpr isGreaterThan(Object value) {
        return this.cmp(DBCmpType.GREATERTHAN, value);
    }

    public final DBCompareColExpr isMoreOrEqual(Object value) {
        return this.cmp(DBCmpType.MOREOREQUAL, value);
    }

    public final DBCompareColExpr isLessOrEqual(Object value) {
        return this.cmp(DBCmpType.LESSOREQUAL, value);
    }

    public final DBCompareColExpr isSmallerThan(Object value) {
        return this.cmp(DBCmpType.LESSTHAN, value);
    }

    public DBCalcExpr multiplyWith(Object value) {
        return new DBCalcExpr(this, "*", value);
    }

    public DBCalcExpr divideBy(Object value) {
        return new DBCalcExpr(this, "/", value);
    }

    public DBCalcExpr plus(Object value) {
        return new DBCalcExpr(this, "+", value);
    }

    public DBCalcExpr minus(Object value) {
        return new DBCalcExpr(this, "-", value);
    }

    public DBCalcExpr plus(int value) {
        return value >= 0 ? new DBCalcExpr(this, "+", new Integer(value)) : new DBCalcExpr(this, "-", new Integer(-value));
    }

    public DBCalcExpr minus(int value) {
        return value >= 0 ? new DBCalcExpr(this, "-", new Integer(value)) : new DBCalcExpr(this, "+", new Integer(-value));
    }

    protected DBColumnExpr getExprFromPhrase(DBSqlPhrase phrase, Object[] params, DataType dataType) {
        return new DBFuncExpr(this, phrase, params, dataType);
    }

    protected DBColumnExpr getExprFromPhrase(DBSqlPhrase phrase, Object[] params) {
        return this.getExprFromPhrase(phrase, params, this.getDataType());
    }

    public DBColumnExpr parenthesis() {
        return new DBParenthesisExpr(this);
    }

    public DBColumnExpr coalesce(Object nullValue) {
        return new DBCoalesceExpr(this, nullValue);
    }

    public DBColumnExpr modulo(Object divisor) {
        return this.getExprFromPhrase(DBSqlPhrase.SQL_FUNC_MOD, new Object[]{divisor});
    }

    @Deprecated
    public DBColumnExpr nvl(Object nullValue) {
        return this.coalesce(nullValue);
    }

    public DBColumnExpr substring(DBExpr pos) {
        return this.getExprFromPhrase(DBSqlPhrase.SQL_FUNC_SUBSTRING, new Object[]{pos});
    }

    public DBColumnExpr substring(int pos) {
        return this.substring(new DBValueExpr((DBDatabase)this.getDatabase(), pos, DataType.INTEGER));
    }

    public DBColumnExpr substring(DBExpr pos, DBExpr count) {
        return this.getExprFromPhrase(DBSqlPhrase.SQL_FUNC_SUBSTRINGEX, new Object[]{pos, count});
    }

    public DBColumnExpr substring(DBExpr pos, int count) {
        return this.substring(pos, (DBExpr)new DBValueExpr((DBDatabase)this.getDatabase(), count, DataType.INTEGER));
    }

    public DBColumnExpr substring(int pos, DBExpr count) {
        return this.substring((DBExpr)new DBValueExpr((DBDatabase)this.getDatabase(), pos, DataType.INTEGER), count);
    }

    public DBColumnExpr substring(int pos, int count) {
        return this.substring((DBExpr)new DBValueExpr((DBDatabase)this.getDatabase(), pos, DataType.INTEGER), (DBExpr)new DBValueExpr((DBDatabase)this.getDatabase(), count, DataType.INTEGER));
    }

    public DBColumnExpr replace(Object match, Object replace) {
        return this.getExprFromPhrase(DBSqlPhrase.SQL_FUNC_REPLACE, new Object[]{match, replace});
    }

    public DBColumnExpr reverse() {
        return this.getExprFromPhrase(DBSqlPhrase.SQL_FUNC_REVERSE, null);
    }

    public DBColumnExpr trim() {
        return this.getExprFromPhrase(DBSqlPhrase.SQL_FUNC_TRIM, null);
    }

    public DBColumnExpr trimLeft() {
        return this.getExprFromPhrase(DBSqlPhrase.SQL_FUNC_LTRIM, null);
    }

    public DBColumnExpr trimRight() {
        return this.getExprFromPhrase(DBSqlPhrase.SQL_FUNC_RTRIM, null);
    }

    public DBColumnExpr upper() {
        return this.getExprFromPhrase(DBSqlPhrase.SQL_FUNC_UPPER, null);
    }

    public DBColumnExpr lower() {
        return this.getExprFromPhrase(DBSqlPhrase.SQL_FUNC_LOWER, null);
    }

    public DBColumnExpr format(String format) {
        return this.getExprFromPhrase(DBSqlPhrase.SQL_FUNC_FORMAT, new Object[]{format}, DataType.VARCHAR);
    }

    public DBColumnExpr length() {
        return this.getExprFromPhrase(DBSqlPhrase.SQL_FUNC_LENGTH, null, DataType.INTEGER);
    }

    public DBColumnExpr indexOf(Object str) {
        return this.getExprFromPhrase(DBSqlPhrase.SQL_FUNC_STRINDEX, new Object[]{str}, DataType.INTEGER);
    }

    public DBColumnExpr indexOf(Object str, DBExpr fromPos) {
        return this.getExprFromPhrase(DBSqlPhrase.SQL_FUNC_STRINDEXFROM, new Object[]{str, fromPos}, DataType.INTEGER);
    }

    public DBColumnExpr indexOf(Object str, int fromPos) {
        return this.indexOf(str, new DBValueExpr((DBDatabase)this.getDatabase(), fromPos, DataType.INTEGER));
    }

    public DBColumnExpr concat(DBColumnExpr ... concatExprs) {
        return new DBConcatFuncExpr(this, concatExprs);
    }

    public DBColumnExpr concat(String separator, DBColumnExpr ... concatExprs) {
        return new DBConcatFuncExpr(this, separator, concatExprs);
    }

    public DBColumnExpr prepend(Object value) {
        String opertor = this.getDataType() == DataType.UNKNOWN ? "" : (this.getDataType().isText() ? ((DBDatabase)this.getDatabase()).getDbms().getSQLPhrase(DBSqlPhrase.SQL_CONCAT_EXPR) : "+");
        String template = StringUtils.concat("{0}", opertor, "?");
        return new DBFuncExpr(this, template, new Object[]{value}, false, this.getDataType());
    }

    public DBColumnExpr abs() {
        return this.getExprFromPhrase(DBSqlPhrase.SQL_FUNC_ABS, null);
    }

    public DBColumnExpr floor() {
        return this.getExprFromPhrase(DBSqlPhrase.SQL_FUNC_FLOOR, null);
    }

    public DBColumnExpr ceiling() {
        return this.getExprFromPhrase(DBSqlPhrase.SQL_FUNC_CEILING, null);
    }

    public DBColumnExpr round(int decimals) {
        return this.getExprFromPhrase(DBSqlPhrase.SQL_FUNC_ROUND, new Object[]{new Integer(decimals)});
    }

    public DBColumnExpr trunc(int decimals) {
        return this.getExprFromPhrase(DBSqlPhrase.SQL_FUNC_TRUNC, new Object[]{new Integer(decimals)});
    }

    public DBColumnExpr year() {
        return this.getExprFromPhrase(DBSqlPhrase.SQL_FUNC_YEAR, null);
    }

    public DBColumnExpr month() {
        return this.getExprFromPhrase(DBSqlPhrase.SQL_FUNC_MONTH, null);
    }

    public DBColumnExpr day() {
        return this.getExprFromPhrase(DBSqlPhrase.SQL_FUNC_DAY, null);
    }

    public DBColumnExpr sum() {
        return this.getExprFromPhrase(DBSqlPhrase.SQL_FUNC_SUM, null);
    }

    public DBColumnExpr min() {
        return this.getExprFromPhrase(DBSqlPhrase.SQL_FUNC_MIN, null);
    }

    public DBColumnExpr max() {
        return this.getExprFromPhrase(DBSqlPhrase.SQL_FUNC_MAX, null);
    }

    public DBColumnExpr avg() {
        return this.getExprFromPhrase(DBSqlPhrase.SQL_FUNC_AVG, null);
    }

    public DBColumnExpr stringAgg(String separator, DBOrderByExpr orderBy) {
        return this.getExprFromPhrase(DBSqlPhrase.SQL_FUNC_STRAGG, new Object[]{separator, orderBy});
    }

    public DBColumnExpr stringAgg(String separator) {
        return this.stringAgg(separator, this.asc());
    }

    public DBColumnExpr count() {
        return new DBCountExpr(this, false);
    }

    public DBColumnExpr countDistinct() {
        return new DBCountExpr(this, true);
    }

    public DBColumnExpr decodeEnum(Class<? extends Enum<?>> enumType, String otherwise) {
        if (enumType == null || !enumType.isEnum()) {
            throw new InvalidArgumentException("enumType", enumType);
        }
        boolean byOrdinal = this.getDataType().isNumeric();
        Enum<?>[] items = enumType.getEnumConstants();
        LinkedHashMap<Object, String> enumMap = new LinkedHashMap<Object, String>(items.length);
        for (int i = 0; i < items.length; ++i) {
            Object key = ObjectUtils.getEnumValue(items[i], byOrdinal);
            enumMap.put(key, items[i].toString());
        }
        return new DBDecodeExpr(this, enumMap, otherwise, DataType.VARCHAR);
    }

    public DBColumnExpr decodeSort(Class<? extends Enum<?>> enumType, boolean defaultToEnd) {
        if (enumType == null || !enumType.isEnum()) {
            throw new InvalidArgumentException("enumType", enumType);
        }
        Enum<?>[] items = enumType.getEnumConstants();
        LinkedHashMap<String, Integer> enumMap = new LinkedHashMap<String, Integer>(items.length);
        int sortOffset = defaultToEnd ? 0 : 1;
        for (int i = 0; i < items.length; ++i) {
            int sortValue = items[i].ordinal();
            String value = ObjectUtils.getString(items[i]);
            enumMap.put(value, sortValue + sortOffset);
        }
        int defaultValue = defaultToEnd ? items.length : 0;
        return new DBDecodeExpr(this, enumMap, defaultValue, DataType.INTEGER);
    }

    public DBColumnExpr decode(Map<?, ?> valueMap, Object otherwise) {
        DataType dataType = DataType.UNKNOWN;
        if (otherwise != null) {
            dataType = ((DBDatabase)this.getDatabase()).detectDataType(otherwise);
        }
        if (dataType == DataType.UNKNOWN) {
            for (Object v : valueMap.values()) {
                dataType = ((DBDatabase)this.getDatabase()).detectDataType(v);
                if (dataType == DataType.UNKNOWN) continue;
                break;
            }
        }
        return new DBDecodeExpr(this, valueMap, otherwise, dataType);
    }

    public final DBColumnExpr decode(Object key1, Object value1, Object otherwise) {
        HashMap<Object, Object> list = new HashMap<Object, Object>();
        list.put(key1, value1);
        return this.decode(list, otherwise);
    }

    public final DBColumnExpr decode(Object key1, Object value1, Object key2, Object value2, Object otherwise) {
        HashMap<Object, Object> list = new HashMap<Object, Object>();
        list.put(key1, value1);
        list.put(key2, value2);
        return this.decode(list, otherwise);
    }

    public final DBColumnExpr decode(Object key1, Object value1, Object key2, Object value2, Object key3, Object value3, Object otherwise) {
        HashMap<Object, Object> list = new HashMap<Object, Object>();
        list.put(key1, value1);
        list.put(key2, value2);
        list.put(key3, value3);
        return this.decode(list, otherwise);
    }

    public final DBColumnExpr decode(Options options, Object otherwise) {
        int size = options.size() + (otherwise != null ? 1 : 0);
        HashMap<Object, String> list = new HashMap<Object, String>(size);
        for (OptionEntry e : options) {
            list.put(e.getValue(), e.getText());
        }
        return this.decode(list, otherwise);
    }

    public final DBColumnExpr decode(Options options) {
        return this.decode(options, null);
    }

    public final DBCaseExpr when(DBCompareExpr compExpr, Object otherwise) {
        DBColumnExpr elseExpr = null;
        if (otherwise instanceof DBColumnExpr) {
            elseExpr = (DBColumnExpr)otherwise;
        } else if (otherwise != null) {
            elseExpr = new DBValueExpr((DBDatabase)this.getDatabase(), otherwise, this.getDataType());
        }
        return new DBCaseWhenExpr(compExpr, this, (Object)elseExpr);
    }

    public DBColumnExpr toChar() {
        return this.convertTo(DataType.VARCHAR);
    }

    public DBColumnExpr toChar(String format) {
        return this.convertTo(DataType.VARCHAR, format);
    }

    public DBColumnExpr convertTo(DataType dataType, Object format) {
        return new DBConvertExpr(this, dataType, format);
    }

    public final DBColumnExpr convertTo(DataType dataType) {
        return this.convertTo(dataType, null);
    }

    public final DBColumnExpr function(String template, DataType returnType, Object ... params) {
        return new DBFuncExpr(this, template, params, false, returnType);
    }

    public final DBColumnExpr aggregate(String template, DataType returnType, Object ... params) {
        return new DBFuncExpr(this, template, params, true, returnType);
    }

    public DBOrderByExpr asc() {
        return new DBOrderByExpr(this, false);
    }

    public DBOrderByExpr desc() {
        return new DBOrderByExpr(this, true);
    }

    public DBColumnJoinExpr on(DBColumnExpr joinWith) {
        if (this.getRowSet() == null) {
            throw new NotSupportedException(this, "join");
        }
        if (joinWith.getRowSet() == null) {
            throw new NotSupportedException(joinWith, "join");
        }
        DBColumnJoinExpr join = new DBColumnJoinExpr(this, joinWith, DBJoinType.INNER);
        return join;
    }

    public Class<?> getJavaType() {
        return ((DBDatabase)this.getDatabase()).getColumnJavaType(this);
    }

    public String toString() {
        String name = this.getName();
        if (StringUtils.isNotEmpty(name)) {
            return this.getClass().getSimpleName() + "[" + name + "]";
        }
        return super.toString();
    }
}

