/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db;

import java.lang.ref.WeakReference;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.Options;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.Column;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBCmdParam;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBCommandExpr;
import org.apache.empire.db.DBContext;
import org.apache.empire.db.DBDDLGenerator;
import org.apache.empire.db.DBObject;
import org.apache.empire.db.DBRelation;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.DBSQLBuilder;
import org.apache.empire.db.DBSQLScript;
import org.apache.empire.db.DBTable;
import org.apache.empire.db.DBTableColumn;
import org.apache.empire.db.DBView;
import org.apache.empire.db.exceptions.DatabaseNotOpenException;
import org.apache.empire.db.exceptions.FieldIllegalValueException;
import org.apache.empire.db.exceptions.FieldNotNullException;
import org.apache.empire.db.exceptions.FieldValueOutOfRangeException;
import org.apache.empire.db.exceptions.FieldValueTooLongException;
import org.apache.empire.db.expr.column.DBCaseExpr;
import org.apache.empire.db.expr.column.DBCaseMapExpr;
import org.apache.empire.db.expr.column.DBCaseWhenExpr;
import org.apache.empire.db.expr.column.DBValueExpr;
import org.apache.empire.db.expr.compare.DBCompareExpr;
import org.apache.empire.dbms.DBMSHandler;
import org.apache.empire.dbms.DBSqlPhrase;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.InvalidOperationException;
import org.apache.empire.exceptions.ItemExistsException;
import org.apache.empire.exceptions.NotSupportedException;
import org.apache.empire.exceptions.ObjectNotValidException;
import org.apache.empire.exceptions.PropertyReadOnlyException;
import org.apache.empire.exceptions.ValueConversionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DBDatabase
extends DBObject {
    public static final DBSystemDate SYSDATE = new DBSystemDate();
    public static final String EMPTY_STRING = "\u0000";
    private static final Logger log = LoggerFactory.getLogger(DBDatabase.class);
    private static Map<String, WeakReference<DBDatabase>> databaseMap = new LinkedHashMap<String, WeakReference<DBDatabase>>();
    private String schema;
    private String linkName;
    private String instanceId;
    protected final List<DBTable> tables = new ArrayList<DBTable>();
    protected final List<DBRelation> relations = new ArrayList<DBRelation>();
    protected final List<DBView> views = new ArrayList<DBView>();
    protected final Map<String, DBRowSet> rowsetAliasMap = new HashMap<String, DBRowSet>();
    protected DBMSHandler dbms = null;
    private boolean autoPrepareStmt = true;
    protected boolean legacyDate = true;

    public static DBDatabase findByIdentifier(String dbIdent) {
        WeakReference<DBDatabase> ref = databaseMap.get(dbIdent);
        if (ref == null) {
            return null;
        }
        DBDatabase db = (DBDatabase)ref.get();
        if (db == null) {
            log.warn("Database width id='{}' habe been destroyed!", (Object)dbIdent);
            databaseMap.remove(dbIdent);
        }
        return db;
    }

    public static DBDatabase findByClass(Class<? extends DBDatabase> clazz) {
        for (WeakReference<DBDatabase> ref : databaseMap.values()) {
            DBDatabase db = (DBDatabase)ref.get();
            if (db == null || !clazz.isInstance(db)) continue;
            return db;
        }
        log.warn("Database of class {} not found!", (Object)clazz.getSimpleName());
        return null;
    }

    public DBDatabase(String schema, String linkName) {
        this.schema = schema;
        this.linkName = linkName;
        this.register(this.getClass().getSimpleName());
    }

    public DBDatabase(String schema) {
        this(schema, null);
    }

    public DBDatabase() {
        this(null, null);
    }

    public synchronized void discard() {
        if (this.isOpen()) {
            throw new InvalidOperationException("Database is open. Discard not possible.");
        }
        databaseMap.remove(this.instanceId);
        this.instanceId = null;
        this.tables.clear();
        this.relations.clear();
        this.views.clear();
    }

    protected synchronized void register(String dbid) {
        HashSet<String> invalidKeys = new HashSet<String>();
        for (Map.Entry<String, WeakReference<DBDatabase>> e : databaseMap.entrySet()) {
            DBDatabase dbInst = (DBDatabase)e.getValue().get();
            if (dbInst == this) {
                log.error("Instance of database " + this.getClass().getName() + " already registered. Not registering same instance twice!");
                throw new ItemExistsException((Object)e.getKey());
            }
            if (dbInst != null) continue;
            invalidKeys.add(e.getKey());
        }
        for (String key : invalidKeys) {
            databaseMap.remove(key);
        }
        invalidKeys.clear();
        if (DBDatabase.findByIdentifier(dbid) != null) {
            int maxInstId = 1;
            String instPrefix = dbid + ":";
            for (String key : databaseMap.keySet()) {
                int instId;
                if (databaseMap.get(key).get() == null) {
                    log.warn("Database width id='{}' habe been destroyed!", (Object)key);
                    continue;
                }
                if (!key.startsWith(instPrefix) || (instId = Integer.parseInt(key.substring(instPrefix.length()))) <= maxInstId) continue;
                maxInstId = instId;
            }
            this.instanceId = dbid + ":" + String.valueOf(maxInstId + 1);
        } else {
            this.instanceId = dbid;
        }
        log.info("Instance of database {} registered with instanceid={}", (Object)this.getClass().getName(), (Object)this.instanceId);
        databaseMap.put(this.instanceId, new WeakReference<DBDatabase>(this));
    }

    protected String getDefaultIdentifier() {
        return this.getClass().getSimpleName();
    }

    public String getIdentifier() {
        return this.instanceId;
    }

    public <T extends DBMSHandler> T getDbms() {
        return (T)this.dbms;
    }

    public boolean isPreparedStatementsEnabled() {
        return this.autoPrepareStmt;
    }

    public void setPreparedStatementsEnabled(boolean autoPrepareStmt) {
        this.autoPrepareStmt = autoPrepareStmt;
        log.info("PreparedStatementsEnabled is " + autoPrepareStmt);
    }

    public boolean checkExists(DBContext context) {
        return context.getDbms().checkExists(this, context.getConnection());
    }

    public void open(DBContext context) {
        DBMSHandler dbms = context.getDbms();
        if (dbms == this.dbms) {
            log.warn("Database already attached to this dbms");
        } else {
            if (this.dbms != null) {
                log.error("Database already attached to another dbms {}", (Object)this.dbms.getClass().getName());
                throw new NotSupportedException(this, "open");
            }
            dbms.attachDatabase(this, context.getConnection());
            this.dbms = dbms;
        }
    }

    public void close(DBContext context) {
        DBMSHandler dbms = context.getDbms();
        if (this.dbms == null) {
            log.warn("Database not attached to a dbms");
        } else {
            if (dbms != this.dbms) {
                log.error("Database attached to another dbms {}", (Object)this.dbms.getClass().getName());
                throw new NotSupportedException(this, "close");
            }
            this.dbms.detachDatabase(this, context.getConnection());
            this.dbms = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void getCreateDDLScript(DBSQLScript script) {
        DBMSHandler orgHandler = this.dbms;
        DBMSHandler ddlHandler = script.getContext().getDbms();
        try {
            if (this.dbms != null && this.dbms != ddlHandler && ddlHandler != null) {
                throw new InvalidOperationException("The database is attached to a different dbms.");
            }
            if (this.dbms == null) {
                this.dbms = ddlHandler;
            }
            this.generateDDLScript(script);
        }
        finally {
            this.dbms = orgHandler;
        }
    }

    protected void generateDDLScript(DBSQLScript script) {
        this.dbms.getDDLScript(DBDDLGenerator.DDLActionType.CREATE, this, script);
    }

    public DBDatabase getDatabase() {
        return this;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        if (this.dbms != null) {
            throw new PropertyReadOnlyException("schema");
        }
        this.schema = schema;
    }

    public String getSchemaPrefix() {
        if (this.schema == null) {
            return "";
        }
        return this.schema + ".";
    }

    public String getLinkName() {
        return this.linkName;
    }

    public void setLinkName(String linkName) {
        if (this.dbms != null) {
            throw new PropertyReadOnlyException(linkName);
        }
        this.linkName = linkName;
    }

    public void appendQualifiedName(DBSQLBuilder sql, String name, Boolean quoteName) {
        if (this.schema != null) {
            sql.append(this.schema);
            sql.append(".");
        }
        if (this.dbms == null) {
            log.warn("No dbms attached for appending qualified name {0}.", (Object)name);
            sql.append(name);
            return;
        }
        this.dbms.appendObjectName(sql, name, quoteName);
        if (this.linkName != null) {
            sql.append(this.dbms.getSQLPhrase(DBSqlPhrase.SQL_DATABASE_LINK));
            sql.append(this.linkName);
        }
    }

    public Class<?> getColumnJavaType(DBColumnExpr expr) {
        switch (expr.getDataType()) {
            case AUTOINC: {
                return Long.class;
            }
            case INTEGER: {
                int size;
                DBColumn source = expr.getUpdateColumn();
                int n = size = source != null ? (int)source.getSize() : 8;
                if (size <= 2) {
                    return Short.class;
                }
                if (size <= 4) {
                    return Integer.class;
                }
                return Long.class;
            }
            case VARCHAR: 
            case CLOB: 
            case CHAR: {
                return String.class;
            }
            case DATE: {
                return this.legacyDate ? Date.class : LocalDate.class;
            }
            case TIME: {
                return this.legacyDate ? Date.class : LocalTime.class;
            }
            case DATETIME: {
                return this.legacyDate ? Date.class : LocalDateTime.class;
            }
            case TIMESTAMP: {
                return Timestamp.class;
            }
            case FLOAT: {
                return Double.class;
            }
            case DECIMAL: {
                return BigDecimal.class;
            }
            case BOOL: {
                return Boolean.class;
            }
            case BLOB: {
                return byte[].class;
            }
        }
        return Object.class;
    }

    public DBValueExpr getSystemDateExpr() {
        return new DBValueExpr(this, SYSDATE, DataType.DATETIME);
    }

    public DBValueExpr getValueExpr(String value) {
        return new DBValueExpr(this, value, DataType.VARCHAR);
    }

    public DBValueExpr getValueExpr(boolean value) {
        return new DBValueExpr(this, value, DataType.BOOL);
    }

    public DBValueExpr getValueExpr(int value) {
        return new DBValueExpr(this, value, DataType.INTEGER);
    }

    public DBValueExpr getValueExpr(long value) {
        return new DBValueExpr(this, value, DataType.INTEGER);
    }

    public DBValueExpr getValueExpr(BigDecimal value) {
        return new DBValueExpr(this, value, DataType.DECIMAL);
    }

    public DBValueExpr getValueExpr(Object value, DataType dataType) {
        if (value instanceof DBValueExpr) {
            return (DBValueExpr)value;
        }
        return new DBValueExpr(this, value, dataType);
    }

    public DBValueExpr getParamExpr(DBCmdParam param) {
        return new DBValueExpr(this, param, param.getDataType());
    }

    public DBValueExpr getNullExpr() {
        return new DBValueExpr(this, null, DataType.UNKNOWN);
    }

    protected void addTable(DBTable table) {
        if (table == null || table.db != this) {
            throw new InvalidArgumentException("table", table);
        }
        DBTable existing = this.getTable(table.getName());
        if (existing == table) {
            return;
        }
        if (existing != null) {
            if (this.isSameRowSet(existing, table)) {
                this.addRowsetToAliasMap(table);
                return;
            }
            throw new ItemExistsException((Object)table.getName());
        }
        this.addRowsetToAliasMap(table);
        this.tables.add(table);
    }

    public void removeTable(DBTable table) {
        if (table == null || table.getDatabase() != this) {
            throw new InvalidArgumentException("table", table);
        }
        if (this.tables.contains(table)) {
            this.tables.remove(table);
        }
        this.removeRowsetFromAliasMap(table);
    }

    public List<DBTable> getTables() {
        return Collections.unmodifiableList(this.tables);
    }

    public DBTable getTable(String name) {
        for (int i = 0; i < this.tables.size(); ++i) {
            DBTable tab = this.tables.get(i);
            if (!tab.getName().equalsIgnoreCase(name)) continue;
            return tab;
        }
        return null;
    }

    public DBRowSet getRowSet(String name) {
        DBRowSet rset = this.getTable(name);
        if (rset == null) {
            rset = this.getView(name);
        }
        return rset;
    }

    public DBRowSet getRowSetByAlias(String alias) {
        return this.rowsetAliasMap.get(alias);
    }

    public Collection<DBRowSet> getAllRowSets() {
        return this.rowsetAliasMap.values();
    }

    public final DBRelation addRelation(DBRelation.DBReference reference) {
        String table = reference.getSourceColumn().getRowSet().getName();
        String col1 = reference.getSourceColumn().getName();
        String name = table.substring(0, Math.min(table.length(), 14)) + "_" + col1.substring(0, Math.min(col1.length(), 12)) + "_FK";
        return this.addRelation(name, reference);
    }

    public final DBRelation addRelation(DBRelation.DBReference ref1, DBRelation.DBReference ref2) {
        String table = ref1.getSourceColumn().getRowSet().getName();
        String col1 = ref1.getSourceColumn().getName();
        String col2 = ref2.getSourceColumn().getName();
        String name = table.substring(0, Math.min(table.length(), 9)) + "_" + col1.substring(0, Math.min(col1.length(), 9)) + "_" + col2.substring(0, Math.min(col2.length(), 9)) + "_FK";
        return this.addRelation(name, ref1, ref2);
    }

    public DBRelation addRelation(String name, DBRelation.DBReference ... references) {
        if (this.getRelation(name) != null) {
            throw new ItemExistsException((Object)name);
        }
        DBTable targetTable = (DBTable)references[0].getTargetColumn().getRowSet();
        DBRelation.DBCascadeAction deleteAction = targetTable.getDefaultCascadeDeleteAction();
        DBRelation relation = new DBRelation(this, name, references, deleteAction);
        if (this.relations.contains(relation)) {
            throw new ItemExistsException((Object)name);
        }
        for (DBRelation.DBReference ref : references) {
            DBRowSet rset = ref.getSourceColumn().getRowSet();
            rset.addColumnReference(ref.getSourceColumn(), ref.getTargetColumn());
        }
        this.relations.add(relation);
        return relation;
    }

    public void removeRelation(DBRelation relation) {
        if (relation == null || relation.getDatabase() != this) {
            throw new InvalidArgumentException("relation", relation);
        }
        this.relations.remove(relation);
    }

    public List<DBRelation> getRelations() {
        return Collections.unmodifiableList(this.relations);
    }

    public DBRelation getRelation(String relationName) {
        for (DBRelation r : this.relations) {
            String name = r.getName();
            if (relationName.compareToIgnoreCase(name) != 0) continue;
            return r;
        }
        return null;
    }

    protected void addView(DBView view) {
        if (view == null || view.db != this) {
            throw new InvalidArgumentException("view", view);
        }
        DBView existing = this.getView(view.getName());
        if (existing == view) {
            return;
        }
        if (existing != null) {
            if (this.isSameRowSet(existing, view)) {
                this.addRowsetToAliasMap(view);
                return;
            }
            throw new ItemExistsException((Object)view.getName());
        }
        this.addRowsetToAliasMap(view);
        this.views.add(view);
    }

    public void removeView(DBView view) {
        if (view == null || view.getDatabase() != this) {
            throw new InvalidArgumentException("view", view);
        }
        if (this.views.contains(view)) {
            this.views.remove(view);
        }
        this.removeRowsetFromAliasMap(view);
    }

    public List<DBView> getViews() {
        return Collections.unmodifiableList(this.views);
    }

    public DBView getView(String name) {
        for (int i = 0; i < this.views.size(); ++i) {
            DBView view = this.views.get(i);
            if (!view.getName().equalsIgnoreCase(name)) continue;
            return view;
        }
        return null;
    }

    public boolean isOpen() {
        return this.dbms != null;
    }

    protected void checkOpen() {
        if (!this.isOpen()) {
            throw new DatabaseNotOpenException(this);
        }
    }

    public DBCommand createCommand() {
        this.checkOpen();
        return this.dbms.createCommand(false);
    }

    public DataType detectDataType(Object value) {
        if (value instanceof DBColumnExpr) {
            return ((DBColumnExpr)value).getDataType();
        }
        if (value instanceof String) {
            return DataType.VARCHAR;
        }
        if (value instanceof Integer || value instanceof Long) {
            return DataType.INTEGER;
        }
        if (value instanceof Number) {
            return DataType.DECIMAL;
        }
        if (value instanceof Boolean) {
            return DataType.BOOL;
        }
        if (value instanceof Date) {
            return DataType.DATETIME;
        }
        if (value instanceof Character) {
            return DataType.CHAR;
        }
        if (value instanceof byte[]) {
            return DataType.BLOB;
        }
        if (value instanceof Enum) {
            return DataType.VARCHAR;
        }
        return DataType.UNKNOWN;
    }

    protected Object validateValue(DBTableColumn column, Object value) {
        DataType type = column.getDataType();
        if (ObjectUtils.isEmpty(value)) {
            if (column.isRequired()) {
                throw new FieldNotNullException(column);
            }
            return null;
        }
        if (value instanceof DBColumnExpr) {
            DataType funcType = ((DBColumnExpr)value).getDataType();
            if (!type.isCompatible(funcType)) {
                log.info("Incompatible data types in expression for column {} using function {}!", (Object)column.getName(), (Object)value.toString());
                throw new FieldIllegalValueException(column, String.valueOf(value));
            }
            return value;
        }
        if (value instanceof DBCommandExpr) {
            List<DBColumnExpr> exprList = ((DBCommandExpr)value).getSelectExpressions();
            if (exprList.size() != 1) {
                log.info("Invalid command expression for column {} using command {}!", (Object)column.getName(), (Object)((DBCommandExpr)value).getSelect());
                throw new FieldIllegalValueException(column, ((DBCommandExpr)value).getSelect());
            }
            if (!type.isCompatible(exprList.get(0).getDataType())) {
                log.info("Incompatible data types in expression for column {} using function {}!", (Object)column.getName(), (Object)value.toString());
                throw new FieldIllegalValueException(column, String.valueOf(value));
            }
            return value;
        }
        switch (type) {
            case DATE: {
                if (value instanceof LocalDate) break;
                if (value instanceof LocalDateTime) {
                    value = ((LocalDateTime)value).toLocalDate();
                    break;
                }
            }
            case DATETIME: 
            case TIMESTAMP: {
                if (value instanceof LocalDateTime || value instanceof Date || SYSDATE.equals(value)) break;
                try {
                    value = ObjectUtils.getDate(value);
                    break;
                }
                catch (ValueConversionException e) {
                    log.info("Parsing '{}' to Date failed for column {}. Message is " + e.toString(), value, (Object)column.getName());
                    throw new FieldIllegalValueException((Column)column, String.valueOf(value), e.getCause());
                }
            }
            case DECIMAL: {
                if (value instanceof Enum) break;
                if (!(value instanceof Number)) {
                    try {
                        value = ObjectUtils.getValueUtils().toDecimal(value);
                    }
                    catch (NumberFormatException e) {
                        log.info("Parsing '{}' to Decimal failed for column {}. Message is " + e.toString(), value, (Object)column.getName());
                        throw new FieldIllegalValueException((Column)column, String.valueOf(value), (Throwable)e);
                    }
                }
                value = this.validateNumber(column, type, (Number)value);
                break;
            }
            case FLOAT: {
                if (!(value instanceof Number)) {
                    try {
                        value = ObjectUtils.getValueUtils().toDouble(value);
                    }
                    catch (NumberFormatException e) {
                        log.info("Parsing '{}' to Double failed for column {}. Message is " + e.toString(), value, (Object)column.getName());
                        throw new FieldIllegalValueException((Column)column, String.valueOf(value), (Throwable)e);
                    }
                }
                value = this.validateNumber(column, type, (Number)value);
                break;
            }
            case INTEGER: {
                if (value instanceof Enum) break;
                if (!(value instanceof Number)) {
                    try {
                        value = ObjectUtils.getValueUtils().toLong(value);
                    }
                    catch (NumberFormatException e) {
                        log.info("Parsing '{}' to Integer failed for column {}. Message is " + e.toString(), value, (Object)column.getName());
                        throw new FieldIllegalValueException((Column)column, String.valueOf(value), (Throwable)e);
                    }
                }
                value = this.validateNumber(column, type, (Number)value);
                break;
            }
            case VARCHAR: 
            case CHAR: {
                if (value instanceof Enum || value.toString().length() <= (int)column.getSize()) break;
                throw new FieldValueTooLongException(column);
            }
            default: {
                if (!log.isTraceEnabled()) break;
                log.trace("No column validation has been implemented for data type " + (Object)((Object)type));
            }
        }
        return value;
    }

    protected Number validateNumber(DBTableColumn column, DataType type, Number n) {
        boolean aboveMax;
        boolean belowMin;
        Object min = column.getAttribute("minValue");
        Object max = column.getAttribute("maxValue");
        boolean bl = min instanceof Number ? ObjectUtils.compare(n, min) < 0 : (belowMin = false);
        boolean bl2 = max instanceof Number ? ObjectUtils.compare(n, max) > 0 : (aboveMax = false);
        if (belowMin && aboveMax) {
            throw new FieldValueOutOfRangeException((Column)column, (Number)min, (Number)max);
        }
        if (belowMin) {
            throw new FieldValueOutOfRangeException((Column)column, (Number)min, false);
        }
        if (aboveMax) {
            throw new FieldValueOutOfRangeException((Column)column, (Number)max, true);
        }
        if (type == DataType.DECIMAL) {
            BigDecimal dv = ObjectUtils.getValueUtils().toDecimal(n);
            int prec = dv.precision();
            int scale = dv.scale();
            double size = column.getSize();
            int reqPrec = (int)size;
            int reqScale = column.getDecimalScale();
            if (scale > reqScale) {
                dv = dv.setScale(reqScale, RoundingMode.HALF_UP);
                prec = dv.precision();
                scale = dv.scale();
                n = dv;
            }
            if (prec - scale > reqPrec - reqScale) {
                throw new FieldValueOutOfRangeException(column);
            }
        }
        return n;
    }

    public DBCaseExpr caseWhen(DBCompareExpr condition, Object trueValue, Object falseValue) {
        return new DBCaseWhenExpr(condition, trueValue, falseValue);
    }

    public DBCaseExpr caseWhen(Map<DBCompareExpr, ? extends Object> whenMap, Object elseValue) {
        return new DBCaseWhenExpr(this, whenMap, elseValue);
    }

    public DBCaseExpr caseWhenNull(DBColumnExpr column, Object trueValue, Object falseValue) {
        return this.caseWhen(column.is(null), trueValue, falseValue);
    }

    public DBCaseExpr caseMap(DBColumnExpr column, Map<? extends Object, ? extends Object> valueMap, Object elseValue) {
        return new DBCaseMapExpr(column, valueMap, elseValue);
    }

    public DBCaseExpr caseMap(DBColumnExpr column, Options options, Object elseValue) {
        return new DBCaseMapExpr(column, options.map(), elseValue);
    }

    public DBCaseExpr caseMap(DBColumnExpr column, Object cmpValue, Object trueValue, Object falseValue) {
        return new DBCaseMapExpr(column, cmpValue, trueValue, falseValue);
    }

    protected boolean isSameRowSet(DBRowSet first, DBRowSet second) {
        return first.getClass().equals(second.getClass());
    }

    protected void addRowsetToAliasMap(DBRowSet rowset) {
        String alias = rowset.getAlias();
        if (StringUtils.isEmpty(alias)) {
            throw new ObjectNotValidException(rowset);
        }
        DBRowSet existing = this.rowsetAliasMap.get(alias);
        if (existing == rowset) {
            return;
        }
        if (existing != null) {
            log.error("Rowset alias \"{}\" must be unqiue, but has alreaedy been used for {}", (Object)alias, (Object)existing.getClass().getName());
            throw new ItemExistsException((Object)alias);
        }
        this.rowsetAliasMap.put(alias, rowset);
    }

    protected void removeRowsetFromAliasMap(DBRowSet rowset) {
        String alias = rowset.getAlias();
        this.rowsetAliasMap.remove(alias);
    }

    public static final class DBSystemDate {
        private DBSystemDate() {
        }

        public String toString() {
            return "sysdate";
        }
    }
}

