/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.expr.column;

import java.util.Map;
import java.util.Set;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBExpr;
import org.apache.empire.db.DBSQLBuilder;
import org.apache.empire.db.expr.column.DBAbstractFuncExpr;
import org.apache.empire.dbms.DBSqlPhrase;
import org.apache.empire.exceptions.InvalidArgumentException;

public class DBDecodeExpr
extends DBAbstractFuncExpr {
    private final Map<?, ?> valueMap;
    private final Object elseExpr;

    public DBDecodeExpr(DBColumnExpr expr, Map<?, ?> valueMap, Object elseExpr, DataType dataType) {
        super(expr, false, dataType);
        this.valueMap = valueMap;
        this.elseExpr = elseExpr;
    }

    @Override
    protected String getFunctionName() {
        return "DECODE";
    }

    @Override
    public DBColumn getUpdateColumn() {
        return null;
    }

    @Override
    public Class<Enum<?>> getEnumType() {
        DBColumnExpr firstExpr = this.getFirstColumnExpr();
        if (firstExpr != null) {
            return firstExpr.getEnumType();
        }
        return super.getEnumType();
    }

    @Override
    public void addReferencedColumns(Set<DBColumn> list) {
        this.expr.addReferencedColumns(list);
        for (Map.Entry<?, ?> e : this.valueMap.entrySet()) {
            if (e.getKey() instanceof DBExpr) {
                ((DBExpr)e.getKey()).addReferencedColumns(list);
            }
            if (!(e.getValue() instanceof DBExpr)) continue;
            ((DBExpr)e.getValue()).addReferencedColumns(list);
        }
        if (this.elseExpr instanceof DBExpr) {
            ((DBExpr)this.elseExpr).addReferencedColumns(list);
        }
    }

    @Override
    public void addSQL(DBSQLBuilder sql, long context) {
        String template = sql.getPhrase(DBSqlPhrase.SQL_FUNC_DECODE);
        int pos = 0;
        int prev = 0;
        int len = template.length();
        while (pos < len) {
            char c = template.charAt(pos);
            if (c == '?') {
                if (prev < pos) {
                    sql.append(template.substring(prev, pos));
                }
                this.expr.addSQL(sql, context & 0xFFFFFFFFFFFFFFF7L);
                prev = ++pos;
                continue;
            }
            if (c == '{') {
                if (prev < pos) {
                    sql.append(template.substring(prev, pos));
                }
                ++pos;
                int end = pos++;
                for (end = pos; end < len && template.charAt(end) != '}'; ++end) {
                }
                if (end >= len) {
                    throw new InvalidArgumentException("template", template);
                }
                this.addDecodeParts(sql);
                prev = pos = end + 1;
                continue;
            }
            ++pos;
        }
        if (prev < len) {
            sql.append(template.substring(prev));
            if (prev == 0) {
                log.warn("No Placeholder found in template {}", (Object)template);
            }
        }
    }

    public void addDecodeParts(DBSQLBuilder sql) {
        for (Object key : this.valueMap.keySet()) {
            Object val = this.valueMap.get(key);
            sql.append(DBSqlPhrase.SQL_FUNC_DECODE_SEP);
            Object[] keyVal = new Object[]{key, val};
            DataType[] dataTypes = new DataType[]{this.expr.getDataType(), this.getDataType()};
            String part = sql.getPhrase(DBSqlPhrase.SQL_FUNC_DECODE_PART);
            sql.appendTemplate(part, keyVal, dataTypes, 7L, "");
        }
        if (this.elseExpr != null) {
            sql.append(DBSqlPhrase.SQL_FUNC_DECODE_SEP);
            String other = sql.getPhrase(DBSqlPhrase.SQL_FUNC_DECODE_ELSE);
            sql.appendTemplate(other, new Object[]{this.elseExpr}, new DataType[]{this.getDataType()}, 7L, "");
        }
    }

    private DBColumnExpr getFirstColumnExpr() {
        for (Object val : this.valueMap.values()) {
            if (!(val instanceof DBColumnExpr)) continue;
            return (DBColumnExpr)val;
        }
        if (this.elseExpr instanceof DBColumnExpr) {
            return (DBColumnExpr)this.elseExpr;
        }
        return null;
    }
}

