/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.client.models;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.fineract.client.models.ClientTextSearch;
import org.apache.fineract.client.models.SortOrder;

public class PagedRequestClientTextSearch {
    public static final String SERIALIZED_NAME_PAGE = "page";
    @SerializedName(value="page")
    private Integer page;
    public static final String SERIALIZED_NAME_REQUEST = "request";
    @SerializedName(value="request")
    private ClientTextSearch request;
    public static final String SERIALIZED_NAME_SIZE = "size";
    @SerializedName(value="size")
    private Integer size;
    public static final String SERIALIZED_NAME_SORTS = "sorts";
    @SerializedName(value="sorts")
    private List<SortOrder> sorts;

    public PagedRequestClientTextSearch page(Integer page) {
        this.page = page;
        return this;
    }

    @Nullable
    public Integer getPage() {
        return this.page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public PagedRequestClientTextSearch request(ClientTextSearch request) {
        this.request = request;
        return this;
    }

    @Nullable
    public ClientTextSearch getRequest() {
        return this.request;
    }

    public void setRequest(ClientTextSearch request) {
        this.request = request;
    }

    public PagedRequestClientTextSearch size(Integer size) {
        this.size = size;
        return this;
    }

    @Nullable
    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public PagedRequestClientTextSearch sorts(List<SortOrder> sorts) {
        this.sorts = sorts;
        return this;
    }

    public PagedRequestClientTextSearch addSortsItem(SortOrder sortsItem) {
        if (this.sorts == null) {
            this.sorts = new ArrayList<SortOrder>();
        }
        this.sorts.add(sortsItem);
        return this;
    }

    @Nullable
    public List<SortOrder> getSorts() {
        return this.sorts;
    }

    public void setSorts(List<SortOrder> sorts) {
        this.sorts = sorts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PagedRequestClientTextSearch pagedRequestClientTextSearch = (PagedRequestClientTextSearch)o;
        return Objects.equals(this.page, pagedRequestClientTextSearch.page) && Objects.equals(this.request, pagedRequestClientTextSearch.request) && Objects.equals(this.size, pagedRequestClientTextSearch.size) && Objects.equals(this.sorts, pagedRequestClientTextSearch.sorts);
    }

    public int hashCode() {
        return Objects.hash(this.page, this.request, this.size, this.sorts);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PagedRequestClientTextSearch {\n");
        sb.append("    page: ").append(this.toIndentedString(this.page)).append("\n");
        sb.append("    request: ").append(this.toIndentedString(this.request)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    sorts: ").append(this.toIndentedString(this.sorts)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

