/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.accounting.common;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.fineract.accounting.common.AccountingDropdownReadPlatformService;
import org.apache.fineract.accounting.common.AccountingEnumerations;
import org.apache.fineract.accounting.common.AccountingRuleType;
import org.apache.fineract.accounting.glaccount.data.GLAccountData;
import org.apache.fineract.accounting.glaccount.domain.GLAccountType;
import org.apache.fineract.accounting.glaccount.domain.GLAccountUsage;
import org.apache.fineract.accounting.glaccount.service.GLAccountReadPlatformService;
import org.apache.fineract.accounting.journalentry.domain.JournalEntryType;
import org.apache.fineract.infrastructure.core.data.EnumOptionData;
import org.springframework.stereotype.Service;

@Service
public class AccountingDropdownReadPlatformServiceImpl
implements AccountingDropdownReadPlatformService {
    private final GLAccountReadPlatformService accountReadPlatformService;

    public List<EnumOptionData> retrieveGLAccountTypeOptions() {
        return AccountingEnumerations.gLAccountType((GLAccountType[])GLAccountType.values());
    }

    public List<EnumOptionData> retrieveGLAccountUsageOptions() {
        return AccountingEnumerations.gLAccountUsage((GLAccountUsage[])GLAccountUsage.values());
    }

    public List<EnumOptionData> retrieveJournalEntryTypeOptions() {
        return AccountingEnumerations.journalEntryTypes((JournalEntryType[])JournalEntryType.values());
    }

    public List<EnumOptionData> retrieveAccountingRuleTypeOptions() {
        return AccountingEnumerations.accountingRuleTypes((AccountingRuleType[])AccountingRuleType.values());
    }

    public Map<String, List<GLAccountData>> retrieveAccountMappingOptionsForLoanProducts() {
        return this.retrieveAccountMappingOptions();
    }

    public Map<String, List<GLAccountData>> retrieveAccountMappingOptionsForSavingsProducts() {
        return this.retrieveAccountMappingOptions();
    }

    public Map<String, List<GLAccountData>> retrieveAccountMappingOptionsForCharges() {
        boolean includeIncomeAccounts = true;
        boolean includeLiabilityAccounts = true;
        boolean includeAssetAccounts = false;
        boolean includeExpenseAccounts = false;
        boolean includeEquityAccounts = false;
        return this.retrieveAccountMappingOptions(includeAssetAccounts, includeIncomeAccounts, includeExpenseAccounts, includeLiabilityAccounts, includeEquityAccounts);
    }

    public Map<String, List<GLAccountData>> retrieveAccountMappingOptions() {
        boolean includeAssetAccounts = true;
        boolean includeIncomeAccounts = true;
        boolean includeExpenseAccounts = true;
        boolean includeLiabilityAccounts = true;
        boolean includeEquityAccounts = true;
        return this.retrieveAccountMappingOptions(includeAssetAccounts, includeIncomeAccounts, includeExpenseAccounts, includeLiabilityAccounts, includeEquityAccounts);
    }

    public List<GLAccountData> retrieveExpenseAccountOptions() {
        return this.accountReadPlatformService.retrieveAllEnabledDetailGLAccounts(GLAccountType.EXPENSE);
    }

    public List<GLAccountData> retrieveAssetAccountOptions() {
        return this.accountReadPlatformService.retrieveAllEnabledDetailGLAccounts(GLAccountType.ASSET);
    }

    private Map<String, List<GLAccountData>> retrieveAccountMappingOptions(boolean includeAssetAccounts, boolean includeIncomeAccounts, boolean includeExpenseAccounts, boolean includeLiabilityAccounts, boolean includeEquityAccounts) {
        HashMap<String, List<GLAccountData>> accountOptions = new HashMap<String, List<GLAccountData>>();
        if (includeAssetAccounts) {
            List assetAccountOptions = this.accountReadPlatformService.retrieveAllEnabledDetailGLAccounts(GLAccountType.ASSET);
            if (assetAccountOptions.isEmpty()) {
                assetAccountOptions = null;
            }
            accountOptions.put("assetAccountOptions", assetAccountOptions);
        }
        if (includeIncomeAccounts) {
            List incomeAccountOptions = this.accountReadPlatformService.retrieveAllEnabledDetailGLAccounts(GLAccountType.INCOME);
            if (incomeAccountOptions.isEmpty()) {
                incomeAccountOptions = null;
            }
            accountOptions.put("incomeAccountOptions", incomeAccountOptions);
        }
        if (includeExpenseAccounts) {
            List expenseAccountOptions = this.accountReadPlatformService.retrieveAllEnabledDetailGLAccounts(GLAccountType.EXPENSE);
            if (expenseAccountOptions.isEmpty()) {
                expenseAccountOptions = null;
            }
            accountOptions.put("expenseAccountOptions", expenseAccountOptions);
        }
        if (includeLiabilityAccounts) {
            List liabilityAccountOptions = this.accountReadPlatformService.retrieveAllEnabledDetailGLAccounts(GLAccountType.LIABILITY);
            if (liabilityAccountOptions.isEmpty()) {
                liabilityAccountOptions = null;
            }
            accountOptions.put("liabilityAccountOptions", liabilityAccountOptions);
        }
        if (includeEquityAccounts) {
            List equityAccountOptions = this.accountReadPlatformService.retrieveAllEnabledDetailGLAccounts(GLAccountType.EQUITY);
            if (equityAccountOptions.isEmpty()) {
                equityAccountOptions = null;
            }
            accountOptions.put("equityAccountOptions", equityAccountOptions);
        }
        return accountOptions;
    }

    public Map<String, List<GLAccountData>> retrieveAccountMappingOptionsForShareProducts() {
        boolean includeAssetAccounts = true;
        boolean includeIncomeAccounts = true;
        boolean includeExpenseAccounts = false;
        boolean includeLiabilityAccounts = true;
        boolean includeEquityAccounts = true;
        return this.retrieveAccountMappingOptions(includeAssetAccounts, includeIncomeAccounts, includeExpenseAccounts, includeLiabilityAccounts, includeEquityAccounts);
    }

    @Generated
    public AccountingDropdownReadPlatformServiceImpl(GLAccountReadPlatformService accountReadPlatformService) {
        this.accountReadPlatformService = accountReadPlatformService;
    }
}

