/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.adhocquery.service;

import java.util.Map;
import lombok.Generated;
import org.apache.fineract.adhocquery.api.AdHocJsonInputParams;
import org.apache.fineract.adhocquery.domain.AdHoc;
import org.apache.fineract.adhocquery.domain.AdHocRepository;
import org.apache.fineract.adhocquery.exception.AdHocNotFoundException;
import org.apache.fineract.adhocquery.service.AdHocDataValidator;
import org.apache.fineract.adhocquery.service.AdHocWritePlatformService;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.exception.ErrorHandler;
import org.apache.fineract.infrastructure.core.exception.PlatformDataIntegrityException;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.infrastructure.security.service.SqlValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.NonTransientDataAccessException;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.transaction.annotation.Transactional;

public class AdHocWritePlatformServiceJpaRepositoryImpl
implements AdHocWritePlatformService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AdHocWritePlatformServiceJpaRepositoryImpl.class);
    private final PlatformSecurityContext context;
    private final AdHocRepository adHocRepository;
    private final AdHocDataValidator adHocCommandFromApiJsonDeserializer;
    private final SqlValidator sqlValidator;

    @Transactional
    public CommandProcessingResult createAdHocQuery(JsonCommand command) {
        try {
            this.context.authenticatedUser();
            this.adHocCommandFromApiJsonDeserializer.validateForCreate(command.json());
            String commandQuery = command.stringValueOfParameterNamed(AdHocJsonInputParams.QUERY.getValue());
            this.sqlValidator.validate("adhoc", commandQuery);
            AdHoc entity = AdHoc.fromJson((JsonCommand)command);
            this.adHocRepository.saveAndFlush((Object)entity);
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)entity.getId()).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            Throwable throwable = dve.getMostSpecificCause();
            this.handleDataIntegrityIssues(command, throwable, (NonTransientDataAccessException)dve);
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).build();
        }
    }

    private void handleDataIntegrityIssues(JsonCommand command, Throwable realCause, NonTransientDataAccessException dve) {
        if (realCause.getMessage().contains("unq_name")) {
            String name = command.stringValueOfParameterNamed("name");
            throw new PlatformDataIntegrityException("error.msg.adhocquery.duplicate.name", "AdHocQuery with name `" + name + "` already exists", "name", new Object[]{name});
        }
        log.error("Error occured.", (Throwable)dve);
        throw ErrorHandler.getMappable((Throwable)dve, (String)"error.msg.adhocquery.unknown.data.integrity.issue", (String)"Unknown data integrity issue with resource.");
    }

    @Transactional
    public CommandProcessingResult updateAdHocQuery(Long adHocId, JsonCommand command) {
        try {
            this.context.authenticatedUser();
            this.adHocCommandFromApiJsonDeserializer.validateForUpdate(command.json());
            AdHoc adHoc = (AdHoc)this.adHocRepository.findById((Object)adHocId).orElseThrow(() -> new AdHocNotFoundException(adHocId));
            Map changes = adHoc.update(command);
            if (!changes.isEmpty()) {
                this.adHocRepository.saveAndFlush((Object)adHoc);
            }
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId(adHocId).with(changes).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            Throwable throwable = dve.getMostSpecificCause();
            this.handleDataIntegrityIssues(command, throwable, (NonTransientDataAccessException)dve);
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).build();
        }
    }

    @Transactional
    public CommandProcessingResult deleteAdHocQuery(Long adHocId) {
        try {
            AdHoc adHoc = (AdHoc)this.adHocRepository.findById((Object)adHocId).orElseThrow(() -> new AdHocNotFoundException(adHocId));
            this.adHocRepository.delete((Object)adHoc);
            return new CommandProcessingResultBuilder().withEntityId(adHocId).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException e) {
            throw ErrorHandler.getMappable((Throwable)e, (String)"error.msg.unknown.data.integrity.issue", (String)("Unknown data integrity issue with resource: " + String.valueOf(e.getMostSpecificCause())));
        }
    }

    @Transactional
    public CommandProcessingResult disableAdHocQuery(Long adHocId) {
        try {
            AdHoc adHoc = (AdHoc)this.adHocRepository.findById((Object)adHocId).orElseThrow(() -> new AdHocNotFoundException(adHocId));
            adHoc.setActive(true);
            this.adHocRepository.save((Object)adHoc);
            return new CommandProcessingResultBuilder().withEntityId(adHocId).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException e) {
            throw ErrorHandler.getMappable((Throwable)e, (String)"error.msg.unknown.data.integrity.issue", (String)("Unknown data integrity issue with resource: " + String.valueOf(e.getMostSpecificCause())));
        }
    }

    @Transactional
    public CommandProcessingResult enableAdHocQuery(Long adHocId) {
        try {
            AdHoc adHoc = (AdHoc)this.adHocRepository.findById((Object)adHocId).orElseThrow(() -> new AdHocNotFoundException(adHocId));
            adHoc.setActive(false);
            this.adHocRepository.save((Object)adHoc);
            return new CommandProcessingResultBuilder().withEntityId(adHocId).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException e) {
            throw ErrorHandler.getMappable((Throwable)e, (String)"error.msg.unknown.data.integrity.issue", (String)("Unknown data integrity issue with resource: " + String.valueOf(e.getMostSpecificCause())));
        }
    }

    @Generated
    public AdHocWritePlatformServiceJpaRepositoryImpl(PlatformSecurityContext context, AdHocRepository adHocRepository, AdHocDataValidator adHocCommandFromApiJsonDeserializer, SqlValidator sqlValidator) {
        this.context = context;
        this.adHocRepository = adHocRepository;
        this.adHocCommandFromApiJsonDeserializer = adHocCommandFromApiJsonDeserializer;
        this.sqlValidator = sqlValidator;
    }
}

