/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.campaigns.email.service;

import java.util.Map;
import lombok.Generated;
import org.apache.fineract.infrastructure.campaigns.email.data.EmailDataValidator;
import org.apache.fineract.infrastructure.campaigns.email.domain.EmailMessage;
import org.apache.fineract.infrastructure.campaigns.email.domain.EmailMessageAssembler;
import org.apache.fineract.infrastructure.campaigns.email.domain.EmailMessageRepository;
import org.apache.fineract.infrastructure.campaigns.email.service.EmailWritePlatformService;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.exception.ErrorHandler;
import org.apache.fineract.infrastructure.core.exception.PlatformDataIntegrityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.NonTransientDataAccessException;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class EmailWritePlatformServiceJpaRepositoryImpl
implements EmailWritePlatformService {
    private static final Logger LOG = LoggerFactory.getLogger(EmailWritePlatformServiceJpaRepositoryImpl.class);
    private final EmailMessageAssembler assembler;
    private final EmailMessageRepository repository;
    private final EmailDataValidator validator;

    @Transactional
    public CommandProcessingResult create(JsonCommand command) {
        try {
            this.validator.validateCreateRequest(command);
            EmailMessage message = this.assembler.assembleFromJson(command);
            this.repository.saveAndFlush((Object)message);
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)message.getId()).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            Throwable throwable = dve.getMostSpecificCause();
            this.handleDataIntegrityIssues(command, throwable, (NonTransientDataAccessException)dve);
            return CommandProcessingResult.empty();
        }
    }

    @Transactional
    public CommandProcessingResult update(Long resourceId, JsonCommand command) {
        try {
            this.validator.validateUpdateRequest(command);
            EmailMessage message = this.assembler.assembleFromResourceId(resourceId);
            Map changes = message.update(command);
            if (!changes.isEmpty()) {
                this.repository.save((Object)message);
            }
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId(resourceId).with(changes).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            Throwable throwable = dve.getMostSpecificCause();
            this.handleDataIntegrityIssues(command, throwable, (NonTransientDataAccessException)dve);
            return CommandProcessingResult.empty();
        }
    }

    @Transactional
    public CommandProcessingResult delete(Long resourceId) {
        try {
            EmailMessage message = this.assembler.assembleFromResourceId(resourceId);
            this.repository.delete((Object)message);
            this.repository.flush();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            Throwable throwable = dve.getMostSpecificCause();
            this.handleDataIntegrityIssues(null, throwable, (NonTransientDataAccessException)dve);
            return CommandProcessingResult.empty();
        }
        return new CommandProcessingResultBuilder().withEntityId(resourceId).build();
    }

    private void handleDataIntegrityIssues(JsonCommand command, Throwable realCause, NonTransientDataAccessException dve) {
        if (realCause.getMessage().contains("email_address")) {
            throw new PlatformDataIntegrityException("error.msg.email.no.email.address.exists", "The group, client or staff provided has no email address.", "id", new Object[0]);
        }
        LOG.error("Error occured.", (Throwable)dve);
        throw ErrorHandler.getMappable((Throwable)dve, (String)"error.msg.email.unknown.data.integrity.issue", (String)("Unknown data integrity issue with resource: " + realCause.getMessage()));
    }

    @Generated
    public EmailWritePlatformServiceJpaRepositoryImpl(EmailMessageAssembler assembler, EmailMessageRepository repository, EmailDataValidator validator) {
        this.assembler = assembler;
        this.repository = repository;
        this.validator = validator;
    }
}

