/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.campaigns.sms.service;

import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.campaigns.sms.data.SmsCampaignData;
import org.apache.fineract.infrastructure.campaigns.sms.exception.SmsCampaignNotFound;
import org.apache.fineract.infrastructure.campaigns.sms.mapper.BusinessRuleMapper;
import org.apache.fineract.infrastructure.campaigns.sms.mapper.SmsCampaignMapper;
import org.apache.fineract.infrastructure.campaigns.sms.service.SmsCampaignDropdownReadPlatformService;
import org.apache.fineract.infrastructure.campaigns.sms.service.SmsCampaignReadPlatformService;
import org.apache.fineract.infrastructure.core.service.Page;
import org.apache.fineract.infrastructure.core.service.PaginationHelper;
import org.apache.fineract.infrastructure.core.service.SearchParameters;
import org.apache.fineract.infrastructure.core.service.database.DatabaseSpecificSQLGenerator;
import org.apache.fineract.portfolio.calendar.service.CalendarDropdownReadPlatformService;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
public class SmsCampaignReadPlatformServiceImpl
implements SmsCampaignReadPlatformService {
    private final JdbcTemplate jdbcTemplate;
    private final DatabaseSpecificSQLGenerator sqlGenerator;
    private final SmsCampaignDropdownReadPlatformService smsCampaignDropdownReadPlatformService;
    private final CalendarDropdownReadPlatformService calendarDropdownReadPlatformService;
    private final PaginationHelper paginationHelper;
    private final BusinessRuleMapper businessRuleMapper;
    private final SmsCampaignMapper smsCampaignMapper;

    public SmsCampaignData retrieveOne(Long campaignId) {
        boolean isVisible = true;
        try {
            String sql = "select " + this.smsCampaignMapper.schema() + " where sc.id = ? and sc.is_visible = ?";
            return (SmsCampaignData)this.jdbcTemplate.queryForObject(sql, (RowMapper)this.smsCampaignMapper, new Object[]{campaignId, true});
        }
        catch (EmptyResultDataAccessException e) {
            throw new SmsCampaignNotFound(campaignId, e);
        }
    }

    public Page<SmsCampaignData> retrieveAll(SearchParameters searchParameters) {
        boolean visible = true;
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("select ").append(this.sqlGenerator.calcFoundRows()).append(" ").append(this.smsCampaignMapper.schema()).append(" where sc.is_visible = ? ");
        if (searchParameters.hasLimit()) {
            sqlBuilder.append(" ");
            if (searchParameters.hasOffset()) {
                sqlBuilder.append(this.sqlGenerator.limit(searchParameters.getLimit().intValue(), searchParameters.getOffset().intValue()));
            } else {
                sqlBuilder.append(this.sqlGenerator.limit(searchParameters.getLimit().intValue()));
            }
        }
        return this.paginationHelper.fetchPage(this.jdbcTemplate, sqlBuilder.toString(), new Object[]{true}, (RowMapper)this.smsCampaignMapper);
    }

    public SmsCampaignData retrieveTemplate(String reportType) {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("select ").append(this.businessRuleMapper.schema());
        if (StringUtils.isNotBlank((CharSequence)reportType)) {
            sqlBuilder.append(" where sr.report_type = ?");
        }
        Collection businessRulesOptions = (Collection)this.jdbcTemplate.query(sqlBuilder.toString(), (ResultSetExtractor)this.businessRuleMapper, new Object[]{reportType});
        Collection smsProviderOptions = this.smsCampaignDropdownReadPlatformService.retrieveSmsProviders();
        Collection campaignTypeOptions = this.smsCampaignDropdownReadPlatformService.retrieveCampaignTypes();
        Collection campaignTriggerTypeOptions = this.smsCampaignDropdownReadPlatformService.retrieveCampaignTriggerTypes();
        Collection months = this.smsCampaignDropdownReadPlatformService.retrieveMonths();
        Collection weekDays = this.smsCampaignDropdownReadPlatformService.retrieveWeeks();
        List frequencyTypeOptions = this.calendarDropdownReadPlatformService.retrieveCalendarFrequencyTypeOptions();
        Collection periodFrequencyOptions = this.smsCampaignDropdownReadPlatformService.retrivePeriodFrequencyTypes();
        return SmsCampaignData.template((Collection)smsProviderOptions, (Collection)campaignTypeOptions, (Collection)businessRulesOptions, (Collection)campaignTriggerTypeOptions, (Collection)months, (Collection)weekDays, (Collection)frequencyTypeOptions, (Collection)periodFrequencyOptions);
    }

    @Generated
    public SmsCampaignReadPlatformServiceImpl(JdbcTemplate jdbcTemplate, DatabaseSpecificSQLGenerator sqlGenerator, SmsCampaignDropdownReadPlatformService smsCampaignDropdownReadPlatformService, CalendarDropdownReadPlatformService calendarDropdownReadPlatformService, PaginationHelper paginationHelper, BusinessRuleMapper businessRuleMapper, SmsCampaignMapper smsCampaignMapper) {
        this.jdbcTemplate = jdbcTemplate;
        this.sqlGenerator = sqlGenerator;
        this.smsCampaignDropdownReadPlatformService = smsCampaignDropdownReadPlatformService;
        this.calendarDropdownReadPlatformService = calendarDropdownReadPlatformService;
        this.paginationHelper = paginationHelper;
        this.businessRuleMapper = businessRuleMapper;
        this.smsCampaignMapper = smsCampaignMapper;
    }
}

