/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.core.diagnostics.performance.sampling.core;

import com.google.common.base.Splitter;
import java.time.Duration;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.config.FineractProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class SamplingConfiguration
implements InitializingBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SamplingConfiguration.class);
    private final Set<Class<?>> classesToSample = ConcurrentHashMap.newKeySet();
    private final FineractProperties properties;

    public void afterPropertiesSet() throws Exception {
        if (!this.properties.getSampling().isEnabled()) {
            return;
        }
        String sampledClasses = this.properties.getSampling().getSampledClasses();
        Iterable fqdns = Splitter.on((char)',').split((CharSequence)sampledClasses);
        for (String fqdn : fqdns) {
            String trimmedFqdn = fqdn.trim();
            try {
                Class<?> aClass = Class.forName(trimmedFqdn);
                this.classesToSample.add(aClass);
            }
            catch (Exception e) {
                log.info("Cannot load class for sampling [{}]", (Object)trimmedFqdn);
            }
        }
    }

    public boolean isSamplingConfiguredForClass(Class<?> contextClass) {
        return this.classesToSample.stream().anyMatch(c -> c.isAssignableFrom(contextClass));
    }

    public boolean isSamplingEnabled() {
        return this.properties.getSampling().isEnabled();
    }

    public int getSamplingRate() {
        return this.properties.getSampling().getSamplingRate();
    }

    public Duration getResetPeriod() {
        return Duration.ofSeconds(this.properties.getSampling().getResetPeriodSec());
    }

    @Generated
    public SamplingConfiguration(FineractProperties properties) {
        this.properties = properties;
    }
}

