/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.event.external.service.serialization.serializer.client;

import lombok.Generated;
import org.apache.avro.generic.GenericContainer;
import org.apache.fineract.avro.client.v1.ClientDataV1;
import org.apache.fineract.avro.generator.ByteBufferSerializable;
import org.apache.fineract.infrastructure.event.business.domain.BusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.client.ClientBusinessEvent;
import org.apache.fineract.infrastructure.event.external.service.serialization.mapper.client.ClientDataMapper;
import org.apache.fineract.infrastructure.event.external.service.serialization.serializer.BusinessEventSerializer;
import org.apache.fineract.portfolio.client.data.ClientData;
import org.apache.fineract.portfolio.client.domain.Client;
import org.apache.fineract.portfolio.client.service.ClientReadPlatformService;
import org.springframework.stereotype.Component;

@Component
public class ClientBusinessEventSerializer
implements BusinessEventSerializer {
    private final ClientReadPlatformService service;
    private final ClientDataMapper mapper;

    public <T> boolean canSerialize(BusinessEvent<T> event) {
        return event instanceof ClientBusinessEvent;
    }

    public <T> ByteBufferSerializable toAvroDTO(BusinessEvent<T> rawEvent) {
        ClientBusinessEvent event = (ClientBusinessEvent)rawEvent;
        ClientData data = this.service.retrieveOne((Long)((Client)event.get()).getId());
        return this.mapper.map(data);
    }

    public Class<? extends GenericContainer> getSupportedSchema() {
        return ClientDataV1.class;
    }

    @Generated
    public ClientBusinessEventSerializer(ClientReadPlatformService service, ClientDataMapper mapper) {
        this.service = service;
        this.mapper = mapper;
    }
}

