/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.event.external.service.serialization.serializer.loan;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.fineract.avro.loan.v1.DelinquencyRangeDataV1;
import org.apache.fineract.avro.loan.v1.LoanAmountDataV1;
import org.apache.fineract.avro.loan.v1.LoanChargeDataRangeViewV1;
import org.apache.fineract.avro.loan.v1.LoanInstallmentDelinquencyBucketDataV1;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.event.external.service.serialization.mapper.generic.CurrencyDataMapper;
import org.apache.fineract.organisation.monetary.data.CurrencyData;
import org.apache.fineract.portfolio.delinquency.data.LoanInstallmentDelinquencyTagData;
import org.apache.fineract.portfolio.delinquency.service.DelinquencyReadPlatformService;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanCharge;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepaymentScheduleInstallment;
import org.springframework.stereotype.Component;

@Component
public class LoanInstallmentLevelDelinquencyEventProducer {
    private final DelinquencyReadPlatformService delinquencyReadPlatformService;
    private final CurrencyDataMapper currencyMapper;

    public List<LoanInstallmentDelinquencyBucketDataV1> calculateInstallmentLevelDelinquencyData(Loan loan, CurrencyData currency) {
        Collection installmentDelinquencyTags;
        ArrayList<LoanInstallmentDelinquencyBucketDataV1> loanInstallmentDelinquencyData = new ArrayList<LoanInstallmentDelinquencyBucketDataV1>();
        if (loan.isEnableInstallmentLevelDelinquency() && (installmentDelinquencyTags = this.delinquencyReadPlatformService.retrieveLoanInstallmentsCurrentDelinquencyTag((Long)loan.getId())) != null && installmentDelinquencyTags.size() > 0) {
            Map<Long, List<LoanInstallmentDelinquencyTagData>> installmentsInSameRange = installmentDelinquencyTags.stream().collect(Collectors.groupingBy(installmentDelnquencyTags -> installmentDelnquencyTags.getDelinquencyRange().getId()));
            for (Map.Entry<Long, List<LoanInstallmentDelinquencyTagData>> installmentDelinquencyTagData : installmentsInSameRange.entrySet()) {
                List<LoanRepaymentScheduleInstallment> delinquentInstallmentsInSameRange = loan.getRepaymentScheduleInstallments().stream().filter(installment -> ((List)installmentDelinquencyTagData.getValue()).stream().anyMatch(installmentTag -> installmentTag.getId().equals(installment.getId()))).toList();
                LoanAmountDataV1 amount = LoanAmountDataV1.newBuilder().setPrincipalAmount(delinquentInstallmentsInSameRange.stream().map(installment -> installment.getPrincipalOutstanding(loan.getCurrency()).getAmount()).reduce(BigDecimal.ZERO, BigDecimal::add)).setFeeAmount(delinquentInstallmentsInSameRange.stream().map(installment -> installment.getFeeChargesOutstanding(loan.getCurrency()).getAmount()).reduce(BigDecimal.ZERO, BigDecimal::add)).setInterestAmount(delinquentInstallmentsInSameRange.stream().map(installment -> installment.getInterestOutstanding(loan.getCurrency()).getAmount()).reduce(BigDecimal.ZERO, BigDecimal::add)).setPenaltyAmount(delinquentInstallmentsInSameRange.stream().map(installment -> installment.getPenaltyChargesOutstanding(loan.getCurrency()).getAmount()).reduce(BigDecimal.ZERO, BigDecimal::add)).setTotalAmount(delinquentInstallmentsInSameRange.stream().map(installment -> installment.getTotalOutstanding(loan.getCurrency()).getAmount()).reduce(BigDecimal.ZERO, BigDecimal::add)).build();
                List<LoanCharge> chargesForInstallmentsInSameRange = loan.getLoanCharges().stream().filter(loanCharge -> !loanCharge.isPaid() && delinquentInstallmentsInSameRange.stream().anyMatch(installmentForCharge -> !(!DateUtils.isAfter((LocalDate)loanCharge.getEffectiveDueDate(), (LocalDate)installmentForCharge.getFromDate()) && !DateUtils.isEqual((LocalDate)loanCharge.getEffectiveDueDate(), (LocalDate)installmentForCharge.getFromDate()) || !DateUtils.isBefore((LocalDate)loanCharge.getEffectiveDueDate(), (LocalDate)installmentForCharge.getDueDate()) && !DateUtils.isEqual((LocalDate)loanCharge.getEffectiveDueDate(), (LocalDate)installmentForCharge.getDueDate())))).toList();
                ArrayList<LoanChargeDataRangeViewV1> charges = new ArrayList<LoanChargeDataRangeViewV1>();
                for (LoanCharge charge : chargesForInstallmentsInSameRange) {
                    LoanChargeDataRangeViewV1 chargeData = LoanChargeDataRangeViewV1.newBuilder().setId(((Long)charge.getId()).longValue()).setName(charge.name()).setAmount(charge.amountOutstanding()).setCurrency(this.currencyMapper.map(currency)).build();
                    charges.add(chargeData);
                }
                LoanInstallmentDelinquencyTagData.InstallmentDelinquencyRange delinquencyRange = installmentDelinquencyTagData.getValue().get(0).getDelinquencyRange();
                DelinquencyRangeDataV1 delinquencyRangeDataV1 = DelinquencyRangeDataV1.newBuilder().setId(delinquencyRange.getId()).setClassification(delinquencyRange.getClassification()).setMinimumAgeDays(delinquencyRange.getMinimumAgeDays()).setMaximumAgeDays(delinquencyRange.getMaximumAgeDays()).build();
                LoanInstallmentDelinquencyBucketDataV1 installmentDelinquencyBucketDataV1 = LoanInstallmentDelinquencyBucketDataV1.newBuilder().setDelinquencyRange(delinquencyRangeDataV1).setAmount(amount).setCharges(charges).setCurrency(this.currencyMapper.map(currency)).build();
                loanInstallmentDelinquencyData.add(installmentDelinquencyBucketDataV1);
            }
        }
        return loanInstallmentDelinquencyData;
    }

    @Generated
    public LoanInstallmentLevelDelinquencyEventProducer(DelinquencyReadPlatformService delinquencyReadPlatformService, CurrencyDataMapper currencyMapper) {
        this.delinquencyReadPlatformService = delinquencyReadPlatformService;
        this.currencyMapper = currencyMapper;
    }
}

