/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.interoperation.data;

import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDate;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.service.MathUtil;
import org.apache.fineract.portfolio.savings.SavingsAccountTransactionType;
import org.apache.fineract.portfolio.savings.domain.SavingsAccount;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountChargePaidBy;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountTransaction;
import org.apache.fineract.portfolio.savings.service.SavingsEnumerations;

public class InteropTransactionData
extends CommandProcessingResult {
    @NotNull
    private final String accountId;
    @NotNull
    private final String savingTransactionId;
    @NotNull
    private final SavingsAccountTransactionType transactionType;
    @NotNull
    private final BigDecimal amount;
    private final BigDecimal chargeAmount;
    @NotNull
    private final String currency;
    @NotNull
    private final BigDecimal accountBalance;
    @NotNull
    private final LocalDate bookingDateTime;
    @NotNull
    private final LocalDate valueDateTime;
    private String note;

    public InteropTransactionData(Long entityId, String accountId, String transactionId, SavingsAccountTransactionType transactionType, BigDecimal amount, BigDecimal chargeAmount, String currency, BigDecimal accountBalance, LocalDate bookingDateTime, LocalDate valueDateTime, String note) {
        super(entityId);
        this.accountId = accountId;
        this.savingTransactionId = transactionId;
        this.transactionType = transactionType;
        this.amount = amount;
        this.chargeAmount = chargeAmount;
        this.currency = currency;
        this.accountBalance = accountBalance;
        this.bookingDateTime = bookingDateTime;
        this.valueDateTime = valueDateTime;
        this.note = note;
    }

    public static InteropTransactionData build(SavingsAccountTransaction transaction) {
        if (transaction == null) {
            return null;
        }
        SavingsAccount savingsAccount = transaction.getSavingsAccount();
        String transactionId = ((Long)transaction.getId()).toString();
        SavingsAccountTransactionType transactionType = transaction.getTransactionType();
        BigDecimal amount = transaction.getAmount();
        BigDecimal chargeAmount = null;
        for (SavingsAccountChargePaidBy charge : transaction.getSavingsAccountChargesPaid()) {
            chargeAmount = MathUtil.add(chargeAmount, (BigDecimal)charge.getAmount());
        }
        String currency = savingsAccount.getCurrency().getCode();
        BigDecimal runningBalance = transaction.getRunningBalance(savingsAccount.getCurrency()).getAmount();
        LocalDate bookingDateTime = transaction.getTransactionDate();
        LocalDate endOfBalanceLocalDate = transaction.getEndOfBalanceDate();
        LocalDate valueDateTime = endOfBalanceLocalDate == null ? bookingDateTime : endOfBalanceLocalDate;
        StringBuilder sb = new StringBuilder();
        sb.append(SavingsEnumerations.transactionType((SavingsAccountTransactionType)transactionType).getValue());
        return new InteropTransactionData((Long)savingsAccount.getId(), savingsAccount.getExternalId().getValue(), transactionId, transactionType, amount, chargeAmount, currency, runningBalance, bookingDateTime, valueDateTime, sb.toString());
    }

    public void updateNote(String note) {
        this.note = note;
    }

    @Generated
    public String getAccountId() {
        return this.accountId;
    }

    @Generated
    public String getSavingTransactionId() {
        return this.savingTransactionId;
    }

    @Generated
    public SavingsAccountTransactionType getTransactionType() {
        return this.transactionType;
    }

    @Generated
    public BigDecimal getAmount() {
        return this.amount;
    }

    @Generated
    public BigDecimal getChargeAmount() {
        return this.chargeAmount;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public BigDecimal getAccountBalance() {
        return this.accountBalance;
    }

    @Generated
    public LocalDate getBookingDateTime() {
        return this.bookingDateTime;
    }

    @Generated
    public LocalDate getValueDateTime() {
        return this.valueDateTime;
    }

    @Generated
    public String getNote() {
        return this.note;
    }
}

