/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.interoperation.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.infrastructure.core.service.MathUtil;
import org.apache.fineract.interoperation.util.InteropUtil;
import org.apache.fineract.organisation.monetary.domain.MonetaryCurrency;

public class MoneyData {
    public static final List<String> PARAMS = List.copyOf(Arrays.asList("amount", "currency", "locale"));
    @NotNull
    private final BigDecimal amount;
    @NotNull
    private final String currency;

    MoneyData(BigDecimal amount, String currency) {
        this.amount = amount;
        this.currency = currency;
    }

    public static MoneyData build(BigDecimal amount, String currency) {
        return new MoneyData(amount, currency);
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void normalizeAmount(@NotNull MonetaryCurrency currency) {
        if (!currency.getCode().equals(this.currency)) {
            throw new UnsupportedOperationException("Internal error: Invalid currency " + currency.getCode());
        }
        MathUtil.normalizeAmount((BigDecimal)this.amount, (MonetaryCurrency)currency);
    }

    public static MoneyData validateAndParse(DataValidatorBuilder dataValidator, JsonObject element, FromJsonHelper jsonHelper) {
        if (element == null) {
            return null;
        }
        jsonHelper.checkForUnsupportedParameters(element, (Collection)PARAMS);
        String locale = jsonHelper.extractStringNamed("locale", (JsonElement)element);
        BigDecimal amount = locale == null ? jsonHelper.extractBigDecimalNamed("amount", (JsonElement)element, InteropUtil.DEFAULT_LOCALE) : jsonHelper.extractBigDecimalWithLocaleNamed("amount", (JsonElement)element);
        DataValidatorBuilder dataValidatorCopy = dataValidator.reset().parameter("amount").value((Object)amount).notBlank().zeroOrPositiveAmount();
        String currency = jsonHelper.extractStringNamed("currency", (JsonElement)element);
        dataValidatorCopy = dataValidatorCopy.reset().parameter("currency").value((Object)currency).notBlank().notExceedingLengthOf(Integer.valueOf(3));
        dataValidator.merge(dataValidatorCopy);
        return dataValidator.hasError() ? null : new MoneyData(amount, currency);
    }
}

