/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.organisation.office.serialization;

import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class OfficeTransactionCommandFromApiJsonDeserializer {
    public static final String FROM_OFFICE_ID = "fromOfficeId";
    public static final String TO_OFFICE_ID = "toOfficeId";
    public static final String TRANSACTION_DATE = "transactionDate";
    public static final String CURRENCY_CODE = "currencyCode";
    public static final String TRANSACTION_AMOUNT = "transactionAmount";
    public static final String DESCRIPTION = "description";
    public static final String LOCALE = "locale";
    public static final String DATE_FORMAT = "dateFormat";
    private static final Set<String> SUPPORTED_PARAMETERS = new HashSet<String>(Arrays.asList("fromOfficeId", "toOfficeId", "transactionDate", "currencyCode", "transactionAmount", "description", "locale", "dateFormat"));
    private final FromJsonHelper fromApiJsonHelper;

    @Autowired
    public OfficeTransactionCommandFromApiJsonDeserializer(FromJsonHelper fromApiJsonHelper) {
        this.fromApiJsonHelper = fromApiJsonHelper;
    }

    public void validateOfficeTransfer(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)SUPPORTED_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("officeTransaction");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        Long fromOfficeId = this.fromApiJsonHelper.extractLongNamed(FROM_OFFICE_ID, element);
        baseDataValidator.reset().parameter(FROM_OFFICE_ID).value((Object)fromOfficeId).ignoreIfNull().integerGreaterThanZero();
        Long toOfficeId = this.fromApiJsonHelper.extractLongNamed(TO_OFFICE_ID, element);
        baseDataValidator.reset().parameter(TO_OFFICE_ID).value((Object)toOfficeId).ignoreIfNull().integerGreaterThanZero();
        if (fromOfficeId == null && toOfficeId == null) {
            baseDataValidator.reset().parameter(TO_OFFICE_ID).value((Object)toOfficeId).notNull();
        }
        if (fromOfficeId != null && toOfficeId != null) {
            baseDataValidator.reset().parameter(FROM_OFFICE_ID).value((Object)fromOfficeId).notSameAsParameter(TO_OFFICE_ID, (Object)toOfficeId);
        }
        LocalDate transactionDate = this.fromApiJsonHelper.extractLocalDateNamed(TRANSACTION_DATE, element);
        baseDataValidator.reset().parameter(TRANSACTION_DATE).value((Object)transactionDate).notNull();
        String currencyCode = this.fromApiJsonHelper.extractStringNamed(CURRENCY_CODE, element);
        baseDataValidator.reset().parameter(CURRENCY_CODE).value((Object)currencyCode).notBlank().notExceedingLengthOf(Integer.valueOf(3));
        BigDecimal transactionAmount = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed(TRANSACTION_AMOUNT, element);
        baseDataValidator.reset().parameter(TRANSACTION_AMOUNT).value((Object)transactionAmount).notNull().positiveAmount();
        String description = this.fromApiJsonHelper.extractStringNamed(DESCRIPTION, element);
        baseDataValidator.reset().parameter(DESCRIPTION).value((Object)description).notExceedingLengthOf(Integer.valueOf(100));
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    private void throwExceptionIfValidationWarningsExist(List<ApiParameterError> dataValidationErrors) {
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException("validation.msg.validation.errors.exist", "Validation errors exist.", dataValidationErrors);
        }
    }
}

