/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.organisation.office.service;

import jakarta.persistence.PersistenceException;
import java.math.BigDecimal;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.exception.ErrorHandler;
import org.apache.fineract.infrastructure.core.exception.PlatformDataIntegrityException;
import org.apache.fineract.infrastructure.security.exception.NoAuthorizationException;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.organisation.monetary.domain.ApplicationCurrency;
import org.apache.fineract.organisation.monetary.domain.ApplicationCurrencyRepositoryWrapper;
import org.apache.fineract.organisation.monetary.domain.MonetaryCurrency;
import org.apache.fineract.organisation.monetary.domain.Money;
import org.apache.fineract.organisation.office.domain.Office;
import org.apache.fineract.organisation.office.domain.OfficeRepositoryWrapper;
import org.apache.fineract.organisation.office.domain.OfficeTransaction;
import org.apache.fineract.organisation.office.domain.OfficeTransactionRepository;
import org.apache.fineract.organisation.office.serialization.OfficeCommandFromApiJsonDeserializer;
import org.apache.fineract.organisation.office.serialization.OfficeTransactionCommandFromApiJsonDeserializer;
import org.apache.fineract.organisation.office.service.OfficeWritePlatformService;
import org.apache.fineract.useradministration.domain.AppUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Caching;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.transaction.annotation.Transactional;

public class OfficeWritePlatformServiceJpaRepositoryImpl
implements OfficeWritePlatformService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OfficeWritePlatformServiceJpaRepositoryImpl.class);
    private final PlatformSecurityContext context;
    private final OfficeCommandFromApiJsonDeserializer fromApiJsonDeserializer;
    private final OfficeTransactionCommandFromApiJsonDeserializer moneyTransferCommandFromApiJsonDeserializer;
    private final OfficeRepositoryWrapper officeRepositoryWrapper;
    private final OfficeTransactionRepository officeTransactionRepository;
    private final ApplicationCurrencyRepositoryWrapper applicationCurrencyRepository;

    @Transactional
    @Caching(evict={@CacheEvict(value={"offices"}, key="T(org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil).getTenant().getTenantIdentifier().concat(#root.target.context.authenticatedUser().getOffice().getHierarchy()+'of')"), @CacheEvict(value={"officesForDropdown"}, key="T(org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil).getTenant().getTenantIdentifier().concat(#root.target.context.authenticatedUser().getOffice().getHierarchy()+'ofd')")})
    public CommandProcessingResult createOffice(JsonCommand command) {
        try {
            AppUser currentUser = this.context.authenticatedUser();
            this.fromApiJsonDeserializer.validateForCreate(command.json());
            Long parentId = null;
            if (command.parameterExists("parentId")) {
                parentId = command.longValueOfParameterNamed("parentId");
            }
            Office parent = this.validateUserPriviledgeOnOfficeAndRetrieve(currentUser, parentId);
            Office office = Office.fromJson((Office)parent, (JsonCommand)command);
            this.officeRepositoryWrapper.saveAndFlush(office);
            office.generateHierarchy();
            this.officeRepositoryWrapper.save(office);
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)office.getId()).withOfficeId((Long)office.getId()).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleOfficeDataIntegrityIssues(command, dve.getMostSpecificCause(), (Exception)dve);
            return CommandProcessingResult.empty();
        }
        catch (PersistenceException dve) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)dve.getCause());
            this.handleOfficeDataIntegrityIssues(command, throwable, (Exception)((Object)dve));
            return CommandProcessingResult.empty();
        }
    }

    @Transactional
    @Caching(evict={@CacheEvict(value={"offices"}, key="T(org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil).getTenant().getTenantIdentifier().concat(#root.target.context.authenticatedUser().getOffice().getHierarchy()+'of')"), @CacheEvict(value={"officesForDropdown"}, key="T(org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil).getTenant().getTenantIdentifier().concat(#root.target.context.authenticatedUser().getOffice().getHierarchy()+'ofd')"), @CacheEvict(value={"officesById"}, key="T(org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil).getTenant().getTenantIdentifier().concat(#officeId)")})
    public CommandProcessingResult updateOffice(Long officeId, JsonCommand command) {
        try {
            Office office;
            Map changes;
            AppUser currentUser = this.context.authenticatedUser();
            this.fromApiJsonDeserializer.validateForUpdate(command.json());
            Long parentId = null;
            if (command.parameterExists("parentId")) {
                parentId = command.longValueOfParameterNamed("parentId");
            }
            if ((changes = (office = this.validateUserPriviledgeOnOfficeAndRetrieve(currentUser, officeId)).update(command)).containsKey("parentId")) {
                Office parent = this.validateUserPriviledgeOnOfficeAndRetrieve(currentUser, parentId);
                office.update(parent);
            }
            if (!changes.isEmpty()) {
                this.officeRepositoryWrapper.saveAndFlush(office);
            }
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)office.getId()).withOfficeId((Long)office.getId()).with(changes).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleOfficeDataIntegrityIssues(command, dve.getMostSpecificCause(), (Exception)dve);
            return CommandProcessingResult.empty();
        }
        catch (PersistenceException dve) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)dve.getCause());
            this.handleOfficeDataIntegrityIssues(command, throwable, (Exception)((Object)dve));
            return CommandProcessingResult.empty();
        }
    }

    @Transactional
    public CommandProcessingResult officeTransaction(JsonCommand command) {
        this.context.authenticatedUser();
        this.moneyTransferCommandFromApiJsonDeserializer.validateOfficeTransfer(command.json());
        Long officeId = null;
        Office fromOffice = null;
        Long fromOfficeId = command.longValueOfParameterNamed("fromOfficeId");
        if (fromOfficeId != null) {
            fromOffice = this.officeRepositoryWrapper.findOneWithNotFoundDetection(fromOfficeId);
            officeId = (Long)fromOffice.getId();
        }
        Office toOffice = null;
        Long toOfficeId = command.longValueOfParameterNamed("toOfficeId");
        if (toOfficeId != null) {
            toOffice = this.officeRepositoryWrapper.findOneWithNotFoundDetection(toOfficeId);
            officeId = (Long)toOffice.getId();
        }
        String currencyCode = command.stringValueOfParameterNamed("currencyCode");
        ApplicationCurrency appCurrency = this.applicationCurrencyRepository.findOneWithNotFoundDetection(currencyCode);
        MonetaryCurrency currency = new MonetaryCurrency(appCurrency.getCode(), appCurrency.getDecimalPlaces().intValue(), appCurrency.getCurrencyInMultiplesOf());
        Money amount = Money.of((MonetaryCurrency)currency, (BigDecimal)command.bigDecimalValueOfParameterNamed("transactionAmount"));
        OfficeTransaction entity = OfficeTransaction.fromJson((Office)fromOffice, (Office)toOffice, (Money)amount, (JsonCommand)command);
        this.officeTransactionRepository.save((Object)entity);
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)entity.getId()).withOfficeId(officeId).build();
    }

    @Transactional
    public CommandProcessingResult deleteOfficeTransaction(Long transactionId, JsonCommand command) {
        this.context.authenticatedUser();
        this.officeTransactionRepository.deleteById((Object)transactionId);
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId(transactionId).build();
    }

    private void handleOfficeDataIntegrityIssues(JsonCommand command, Throwable realCause, Exception dve) {
        if (realCause.getMessage().contains("externalid_org")) {
            String externalId = command.stringValueOfParameterNamed("externalId");
            throw new PlatformDataIntegrityException("error.msg.office.duplicate.externalId", "Office with externalId `" + externalId + "` already exists", "externalId", new Object[]{externalId});
        }
        if (realCause.getMessage().contains("name_org")) {
            String name = command.stringValueOfParameterNamed("name");
            throw new PlatformDataIntegrityException("error.msg.office.duplicate.name", "Office with name `" + name + "` already exists", "name", new Object[]{name});
        }
        log.error("Error occured.", (Throwable)dve);
        throw ErrorHandler.getMappable((Throwable)dve, (String)"error.msg.office.unknown.data.integrity.issue", (String)"Unknown data integrity issue with resource.");
    }

    private Office validateUserPriviledgeOnOfficeAndRetrieve(AppUser currentUser, Long officeId) {
        Long userOfficeId = (Long)currentUser.getOffice().getId();
        Office userOffice = this.officeRepositoryWrapper.findOfficeHierarchy(userOfficeId);
        if (userOffice.doesNotHaveAnOfficeInHierarchyWithId(officeId)) {
            throw new NoAuthorizationException("User does not have sufficient priviledges to act on the provided office.");
        }
        Office officeToReturn = userOffice;
        if (!userOffice.identifiedBy(officeId)) {
            officeToReturn = this.officeRepositoryWrapper.findOfficeHierarchy(officeId);
        }
        return officeToReturn;
    }

    public PlatformSecurityContext getContext() {
        return this.context;
    }

    @Generated
    public OfficeWritePlatformServiceJpaRepositoryImpl(PlatformSecurityContext context, OfficeCommandFromApiJsonDeserializer fromApiJsonDeserializer, OfficeTransactionCommandFromApiJsonDeserializer moneyTransferCommandFromApiJsonDeserializer, OfficeRepositoryWrapper officeRepositoryWrapper, OfficeTransactionRepository officeTransactionRepository, ApplicationCurrencyRepositoryWrapper applicationCurrencyRepository) {
        this.context = context;
        this.fromApiJsonDeserializer = fromApiJsonDeserializer;
        this.moneyTransferCommandFromApiJsonDeserializer = moneyTransferCommandFromApiJsonDeserializer;
        this.officeRepositoryWrapper = officeRepositoryWrapper;
        this.officeTransactionRepository = officeTransactionRepository;
        this.applicationCurrencyRepository = applicationCurrencyRepository;
    }
}

