/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.account.domain;

public enum AccountTransferRecurrenceType {
    INVALID(Integer.valueOf(0), "accountTransferRecurrenceType.invalid"),
    PERIODIC(Integer.valueOf(1), "accountTransferRecurrenceType.periodic"),
    AS_PER_DUES(Integer.valueOf(2), "accountTransferRecurrenceType.as.per.dues");

    private final Integer value;
    private final String code;

    public static AccountTransferRecurrenceType fromInt(Integer statusValue) {
        AccountTransferRecurrenceType enumeration = INVALID;
        switch (statusValue) {
            case 1: {
                enumeration = PERIODIC;
                break;
            }
            case 2: {
                enumeration = AS_PER_DUES;
            }
        }
        return enumeration;
    }

    private AccountTransferRecurrenceType(Integer value, String code) {
        this.value = value;
        this.code = code;
    }

    public boolean hasStateOf(AccountTransferRecurrenceType state) {
        return this.value.equals(state.getValue());
    }

    public Integer getValue() {
        return this.value;
    }

    public String getCode() {
        return this.code;
    }

    public boolean isPeriodicRecurrence() {
        return this.value.equals(PERIODIC.getValue());
    }

    public boolean isDuesRecurrence() {
        return this.value.equals(AS_PER_DUES.getValue());
    }
}

