/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.account.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.fineract.portfolio.account.data.AccountAssociationsData;
import org.apache.fineract.portfolio.account.data.PortfolioAccountData;
import org.apache.fineract.portfolio.account.domain.AccountAssociationType;
import org.apache.fineract.portfolio.account.service.AccountAssociationsReadPlatformService;
import org.apache.fineract.portfolio.account.service.AccountAssociationsReadPlatformServiceImpl;
import org.apache.fineract.portfolio.loanaccount.domain.LoanStatus;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountStatusType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class AccountAssociationsReadPlatformServiceImpl
implements AccountAssociationsReadPlatformService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AccountAssociationsReadPlatformServiceImpl.class);
    private final JdbcTemplate jdbcTemplate;

    public PortfolioAccountData retriveLoanLinkedAssociation(Long loanId) {
        PortfolioAccountData linkedAccount = null;
        AccountAssociationsMapper mapper = new AccountAssociationsMapper();
        String sql = "select " + mapper.schema() + " where aa.loan_account_id = ? and aa.association_type_enum = ?";
        try {
            AccountAssociationsData accountAssociationsData = (AccountAssociationsData)this.jdbcTemplate.queryForObject(sql, (RowMapper)mapper, new Object[]{loanId, AccountAssociationType.LINKED_ACCOUNT_ASSOCIATION.getValue()});
            if (accountAssociationsData != null) {
                linkedAccount = accountAssociationsData.linkedAccount();
            }
        }
        catch (EmptyResultDataAccessException e) {
            log.debug("Linking account is not configured");
        }
        return linkedAccount;
    }

    public Collection<AccountAssociationsData> retriveLoanAssociations(Long loanId, Integer associationType) {
        AccountAssociationsMapper mapper = new AccountAssociationsMapper();
        String sql = "select " + mapper.schema() + " where aa.loan_account_id = ? and aa.association_type_enum = ?";
        try {
            return this.jdbcTemplate.query(sql, (RowMapper)mapper, new Object[]{loanId, associationType});
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    public PortfolioAccountData retriveSavingsLinkedAssociation(Long savingsId) {
        PortfolioAccountData linkedAccount = null;
        AccountAssociationsMapper mapper = new AccountAssociationsMapper();
        String sql = "select " + mapper.schema() + " where aa.savings_account_id = ? and aa.association_type_enum = ?";
        try {
            AccountAssociationsData accountAssociationsData = (AccountAssociationsData)this.jdbcTemplate.queryForObject(sql, (RowMapper)mapper, new Object[]{savingsId, AccountAssociationType.LINKED_ACCOUNT_ASSOCIATION.getValue()});
            if (accountAssociationsData != null) {
                linkedAccount = accountAssociationsData.linkedAccount();
            }
        }
        catch (EmptyResultDataAccessException e) {
            log.debug("Linking account is not configured");
        }
        return linkedAccount;
    }

    public boolean isLinkedWithAnyActiveAccount(Long savingsId) {
        boolean hasActiveAccount = false;
        String sql1 = "select aa.is_active as active,aa.association_type_enum as type, loanAccount.loan_status_id as loanStatus,savingAccount.status_enum as savingsStatus from m_portfolio_account_associations aa left join m_loan loanAccount on loanAccount.id = aa.loan_account_id left join m_savings_account savingAccount on savingAccount.id = aa.savings_account_id where aa.linked_savings_account_id = ?";
        List statusList = this.jdbcTemplate.queryForList("select aa.is_active as active,aa.association_type_enum as type, loanAccount.loan_status_id as loanStatus,savingAccount.status_enum as savingsStatus from m_portfolio_account_associations aa left join m_loan loanAccount on loanAccount.id = aa.loan_account_id left join m_savings_account savingAccount on savingAccount.id = aa.savings_account_id where aa.linked_savings_account_id = ?", new Object[]{savingsId});
        for (Map statusMap : statusList) {
            SavingsAccountStatusType saveStatus;
            LoanStatus loanStatus;
            AccountAssociationType associationType = AccountAssociationType.fromInt((Integer)((Integer)statusMap.get("type")));
            if (!associationType.isLinkedAccountAssociation() && ((Boolean)statusMap.get("active")).booleanValue()) {
                hasActiveAccount = true;
                break;
            }
            if (statusMap.get("loanStatus") != null && ((loanStatus = LoanStatus.fromInt((Integer)((Integer)statusMap.get("loanStatus")))).isActiveOrAwaitingApprovalOrDisbursal() || loanStatus.isUnderTransfer())) {
                hasActiveAccount = true;
                break;
            }
            if (statusMap.get("savingsStatus") == null || !(saveStatus = SavingsAccountStatusType.fromInt((Integer)((Integer)statusMap.get("savingsStatus")))).isActiveOrAwaitingApprovalOrDisbursal() && !saveStatus.isUnderTransfer()) continue;
            hasActiveAccount = true;
            break;
        }
        return hasActiveAccount;
    }

    public PortfolioAccountData retriveSavingsAccount(Long savingsId) {
        String accountNo = (String)this.jdbcTemplate.queryForObject("select account_no from m_savings_account where id = ?", String.class, new Object[]{savingsId});
        return PortfolioAccountData.lookup((Long)savingsId, (String)accountNo);
    }

    @Generated
    public AccountAssociationsReadPlatformServiceImpl(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }
}

