/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.collateralmanagement.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.collateralmanagement.data.LoanCollateralResponseData;
import org.apache.fineract.portfolio.collateralmanagement.domain.CollateralManagementDomain;
import org.apache.fineract.portfolio.collateralmanagement.exception.LoanCollateralManagementNotFoundException;
import org.apache.fineract.portfolio.collateralmanagement.service.LoanCollateralManagementReadPlatformService;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanCollateralManagement;
import org.apache.fineract.portfolio.loanaccount.domain.LoanCollateralManagementRepository;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepository;
import org.apache.fineract.portfolio.loanaccount.exception.LoanNotFoundException;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class LoanCollateralManagementReadPlatformServiceImpl
implements LoanCollateralManagementReadPlatformService {
    private final PlatformSecurityContext context;
    private LoanCollateralManagementRepository loanCollateralManagementRepository;
    private LoanRepository loanRepository;

    public LoanCollateralManagementReadPlatformServiceImpl(PlatformSecurityContext context, LoanCollateralManagementRepository loanCollateralManagementRepository, LoanRepository loanRepository) {
        this.context = context;
        this.loanCollateralManagementRepository = loanCollateralManagementRepository;
        this.loanRepository = loanRepository;
    }

    public List<LoanCollateralManagement> getLoanCollaterals(Long loanId) {
        this.context.authenticatedUser();
        Loan loan = (Loan)this.loanRepository.findById((Object)loanId).orElseThrow(() -> new LoanNotFoundException(loanId));
        return this.loanCollateralManagementRepository.findByLoan(loan);
    }

    public LoanCollateralResponseData getLoanCollateralResponseData(Long collateralId) {
        this.context.authenticatedUser();
        LoanCollateralManagement loanCollateralManagement = (LoanCollateralManagement)this.loanCollateralManagementRepository.findById((Object)collateralId).orElseThrow(() -> new LoanCollateralManagementNotFoundException(collateralId));
        CollateralManagementDomain collateralManagementDomain = loanCollateralManagement.getClientCollateralManagement().getCollaterals();
        BigDecimal quantity = loanCollateralManagement.getQuantity();
        BigDecimal total = quantity.multiply(collateralManagementDomain.getBasePrice());
        BigDecimal totalCollateral = total.multiply(collateralManagementDomain.getPctToBase()).divide(BigDecimal.valueOf(100L));
        return LoanCollateralResponseData.instanceOf((LoanCollateralManagement)loanCollateralManagement, (BigDecimal)total, (BigDecimal)totalCollateral);
    }

    public List<LoanCollateralResponseData> getLoanCollateralResponseDataList(Long loanId) {
        this.context.authenticatedUser();
        Loan loan = (Loan)this.loanRepository.findById((Object)loanId).orElseThrow(() -> new LoanNotFoundException(loanId));
        ArrayList<LoanCollateralResponseData> loanCollateralResponseDataCollection = new ArrayList<LoanCollateralResponseData>();
        Set loanCollateralManagements = loan.getLoanCollateralManagements();
        for (LoanCollateralManagement loanCollateralManagement : loanCollateralManagements) {
            CollateralManagementDomain collateralManagementDomain = loanCollateralManagement.getClientCollateralManagement().getCollaterals();
            BigDecimal quantity = loanCollateralManagement.getQuantity();
            BigDecimal total = quantity.multiply(collateralManagementDomain.getBasePrice());
            BigDecimal totalCollateral = total.multiply(collateralManagementDomain.getPctToBase()).divide(BigDecimal.valueOf(100L));
            loanCollateralResponseDataCollection.add(LoanCollateralResponseData.instanceOf((LoanCollateralManagement)loanCollateralManagement, (BigDecimal)total, (BigDecimal)totalCollateral));
        }
        return loanCollateralResponseDataCollection;
    }
}

