/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.service;

import com.google.common.base.Splitter;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.domain.ExternalId;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.core.service.ExternalIdFactory;
import org.apache.fineract.portfolio.charge.domain.Charge;
import org.apache.fineract.portfolio.charge.domain.ChargeCalculationType;
import org.apache.fineract.portfolio.charge.domain.ChargePaymentMode;
import org.apache.fineract.portfolio.charge.domain.ChargeRepositoryWrapper;
import org.apache.fineract.portfolio.charge.domain.ChargeTimeType;
import org.apache.fineract.portfolio.charge.exception.LoanChargeNotFoundException;
import org.apache.fineract.portfolio.charge.exception.LoanChargeWithoutMandatoryFieldException;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanCharge;
import org.apache.fineract.portfolio.loanaccount.domain.LoanChargeRepository;
import org.apache.fineract.portfolio.loanaccount.domain.LoanDisbursementDetails;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTrancheDisbursementCharge;
import org.apache.fineract.portfolio.loanaccount.service.LoanChargeAssembler;
import org.apache.fineract.portfolio.loanaccount.service.LoanChargeService;
import org.apache.fineract.portfolio.loanproduct.domain.LoanProduct;
import org.apache.fineract.portfolio.loanproduct.domain.LoanProductRepository;
import org.apache.fineract.portfolio.loanproduct.exception.LoanProductNotFoundException;

public class LoanChargeAssembler {
    private final FromJsonHelper fromApiJsonHelper;
    private final ChargeRepositoryWrapper chargeRepository;
    private final LoanChargeRepository loanChargeRepository;
    private final LoanProductRepository loanProductRepository;
    private final ExternalIdFactory externalIdFactory;
    private final LoanChargeService loanChargeService;

    public Set<LoanCharge> fromParsedJson(JsonElement element, List<LoanDisbursementDetails> disbursementDetails) {
        JsonArray jsonDisbursement = this.fromApiJsonHelper.extractJsonArrayNamed("disbursementData", element);
        ArrayList<Long> disbursementChargeIds = new ArrayList<Long>();
        if (jsonDisbursement != null && !jsonDisbursement.isEmpty()) {
            for (int i = 0; i < jsonDisbursement.size(); ++i) {
                String chargeIds;
                JsonObject jsonObject = jsonDisbursement.get(i).getAsJsonObject();
                if (jsonObject == null || jsonObject.getAsJsonPrimitive("loanChargeId") == null || (chargeIds = jsonObject.getAsJsonPrimitive("loanChargeId").getAsString()) == null) continue;
                if (chargeIds.contains(",")) {
                    Iterable chargeId = Splitter.on((char)',').split((CharSequence)chargeIds);
                    for (String loanChargeId : chargeId) {
                        disbursementChargeIds.add(Long.parseLong(loanChargeId));
                    }
                    continue;
                }
                disbursementChargeIds.add(Long.parseLong(chargeIds));
            }
        }
        HashSet<LoanCharge> loanCharges = new HashSet<LoanCharge>();
        BigDecimal principal = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("principal", element);
        Integer numberOfRepayments = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("numberOfRepayments", element);
        Long productId = this.fromApiJsonHelper.extractLongNamed("productId", element);
        LoanProduct loanProduct = (LoanProduct)this.loanProductRepository.findById((Object)productId).orElseThrow(() -> new LoanProductNotFoundException(productId));
        boolean isMultiDisbursal = loanProduct.isMultiDisburseLoan();
        LocalDate expectedDisbursementDate = null;
        if (element.isJsonObject()) {
            JsonObject topLevelJsonElement = element.getAsJsonObject();
            String dateFormat = this.fromApiJsonHelper.extractDateFormatParameter(topLevelJsonElement);
            Locale locale = this.fromApiJsonHelper.extractLocaleParameter(topLevelJsonElement);
            if (topLevelJsonElement.has("charges") && topLevelJsonElement.get("charges").isJsonArray()) {
                JsonArray array = topLevelJsonElement.get("charges").getAsJsonArray();
                for (int i = 0; i < array.size(); ++i) {
                    JsonObject loanChargeElement = array.get(i).getAsJsonObject();
                    Long loanChargeId = this.fromApiJsonHelper.extractLongNamed("id", (JsonElement)loanChargeElement);
                    Long chargeId = this.fromApiJsonHelper.extractLongNamed("chargeId", (JsonElement)loanChargeElement);
                    BigDecimal amount = this.fromApiJsonHelper.extractBigDecimalNamed("amount", (JsonElement)loanChargeElement, locale);
                    Integer chargeTimeType = this.fromApiJsonHelper.extractIntegerNamed("chargeTimeType", (JsonElement)loanChargeElement, locale);
                    Integer chargeCalculationType = this.fromApiJsonHelper.extractIntegerNamed("chargeCalculationType", (JsonElement)loanChargeElement, locale);
                    LocalDate dueDate = this.fromApiJsonHelper.extractLocalDateNamed("dueDate", (JsonElement)loanChargeElement, dateFormat, locale);
                    Integer chargePaymentMode = this.fromApiJsonHelper.extractIntegerNamed("chargePaymentMode", (JsonElement)loanChargeElement, locale);
                    String externalIdStr = this.fromApiJsonHelper.extractStringNamed("externalId", (JsonElement)loanChargeElement);
                    ExternalId externalId = this.externalIdFactory.create(externalIdStr);
                    if (loanChargeId == null) {
                        LoanCharge loanCharge;
                        Object loanCharge2;
                        Charge chargeDefinition = this.chargeRepository.findOneWithNotFoundDetection(chargeId);
                        ChargeTimeType chargeTime = null;
                        if (chargeTimeType != null) {
                            chargeTime = ChargeTimeType.fromInt((Integer)chargeTimeType);
                        }
                        ChargeCalculationType chargeCalculation = null;
                        if (chargeCalculationType != null) {
                            chargeCalculation = ChargeCalculationType.fromInt((Integer)chargeCalculationType);
                        }
                        ChargePaymentMode chargePaymentModeEnum = null;
                        if (chargePaymentMode != null) {
                            chargePaymentModeEnum = ChargePaymentMode.fromInt((Integer)chargePaymentMode);
                        }
                        if (!isMultiDisbursal) {
                            loanCharge2 = this.createNewWithoutLoan(chargeDefinition, principal, amount, chargeTime, chargeCalculation, dueDate, chargePaymentModeEnum, numberOfRepayments, externalId);
                            loanCharges.add((LoanCharge)loanCharge2);
                            continue;
                        }
                        if (topLevelJsonElement.has("disbursementData") && topLevelJsonElement.get("disbursementData").isJsonArray()) {
                            JsonArray disbursementArray = topLevelJsonElement.get("disbursementData").getAsJsonArray();
                            if (!disbursementArray.isEmpty()) {
                                JsonObject disbursementDataElement = disbursementArray.get(0).getAsJsonObject();
                                expectedDisbursementDate = this.fromApiJsonHelper.extractLocalDateNamed("expectedDisbursementDate", (JsonElement)disbursementDataElement, dateFormat, locale);
                            } else {
                                expectedDisbursementDate = this.fromApiJsonHelper.extractLocalDateNamed("expectedDisbursementDate", element);
                            }
                        }
                        if (ChargeTimeType.DISBURSEMENT.getValue().equals(chargeDefinition.getChargeTimeType())) {
                            if (CollectionUtils.isEmpty(disbursementDetails)) {
                                loanCharge2 = this.createNewWithoutLoan(chargeDefinition, principal, amount, chargeTime, chargeCalculation, dueDate, chargePaymentModeEnum, numberOfRepayments, externalId);
                                loanCharges.add((LoanCharge)loanCharge2);
                                continue;
                            }
                            for (LoanDisbursementDetails disbursementDetail : disbursementDetails) {
                                LoanTrancheDisbursementCharge loanTrancheDisbursementCharge = null;
                                if (chargeDefinition.isPercentageOfApprovedAmount() && disbursementDetail.expectedDisbursementDateAsLocalDate().equals(expectedDisbursementDate)) {
                                    loanCharge = this.createNewWithoutLoan(chargeDefinition, principal, amount, chargeTime, chargeCalculation, dueDate, chargePaymentModeEnum, numberOfRepayments, externalId);
                                    loanCharges.add(loanCharge);
                                    if (!loanCharge.isTrancheDisbursementCharge()) continue;
                                    loanTrancheDisbursementCharge = new LoanTrancheDisbursementCharge(loanCharge, disbursementDetail);
                                    loanCharge.updateLoanTrancheDisbursementCharge(loanTrancheDisbursementCharge);
                                    continue;
                                }
                                if (!disbursementDetail.expectedDisbursementDateAsLocalDate().equals(expectedDisbursementDate)) continue;
                                loanCharge = this.createNewWithoutLoan(chargeDefinition, disbursementDetail.principal(), amount, chargeTime, chargeCalculation, disbursementDetail.expectedDisbursementDateAsLocalDate(), chargePaymentModeEnum, numberOfRepayments, externalId);
                                loanCharges.add(loanCharge);
                                if (!loanCharge.isTrancheDisbursementCharge()) continue;
                                loanTrancheDisbursementCharge = new LoanTrancheDisbursementCharge(loanCharge, disbursementDetail);
                                loanCharge.updateLoanTrancheDisbursementCharge(loanTrancheDisbursementCharge);
                            }
                            continue;
                        }
                        if (ChargeTimeType.TRANCHE_DISBURSEMENT.getValue().equals(chargeDefinition.getChargeTimeType())) {
                            LoanTrancheDisbursementCharge loanTrancheDisbursementCharge = null;
                            for (LoanDisbursementDetails disbursementDetail : disbursementDetails) {
                                if (!ChargeTimeType.TRANCHE_DISBURSEMENT.getValue().equals(chargeDefinition.getChargeTimeType())) continue;
                                loanCharge = this.createNewWithoutLoan(chargeDefinition, disbursementDetail.principal(), amount, chargeTime, chargeCalculation, disbursementDetail.expectedDisbursementDateAsLocalDate(), chargePaymentModeEnum, numberOfRepayments, externalId);
                                loanCharges.add(loanCharge);
                                loanTrancheDisbursementCharge = new LoanTrancheDisbursementCharge(loanCharge, disbursementDetail);
                                loanCharge.updateLoanTrancheDisbursementCharge(loanTrancheDisbursementCharge);
                            }
                            continue;
                        }
                        loanCharge2 = this.createNewWithoutLoan(chargeDefinition, principal, amount, chargeTime, chargeCalculation, dueDate, chargePaymentModeEnum, numberOfRepayments, externalId);
                        loanCharges.add((LoanCharge)loanCharge2);
                        continue;
                    }
                    LoanCharge loanCharge = (LoanCharge)this.loanChargeRepository.findById((Object)loanChargeId).orElseThrow(() -> new LoanChargeNotFoundException(loanChargeId));
                    if (loanCharge.isTrancheDisbursementCharge() && !disbursementChargeIds.contains(loanChargeId)) continue;
                    this.loanChargeService.update(loanCharge, amount, dueDate, numberOfRepayments);
                    loanCharges.add(loanCharge);
                }
            }
        }
        return loanCharges;
    }

    public Set<Charge> getNewLoanTrancheCharges(JsonElement element) {
        JsonObject topLevelJsonElement;
        HashSet<Charge> associatedChargesForLoan = new HashSet<Charge>();
        if (element.isJsonObject() && (topLevelJsonElement = element.getAsJsonObject()).has("charges") && topLevelJsonElement.get("charges").isJsonArray()) {
            JsonArray array = topLevelJsonElement.get("charges").getAsJsonArray();
            for (int i = 0; i < array.size(); ++i) {
                Charge chargeDefinition;
                JsonObject loanChargeElement = array.get(i).getAsJsonObject();
                Long id = this.fromApiJsonHelper.extractLongNamed("id", (JsonElement)loanChargeElement);
                Long chargeId = this.fromApiJsonHelper.extractLongNamed("chargeId", (JsonElement)loanChargeElement);
                if (id != null || !(chargeDefinition = this.chargeRepository.findOneWithNotFoundDetection(chargeId)).getChargeTimeType().equals(ChargeTimeType.TRANCHE_DISBURSEMENT.getValue())) continue;
                associatedChargesForLoan.add(chargeDefinition);
            }
        }
        return associatedChargesForLoan;
    }

    public LoanCharge createNewFromJson(Loan loan, Charge chargeDefinition, JsonCommand command) {
        LocalDate dueDate = command.localDateValueOfParameterNamed("dueDate");
        if (chargeDefinition.getChargeTimeType().equals(ChargeTimeType.SPECIFIED_DUE_DATE.getValue()) && dueDate == null) {
            String defaultUserMessage = "Loan charge is missing due date.";
            throw new LoanChargeWithoutMandatoryFieldException("loanCharge", "dueDate", "Loan charge is missing due date.", new Object[]{chargeDefinition.getId(), chargeDefinition.getName()});
        }
        return this.createNewFromJson(loan, chargeDefinition, command, dueDate);
    }

    public LoanCharge createNewFromJson(Loan loan, Charge chargeDefinition, JsonCommand command, LocalDate dueDate) {
        Locale locale = command.extractLocale();
        BigDecimal amount = command.bigDecimalValueOfParameterNamed("amount", locale);
        ChargeTimeType chargeTime = null;
        ChargeCalculationType chargeCalculation = null;
        ChargePaymentMode chargePaymentMode = null;
        BigDecimal amountPercentageAppliedTo = BigDecimal.ZERO;
        switch (1.$SwitchMap$org$apache$fineract$portfolio$charge$domain$ChargeCalculationType[ChargeCalculationType.fromInt((Integer)chargeDefinition.getChargeCalculation()).ordinal()]) {
            case 1: {
                if (command.hasParameter("principal")) {
                    amountPercentageAppliedTo = command.bigDecimalValueOfParameterNamed("principal");
                    break;
                }
                amountPercentageAppliedTo = loan.getPrincipal().getAmount();
                break;
            }
            case 2: {
                if (command.hasParameter("principal") && command.hasParameter("interest")) {
                    amountPercentageAppliedTo = command.bigDecimalValueOfParameterNamed("principal").add(command.bigDecimalValueOfParameterNamed("interest"));
                    break;
                }
                amountPercentageAppliedTo = loan.getPrincipal().getAmount().add(loan.getTotalInterest());
                break;
            }
            case 3: {
                if (command.hasParameter("interest")) {
                    amountPercentageAppliedTo = command.bigDecimalValueOfParameterNamed("interest");
                    break;
                }
                amountPercentageAppliedTo = loan.getTotalInterest();
                break;
            }
        }
        BigDecimal loanCharge = BigDecimal.ZERO;
        if (ChargeTimeType.fromInt((Integer)chargeDefinition.getChargeTimeType()).equals((Object)ChargeTimeType.INSTALMENT_FEE)) {
            Object percentage = amount;
            if (percentage == null) {
                percentage = chargeDefinition.getAmount();
            }
            loanCharge = this.loanChargeService.calculatePerInstallmentChargeAmount(loan, ChargeCalculationType.fromInt((Integer)chargeDefinition.getChargeCalculation()), (BigDecimal)percentage);
        }
        if (chargeDefinition.getChargeTimeType().equals(ChargeTimeType.SPECIFIED_DUE_DATE.getValue()) && loan.isMultiDisburmentLoan()) {
            amountPercentageAppliedTo = BigDecimal.ZERO;
            for (LoanDisbursementDetails loanDisbursementDetails : loan.getDisbursementDetails()) {
                if (DateUtils.isAfter((LocalDate)loanDisbursementDetails.expectedDisbursementDate(), (LocalDate)dueDate)) continue;
                amountPercentageAppliedTo = amountPercentageAppliedTo.add(loanDisbursementDetails.principal());
            }
        }
        ExternalId externalId = this.externalIdFactory.createFromCommand(command, "externalId");
        return this.loanChargeService.create(loan, chargeDefinition, amountPercentageAppliedTo, amount, chargeTime, chargeCalculation, dueDate, chargePaymentMode, null, loanCharge, externalId);
    }

    public LoanCharge createNewWithoutLoan(Charge chargeDefinition, BigDecimal loanPrincipal, BigDecimal amount, ChargeTimeType chargeTime, ChargeCalculationType chargeCalculation, LocalDate dueDate, ChargePaymentMode chargePaymentMode, Integer numberOfRepayments, ExternalId externalId) {
        return this.loanChargeService.create(null, chargeDefinition, loanPrincipal, amount, chargeTime, chargeCalculation, dueDate, chargePaymentMode, numberOfRepayments, BigDecimal.ZERO, externalId);
    }

    @Generated
    public LoanChargeAssembler(FromJsonHelper fromApiJsonHelper, ChargeRepositoryWrapper chargeRepository, LoanChargeRepository loanChargeRepository, LoanProductRepository loanProductRepository, ExternalIdFactory externalIdFactory, LoanChargeService loanChargeService) {
        this.fromApiJsonHelper = fromApiJsonHelper;
        this.chargeRepository = chargeRepository;
        this.loanChargeRepository = loanChargeRepository;
        this.loanProductRepository = loanProductRepository;
        this.externalIdFactory = externalIdFactory;
        this.loanChargeService = loanChargeService;
    }
}

