/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.service;

import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.Predicate;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.codes.service.CodeValueReadPlatformService;
import org.apache.fineract.infrastructure.configuration.domain.ConfigurationDomainService;
import org.apache.fineract.infrastructure.core.data.EnumOptionData;
import org.apache.fineract.infrastructure.core.domain.AbstractPersistableCustom;
import org.apache.fineract.infrastructure.core.domain.ExternalId;
import org.apache.fineract.infrastructure.core.exception.GeneralPlatformDomainRuleException;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.core.service.ExternalIdFactory;
import org.apache.fineract.infrastructure.core.service.MathUtil;
import org.apache.fineract.infrastructure.core.service.PaginationHelper;
import org.apache.fineract.infrastructure.core.service.SearchParameters;
import org.apache.fineract.infrastructure.core.service.database.DatabaseSpecificSQLGenerator;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.infrastructure.security.utils.ColumnValidator;
import org.apache.fineract.organisation.monetary.data.CurrencyData;
import org.apache.fineract.organisation.monetary.domain.ApplicationCurrency;
import org.apache.fineract.organisation.monetary.domain.ApplicationCurrencyRepositoryWrapper;
import org.apache.fineract.organisation.monetary.domain.MonetaryCurrency;
import org.apache.fineract.organisation.monetary.domain.Money;
import org.apache.fineract.organisation.office.domain.Office;
import org.apache.fineract.organisation.staff.data.StaffData;
import org.apache.fineract.organisation.staff.service.StaffReadPlatformService;
import org.apache.fineract.portfolio.accountdetails.domain.AccountType;
import org.apache.fineract.portfolio.accountdetails.service.AccountDetailsReadPlatformService;
import org.apache.fineract.portfolio.calendar.data.CalendarData;
import org.apache.fineract.portfolio.calendar.domain.CalendarEntityType;
import org.apache.fineract.portfolio.calendar.service.CalendarReadPlatformService;
import org.apache.fineract.portfolio.charge.domain.Charge;
import org.apache.fineract.portfolio.charge.domain.ChargeTimeType;
import org.apache.fineract.portfolio.charge.service.ChargeReadPlatformService;
import org.apache.fineract.portfolio.client.data.ClientData;
import org.apache.fineract.portfolio.client.service.ClientReadPlatformService;
import org.apache.fineract.portfolio.delinquency.service.DelinquencyReadPlatformService;
import org.apache.fineract.portfolio.floatingrates.data.InterestRatePeriodData;
import org.apache.fineract.portfolio.floatingrates.service.FloatingRatesReadPlatformService;
import org.apache.fineract.portfolio.fund.service.FundReadPlatformService;
import org.apache.fineract.portfolio.group.data.GroupGeneralData;
import org.apache.fineract.portfolio.group.service.GroupReadPlatformService;
import org.apache.fineract.portfolio.loanaccount.data.DisbursementData;
import org.apache.fineract.portfolio.loanaccount.data.LoanAccountData;
import org.apache.fineract.portfolio.loanaccount.data.LoanApprovalData;
import org.apache.fineract.portfolio.loanaccount.data.LoanRepaymentScheduleInstallmentData;
import org.apache.fineract.portfolio.loanaccount.data.LoanTransactionData;
import org.apache.fineract.portfolio.loanaccount.data.LoanTransactionEnumData;
import org.apache.fineract.portfolio.loanaccount.data.OutstandingAmountsDTO;
import org.apache.fineract.portfolio.loanaccount.data.PaidInAdvanceData;
import org.apache.fineract.portfolio.loanaccount.data.RepaymentScheduleRelatedLoanData;
import org.apache.fineract.portfolio.loanaccount.data.ScheduleGeneratorDTO;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanBuyDownFeeBalance;
import org.apache.fineract.portfolio.loanaccount.domain.LoanCapitalizedIncomeBalance;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepaymentScheduleInstallment;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepositoryWrapper;
import org.apache.fineract.portfolio.loanaccount.domain.LoanStatus;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransaction;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionRepaymentPeriodData;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionRepository;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionType;
import org.apache.fineract.portfolio.loanaccount.exception.LoanNotFoundException;
import org.apache.fineract.portfolio.loanaccount.exception.LoanTransactionNotFoundException;
import org.apache.fineract.portfolio.loanaccount.loanschedule.data.LoanScheduleData;
import org.apache.fineract.portfolio.loanaccount.loanschedule.data.OverdueLoanScheduleData;
import org.apache.fineract.portfolio.loanaccount.loanschedule.domain.LoanScheduleProcessingType;
import org.apache.fineract.portfolio.loanaccount.loanschedule.domain.LoanScheduleType;
import org.apache.fineract.portfolio.loanaccount.mapper.LoanTransactionMapper;
import org.apache.fineract.portfolio.loanaccount.repository.LoanBuyDownFeeBalanceRepository;
import org.apache.fineract.portfolio.loanaccount.repository.LoanCapitalizedIncomeBalanceRepository;
import org.apache.fineract.portfolio.loanaccount.serialization.LoanForeclosureValidator;
import org.apache.fineract.portfolio.loanaccount.service.InterestRefundService;
import org.apache.fineract.portfolio.loanaccount.service.InterestRefundServiceDelegate;
import org.apache.fineract.portfolio.loanaccount.service.LoanBalanceService;
import org.apache.fineract.portfolio.loanaccount.service.LoanChargePaidByReadService;
import org.apache.fineract.portfolio.loanaccount.service.LoanMaximumAmountCalculator;
import org.apache.fineract.portfolio.loanaccount.service.LoanReadPlatformService;
import org.apache.fineract.portfolio.loanaccount.service.LoanReadPlatformServiceCommon;
import org.apache.fineract.portfolio.loanaccount.service.LoanReadPlatformServiceImpl;
import org.apache.fineract.portfolio.loanaccount.service.LoanTransactionProcessingService;
import org.apache.fineract.portfolio.loanaccount.service.LoanTransactionRelationReadService;
import org.apache.fineract.portfolio.loanaccount.service.LoanUtilService;
import org.apache.fineract.portfolio.loanproduct.data.LoanProductData;
import org.apache.fineract.portfolio.loanproduct.domain.InterestMethod;
import org.apache.fineract.portfolio.loanproduct.service.LoanDropdownReadPlatformService;
import org.apache.fineract.portfolio.loanproduct.service.LoanEnumerations;
import org.apache.fineract.portfolio.loanproduct.service.LoanProductReadPlatformService;
import org.apache.fineract.portfolio.paymenttype.data.PaymentTypeData;
import org.apache.fineract.portfolio.paymenttype.service.PaymentTypeReadPlatformService;
import org.apache.fineract.useradministration.domain.AppUser;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Transactional(readOnly=true)
public class LoanReadPlatformServiceImpl
implements LoanReadPlatformService,
LoanReadPlatformServiceCommon {
    private final JdbcTemplate jdbcTemplate;
    private final PlatformSecurityContext context;
    private final LoanRepositoryWrapper loanRepositoryWrapper;
    private final ApplicationCurrencyRepositoryWrapper applicationCurrencyRepository;
    private final LoanProductReadPlatformService loanProductReadPlatformService;
    private final ClientReadPlatformService clientReadPlatformService;
    private final GroupReadPlatformService groupReadPlatformService;
    private final LoanDropdownReadPlatformService loanDropdownReadPlatformService;
    private final FundReadPlatformService fundReadPlatformService;
    private final ChargeReadPlatformService chargeReadPlatformService;
    private final CodeValueReadPlatformService codeValueReadPlatformService;
    private final CalendarReadPlatformService calendarReadPlatformService;
    private final StaffReadPlatformService staffReadPlatformService;
    private final PaginationHelper paginationHelper;
    private final PaymentTypeReadPlatformService paymentTypeReadPlatformService;
    private final FloatingRatesReadPlatformService floatingRatesReadPlatformService;
    private final LoanUtilService loanUtilService;
    private final ConfigurationDomainService configurationDomainService;
    private final AccountDetailsReadPlatformService accountDetailsReadPlatformService;
    private final ColumnValidator columnValidator;
    private final DatabaseSpecificSQLGenerator sqlGenerator;
    private final DelinquencyReadPlatformService delinquencyReadPlatformService;
    private final LoanTransactionRepository loanTransactionRepository;
    private final LoanChargePaidByReadService loanChargePaidByReadService;
    private final LoanTransactionRelationReadService loanTransactionRelationReadService;
    private final LoanForeclosureValidator loanForeclosureValidator;
    private final LoanTransactionMapper loanTransactionMapper;
    private final LoanTransactionProcessingService loadTransactionProcessingService;
    private final LoanBalanceService loanBalanceService;
    private final LoanCapitalizedIncomeBalanceRepository loanCapitalizedIncomeBalanceRepository;
    private final LoanBuyDownFeeBalanceRepository loanBuyDownFeeBalanceRepository;
    private final InterestRefundServiceDelegate interestRefundServiceDelegate;
    private final LoanMaximumAmountCalculator loanMaximumAmountCalculator;

    public LoanAccountData retrieveOne(Long loanId) {
        try {
            String hierarchy = this.getHierarchyString();
            String hierarchySearchString = hierarchy + "%";
            LoanMapper rm = new LoanMapper(this.sqlGenerator, this.delinquencyReadPlatformService);
            StringBuilder sqlBuilder = new StringBuilder();
            sqlBuilder.append("select ");
            sqlBuilder.append(rm.loanSchema());
            sqlBuilder.append(" join m_office o on (o.id = c.office_id or o.id = g.office_id) ");
            sqlBuilder.append(" left join m_office transferToOffice on transferToOffice.id = c.transfer_to_office_id ");
            sqlBuilder.append(" where l.id=? and ( o.hierarchy like ? or transferToOffice.hierarchy like ?)");
            return (LoanAccountData)this.jdbcTemplate.queryForObject(sqlBuilder.toString(), (RowMapper)rm, new Object[]{loanId, hierarchySearchString, hierarchySearchString});
        }
        catch (EmptyResultDataAccessException e) {
            throw new LoanNotFoundException(loanId, (Exception)((Object)e));
        }
    }

    private String getHierarchyString() {
        AppUser currentUser = null;
        if (this.context != null) {
            currentUser = this.context.getAuthenticatedUserIfPresent();
        }
        return Optional.ofNullable(currentUser).map(appUser -> appUser.getOffice().getHierarchy()).orElse(".");
    }

    public LoanAccountData retrieveLoanByLoanAccount(String loanAccountNumber) {
        this.context.authenticatedUser();
        LoanMapper rm = new LoanMapper(this.sqlGenerator, this.delinquencyReadPlatformService);
        String sql = "select " + rm.loanSchema() + " where l.account_no=?";
        return (LoanAccountData)this.jdbcTemplate.queryForObject(sql, (RowMapper)rm, new Object[]{loanAccountNumber});
    }

    public List<LoanAccountData> retrieveGLIMChildLoansByGLIMParentAccount(String parentloanAccountNumber) {
        this.context.authenticatedUser();
        LoanMapper rm = new LoanMapper(this.sqlGenerator, this.delinquencyReadPlatformService);
        String sql = "select " + rm.loanSchema() + " left join glim_parent_child_mapping as glim on glim.glim_child_account_id=l.account_no where glim.glim_parent_account_id=?";
        return this.jdbcTemplate.query(sql, (RowMapper)rm, new Object[]{parentloanAccountNumber});
    }

    public LoanAccountData fetchRepaymentScheduleData(LoanAccountData accountData) {
        RepaymentScheduleRelatedLoanData repaymentScheduleRelatedData = new RepaymentScheduleRelatedLoanData(accountData.getTimeline().getExpectedDisbursementDate(), accountData.getTimeline().getActualDisbursementDate(), accountData.getCurrency(), accountData.getPrincipal(), accountData.getInArrearsTolerance(), accountData.getFeeChargesAtDisbursementCharged());
        Collection disbursementData = this.retrieveLoanDisbursementDetails(accountData.getId());
        List capitalizedIncomeData = this.loanCapitalizedIncomeBalanceRepository.findRepaymentPeriodDataByLoanId(accountData.getId());
        LoanScheduleData repaymentSchedule = this.retrieveRepaymentSchedule(accountData.getId(), repaymentScheduleRelatedData, disbursementData, (Collection)capitalizedIncomeData, accountData.isInterestRecalculationEnabled(), LoanScheduleType.fromEnumOptionData((EnumOptionData)accountData.getLoanScheduleType()));
        accountData.setRepaymentSchedule(repaymentSchedule);
        return accountData;
    }

    public LoanScheduleData retrieveRepaymentSchedule(Long loanId, RepaymentScheduleRelatedLoanData repaymentScheduleRelatedLoanData, Collection<DisbursementData> disbursementData, Collection<LoanTransactionRepaymentPeriodData> capitalizedIncomeData, boolean isInterestRecalculationEnabled, LoanScheduleType loanScheduleType) {
        try {
            this.context.authenticatedUser();
            LoanScheduleResultSetExtractor fullResultsetExtractor = new LoanScheduleResultSetExtractor(repaymentScheduleRelatedLoanData, disbursementData, capitalizedIncomeData, isInterestRecalculationEnabled, loanScheduleType);
            String sql = "select " + fullResultsetExtractor.schema() + " where ls.loan_id = ? order by ls.loan_id, ls.installment";
            return (LoanScheduleData)this.jdbcTemplate.query(sql, (ResultSetExtractor)fullResultsetExtractor, new Object[]{loanId});
        }
        catch (EmptyResultDataAccessException e) {
            throw new LoanNotFoundException(loanId, (Exception)((Object)e));
        }
    }

    public Collection<LoanTransactionData> retrieveLoanTransactions(Long loanId) {
        try {
            this.context.authenticatedUser();
            LoanTransactionsMapper rm = new LoanTransactionsMapper(this.sqlGenerator);
            String sql = "select " + rm.loanPaymentsSchema() + " where tr.loan_id = ? and tr.transaction_type_enum not in (0, 3)  and (tr.is_reversed=false or tr.manually_adjusted_or_reversed = true)  order by tr.transaction_date, tr.created_on_utc, tr.id ";
            List loanTransactionData = this.jdbcTemplate.query(sql, (RowMapper)rm, new Object[]{loanId});
            List loanIds = loanTransactionData.stream().map(LoanTransactionData::getId).collect(Collectors.toList());
            List loanTransactionRelationDatas = this.loanTransactionRelationReadService.fetchLoanTransactionRelationDataFrom(loanIds);
            List loanChargePaidByDatas = this.loanChargePaidByReadService.fetchLoanChargesPaidByDataTransactionId(loanIds);
            for (LoanTransactionData loanTransaction : loanTransactionData) {
                loanTransaction.setTransactionRelations(loanTransactionRelationDatas.stream().filter(loanTransactionRelationData -> loanTransactionRelationData.getFromLoanTransaction().equals(loanTransaction.getId())).toList());
                loanTransaction.setLoanChargePaidByList(loanChargePaidByDatas.stream().filter(loanChargePaidByData -> loanChargePaidByData.getTransactionId().equals(loanTransaction.getId())).toList());
            }
            return loanTransactionData;
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    public org.apache.fineract.infrastructure.core.service.Page<LoanAccountData> retrieveAll(SearchParameters searchParameters) {
        AppUser currentUser = this.context.authenticatedUser();
        String hierarchy = currentUser.getOffice().getHierarchy();
        String hierarchySearchString = hierarchy + "%";
        LoanMapper loanMapper = new LoanMapper(this.sqlGenerator, this.delinquencyReadPlatformService);
        StringBuilder sqlBuilder = new StringBuilder(200);
        sqlBuilder.append("select " + this.sqlGenerator.calcFoundRows() + " ");
        sqlBuilder.append(loanMapper.loanSchema());
        sqlBuilder.append(" join m_office o on (o.id = c.office_id or o.id = g.office_id) ");
        sqlBuilder.append(" left join m_office transferToOffice on transferToOffice.id = c.transfer_to_office_id ");
        sqlBuilder.append(" where ( o.hierarchy like ? or transferToOffice.hierarchy like ?)");
        int arrayPos = 2;
        ArrayList<Object> extraCriterias = new ArrayList<Object>();
        extraCriterias.add(hierarchySearchString);
        extraCriterias.add(hierarchySearchString);
        if (searchParameters != null) {
            if (StringUtils.isNotBlank((CharSequence)searchParameters.getStatus())) {
                sqlBuilder.append(" and l.loan_status_id = ?");
                extraCriterias.add(Integer.parseInt(searchParameters.getStatus()));
                ++arrayPos;
            }
            if (StringUtils.isNotBlank((CharSequence)searchParameters.getExternalId())) {
                sqlBuilder.append(" and l.external_id = ?");
                extraCriterias.add(searchParameters.getExternalId());
                ++arrayPos;
            }
            if (searchParameters.getOfficeId() != null) {
                sqlBuilder.append("and c.office_id =?");
                extraCriterias.add(searchParameters.getOfficeId());
                ++arrayPos;
            }
            if (StringUtils.isNotBlank((CharSequence)searchParameters.getAccountNo())) {
                sqlBuilder.append(" and l.account_no = ?");
                extraCriterias.add(searchParameters.getAccountNo());
                ++arrayPos;
            }
            if (searchParameters.getClientId() != null) {
                sqlBuilder.append(" and l.client_id = ?");
                extraCriterias.add(searchParameters.getClientId());
                ++arrayPos;
            }
            if (searchParameters.hasOrderBy()) {
                sqlBuilder.append(" order by ").append(searchParameters.getOrderBy());
                this.columnValidator.validateSqlInjection(sqlBuilder.toString(), new String[]{searchParameters.getOrderBy()});
                if (searchParameters.hasSortOrder()) {
                    sqlBuilder.append(' ').append(searchParameters.getSortOrder());
                    this.columnValidator.validateSqlInjection(sqlBuilder.toString(), new String[]{searchParameters.getSortOrder()});
                }
            }
            if (searchParameters.hasLimit()) {
                sqlBuilder.append(" ");
                if (searchParameters.hasOffset()) {
                    sqlBuilder.append(this.sqlGenerator.limit(searchParameters.getLimit().intValue(), searchParameters.getOffset().intValue()));
                } else {
                    sqlBuilder.append(this.sqlGenerator.limit(searchParameters.getLimit().intValue()));
                }
            }
        }
        Object[] objectArray = extraCriterias.toArray();
        Object[] finalObjectArray = Arrays.copyOf(objectArray, arrayPos);
        return this.paginationHelper.fetchPage(this.jdbcTemplate, sqlBuilder.toString(), finalObjectArray, (RowMapper)loanMapper);
    }

    public LoanAccountData retrieveTemplateWithClientAndProductDetails(Long clientId, Long productId) {
        this.context.authenticatedUser();
        ClientData clientAccount = this.clientReadPlatformService.retrieveOne(clientId);
        LocalDate expectedDisbursementDate = DateUtils.getBusinessLocalDate();
        LoanAccountData loanDetails = new LoanAccountData().withClientData(clientAccount).setExpectedDisbursementDate(expectedDisbursementDate);
        if (productId != null) {
            LoanProductData selectedProduct = this.loanProductReadPlatformService.retrieveLoanProduct(productId);
            loanDetails = loanDetails.withProductData(selectedProduct, null);
        }
        return loanDetails;
    }

    public LoanAccountData retrieveTemplateWithGroupAndProductDetails(Long groupId, Long productId) {
        this.context.authenticatedUser();
        GroupGeneralData groupAccount = this.groupReadPlatformService.retrieveOne(groupId);
        LocalDate expectedDisbursementDate = DateUtils.getBusinessLocalDate();
        LoanAccountData loanDetails = new LoanAccountData().setGroup(groupAccount).withExpectedDisbursementDate(expectedDisbursementDate);
        if (productId != null) {
            LoanProductData selectedProduct = this.loanProductReadPlatformService.retrieveLoanProduct(productId);
            loanDetails = loanDetails.withProductData(selectedProduct, null);
        }
        return loanDetails;
    }

    public LoanAccountData retrieveTemplateWithCompleteGroupAndProductDetails(Long groupId, Long productId) {
        this.context.authenticatedUser();
        GroupGeneralData groupAccount = this.groupReadPlatformService.retrieveOne(groupId);
        Collection membersOfGroup = this.clientReadPlatformService.retrieveClientMembersOfGroup(groupId);
        if (!CollectionUtils.isEmpty((Collection)membersOfGroup)) {
            Collection activeClientMembers = null;
            Collection calendarsData = null;
            CalendarData collectionMeetingCalendar = null;
            Collection groupRoles = null;
            groupAccount = GroupGeneralData.withAssocations((GroupGeneralData)groupAccount, (Collection)membersOfGroup, activeClientMembers, groupRoles, calendarsData, collectionMeetingCalendar);
        }
        LocalDate expectedDisbursementDate = DateUtils.getBusinessLocalDate();
        LoanAccountData loanDetails = new LoanAccountData().setGroup(groupAccount).withExpectedDisbursementDate(expectedDisbursementDate);
        if (productId != null) {
            LoanProductData selectedProduct = this.loanProductReadPlatformService.retrieveLoanProduct(productId);
            loanDetails = loanDetails.withProductData(selectedProduct, null);
        }
        return loanDetails;
    }

    private CurrencyData retriveLoanCurrencyData(Long loanId) {
        LoanCurrencyDataMapper loanCurrencyMapper = new LoanCurrencyDataMapper(this.sqlGenerator);
        String sql = "select " + loanCurrencyMapper.schema() + " where l.id = ?";
        return (CurrencyData)this.jdbcTemplate.queryForObject(sql, (RowMapper)loanCurrencyMapper, new Object[]{loanId});
    }

    public LoanTransactionData retrieveLoanTransactionTemplate(Long loanId, LoanTransactionType transactionType, Long transactionId) {
        LoanTransactionData loanTransactionData = null;
        List paymentOptions = null;
        List classificationOptions = null;
        BigDecimal transactionAmount = BigDecimal.ZERO;
        switch (1.$SwitchMap$org$apache$fineract$portfolio$loanaccount$domain$LoanTransactionType[transactionType.ordinal()]) {
            case 1: {
                Loan loan = this.loanRepositoryWrapper.findOneWithNotFoundDetection(loanId);
                BigDecimal capitalizedIncomeBalance = BigDecimal.ZERO;
                if (loan.getLoanProduct().getLoanProductRelatedDetail().isEnableIncomeCapitalization()) {
                    capitalizedIncomeBalance = this.loanCapitalizedIncomeBalanceRepository.findAllByLoanIdAndDeletedFalseAndClosedFalse(loanId).stream().map(LoanCapitalizedIncomeBalance::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                }
                transactionAmount = loan.getLoanProduct().isAllowApprovedDisbursedAmountsOverApplied() ? this.loanMaximumAmountCalculator.getOverAppliedMax(loan) : loan.getApprovedPrincipal();
                transactionAmount = transactionAmount.subtract(loan.getDisbursedAmount()).subtract(capitalizedIncomeBalance);
                paymentOptions = this.paymentTypeReadPlatformService.retrieveAllPaymentTypes();
                classificationOptions = this.codeValueReadPlatformService.retrieveCodeValuesByCode("capitalized_income_transaction_classification");
                loanTransactionData = LoanTransactionData.loanTransactionDataForCreditTemplate((LoanTransactionEnumData)LoanEnumerations.transactionType((LoanTransactionType)transactionType), (LocalDate)DateUtils.getBusinessLocalDate(), (BigDecimal)transactionAmount, (Collection)paymentOptions, (CurrencyData)this.retriveLoanCurrencyData(loanId), (List)classificationOptions);
                break;
            }
            case 2: {
                paymentOptions = this.paymentTypeReadPlatformService.retrieveAllPaymentTypes();
                classificationOptions = this.codeValueReadPlatformService.retrieveCodeValuesByCode("buydown_fee_transaction_classification");
                loanTransactionData = LoanTransactionData.loanTransactionDataForCreditTemplate((LoanTransactionEnumData)LoanEnumerations.transactionType((LoanTransactionType)transactionType), (LocalDate)DateUtils.getBusinessLocalDate(), (BigDecimal)transactionAmount, (Collection)paymentOptions, (CurrencyData)this.retriveLoanCurrencyData(loanId), (List)classificationOptions);
                break;
            }
            case 3: {
                LoanCapitalizedIncomeBalance loanCapitalizedIncomeBalance = this.loanCapitalizedIncomeBalanceRepository.findByLoanIdAndLoanTransactionIdAndDeletedFalseAndClosedFalse(loanId, transactionId);
                transactionAmount = loanCapitalizedIncomeBalance == null ? BigDecimal.ZERO : loanCapitalizedIncomeBalance.getAmount().subtract(MathUtil.nullToZero((BigDecimal)loanCapitalizedIncomeBalance.getAmountAdjustment()));
                loanTransactionData = LoanTransactionData.loanTransactionDataForCreditTemplate((LoanTransactionEnumData)LoanEnumerations.transactionType((LoanTransactionType)transactionType), (LocalDate)DateUtils.getBusinessLocalDate(), (BigDecimal)transactionAmount, (Collection)paymentOptions, (CurrencyData)this.retriveLoanCurrencyData(loanId), (List)classificationOptions);
                break;
            }
            case 4: {
                LoanBuyDownFeeBalance loanBuyDownFeeBalance = this.loanBuyDownFeeBalanceRepository.findByLoanIdAndLoanTransactionIdAndDeletedFalseAndClosedFalse(loanId, transactionId);
                transactionAmount = loanBuyDownFeeBalance == null ? BigDecimal.ZERO : loanBuyDownFeeBalance.getAmount().subtract(MathUtil.nullToZero((BigDecimal)loanBuyDownFeeBalance.getAmountAdjustment()));
                loanTransactionData = LoanTransactionData.loanTransactionDataForCreditTemplate((LoanTransactionEnumData)LoanEnumerations.transactionType((LoanTransactionType)transactionType), (LocalDate)DateUtils.getBusinessLocalDate(), (BigDecimal)transactionAmount, (Collection)paymentOptions, (CurrencyData)this.retriveLoanCurrencyData(loanId), (List)classificationOptions);
                break;
            }
            default: {
                loanTransactionData = LoanTransactionData.templateOnTop((LoanTransactionData)this.retrieveLoanTransactionTemplate(loanId), (LoanTransactionEnumData)LoanEnumerations.transactionType((LoanTransactionType)transactionType));
            }
        }
        return loanTransactionData;
    }

    public LoanTransactionData retrieveLoanTransactionTemplate(Long loanId) {
        this.context.authenticatedUser();
        RepaymentTransactionTemplateMapper mapper = new RepaymentTransactionTemplateMapper(this.sqlGenerator);
        String sql = "select " + mapper.schema();
        LoanTransactionData loanTransactionData = (LoanTransactionData)this.jdbcTemplate.queryForObject(sql, (RowMapper)mapper, new Object[]{LoanTransactionType.REPAYMENT.getValue(), LoanTransactionType.DOWN_PAYMENT.getValue(), LoanTransactionType.REPAYMENT.getValue(), LoanTransactionType.DOWN_PAYMENT.getValue(), loanId, loanId});
        List paymentOptions = this.paymentTypeReadPlatformService.retrieveAllPaymentTypes();
        return LoanTransactionData.templateOnTop((LoanTransactionData)loanTransactionData, (Collection)paymentOptions);
    }

    public LoanTransactionData retrieveLoanPrePaymentTemplate(LoanTransactionType repaymentTransactionType, Long loanId, LocalDate onDate) {
        this.context.authenticatedUser();
        this.loanUtilService.validateRepaymentTransactionType(repaymentTransactionType);
        Loan loan = this.loanRepositoryWrapper.findOneWithNotFoundDetection(loanId, true);
        MonetaryCurrency currency = loan.getCurrency();
        ApplicationCurrency applicationCurrency = this.applicationCurrencyRepository.findOneWithNotFoundDetection(currency);
        CurrencyData currencyData = applicationCurrency.toData();
        LocalDate earliestUnpaidInstallmentDate = DateUtils.getBusinessLocalDate();
        LocalDate recalculateFrom = null;
        ScheduleGeneratorDTO scheduleGeneratorDTO = this.loanUtilService.buildScheduleGeneratorDTO(loan, recalculateFrom);
        OutstandingAmountsDTO outstandingAmounts = this.loadTransactionProcessingService.fetchPrepaymentDetail(scheduleGeneratorDTO, onDate, loan);
        LoanTransactionEnumData transactionType = LoanEnumerations.transactionType((LoanTransactionType)repaymentTransactionType);
        List paymentOptions = this.paymentTypeReadPlatformService.retrieveAllPaymentTypes();
        BigDecimal outstandingLoanBalance = outstandingAmounts.principal().getAmount();
        BigDecimal unrecognizedIncomePortion = null;
        BigDecimal adjustedChargeAmount = this.adjustPrepayInstallmentCharge(loan, onDate);
        BigDecimal totalAdjusted = outstandingAmounts.getTotalOutstanding().getAmount().subtract(adjustedChargeAmount);
        return LoanTransactionData.builder().type(transactionType).currency(currencyData).date(earliestUnpaidInstallmentDate).amount(totalAdjusted).netDisbursalAmount(loan.getNetDisbursalAmount()).principalPortion(outstandingAmounts.principal().getAmount()).interestPortion(outstandingAmounts.interest().getAmount()).feeChargesPortion(outstandingAmounts.feeCharges().getAmount().subtract(adjustedChargeAmount)).penaltyChargesPortion(outstandingAmounts.penaltyCharges().getAmount()).unrecognizedIncomePortion(unrecognizedIncomePortion).paymentTypeOptions((Collection)paymentOptions).externalId(ExternalId.empty()).outstandingLoanBalance(outstandingLoanBalance).manuallyReversed(false).loanId(loanId).externalLoanId(loan.getExternalId()).build();
    }

    private BigDecimal adjustPrepayInstallmentCharge(Loan loan, LocalDate onDate) {
        BigDecimal chargeAmount = BigDecimal.ZERO;
        return chargeAmount;
    }

    public LoanTransactionData retrieveWaiveInterestDetails(Long loanId) {
        Loan loan = this.loanRepositoryWrapper.findOneWithNotFoundDetection(loanId, true);
        MonetaryCurrency currency = loan.getCurrency();
        ApplicationCurrency applicationCurrency = this.applicationCurrencyRepository.findOneWithNotFoundDetection(currency);
        CurrencyData currencyData = applicationCurrency.toData();
        LoanTransaction waiveOfInterest = this.deriveDefaultInterestWaiverTransaction(loan);
        LoanTransactionEnumData transactionType = LoanEnumerations.transactionType((LoanTransactionType)LoanTransactionType.WAIVE_INTEREST);
        BigDecimal amount = waiveOfInterest.getAmount(currency).getAmount();
        BigDecimal outstandingLoanBalance = null;
        BigDecimal unrecognizedIncomePortion = null;
        return LoanTransactionData.builder().type(transactionType).currency(currencyData).date(waiveOfInterest.getTransactionDate()).amount(amount).netDisbursalAmount(loan.getNetDisbursalAmount()).outstandingLoanBalance(outstandingLoanBalance).unrecognizedIncomePortion(unrecognizedIncomePortion).externalId(ExternalId.empty()).manuallyReversed(false).loanId(loanId).externalLoanId(loan.getExternalId()).build();
    }

    public LoanTransactionData retrieveNewClosureDetails() {
        this.context.authenticatedUser();
        BigDecimal outstandingLoanBalance = null;
        LoanTransactionEnumData transactionType = LoanEnumerations.transactionType((LoanTransactionType)LoanTransactionType.WRITEOFF);
        BigDecimal unrecognizedIncomePortion = null;
        return LoanTransactionData.builder().type(transactionType).date(DateUtils.getBusinessLocalDate()).externalId(ExternalId.empty()).outstandingLoanBalance(outstandingLoanBalance).unrecognizedIncomePortion(unrecognizedIncomePortion).manuallyReversed(false).build();
    }

    public LoanApprovalData retrieveApprovalTemplate(Long loanId) {
        Loan loan = this.loanRepositoryWrapper.findOneWithNotFoundDetection(loanId, true);
        ApplicationCurrency appCurrency = this.applicationCurrencyRepository.findOneWithNotFoundDetection(loan.getCurrency());
        BigDecimal availableDisbursementAmountWithOverApplied = this.delinquencyReadPlatformService.calculateAvailableDisbursementAmountWithOverApplied(loan);
        return new LoanApprovalData(loan.getProposedPrincipal(), DateUtils.getBusinessLocalDate(), loan.getNetDisbursalAmount(), appCurrency.toData(), availableDisbursementAmountWithOverApplied);
    }

    public LoanTransactionData retrieveDisbursalTemplate(Long loanId, boolean paymentDetailsRequired) {
        Loan loan = this.loanRepositoryWrapper.findOneWithNotFoundDetection(loanId, true);
        LoanTransactionEnumData transactionType = LoanEnumerations.transactionType((LoanTransactionType)LoanTransactionType.DISBURSEMENT);
        List paymentOptions = null;
        if (paymentDetailsRequired) {
            paymentOptions = this.paymentTypeReadPlatformService.retrieveAllPaymentTypes();
        }
        ApplicationCurrency appCurrency = this.applicationCurrencyRepository.findOneWithNotFoundDetection(loan.getCurrency());
        BigDecimal availableDisbursementAmountWithOverApplied = this.delinquencyReadPlatformService.calculateAvailableDisbursementAmountWithOverApplied(loan);
        return LoanTransactionData.loanTransactionDataForDisbursalTemplate((LoanTransactionEnumData)transactionType, (LocalDate)loan.getExpectedDisbursedOnLocalDateForTemplate(), (BigDecimal)loan.getDisburseAmountForTemplate(), (BigDecimal)loan.getNetDisbursalAmount(), (Collection)paymentOptions, (BigDecimal)loan.retriveLastEmiAmount(), (LocalDate)loan.getNextPossibleRepaymentDateForRescheduling(), (CurrencyData)appCurrency.toData(), (BigDecimal)availableDisbursementAmountWithOverApplied);
    }

    public Integer retrieveNumberOfRepayments(Long loanId) {
        this.context.authenticatedUser();
        return this.loanRepositoryWrapper.getNumberOfRepayments(loanId);
    }

    public List<LoanRepaymentScheduleInstallmentData> getRepaymentDataResponse(Long loanId) {
        this.context.authenticatedUser();
        List loanRepaymentScheduleInstallments = this.loanRepositoryWrapper.getLoanRepaymentScheduleInstallments(loanId);
        ArrayList<LoanRepaymentScheduleInstallmentData> loanRepaymentScheduleInstallmentData = new ArrayList<LoanRepaymentScheduleInstallmentData>();
        for (LoanRepaymentScheduleInstallment loanRepaymentScheduleInstallment : loanRepaymentScheduleInstallments) {
            loanRepaymentScheduleInstallmentData.add(LoanRepaymentScheduleInstallmentData.instanceOf((Long)((Long)loanRepaymentScheduleInstallment.getId()), (Integer)loanRepaymentScheduleInstallment.getInstallmentNumber(), (LocalDate)loanRepaymentScheduleInstallment.getDueDate(), (BigDecimal)loanRepaymentScheduleInstallment.getTotalOutstanding(loanRepaymentScheduleInstallment.getLoan().getCurrency()).getAmount()));
        }
        return loanRepaymentScheduleInstallmentData;
    }

    public LoanTransactionData retrieveLoanTransaction(Long loanId, Long transactionId) {
        this.context.authenticatedUser();
        try {
            LoanTransactionsMapper rm = new LoanTransactionsMapper(this.sqlGenerator);
            String sql = "select " + rm.loanPaymentsSchema() + " where l.id = ? and tr.id = ? ";
            LoanTransactionData loanTransactionData = (LoanTransactionData)this.jdbcTemplate.queryForObject(sql, (RowMapper)rm, new Object[]{loanId, transactionId});
            loanTransactionData.setTransactionRelations(this.loanTransactionRelationReadService.fetchLoanTransactionRelationDataFrom(loanTransactionData.getId()));
            return loanTransactionData;
        }
        catch (EmptyResultDataAccessException e) {
            throw new LoanTransactionNotFoundException(transactionId, e);
        }
    }

    public Page<LoanTransactionData> retrieveLoanTransactions(@NotNull Long loanId, Set<LoanTransactionType> excludedTransactionTypes, Pageable pageable) {
        Page transactionPage = this.loanTransactionRepository.findAll((Specification & Serializable)(root, query, builder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            Join loanjoin = root.join("loan");
            predicates.add(builder.equal((Expression)loanjoin.get("id"), (Object)loanId));
            if (excludedTransactionTypes != null && !excludedTransactionTypes.isEmpty()) {
                List excludedTransactionTypeValues = excludedTransactionTypes.stream().toList();
                predicates.add(builder.not((Expression)root.get("typeOf").in(excludedTransactionTypeValues)));
            }
            return builder.and(predicates.toArray(new Predicate[0]));
        }, pageable);
        return transactionPage.map(arg_0 -> ((LoanTransactionMapper)this.loanTransactionMapper).mapLoanTransaction(arg_0));
    }

    public Long getLoanIdByLoanExternalId(String externalId) {
        ExternalId loanExternalId = ExternalIdFactory.produce((String)externalId);
        Long loanId = this.loanRepositoryWrapper.findIdByExternalId(loanExternalId);
        if (Objects.isNull(loanId)) {
            throw new LoanNotFoundException(loanExternalId);
        }
        return loanId;
    }

    public LoanAccountData retrieveLoanProductDetailsTemplate(Long productId, Long clientId, Long groupId) {
        this.context.authenticatedUser();
        LoanProductData loanProduct = this.loanProductReadPlatformService.retrieveLoanProduct(productId);
        List loanTermFrequencyTypeOptions = this.loanDropdownReadPlatformService.retrieveLoanTermFrequencyTypeOptions();
        List repaymentFrequencyTypeOptions = this.loanDropdownReadPlatformService.retrieveRepaymentFrequencyTypeOptions();
        List repaymentFrequencyNthDayTypeOptions = this.loanDropdownReadPlatformService.retrieveRepaymentFrequencyOptionsForNthDayOfMonth();
        List repaymentFrequencyDaysOfWeekTypeOptions = this.loanDropdownReadPlatformService.retrieveRepaymentFrequencyOptionsForDaysOfWeek();
        List interestRateFrequencyTypeOptions = this.loanDropdownReadPlatformService.retrieveInterestRateFrequencyTypeOptions();
        List amortizationTypeOptions = this.loanDropdownReadPlatformService.retrieveLoanAmortizationTypeOptions();
        List interestTypeOptions = null;
        interestTypeOptions = loanProduct.isLinkedToFloatingInterestRates() ? List.of(LoanEnumerations.interestType((InterestMethod)InterestMethod.DECLINING_BALANCE)) : this.loanDropdownReadPlatformService.retrieveLoanInterestTypeOptions();
        List interestCalculationPeriodTypeOptions = this.loanDropdownReadPlatformService.retrieveLoanInterestRateCalculatedInPeriodOptions();
        List fundOptions = this.fundReadPlatformService.retrieveAllFunds();
        Collection repaymentStrategyOptions = this.loanDropdownReadPlatformService.retrieveTransactionProcessingStrategies();
        List loanPurposeOptions = this.codeValueReadPlatformService.retrieveCodeValuesByCode("LoanPurpose");
        List loanCollateralOptions = this.codeValueReadPlatformService.retrieveCodeValuesByCode("LoanCollateral");
        List chargeOptions = null;
        chargeOptions = loanProduct.getMultiDisburseLoan() != false ? this.chargeReadPlatformService.retrieveLoanProductApplicableCharges(productId, new ChargeTimeType[]{ChargeTimeType.OVERDUE_INSTALLMENT}) : this.chargeReadPlatformService.retrieveLoanProductApplicableCharges(productId, new ChargeTimeType[]{ChargeTimeType.OVERDUE_INSTALLMENT, ChargeTimeType.TRANCHE_DISBURSEMENT});
        Integer loanCycleCounter = null;
        if (loanProduct.isUseBorrowerCycle()) {
            loanCycleCounter = clientId == null ? this.retriveLoanCounter(groupId, AccountType.GROUP.getValue(), loanProduct.getId()) : this.retriveLoanCounter(clientId, loanProduct.getId());
        }
        Collection activeLoanOptions = null;
        if (loanProduct.isCanUseForTopup() && clientId != null) {
            activeLoanOptions = this.accountDetailsReadPlatformService.retrieveClientActiveLoanAccountSummary(clientId);
        } else if (loanProduct.isCanUseForTopup() && groupId != null) {
            activeLoanOptions = this.accountDetailsReadPlatformService.retrieveGroupActiveLoanAccountSummary(groupId);
        }
        return new LoanAccountData().withProductData(loanProduct, loanCycleCounter).setTermFrequencyTypeOptions((Collection)loanTermFrequencyTypeOptions).setRepaymentFrequencyTypeOptions((Collection)repaymentFrequencyTypeOptions).setRepaymentFrequencyNthDayTypeOptions((Collection)repaymentFrequencyNthDayTypeOptions).setRepaymentFrequencyDaysOfWeekTypeOptions((Collection)repaymentFrequencyDaysOfWeekTypeOptions).setTransactionProcessingStrategyOptions(repaymentStrategyOptions).setInterestRateFrequencyTypeOptions((Collection)interestRateFrequencyTypeOptions).setAmortizationTypeOptions((Collection)amortizationTypeOptions).setInterestTypeOptions((Collection)interestTypeOptions).setInterestCalculationPeriodTypeOptions((Collection)interestCalculationPeriodTypeOptions).setFundOptions((Collection)fundOptions).setChargeOptions((Collection)chargeOptions).setLoanPurposeOptions((Collection)loanPurposeOptions).setLoanCollateralOptions((Collection)loanCollateralOptions).setClientActiveLoanOptions(activeLoanOptions).setLoanScheduleTypeOptions(LoanScheduleType.getValuesAsEnumOptionDataList()).setLoanScheduleProcessingTypeOptions(LoanScheduleProcessingType.getValuesAsEnumOptionDataList());
    }

    public Collection<CalendarData> retrieveCalendars(Long groupId) {
        ArrayList<CalendarData> calendarsData = new ArrayList();
        calendarsData.addAll(this.calendarReadPlatformService.retrieveParentCalendarsByEntity(groupId, CalendarEntityType.GROUPS.getValue(), null));
        calendarsData.addAll(this.calendarReadPlatformService.retrieveCalendarsByEntity(groupId, CalendarEntityType.GROUPS.getValue(), null));
        calendarsData = this.calendarReadPlatformService.updateWithRecurringDates(calendarsData);
        return calendarsData;
    }

    public Collection<StaffData> retrieveAllowedLoanOfficers(Long selectedOfficeId, boolean staffInSelectedOfficeOnly) {
        if (selectedOfficeId == null) {
            return null;
        }
        List allowedLoanOfficers = null;
        if (staffInSelectedOfficeOnly) {
            allowedLoanOfficers = this.staffReadPlatformService.retrieveAllLoanOfficersInOfficeById(selectedOfficeId);
        } else {
            boolean restrictToLoanOfficersOnly = true;
            allowedLoanOfficers = this.staffReadPlatformService.retrieveAllStaffInOfficeAndItsParentOfficeHierarchy(selectedOfficeId, true);
        }
        return allowedLoanOfficers;
    }

    public Collection<OverdueLoanScheduleData> retrieveAllLoansWithOverdueInstallments(Long penaltyWaitPeriod, Boolean backdatePenalties) {
        MusoniOverdueLoanScheduleMapper rm = new MusoniOverdueLoanScheduleMapper();
        StringBuilder sqlBuilder = new StringBuilder(400);
        sqlBuilder.append("select ").append(rm.schema()).append(" where " + this.sqlGenerator.subDate(this.sqlGenerator.currentBusinessDate(), "?", "day") + " > ls.duedate ").append(" and ls.completed_derived <> true and mc.charge_applies_to_enum =1 ").append(" and ls.recalculated_interest_component <> true ").append(" and mc.charge_time_enum = 9 and ml.loan_status_id = 300 ");
        if (backdatePenalties.booleanValue()) {
            return this.jdbcTemplate.query(sqlBuilder.toString(), (RowMapper)rm, new Object[]{penaltyWaitPeriod});
        }
        sqlBuilder.append(" and ls.duedate >= " + this.sqlGenerator.subDate(this.sqlGenerator.currentBusinessDate(), "(? + 1)", "day"));
        return this.jdbcTemplate.query(sqlBuilder.toString(), (RowMapper)rm, new Object[]{penaltyWaitPeriod, penaltyWaitPeriod});
    }

    public Collection<OverdueLoanScheduleData> retrieveAllOverdueInstallmentsForLoan(Loan loan) {
        ArrayList<OverdueLoanScheduleData> list = new ArrayList<OverdueLoanScheduleData>();
        if (!loan.isOpen()) {
            return list;
        }
        Optional<Charge> optPenaltyCharge = loan.getLoanProduct().getCharges().stream().filter(e -> ChargeTimeType.OVERDUE_INSTALLMENT.getValue().equals(e.getChargeTimeType()) && e.isLoanCharge()).findFirst();
        if (optPenaltyCharge.isEmpty()) {
            return list;
        }
        Charge penaltyCharge = optPenaltyCharge.get();
        Long penaltyWaitPeriod = this.configurationDomainService.retrievePenaltyWaitPeriod();
        boolean backdatePenalties = this.configurationDomainService.isBackdatePenaltiesEnabled();
        for (LoanRepaymentScheduleInstallment installment : loan.getRepaymentScheduleInstallments()) {
            if (installment.isObligationsMet() || installment.isRecalculatedInterestComponent()) continue;
            boolean isPenaltyDue = installment.isOverdueOn(DateUtils.getBusinessLocalDate().minusDays(penaltyWaitPeriod).plusDays(1L));
            boolean isDueToday = installment.getDueDate().equals(DateUtils.getBusinessLocalDate().minusDays(penaltyWaitPeriod));
            if (!isPenaltyDue || !backdatePenalties && !isDueToday) continue;
            list.add(new OverdueLoanScheduleData((Long)loan.getId(), (Long)penaltyCharge.getId(), DateUtils.DEFAULT_DATE_FORMATTER.format(installment.getDueDate()), penaltyCharge.getAmount(), "yyyy-MM-dd", Locale.ENGLISH.toLanguageTag(), installment.getPrincipalOutstanding(loan.getCurrency()).getAmount(), installment.getInterestOutstanding(loan.getCurrency()).getAmount(), installment.getInstallmentNumber()));
        }
        return list;
    }

    public Integer retriveLoanCounter(Long groupId, Integer loanType, Long productId) {
        String sql = "Select MAX(l.loan_product_counter) from m_loan l where l.group_id = ?  and l.loan_type_enum = ? and l.product_id=?";
        return (Integer)this.jdbcTemplate.queryForObject("Select MAX(l.loan_product_counter) from m_loan l where l.group_id = ?  and l.loan_type_enum = ? and l.product_id=?", new Object[]{groupId, loanType, productId}, Integer.class);
    }

    public Integer retriveLoanCounter(Long clientId, Long productId) {
        String sql = "Select MAX(l.loan_product_counter) from m_loan l where l.client_id = ? and l.product_id=?";
        return (Integer)this.jdbcTemplate.queryForObject("Select MAX(l.loan_product_counter) from m_loan l where l.client_id = ? and l.product_id=?", new Object[]{clientId, productId}, Integer.class);
    }

    public Collection<DisbursementData> retrieveLoanDisbursementDetails(Long loanId) {
        return this.retrieveLoanDisbursementDetails(List.of(loanId)).getOrDefault(loanId, Collections.emptyList());
    }

    public Map<Long, List<DisbursementData>> retrieveLoanDisbursementDetails(List<Long> loanIds) {
        Object[] parameters = this.sqlGenerator.inParametersFor(loanIds);
        LoanDisbursementDetailMapper rm = new LoanDisbursementDetailMapper(this.sqlGenerator);
        String sql = "select " + rm.schema() + " where " + this.sqlGenerator.in("dd.loan_id", loanIds) + " and dd.is_reversed=false group by dd.id, lc.amount_waived_derived order by dd.expected_disburse_date,dd.disbursedon_date,dd.id";
        return this.jdbcTemplate.query(sql, (RowMapper)rm, parameters).stream().collect(Collectors.groupingBy(DisbursementData::getLoanId));
    }

    public DisbursementData retrieveLoanDisbursementDetail(Long loanId, Long disbursementId) {
        LoanDisbursementDetailMapper rm = new LoanDisbursementDetailMapper(this.sqlGenerator);
        String sql = "select " + rm.schema() + " where dd.loan_id=? and dd.id=? group by dd.id, lc.amount_waived_derived";
        return (DisbursementData)this.jdbcTemplate.queryForObject(sql, (RowMapper)rm, new Object[]{loanId, disbursementId});
    }

    public LoanTransactionData retrieveRecoveryPaymentTemplate(Long loanId) {
        Loan loan = this.loanRepositoryWrapper.findOneWithNotFoundDetection(loanId, true);
        LoanTransactionEnumData transactionType = LoanEnumerations.transactionType((LoanTransactionType)LoanTransactionType.RECOVERY_REPAYMENT);
        List paymentOptions = this.paymentTypeReadPlatformService.retrieveAllPaymentTypes();
        BigDecimal outstandingLoanBalance = null;
        BigDecimal unrecognizedIncomePortion = null;
        return LoanTransactionData.builder().type(transactionType).amount(loan.getTotalWrittenOff()).netDisbursalAmount(loan.getNetDisbursalAmount()).unrecognizedIncomePortion(unrecognizedIncomePortion).paymentTypeOptions((Collection)paymentOptions).externalId(ExternalId.empty()).outstandingLoanBalance(outstandingLoanBalance).manuallyReversed(false).loanId(loanId).externalLoanId(loan.getExternalId()).build();
    }

    public LoanTransactionData retrieveLoanWriteoffTemplate(Long loanId) {
        LoanAccountData loan = this.retrieveOne(loanId);
        LoanTransactionEnumData transactionType = LoanEnumerations.transactionType((LoanTransactionType)LoanTransactionType.WRITEOFF);
        BigDecimal totalOutstanding = loan.getSummary() != null ? loan.getSummary().getTotalOutstanding() : null;
        ArrayList writeOffReasonOptions = new ArrayList(this.codeValueReadPlatformService.retrieveCodeValuesByCode("WriteOffReasons"));
        LoanTransactionData loanTransactionData = LoanTransactionData.builder().type(transactionType).currency(loan.getCurrency()).date(DateUtils.getBusinessLocalDate()).amount(totalOutstanding).netDisbursalAmount(loan.getNetDisbursalAmount()).externalId(ExternalId.empty()).manuallyReversed(false).loanId(loanId).externalLoanId(loan.getExternalId()).writeOffReasonOptions(writeOffReasonOptions).build();
        return loanTransactionData;
    }

    public LoanTransactionData retrieveLoanChargeOffTemplate(Long loanId) {
        LoanAccountData loan = this.retrieveOne(loanId);
        LoanTransactionEnumData transactionType = LoanEnumerations.transactionType((LoanTransactionType)LoanTransactionType.CHARGE_OFF);
        BigDecimal totalOutstanding = loan.getSummary() != null ? loan.getSummary().getTotalOutstanding() : null;
        BigDecimal totalPrincipalOutstanding = loan.getSummary() != null ? loan.getSummary().getPrincipalOutstanding() : null;
        BigDecimal totalInterestOutstanding = loan.getSummary() != null ? loan.getSummary().getInterestOutstanding() : null;
        BigDecimal totalFeeOutstanding = loan.getSummary() != null ? loan.getSummary().getFeeChargesOutstanding() : null;
        BigDecimal totalPenaltyOutstanding = loan.getSummary() != null ? loan.getSummary().getPenaltyChargesOutstanding() : null;
        ArrayList chargeOffReasonOptions = new ArrayList(this.codeValueReadPlatformService.retrieveCodeValuesByCode("ChargeOffReasons"));
        LoanTransactionData loanTransactionData = LoanTransactionData.builder().type(transactionType).currency(loan.getCurrency()).date(DateUtils.getBusinessLocalDate()).amount(totalOutstanding).netDisbursalAmount(loan.getNetDisbursalAmount()).principalPortion(totalPrincipalOutstanding).interestPortion(totalInterestOutstanding).feeChargesPortion(totalFeeOutstanding).penaltyChargesPortion(totalPenaltyOutstanding).externalId(ExternalId.empty()).manuallyReversed(false).loanId(loanId).externalLoanId(loan.getExternalId()).chargeOffReasonOptions(chargeOffReasonOptions).build();
        return loanTransactionData;
    }

    public Collection<Long> fetchLoansForInterestRecalculation() {
        String sql = "SELECT l.id\nFROM m_loan l\nINNER JOIN m_loan_repayment_schedule mr ON mr.loan_id = l.id\nLEFT JOIN m_loan_disbursement_detail dd ON dd.loan_id=l.id AND dd.disbursedon_date IS NULL\n-- for past due interest recalculation\nLEFT JOIN m_loan_recalculation_details rcd ON rcd.loan_id = l.id\n-- For Floating rate changes\nLEFT JOIN m_product_loan_floating_rates pfr\n    ON l.product_id = pfr.loan_product_id AND l.is_floating_interest_rate = TRUE\nLEFT JOIN m_floating_rates fr ON pfr.floating_rates_id = fr.id\nLEFT JOIN m_floating_rates_periods frp ON fr.id = frp.floating_rates_id\nLEFT JOIN m_loan_reschedule_request lrr ON lrr.loan_id = l.id\n-- this is to identify the applicable rates when base rate is changed\nLEFT JOIN m_floating_rates bfr ON bfr.is_base_lending_rate = TRUE\nLEFT JOIN m_floating_rates_periods bfrp ON bfr.id = bfrp.floating_rates_id AND bfrp.created_date >= ?\nWHERE l.loan_status_id = ?\n  AND l.is_npa = FALSE\n  AND l.is_charged_off = FALSE\n  AND dd.is_reversed = FALSE\n  AND (\n        (l.interest_recalculation_enabled = TRUE\n            AND (l.interest_recalcualated_on IS NULL OR l.interest_recalcualated_on <> ?)\n            AND ((mr.completed_derived IS FALSE AND mr.duedate < ?) OR dd.expected_disburse_date < ?)\n            AND rcd.disallow_interest_calc_on_past_due = FALSE)\n       OR\n        -- float rate changes\n        (fr.is_active = TRUE\n            AND frp.is_active = TRUE\n            AND (frp.created_date >= ?\n                 OR (bfrp.id IS NOT NULL\n                     AND frp.is_differential_to_base_lending_rate = TRUE\n                     AND frp.from_date >= bfrp.from_date))\n            AND lrr.loan_id IS NULL)\n  )\nGROUP BY l.id\n";
        try {
            LocalDate currentdate = DateUtils.getBusinessLocalDate();
            LocalDate yesterday = DateUtils.getBusinessLocalDate().minusDays(1L);
            return this.jdbcTemplate.queryForList("SELECT l.id\nFROM m_loan l\nINNER JOIN m_loan_repayment_schedule mr ON mr.loan_id = l.id\nLEFT JOIN m_loan_disbursement_detail dd ON dd.loan_id=l.id AND dd.disbursedon_date IS NULL\n-- for past due interest recalculation\nLEFT JOIN m_loan_recalculation_details rcd ON rcd.loan_id = l.id\n-- For Floating rate changes\nLEFT JOIN m_product_loan_floating_rates pfr\n    ON l.product_id = pfr.loan_product_id AND l.is_floating_interest_rate = TRUE\nLEFT JOIN m_floating_rates fr ON pfr.floating_rates_id = fr.id\nLEFT JOIN m_floating_rates_periods frp ON fr.id = frp.floating_rates_id\nLEFT JOIN m_loan_reschedule_request lrr ON lrr.loan_id = l.id\n-- this is to identify the applicable rates when base rate is changed\nLEFT JOIN m_floating_rates bfr ON bfr.is_base_lending_rate = TRUE\nLEFT JOIN m_floating_rates_periods bfrp ON bfr.id = bfrp.floating_rates_id AND bfrp.created_date >= ?\nWHERE l.loan_status_id = ?\n  AND l.is_npa = FALSE\n  AND l.is_charged_off = FALSE\n  AND dd.is_reversed = FALSE\n  AND (\n        (l.interest_recalculation_enabled = TRUE\n            AND (l.interest_recalcualated_on IS NULL OR l.interest_recalcualated_on <> ?)\n            AND ((mr.completed_derived IS FALSE AND mr.duedate < ?) OR dd.expected_disburse_date < ?)\n            AND rcd.disallow_interest_calc_on_past_due = FALSE)\n       OR\n        -- float rate changes\n        (fr.is_active = TRUE\n            AND frp.is_active = TRUE\n            AND (frp.created_date >= ?\n                 OR (bfrp.id IS NOT NULL\n                     AND frp.is_differential_to_base_lending_rate = TRUE\n                     AND frp.from_date >= bfrp.from_date))\n            AND lrr.loan_id IS NULL)\n  )\nGROUP BY l.id\n", Long.class, new Object[]{yesterday, LoanStatus.ACTIVE.getValue(), currentdate, currentdate, currentdate, yesterday});
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    public List<Long> fetchLoansForInterestRecalculation(Integer pageSize, Long maxLoanIdInList, String officeHierarchy) {
        LocalDate currentdate = DateUtils.getBusinessLocalDate();
        LocalDate yesterday = DateUtils.getBusinessLocalDate().minusDays(1L);
        String sql = "SELECT l.id\nFROM m_loan l\nLEFT JOIN m_client c ON c.id = l.client_id\nLEFT JOIN m_office o ON c.office_id = o.id\nINNER JOIN m_loan_repayment_schedule rps ON rps.loan_id = l.id\nLEFT JOIN m_loan_disbursement_detail dd\n    ON dd.loan_id=l.id AND dd.disbursedon_date IS NULL AND dd.is_reversed = FALSE\n-- for past due interest recalculation\nLEFT JOIN m_loan_recalculation_details rcd ON rcd.loan_id = l.id\n-- For Floating rate changes\nLEFT JOIN m_product_loan_floating_rates pfr\n    ON l.product_id = pfr.loan_product_id AND l.is_floating_interest_rate = TRUE\nLEFT JOIN m_floating_rates fr ON pfr.floating_rates_id = fr.id\nLEFT JOIN m_floating_rates_periods frp ON fr.id = frp.floating_rates_id\nLEFT JOIN m_loan_reschedule_request lrr ON lrr.loan_id = l.id\n-- this is to identify the applicable rates when base rate is changed\nLEFT JOIN m_floating_rates bfr ON bfr.is_base_lending_rate = TRUE\nLEFT JOIN m_floating_rates_periods bfrp ON bfr.id = bfrp.floating_rates_id AND bfrp.created_date >= ?\nWHERE l.loan_status_id = ?\n    AND l.is_npa = FALSE\n    AND l.is_charged_off = FALSE\n    AND (\n         (l.interest_recalculation_enabled = TRUE\n             AND (l.interest_recalcualated_on IS NULL OR l.interest_recalcualated_on <> ?)\n             AND ((rps.completed_derived IS FALSE AND rps.duedate < ?) OR dd.expected_disburse_date < ?)\n             AND rcd.disallow_interest_calc_on_past_due = FALSE)\n        OR\n         (fr.is_active = TRUE\n             AND frp.is_active = TRUE\n             AND (frp.created_date >= ?\n                  OR (bfrp.id IS NOT NULL\n                      AND frp.is_differential_to_base_lending_rate = TRUE\n                      AND frp.from_date >= bfrp.from_date))\n             AND lrr.loan_id IS NULL)\n    )\n    AND l.id >= ?\n    AND o.hierarchy like ?\nGROUP BY l.id\nLIMIT ?\n";
        try {
            return Collections.synchronizedList(this.jdbcTemplate.queryForList("SELECT l.id\nFROM m_loan l\nLEFT JOIN m_client c ON c.id = l.client_id\nLEFT JOIN m_office o ON c.office_id = o.id\nINNER JOIN m_loan_repayment_schedule rps ON rps.loan_id = l.id\nLEFT JOIN m_loan_disbursement_detail dd\n    ON dd.loan_id=l.id AND dd.disbursedon_date IS NULL AND dd.is_reversed = FALSE\n-- for past due interest recalculation\nLEFT JOIN m_loan_recalculation_details rcd ON rcd.loan_id = l.id\n-- For Floating rate changes\nLEFT JOIN m_product_loan_floating_rates pfr\n    ON l.product_id = pfr.loan_product_id AND l.is_floating_interest_rate = TRUE\nLEFT JOIN m_floating_rates fr ON pfr.floating_rates_id = fr.id\nLEFT JOIN m_floating_rates_periods frp ON fr.id = frp.floating_rates_id\nLEFT JOIN m_loan_reschedule_request lrr ON lrr.loan_id = l.id\n-- this is to identify the applicable rates when base rate is changed\nLEFT JOIN m_floating_rates bfr ON bfr.is_base_lending_rate = TRUE\nLEFT JOIN m_floating_rates_periods bfrp ON bfr.id = bfrp.floating_rates_id AND bfrp.created_date >= ?\nWHERE l.loan_status_id = ?\n    AND l.is_npa = FALSE\n    AND l.is_charged_off = FALSE\n    AND (\n         (l.interest_recalculation_enabled = TRUE\n             AND (l.interest_recalcualated_on IS NULL OR l.interest_recalcualated_on <> ?)\n             AND ((rps.completed_derived IS FALSE AND rps.duedate < ?) OR dd.expected_disburse_date < ?)\n             AND rcd.disallow_interest_calc_on_past_due = FALSE)\n        OR\n         (fr.is_active = TRUE\n             AND frp.is_active = TRUE\n             AND (frp.created_date >= ?\n                  OR (bfrp.id IS NOT NULL\n                      AND frp.is_differential_to_base_lending_rate = TRUE\n                      AND frp.from_date >= bfrp.from_date))\n             AND lrr.loan_id IS NULL)\n    )\n    AND l.id >= ?\n    AND o.hierarchy like ?\nGROUP BY l.id\nLIMIT ?\n", Long.class, new Object[]{yesterday, LoanStatus.ACTIVE.getValue(), currentdate, currentdate, currentdate, yesterday, maxLoanIdInList, officeHierarchy, pageSize}));
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    public boolean isGuaranteeRequired(Long loanId) {
        String sql = "select pl.hold_guarantee_funds from m_loan ml inner join m_product_loan pl on pl.id = ml.product_id where ml.id=?";
        return Boolean.TRUE.equals(this.jdbcTemplate.queryForObject("select pl.hold_guarantee_funds from m_loan ml inner join m_product_loan pl on pl.id = ml.product_id where ml.id=?", Boolean.class, new Object[]{loanId}));
    }

    public LocalDate retrieveMinimumDateOfRepaymentTransaction(Long loanId) {
        return (LocalDate)this.jdbcTemplate.queryForObject("select min(transaction_date) from m_loan_transaction where loan_id=? and transaction_type_enum=2", LocalDate.class, new Object[]{loanId});
    }

    public PaidInAdvanceData retrieveTotalPaidInAdvance(Long loanId) {
        try {
            String sql = "  select (SUM(COALESCE(mr.principal_completed_derived, 0)) + SUM(COALESCE(mr.interest_completed_derived, 0))  + SUM(COALESCE(mr.fee_charges_completed_derived, 0))  + SUM(COALESCE(mr.penalty_charges_completed_derived, 0))) as total_in_advance_derived  from m_loan ml INNER JOIN m_loan_repayment_schedule mr on mr.loan_id = ml.id  where ml.id=? and  mr.duedate >= " + this.sqlGenerator.currentBusinessDate() + " group by ml.id having  (SUM(COALESCE(mr.principal_completed_derived, 0))   + SUM(COALESCE(mr.interest_completed_derived, 0))  + SUM(COALESCE(mr.fee_charges_completed_derived, 0)) +  SUM(COALESCE(mr.penalty_charges_completed_derived, 0))) > 0";
            BigDecimal bigDecimal = (BigDecimal)this.jdbcTemplate.queryForObject(sql, BigDecimal.class, new Object[]{loanId});
            return new PaidInAdvanceData(bigDecimal);
        }
        catch (DataAccessException e) {
            return new PaidInAdvanceData(new BigDecimal(0));
        }
    }

    public LoanTransactionData retrieveRefundByCashTemplate(Long loanId) {
        this.context.authenticatedUser();
        List paymentOptions = this.paymentTypeReadPlatformService.retrieveAllPaymentTypes();
        Loan loan = this.loanRepositoryWrapper.findOneWithNotFoundDetection(loanId, true);
        return this.retrieveRefundTemplate(loanId, LoanTransactionType.REFUND_FOR_ACTIVE_LOAN, (Collection)paymentOptions, loan.getCurrency(), this.retrieveTotalPaidInAdvance((Long)loan.getId()).getPaidInAdvance(), loan.getNetDisbursalAmount(), loan.getExternalId());
    }

    public LoanTransactionData retrieveCreditBalanceRefundTemplate(Long loanId) {
        this.context.authenticatedUser();
        Collection paymentOptions = null;
        BigDecimal netDisbursal = null;
        Loan loan = this.loanRepositoryWrapper.findOneWithNotFoundDetection(loanId, true);
        return this.retrieveRefundTemplate(loanId, LoanTransactionType.CREDIT_BALANCE_REFUND, paymentOptions, loan.getCurrency(), loan.getTotalOverpaid(), netDisbursal, loan.getExternalId());
    }

    private LoanTransactionData retrieveRefundTemplate(Long loanId, LoanTransactionType loanTransactionType, Collection<PaymentTypeData> paymentOptions, MonetaryCurrency currency, BigDecimal transactionAmount, BigDecimal netDisbursal, ExternalId externalLoanId) {
        ApplicationCurrency applicationCurrency = this.applicationCurrencyRepository.findOneWithNotFoundDetection(currency);
        CurrencyData currencyData = applicationCurrency.toData();
        LocalDate currentDate = LocalDate.now(DateUtils.getDateTimeZoneOfTenant());
        LoanTransactionEnumData transactionType = LoanEnumerations.transactionType((LoanTransactionType)loanTransactionType);
        return LoanTransactionData.builder().type(transactionType).currency(currencyData).date(currentDate).amount(transactionAmount).netDisbursalAmount(netDisbursal).paymentTypeOptions(paymentOptions).externalId(ExternalId.empty()).manuallyReversed(false).loanId(loanId).externalLoanId(externalLoanId).build();
    }

    public Collection<InterestRatePeriodData> retrieveLoanInterestRatePeriodData(LoanAccountData loanData) {
        this.context.authenticatedUser();
        if (loanData.isLoanProductLinkedToFloatingRate()) {
            ArrayList<InterestRatePeriodData> intRatePeriodData = new ArrayList<InterestRatePeriodData>();
            List intRates = this.floatingRatesReadPlatformService.retrieveInterestRatePeriods(loanData.getLoanProductId());
            for (InterestRatePeriodData rate : intRates) {
                if (loanData.getTimeline() == null) continue;
                boolean isAfterDisbursement = DateUtils.isAfter((LocalDate)rate.getFromDate(), (LocalDate)loanData.getTimeline().getDisbursementDate());
                if (isAfterDisbursement && loanData.isFloatingInterestRate()) {
                    this.updateInterestRatePeriodData(rate, loanData);
                    intRatePeriodData.add(rate);
                    continue;
                }
                if (isAfterDisbursement) continue;
                this.updateInterestRatePeriodData(rate, loanData);
                intRatePeriodData.add(rate);
                break;
            }
            return intRatePeriodData;
        }
        return null;
    }

    private void updateInterestRatePeriodData(InterestRatePeriodData rate, LoanAccountData loan) {
        LoanProductData loanProductData = this.loanProductReadPlatformService.retrieveLoanProductFloatingDetails(loan.getLoanProductId());
        rate.setLoanProductDifferentialInterestRate(loanProductData.getInterestRateDifferential());
        rate.setLoanDifferentialInterestRate(loan.getInterestRateDifferential());
        BigDecimal effectiveInterestRate = BigDecimal.ZERO;
        effectiveInterestRate = effectiveInterestRate.add(rate.getLoanDifferentialInterestRate());
        effectiveInterestRate = effectiveInterestRate.add(rate.getLoanProductDifferentialInterestRate());
        effectiveInterestRate = effectiveInterestRate.add(rate.getInterestRate());
        if (rate.getBlrInterestRate() != null && rate.isDifferentialToBLR()) {
            effectiveInterestRate = effectiveInterestRate.add(rate.getBlrInterestRate());
        }
        rate.setEffectiveInterestRate(effectiveInterestRate);
        if (loan.getTimeline() != null && DateUtils.isBefore((LocalDate)rate.getFromDate(), (LocalDate)loan.getTimeline().getDisbursementDate())) {
            rate.setFromDate(loan.getTimeline().getDisbursementDate());
        }
    }

    public Collection<Long> retrieveLoanIdsWithPendingIncomePostingTransactions() {
        LocalDate currentdate = DateUtils.getBusinessLocalDate();
        StringBuilder sqlBuilder = new StringBuilder().append(" select distinct loan.id from m_loan as loan ").append(" inner join m_loan_recalculation_details as recdet on (recdet.loan_id = loan.id and recdet.is_compounding_to_be_posted_as_transaction is not null and recdet.is_compounding_to_be_posted_as_transaction = true) ").append(" inner join m_loan_repayment_schedule as repsch on repsch.loan_id = loan.id ").append(" inner join m_loan_interest_recalculation_additional_details as adddet on adddet.loan_repayment_schedule_id = repsch.id ").append(" left join m_loan_transaction as trans on (trans.is_reversed <> true and trans.transaction_type_enum = 19 and trans.loan_id = loan.id and trans.transaction_date = adddet.effective_date) ").append(" where loan.loan_status_id = 300 ").append(" and loan.is_npa = false and loan.is_charged_off = false ").append(" and adddet.effective_date is not null ").append(" and trans.transaction_date is null ").append(" and adddet.effective_date < ? ");
        try {
            return this.jdbcTemplate.queryForList(sqlBuilder.toString(), Long.class, new Object[]{currentdate});
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    public LoanTransactionData retrieveLoanForeclosureTemplate(Long loanId, LocalDate transactionDate) {
        this.context.authenticatedUser();
        Loan loan = this.loanRepositoryWrapper.findOneWithNotFoundDetection(loanId, true);
        this.loanForeclosureValidator.validateForForeclosure(loan, transactionDate);
        MonetaryCurrency currency = loan.getCurrency();
        ApplicationCurrency applicationCurrency = this.applicationCurrencyRepository.findOneWithNotFoundDetection(currency);
        CurrencyData currencyData = applicationCurrency.toData();
        LocalDate earliestUnpaidInstallmentDate = DateUtils.getBusinessLocalDate();
        LoanRepaymentScheduleInstallment loanRepaymentScheduleInstallment = this.loanBalanceService.fetchLoanForeclosureDetail(loan, transactionDate);
        BigDecimal unrecognizedIncomePortion = null;
        LoanTransactionEnumData transactionType = LoanEnumerations.transactionType((LoanTransactionType)LoanTransactionType.REPAYMENT);
        List paymentTypeOptions = this.paymentTypeReadPlatformService.retrieveAllPaymentTypes();
        BigDecimal outstandingLoanBalance = loanRepaymentScheduleInstallment.getPrincipalOutstanding(currency).getAmount();
        Boolean isManuallyReversed = false;
        Money outStandingAmount = loanRepaymentScheduleInstallment.getTotalOutstanding(currency);
        return LoanTransactionData.builder().type(transactionType).currency(currencyData).date(earliestUnpaidInstallmentDate).amount(outStandingAmount.getAmount()).netDisbursalAmount(loan.getNetDisbursalAmount()).principalPortion(loanRepaymentScheduleInstallment.getPrincipalOutstanding(currency).getAmount()).interestPortion(loanRepaymentScheduleInstallment.getInterestOutstanding(currency).getAmount()).feeChargesPortion(loanRepaymentScheduleInstallment.getFeeChargesOutstanding(currency).getAmount()).penaltyChargesPortion(loanRepaymentScheduleInstallment.getPenaltyChargesOutstanding(currency).getAmount()).unrecognizedIncomePortion(unrecognizedIncomePortion).paymentTypeOptions((Collection)paymentTypeOptions).externalId(ExternalId.empty()).outstandingLoanBalance(outstandingLoanBalance).manuallyReversed(isManuallyReversed.booleanValue()).loanId(loanId).externalLoanId(loan.getExternalId()).build();
    }

    public Long retrieveLoanIdByAccountNumber(String loanAccountNumber) {
        try {
            return (Long)this.jdbcTemplate.queryForObject("select l.id from m_loan l where l.account_no = ?", Long.class, new Object[]{loanAccountNumber});
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    public String retrieveAccountNumberByAccountId(Long accountId) {
        try {
            String sql = "select loan.account_no from m_loan loan where loan.id = ?";
            return (String)this.jdbcTemplate.queryForObject("select loan.account_no from m_loan loan where loan.id = ?", String.class, new Object[]{accountId});
        }
        catch (EmptyResultDataAccessException e) {
            throw new LoanNotFoundException(accountId, (Exception)((Object)e));
        }
    }

    public Integer retrieveNumberOfActiveLoans() {
        String sql = "select count(*) from m_loan";
        return (Integer)this.jdbcTemplate.queryForObject("select count(*) from m_loan", Integer.class);
    }

    public Long retrieveLoanTransactionIdByExternalId(ExternalId externalId) {
        return this.loanTransactionRepository.findIdByExternalId(externalId);
    }

    public Long retrieveLoanIdByExternalId(ExternalId externalId) {
        return this.loanRepositoryWrapper.findIdByExternalId(externalId);
    }

    public List<Long> retrieveLoanIdsByExternalIds(List<ExternalId> externalIds) {
        return this.loanRepositoryWrapper.findIdByExternalIds(externalIds);
    }

    public boolean existsByLoanId(Long loanId) {
        return this.loanRepositoryWrapper.existsByLoanId(loanId);
    }

    public LoanTransactionData retrieveManualInterestRefundTemplate(Long loanId, Long targetTransactionId) {
        Loan loan = this.loanRepositoryWrapper.findOneWithNotFoundDetection(loanId);
        LoanTransaction targetTxn = loan.getLoanTransaction(txn -> txn.getId() != null && ((Long)txn.getId()).equals(targetTransactionId));
        if (targetTxn == null) {
            throw new LoanTransactionNotFoundException(targetTransactionId);
        }
        if (!targetTxn.isMerchantIssuedRefund() && !targetTxn.isPayoutRefund()) {
            throw new GeneralPlatformDomainRuleException("error.msg.loan.transaction.not.refund.type", "Only for refund transactions", new Object[0]);
        }
        if (targetTxn.isReversed()) {
            throw new GeneralPlatformDomainRuleException("error.msg.loan.transaction.reversed", "Refund transaction is reversed", new Object[0]);
        }
        boolean alreadyExists = loan.getLoanTransactions().stream().anyMatch(txn -> txn.isInterestRefund() && !txn.getLoanTransactionRelations(rel -> rel.getToTransaction() != null && rel.getToTransaction().equals(targetTxn)).isEmpty());
        if (alreadyExists) {
            throw new GeneralPlatformDomainRuleException("error.msg.loan.transaction.interest.refund.already.exists", "Interest Refund already exists for this refund", new Object[0]);
        }
        InterestRefundService interestRefundService = this.interestRefundServiceDelegate.lookupInterestRefundService(loan);
        Money totalInterest = interestRefundService.totalInterestByTransactions(null, (Long)loan.getId(), targetTxn.getTransactionDate(), List.of(), loan.getLoanTransactions().stream().map(AbstractPersistableCustom::getId).toList());
        Money newTotalInterest = interestRefundService.totalInterestByTransactions(null, (Long)loan.getId(), targetTxn.getTransactionDate(), List.of(targetTxn), loan.getLoanTransactions().stream().map(AbstractPersistableCustom::getId).toList());
        BigDecimal interestRefundAmount = totalInterest.minus(newTotalInterest).getAmount();
        List paymentTypeOptions = this.paymentTypeReadPlatformService.retrieveAllPaymentTypes();
        LoanTransactionEnumData transactionType = LoanEnumerations.transactionType((LoanTransactionType)LoanTransactionType.INTEREST_REFUND);
        return LoanTransactionData.builder().transactionType(LoanTransactionType.INTEREST_REFUND.name()).type(transactionType).date(targetTxn.getTransactionDate()).amount(interestRefundAmount).paymentTypeOptions((Collection)paymentTypeOptions).currency(loan.getCurrency().toData()).build();
    }

    public Long getResolvedLoanId(ExternalId loanExternalId) {
        loanExternalId.throwExceptionIfEmpty();
        Long resolvedLoanId = this.retrieveLoanIdByExternalId(loanExternalId);
        if (resolvedLoanId == null) {
            throw new LoanNotFoundException(loanExternalId);
        }
        return resolvedLoanId;
    }

    public Long getResolvedLoanTransactionId(Long transactionId, ExternalId externalTransactionId) {
        Long resolvedLoanTransactionId = transactionId;
        if (resolvedLoanTransactionId == null) {
            externalTransactionId.throwExceptionIfEmpty();
            resolvedLoanTransactionId = this.retrieveLoanTransactionIdByExternalId(externalTransactionId);
            if (resolvedLoanTransactionId == null) {
                throw new LoanTransactionNotFoundException(externalTransactionId);
            }
        }
        return resolvedLoanTransactionId;
    }

    private LoanTransaction deriveDefaultInterestWaiverTransaction(Loan loan) {
        Money totalInterestOutstanding = loan.getTotalInterestOutstandingOnLoan();
        Money possibleInterestToWaive = totalInterestOutstanding.copy();
        LocalDate transactionDate = DateUtils.getBusinessLocalDate();
        if (totalInterestOutstanding.isGreaterThanZero()) {
            List installments = loan.getRepaymentScheduleInstallments();
            for (LoanRepaymentScheduleInstallment scheduledRepayment : installments) {
                Money outstandingForPeriod = scheduledRepayment.getInterestOutstanding(loan.getCurrency());
                if (!scheduledRepayment.isOverdueOn(DateUtils.getBusinessLocalDate()) || !scheduledRepayment.isNotFullyPaidOff() || !outstandingForPeriod.isGreaterThanZero()) continue;
                transactionDate = scheduledRepayment.getDueDate();
                possibleInterestToWaive = outstandingForPeriod;
                break;
            }
        }
        return LoanTransaction.waiver((Office)loan.getOffice(), (Loan)loan, (Money)possibleInterestToWaive, (LocalDate)transactionDate, (Money)possibleInterestToWaive, (Money)possibleInterestToWaive.zero(), (ExternalId)ExternalId.empty());
    }

    @Generated
    public LoanReadPlatformServiceImpl(JdbcTemplate jdbcTemplate, PlatformSecurityContext context, LoanRepositoryWrapper loanRepositoryWrapper, ApplicationCurrencyRepositoryWrapper applicationCurrencyRepository, LoanProductReadPlatformService loanProductReadPlatformService, ClientReadPlatformService clientReadPlatformService, GroupReadPlatformService groupReadPlatformService, LoanDropdownReadPlatformService loanDropdownReadPlatformService, FundReadPlatformService fundReadPlatformService, ChargeReadPlatformService chargeReadPlatformService, CodeValueReadPlatformService codeValueReadPlatformService, CalendarReadPlatformService calendarReadPlatformService, StaffReadPlatformService staffReadPlatformService, PaginationHelper paginationHelper, PaymentTypeReadPlatformService paymentTypeReadPlatformService, FloatingRatesReadPlatformService floatingRatesReadPlatformService, LoanUtilService loanUtilService, ConfigurationDomainService configurationDomainService, AccountDetailsReadPlatformService accountDetailsReadPlatformService, ColumnValidator columnValidator, DatabaseSpecificSQLGenerator sqlGenerator, DelinquencyReadPlatformService delinquencyReadPlatformService, LoanTransactionRepository loanTransactionRepository, LoanChargePaidByReadService loanChargePaidByReadService, LoanTransactionRelationReadService loanTransactionRelationReadService, LoanForeclosureValidator loanForeclosureValidator, LoanTransactionMapper loanTransactionMapper, LoanTransactionProcessingService loadTransactionProcessingService, LoanBalanceService loanBalanceService, LoanCapitalizedIncomeBalanceRepository loanCapitalizedIncomeBalanceRepository, LoanBuyDownFeeBalanceRepository loanBuyDownFeeBalanceRepository, InterestRefundServiceDelegate interestRefundServiceDelegate, LoanMaximumAmountCalculator loanMaximumAmountCalculator) {
        this.jdbcTemplate = jdbcTemplate;
        this.context = context;
        this.loanRepositoryWrapper = loanRepositoryWrapper;
        this.applicationCurrencyRepository = applicationCurrencyRepository;
        this.loanProductReadPlatformService = loanProductReadPlatformService;
        this.clientReadPlatformService = clientReadPlatformService;
        this.groupReadPlatformService = groupReadPlatformService;
        this.loanDropdownReadPlatformService = loanDropdownReadPlatformService;
        this.fundReadPlatformService = fundReadPlatformService;
        this.chargeReadPlatformService = chargeReadPlatformService;
        this.codeValueReadPlatformService = codeValueReadPlatformService;
        this.calendarReadPlatformService = calendarReadPlatformService;
        this.staffReadPlatformService = staffReadPlatformService;
        this.paginationHelper = paginationHelper;
        this.paymentTypeReadPlatformService = paymentTypeReadPlatformService;
        this.floatingRatesReadPlatformService = floatingRatesReadPlatformService;
        this.loanUtilService = loanUtilService;
        this.configurationDomainService = configurationDomainService;
        this.accountDetailsReadPlatformService = accountDetailsReadPlatformService;
        this.columnValidator = columnValidator;
        this.sqlGenerator = sqlGenerator;
        this.delinquencyReadPlatformService = delinquencyReadPlatformService;
        this.loanTransactionRepository = loanTransactionRepository;
        this.loanChargePaidByReadService = loanChargePaidByReadService;
        this.loanTransactionRelationReadService = loanTransactionRelationReadService;
        this.loanForeclosureValidator = loanForeclosureValidator;
        this.loanTransactionMapper = loanTransactionMapper;
        this.loadTransactionProcessingService = loadTransactionProcessingService;
        this.loanBalanceService = loanBalanceService;
        this.loanCapitalizedIncomeBalanceRepository = loanCapitalizedIncomeBalanceRepository;
        this.loanBuyDownFeeBalanceRepository = loanBuyDownFeeBalanceRepository;
        this.interestRefundServiceDelegate = interestRefundServiceDelegate;
        this.loanMaximumAmountCalculator = loanMaximumAmountCalculator;
    }
}

