/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.meeting.domain;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.time.LocalDate;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.domain.AbstractPersistableCustom;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.portfolio.calendar.domain.Calendar;
import org.apache.fineract.portfolio.calendar.domain.CalendarEntityType;
import org.apache.fineract.portfolio.calendar.domain.CalendarInstance;
import org.apache.fineract.portfolio.calendar.exception.NotValidRecurringDateException;
import org.apache.fineract.portfolio.meeting.attendance.domain.ClientAttendance;
import org.apache.fineract.portfolio.meeting.exception.MeetingDateException;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

/*
 * Exception performing whole class analysis ignored.
 */
@Entity
@Table(name="m_meeting", uniqueConstraints={@UniqueConstraint(columnNames={"calendar_instance_id", "meeting_date"}, name="unique_calendar_instance_id_meeting_date")})
public class Meeting
extends AbstractPersistableCustom<Long>
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups {
    @ManyToOne
    @JoinColumn(name="calendar_instance_id", nullable=false)
    private CalendarInstance calendarInstance;
    @Column(name="meeting_date", nullable=false)
    private LocalDate meetingDate;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, mappedBy="meeting", orphanRemoval=true)
    private Set<ClientAttendance> clientsAttendance;
    static final long serialVersionUID = -4866928681207898948L;

    protected Meeting() {
    }

    private Meeting(CalendarInstance calendarInstance, LocalDate meetingDate) {
        this.calendarInstance = calendarInstance;
        this.meetingDate = meetingDate;
    }

    public static Meeting createNew(CalendarInstance calendarInstance, LocalDate meetingDate, Boolean isTransactionDateOnNonMeetingDate, boolean isSkipRepaymentOnFirstMonth, int numberOfDays) {
        if (!isTransactionDateOnNonMeetingDate.booleanValue() && !Meeting.isValidMeetingDate((CalendarInstance)calendarInstance, (LocalDate)meetingDate, (boolean)isSkipRepaymentOnFirstMonth, (int)numberOfDays)) {
            throw new NotValidRecurringDateException("meeting", "The date '" + String.valueOf(meetingDate) + "' is not a valid meeting date.", new Object[]{meetingDate});
        }
        return new Meeting(calendarInstance, meetingDate);
    }

    public void associateClientsAttendance(Collection<ClientAttendance> clientsAttendance) {
        if (this.isMeetingDateAfter(DateUtils.getBusinessLocalDate())) {
            String errorMessage = "Attendance cannot be in the future.";
            throw new MeetingDateException("cannot.be.a.future.date", "Attendance cannot be in the future.", new Object[]{this.getMeetingDateLocalDate()});
        }
        this._persistence_set_clientsAttendance(new HashSet<ClientAttendance>(clientsAttendance));
    }

    public Map<String, Object> update(JsonCommand command, boolean isSkipRepaymentOnFirstMonth, int numberOfDays) {
        LinkedHashMap<String, Object> actualChanges = new LinkedHashMap<String, Object>(9);
        String dateFormatAsInput = command.dateFormat();
        String localeAsInput = command.locale();
        if (command.isChangeInLocalDateParameterNamed("meetingDate", this.getMeetingDateLocalDate())) {
            actualChanges.put("meetingDate", command.stringValueOfParameterNamed("meetingDate"));
            actualChanges.put("dateFormat", dateFormatAsInput);
            actualChanges.put("locale", localeAsInput);
            this._persistence_set_meetingDate(command.localDateValueOfParameterNamed("meetingDate"));
            if (!Meeting.isValidMeetingDate((CalendarInstance)this._persistence_get_calendarInstance(), (LocalDate)this._persistence_get_meetingDate(), (boolean)isSkipRepaymentOnFirstMonth, (int)numberOfDays)) {
                throw new NotValidRecurringDateException("meeting", "Not a valid meeting date", new Object[]{this._persistence_get_meetingDate()});
            }
        }
        return actualChanges;
    }

    public Map<String, Object> updateAttendance(Collection<ClientAttendance> clientsAttendance) {
        LinkedHashMap<String, Object> actualChanges = new LinkedHashMap<String, Object>(1);
        LinkedHashMap clientAttendanceChanges = new LinkedHashMap(clientsAttendance.size());
        block0: for (ClientAttendance clientAttendance : clientsAttendance) {
            if (this._persistence_get_clientsAttendance() == null) {
                this._persistence_set_clientsAttendance(new HashSet());
            }
            for (ClientAttendance clientAttendanceOriginal : this._persistence_get_clientsAttendance()) {
                if (!clientAttendanceOriginal.clientId().equals(clientAttendance.clientId())) continue;
                Integer newValue = clientAttendance.getAttendanceTypeId();
                if (newValue.equals(clientAttendanceOriginal.getAttendanceTypeId())) continue block0;
                clientAttendanceOriginal.updateAttendanceTypeId(newValue);
                LinkedHashMap<String, Number> clientAttendanceChange = new LinkedHashMap<String, Number>(2);
                clientAttendanceChange.put("clientId", clientAttendanceOriginal.clientId());
                clientAttendanceChange.put("attendanceType", newValue);
                clientAttendanceChanges.put(clientAttendanceOriginal.clientId().toString(), clientAttendanceChange);
                continue block0;
            }
            LinkedHashMap<String, Number> clientAttendanceChange = new LinkedHashMap<String, Number>();
            clientAttendanceChange.put("clientId", clientAttendance.clientId());
            clientAttendanceChange.put("attendanceType", clientAttendance.getAttendanceTypeId());
            clientAttendanceChanges.put(clientAttendance.clientId().toString(), clientAttendanceChange);
            this._persistence_get_clientsAttendance().add(clientAttendance);
        }
        actualChanges.put("clientsAttendance", clientAttendanceChanges);
        return actualChanges;
    }

    public Long entityId() {
        return this._persistence_get_calendarInstance().getEntityId();
    }

    public boolean isCenterEntity() {
        return CalendarEntityType.isCenter((Integer)this._persistence_get_calendarInstance().getEntityTypeId());
    }

    public boolean isGroupEntity() {
        return CalendarEntityType.isGroup((Integer)this._persistence_get_calendarInstance().getEntityTypeId());
    }

    public LocalDate getMeetingDateLocalDate() {
        return this._persistence_get_meetingDate();
    }

    public LocalDate getMeetingDate() {
        return this._persistence_get_meetingDate();
    }

    public boolean isMeetingDateBefore(LocalDate newStartDate) {
        return this._persistence_get_meetingDate() != null && DateUtils.isBefore((LocalDate)this.getMeetingDateLocalDate(), (LocalDate)newStartDate);
    }

    private static boolean isValidMeetingDate(CalendarInstance calendarInstance, LocalDate meetingDate, boolean isSkipRepaymentOnFirstMonth, int numberOfDays) {
        Calendar calendar = calendarInstance.getCalendar();
        return meetingDate != null && calendar.isValidRecurringDate(meetingDate, Boolean.valueOf(isSkipRepaymentOnFirstMonth), Integer.valueOf(numberOfDays));
    }

    private boolean isMeetingDateAfter(LocalDate date) {
        return DateUtils.isAfter((LocalDate)this.getMeetingDateLocalDate(), (LocalDate)date);
    }

    public Collection<ClientAttendance> getClientsAttendance() {
        return this._persistence_get_clientsAttendance();
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new Meeting(persistenceObject);
    }

    public Meeting(PersistenceObject persistenceObject) {
        super(persistenceObject);
    }

    public Object _persistence_get(String string) {
        if (string == "calendarInstance") {
            return this.calendarInstance;
        }
        if (string == "meetingDate") {
            return this.meetingDate;
        }
        if (string == "clientsAttendance") {
            return this.clientsAttendance;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "calendarInstance") {
            this.calendarInstance = (CalendarInstance)object;
            return;
        }
        if (string == "meetingDate") {
            this.meetingDate = (LocalDate)object;
            return;
        }
        if (string == "clientsAttendance") {
            this.clientsAttendance = (Set)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public CalendarInstance _persistence_get_calendarInstance() {
        this._persistence_checkFetched("calendarInstance");
        return this.calendarInstance;
    }

    public void _persistence_set_calendarInstance(CalendarInstance calendarInstance) {
        this._persistence_checkFetchedForSet("calendarInstance");
        this.calendarInstance = calendarInstance;
    }

    public LocalDate _persistence_get_meetingDate() {
        this._persistence_checkFetched("meetingDate");
        return this.meetingDate;
    }

    public void _persistence_set_meetingDate(LocalDate localDate) {
        this._persistence_checkFetchedForSet("meetingDate");
        this.meetingDate = localDate;
    }

    public Set _persistence_get_clientsAttendance() {
        this._persistence_checkFetched("clientsAttendance");
        return this.clientsAttendance;
    }

    public void _persistence_set_clientsAttendance(Set set) {
        this._persistence_checkFetchedForSet("clientsAttendance");
        this.clientsAttendance = set;
    }
}

