/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.savings.api;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountRepository;
import org.apache.fineract.portfolio.savings.service.SavingsAccountWritePlatformService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Profile(value={"test"})
@Component
@Path(value="/v1/internal/savingsaccounts")
public class InternalSavingsAccountInformationApiResource
implements InitializingBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InternalSavingsAccountInformationApiResource.class);
    private final SavingsAccountRepository repository;
    private final SavingsAccountWritePlatformService writePlatformService;

    @SuppressFBWarnings(value={"SLF4J_SIGN_ONLY_FORMAT"})
    public void afterPropertiesSet() {
        log.warn("------------------------------------------------------------");
        log.warn("                                                            ");
        log.warn("DO NOT USE THIS IN PRODUCTION!");
        log.warn("Internal savings account services mode is enabled");
        log.warn("DO NOT USE THIS IN PRODUCTION!");
        log.warn("                                                            ");
        log.warn("------------------------------------------------------------");
    }

    @GET
    @Path(value="status/{statusId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @SuppressFBWarnings(value={"SLF4J_SIGN_ONLY_FORMAT"})
    public List<Long> getSavingsAccountsByStatus(@Context UriInfo uriInfo, @PathParam(value="statusId") Integer statusId) {
        log.warn("------------------------------------------------------------");
        log.warn("                                                            ");
        log.warn("Fetching loans by status {}", (Object)statusId);
        log.warn("                                                            ");
        log.warn("------------------------------------------------------------");
        return this.repository.findSavingsAccountIdsByStatusId(statusId);
    }

    @Generated
    public InternalSavingsAccountInformationApiResource(SavingsAccountRepository repository, SavingsAccountWritePlatformService writePlatformService) {
        this.repository = repository;
        this.writePlatformService = writePlatformService;
    }
}

