/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.savings.service;

import com.google.gson.JsonElement;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.HashMap;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.api.JsonQuery;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.organisation.monetary.domain.MoneyHelper;
import org.apache.fineract.portfolio.savings.data.DepositAccountDataValidator;
import org.apache.fineract.portfolio.savings.service.FixedDepositAccountInterestCalculationService;
import org.springframework.stereotype.Service;

@Service
public class FixedDepositAccountInterestCalculationServiceImpl
implements FixedDepositAccountInterestCalculationService {
    private final DepositAccountDataValidator depositAccountDataValidator;
    private final FromJsonHelper fromApiJsonHelper;

    public HashMap calculateInterest(JsonQuery query) {
        this.depositAccountDataValidator.validateFixedDepositForInterestCalculation(query.json());
        JsonElement element = query.parsedJson();
        BigDecimal principalAmount = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("principalAmount", element);
        BigDecimal annualInterestRate = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("annualInterestRate", element);
        Long tenureInMonths = this.fromApiJsonHelper.extractLongNamed("tenureInMonths", element);
        Long interestCompoundingPeriodInMonths = this.fromApiJsonHelper.extractLongNamed("interestCompoundingPeriodInMonths", element);
        BigDecimal maturityAmount = this.calculateInterestInternal(principalAmount, annualInterestRate, tenureInMonths, interestCompoundingPeriodInMonths);
        String warning = "This is an approximate calculated amount - it may vary slightly when the account is created";
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("maturityAmount", maturityAmount);
        result.put("warning", warning);
        return result;
    }

    public BigDecimal calculateInterestInternal(BigDecimal principalAmount, BigDecimal annualInterestRate, Long tenureInMonths, Long interestCompoundingPeriodInMonths) {
        BigDecimal numberOfCompoundingsPerAnnum = BigDecimal.valueOf(12L).divide(BigDecimal.valueOf(interestCompoundingPeriodInMonths));
        Long totalNumberOfCompoundings = tenureInMonths / interestCompoundingPeriodInMonths;
        MathContext mc = MoneyHelper.getMathContext();
        BigDecimal exponentialTerm = annualInterestRate.divide(numberOfCompoundingsPerAnnum, mc).divide(BigDecimal.valueOf(100L), mc).add(BigDecimal.valueOf(1L)).pow(Math.toIntExact(totalNumberOfCompoundings));
        return principalAmount.multiply(exponentialTerm);
    }

    @Generated
    public FixedDepositAccountInterestCalculationServiceImpl(DepositAccountDataValidator depositAccountDataValidator, FromJsonHelper fromApiJsonHelper) {
        this.depositAccountDataValidator = depositAccountDataValidator;
        this.fromApiJsonHelper = fromApiJsonHelper;
    }
}

