/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.savings.service;

import java.util.Collection;
import lombok.Generated;
import org.apache.fineract.infrastructure.entityaccess.domain.FineractEntityType;
import org.apache.fineract.infrastructure.entityaccess.service.FineractEntityAccessUtil;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.savings.DepositAccountType;
import org.apache.fineract.portfolio.savings.data.SavingsProductData;
import org.apache.fineract.portfolio.savings.exception.SavingsProductNotFoundException;
import org.apache.fineract.portfolio.savings.service.SavingsProductReadPlatformService;
import org.apache.fineract.portfolio.savings.service.SavingsProductReadPlatformServiceImpl;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class SavingsProductReadPlatformServiceImpl
implements SavingsProductReadPlatformService {
    private final PlatformSecurityContext context;
    private final JdbcTemplate jdbcTemplate;
    private final SavingProductMapper savingsProductRowMapper = new SavingProductMapper();
    private final SavingProductLookupMapper savingsProductLookupsRowMapper = new SavingProductLookupMapper();
    private final FineractEntityAccessUtil fineractEntityAccessUtil;

    public Collection<SavingsProductData> retrieveAll() {
        this.context.authenticatedUser();
        String sql = "select " + this.savingsProductRowMapper.schema() + "where sp.deposit_type_enum = ?";
        String inClause = this.fineractEntityAccessUtil.getSQLWhereClauseForProductIDsForUserOffice_ifGlobalConfigEnabled(FineractEntityType.SAVINGS_PRODUCT);
        if (inClause != null && !inClause.trim().isEmpty()) {
            sql = sql + " and sp.id in ( " + inClause + " ) ";
        }
        return this.jdbcTemplate.query(sql, (RowMapper)this.savingsProductRowMapper, new Object[]{DepositAccountType.SAVINGS_DEPOSIT.getValue()});
    }

    public Collection<SavingsProductData> retrieveAllForLookup() {
        String sql = "select " + this.savingsProductLookupsRowMapper.schema() + " where sp.deposit_type_enum = ? ";
        String inClause = this.fineractEntityAccessUtil.getSQLWhereClauseForProductIDsForUserOffice_ifGlobalConfigEnabled(FineractEntityType.SAVINGS_PRODUCT);
        if (inClause != null && !inClause.trim().isEmpty()) {
            sql = sql + " and id in ( " + inClause + " ) ";
        }
        return this.jdbcTemplate.query(sql, (RowMapper)this.savingsProductLookupsRowMapper, new Object[]{DepositAccountType.SAVINGS_DEPOSIT.getValue()});
    }

    public SavingsProductData retrieveOne(Long savingProductId) {
        try {
            this.context.authenticatedUser();
            String sql = "select " + this.savingsProductRowMapper.schema() + " where sp.id = ? and sp.deposit_type_enum = ?";
            return (SavingsProductData)this.jdbcTemplate.queryForObject(sql, (RowMapper)this.savingsProductRowMapper, new Object[]{savingProductId, DepositAccountType.SAVINGS_DEPOSIT.getValue()});
        }
        catch (EmptyResultDataAccessException e) {
            throw new SavingsProductNotFoundException(savingProductId, e);
        }
    }

    public Collection<SavingsProductData> retrieveAllForLookupByType(Boolean isOverdraftType) {
        String sql = "select " + this.savingsProductLookupsRowMapper.schema();
        boolean inClauseAdded = false;
        String inClause = this.fineractEntityAccessUtil.getSQLWhereClauseForProductIDsForUserOffice_ifGlobalConfigEnabled(FineractEntityType.SAVINGS_PRODUCT);
        if (inClause != null && !inClause.trim().isEmpty()) {
            sql = sql + " where id in ( " + inClause + " ) ";
            inClauseAdded = true;
        }
        if (isOverdraftType != null) {
            sql = inClauseAdded ? sql + " and sp.allow_overdraft=? and sp.deposit_type_enum = ?" : sql + " where sp.allow_overdraft=? and sp.deposit_type_enum = ?";
            return this.jdbcTemplate.query(sql, (RowMapper)this.savingsProductLookupsRowMapper, new Object[]{isOverdraftType, DepositAccountType.SAVINGS_DEPOSIT.getValue()});
        }
        sql = inClauseAdded ? sql + " and sp.deposit_type_enum = ?" : sql + " where sp.deposit_type_enum = ?";
        return this.jdbcTemplate.query(sql, (RowMapper)this.savingsProductLookupsRowMapper, new Object[]{DepositAccountType.SAVINGS_DEPOSIT.getValue()});
    }

    public Collection<SavingsProductData> retrieveAllForCurrency(String currencyCode) {
        this.context.authenticatedUser();
        String sql = "select " + this.savingsProductRowMapper.schema() + " where sp.currency_code= ? ";
        String inClause = this.fineractEntityAccessUtil.getSQLWhereClauseForProductIDsForUserOffice_ifGlobalConfigEnabled(FineractEntityType.SAVINGS_PRODUCT);
        if (inClause != null && !inClause.trim().isEmpty()) {
            sql = sql + " and id in ( " + inClause + " ) ";
        }
        return this.jdbcTemplate.query(sql, (RowMapper)this.savingsProductRowMapper, new Object[]{currencyCode});
    }

    @Generated
    public SavingsProductReadPlatformServiceImpl(PlatformSecurityContext context, JdbcTemplate jdbcTemplate, FineractEntityAccessUtil fineractEntityAccessUtil) {
        this.context = context;
        this.jdbcTemplate = jdbcTemplate;
        this.fineractEntityAccessUtil = fineractEntityAccessUtil;
    }
}

