/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.spm.service;

import java.util.List;
import lombok.Generated;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.client.domain.Client;
import org.apache.fineract.spm.domain.Scorecard;
import org.apache.fineract.spm.domain.ScorecardRepository;
import org.apache.fineract.spm.domain.Survey;

public class ScorecardService {
    private final PlatformSecurityContext securityContext;
    private final ScorecardRepository scorecardRepository;

    public List<Scorecard> createScorecard(List<Scorecard> scorecards) {
        this.securityContext.authenticatedUser();
        return this.scorecardRepository.saveAll(scorecards);
    }

    public List<Scorecard> findBySurvey(Survey survey) {
        this.securityContext.authenticatedUser();
        return this.scorecardRepository.findBySurvey(survey);
    }

    public List<Scorecard> findBySurveyAndClient(Survey survey, Client client) {
        this.securityContext.authenticatedUser();
        return this.scorecardRepository.findBySurveyAndClient(survey, client);
    }

    @Generated
    public ScorecardService(PlatformSecurityContext securityContext, ScorecardRepository scorecardRepository) {
        this.securityContext = securityContext;
        this.scorecardRepository = scorecardRepository;
    }
}

