/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.agents.api.logger;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.agents.api.EventFilter;

public final class EventLoggerConfig {
    private final String loggerType;
    private final EventFilter eventFilter;
    private final Map<String, Object> properties;

    private EventLoggerConfig(String loggerType, EventFilter eventFilter, Map<String, Object> properties) {
        this.loggerType = Objects.requireNonNull(loggerType, "Logger type cannot be null");
        this.eventFilter = eventFilter == null ? EventFilter.ACCEPT_ALL : eventFilter;
        this.properties = Collections.unmodifiableMap(new HashMap<String, Object>(properties));
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getLoggerType() {
        return this.loggerType;
    }

    public EventFilter getEventFilter() {
        return this.eventFilter;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventLoggerConfig that = (EventLoggerConfig)o;
        return Objects.equals(this.loggerType, that.loggerType) && Objects.equals(this.eventFilter, that.eventFilter) && Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        return Objects.hash(this.loggerType, this.eventFilter, this.properties);
    }

    public String toString() {
        return "EventLoggerConfig{loggerType='" + this.loggerType + "', eventFilter=" + String.valueOf(this.eventFilter) + ", properties=" + String.valueOf(this.properties) + "}";
    }

    public static final class Builder {
        private String loggerType = "file";
        private EventFilter eventFilter = EventFilter.ACCEPT_ALL;
        private final Map<String, Object> properties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder loggerType(String loggerType) {
            if (loggerType == null || loggerType.trim().isEmpty()) {
                throw new IllegalArgumentException("Logger type cannot be null or empty");
            }
            this.loggerType = loggerType.trim();
            return this;
        }

        public Builder eventFilter(EventFilter eventFilter) {
            this.eventFilter = Objects.requireNonNull(eventFilter, "Event filter cannot be null");
            return this;
        }

        public Builder property(String key, Object value) {
            if (key == null || key.trim().isEmpty()) {
                throw new IllegalArgumentException("Property key cannot be null or empty");
            }
            Objects.requireNonNull(value, "Property value cannot be null");
            this.properties.put(key.trim(), value);
            return this;
        }

        public Builder properties(Map<String, Object> properties) {
            Objects.requireNonNull(properties, "Properties map cannot be null");
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                this.property(entry.getKey(), entry.getValue());
            }
            return this;
        }

        public EventLoggerConfig build() {
            return new EventLoggerConfig(this.loggerType, this.eventFilter, this.properties);
        }
    }
}

